% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_spot_fleet_instances}
\alias{ec2_describe_spot_fleet_instances}
\title{Describes the running instances for the specified Spot Fleet}
\usage{
ec2_describe_spot_fleet_instances(
  DryRun = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  SpotFleetRequestId
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{MaxResults}{The maximum number of results to return in a single call. Specify a
value between 1 and 1000. The default value is 1000. To retrieve the
remaining results, make another call with the returned \code{NextToken}
value.}

\item{NextToken}{The token for the next set of results.}

\item{SpotFleetRequestId}{[required] The ID of the Spot Fleet request.}
}
\description{
Describes the running instances for the specified Spot Fleet.

See \url{https://paws-r.github.io/docs/ec2/describe_spot_fleet_instances.html} for full documentation.
}
\keyword{internal}
