% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_principal_id_format}
\alias{ec2_describe_principal_id_format}
\title{Describes the ID format settings for the root user and all IAM roles and
IAM users that have explicitly specified a longer ID (17-character ID)
preference}
\usage{
ec2_describe_principal_id_format(
  DryRun = NULL,
  Resources = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Resources}{The type of resource: \code{bundle} | \code{conversion-task} | \code{customer-gateway}
| \code{dhcp-options} | \code{elastic-ip-allocation} | \code{elastic-ip-association} |
\code{export-task} | \code{flow-log} | \code{image} | \code{import-task} | \code{instance} |
\code{internet-gateway} | \code{network-acl} | \code{network-acl-association} |
\code{network-interface} | \code{network-interface-attachment} | \code{prefix-list} |
\code{reservation} | \code{route-table} | \code{route-table-association} |
\code{security-group} | \code{snapshot} | \code{subnet} |
\code{subnet-cidr-block-association} | \code{volume} | \code{vpc} |
\code{vpc-cidr-block-association} | \code{vpc-endpoint} | \code{vpc-peering-connection}
| \code{vpn-connection} | \code{vpn-gateway}}

\item{MaxResults}{The maximum number of results to return in a single call. To retrieve
the remaining results, make another call with the returned NextToken
value.}

\item{NextToken}{The token to request the next page of results.}
}
\description{
Describes the ID format settings for the root user and all IAM roles and IAM users that have explicitly specified a longer ID (17-character ID) preference.

See \url{https://paws-r.github.io/docs/ec2/describe_principal_id_format.html} for full documentation.
}
\keyword{internal}
