% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_local_gateway_route_tables}
\alias{ec2_describe_local_gateway_route_tables}
\title{Describes one or more local gateway route tables}
\usage{
ec2_describe_local_gateway_route_tables(
  LocalGatewayRouteTableIds = NULL,
  Filters = NULL,
  MaxResults = NULL,
  NextToken = NULL,
  DryRun = NULL
)
}
\arguments{
\item{LocalGatewayRouteTableIds}{The IDs of the local gateway route tables.}

\item{Filters}{One or more filters.
\itemize{
\item \code{local-gateway-id} - The ID of a local gateway.
\item \code{local-gateway-route-table-arn} - The Amazon Resource Name (ARN) of
the local gateway route table.
\item \code{local-gateway-route-table-id} - The ID of a local gateway route
table.
\item \code{outpost-arn} - The Amazon Resource Name (ARN) of the Outpost.
\item \code{owner-id} - The ID of the Amazon Web Services account that owns the
local gateway route table.
\item \code{state} - The state of the local gateway route table.
}}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{NextToken}{The token for the next page of results.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes one or more local gateway route tables. By default, all local gateway route tables are described. Alternatively, you can filter the results.

See \url{https://paws-r.github.io/docs/ec2/describe_local_gateway_route_tables.html} for full documentation.
}
\keyword{internal}
