% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_addresses_attribute}
\alias{ec2_describe_addresses_attribute}
\title{Describes the attributes of the specified Elastic IP addresses}
\usage{
ec2_describe_addresses_attribute(
  AllocationIds = NULL,
  Attribute = NULL,
  NextToken = NULL,
  MaxResults = NULL,
  DryRun = NULL
)
}
\arguments{
\item{AllocationIds}{[EC2-VPC] The allocation IDs.}

\item{Attribute}{The attribute of the IP address.}

\item{NextToken}{The token for the next page of results.}

\item{MaxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes the attributes of the specified Elastic IP addresses. For requirements, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html#Using_Elastic_Addressing_Reverse_DNS}{Using reverse DNS for email applications}.

See \url{https://paws-r.github.io/docs/ec2/describe_addresses_attribute.html} for full documentation.
}
\keyword{internal}
