% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_launch_template_versions}
\alias{ec2_delete_launch_template_versions}
\title{Deletes one or more versions of a launch template}
\usage{
ec2_delete_launch_template_versions(
  DryRun = NULL,
  LaunchTemplateId = NULL,
  LaunchTemplateName = NULL,
  Versions
)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{LaunchTemplateId}{The ID of the launch template.

You must specify either the \code{LaunchTemplateId} or the
\code{LaunchTemplateName}, but not both.}

\item{LaunchTemplateName}{The name of the launch template.

You must specify either the \code{LaunchTemplateName} or the
\code{LaunchTemplateId}, but not both.}

\item{Versions}{[required] The version numbers of one or more launch template versions to delete.}
}
\description{
Deletes one or more versions of a launch template. You cannot delete the default version of a launch template; you must first assign a different version as the default. If the default version is the only version for the launch template, you must delete the entire launch template using \code{\link[=ec2_delete_launch_template]{delete_launch_template}}.

See \url{https://paws-r.github.io/docs/ec2/delete_launch_template_versions.html} for full documentation.
}
\keyword{internal}
