% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_ipam}
\alias{ec2_delete_ipam}
\title{Delete an IPAM}
\usage{
ec2_delete_ipam(DryRun = NULL, IpamId, Cascade = NULL)
}
\arguments{
\item{DryRun}{A check for whether you have the required permissions for the action
without actually making the request and provides an error response. If
you have the required permissions, the error response is
\code{DryRunOperation}. Otherwise, it is \code{UnauthorizedOperation}.}

\item{IpamId}{[required] The ID of the IPAM to delete.}

\item{Cascade}{Enables you to quickly delete an IPAM, private scopes, pools in private
scopes, and any allocations in the pools in private scopes. You cannot
delete the IPAM with this option if there is a pool in your public
scope. If you use this option, IPAM does the following:
\itemize{
\item Deallocates any CIDRs allocated to VPC resources (such as VPCs) in
pools in private scopes.

No VPC resources are deleted as a result of enabling this option.
The CIDR associated with the resource will no longer be allocated
from an IPAM pool, but the CIDR itself will remain unchanged.
\item Deprovisions all IPv4 CIDRs provisioned to IPAM pools in private
scopes.
\item Deletes all IPAM pools in private scopes.
\item Deletes all non-default private scopes in the IPAM.
\item Deletes the default public and private scopes and the IPAM.
}}
}
\description{
Delete an IPAM. Deleting an IPAM removes all monitored data associated with the IPAM including the historical data for CIDRs.

See \url{https://paws-r.github.io/docs/ec2/delete_ipam.html} for full documentation.
}
\keyword{internal}
