% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_nat_gateway}
\alias{ec2_create_nat_gateway}
\title{Creates a NAT gateway in the specified subnet}
\usage{
ec2_create_nat_gateway(
  AllocationId = NULL,
  ClientToken = NULL,
  DryRun = NULL,
  SubnetId,
  TagSpecifications = NULL,
  ConnectivityType = NULL
)
}
\arguments{
\item{AllocationId}{[Public NAT gateways only] The allocation ID of an Elastic IP address
to associate with the NAT gateway. You cannot specify an Elastic IP
address with a private NAT gateway. If the Elastic IP address is
associated with another resource, you must first disassociate it.}

\item{ClientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html}{How to ensure idempotency}.

Constraint: Maximum 64 ASCII characters.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{SubnetId}{[required] The subnet in which to create the NAT gateway.}

\item{TagSpecifications}{The tags to assign to the NAT gateway.}

\item{ConnectivityType}{Indicates whether the NAT gateway supports public or private
connectivity. The default is public connectivity.}
}
\description{
Creates a NAT gateway in the specified subnet. This action creates a network interface in the specified subnet with a private IP address from the IP address range of the subnet. You can create either a public NAT gateway or a private NAT gateway.

See \url{https://paws-r.github.io/docs/ec2/create_nat_gateway.html} for full documentation.
}
\keyword{internal}
