% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_tag_resource}
\alias{lambda_tag_resource}
\title{Adds tags to a function}
\usage{
lambda_tag_resource(Resource, Tags)
}
\arguments{
\item{Resource}{[required] The function\'s Amazon Resource Name (ARN).}

\item{Tags}{[required] A list of tags to apply to the function.}
}
\description{
Adds \href{https://docs.aws.amazon.com/lambda/latest/dg/tagging.html}{tags}
to a function.
}
\section{Request syntax}{
\preformatted{svc$tag_resource(
  Resource = "string",
  Tags = list(
    "string"
  )
)
}
}

\examples{
\dontrun{
# The following example adds a tag with the key name DEPARTMENT and a
# value of 'Department A' to the specified Lambda function.
svc$tag_resource(
  Resource = "arn:aws:lambda:us-west-2:123456789012:function:my-function",
  Tags = list(
    DEPARTMENT = "Department A"
  )
)
}

}
\keyword{internal}
