% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_volumes_modifications}
\alias{ec2_describe_volumes_modifications}
\title{Describes the most recent volume modification request for the specified
EBS volumes}
\usage{
ec2_describe_volumes_modifications(DryRun, VolumeIds, Filters,
  NextToken, MaxResults)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VolumeIds}{The IDs of the volumes.}

\item{Filters}{The filters.
\itemize{
\item \code{modification-state} - The current modification state (modifying \\|
optimizing \\| completed \\| failed).
\item \code{original-iops} - The original IOPS rate of the volume.
\item \code{original-size} - The original size of the volume, in GiB.
\item \code{original-volume-type} - The original volume type of the volume
(standard \\| io1 \\| gp2 \\| sc1 \\| st1).
\item \code{originalMultiAttachEnabled} - Indicates whether Multi-Attach
support was enabled (true \\| false).
\item \code{start-time} - The modification start time.
\item \code{target-iops} - The target IOPS rate of the volume.
\item \code{target-size} - The target size of the volume, in GiB.
\item \code{target-volume-type} - The target volume type of the volume
(standard \\| io1 \\| gp2 \\| sc1 \\| st1).
\item \code{targetMultiAttachEnabled} - Indicates whether Multi-Attach support
is to be enabled (true \\| false).
\item \code{volume-id} - The ID of the volume.
}}

\item{NextToken}{The \code{nextToken} value returned by a previous paginated request.}

\item{MaxResults}{The maximum number of results (up to a limit of 500) to be returned in a
paginated request.}
}
\description{
Describes the most recent volume modification request for the specified
EBS volumes.
}
\details{
If a volume has never been modified, some information in the output will
be null. If a volume has been modified more than once, the output
includes only the most recent modification request.

You can also use CloudWatch Events to check the status of a modification
to an EBS volume. For information about CloudWatch Events, see the
\href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/}{Amazon CloudWatch Events User Guide}. For
more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#monitoring_mods}{Monitoring Volume Modifications}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_volumes_modifications(
  DryRun = TRUE|FALSE,
  VolumeIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
