% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_transit_gateway_route_table}
\alias{ec2_delete_transit_gateway_route_table}
\title{Deletes the specified transit gateway route table}
\usage{
ec2_delete_transit_gateway_route_table(TransitGatewayRouteTableId,
  DryRun)
}
\arguments{
\item{TransitGatewayRouteTableId}{[required] The ID of the transit gateway route table.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Deletes the specified transit gateway route table. You must disassociate
the route table from any transit gateway route tables before you can
delete it.
}
\section{Request syntax}{
\preformatted{svc$delete_transit_gateway_route_table(
  TransitGatewayRouteTableId = "string",
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
