% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_transit_gateway_multicast_domain}
\alias{ec2_create_transit_gateway_multicast_domain}
\title{Creates a multicast domain using the specified transit gateway}
\usage{
ec2_create_transit_gateway_multicast_domain(TransitGatewayId,
  TagSpecifications, DryRun)
}
\arguments{
\item{TransitGatewayId}{[required] The ID of the transit gateway.}

\item{TagSpecifications}{The tags for the transit gateway multicast domain.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Creates a multicast domain using the specified transit gateway.
}
\details{
The transit gateway must be in the available state before you create a
domain. Use
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html}{DescribeTransitGateways}
to see the state of transit gateway.
}
\section{Request syntax}{
\preformatted{svc$create_transit_gateway_multicast_domain(
  TransitGatewayId = "string",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
