% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_account_attributes}
\alias{ec2_describe_account_attributes}
\title{Describes attributes of your AWS account}
\usage{
ec2_describe_account_attributes(AttributeNames, DryRun)
}
\arguments{
\item{AttributeNames}{The account attribute names.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes attributes of your AWS account. The following are the
supported account attributes:
}
\details{
\itemize{
\item \code{supported-platforms}: Indicates whether your account can launch
instances into EC2-Classic and EC2-VPC, or only into EC2-VPC.
\item \code{default-vpc}: The ID of the default VPC for your account, or
\code{none}.
\item \code{max-instances}: This attribute is no longer supported. The returned
value does not reflect your actual vCPU limit for running On-Demand
Instances. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits}{On-Demand Instance Limits}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
\item \code{vpc-max-security-groups-per-interface}: The maximum number of
security groups that you can assign to a network interface.
\item \code{max-elastic-ips}: The maximum number of Elastic IP addresses that
you can allocate for use with EC2-Classic.
\item \code{vpc-max-elastic-ips}: The maximum number of Elastic IP addresses
that you can allocate for use with EC2-VPC.
}
}
\section{Request syntax}{
\preformatted{svc$describe_account_attributes(
  AttributeNames = list(
    "supported-platforms"|"default-vpc"
  ),
  DryRun = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example describes the supported-platforms attribute for your AWS
# account.
svc$describe_account_attributes(
  AttributeNames = list(
    "supported-platforms"
  )
)

# This example describes the attributes for your AWS account.
svc$describe_account_attributes()
}

}
\keyword{internal}
