% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_allocate_address}
\alias{ec2_allocate_address}
\title{Allocates an Elastic IP address to your AWS account}
\usage{
ec2_allocate_address(Domain, Address, PublicIpv4Pool,
  NetworkBorderGroup, CustomerOwnedIpv4Pool, DryRun)
}
\arguments{
\item{Domain}{Set to \code{vpc} to allocate the address for use with instances in a VPC.

Default: The address is for use with instances in EC2-Classic.}

\item{Address}{[EC2-VPC] The Elastic IP address to recover or an IPv4 address from an
address pool.}

\item{PublicIpv4Pool}{The ID of an address pool that you own. Use this parameter to let Amazon
EC2 select an address from the address pool. To specify a specific
address from the address pool, use the \code{Address} parameter instead.}

\item{NetworkBorderGroup}{The location from which the IP address is advertised. Use this parameter
to limit the address to this location.

Use
\href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html}{DescribeVpcs}
to view the network border groups.

You cannot use a network border group with EC2 Classic. If you attempt
this operation on EC2 classic, you will receive an
\code{InvalidParameterCombination} error. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html}{Error Codes}.}

\item{CustomerOwnedIpv4Pool}{The ID of a customer-owned address pool. Use this parameter to let
Amazon EC2 select an address from the address pool. Alternatively,
specify a specific address from the address pool.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Allocates an Elastic IP address to your AWS account. After you allocate
the Elastic IP address you can associate it with an instance or network
interface. After you release an Elastic IP address, it is released to
the IP address pool and can be allocated to a different AWS account.
}
\details{
You can allocate an Elastic IP address from an address pool owned by AWS
or from an address pool created from a public IPv4 address range that
you have brought to AWS for use with your AWS resources using bring your
own IP addresses (BYOIP). For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html}{Bring Your Own IP Addresses (BYOIP)}
in the \emph{Amazon Elastic Compute Cloud User Guide}.

[EC2-VPC] If you release an Elastic IP address, you might be able to
recover it. You cannot recover an Elastic IP address that you released
after it is allocated to another AWS account. You cannot recover an
Elastic IP address for EC2-Classic. To attempt to recover an Elastic IP
address that you released, specify it in this operation.

An Elastic IP address is for use either in the EC2-Classic platform or
in a VPC. By default, you can allocate 5 Elastic IP addresses for
EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per
Region.

For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html}{Elastic IP Addresses}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$allocate_address(
  Domain = "vpc"|"standard",
  Address = "string",
  PublicIpv4Pool = "string",
  NetworkBorderGroup = "string",
  CustomerOwnedIpv4Pool = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
\dontrun{
# This example allocates an Elastic IP address to use with an instance in
# a VPC.
svc$allocate_address(
  Domain = "vpc"
)

# This example allocates an Elastic IP address to use with an instance in
# EC2-Classic.
svc$allocate_address()
}

}
\keyword{internal}
