% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_delete_security_group}
\alias{ec2_delete_security_group}
\title{Deletes a security group}
\usage{
ec2_delete_security_group(GroupId, GroupName, DryRun)
}
\arguments{
\item{GroupId}{The ID of the security group. Required for a nondefault VPC.}

\item{GroupName}{[EC2-Classic, default VPC] The name of the security group. You can
specify either the security group name or the security group ID.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Deletes a security group.
}
\details{
If you attempt to delete a security group that is associated with an
instance, or is referenced by another security group, the operation
fails with \code{InvalidGroup.InUse} in EC2-Classic or \code{DependencyViolation}
in EC2-VPC.
}
\section{Request syntax}{
\preformatted{svc$delete_security_group(
  GroupId = "string",
  GroupName = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example deletes the specified security group.
\dontrun{svc$delete_security_group(
  GroupId = "sg-903004f8"
)}

}
\keyword{internal}
