# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ec2_service.R
NULL

#' Accepts the Convertible Reserved Instance exchange quote described in
#' the GetReservedInstancesExchangeQuote call
#'
#' Accepts the Convertible Reserved Instance exchange quote described in
#' the GetReservedInstancesExchangeQuote call.
#'
#' @usage
#' ec2_accept_reserved_instances_exchange_quote(DryRun,
#'   ReservedInstanceIds, TargetConfigurations)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ReservedInstanceIds &#91;required&#93; The IDs of the Convertible Reserved Instances to exchange for another
#' Convertible Reserved Instance of the same or higher value.
#' @param TargetConfigurations The configuration of the target Convertible Reserved Instance to
#' exchange for your current Convertible Reserved Instances.
#'
#' @section Request syntax:
#' ```
#' svc$accept_reserved_instances_exchange_quote(
#'   DryRun = TRUE|FALSE,
#'   ReservedInstanceIds = list(
#'     "string"
#'   ),
#'   TargetConfigurations = list(
#'     list(
#'       InstanceCount = 123,
#'       OfferingId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_accept_reserved_instances_exchange_quote
ec2_accept_reserved_instances_exchange_quote <- function(DryRun = NULL, ReservedInstanceIds, TargetConfigurations = NULL) {
  op <- new_operation(
    name = "AcceptReservedInstancesExchangeQuote",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$accept_reserved_instances_exchange_quote_input(DryRun = DryRun, ReservedInstanceIds = ReservedInstanceIds, TargetConfigurations = TargetConfigurations)
  output <- .ec2$accept_reserved_instances_exchange_quote_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_reserved_instances_exchange_quote <- ec2_accept_reserved_instances_exchange_quote

#' Accepts a transit gateway peering attachment request
#'
#' Accepts a transit gateway peering attachment request. The peering
#' attachment must be in the `pendingAcceptance` state.
#'
#' @usage
#' ec2_accept_transit_gateway_peering_attachment(
#'   TransitGatewayAttachmentId, DryRun)
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the transit gateway attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$accept_transit_gateway_peering_attachment(
#'   TransitGatewayAttachmentId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_accept_transit_gateway_peering_attachment
ec2_accept_transit_gateway_peering_attachment <- function(TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "AcceptTransitGatewayPeeringAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$accept_transit_gateway_peering_attachment_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$accept_transit_gateway_peering_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_transit_gateway_peering_attachment <- ec2_accept_transit_gateway_peering_attachment

#' Accepts a request to attach a VPC to a transit gateway
#'
#' Accepts a request to attach a VPC to a transit gateway.
#' 
#' The VPC attachment must be in the `pendingAcceptance` state. Use
#' DescribeTransitGatewayVpcAttachments to view your pending VPC attachment
#' requests. Use RejectTransitGatewayVpcAttachment to reject a VPC
#' attachment request.
#'
#' @usage
#' ec2_accept_transit_gateway_vpc_attachment(TransitGatewayAttachmentId,
#'   DryRun)
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$accept_transit_gateway_vpc_attachment(
#'   TransitGatewayAttachmentId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_accept_transit_gateway_vpc_attachment
ec2_accept_transit_gateway_vpc_attachment <- function(TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "AcceptTransitGatewayVpcAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$accept_transit_gateway_vpc_attachment_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$accept_transit_gateway_vpc_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_transit_gateway_vpc_attachment <- ec2_accept_transit_gateway_vpc_attachment

#' Accepts one or more interface VPC endpoint connection requests to your
#' VPC endpoint service
#'
#' Accepts one or more interface VPC endpoint connection requests to your
#' VPC endpoint service.
#'
#' @usage
#' ec2_accept_vpc_endpoint_connections(DryRun, ServiceId, VpcEndpointIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ServiceId &#91;required&#93; The ID of the VPC endpoint service.
#' @param VpcEndpointIds &#91;required&#93; The IDs of one or more interface VPC endpoints.
#'
#' @section Request syntax:
#' ```
#' svc$accept_vpc_endpoint_connections(
#'   DryRun = TRUE|FALSE,
#'   ServiceId = "string",
#'   VpcEndpointIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_accept_vpc_endpoint_connections
ec2_accept_vpc_endpoint_connections <- function(DryRun = NULL, ServiceId, VpcEndpointIds) {
  op <- new_operation(
    name = "AcceptVpcEndpointConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$accept_vpc_endpoint_connections_input(DryRun = DryRun, ServiceId = ServiceId, VpcEndpointIds = VpcEndpointIds)
  output <- .ec2$accept_vpc_endpoint_connections_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_vpc_endpoint_connections <- ec2_accept_vpc_endpoint_connections

#' Accept a VPC peering connection request
#'
#' Accept a VPC peering connection request. To accept a request, the VPC
#' peering connection must be in the `pending-acceptance` state, and you
#' must be the owner of the peer VPC. Use DescribeVpcPeeringConnections to
#' view your outstanding VPC peering connection requests.
#' 
#' For an inter-Region VPC peering connection request, you must accept the
#' VPC peering connection in the Region of the accepter VPC.
#'
#' @usage
#' ec2_accept_vpc_peering_connection(DryRun, VpcPeeringConnectionId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcPeeringConnectionId The ID of the VPC peering connection. You must specify this parameter in
#' the request.
#'
#' @section Request syntax:
#' ```
#' svc$accept_vpc_peering_connection(
#'   DryRun = TRUE|FALSE,
#'   VpcPeeringConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_accept_vpc_peering_connection
ec2_accept_vpc_peering_connection <- function(DryRun = NULL, VpcPeeringConnectionId = NULL) {
  op <- new_operation(
    name = "AcceptVpcPeeringConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$accept_vpc_peering_connection_input(DryRun = DryRun, VpcPeeringConnectionId = VpcPeeringConnectionId)
  output <- .ec2$accept_vpc_peering_connection_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$accept_vpc_peering_connection <- ec2_accept_vpc_peering_connection

#' Advertises an IPv4 address range that is provisioned for use with your
#' AWS resources through bring your own IP addresses (BYOIP)
#'
#' Advertises an IPv4 address range that is provisioned for use with your
#' AWS resources through bring your own IP addresses (BYOIP).
#' 
#' You can perform this operation at most once every 10 seconds, even if
#' you specify different address ranges each time.
#' 
#' We recommend that you stop advertising the BYOIP CIDR from other
#' locations when you advertise it from AWS. To minimize down time, you can
#' configure your AWS resources to use an address from a BYOIP CIDR before
#' it is advertised, and then simultaneously stop advertising it from the
#' current location and start advertising it through AWS.
#' 
#' It can take a few minutes before traffic to the specified addresses
#' starts routing to AWS because of BGP propagation delays.
#' 
#' To stop advertising the BYOIP CIDR, use WithdrawByoipCidr.
#'
#' @usage
#' ec2_advertise_byoip_cidr(Cidr, DryRun)
#'
#' @param Cidr &#91;required&#93; The IPv4 address range, in CIDR notation. This must be the exact range
#' that you provisioned. You can\'t advertise only a portion of the
#' provisioned range.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$advertise_byoip_cidr(
#'   Cidr = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_advertise_byoip_cidr
ec2_advertise_byoip_cidr <- function(Cidr, DryRun = NULL) {
  op <- new_operation(
    name = "AdvertiseByoipCidr",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$advertise_byoip_cidr_input(Cidr = Cidr, DryRun = DryRun)
  output <- .ec2$advertise_byoip_cidr_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$advertise_byoip_cidr <- ec2_advertise_byoip_cidr

#' Allocates an Elastic IP address to your AWS account
#'
#' Allocates an Elastic IP address to your AWS account. After you allocate
#' the Elastic IP address you can associate it with an instance or network
#' interface. After you release an Elastic IP address, it is released to
#' the IP address pool and can be allocated to a different AWS account.
#' 
#' You can allocate an Elastic IP address from an address pool owned by AWS
#' or from an address pool created from a public IPv4 address range that
#' you have brought to AWS for use with your AWS resources using bring your
#' own IP addresses (BYOIP). For more information, see [Bring Your Own IP
#' Addresses
#' (BYOIP)](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-byoip.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' \[EC2-VPC\] If you release an Elastic IP address, you might be able to
#' recover it. You cannot recover an Elastic IP address that you released
#' after it is allocated to another AWS account. You cannot recover an
#' Elastic IP address for EC2-Classic. To attempt to recover an Elastic IP
#' address that you released, specify it in this operation.
#' 
#' An Elastic IP address is for use either in the EC2-Classic platform or
#' in a VPC. By default, you can allocate 5 Elastic IP addresses for
#' EC2-Classic per Region and 5 Elastic IP addresses for EC2-VPC per
#' Region.
#' 
#' For more information, see [Elastic IP
#' Addresses](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_allocate_address(Domain, Address, PublicIpv4Pool,
#'   NetworkBorderGroup, CustomerOwnedIpv4Pool, DryRun)
#'
#' @param Domain Set to `vpc` to allocate the address for use with instances in a VPC.
#' 
#' Default: The address is for use with instances in EC2-Classic.
#' @param Address \[EC2-VPC\] The Elastic IP address to recover or an IPv4 address from an
#' address pool.
#' @param PublicIpv4Pool The ID of an address pool that you own. Use this parameter to let Amazon
#' EC2 select an address from the address pool. To specify a specific
#' address from the address pool, use the `Address` parameter instead.
#' @param NetworkBorderGroup The location from which the IP address is advertised. Use this parameter
#' to limit the address to this location.
#' 
#' Use
#' [DescribeVpcs](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeVpcs.html)
#' to view the network border groups.
#' 
#' You cannot use a network border group with EC2 Classic. If you attempt
#' this operation on EC2 classic, you will receive an
#' `InvalidParameterCombination` error. For more information, see [Error
#' Codes](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/errors-overview.html).
#' @param CustomerOwnedIpv4Pool The ID of a customer-owned address pool. Use this parameter to let
#' Amazon EC2 select an address from the address pool. Alternatively,
#' specify a specific address from the address pool.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$allocate_address(
#'   Domain = "vpc"|"standard",
#'   Address = "string",
#'   PublicIpv4Pool = "string",
#'   NetworkBorderGroup = "string",
#'   CustomerOwnedIpv4Pool = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example allocates an Elastic IP address to use with an instance in
#' # a VPC.
#' \dontrun{svc$allocate_address(
#'   Domain = "vpc"
#' )}
#' 
#' # This example allocates an Elastic IP address to use with an instance in
#' # EC2-Classic.
#' \dontrun{svc$allocate_address()}
#'
#' @keywords internal
#'
#' @rdname ec2_allocate_address
ec2_allocate_address <- function(Domain = NULL, Address = NULL, PublicIpv4Pool = NULL, NetworkBorderGroup = NULL, CustomerOwnedIpv4Pool = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AllocateAddress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$allocate_address_input(Domain = Domain, Address = Address, PublicIpv4Pool = PublicIpv4Pool, NetworkBorderGroup = NetworkBorderGroup, CustomerOwnedIpv4Pool = CustomerOwnedIpv4Pool, DryRun = DryRun)
  output <- .ec2$allocate_address_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$allocate_address <- ec2_allocate_address

#' Allocates a Dedicated Host to your account
#'
#' Allocates a Dedicated Host to your account. At a minimum, specify the
#' supported instance type or instance family, the Availability Zone in
#' which to allocate the host, and the number of hosts to allocate.
#'
#' @usage
#' ec2_allocate_hosts(AutoPlacement, AvailabilityZone, ClientToken,
#'   InstanceType, InstanceFamily, Quantity, TagSpecifications, HostRecovery)
#'
#' @param AutoPlacement Indicates whether the host accepts any untargeted instance launches that
#' match its instance type configuration, or if it only accepts Host
#' tenancy instance launches that specify its unique host ID. For more
#' information, see [Understanding Instance Placement and Host
#' Affinity](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/how-dedicated-hosts-work.html#dedicated-hosts-understanding)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' 
#' Default: `on`
#' @param AvailabilityZone &#91;required&#93; The Availability Zone in which to allocate the Dedicated Host.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param InstanceType Specifies the instance type to be supported by the Dedicated Hosts. If
#' you specify an instance type, the Dedicated Hosts support instances of
#' the specified instance type only.
#' 
#' If you want the Dedicated Hosts to support multiple instance types in a
#' specific instance family, omit this parameter and specify
#' **InstanceFamily** instead. You cannot specify **InstanceType** and
#' **InstanceFamily** in the same request.
#' @param InstanceFamily Specifies the instance family to be supported by the Dedicated Hosts. If
#' you specify an instance family, the Dedicated Hosts support multiple
#' instance types within that instance family.
#' 
#' If you want the Dedicated Hosts to support a specific instance type
#' only, omit this parameter and specify **InstanceType** instead. You
#' cannot specify **InstanceFamily** and **InstanceType** in the same
#' request.
#' @param Quantity &#91;required&#93; The number of Dedicated Hosts to allocate to your account with these
#' parameters.
#' @param TagSpecifications The tags to apply to the Dedicated Host during creation.
#' @param HostRecovery Indicates whether to enable or disable host recovery for the Dedicated
#' Host. Host recovery is disabled by default. For more information, see
#' [Host
#' Recovery](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' Default: `off`
#'
#' @section Request syntax:
#' ```
#' svc$allocate_hosts(
#'   AutoPlacement = "on"|"off",
#'   AvailabilityZone = "string",
#'   ClientToken = "string",
#'   InstanceType = "string",
#'   InstanceFamily = "string",
#'   Quantity = 123,
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   HostRecovery = "on"|"off"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_allocate_hosts
ec2_allocate_hosts <- function(AutoPlacement = NULL, AvailabilityZone, ClientToken = NULL, InstanceType = NULL, InstanceFamily = NULL, Quantity, TagSpecifications = NULL, HostRecovery = NULL) {
  op <- new_operation(
    name = "AllocateHosts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$allocate_hosts_input(AutoPlacement = AutoPlacement, AvailabilityZone = AvailabilityZone, ClientToken = ClientToken, InstanceType = InstanceType, InstanceFamily = InstanceFamily, Quantity = Quantity, TagSpecifications = TagSpecifications, HostRecovery = HostRecovery)
  output <- .ec2$allocate_hosts_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$allocate_hosts <- ec2_allocate_hosts

#' Applies a security group to the association between the target network
#' and the Client VPN endpoint
#'
#' Applies a security group to the association between the target network
#' and the Client VPN endpoint. This action replaces the existing security
#' groups with the specified security groups.
#'
#' @usage
#' ec2_apply_security_groups_to_client_vpn_target_network(
#'   ClientVpnEndpointId, VpcId, SecurityGroupIds, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param VpcId &#91;required&#93; The ID of the VPC in which the associated target network is located.
#' @param SecurityGroupIds &#91;required&#93; The IDs of the security groups to apply to the associated target
#' network. Up to 5 security groups can be applied to an associated target
#' network.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$apply_security_groups_to_client_vpn_target_network(
#'   ClientVpnEndpointId = "string",
#'   VpcId = "string",
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_apply_security_groups_to_client_vpn_target_network
ec2_apply_security_groups_to_client_vpn_target_network <- function(ClientVpnEndpointId, VpcId, SecurityGroupIds, DryRun = NULL) {
  op <- new_operation(
    name = "ApplySecurityGroupsToClientVpnTargetNetwork",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$apply_security_groups_to_client_vpn_target_network_input(ClientVpnEndpointId = ClientVpnEndpointId, VpcId = VpcId, SecurityGroupIds = SecurityGroupIds, DryRun = DryRun)
  output <- .ec2$apply_security_groups_to_client_vpn_target_network_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$apply_security_groups_to_client_vpn_target_network <- ec2_apply_security_groups_to_client_vpn_target_network

#' Assigns one or more IPv6 addresses to the specified network interface
#'
#' Assigns one or more IPv6 addresses to the specified network interface.
#' You can specify one or more specific IPv6 addresses, or you can specify
#' the number of IPv6 addresses to be automatically assigned from within
#' the subnet\'s IPv6 CIDR block range. You can assign as many IPv6
#' addresses to a network interface as you can assign private IPv4
#' addresses, and the limit varies per instance type. For information, see
#' [IP Addresses Per Network Interface Per Instance
#' Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_assign_ipv_6_addresses(Ipv6AddressCount, Ipv6Addresses,
#'   NetworkInterfaceId)
#'
#' @param Ipv6AddressCount The number of IPv6 addresses to assign to the network interface. Amazon
#' EC2 automatically selects the IPv6 addresses from the subnet range. You
#' can\'t use this option if specifying specific IPv6 addresses.
#' @param Ipv6Addresses One or more specific IPv6 addresses to be assigned to the network
#' interface. You can\'t use this option if you\'re specifying a number of
#' IPv6 addresses.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#'
#' @section Request syntax:
#' ```
#' svc$assign_ipv_6_addresses(
#'   Ipv6AddressCount = 123,
#'   Ipv6Addresses = list(
#'     "string"
#'   ),
#'   NetworkInterfaceId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_assign_ipv_6_addresses
ec2_assign_ipv_6_addresses <- function(Ipv6AddressCount = NULL, Ipv6Addresses = NULL, NetworkInterfaceId) {
  op <- new_operation(
    name = "AssignIpv6Addresses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$assign_ipv_6_addresses_input(Ipv6AddressCount = Ipv6AddressCount, Ipv6Addresses = Ipv6Addresses, NetworkInterfaceId = NetworkInterfaceId)
  output <- .ec2$assign_ipv_6_addresses_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$assign_ipv_6_addresses <- ec2_assign_ipv_6_addresses

#' Assigns one or more secondary private IP addresses to the specified
#' network interface
#'
#' Assigns one or more secondary private IP addresses to the specified
#' network interface.
#' 
#' You can specify one or more specific secondary IP addresses, or you can
#' specify the number of secondary IP addresses to be automatically
#' assigned within the subnet\'s CIDR block range. The number of secondary
#' IP addresses that you can assign to an instance varies by instance type.
#' For information about instance types, see [Instance
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
#' in the *Amazon Elastic Compute Cloud User Guide*. For more information
#' about Elastic IP addresses, see [Elastic IP
#' Addresses](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' When you move a secondary private IP address to another network
#' interface, any Elastic IP address that is associated with the IP address
#' is also moved.
#' 
#' Remapping an IP address is an asynchronous operation. When you move an
#' IP address from one network interface to another, check
#' `network/interfaces/macs/mac/local-ipv4s` in the instance metadata to
#' confirm that the remapping is complete.
#'
#' @usage
#' ec2_assign_private_ip_addresses(AllowReassignment, NetworkInterfaceId,
#'   PrivateIpAddresses, SecondaryPrivateIpAddressCount)
#'
#' @param AllowReassignment Indicates whether to allow an IP address that is already assigned to
#' another network interface or instance to be reassigned to the specified
#' network interface.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#' @param PrivateIpAddresses One or more IP addresses to be assigned as a secondary private IP
#' address to the network interface. You can\'t specify this parameter when
#' also specifying a number of secondary IP addresses.
#' 
#' If you don\'t specify an IP address, Amazon EC2 automatically selects an
#' IP address within the subnet range.
#' @param SecondaryPrivateIpAddressCount The number of secondary IP addresses to assign to the network interface.
#' You can\'t specify this parameter when also specifying private IP
#' addresses.
#'
#' @section Request syntax:
#' ```
#' svc$assign_private_ip_addresses(
#'   AllowReassignment = TRUE|FALSE,
#'   NetworkInterfaceId = "string",
#'   PrivateIpAddresses = list(
#'     "string"
#'   ),
#'   SecondaryPrivateIpAddressCount = 123
#' )
#' ```
#'
#' @examples
#' # This example assigns the specified secondary private IP address to the
#' # specified network interface.
#' \dontrun{svc$assign_private_ip_addresses(
#'   NetworkInterfaceId = "eni-e5aa89a3",
#'   PrivateIpAddresses = list(
#'     "10.0.0.82"
#'   )
#' )}
#' 
#' # This example assigns two secondary private IP addresses to the specified
#' # network interface. Amazon EC2 automatically assigns these IP addresses
#' # from the available IP addresses in the CIDR block range of the subnet
#' # the network interface is associated with.
#' \dontrun{svc$assign_private_ip_addresses(
#'   NetworkInterfaceId = "eni-e5aa89a3",
#'   SecondaryPrivateIpAddressCount = 2L
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_assign_private_ip_addresses
ec2_assign_private_ip_addresses <- function(AllowReassignment = NULL, NetworkInterfaceId, PrivateIpAddresses = NULL, SecondaryPrivateIpAddressCount = NULL) {
  op <- new_operation(
    name = "AssignPrivateIpAddresses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$assign_private_ip_addresses_input(AllowReassignment = AllowReassignment, NetworkInterfaceId = NetworkInterfaceId, PrivateIpAddresses = PrivateIpAddresses, SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount)
  output <- .ec2$assign_private_ip_addresses_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$assign_private_ip_addresses <- ec2_assign_private_ip_addresses

#' Associates an Elastic IP address with an instance or a network interface
#'
#' Associates an Elastic IP address with an instance or a network
#' interface. Before you can use an Elastic IP address, you must allocate
#' it to your account.
#' 
#' An Elastic IP address is for use in either the EC2-Classic platform or
#' in a VPC. For more information, see [Elastic IP
#' Addresses](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' \[EC2-Classic, VPC in an EC2-VPC-only account\] If the Elastic IP
#' address is already associated with a different instance, it is
#' disassociated from that instance and associated with the specified
#' instance. If you associate an Elastic IP address with an instance that
#' has an existing Elastic IP address, the existing address is
#' disassociated from the instance, but remains allocated to your account.
#' 
#' \[VPC in an EC2-Classic account\] If you don\'t specify a private IP
#' address, the Elastic IP address is associated with the primary IP
#' address. If the Elastic IP address is already associated with a
#' different instance or a network interface, you get an error unless you
#' allow reassociation. You cannot associate an Elastic IP address with an
#' instance or network interface that has an existing Elastic IP address.
#' 
#' You cannot associate an Elastic IP address with an interface in a
#' different network border group.
#' 
#' This is an idempotent operation. If you perform the operation more than
#' once, Amazon EC2 doesn\'t return an error, and you may be charged for
#' each time the Elastic IP address is remapped to the same instance. For
#' more information, see the *Elastic IP Addresses* section of [Amazon EC2
#' Pricing](http://aws.amazon.com/ec2/pricing/).
#'
#' @usage
#' ec2_associate_address(AllocationId, InstanceId, PublicIp,
#'   AllowReassociation, DryRun, NetworkInterfaceId, PrivateIpAddress)
#'
#' @param AllocationId \[EC2-VPC\] The allocation ID. This is required for EC2-VPC.
#' @param InstanceId The ID of the instance. This is required for EC2-Classic. For EC2-VPC,
#' you can specify either the instance ID or the network interface ID, but
#' not both. The operation fails if you specify an instance ID unless
#' exactly one network interface is attached.
#' @param PublicIp The Elastic IP address to associate with the instance. This is required
#' for EC2-Classic.
#' @param AllowReassociation \[EC2-VPC\] For a VPC in an EC2-Classic account, specify true to allow
#' an Elastic IP address that is already associated with an instance or
#' network interface to be reassociated with the specified instance or
#' network interface. Otherwise, the operation fails. In a VPC in an
#' EC2-VPC-only account, reassociation is automatic, therefore you can
#' specify false to ensure the operation fails if the Elastic IP address is
#' already associated with another resource.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInterfaceId \[EC2-VPC\] The ID of the network interface. If the instance has more
#' than one network interface, you must specify a network interface ID.
#' 
#' For EC2-VPC, you can specify either the instance ID or the network
#' interface ID, but not both.
#' @param PrivateIpAddress \[EC2-VPC\] The primary or secondary private IP address to associate
#' with the Elastic IP address. If no private IP address is specified, the
#' Elastic IP address is associated with the primary private IP address.
#'
#' @section Request syntax:
#' ```
#' svc$associate_address(
#'   AllocationId = "string",
#'   InstanceId = "string",
#'   PublicIp = "string",
#'   AllowReassociation = TRUE|FALSE,
#'   DryRun = TRUE|FALSE,
#'   NetworkInterfaceId = "string",
#'   PrivateIpAddress = "string"
#' )
#' ```
#'
#' @examples
#' # This example associates the specified Elastic IP address with the
#' # specified instance in a VPC.
#' \dontrun{svc$associate_address(
#'   AllocationId = "eipalloc-64d5890a",
#'   InstanceId = "i-0b263919b6498b123"
#' )}
#' 
#' # This example associates the specified Elastic IP address with the
#' # specified network interface.
#' \dontrun{svc$associate_address(
#'   AllocationId = "eipalloc-64d5890a",
#'   NetworkInterfaceId = "eni-1a2b3c4d"
#' )}
#' 
#' # This example associates an Elastic IP address with an instance in
#' # EC2-Classic.
#' \dontrun{svc$associate_address(
#'   InstanceId = "i-07ffe74c7330ebf53",
#'   PublicIp = "198.51.100.0"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_associate_address
ec2_associate_address <- function(AllocationId = NULL, InstanceId = NULL, PublicIp = NULL, AllowReassociation = NULL, DryRun = NULL, NetworkInterfaceId = NULL, PrivateIpAddress = NULL) {
  op <- new_operation(
    name = "AssociateAddress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_address_input(AllocationId = AllocationId, InstanceId = InstanceId, PublicIp = PublicIp, AllowReassociation = AllowReassociation, DryRun = DryRun, NetworkInterfaceId = NetworkInterfaceId, PrivateIpAddress = PrivateIpAddress)
  output <- .ec2$associate_address_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_address <- ec2_associate_address

#' Associates a target network with a Client VPN endpoint
#'
#' Associates a target network with a Client VPN endpoint. A target network
#' is a subnet in a VPC. You can associate multiple subnets from the same
#' VPC with a Client VPN endpoint. You can associate only one subnet in
#' each Availability Zone. We recommend that you associate at least two
#' subnets to provide Availability Zone redundancy.
#'
#' @usage
#' ec2_associate_client_vpn_target_network(ClientVpnEndpointId, SubnetId,
#'   ClientToken, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param SubnetId &#91;required&#93; The ID of the subnet to associate with the Client VPN endpoint.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$associate_client_vpn_target_network(
#'   ClientVpnEndpointId = "string",
#'   SubnetId = "string",
#'   ClientToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_associate_client_vpn_target_network
ec2_associate_client_vpn_target_network <- function(ClientVpnEndpointId, SubnetId, ClientToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateClientVpnTargetNetwork",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_client_vpn_target_network_input(ClientVpnEndpointId = ClientVpnEndpointId, SubnetId = SubnetId, ClientToken = ClientToken, DryRun = DryRun)
  output <- .ec2$associate_client_vpn_target_network_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_client_vpn_target_network <- ec2_associate_client_vpn_target_network

#' Associates a set of DHCP options (that you've previously created) with
#' the specified VPC, or associates no DHCP options with the VPC
#'
#' Associates a set of DHCP options (that you\'ve previously created) with
#' the specified VPC, or associates no DHCP options with the VPC.
#' 
#' After you associate the options with the VPC, any existing instances and
#' all new instances that you launch in that VPC use the options. You
#' don\'t need to restart or relaunch the instances. They automatically
#' pick up the changes within a few hours, depending on how frequently the
#' instance renews its DHCP lease. You can explicitly renew the lease using
#' the operating system on the instance.
#' 
#' For more information, see [DHCP Options
#' Sets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_associate_dhcp_options(DhcpOptionsId, VpcId, DryRun)
#'
#' @param DhcpOptionsId &#91;required&#93; The ID of the DHCP options set, or `default` to associate no DHCP
#' options with the VPC.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$associate_dhcp_options(
#'   DhcpOptionsId = "string",
#'   VpcId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example associates the specified DHCP options set with the
#' # specified VPC.
#' \dontrun{svc$associate_dhcp_options(
#'   DhcpOptionsId = "dopt-d9070ebb",
#'   VpcId = "vpc-a01106c2"
#' )}
#' 
#' # This example associates the default DHCP options set with the specified
#' # VPC.
#' \dontrun{svc$associate_dhcp_options(
#'   DhcpOptionsId = "default",
#'   VpcId = "vpc-a01106c2"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_associate_dhcp_options
ec2_associate_dhcp_options <- function(DhcpOptionsId, VpcId, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateDhcpOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_dhcp_options_input(DhcpOptionsId = DhcpOptionsId, VpcId = VpcId, DryRun = DryRun)
  output <- .ec2$associate_dhcp_options_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_dhcp_options <- ec2_associate_dhcp_options

#' Associates an IAM instance profile with a running or stopped instance
#'
#' Associates an IAM instance profile with a running or stopped instance.
#' You cannot associate more than one IAM instance profile with an
#' instance.
#'
#' @usage
#' ec2_associate_iam_instance_profile(IamInstanceProfile, InstanceId)
#'
#' @param IamInstanceProfile &#91;required&#93; The IAM instance profile.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#'
#' @section Request syntax:
#' ```
#' svc$associate_iam_instance_profile(
#'   IamInstanceProfile = list(
#'     Arn = "string",
#'     Name = "string"
#'   ),
#'   InstanceId = "string"
#' )
#' ```
#'
#' @examples
#' # This example associates an IAM instance profile named admin-role with
#' # the specified instance.
#' \dontrun{svc$associate_iam_instance_profile(
#'   IamInstanceProfile = list(
#'     Name = "admin-role"
#'   ),
#'   InstanceId = "i-123456789abcde123"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_associate_iam_instance_profile
ec2_associate_iam_instance_profile <- function(IamInstanceProfile, InstanceId) {
  op <- new_operation(
    name = "AssociateIamInstanceProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_iam_instance_profile_input(IamInstanceProfile = IamInstanceProfile, InstanceId = InstanceId)
  output <- .ec2$associate_iam_instance_profile_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_iam_instance_profile <- ec2_associate_iam_instance_profile

#' Associates a subnet in your VPC or an internet gateway or virtual
#' private gateway attached to your VPC with a route table in your VPC
#'
#' Associates a subnet in your VPC or an internet gateway or virtual
#' private gateway attached to your VPC with a route table in your VPC.
#' This association causes traffic from the subnet or gateway to be routed
#' according to the routes in the route table. The action returns an
#' association ID, which you need in order to disassociate the route table
#' later. A route table can be associated with multiple subnets.
#' 
#' For more information, see [Route
#' Tables](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_associate_route_table(DryRun, RouteTableId, SubnetId, GatewayId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param RouteTableId &#91;required&#93; The ID of the route table.
#' @param SubnetId The ID of the subnet.
#' @param GatewayId The ID of the internet gateway or virtual private gateway.
#'
#' @section Request syntax:
#' ```
#' svc$associate_route_table(
#'   DryRun = TRUE|FALSE,
#'   RouteTableId = "string",
#'   SubnetId = "string",
#'   GatewayId = "string"
#' )
#' ```
#'
#' @examples
#' # This example associates the specified route table with the specified
#' # subnet.
#' \dontrun{svc$associate_route_table(
#'   RouteTableId = "rtb-22574640",
#'   SubnetId = "subnet-9d4a7b6"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_associate_route_table
ec2_associate_route_table <- function(DryRun = NULL, RouteTableId, SubnetId = NULL, GatewayId = NULL) {
  op <- new_operation(
    name = "AssociateRouteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_route_table_input(DryRun = DryRun, RouteTableId = RouteTableId, SubnetId = SubnetId, GatewayId = GatewayId)
  output <- .ec2$associate_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_route_table <- ec2_associate_route_table

#' Associates a CIDR block with your subnet
#'
#' Associates a CIDR block with your subnet. You can only associate a
#' single IPv6 CIDR block with your subnet. An IPv6 CIDR block must have a
#' prefix length of /64.
#'
#' @usage
#' ec2_associate_subnet_cidr_block(Ipv6CidrBlock, SubnetId)
#'
#' @param Ipv6CidrBlock &#91;required&#93; The IPv6 CIDR block for your subnet. The subnet must have a /64 prefix
#' length.
#' @param SubnetId &#91;required&#93; The ID of your subnet.
#'
#' @section Request syntax:
#' ```
#' svc$associate_subnet_cidr_block(
#'   Ipv6CidrBlock = "string",
#'   SubnetId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_associate_subnet_cidr_block
ec2_associate_subnet_cidr_block <- function(Ipv6CidrBlock, SubnetId) {
  op <- new_operation(
    name = "AssociateSubnetCidrBlock",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_subnet_cidr_block_input(Ipv6CidrBlock = Ipv6CidrBlock, SubnetId = SubnetId)
  output <- .ec2$associate_subnet_cidr_block_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_subnet_cidr_block <- ec2_associate_subnet_cidr_block

#' Associates the specified subnets and transit gateway attachments with
#' the specified transit gateway multicast domain
#'
#' Associates the specified subnets and transit gateway attachments with
#' the specified transit gateway multicast domain.
#' 
#' The transit gateway attachment must be in the available state before you
#' can add a resource. Use
#' [DescribeTransitGatewayAttachments](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGatewayAttachments.html)
#' to see the state of the attachment.
#'
#' @usage
#' ec2_associate_transit_gateway_multicast_domain(
#'   TransitGatewayMulticastDomainId, TransitGatewayAttachmentId, SubnetIds,
#'   DryRun)
#'
#' @param TransitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
#' @param TransitGatewayAttachmentId The ID of the transit gateway attachment to associate with the transit
#' gateway multicast domain.
#' @param SubnetIds The IDs of the subnets to associate with the transit gateway multicast
#' domain.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$associate_transit_gateway_multicast_domain(
#'   TransitGatewayMulticastDomainId = "string",
#'   TransitGatewayAttachmentId = "string",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_associate_transit_gateway_multicast_domain
ec2_associate_transit_gateway_multicast_domain <- function(TransitGatewayMulticastDomainId = NULL, TransitGatewayAttachmentId = NULL, SubnetIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateTransitGatewayMulticastDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_transit_gateway_multicast_domain_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, SubnetIds = SubnetIds, DryRun = DryRun)
  output <- .ec2$associate_transit_gateway_multicast_domain_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_transit_gateway_multicast_domain <- ec2_associate_transit_gateway_multicast_domain

#' Associates the specified attachment with the specified transit gateway
#' route table
#'
#' Associates the specified attachment with the specified transit gateway
#' route table. You can associate only one route table with an attachment.
#'
#' @usage
#' ec2_associate_transit_gateway_route_table(TransitGatewayRouteTableId,
#'   TransitGatewayAttachmentId, DryRun)
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$associate_transit_gateway_route_table(
#'   TransitGatewayRouteTableId = "string",
#'   TransitGatewayAttachmentId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_associate_transit_gateway_route_table
ec2_associate_transit_gateway_route_table <- function(TransitGatewayRouteTableId, TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "AssociateTransitGatewayRouteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_transit_gateway_route_table_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$associate_transit_gateway_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_transit_gateway_route_table <- ec2_associate_transit_gateway_route_table

#' Associates a CIDR block with your VPC
#'
#' Associates a CIDR block with your VPC. You can associate a secondary
#' IPv4 CIDR block, or you can associate an Amazon-provided IPv6 CIDR
#' block. The IPv6 CIDR block size is fixed at /56.
#' 
#' For more information about associating CIDR blocks with your VPC and
#' applicable restrictions, see [VPC and Subnet
#' Sizing](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html#VPC_Sizing)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_associate_vpc_cidr_block(AmazonProvidedIpv6CidrBlock, CidrBlock,
#'   VpcId, Ipv6CidrBlockNetworkBorderGroup)
#'
#' @param AmazonProvidedIpv6CidrBlock Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for
#' the VPC. You cannot specify the range of IPv6 addresses, or the size of
#' the CIDR block.
#' @param CidrBlock An IPv4 CIDR block to associate with the VPC.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param Ipv6CidrBlockNetworkBorderGroup The name of the location from which we advertise the IPV6 CIDR block.
#' Use this parameter to limit the CiDR block to this location.
#' 
#' You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this
#' parameter.
#' 
#' You can have one IPv6 CIDR block association per network border group.
#'
#' @section Request syntax:
#' ```
#' svc$associate_vpc_cidr_block(
#'   AmazonProvidedIpv6CidrBlock = TRUE|FALSE,
#'   CidrBlock = "string",
#'   VpcId = "string",
#'   Ipv6CidrBlockNetworkBorderGroup = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_associate_vpc_cidr_block
ec2_associate_vpc_cidr_block <- function(AmazonProvidedIpv6CidrBlock = NULL, CidrBlock = NULL, VpcId, Ipv6CidrBlockNetworkBorderGroup = NULL) {
  op <- new_operation(
    name = "AssociateVpcCidrBlock",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$associate_vpc_cidr_block_input(AmazonProvidedIpv6CidrBlock = AmazonProvidedIpv6CidrBlock, CidrBlock = CidrBlock, VpcId = VpcId, Ipv6CidrBlockNetworkBorderGroup = Ipv6CidrBlockNetworkBorderGroup)
  output <- .ec2$associate_vpc_cidr_block_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$associate_vpc_cidr_block <- ec2_associate_vpc_cidr_block

#' Links an EC2-Classic instance to a ClassicLink-enabled VPC through one
#' or more of the VPC's security groups
#'
#' Links an EC2-Classic instance to a ClassicLink-enabled VPC through one
#' or more of the VPC\'s security groups. You cannot link an EC2-Classic
#' instance to more than one VPC at a time. You can only link an instance
#' that\'s in the `running` state. An instance is automatically unlinked
#' from a VPC when it\'s stopped - you can link it to the VPC again when
#' you restart it.
#' 
#' After you\'ve linked an instance, you cannot change the VPC security
#' groups that are associated with it. To change the security groups, you
#' must first unlink the instance, and then link it again.
#' 
#' Linking your instance to a VPC is sometimes referred to as *attaching*
#' your instance.
#'
#' @usage
#' ec2_attach_classic_link_vpc(DryRun, Groups, InstanceId, VpcId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Groups &#91;required&#93; The ID of one or more of the VPC\'s security groups. You cannot specify
#' security groups from a different VPC.
#' @param InstanceId &#91;required&#93; The ID of an EC2-Classic instance to link to the ClassicLink-enabled
#' VPC.
#' @param VpcId &#91;required&#93; The ID of a ClassicLink-enabled VPC.
#'
#' @section Request syntax:
#' ```
#' svc$attach_classic_link_vpc(
#'   DryRun = TRUE|FALSE,
#'   Groups = list(
#'     "string"
#'   ),
#'   InstanceId = "string",
#'   VpcId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_attach_classic_link_vpc
ec2_attach_classic_link_vpc <- function(DryRun = NULL, Groups, InstanceId, VpcId) {
  op <- new_operation(
    name = "AttachClassicLinkVpc",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$attach_classic_link_vpc_input(DryRun = DryRun, Groups = Groups, InstanceId = InstanceId, VpcId = VpcId)
  output <- .ec2$attach_classic_link_vpc_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_classic_link_vpc <- ec2_attach_classic_link_vpc

#' Attaches an internet gateway or a virtual private gateway to a VPC,
#' enabling connectivity between the internet and the VPC
#'
#' Attaches an internet gateway or a virtual private gateway to a VPC,
#' enabling connectivity between the internet and the VPC. For more
#' information about your VPC and internet gateway, see the [Amazon Virtual
#' Private Cloud User
#' Guide](https://docs.aws.amazon.com/vpc/latest/userguide/).
#'
#' @usage
#' ec2_attach_internet_gateway(DryRun, InternetGatewayId, VpcId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InternetGatewayId &#91;required&#93; The ID of the internet gateway.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#'
#' @section Request syntax:
#' ```
#' svc$attach_internet_gateway(
#'   DryRun = TRUE|FALSE,
#'   InternetGatewayId = "string",
#'   VpcId = "string"
#' )
#' ```
#'
#' @examples
#' # This example attaches the specified Internet gateway to the specified
#' # VPC.
#' \dontrun{svc$attach_internet_gateway(
#'   InternetGatewayId = "igw-c0a643a9",
#'   VpcId = "vpc-a01106c2"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_attach_internet_gateway
ec2_attach_internet_gateway <- function(DryRun = NULL, InternetGatewayId, VpcId) {
  op <- new_operation(
    name = "AttachInternetGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$attach_internet_gateway_input(DryRun = DryRun, InternetGatewayId = InternetGatewayId, VpcId = VpcId)
  output <- .ec2$attach_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_internet_gateway <- ec2_attach_internet_gateway

#' Attaches a network interface to an instance
#'
#' Attaches a network interface to an instance.
#'
#' @usage
#' ec2_attach_network_interface(DeviceIndex, DryRun, InstanceId,
#'   NetworkInterfaceId)
#'
#' @param DeviceIndex &#91;required&#93; The index of the device for the network interface attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#'
#' @section Request syntax:
#' ```
#' svc$attach_network_interface(
#'   DeviceIndex = 123,
#'   DryRun = TRUE|FALSE,
#'   InstanceId = "string",
#'   NetworkInterfaceId = "string"
#' )
#' ```
#'
#' @examples
#' # This example attaches the specified network interface to the specified
#' # instance.
#' \dontrun{svc$attach_network_interface(
#'   DeviceIndex = 1L,
#'   InstanceId = "i-1234567890abcdef0",
#'   NetworkInterfaceId = "eni-e5aa89a3"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_attach_network_interface
ec2_attach_network_interface <- function(DeviceIndex, DryRun = NULL, InstanceId, NetworkInterfaceId) {
  op <- new_operation(
    name = "AttachNetworkInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$attach_network_interface_input(DeviceIndex = DeviceIndex, DryRun = DryRun, InstanceId = InstanceId, NetworkInterfaceId = NetworkInterfaceId)
  output <- .ec2$attach_network_interface_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_network_interface <- ec2_attach_network_interface

#' Attaches an EBS volume to a running or stopped instance and exposes it
#' to the instance with the specified device name
#'
#' Attaches an EBS volume to a running or stopped instance and exposes it
#' to the instance with the specified device name.
#' 
#' Encrypted EBS volumes must be attached to instances that support Amazon
#' EBS encryption. For more information, see [Amazon EBS
#' Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' After you attach an EBS volume, you must make it available. For more
#' information, see [Making an EBS Volume Available For
#' Use](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-using-volumes.html).
#' 
#' If a volume has an AWS Marketplace product code:
#' 
#' -   The volume can be attached only to a stopped instance.
#' 
#' -   AWS Marketplace product codes are copied from the volume to the
#'     instance.
#' 
#' -   You must be subscribed to the product.
#' 
#' -   The instance type and operating system of the instance must support
#'     the product. For example, you can\'t detach a volume from a Windows
#'     instance and attach it to a Linux instance.
#' 
#' For more information, see [Attaching Amazon EBS
#' Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-attaching-volume.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_attach_volume(Device, InstanceId, VolumeId, DryRun)
#'
#' @param Device &#91;required&#93; The device name (for example, `/dev/sdh` or `xvdh`).
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param VolumeId &#91;required&#93; The ID of the EBS volume. The volume and instance must be within the
#' same Availability Zone.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$attach_volume(
#'   Device = "string",
#'   InstanceId = "string",
#'   VolumeId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example attaches a volume (`vol-1234567890abcdef0`) to an
#' # instance (`i-01474ef662b89480`) as `/dev/sdf`.
#' \dontrun{svc$attach_volume(
#'   Device = "/dev/sdf",
#'   InstanceId = "i-01474ef662b89480",
#'   VolumeId = "vol-1234567890abcdef0"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_attach_volume
ec2_attach_volume <- function(Device, InstanceId, VolumeId, DryRun = NULL) {
  op <- new_operation(
    name = "AttachVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$attach_volume_input(Device = Device, InstanceId = InstanceId, VolumeId = VolumeId, DryRun = DryRun)
  output <- .ec2$attach_volume_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_volume <- ec2_attach_volume

#' Attaches a virtual private gateway to a VPC
#'
#' Attaches a virtual private gateway to a VPC. You can attach one virtual
#' private gateway to one VPC at a time.
#' 
#' For more information, see [AWS Site-to-Site
#' VPN](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the
#' *AWS Site-to-Site VPN User Guide*.
#'
#' @usage
#' ec2_attach_vpn_gateway(VpcId, VpnGatewayId, DryRun)
#'
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param VpnGatewayId &#91;required&#93; The ID of the virtual private gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$attach_vpn_gateway(
#'   VpcId = "string",
#'   VpnGatewayId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_attach_vpn_gateway
ec2_attach_vpn_gateway <- function(VpcId, VpnGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "AttachVpnGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$attach_vpn_gateway_input(VpcId = VpcId, VpnGatewayId = VpnGatewayId, DryRun = DryRun)
  output <- .ec2$attach_vpn_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$attach_vpn_gateway <- ec2_attach_vpn_gateway

#' Adds an ingress authorization rule to a Client VPN endpoint
#'
#' Adds an ingress authorization rule to a Client VPN endpoint. Ingress
#' authorization rules act as firewall rules that grant access to networks.
#' You must configure ingress authorization rules to enable clients to
#' access resources in AWS or on-premises networks.
#'
#' @usage
#' ec2_authorize_client_vpn_ingress(ClientVpnEndpointId, TargetNetworkCidr,
#'   AccessGroupId, AuthorizeAllGroups, Description, ClientToken, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param TargetNetworkCidr &#91;required&#93; The IPv4 address range, in CIDR notation, of the network for which
#' access is being authorized.
#' @param AccessGroupId The ID of the Active Directory group to grant access.
#' @param AuthorizeAllGroups Indicates whether to grant access to all clients. Use `true` to grant
#' all clients who successfully establish a VPN connection access to the
#' network.
#' @param Description A brief description of the authorization rule.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$authorize_client_vpn_ingress(
#'   ClientVpnEndpointId = "string",
#'   TargetNetworkCidr = "string",
#'   AccessGroupId = "string",
#'   AuthorizeAllGroups = TRUE|FALSE,
#'   Description = "string",
#'   ClientToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_authorize_client_vpn_ingress
ec2_authorize_client_vpn_ingress <- function(ClientVpnEndpointId, TargetNetworkCidr, AccessGroupId = NULL, AuthorizeAllGroups = NULL, Description = NULL, ClientToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AuthorizeClientVpnIngress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$authorize_client_vpn_ingress_input(ClientVpnEndpointId = ClientVpnEndpointId, TargetNetworkCidr = TargetNetworkCidr, AccessGroupId = AccessGroupId, AuthorizeAllGroups = AuthorizeAllGroups, Description = Description, ClientToken = ClientToken, DryRun = DryRun)
  output <- .ec2$authorize_client_vpn_ingress_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$authorize_client_vpn_ingress <- ec2_authorize_client_vpn_ingress

#' &#91;VPC only&#93; Adds the specified egress rules to a security group
#' for use with a VPC
#'
#' \[VPC only\] Adds the specified egress rules to a security group for use
#' with a VPC.
#' 
#' An outbound rule permits instances to send traffic to the specified IPv4
#' or IPv6 CIDR address ranges, or to the instances associated with the
#' specified destination security groups.
#' 
#' You specify a protocol for each rule (for example, TCP). For the TCP and
#' UDP protocols, you must also specify the destination port or port range.
#' For the ICMP protocol, you must also specify the ICMP type and code. You
#' can use -1 for the type or code to mean all types or all codes.
#' 
#' Rule changes are propagated to affected instances as quickly as
#' possible. However, a small delay might occur.
#' 
#' For more information about VPC security group limits, see [Amazon VPC
#' Limits](https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html).
#'
#' @usage
#' ec2_authorize_security_group_egress(DryRun, GroupId, IpPermissions,
#'   CidrIp, FromPort, IpProtocol, ToPort, SourceSecurityGroupName,
#'   SourceSecurityGroupOwnerId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param GroupId &#91;required&#93; The ID of the security group.
#' @param IpPermissions The sets of IP permissions. You can\'t specify a destination security
#' group and a CIDR IP address range in the same set of permissions.
#' @param CidrIp Not supported. Use a set of IP permissions to specify the CIDR.
#' @param FromPort Not supported. Use a set of IP permissions to specify the port.
#' @param IpProtocol Not supported. Use a set of IP permissions to specify the protocol name
#' or number.
#' @param ToPort Not supported. Use a set of IP permissions to specify the port.
#' @param SourceSecurityGroupName Not supported. Use a set of IP permissions to specify a destination
#' security group.
#' @param SourceSecurityGroupOwnerId Not supported. Use a set of IP permissions to specify a destination
#' security group.
#'
#' @section Request syntax:
#' ```
#' svc$authorize_security_group_egress(
#'   DryRun = TRUE|FALSE,
#'   GroupId = "string",
#'   IpPermissions = list(
#'     list(
#'       FromPort = 123,
#'       IpProtocol = "string",
#'       IpRanges = list(
#'         list(
#'           CidrIp = "string",
#'           Description = "string"
#'         )
#'       ),
#'       Ipv6Ranges = list(
#'         list(
#'           CidrIpv6 = "string",
#'           Description = "string"
#'         )
#'       ),
#'       PrefixListIds = list(
#'         list(
#'           Description = "string",
#'           PrefixListId = "string"
#'         )
#'       ),
#'       ToPort = 123,
#'       UserIdGroupPairs = list(
#'         list(
#'           Description = "string",
#'           GroupId = "string",
#'           GroupName = "string",
#'           PeeringStatus = "string",
#'           UserId = "string",
#'           VpcId = "string",
#'           VpcPeeringConnectionId = "string"
#'         )
#'       )
#'     )
#'   ),
#'   CidrIp = "string",
#'   FromPort = 123,
#'   IpProtocol = "string",
#'   ToPort = 123,
#'   SourceSecurityGroupName = "string",
#'   SourceSecurityGroupOwnerId = "string"
#' )
#' ```
#'
#' @examples
#' # This example adds a rule that grants access to the specified address
#' # ranges on TCP port 80.
#' \dontrun{svc$authorize_security_group_egress(
#'   GroupId = "sg-1a2b3c4d",
#'   IpPermissions = list(
#'     list(
#'       FromPort = 80L,
#'       IpProtocol = "tcp",
#'       IpRanges = list(
#'         list(
#'           CidrIp = "10.0.0.0/16"
#'         )
#'       ),
#'       ToPort = 80L
#'     )
#'   )
#' )}
#' 
#' # This example adds a rule that grants access to the specified security
#' # group on TCP port 80.
#' \dontrun{svc$authorize_security_group_egress(
#'   GroupId = "sg-1a2b3c4d",
#'   IpPermissions = list(
#'     list(
#'       FromPort = 80L,
#'       IpProtocol = "tcp",
#'       ToPort = 80L,
#'       UserIdGroupPairs = list(
#'         list(
#'           GroupId = "sg-4b51a32f"
#'         )
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_authorize_security_group_egress
ec2_authorize_security_group_egress <- function(DryRun = NULL, GroupId, IpPermissions = NULL, CidrIp = NULL, FromPort = NULL, IpProtocol = NULL, ToPort = NULL, SourceSecurityGroupName = NULL, SourceSecurityGroupOwnerId = NULL) {
  op <- new_operation(
    name = "AuthorizeSecurityGroupEgress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$authorize_security_group_egress_input(DryRun = DryRun, GroupId = GroupId, IpPermissions = IpPermissions, CidrIp = CidrIp, FromPort = FromPort, IpProtocol = IpProtocol, ToPort = ToPort, SourceSecurityGroupName = SourceSecurityGroupName, SourceSecurityGroupOwnerId = SourceSecurityGroupOwnerId)
  output <- .ec2$authorize_security_group_egress_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$authorize_security_group_egress <- ec2_authorize_security_group_egress

#' Adds the specified ingress rules to a security group
#'
#' Adds the specified ingress rules to a security group.
#' 
#' An inbound rule permits instances to receive traffic from the specified
#' IPv4 or IPv6 CIDR address ranges, or from the instances associated with
#' the specified destination security groups.
#' 
#' You specify a protocol for each rule (for example, TCP). For TCP and
#' UDP, you must also specify the destination port or port range. For
#' ICMP/ICMPv6, you must also specify the ICMP/ICMPv6 type and code. You
#' can use -1 to mean all types or all codes.
#' 
#' Rule changes are propagated to instances within the security group as
#' quickly as possible. However, a small delay might occur.
#' 
#' For more information about VPC security group limits, see [Amazon VPC
#' Limits](https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html).
#'
#' @usage
#' ec2_authorize_security_group_ingress(CidrIp, FromPort, GroupId,
#'   GroupName, IpPermissions, IpProtocol, SourceSecurityGroupName,
#'   SourceSecurityGroupOwnerId, ToPort, DryRun)
#'
#' @param CidrIp The IPv4 address range, in CIDR format. You can\'t specify this
#' parameter when specifying a source security group. To specify an IPv6
#' address range, use a set of IP permissions.
#' 
#' Alternatively, use a set of IP permissions to specify multiple rules and
#' a description for the rule.
#' @param FromPort The start of port range for the TCP and UDP protocols, or an ICMP type
#' number. For the ICMP type number, use `-1` to specify all types. If you
#' specify all ICMP types, you must specify all codes.
#' 
#' Alternatively, use a set of IP permissions to specify multiple rules and
#' a description for the rule.
#' @param GroupId The ID of the security group. You must specify either the security group
#' ID or the security group name in the request. For security groups in a
#' nondefault VPC, you must specify the security group ID.
#' @param GroupName \[EC2-Classic, default VPC\] The name of the security group. You must
#' specify either the security group ID or the security group name in the
#' request.
#' @param IpPermissions The sets of IP permissions.
#' @param IpProtocol The IP protocol name (`tcp`, `udp`, `icmp`) or number (see [Protocol
#' Numbers](http://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)).
#' To specify `icmpv6`, use a set of IP permissions.
#' 
#' \[VPC only\] Use `-1` to specify all protocols. If you specify `-1` or a
#' protocol other than `tcp`, `udp`, or `icmp`, traffic on all ports is
#' allowed, regardless of any ports you specify.
#' 
#' Alternatively, use a set of IP permissions to specify multiple rules and
#' a description for the rule.
#' @param SourceSecurityGroupName \[EC2-Classic, default VPC\] The name of the source security group. You
#' can\'t specify this parameter in combination with the following
#' parameters: the CIDR IP address range, the start of the port range, the
#' IP protocol, and the end of the port range. Creates rules that grant
#' full ICMP, UDP, and TCP access. To create a rule with a specific IP
#' protocol and port range, use a set of IP permissions instead. For
#' EC2-VPC, the source security group must be in the same VPC.
#' @param SourceSecurityGroupOwnerId \[nondefault VPC\] The AWS account ID for the source security group, if
#' the source security group is in a different account. You can\'t specify
#' this parameter in combination with the following parameters: the CIDR IP
#' address range, the IP protocol, the start of the port range, and the end
#' of the port range. Creates rules that grant full ICMP, UDP, and TCP
#' access. To create a rule with a specific IP protocol and port range, use
#' a set of IP permissions instead.
#' @param ToPort The end of port range for the TCP and UDP protocols, or an ICMP code
#' number. For the ICMP code number, use `-1` to specify all codes. If you
#' specify all ICMP types, you must specify all codes.
#' 
#' Alternatively, use a set of IP permissions to specify multiple rules and
#' a description for the rule.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$authorize_security_group_ingress(
#'   CidrIp = "string",
#'   FromPort = 123,
#'   GroupId = "string",
#'   GroupName = "string",
#'   IpPermissions = list(
#'     list(
#'       FromPort = 123,
#'       IpProtocol = "string",
#'       IpRanges = list(
#'         list(
#'           CidrIp = "string",
#'           Description = "string"
#'         )
#'       ),
#'       Ipv6Ranges = list(
#'         list(
#'           CidrIpv6 = "string",
#'           Description = "string"
#'         )
#'       ),
#'       PrefixListIds = list(
#'         list(
#'           Description = "string",
#'           PrefixListId = "string"
#'         )
#'       ),
#'       ToPort = 123,
#'       UserIdGroupPairs = list(
#'         list(
#'           Description = "string",
#'           GroupId = "string",
#'           GroupName = "string",
#'           PeeringStatus = "string",
#'           UserId = "string",
#'           VpcId = "string",
#'           VpcPeeringConnectionId = "string"
#'         )
#'       )
#'     )
#'   ),
#'   IpProtocol = "string",
#'   SourceSecurityGroupName = "string",
#'   SourceSecurityGroupOwnerId = "string",
#'   ToPort = 123,
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example enables inbound traffic on TCP port 22 (SSH). The rule
#' # includes a description to help you identify it later.
#' \dontrun{svc$authorize_security_group_ingress(
#'   GroupId = "sg-903004f8",
#'   IpPermissions = list(
#'     list(
#'       FromPort = 22L,
#'       IpProtocol = "tcp",
#'       IpRanges = list(
#'         list(
#'           CidrIp = "203.0.113.0/24",
#'           Description = "SSH access from the LA office"
#'         )
#'       ),
#'       ToPort = 22L
#'     )
#'   )
#' )}
#' 
#' # This example enables inbound traffic on TCP port 80 from the specified
#' # security group. The group must be in the same VPC or a peer VPC.
#' # Incoming traffic is allowed based on the private IP addresses of
#' # instances that are associated with the specified security group.
#' \dontrun{svc$authorize_security_group_ingress(
#'   GroupId = "sg-111aaa22",
#'   IpPermissions = list(
#'     list(
#'       FromPort = 80L,
#'       IpProtocol = "tcp",
#'       ToPort = 80L,
#'       UserIdGroupPairs = list(
#'         list(
#'           Description = "HTTP access from other instances",
#'           GroupId = "sg-1a2b3c4d"
#'         )
#'       )
#'     )
#'   )
#' )}
#' 
#' # This example adds an inbound rule that allows RDP traffic from the
#' # specified IPv6 address range. The rule includes a description to help
#' # you identify it later.
#' \dontrun{svc$authorize_security_group_ingress(
#'   GroupId = "sg-123abc12 ",
#'   IpPermissions = list(
#'     list(
#'       FromPort = 3389L,
#'       IpProtocol = "tcp",
#'       Ipv6Ranges = list(
#'         list(
#'           CidrIpv6 = "2001:db8:1234:1a00::/64",
#'           Description = "RDP access from the NY office"
#'         )
#'       ),
#'       ToPort = 3389L
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_authorize_security_group_ingress
ec2_authorize_security_group_ingress <- function(CidrIp = NULL, FromPort = NULL, GroupId = NULL, GroupName = NULL, IpPermissions = NULL, IpProtocol = NULL, SourceSecurityGroupName = NULL, SourceSecurityGroupOwnerId = NULL, ToPort = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "AuthorizeSecurityGroupIngress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$authorize_security_group_ingress_input(CidrIp = CidrIp, FromPort = FromPort, GroupId = GroupId, GroupName = GroupName, IpPermissions = IpPermissions, IpProtocol = IpProtocol, SourceSecurityGroupName = SourceSecurityGroupName, SourceSecurityGroupOwnerId = SourceSecurityGroupOwnerId, ToPort = ToPort, DryRun = DryRun)
  output <- .ec2$authorize_security_group_ingress_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$authorize_security_group_ingress <- ec2_authorize_security_group_ingress

#' Bundles an Amazon instance store-backed Windows instance
#'
#' Bundles an Amazon instance store-backed Windows instance.
#' 
#' During bundling, only the root device volume (C:\\) is bundled. Data on
#' other instance store volumes is not preserved.
#' 
#' This action is not applicable for Linux/Unix instances or Windows
#' instances that are backed by Amazon EBS.
#'
#' @usage
#' ec2_bundle_instance(InstanceId, Storage, DryRun)
#'
#' @param InstanceId &#91;required&#93; The ID of the instance to bundle.
#' 
#' Type: String
#' 
#' Default: None
#' 
#' Required: Yes
#' @param Storage &#91;required&#93; The bucket in which to store the AMI. You can specify a bucket that you
#' already own or a new bucket that Amazon EC2 creates on your behalf. If
#' you specify a bucket that belongs to someone else, Amazon EC2 returns an
#' error.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$bundle_instance(
#'   InstanceId = "string",
#'   Storage = list(
#'     S3 = list(
#'       AWSAccessKeyId = "string",
#'       Bucket = "string",
#'       Prefix = "string",
#'       UploadPolicy = raw,
#'       UploadPolicySignature = "string"
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_bundle_instance
ec2_bundle_instance <- function(InstanceId, Storage, DryRun = NULL) {
  op <- new_operation(
    name = "BundleInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$bundle_instance_input(InstanceId = InstanceId, Storage = Storage, DryRun = DryRun)
  output <- .ec2$bundle_instance_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$bundle_instance <- ec2_bundle_instance

#' Cancels a bundling operation for an instance store-backed Windows
#' instance
#'
#' Cancels a bundling operation for an instance store-backed Windows
#' instance.
#'
#' @usage
#' ec2_cancel_bundle_task(BundleId, DryRun)
#'
#' @param BundleId &#91;required&#93; The ID of the bundle task.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_bundle_task(
#'   BundleId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_bundle_task
ec2_cancel_bundle_task <- function(BundleId, DryRun = NULL) {
  op <- new_operation(
    name = "CancelBundleTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_bundle_task_input(BundleId = BundleId, DryRun = DryRun)
  output <- .ec2$cancel_bundle_task_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_bundle_task <- ec2_cancel_bundle_task

#' Cancels the specified Capacity Reservation, releases the reserved
#' capacity, and changes the Capacity Reservation's state to cancelled
#'
#' Cancels the specified Capacity Reservation, releases the reserved
#' capacity, and changes the Capacity Reservation\'s state to `cancelled`.
#' 
#' Instances running in the reserved capacity continue running until you
#' stop them. Stopped instances that target the Capacity Reservation can no
#' longer launch. Modify these instances to either target a different
#' Capacity Reservation, launch On-Demand Instance capacity, or run in any
#' open Capacity Reservation that has matching attributes and sufficient
#' capacity.
#'
#' @usage
#' ec2_cancel_capacity_reservation(CapacityReservationId, DryRun)
#'
#' @param CapacityReservationId &#91;required&#93; The ID of the Capacity Reservation to be cancelled.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_capacity_reservation(
#'   CapacityReservationId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_capacity_reservation
ec2_cancel_capacity_reservation <- function(CapacityReservationId, DryRun = NULL) {
  op <- new_operation(
    name = "CancelCapacityReservation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_capacity_reservation_input(CapacityReservationId = CapacityReservationId, DryRun = DryRun)
  output <- .ec2$cancel_capacity_reservation_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_capacity_reservation <- ec2_cancel_capacity_reservation

#' Cancels an active conversion task
#'
#' Cancels an active conversion task. The task can be the import of an
#' instance or volume. The action removes all artifacts of the conversion,
#' including a partially uploaded volume or instance. If the conversion is
#' complete or is in the process of transferring the final disk image, the
#' command fails and returns an exception.
#' 
#' For more information, see [Importing a Virtual Machine Using the Amazon
#' EC2
#' CLI](https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html).
#'
#' @usage
#' ec2_cancel_conversion_task(ConversionTaskId, DryRun, ReasonMessage)
#'
#' @param ConversionTaskId &#91;required&#93; The ID of the conversion task.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ReasonMessage The reason for canceling the conversion task.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_conversion_task(
#'   ConversionTaskId = "string",
#'   DryRun = TRUE|FALSE,
#'   ReasonMessage = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_conversion_task
ec2_cancel_conversion_task <- function(ConversionTaskId, DryRun = NULL, ReasonMessage = NULL) {
  op <- new_operation(
    name = "CancelConversionTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_conversion_task_input(ConversionTaskId = ConversionTaskId, DryRun = DryRun, ReasonMessage = ReasonMessage)
  output <- .ec2$cancel_conversion_task_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_conversion_task <- ec2_cancel_conversion_task

#' Cancels an active export task
#'
#' Cancels an active export task. The request removes all artifacts of the
#' export, including any partially-created Amazon S3 objects. If the export
#' task is complete or is in the process of transferring the final disk
#' image, the command fails and returns an error.
#'
#' @usage
#' ec2_cancel_export_task(ExportTaskId)
#'
#' @param ExportTaskId &#91;required&#93; The ID of the export task. This is the ID returned by
#' `CreateInstanceExportTask`.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_export_task(
#'   ExportTaskId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_export_task
ec2_cancel_export_task <- function(ExportTaskId) {
  op <- new_operation(
    name = "CancelExportTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_export_task_input(ExportTaskId = ExportTaskId)
  output <- .ec2$cancel_export_task_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_export_task <- ec2_cancel_export_task

#' Cancels an in-process import virtual machine or import snapshot task
#'
#' Cancels an in-process import virtual machine or import snapshot task.
#'
#' @usage
#' ec2_cancel_import_task(CancelReason, DryRun, ImportTaskId)
#'
#' @param CancelReason The reason for canceling the task.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ImportTaskId The ID of the import image or import snapshot task to be canceled.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_import_task(
#'   CancelReason = "string",
#'   DryRun = TRUE|FALSE,
#'   ImportTaskId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_import_task
ec2_cancel_import_task <- function(CancelReason = NULL, DryRun = NULL, ImportTaskId = NULL) {
  op <- new_operation(
    name = "CancelImportTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_import_task_input(CancelReason = CancelReason, DryRun = DryRun, ImportTaskId = ImportTaskId)
  output <- .ec2$cancel_import_task_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_import_task <- ec2_cancel_import_task

#' Cancels the specified Reserved Instance listing in the Reserved Instance
#' Marketplace
#'
#' Cancels the specified Reserved Instance listing in the Reserved Instance
#' Marketplace.
#' 
#' For more information, see [Reserved Instance
#' Marketplace](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_cancel_reserved_instances_listing(ReservedInstancesListingId)
#'
#' @param ReservedInstancesListingId &#91;required&#93; The ID of the Reserved Instance listing.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_reserved_instances_listing(
#'   ReservedInstancesListingId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_reserved_instances_listing
ec2_cancel_reserved_instances_listing <- function(ReservedInstancesListingId) {
  op <- new_operation(
    name = "CancelReservedInstancesListing",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_reserved_instances_listing_input(ReservedInstancesListingId = ReservedInstancesListingId)
  output <- .ec2$cancel_reserved_instances_listing_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_reserved_instances_listing <- ec2_cancel_reserved_instances_listing

#' Cancels the specified Spot Fleet requests
#'
#' Cancels the specified Spot Fleet requests.
#' 
#' After you cancel a Spot Fleet request, the Spot Fleet launches no new
#' Spot Instances. You must specify whether the Spot Fleet should also
#' terminate its Spot Instances. If you terminate the instances, the Spot
#' Fleet request enters the `cancelled_terminating` state. Otherwise, the
#' Spot Fleet request enters the `cancelled_running` state and the
#' instances continue to run until they are interrupted or you terminate
#' them manually.
#'
#' @usage
#' ec2_cancel_spot_fleet_requests(DryRun, SpotFleetRequestIds,
#'   TerminateInstances)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SpotFleetRequestIds &#91;required&#93; The IDs of the Spot Fleet requests.
#' @param TerminateInstances &#91;required&#93; Indicates whether to terminate instances for a Spot Fleet request if it
#' is canceled successfully.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_spot_fleet_requests(
#'   DryRun = TRUE|FALSE,
#'   SpotFleetRequestIds = list(
#'     "string"
#'   ),
#'   TerminateInstances = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example cancels the specified Spot fleet request and terminates its
#' # associated Spot Instances.
#' \dontrun{svc$cancel_spot_fleet_requests(
#'   SpotFleetRequestIds = list(
#'     "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"
#'   ),
#'   TerminateInstances = TRUE
#' )}
#' 
#' # This example cancels the specified Spot fleet request without
#' # terminating its associated Spot Instances.
#' \dontrun{svc$cancel_spot_fleet_requests(
#'   SpotFleetRequestIds = list(
#'     "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"
#'   ),
#'   TerminateInstances = FALSE
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_spot_fleet_requests
ec2_cancel_spot_fleet_requests <- function(DryRun = NULL, SpotFleetRequestIds, TerminateInstances) {
  op <- new_operation(
    name = "CancelSpotFleetRequests",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_spot_fleet_requests_input(DryRun = DryRun, SpotFleetRequestIds = SpotFleetRequestIds, TerminateInstances = TerminateInstances)
  output <- .ec2$cancel_spot_fleet_requests_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_spot_fleet_requests <- ec2_cancel_spot_fleet_requests

#' Cancels one or more Spot Instance requests
#'
#' Cancels one or more Spot Instance requests.
#' 
#' Canceling a Spot Instance request does not terminate running Spot
#' Instances associated with the request.
#'
#' @usage
#' ec2_cancel_spot_instance_requests(DryRun, SpotInstanceRequestIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SpotInstanceRequestIds &#91;required&#93; One or more Spot Instance request IDs.
#'
#' @section Request syntax:
#' ```
#' svc$cancel_spot_instance_requests(
#'   DryRun = TRUE|FALSE,
#'   SpotInstanceRequestIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example cancels a Spot Instance request.
#' \dontrun{svc$cancel_spot_instance_requests(
#'   SpotInstanceRequestIds = list(
#'     "sir-08b93456"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_cancel_spot_instance_requests
ec2_cancel_spot_instance_requests <- function(DryRun = NULL, SpotInstanceRequestIds) {
  op <- new_operation(
    name = "CancelSpotInstanceRequests",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$cancel_spot_instance_requests_input(DryRun = DryRun, SpotInstanceRequestIds = SpotInstanceRequestIds)
  output <- .ec2$cancel_spot_instance_requests_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$cancel_spot_instance_requests <- ec2_cancel_spot_instance_requests

#' Determines whether a product code is associated with an instance
#'
#' Determines whether a product code is associated with an instance. This
#' action can only be used by the owner of the product code. It is useful
#' when a product code owner must verify whether another user\'s instance
#' is eligible for support.
#'
#' @usage
#' ec2_confirm_product_instance(InstanceId, ProductCode, DryRun)
#'
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param ProductCode &#91;required&#93; The product code. This must be a product code that you own.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$confirm_product_instance(
#'   InstanceId = "string",
#'   ProductCode = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example determines whether the specified product code is associated
#' # with the specified instance.
#' \dontrun{svc$confirm_product_instance(
#'   InstanceId = "i-1234567890abcdef0",
#'   ProductCode = "774F4FF8"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_confirm_product_instance
ec2_confirm_product_instance <- function(InstanceId, ProductCode, DryRun = NULL) {
  op <- new_operation(
    name = "ConfirmProductInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$confirm_product_instance_input(InstanceId = InstanceId, ProductCode = ProductCode, DryRun = DryRun)
  output <- .ec2$confirm_product_instance_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$confirm_product_instance <- ec2_confirm_product_instance

#' Copies the specified Amazon FPGA Image (AFI) to the current Region
#'
#' Copies the specified Amazon FPGA Image (AFI) to the current Region.
#'
#' @usage
#' ec2_copy_fpga_image(DryRun, SourceFpgaImageId, Description, Name,
#'   SourceRegion, ClientToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SourceFpgaImageId &#91;required&#93; The ID of the source AFI.
#' @param Description The description for the new AFI.
#' @param Name The name for the new AFI. The default is the name of the source AFI.
#' @param SourceRegion &#91;required&#93; The Region that contains the source AFI.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
#'
#' @section Request syntax:
#' ```
#' svc$copy_fpga_image(
#'   DryRun = TRUE|FALSE,
#'   SourceFpgaImageId = "string",
#'   Description = "string",
#'   Name = "string",
#'   SourceRegion = "string",
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_copy_fpga_image
ec2_copy_fpga_image <- function(DryRun = NULL, SourceFpgaImageId, Description = NULL, Name = NULL, SourceRegion, ClientToken = NULL) {
  op <- new_operation(
    name = "CopyFpgaImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$copy_fpga_image_input(DryRun = DryRun, SourceFpgaImageId = SourceFpgaImageId, Description = Description, Name = Name, SourceRegion = SourceRegion, ClientToken = ClientToken)
  output <- .ec2$copy_fpga_image_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$copy_fpga_image <- ec2_copy_fpga_image

#' Initiates the copy of an AMI from the specified source Region to the
#' current Region
#'
#' Initiates the copy of an AMI from the specified source Region to the
#' current Region. You specify the destination Region by using its endpoint
#' when making the request.
#' 
#' Copies of encrypted backing snapshots for the AMI are encrypted. Copies
#' of unencrypted backing snapshots remain unencrypted, unless you set
#' `Encrypted` during the copy operation. You cannot create an unencrypted
#' copy of an encrypted backing snapshot.
#' 
#' For more information about the prerequisites and limits when copying an
#' AMI, see [Copying an
#' AMI](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/CopyingAMIs.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_copy_image(ClientToken, Description, Encrypted, KmsKeyId, Name,
#'   SourceImageId, SourceRegion, DryRun)
#'
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure idempotency of
#' the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param Description A description for the new AMI in the destination Region.
#' @param Encrypted Specifies whether the destination snapshots of the copied image should
#' be encrypted. You can encrypt a copy of an unencrypted snapshot, but you
#' cannot create an unencrypted copy of an encrypted snapshot. The default
#' CMK for EBS is used unless you specify a non-default AWS Key Management
#' Service (AWS KMS) CMK using `KmsKeyId`. For more information, see
#' [Amazon EBS
#' Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param KmsKeyId An identifier for the symmetric AWS Key Management Service (AWS KMS)
#' customer master key (CMK) to use when creating the encrypted volume.
#' This parameter is only required if you want to use a non-default CMK; if
#' this parameter is not specified, the default CMK for EBS is used. If a
#' `KmsKeyId` is specified, the `Encrypted` flag must also be set.
#' 
#' To specify a CMK, use its key ID, Amazon Resource Name (ARN), alias
#' name, or alias ARN. When using an alias name, prefix it with \"alias/\".
#' For example:
#' 
#' -   Key ID: `1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Key ARN:
#'     `arn:aws:kms:us-east-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab`
#' 
#' -   Alias name: `alias/ExampleAlias`
#' 
#' -   Alias ARN: `arn:aws:kms:us-east-2:111122223333:alias/ExampleAlias`
#' 
#' AWS parses `KmsKeyId` asynchronously, meaning that the action you call
#' may appear to complete even though you provided an invalid identifier.
#' This action will eventually report failure.
#' 
#' The specified CMK must exist in the Region that the snapshot is being
#' copied to.
#' 
#' Amazon EBS does not support asymmetric CMKs.
#' @param Name &#91;required&#93; The name of the new AMI in the destination Region.
#' @param SourceImageId &#91;required&#93; The ID of the AMI to copy.
#' @param SourceRegion &#91;required&#93; The name of the Region that contains the AMI to copy.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$copy_image(
#'   ClientToken = "string",
#'   Description = "string",
#'   Encrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   Name = "string",
#'   SourceImageId = "string",
#'   SourceRegion = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example copies the specified AMI from the us-east-1 region to the
#' # current region.
#' \dontrun{svc$copy_image(
#'   Description = "",
#'   Name = "My server",
#'   SourceImageId = "ami-5731123e",
#'   SourceRegion = "us-east-1"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_copy_image
ec2_copy_image <- function(ClientToken = NULL, Description = NULL, Encrypted = NULL, KmsKeyId = NULL, Name, SourceImageId, SourceRegion, DryRun = NULL) {
  op <- new_operation(
    name = "CopyImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$copy_image_input(ClientToken = ClientToken, Description = Description, Encrypted = Encrypted, KmsKeyId = KmsKeyId, Name = Name, SourceImageId = SourceImageId, SourceRegion = SourceRegion, DryRun = DryRun)
  output <- .ec2$copy_image_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$copy_image <- ec2_copy_image

#' Copies a point-in-time snapshot of an EBS volume and stores it in Amazon
#' S3
#'
#' Copies a point-in-time snapshot of an EBS volume and stores it in Amazon
#' S3. You can copy the snapshot within the same Region or from one Region
#' to another. You can use the snapshot to create EBS volumes or Amazon
#' Machine Images (AMIs).
#' 
#' Copies of encrypted EBS snapshots remain encrypted. Copies of
#' unencrypted snapshots remain unencrypted, unless you enable encryption
#' for the snapshot copy operation. By default, encrypted snapshot copies
#' use the default AWS Key Management Service (AWS KMS) customer master key
#' (CMK); however, you can specify a different CMK.
#' 
#' To copy an encrypted snapshot that has been shared from another account,
#' you must have permissions for the CMK used to encrypt the snapshot.
#' 
#' Snapshots created by copying another snapshot have an arbitrary volume
#' ID that should not be used for any purpose.
#' 
#' For more information, see [Copying an Amazon EBS
#' Snapshot](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-copy-snapshot.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_copy_snapshot(Description, DestinationRegion, Encrypted, KmsKeyId,
#'   PresignedUrl, SourceRegion, SourceSnapshotId, TagSpecifications, DryRun)
#'
#' @param Description A description for the EBS snapshot.
#' @param DestinationRegion The destination Region to use in the `PresignedUrl` parameter of a
#' snapshot copy operation. This parameter is only valid for specifying the
#' destination Region in a `PresignedUrl` parameter, where it is required.
#' 
#' The snapshot copy is sent to the regional endpoint that you sent the
#' HTTP request to (for example, `ec2.us-east-1.amazonaws.com`). With the
#' AWS CLI, this is specified using the `--region` parameter or the default
#' Region in your AWS configuration file.
#' @param Encrypted To encrypt a copy of an unencrypted snapshot if encryption by default is
#' not enabled, enable encryption using this parameter. Otherwise, omit
#' this parameter. Encrypted snapshots are encrypted, even if you omit this
#' parameter and encryption by default is not enabled. You cannot set this
#' parameter to false. For more information, see [Amazon EBS
#' Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param KmsKeyId The identifier of the AWS Key Management Service (AWS KMS) customer
#' master key (CMK) to use for Amazon EBS encryption. If this parameter is
#' not specified, your AWS managed CMK for EBS is used. If `KmsKeyId` is
#' specified, the encrypted state must be `true`.
#' 
#' You can specify the CMK using any of the following:
#' 
#' -   Key ID. For example, key/1234abcd-12ab-34cd-56ef-1234567890ab.
#' 
#' -   Key alias. For example, alias/ExampleAlias.
#' 
#' -   Key ARN. For example,
#'     arn:aws:kms:*us-east-1*:*012345678910*:key/*abcd1234-a123-456a-a12b-a123b4cd56ef*.
#' 
#' -   Alias ARN. For example,
#'     arn:aws:kms:*us-east-1*:*012345678910*:alias/*ExampleAlias*.
#' 
#' AWS authenticates the CMK asynchronously. Therefore, if you specify an
#' ID, alias, or ARN that is not valid, the action can appear to complete,
#' but eventually fails.
#' @param PresignedUrl When you copy an encrypted source snapshot using the Amazon EC2 Query
#' API, you must supply a pre-signed URL. This parameter is optional for
#' unencrypted snapshots. For more information, see [Query
#' Requests](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Query-Requests.html).
#' 
#' The `PresignedUrl` should use the snapshot source endpoint, the
#' `CopySnapshot` action, and include the `SourceRegion`,
#' `SourceSnapshotId`, and `DestinationRegion` parameters. The
#' `PresignedUrl` must be signed using AWS Signature Version 4. Because EBS
#' snapshots are stored in Amazon S3, the signing algorithm for this
#' parameter uses the same logic that is described in [Authenticating
#' Requests by Using Query Parameters (AWS Signature Version
#' 4)](https://docs.aws.amazon.com/AmazonS3/latest/API/sigv4-query-string-auth.html)
#' in the *Amazon Simple Storage Service API Reference*. An invalid or
#' improperly signed `PresignedUrl` will cause the copy operation to fail
#' asynchronously, and the snapshot will move to an `error` state.
#' @param SourceRegion &#91;required&#93; The ID of the Region that contains the snapshot to be copied.
#' @param SourceSnapshotId &#91;required&#93; The ID of the EBS snapshot to copy.
#' @param TagSpecifications The tags to apply to the new snapshot.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$copy_snapshot(
#'   Description = "string",
#'   DestinationRegion = "string",
#'   Encrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   PresignedUrl = "string",
#'   SourceRegion = "string",
#'   SourceSnapshotId = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example copies a snapshot with the snapshot ID of
#' # `snap-066877671789bd71b` from the `us-west-2` region to the
#' # `us-east-1` region and adds a short description to identify the
#' # snapshot.
#' \dontrun{svc$copy_snapshot(
#'   Description = "This is my copied snapshot.",
#'   DestinationRegion = "us-east-1",
#'   SourceRegion = "us-west-2",
#'   SourceSnapshotId = "snap-066877671789bd71b"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_copy_snapshot
ec2_copy_snapshot <- function(Description = NULL, DestinationRegion = NULL, Encrypted = NULL, KmsKeyId = NULL, PresignedUrl = NULL, SourceRegion, SourceSnapshotId, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CopySnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$copy_snapshot_input(Description = Description, DestinationRegion = DestinationRegion, Encrypted = Encrypted, KmsKeyId = KmsKeyId, PresignedUrl = PresignedUrl, SourceRegion = SourceRegion, SourceSnapshotId = SourceSnapshotId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$copy_snapshot_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$copy_snapshot <- ec2_copy_snapshot

#' Creates a new Capacity Reservation with the specified attributes
#'
#' Creates a new Capacity Reservation with the specified attributes.
#' 
#' Capacity Reservations enable you to reserve capacity for your Amazon EC2
#' instances in a specific Availability Zone for any duration. This gives
#' you the flexibility to selectively add capacity reservations and still
#' get the Regional RI discounts for that usage. By creating Capacity
#' Reservations, you ensure that you always have access to Amazon EC2
#' capacity when you need it, for as long as you need it. For more
#' information, see [Capacity
#' Reservations](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-capacity-reservations.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' Your request to create a Capacity Reservation could fail if Amazon EC2
#' does not have sufficient capacity to fulfill the request. If your
#' request fails due to Amazon EC2 capacity constraints, either try again
#' at a later time, try in a different Availability Zone, or request a
#' smaller capacity reservation. If your application is flexible across
#' instance types and sizes, try to create a Capacity Reservation with
#' different instance attributes.
#' 
#' Your request could also fail if the requested quantity exceeds your
#' On-Demand Instance limit for the selected instance type. If your request
#' fails due to limit constraints, increase your On-Demand Instance limit
#' for the required instance type and try again. For more information about
#' increasing your instance limits, see [Amazon EC2 Service
#' Limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-resource-limits.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_capacity_reservation(ClientToken, InstanceType,
#'   InstancePlatform, AvailabilityZone, AvailabilityZoneId, Tenancy,
#'   InstanceCount, EbsOptimized, EphemeralStorage, EndDate, EndDateType,
#'   InstanceMatchCriteria, TagSpecifications, DryRun)
#'
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' 
#' Constraint: Maximum 64 ASCII characters.
#' @param InstanceType &#91;required&#93; The instance type for which to reserve capacity. For more information,
#' see [Instance
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param InstancePlatform &#91;required&#93; The type of operating system for which to reserve capacity.
#' @param AvailabilityZone The Availability Zone in which to create the Capacity Reservation.
#' @param AvailabilityZoneId The ID of the Availability Zone in which to create the Capacity
#' Reservation.
#' @param Tenancy Indicates the tenancy of the Capacity Reservation. A Capacity
#' Reservation can have one of the following tenancy settings:
#' 
#' -   `default` - The Capacity Reservation is created on hardware that is
#'     shared with other AWS accounts.
#' 
#' -   `dedicated` - The Capacity Reservation is created on single-tenant
#'     hardware that is dedicated to a single AWS account.
#' @param InstanceCount &#91;required&#93; The number of instances for which to reserve capacity.
#' @param EbsOptimized Indicates whether the Capacity Reservation supports EBS-optimized
#' instances. This optimization provides dedicated throughput to Amazon EBS
#' and an optimized configuration stack to provide optimal I/O performance.
#' This optimization isn\'t available with all instance types. Additional
#' usage charges apply when using an EBS- optimized instance.
#' @param EphemeralStorage Indicates whether the Capacity Reservation supports instances with
#' temporary, block-level storage.
#' @param EndDate The date and time at which the Capacity Reservation expires. When a
#' Capacity Reservation expires, the reserved capacity is released and you
#' can no longer launch instances into it. The Capacity Reservation\'s
#' state changes to `expired` when it reaches its end date and time.
#' 
#' You must provide an `EndDate` value if `EndDateType` is `limited`. Omit
#' `EndDate` if `EndDateType` is `unlimited`.
#' 
#' If the `EndDateType` is `limited`, the Capacity Reservation is cancelled
#' within an hour from the specified time. For example, if you specify
#' 5/31/2019, 13:30:55, the Capacity Reservation is guaranteed to end
#' between 13:30:55 and 14:30:55 on 5/31/2019.
#' @param EndDateType Indicates the way in which the Capacity Reservation ends. A Capacity
#' Reservation can have one of the following end types:
#' 
#' -   `unlimited` - The Capacity Reservation remains active until you
#'     explicitly cancel it. Do not provide an `EndDate` if the
#'     `EndDateType` is `unlimited`.
#' 
#' -   `limited` - The Capacity Reservation expires automatically at a
#'     specified date and time. You must provide an `EndDate` value if the
#'     `EndDateType` value is `limited`.
#' @param InstanceMatchCriteria Indicates the type of instance launches that the Capacity Reservation
#' accepts. The options include:
#' 
#' -   `open` - The Capacity Reservation automatically matches all
#'     instances that have matching attributes (instance type, platform,
#'     and Availability Zone). Instances that have matching attributes run
#'     in the Capacity Reservation automatically without specifying any
#'     additional parameters.
#' 
#' -   `targeted` - The Capacity Reservation only accepts instances that
#'     have matching attributes (instance type, platform, and Availability
#'     Zone), and explicitly target the Capacity Reservation. This ensures
#'     that only permitted instances can use the reserved capacity.
#' 
#' Default: `open`
#' @param TagSpecifications The tags to apply to the Capacity Reservation during launch.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_capacity_reservation(
#'   ClientToken = "string",
#'   InstanceType = "string",
#'   InstancePlatform = "Linux/UNIX"|"Red Hat Enterprise Linux"|"SUSE Linux"|"Windows"|"Windows with SQL Server"|"Windows with SQL Server Enterprise"|"Windows with SQL Server Standard"|"Windows with SQL Server Web"|"Linux with SQL Server Standard"|"Linux with SQL Server Web"|"Linux with SQL Server Enterprise",
#'   AvailabilityZone = "string",
#'   AvailabilityZoneId = "string",
#'   Tenancy = "default"|"dedicated",
#'   InstanceCount = 123,
#'   EbsOptimized = TRUE|FALSE,
#'   EphemeralStorage = TRUE|FALSE,
#'   EndDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndDateType = "unlimited"|"limited",
#'   InstanceMatchCriteria = "open"|"targeted",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_capacity_reservation
ec2_create_capacity_reservation <- function(ClientToken = NULL, InstanceType, InstancePlatform, AvailabilityZone = NULL, AvailabilityZoneId = NULL, Tenancy = NULL, InstanceCount, EbsOptimized = NULL, EphemeralStorage = NULL, EndDate = NULL, EndDateType = NULL, InstanceMatchCriteria = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateCapacityReservation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_capacity_reservation_input(ClientToken = ClientToken, InstanceType = InstanceType, InstancePlatform = InstancePlatform, AvailabilityZone = AvailabilityZone, AvailabilityZoneId = AvailabilityZoneId, Tenancy = Tenancy, InstanceCount = InstanceCount, EbsOptimized = EbsOptimized, EphemeralStorage = EphemeralStorage, EndDate = EndDate, EndDateType = EndDateType, InstanceMatchCriteria = InstanceMatchCriteria, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_capacity_reservation_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_capacity_reservation <- ec2_create_capacity_reservation

#' Creates a Client VPN endpoint
#'
#' Creates a Client VPN endpoint. A Client VPN endpoint is the resource you
#' create and configure to enable and manage client VPN sessions. It is the
#' destination endpoint at which all client VPN sessions are terminated.
#'
#' @usage
#' ec2_create_client_vpn_endpoint(ClientCidrBlock, ServerCertificateArn,
#'   AuthenticationOptions, ConnectionLogOptions, DnsServers,
#'   TransportProtocol, Description, SplitTunnel, DryRun, ClientToken,
#'   TagSpecifications)
#'
#' @param ClientCidrBlock &#91;required&#93; The IPv4 address range, in CIDR notation, from which to assign client IP
#' addresses. The address range cannot overlap with the local CIDR of the
#' VPC in which the associated subnet is located, or the routes that you
#' add manually. The address range cannot be changed after the Client VPN
#' endpoint has been created. The CIDR block should be /22 or greater.
#' @param ServerCertificateArn &#91;required&#93; The ARN of the server certificate. For more information, see the [AWS
#' Certificate Manager User
#' Guide](https://docs.aws.amazon.com/acm/latest/userguide/).
#' @param AuthenticationOptions &#91;required&#93; Information about the authentication method to be used to authenticate
#' clients.
#' @param ConnectionLogOptions &#91;required&#93; Information about the client connection logging options.
#' 
#' If you enable client connection logging, data about client connections
#' is sent to a Cloudwatch Logs log stream. The following information is
#' logged:
#' 
#' -   Client connection requests
#' 
#' -   Client connection results (successful and unsuccessful)
#' 
#' -   Reasons for unsuccessful client connection requests
#' 
#' -   Client connection termination time
#' @param DnsServers Information about the DNS servers to be used for DNS resolution. A
#' Client VPN endpoint can have up to two DNS servers. If no DNS server is
#' specified, the DNS address configured on the device is used for the DNS
#' server.
#' @param TransportProtocol The transport protocol to be used by the VPN session.
#' 
#' Default value: `udp`
#' @param Description A brief description of the Client VPN endpoint.
#' @param SplitTunnel Indicates whether split-tunnel is enabled on the AWS Client VPN
#' endpoint.
#' 
#' By default, split-tunnel on a VPN endpoint is disabled.
#' 
#' For information about split-tunnel VPN endpoints, see [Split-Tunnel AWS
#' Client VPN
#' Endpoint](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html)
#' in the *AWS Client VPN Administrator Guide*.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param TagSpecifications The tags to apply to the Client VPN endpoint during creation.
#'
#' @section Request syntax:
#' ```
#' svc$create_client_vpn_endpoint(
#'   ClientCidrBlock = "string",
#'   ServerCertificateArn = "string",
#'   AuthenticationOptions = list(
#'     list(
#'       Type = "certificate-authentication"|"directory-service-authentication",
#'       ActiveDirectory = list(
#'         DirectoryId = "string"
#'       ),
#'       MutualAuthentication = list(
#'         ClientRootCertificateChainArn = "string"
#'       )
#'     )
#'   ),
#'   ConnectionLogOptions = list(
#'     Enabled = TRUE|FALSE,
#'     CloudwatchLogGroup = "string",
#'     CloudwatchLogStream = "string"
#'   ),
#'   DnsServers = list(
#'     "string"
#'   ),
#'   TransportProtocol = "tcp"|"udp",
#'   Description = "string",
#'   SplitTunnel = TRUE|FALSE,
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_client_vpn_endpoint
ec2_create_client_vpn_endpoint <- function(ClientCidrBlock, ServerCertificateArn, AuthenticationOptions, ConnectionLogOptions, DnsServers = NULL, TransportProtocol = NULL, Description = NULL, SplitTunnel = NULL, DryRun = NULL, ClientToken = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateClientVpnEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_client_vpn_endpoint_input(ClientCidrBlock = ClientCidrBlock, ServerCertificateArn = ServerCertificateArn, AuthenticationOptions = AuthenticationOptions, ConnectionLogOptions = ConnectionLogOptions, DnsServers = DnsServers, TransportProtocol = TransportProtocol, Description = Description, SplitTunnel = SplitTunnel, DryRun = DryRun, ClientToken = ClientToken, TagSpecifications = TagSpecifications)
  output <- .ec2$create_client_vpn_endpoint_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_client_vpn_endpoint <- ec2_create_client_vpn_endpoint

#' Adds a route to a network to a Client VPN endpoint
#'
#' Adds a route to a network to a Client VPN endpoint. Each Client VPN
#' endpoint has a route table that describes the available destination
#' network routes. Each route in the route table specifies the path for
#' traï¬ƒc to speciï¬c resources or networks.
#'
#' @usage
#' ec2_create_client_vpn_route(ClientVpnEndpointId, DestinationCidrBlock,
#'   TargetVpcSubnetId, Description, ClientToken, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint to which to add the route.
#' @param DestinationCidrBlock &#91;required&#93; The IPv4 address range, in CIDR notation, of the route destination. For
#' example:
#' 
#' -   To add a route for Internet access, enter `0.0.0.0/0`
#' 
#' -   To add a route for a peered VPC, enter the peered VPC\'s IPv4 CIDR
#'     range
#' 
#' -   To add a route for an on-premises network, enter the AWS
#'     Site-to-Site VPN connection\'s IPv4 CIDR range
#' 
#' Route address ranges cannot overlap with the CIDR range specified for
#' client allocation.
#' @param TargetVpcSubnetId &#91;required&#93; The ID of the subnet through which you want to route traffic. The
#' specified subnet must be an existing target network of the Client VPN
#' endpoint.
#' @param Description A brief description of the route.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_client_vpn_route(
#'   ClientVpnEndpointId = "string",
#'   DestinationCidrBlock = "string",
#'   TargetVpcSubnetId = "string",
#'   Description = "string",
#'   ClientToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_client_vpn_route
ec2_create_client_vpn_route <- function(ClientVpnEndpointId, DestinationCidrBlock, TargetVpcSubnetId, Description = NULL, ClientToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateClientVpnRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_client_vpn_route_input(ClientVpnEndpointId = ClientVpnEndpointId, DestinationCidrBlock = DestinationCidrBlock, TargetVpcSubnetId = TargetVpcSubnetId, Description = Description, ClientToken = ClientToken, DryRun = DryRun)
  output <- .ec2$create_client_vpn_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_client_vpn_route <- ec2_create_client_vpn_route

#' Provides information to AWS about your VPN customer gateway device
#'
#' Provides information to AWS about your VPN customer gateway device. The
#' customer gateway is the appliance at your end of the VPN connection.
#' (The device on the AWS side of the VPN connection is the virtual private
#' gateway.) You must provide the Internet-routable IP address of the
#' customer gateway\'s external interface. The IP address must be static
#' and can be behind a device performing network address translation (NAT).
#' 
#' For devices that use Border Gateway Protocol (BGP), you can also provide
#' the device\'s BGP Autonomous System Number (ASN). You can use an
#' existing ASN assigned to your network. If you don\'t have an ASN
#' already, you can use a private ASN (in the 64512 - 65534 range).
#' 
#' Amazon EC2 supports all 2-byte ASN numbers in the range of 1 - 65534,
#' with the exception of 7224, which is reserved in the `us-east-1` Region,
#' and 9059, which is reserved in the `eu-west-1` Region.
#' 
#' For more information, see [AWS Site-to-Site
#' VPN](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the
#' *AWS Site-to-Site VPN User Guide*.
#' 
#' To create more than one customer gateway with the same VPN type, IP
#' address, and BGP ASN, specify a unique device name for each customer
#' gateway. Identical requests return information about the existing
#' customer gateway and do not create new customer gateways.
#'
#' @usage
#' ec2_create_customer_gateway(BgpAsn, PublicIp, CertificateArn, Type,
#'   DeviceName, DryRun)
#'
#' @param BgpAsn &#91;required&#93; For devices that support BGP, the customer gateway\'s BGP ASN.
#' 
#' Default: 65000
#' @param PublicIp The Internet-routable IP address for the customer gateway\'s outside
#' interface. The address must be static.
#' @param CertificateArn The Amazon Resource Name (ARN) for the customer gateway certificate.
#' @param Type &#91;required&#93; The type of VPN connection that this customer gateway supports
#' (`ipsec.1`).
#' @param DeviceName A name for the customer gateway device.
#' 
#' Length Constraints: Up to 255 characters.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_customer_gateway(
#'   BgpAsn = 123,
#'   PublicIp = "string",
#'   CertificateArn = "string",
#'   Type = "ipsec.1",
#'   DeviceName = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example creates a customer gateway with the specified IP address
#' # for its outside interface.
#' \dontrun{svc$create_customer_gateway(
#'   BgpAsn = 65534L,
#'   PublicIp = "12.1.2.3",
#'   Type = "ipsec.1"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_customer_gateway
ec2_create_customer_gateway <- function(BgpAsn, PublicIp = NULL, CertificateArn = NULL, Type, DeviceName = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateCustomerGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_customer_gateway_input(BgpAsn = BgpAsn, PublicIp = PublicIp, CertificateArn = CertificateArn, Type = Type, DeviceName = DeviceName, DryRun = DryRun)
  output <- .ec2$create_customer_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_customer_gateway <- ec2_create_customer_gateway

#' Creates a default subnet with a size /20 IPv4 CIDR block in the
#' specified Availability Zone in your default VPC
#'
#' Creates a default subnet with a size `/20` IPv4 CIDR block in the
#' specified Availability Zone in your default VPC. You can have only one
#' default subnet per Availability Zone. For more information, see
#' [Creating a Default
#' Subnet](https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html#create-default-subnet)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_default_subnet(AvailabilityZone, DryRun)
#'
#' @param AvailabilityZone &#91;required&#93; The Availability Zone in which to create the default subnet.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_default_subnet(
#'   AvailabilityZone = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_default_subnet
ec2_create_default_subnet <- function(AvailabilityZone, DryRun = NULL) {
  op <- new_operation(
    name = "CreateDefaultSubnet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_default_subnet_input(AvailabilityZone = AvailabilityZone, DryRun = DryRun)
  output <- .ec2$create_default_subnet_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_default_subnet <- ec2_create_default_subnet

#' Creates a default VPC with a size /16 IPv4 CIDR block and a default
#' subnet in each Availability Zone
#'
#' Creates a default VPC with a size `/16` IPv4 CIDR block and a default
#' subnet in each Availability Zone. For more information about the
#' components of a default VPC, see [Default VPC and Default
#' Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/default-vpc.html)
#' in the *Amazon Virtual Private Cloud User Guide*. You cannot specify the
#' components of the default VPC yourself.
#' 
#' If you deleted your previous default VPC, you can create a default VPC.
#' You cannot have more than one default VPC per Region.
#' 
#' If your account supports EC2-Classic, you cannot use this action to
#' create a default VPC in a Region that supports EC2-Classic. If you want
#' a default VPC in a Region that supports EC2-Classic, see \"I really want
#' a default VPC for my existing EC2 account. Is that possible?\" in the
#' [Default VPCs FAQ](http://aws.amazon.com/vpc/faqs/#Default_VPCs).
#'
#' @usage
#' ec2_create_default_vpc(DryRun)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_default_vpc(
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_default_vpc
ec2_create_default_vpc <- function(DryRun = NULL) {
  op <- new_operation(
    name = "CreateDefaultVpc",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_default_vpc_input(DryRun = DryRun)
  output <- .ec2$create_default_vpc_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_default_vpc <- ec2_create_default_vpc

#' Creates a set of DHCP options for your VPC
#'
#' Creates a set of DHCP options for your VPC. After creating the set, you
#' must associate it with the VPC, causing all existing and new instances
#' that you launch in the VPC to use this set of DHCP options. The
#' following are the individual DHCP options you can specify. For more
#' information about the options, see [RFC
#' 2132](http://www.ietf.org/rfc/rfc2132.txt).
#' 
#' -   `domain-name-servers` - The IP addresses of up to four domain name
#'     servers, or AmazonProvidedDNS. The default DHCP option set specifies
#'     AmazonProvidedDNS. If specifying more than one domain name server,
#'     specify the IP addresses in a single parameter, separated by commas.
#'     To have your instance receive a custom DNS hostname as specified in
#'     `domain-name`, you must set `domain-name-servers` to a custom DNS
#'     server.
#' 
#' -   `domain-name` - If you\'re using AmazonProvidedDNS in `us-east-1`,
#'     specify `ec2.internal`. If you\'re using AmazonProvidedDNS in
#'     another Region, specify `region.compute.internal` (for example,
#'     `ap-northeast-1.compute.internal`). Otherwise, specify a domain name
#'     (for example, `MyCompany.com`). This value is used to complete
#'     unqualified DNS hostnames. **Important**: Some Linux operating
#'     systems accept multiple domain names separated by spaces. However,
#'     Windows and other Linux operating systems treat the value as a
#'     single domain, which results in unexpected behavior. If your DHCP
#'     options set is associated with a VPC that has instances with
#'     multiple operating systems, specify only one domain name.
#' 
#' -   `ntp-servers` - The IP addresses of up to four Network Time Protocol
#'     (NTP) servers.
#' 
#' -   `netbios-name-servers` - The IP addresses of up to four NetBIOS name
#'     servers.
#' 
#' -   `netbios-node-type` - The NetBIOS node type (1, 2, 4, or 8). We
#'     recommend that you specify 2 (broadcast and multicast are not
#'     currently supported). For more information about these node types,
#'     see [RFC 2132](http://www.ietf.org/rfc/rfc2132.txt).
#' 
#' Your VPC automatically starts out with a set of DHCP options that
#' includes only a DNS server that we provide (AmazonProvidedDNS). If you
#' create a set of options, and if your VPC has an internet gateway, make
#' sure to set the `domain-name-servers` option either to
#' `AmazonProvidedDNS` or to a domain name server of your choice. For more
#' information, see [DHCP Options
#' Sets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_dhcp_options(DhcpConfigurations, DryRun)
#'
#' @param DhcpConfigurations &#91;required&#93; A DHCP configuration option.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_dhcp_options(
#'   DhcpConfigurations = list(
#'     list(
#'       Key = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example creates a DHCP options set.
#' \dontrun{svc$create_dhcp_options(
#'   DhcpConfigurations = list(
#'     list(
#'       Key = "domain-name-servers",
#'       Values = list(
#'         "10.2.5.1",
#'         "10.2.5.2"
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_dhcp_options
ec2_create_dhcp_options <- function(DhcpConfigurations, DryRun = NULL) {
  op <- new_operation(
    name = "CreateDhcpOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_dhcp_options_input(DhcpConfigurations = DhcpConfigurations, DryRun = DryRun)
  output <- .ec2$create_dhcp_options_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_dhcp_options <- ec2_create_dhcp_options

#' &#91;IPv6 only&#93; Creates an egress-only internet gateway for your VPC
#'
#' \[IPv6 only\] Creates an egress-only internet gateway for your VPC. An
#' egress-only internet gateway is used to enable outbound communication
#' over IPv6 from instances in your VPC to the internet, and prevents hosts
#' outside of your VPC from initiating an IPv6 connection with your
#' instance.
#'
#' @usage
#' ec2_create_egress_only_internet_gateway(ClientToken, DryRun, VpcId)
#'
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcId &#91;required&#93; The ID of the VPC for which to create the egress-only internet gateway.
#'
#' @section Request syntax:
#' ```
#' svc$create_egress_only_internet_gateway(
#'   ClientToken = "string",
#'   DryRun = TRUE|FALSE,
#'   VpcId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_egress_only_internet_gateway
ec2_create_egress_only_internet_gateway <- function(ClientToken = NULL, DryRun = NULL, VpcId) {
  op <- new_operation(
    name = "CreateEgressOnlyInternetGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_egress_only_internet_gateway_input(ClientToken = ClientToken, DryRun = DryRun, VpcId = VpcId)
  output <- .ec2$create_egress_only_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_egress_only_internet_gateway <- ec2_create_egress_only_internet_gateway

#' Launches an EC2 Fleet
#'
#' Launches an EC2 Fleet.
#' 
#' You can create a single EC2 Fleet that includes multiple launch
#' specifications that vary by instance type, AMI, Availability Zone, or
#' subnet.
#' 
#' For more information, see [Launching an EC2
#' Fleet](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_fleet(DryRun, ClientToken, SpotOptions, OnDemandOptions,
#'   ExcessCapacityTerminationPolicy, LaunchTemplateConfigs,
#'   TargetCapacitySpecification, TerminateInstancesWithExpiration, Type,
#'   ValidFrom, ValidUntil, ReplaceUnhealthyInstances, TagSpecifications)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param SpotOptions Describes the configuration of Spot Instances in an EC2 Fleet.
#' @param OnDemandOptions Describes the configuration of On-Demand Instances in an EC2 Fleet.
#' @param ExcessCapacityTerminationPolicy Indicates whether running instances should be terminated if the total
#' target capacity of the EC2 Fleet is decreased below the current size of
#' the EC2 Fleet.
#' @param LaunchTemplateConfigs &#91;required&#93; The configuration for the EC2 Fleet.
#' @param TargetCapacitySpecification &#91;required&#93; The number of units to request.
#' @param TerminateInstancesWithExpiration Indicates whether running instances should be terminated when the EC2
#' Fleet expires.
#' @param Type The type of the request. By default, the EC2 Fleet places an
#' asynchronous request for your desired capacity, and maintains it by
#' replenishing interrupted Spot Instances (`maintain`). A value of
#' `instant` places a synchronous one-time request, and returns errors for
#' any instances that could not be launched. A value of `request` places an
#' asynchronous one-time request without maintaining capacity or submitting
#' requests in alternative capacity pools if capacity is unavailable. For
#' more information, see [EC2 Fleet Request
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-fleet-configuration-strategies.html#ec2-fleet-request-type)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param ValidFrom The start date and time of the request, in UTC format (for example,
#' *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z). The default is to start fulfilling
#' the request immediately.
#' @param ValidUntil The end date and time of the request, in UTC format (for example,
#' *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z). At this point, no new EC2 Fleet
#' requests are placed or able to fulfill the request. If no value is
#' specified, the request remains until you cancel it.
#' @param ReplaceUnhealthyInstances Indicates whether EC2 Fleet should replace unhealthy instances.
#' @param TagSpecifications The key-value pair for tagging the EC2 Fleet request on creation. The
#' value for `ResourceType` must be `fleet`, otherwise the fleet request
#' fails. To tag instances at launch, specify the tags in the [launch
#' template](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-launch-templates.html#create-launch-template).
#' For information about tagging after launch, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html#tag-resources).
#'
#' @section Request syntax:
#' ```
#' svc$create_fleet(
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string",
#'   SpotOptions = list(
#'     AllocationStrategy = "lowest-price"|"diversified"|"capacity-optimized",
#'     InstanceInterruptionBehavior = "hibernate"|"stop"|"terminate",
#'     InstancePoolsToUseCount = 123,
#'     SingleInstanceType = TRUE|FALSE,
#'     SingleAvailabilityZone = TRUE|FALSE,
#'     MinTargetCapacity = 123,
#'     MaxTotalPrice = "string"
#'   ),
#'   OnDemandOptions = list(
#'     AllocationStrategy = "lowest-price"|"prioritized",
#'     CapacityReservationOptions = list(
#'       UsageStrategy = "use-capacity-reservations-first"
#'     ),
#'     SingleInstanceType = TRUE|FALSE,
#'     SingleAvailabilityZone = TRUE|FALSE,
#'     MinTargetCapacity = 123,
#'     MaxTotalPrice = "string"
#'   ),
#'   ExcessCapacityTerminationPolicy = "no-termination"|"termination",
#'   LaunchTemplateConfigs = list(
#'     list(
#'       LaunchTemplateSpecification = list(
#'         LaunchTemplateId = "string",
#'         LaunchTemplateName = "string",
#'         Version = "string"
#'       ),
#'       Overrides = list(
#'         list(
#'           InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge",
#'           MaxPrice = "string",
#'           SubnetId = "string",
#'           AvailabilityZone = "string",
#'           WeightedCapacity = 123.0,
#'           Priority = 123.0,
#'           Placement = list(
#'             AvailabilityZone = "string",
#'             Affinity = "string",
#'             GroupName = "string",
#'             PartitionNumber = 123,
#'             HostId = "string",
#'             Tenancy = "default"|"dedicated"|"host",
#'             SpreadDomain = "string",
#'             HostResourceGroupArn = "string"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   TargetCapacitySpecification = list(
#'     TotalTargetCapacity = 123,
#'     OnDemandTargetCapacity = 123,
#'     SpotTargetCapacity = 123,
#'     DefaultTargetCapacityType = "spot"|"on-demand"
#'   ),
#'   TerminateInstancesWithExpiration = TRUE|FALSE,
#'   Type = "request"|"maintain"|"instant",
#'   ValidFrom = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ValidUntil = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   ReplaceUnhealthyInstances = TRUE|FALSE,
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_fleet
ec2_create_fleet <- function(DryRun = NULL, ClientToken = NULL, SpotOptions = NULL, OnDemandOptions = NULL, ExcessCapacityTerminationPolicy = NULL, LaunchTemplateConfigs, TargetCapacitySpecification, TerminateInstancesWithExpiration = NULL, Type = NULL, ValidFrom = NULL, ValidUntil = NULL, ReplaceUnhealthyInstances = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_fleet_input(DryRun = DryRun, ClientToken = ClientToken, SpotOptions = SpotOptions, OnDemandOptions = OnDemandOptions, ExcessCapacityTerminationPolicy = ExcessCapacityTerminationPolicy, LaunchTemplateConfigs = LaunchTemplateConfigs, TargetCapacitySpecification = TargetCapacitySpecification, TerminateInstancesWithExpiration = TerminateInstancesWithExpiration, Type = Type, ValidFrom = ValidFrom, ValidUntil = ValidUntil, ReplaceUnhealthyInstances = ReplaceUnhealthyInstances, TagSpecifications = TagSpecifications)
  output <- .ec2$create_fleet_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_fleet <- ec2_create_fleet

#' Creates one or more flow logs to capture information about IP traffic
#' for a specific network interface, subnet, or VPC
#'
#' Creates one or more flow logs to capture information about IP traffic
#' for a specific network interface, subnet, or VPC.
#' 
#' Flow log data for a monitored network interface is recorded as flow log
#' records, which are log events consisting of fields that describe the
#' traffic flow. For more information, see [Flow Log
#' Records](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' 
#' When publishing to CloudWatch Logs, flow log records are published to a
#' log group, and each network interface has a unique log stream in the log
#' group. When publishing to Amazon S3, flow log records for all of the
#' monitored network interfaces are published to a single log file object
#' that is stored in the specified bucket.
#' 
#' For more information, see [VPC Flow
#' Logs](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_flow_logs(DryRun, ClientToken, DeliverLogsPermissionArn,
#'   LogGroupName, ResourceIds, ResourceType, TrafficType,
#'   LogDestinationType, LogDestination, LogFormat)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
#' @param DeliverLogsPermissionArn The ARN for the IAM role that permits Amazon EC2 to publish flow logs to
#' a CloudWatch Logs log group in your account.
#' 
#' If you specify `LogDestinationType` as `s3`, do not specify
#' `DeliverLogsPermissionArn` or `LogGroupName`.
#' @param LogGroupName The name of a new or existing CloudWatch Logs log group where Amazon EC2
#' publishes your flow logs.
#' 
#' If you specify `LogDestinationType` as `s3`, do not specify
#' `DeliverLogsPermissionArn` or `LogGroupName`.
#' @param ResourceIds &#91;required&#93; The ID of the subnet, network interface, or VPC for which you want to
#' create a flow log.
#' 
#' Constraints: Maximum of 1000 resources
#' @param ResourceType &#91;required&#93; The type of resource for which to create the flow log. For example, if
#' you specified a VPC ID for the `ResourceId` property, specify `VPC` for
#' this property.
#' @param TrafficType &#91;required&#93; The type of traffic to log. You can log traffic that the resource
#' accepts or rejects, or all traffic.
#' @param LogDestinationType Specifies the type of destination to which the flow log data is to be
#' published. Flow log data can be published to CloudWatch Logs or Amazon
#' S3. To publish flow log data to CloudWatch Logs, specify
#' `cloud-watch-logs`. To publish flow log data to Amazon S3, specify `s3`.
#' 
#' If you specify `LogDestinationType` as `s3`, do not specify
#' `DeliverLogsPermissionArn` or `LogGroupName`.
#' 
#' Default: `cloud-watch-logs`
#' @param LogDestination Specifies the destination to which the flow log data is to be published.
#' Flow log data can be published to a CloudWatch Logs log group or an
#' Amazon S3 bucket. The value specified for this parameter depends on the
#' value specified for `LogDestinationType`.
#' 
#' If `LogDestinationType` is not specified or `cloud-watch-logs`, specify
#' the Amazon Resource Name (ARN) of the CloudWatch Logs log group. For
#' example, to publish to a log group called `my-logs`, specify
#' `arn:aws:logs:us-east-1:123456789012:log-group:my-logs`. Alternatively,
#' use `LogGroupName` instead.
#' 
#' If LogDestinationType is `s3`, specify the ARN of the Amazon S3 bucket.
#' You can also specify a subfolder in the bucket. To specify a subfolder
#' in the bucket, use the following ARN format:
#' `bucket_ARN/subfolder_name/`. For example, to specify a subfolder named
#' `my-logs` in a bucket named `my-bucket`, use the following ARN:
#' `arn:aws:s3:::my-bucket/my-logs/`. You cannot use `AWSLogs` as a
#' subfolder name. This is a reserved term.
#' @param LogFormat The fields to include in the flow log record, in the order in which they
#' should appear. For a list of available fields, see [Flow Log
#' Records](https://docs.aws.amazon.com/vpc/latest/userguide/flow-logs.html#flow-log-records).
#' If you omit this parameter, the flow log is created using the default
#' format. If you specify this parameter, you must specify at least one
#' field.
#' 
#' Specify the fields using the `$\{field-id\}` format, separated by spaces.
#' For the AWS CLI, use single quotation marks (\' \') to surround the
#' parameter value.
#' 
#' Only applicable to flow logs that are published to an Amazon S3 bucket.
#'
#' @section Request syntax:
#' ```
#' svc$create_flow_logs(
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string",
#'   DeliverLogsPermissionArn = "string",
#'   LogGroupName = "string",
#'   ResourceIds = list(
#'     "string"
#'   ),
#'   ResourceType = "VPC"|"Subnet"|"NetworkInterface",
#'   TrafficType = "ACCEPT"|"REJECT"|"ALL",
#'   LogDestinationType = "cloud-watch-logs"|"s3",
#'   LogDestination = "string",
#'   LogFormat = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_flow_logs
ec2_create_flow_logs <- function(DryRun = NULL, ClientToken = NULL, DeliverLogsPermissionArn = NULL, LogGroupName = NULL, ResourceIds, ResourceType, TrafficType, LogDestinationType = NULL, LogDestination = NULL, LogFormat = NULL) {
  op <- new_operation(
    name = "CreateFlowLogs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_flow_logs_input(DryRun = DryRun, ClientToken = ClientToken, DeliverLogsPermissionArn = DeliverLogsPermissionArn, LogGroupName = LogGroupName, ResourceIds = ResourceIds, ResourceType = ResourceType, TrafficType = TrafficType, LogDestinationType = LogDestinationType, LogDestination = LogDestination, LogFormat = LogFormat)
  output <- .ec2$create_flow_logs_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_flow_logs <- ec2_create_flow_logs

#' Creates an Amazon FPGA Image (AFI) from the specified design checkpoint
#' (DCP)
#'
#' Creates an Amazon FPGA Image (AFI) from the specified design checkpoint
#' (DCP).
#' 
#' The create operation is asynchronous. To verify that the AFI is ready
#' for use, check the output logs.
#' 
#' An AFI contains the FPGA bitstream that is ready to download to an FPGA.
#' You can securely deploy an AFI on multiple FPGA-accelerated instances.
#' For more information, see the [AWS FPGA Hardware Development
#' Kit](https://github.com/aws/aws-fpga/).
#'
#' @usage
#' ec2_create_fpga_image(DryRun, InputStorageLocation, LogsStorageLocation,
#'   Description, Name, ClientToken, TagSpecifications)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InputStorageLocation &#91;required&#93; The location of the encrypted design checkpoint in Amazon S3. The input
#' must be a tarball.
#' @param LogsStorageLocation The location in Amazon S3 for the output logs.
#' @param Description A description for the AFI.
#' @param Name A name for the AFI.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
#' @param TagSpecifications The tags to apply to the FPGA image during creation.
#'
#' @section Request syntax:
#' ```
#' svc$create_fpga_image(
#'   DryRun = TRUE|FALSE,
#'   InputStorageLocation = list(
#'     Bucket = "string",
#'     Key = "string"
#'   ),
#'   LogsStorageLocation = list(
#'     Bucket = "string",
#'     Key = "string"
#'   ),
#'   Description = "string",
#'   Name = "string",
#'   ClientToken = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_fpga_image
ec2_create_fpga_image <- function(DryRun = NULL, InputStorageLocation, LogsStorageLocation = NULL, Description = NULL, Name = NULL, ClientToken = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateFpgaImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_fpga_image_input(DryRun = DryRun, InputStorageLocation = InputStorageLocation, LogsStorageLocation = LogsStorageLocation, Description = Description, Name = Name, ClientToken = ClientToken, TagSpecifications = TagSpecifications)
  output <- .ec2$create_fpga_image_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_fpga_image <- ec2_create_fpga_image

#' Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that
#' is either running or stopped
#'
#' Creates an Amazon EBS-backed AMI from an Amazon EBS-backed instance that
#' is either running or stopped.
#' 
#' If you customized your instance with instance store volumes or EBS
#' volumes in addition to the root device volume, the new AMI contains
#' block device mapping information for those volumes. When you launch an
#' instance from this new AMI, the instance automatically launches with
#' those additional volumes.
#' 
#' For more information, see [Creating Amazon EBS-Backed Linux
#' AMIs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/creating-an-ami-ebs.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_image(BlockDeviceMappings, Description, DryRun, InstanceId,
#'   Name, NoReboot)
#'
#' @param BlockDeviceMappings The block device mappings. This parameter cannot be used to modify the
#' encryption status of existing volumes or snapshots. To create an AMI
#' with encrypted snapshots, use the CopyImage action.
#' @param Description A description for the new image.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param Name &#91;required&#93; A name for the new image.
#' 
#' Constraints: 3-128 alphanumeric characters, parentheses (()), square
#' brackets (\[\]), spaces ( ), periods (.), slashes (/), dashes (-),
#' single quotes (\'), at-signs (@@), or underscores(\\_)
#' @param NoReboot By default, Amazon EC2 attempts to shut down and reboot the instance
#' before creating the image. If the \'No Reboot\' option is set, Amazon
#' EC2 doesn\'t shut down the instance before creating the image. When this
#' option is used, file system integrity on the created image can\'t be
#' guaranteed.
#'
#' @section Request syntax:
#' ```
#' svc$create_image(
#'   BlockDeviceMappings = list(
#'     list(
#'       DeviceName = "string",
#'       VirtualName = "string",
#'       Ebs = list(
#'         DeleteOnTermination = TRUE|FALSE,
#'         Iops = 123,
#'         SnapshotId = "string",
#'         VolumeSize = 123,
#'         VolumeType = "standard"|"io1"|"gp2"|"sc1"|"st1",
#'         Encrypted = TRUE|FALSE,
#'         KmsKeyId = "string"
#'       ),
#'       NoDevice = "string"
#'     )
#'   ),
#'   Description = "string",
#'   DryRun = TRUE|FALSE,
#'   InstanceId = "string",
#'   Name = "string",
#'   NoReboot = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example creates an AMI from the specified instance and adds an EBS
#' # volume with the device name /dev/sdh and an instance store volume with
#' # the device name /dev/sdc.
#' \dontrun{svc$create_image(
#'   BlockDeviceMappings = list(
#'     list(
#'       DeviceName = "/dev/sdh",
#'       Ebs = list(
#'         VolumeSize = "100"
#'       )
#'     ),
#'     list(
#'       DeviceName = "/dev/sdc",
#'       VirtualName = "ephemeral1"
#'     )
#'   ),
#'   Description = "An AMI for my server",
#'   InstanceId = "i-1234567890abcdef0",
#'   Name = "My server",
#'   NoReboot = TRUE
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_image
ec2_create_image <- function(BlockDeviceMappings = NULL, Description = NULL, DryRun = NULL, InstanceId, Name, NoReboot = NULL) {
  op <- new_operation(
    name = "CreateImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_image_input(BlockDeviceMappings = BlockDeviceMappings, Description = Description, DryRun = DryRun, InstanceId = InstanceId, Name = Name, NoReboot = NoReboot)
  output <- .ec2$create_image_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_image <- ec2_create_image

#' Exports a running or stopped instance to an S3 bucket
#'
#' Exports a running or stopped instance to an S3 bucket.
#' 
#' For information about the supported operating systems, image formats,
#' and known limitations for the types of instances you can export, see
#' [Exporting an Instance as a VM Using VM
#' Import/Export](https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport.html)
#' in the *VM Import/Export User Guide*.
#'
#' @usage
#' ec2_create_instance_export_task(Description, ExportToS3Task, InstanceId,
#'   TargetEnvironment)
#'
#' @param Description A description for the conversion task or the resource being exported.
#' The maximum length is 255 bytes.
#' @param ExportToS3Task The format and location for an instance export task.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param TargetEnvironment The target virtualization environment.
#'
#' @section Request syntax:
#' ```
#' svc$create_instance_export_task(
#'   Description = "string",
#'   ExportToS3Task = list(
#'     ContainerFormat = "ova",
#'     DiskImageFormat = "VMDK"|"RAW"|"VHD",
#'     S3Bucket = "string",
#'     S3Prefix = "string"
#'   ),
#'   InstanceId = "string",
#'   TargetEnvironment = "citrix"|"vmware"|"microsoft"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_instance_export_task
ec2_create_instance_export_task <- function(Description = NULL, ExportToS3Task = NULL, InstanceId, TargetEnvironment = NULL) {
  op <- new_operation(
    name = "CreateInstanceExportTask",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_instance_export_task_input(Description = Description, ExportToS3Task = ExportToS3Task, InstanceId = InstanceId, TargetEnvironment = TargetEnvironment)
  output <- .ec2$create_instance_export_task_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_instance_export_task <- ec2_create_instance_export_task

#' Creates an internet gateway for use with a VPC
#'
#' Creates an internet gateway for use with a VPC. After creating the
#' internet gateway, you attach it to a VPC using AttachInternetGateway.
#' 
#' For more information about your VPC and internet gateway, see the
#' [Amazon Virtual Private Cloud User
#' Guide](https://docs.aws.amazon.com/vpc/latest/userguide/).
#'
#' @usage
#' ec2_create_internet_gateway(DryRun)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_internet_gateway(
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example creates an Internet gateway.
#' \dontrun{svc$create_internet_gateway()}
#'
#' @keywords internal
#'
#' @rdname ec2_create_internet_gateway
ec2_create_internet_gateway <- function(DryRun = NULL) {
  op <- new_operation(
    name = "CreateInternetGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_internet_gateway_input(DryRun = DryRun)
  output <- .ec2$create_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_internet_gateway <- ec2_create_internet_gateway

#' Creates a 2048-bit RSA key pair with the specified name
#'
#' Creates a 2048-bit RSA key pair with the specified name. Amazon EC2
#' stores the public key and displays the private key for you to save to a
#' file. The private key is returned as an unencrypted PEM encoded PKCS\\#1
#' private key. If a key with the specified name already exists, Amazon EC2
#' returns an error.
#' 
#' You can have up to five thousand key pairs per Region.
#' 
#' The key pair returned to you is available only in the Region in which
#' you create it. If you prefer, you can create your own key pair using a
#' third-party tool and upload it to any Region using ImportKeyPair.
#' 
#' For more information, see [Key
#' Pairs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_key_pair(KeyName, DryRun)
#'
#' @param KeyName &#91;required&#93; A unique name for the key pair.
#' 
#' Constraints: Up to 255 ASCII characters
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_key_pair(
#'   KeyName = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example creates a key pair named my-key-pair.
#' \dontrun{svc$create_key_pair(
#'   KeyName = "my-key-pair"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_key_pair
ec2_create_key_pair <- function(KeyName, DryRun = NULL) {
  op <- new_operation(
    name = "CreateKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_key_pair_input(KeyName = KeyName, DryRun = DryRun)
  output <- .ec2$create_key_pair_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_key_pair <- ec2_create_key_pair

#' Creates a launch template
#'
#' Creates a launch template. A launch template contains the parameters to
#' launch an instance. When you launch an instance using RunInstances, you
#' can specify a launch template instead of providing the launch parameters
#' in the request.
#'
#' @usage
#' ec2_create_launch_template(DryRun, ClientToken, LaunchTemplateName,
#'   VersionDescription, LaunchTemplateData, TagSpecifications)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' 
#' Constraint: Maximum 128 ASCII characters.
#' @param LaunchTemplateName &#91;required&#93; A name for the launch template.
#' @param VersionDescription A description for the first version of the launch template.
#' @param LaunchTemplateData &#91;required&#93; The information for the launch template.
#' @param TagSpecifications The tags to apply to the launch template during creation.
#'
#' @section Request syntax:
#' ```
#' svc$create_launch_template(
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string",
#'   LaunchTemplateName = "string",
#'   VersionDescription = "string",
#'   LaunchTemplateData = list(
#'     KernelId = "string",
#'     EbsOptimized = TRUE|FALSE,
#'     IamInstanceProfile = list(
#'       Arn = "string",
#'       Name = "string"
#'     ),
#'     BlockDeviceMappings = list(
#'       list(
#'         DeviceName = "string",
#'         VirtualName = "string",
#'         Ebs = list(
#'           Encrypted = TRUE|FALSE,
#'           DeleteOnTermination = TRUE|FALSE,
#'           Iops = 123,
#'           KmsKeyId = "string",
#'           SnapshotId = "string",
#'           VolumeSize = 123,
#'           VolumeType = "standard"|"io1"|"gp2"|"sc1"|"st1"
#'         ),
#'         NoDevice = "string"
#'       )
#'     ),
#'     NetworkInterfaces = list(
#'       list(
#'         AssociatePublicIpAddress = TRUE|FALSE,
#'         DeleteOnTermination = TRUE|FALSE,
#'         Description = "string",
#'         DeviceIndex = 123,
#'         Groups = list(
#'           "string"
#'         ),
#'         InterfaceType = "string",
#'         Ipv6AddressCount = 123,
#'         Ipv6Addresses = list(
#'           list(
#'             Ipv6Address = "string"
#'           )
#'         ),
#'         NetworkInterfaceId = "string",
#'         PrivateIpAddress = "string",
#'         PrivateIpAddresses = list(
#'           list(
#'             Primary = TRUE|FALSE,
#'             PrivateIpAddress = "string"
#'           )
#'         ),
#'         SecondaryPrivateIpAddressCount = 123,
#'         SubnetId = "string"
#'       )
#'     ),
#'     ImageId = "string",
#'     InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge",
#'     KeyName = "string",
#'     Monitoring = list(
#'       Enabled = TRUE|FALSE
#'     ),
#'     Placement = list(
#'       AvailabilityZone = "string",
#'       Affinity = "string",
#'       GroupName = "string",
#'       HostId = "string",
#'       Tenancy = "default"|"dedicated"|"host",
#'       SpreadDomain = "string",
#'       HostResourceGroupArn = "string"
#'     ),
#'     RamDiskId = "string",
#'     DisableApiTermination = TRUE|FALSE,
#'     InstanceInitiatedShutdownBehavior = "stop"|"terminate",
#'     UserData = "string",
#'     TagSpecifications = list(
#'       list(
#'         ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'         Tags = list(
#'           list(
#'             Key = "string",
#'             Value = "string"
#'           )
#'         )
#'       )
#'     ),
#'     ElasticGpuSpecifications = list(
#'       list(
#'         Type = "string"
#'       )
#'     ),
#'     ElasticInferenceAccelerators = list(
#'       list(
#'         Type = "string",
#'         Count = 123
#'       )
#'     ),
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     SecurityGroups = list(
#'       "string"
#'     ),
#'     InstanceMarketOptions = list(
#'       MarketType = "spot",
#'       SpotOptions = list(
#'         MaxPrice = "string",
#'         SpotInstanceType = "one-time"|"persistent",
#'         BlockDurationMinutes = 123,
#'         ValidUntil = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         InstanceInterruptionBehavior = "hibernate"|"stop"|"terminate"
#'       )
#'     ),
#'     CreditSpecification = list(
#'       CpuCredits = "string"
#'     ),
#'     CpuOptions = list(
#'       CoreCount = 123,
#'       ThreadsPerCore = 123
#'     ),
#'     CapacityReservationSpecification = list(
#'       CapacityReservationPreference = "open"|"none",
#'       CapacityReservationTarget = list(
#'         CapacityReservationId = "string"
#'       )
#'     ),
#'     LicenseSpecifications = list(
#'       list(
#'         LicenseConfigurationArn = "string"
#'       )
#'     ),
#'     HibernationOptions = list(
#'       Configured = TRUE|FALSE
#'     )
#'   ),
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example creates a launch template that specifies the subnet in
#' # which to launch the instance, assigns a public IP address and an IPv6
#' # address to the instance, and creates a tag for the instance.
#' \dontrun{svc$create_launch_template(
#'   LaunchTemplateData = list(
#'     ImageId = "ami-8c1be5f6",
#'     InstanceType = "t2.small",
#'     NetworkInterfaces = list(
#'       list(
#'         AssociatePublicIpAddress = TRUE,
#'         DeviceIndex = 0L,
#'         Ipv6AddressCount = 1L,
#'         SubnetId = "subnet-7b16de0c"
#'       )
#'     ),
#'     TagSpecifications = list(
#'       list(
#'         ResourceType = "instance",
#'         Tags = list(
#'           list(
#'             Key = "Name",
#'             Value = "webserver"
#'           )
#'         )
#'       )
#'     )
#'   ),
#'   LaunchTemplateName = "my-template",
#'   VersionDescription = "WebVersion1"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_launch_template
ec2_create_launch_template <- function(DryRun = NULL, ClientToken = NULL, LaunchTemplateName, VersionDescription = NULL, LaunchTemplateData, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateLaunchTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_launch_template_input(DryRun = DryRun, ClientToken = ClientToken, LaunchTemplateName = LaunchTemplateName, VersionDescription = VersionDescription, LaunchTemplateData = LaunchTemplateData, TagSpecifications = TagSpecifications)
  output <- .ec2$create_launch_template_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_launch_template <- ec2_create_launch_template

#' Creates a new version for a launch template
#'
#' Creates a new version for a launch template. You can specify an existing
#' version of launch template from which to base the new version.
#' 
#' Launch template versions are numbered in the order in which they are
#' created. You cannot specify, change, or replace the numbering of launch
#' template versions.
#'
#' @usage
#' ec2_create_launch_template_version(DryRun, ClientToken,
#'   LaunchTemplateId, LaunchTemplateName, SourceVersion, VersionDescription,
#'   LaunchTemplateData)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' 
#' Constraint: Maximum 128 ASCII characters.
#' @param LaunchTemplateId The ID of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#' @param LaunchTemplateName The name of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#' @param SourceVersion The version number of the launch template version on which to base the
#' new version. The new version inherits the same launch parameters as the
#' source version, except for parameters that you specify in
#' `LaunchTemplateData`. Snapshots applied to the block device mapping are
#' ignored when creating a new version unless they are explicitly included.
#' @param VersionDescription A description for the version of the launch template.
#' @param LaunchTemplateData &#91;required&#93; The information for the launch template.
#'
#' @section Request syntax:
#' ```
#' svc$create_launch_template_version(
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string",
#'   LaunchTemplateId = "string",
#'   LaunchTemplateName = "string",
#'   SourceVersion = "string",
#'   VersionDescription = "string",
#'   LaunchTemplateData = list(
#'     KernelId = "string",
#'     EbsOptimized = TRUE|FALSE,
#'     IamInstanceProfile = list(
#'       Arn = "string",
#'       Name = "string"
#'     ),
#'     BlockDeviceMappings = list(
#'       list(
#'         DeviceName = "string",
#'         VirtualName = "string",
#'         Ebs = list(
#'           Encrypted = TRUE|FALSE,
#'           DeleteOnTermination = TRUE|FALSE,
#'           Iops = 123,
#'           KmsKeyId = "string",
#'           SnapshotId = "string",
#'           VolumeSize = 123,
#'           VolumeType = "standard"|"io1"|"gp2"|"sc1"|"st1"
#'         ),
#'         NoDevice = "string"
#'       )
#'     ),
#'     NetworkInterfaces = list(
#'       list(
#'         AssociatePublicIpAddress = TRUE|FALSE,
#'         DeleteOnTermination = TRUE|FALSE,
#'         Description = "string",
#'         DeviceIndex = 123,
#'         Groups = list(
#'           "string"
#'         ),
#'         InterfaceType = "string",
#'         Ipv6AddressCount = 123,
#'         Ipv6Addresses = list(
#'           list(
#'             Ipv6Address = "string"
#'           )
#'         ),
#'         NetworkInterfaceId = "string",
#'         PrivateIpAddress = "string",
#'         PrivateIpAddresses = list(
#'           list(
#'             Primary = TRUE|FALSE,
#'             PrivateIpAddress = "string"
#'           )
#'         ),
#'         SecondaryPrivateIpAddressCount = 123,
#'         SubnetId = "string"
#'       )
#'     ),
#'     ImageId = "string",
#'     InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge",
#'     KeyName = "string",
#'     Monitoring = list(
#'       Enabled = TRUE|FALSE
#'     ),
#'     Placement = list(
#'       AvailabilityZone = "string",
#'       Affinity = "string",
#'       GroupName = "string",
#'       HostId = "string",
#'       Tenancy = "default"|"dedicated"|"host",
#'       SpreadDomain = "string",
#'       HostResourceGroupArn = "string"
#'     ),
#'     RamDiskId = "string",
#'     DisableApiTermination = TRUE|FALSE,
#'     InstanceInitiatedShutdownBehavior = "stop"|"terminate",
#'     UserData = "string",
#'     TagSpecifications = list(
#'       list(
#'         ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'         Tags = list(
#'           list(
#'             Key = "string",
#'             Value = "string"
#'           )
#'         )
#'       )
#'     ),
#'     ElasticGpuSpecifications = list(
#'       list(
#'         Type = "string"
#'       )
#'     ),
#'     ElasticInferenceAccelerators = list(
#'       list(
#'         Type = "string",
#'         Count = 123
#'       )
#'     ),
#'     SecurityGroupIds = list(
#'       "string"
#'     ),
#'     SecurityGroups = list(
#'       "string"
#'     ),
#'     InstanceMarketOptions = list(
#'       MarketType = "spot",
#'       SpotOptions = list(
#'         MaxPrice = "string",
#'         SpotInstanceType = "one-time"|"persistent",
#'         BlockDurationMinutes = 123,
#'         ValidUntil = as.POSIXct(
#'           "2015-01-01"
#'         ),
#'         InstanceInterruptionBehavior = "hibernate"|"stop"|"terminate"
#'       )
#'     ),
#'     CreditSpecification = list(
#'       CpuCredits = "string"
#'     ),
#'     CpuOptions = list(
#'       CoreCount = 123,
#'       ThreadsPerCore = 123
#'     ),
#'     CapacityReservationSpecification = list(
#'       CapacityReservationPreference = "open"|"none",
#'       CapacityReservationTarget = list(
#'         CapacityReservationId = "string"
#'       )
#'     ),
#'     LicenseSpecifications = list(
#'       list(
#'         LicenseConfigurationArn = "string"
#'       )
#'     ),
#'     HibernationOptions = list(
#'       Configured = TRUE|FALSE
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example creates a new launch template version based on version 1 of
#' # the specified launch template and specifies a different AMI ID.
#' \dontrun{svc$create_launch_template_version(
#'   LaunchTemplateData = list(
#'     ImageId = "ami-c998b6b2"
#'   ),
#'   LaunchTemplateId = "lt-0abcd290751193123",
#'   SourceVersion = "1",
#'   VersionDescription = "WebVersion2"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_launch_template_version
ec2_create_launch_template_version <- function(DryRun = NULL, ClientToken = NULL, LaunchTemplateId = NULL, LaunchTemplateName = NULL, SourceVersion = NULL, VersionDescription = NULL, LaunchTemplateData) {
  op <- new_operation(
    name = "CreateLaunchTemplateVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_launch_template_version_input(DryRun = DryRun, ClientToken = ClientToken, LaunchTemplateId = LaunchTemplateId, LaunchTemplateName = LaunchTemplateName, SourceVersion = SourceVersion, VersionDescription = VersionDescription, LaunchTemplateData = LaunchTemplateData)
  output <- .ec2$create_launch_template_version_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_launch_template_version <- ec2_create_launch_template_version

#' Creates a static route for the specified local gateway route table
#'
#' Creates a static route for the specified local gateway route table.
#'
#' @usage
#' ec2_create_local_gateway_route(DestinationCidrBlock,
#'   LocalGatewayRouteTableId, LocalGatewayVirtualInterfaceGroupId, DryRun)
#'
#' @param DestinationCidrBlock &#91;required&#93; The CIDR range used for destination matches. Routing decisions are based
#' on the most specific match.
#' @param LocalGatewayRouteTableId &#91;required&#93; The ID of the local gateway route table.
#' @param LocalGatewayVirtualInterfaceGroupId &#91;required&#93; The ID of the virtual interface group.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_local_gateway_route(
#'   DestinationCidrBlock = "string",
#'   LocalGatewayRouteTableId = "string",
#'   LocalGatewayVirtualInterfaceGroupId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_local_gateway_route
ec2_create_local_gateway_route <- function(DestinationCidrBlock, LocalGatewayRouteTableId, LocalGatewayVirtualInterfaceGroupId, DryRun = NULL) {
  op <- new_operation(
    name = "CreateLocalGatewayRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_local_gateway_route_input(DestinationCidrBlock = DestinationCidrBlock, LocalGatewayRouteTableId = LocalGatewayRouteTableId, LocalGatewayVirtualInterfaceGroupId = LocalGatewayVirtualInterfaceGroupId, DryRun = DryRun)
  output <- .ec2$create_local_gateway_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_local_gateway_route <- ec2_create_local_gateway_route

#' Associates the specified VPC with the specified local gateway route
#' table
#'
#' Associates the specified VPC with the specified local gateway route
#' table.
#'
#' @usage
#' ec2_create_local_gateway_route_table_vpc_association(
#'   LocalGatewayRouteTableId, VpcId, DryRun)
#'
#' @param LocalGatewayRouteTableId &#91;required&#93; The ID of the local gateway route table.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_local_gateway_route_table_vpc_association(
#'   LocalGatewayRouteTableId = "string",
#'   VpcId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_local_gateway_route_table_vpc_association
ec2_create_local_gateway_route_table_vpc_association <- function(LocalGatewayRouteTableId, VpcId, DryRun = NULL) {
  op <- new_operation(
    name = "CreateLocalGatewayRouteTableVpcAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_local_gateway_route_table_vpc_association_input(LocalGatewayRouteTableId = LocalGatewayRouteTableId, VpcId = VpcId, DryRun = DryRun)
  output <- .ec2$create_local_gateway_route_table_vpc_association_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_local_gateway_route_table_vpc_association <- ec2_create_local_gateway_route_table_vpc_association

#' Creates a NAT gateway in the specified public subnet
#'
#' Creates a NAT gateway in the specified public subnet. This action
#' creates a network interface in the specified subnet with a private IP
#' address from the IP address range of the subnet. Internet-bound traffic
#' from a private subnet can be routed to the NAT gateway, therefore
#' enabling instances in the private subnet to connect to the internet. For
#' more information, see [NAT
#' Gateways](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-nat-gateway.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_nat_gateway(AllocationId, ClientToken, SubnetId)
#'
#' @param AllocationId &#91;required&#93; The allocation ID of an Elastic IP address to associate with the NAT
#' gateway. If the Elastic IP address is associated with another resource,
#' you must first disassociate it.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' 
#' Constraint: Maximum 64 ASCII characters.
#' @param SubnetId &#91;required&#93; The subnet in which to create the NAT gateway.
#'
#' @section Request syntax:
#' ```
#' svc$create_nat_gateway(
#'   AllocationId = "string",
#'   ClientToken = "string",
#'   SubnetId = "string"
#' )
#' ```
#'
#' @examples
#' # This example creates a NAT gateway in subnet subnet-1a2b3c4d and
#' # associates an Elastic IP address with the allocation ID
#' # eipalloc-37fc1a52 with the NAT gateway.
#' \dontrun{svc$create_nat_gateway(
#'   AllocationId = "eipalloc-37fc1a52",
#'   SubnetId = "subnet-1a2b3c4d"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_nat_gateway
ec2_create_nat_gateway <- function(AllocationId, ClientToken = NULL, SubnetId) {
  op <- new_operation(
    name = "CreateNatGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_nat_gateway_input(AllocationId = AllocationId, ClientToken = ClientToken, SubnetId = SubnetId)
  output <- .ec2$create_nat_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_nat_gateway <- ec2_create_nat_gateway

#' Creates a network ACL in a VPC
#'
#' Creates a network ACL in a VPC. Network ACLs provide an optional layer
#' of security (in addition to security groups) for the instances in your
#' VPC.
#' 
#' For more information, see [Network
#' ACLs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html) in
#' the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_network_acl(DryRun, VpcId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#'
#' @section Request syntax:
#' ```
#' svc$create_network_acl(
#'   DryRun = TRUE|FALSE,
#'   VpcId = "string"
#' )
#' ```
#'
#' @examples
#' # This example creates a network ACL for the specified VPC.
#' \dontrun{svc$create_network_acl(
#'   VpcId = "vpc-a01106c2"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_network_acl
ec2_create_network_acl <- function(DryRun = NULL, VpcId) {
  op <- new_operation(
    name = "CreateNetworkAcl",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_network_acl_input(DryRun = DryRun, VpcId = VpcId)
  output <- .ec2$create_network_acl_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_network_acl <- ec2_create_network_acl

#' Creates an entry (a rule) in a network ACL with the specified rule
#' number
#'
#' Creates an entry (a rule) in a network ACL with the specified rule
#' number. Each network ACL has a set of numbered ingress rules and a
#' separate set of numbered egress rules. When determining whether a packet
#' should be allowed in or out of a subnet associated with the ACL, we
#' process the entries in the ACL according to the rule numbers, in
#' ascending order. Each network ACL has a set of ingress rules and a
#' separate set of egress rules.
#' 
#' We recommend that you leave room between the rule numbers (for example,
#' 100, 110, 120, \\...), and not number them one right after the other (for
#' example, 101, 102, 103, \\...). This makes it easier to add a rule
#' between existing ones without having to renumber the rules.
#' 
#' After you add an entry, you can\'t modify it; you must either replace
#' it, or create an entry and delete the old one.
#' 
#' For more information about network ACLs, see [Network
#' ACLs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html) in
#' the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_network_acl_entry(CidrBlock, DryRun, Egress, IcmpTypeCode,
#'   Ipv6CidrBlock, NetworkAclId, PortRange, Protocol, RuleAction,
#'   RuleNumber)
#'
#' @param CidrBlock The IPv4 network range to allow or deny, in CIDR notation (for example
#' `172.16.0.0/24`).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Egress &#91;required&#93; Indicates whether this is an egress rule (rule is applied to traffic
#' leaving the subnet).
#' @param IcmpTypeCode ICMP protocol: The ICMP or ICMPv6 type and code. Required if specifying
#' protocol 1 (ICMP) or protocol 58 (ICMPv6) with an IPv6 CIDR block.
#' @param Ipv6CidrBlock The IPv6 network range to allow or deny, in CIDR notation (for example
#' `2001:db8:1234:1a00::/64`).
#' @param NetworkAclId &#91;required&#93; The ID of the network ACL.
#' @param PortRange TCP or UDP protocols: The range of ports the rule applies to. Required
#' if specifying protocol 6 (TCP) or 17 (UDP).
#' @param Protocol &#91;required&#93; The protocol number. A value of \"-1\" means all protocols. If you
#' specify \"-1\" or a protocol number other than \"6\" (TCP), \"17\"
#' (UDP), or \"1\" (ICMP), traffic on all ports is allowed, regardless of
#' any ports or ICMP types or codes that you specify. If you specify
#' protocol \"58\" (ICMPv6) and specify an IPv4 CIDR block, traffic for all
#' ICMP types and codes allowed, regardless of any that you specify. If you
#' specify protocol \"58\" (ICMPv6) and specify an IPv6 CIDR block, you
#' must specify an ICMP type and code.
#' @param RuleAction &#91;required&#93; Indicates whether to allow or deny the traffic that matches the rule.
#' @param RuleNumber &#91;required&#93; The rule number for the entry (for example, 100). ACL entries are
#' processed in ascending order by rule number.
#' 
#' Constraints: Positive integer from 1 to 32766. The range 32767 to 65535
#' is reserved for internal use.
#'
#' @section Request syntax:
#' ```
#' svc$create_network_acl_entry(
#'   CidrBlock = "string",
#'   DryRun = TRUE|FALSE,
#'   Egress = TRUE|FALSE,
#'   IcmpTypeCode = list(
#'     Code = 123,
#'     Type = 123
#'   ),
#'   Ipv6CidrBlock = "string",
#'   NetworkAclId = "string",
#'   PortRange = list(
#'     From = 123,
#'     To = 123
#'   ),
#'   Protocol = "string",
#'   RuleAction = "allow"|"deny",
#'   RuleNumber = 123
#' )
#' ```
#'
#' @examples
#' # This example creates an entry for the specified network ACL. The rule
#' # allows ingress traffic from anywhere (0.0.0.0/0) on UDP port 53 (DNS)
#' # into any associated subnet.
#' \dontrun{svc$create_network_acl_entry(
#'   CidrBlock = "0.0.0.0/0",
#'   Egress = FALSE,
#'   NetworkAclId = "acl-5fb85d36",
#'   PortRange = list(
#'     From = 53L,
#'     To = 53L
#'   ),
#'   Protocol = "17",
#'   RuleAction = "allow",
#'   RuleNumber = 100L
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_network_acl_entry
ec2_create_network_acl_entry <- function(CidrBlock = NULL, DryRun = NULL, Egress, IcmpTypeCode = NULL, Ipv6CidrBlock = NULL, NetworkAclId, PortRange = NULL, Protocol, RuleAction, RuleNumber) {
  op <- new_operation(
    name = "CreateNetworkAclEntry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_network_acl_entry_input(CidrBlock = CidrBlock, DryRun = DryRun, Egress = Egress, IcmpTypeCode = IcmpTypeCode, Ipv6CidrBlock = Ipv6CidrBlock, NetworkAclId = NetworkAclId, PortRange = PortRange, Protocol = Protocol, RuleAction = RuleAction, RuleNumber = RuleNumber)
  output <- .ec2$create_network_acl_entry_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_network_acl_entry <- ec2_create_network_acl_entry

#' Creates a network interface in the specified subnet
#'
#' Creates a network interface in the specified subnet.
#' 
#' For more information about network interfaces, see [Elastic Network
#' Interfaces](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_network_interface(Description, DryRun, Groups,
#'   Ipv6AddressCount, Ipv6Addresses, PrivateIpAddress, PrivateIpAddresses,
#'   SecondaryPrivateIpAddressCount, InterfaceType, SubnetId)
#'
#' @param Description A description for the network interface.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Groups The IDs of one or more security groups.
#' @param Ipv6AddressCount The number of IPv6 addresses to assign to a network interface. Amazon
#' EC2 automatically selects the IPv6 addresses from the subnet range. You
#' can\'t use this option if specifying specific IPv6 addresses. If your
#' subnet has the `AssignIpv6AddressOnCreation` attribute set to `true`,
#' you can specify `0` to override this setting.
#' @param Ipv6Addresses One or more specific IPv6 addresses from the IPv6 CIDR block range of
#' your subnet. You can\'t use this option if you\'re specifying a number
#' of IPv6 addresses.
#' @param PrivateIpAddress The primary private IPv4 address of the network interface. If you don\'t
#' specify an IPv4 address, Amazon EC2 selects one for you from the
#' subnet\'s IPv4 CIDR range. If you specify an IP address, you cannot
#' indicate any IP addresses specified in `privateIpAddresses` as primary
#' (only one IP address can be designated as primary).
#' @param PrivateIpAddresses One or more private IPv4 addresses.
#' @param SecondaryPrivateIpAddressCount The number of secondary private IPv4 addresses to assign to a network
#' interface. When you specify a number of secondary IPv4 addresses, Amazon
#' EC2 selects these IP addresses within the subnet\'s IPv4 CIDR range. You
#' can\'t specify this option and specify more than one private IP address
#' using `privateIpAddresses`.
#' 
#' The number of IP addresses you can assign to a network interface varies
#' by instance type. For more information, see [IP Addresses Per ENI Per
#' Instance
#' Type](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' @param InterfaceType Indicates the type of network interface. To create an Elastic Fabric
#' Adapter (EFA), specify `efa`. For more information, see [Elastic Fabric
#' Adapter](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param SubnetId &#91;required&#93; The ID of the subnet to associate with the network interface.
#'
#' @section Request syntax:
#' ```
#' svc$create_network_interface(
#'   Description = "string",
#'   DryRun = TRUE|FALSE,
#'   Groups = list(
#'     "string"
#'   ),
#'   Ipv6AddressCount = 123,
#'   Ipv6Addresses = list(
#'     list(
#'       Ipv6Address = "string"
#'     )
#'   ),
#'   PrivateIpAddress = "string",
#'   PrivateIpAddresses = list(
#'     list(
#'       Primary = TRUE|FALSE,
#'       PrivateIpAddress = "string"
#'     )
#'   ),
#'   SecondaryPrivateIpAddressCount = 123,
#'   InterfaceType = "efa",
#'   SubnetId = "string"
#' )
#' ```
#'
#' @examples
#' # This example creates a network interface for the specified subnet.
#' \dontrun{svc$create_network_interface(
#'   Description = "my network interface",
#'   Groups = list(
#'     "sg-903004f8"
#'   ),
#'   PrivateIpAddress = "10.0.2.17",
#'   SubnetId = "subnet-9d4a7b6c"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_network_interface
ec2_create_network_interface <- function(Description = NULL, DryRun = NULL, Groups = NULL, Ipv6AddressCount = NULL, Ipv6Addresses = NULL, PrivateIpAddress = NULL, PrivateIpAddresses = NULL, SecondaryPrivateIpAddressCount = NULL, InterfaceType = NULL, SubnetId) {
  op <- new_operation(
    name = "CreateNetworkInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_network_interface_input(Description = Description, DryRun = DryRun, Groups = Groups, Ipv6AddressCount = Ipv6AddressCount, Ipv6Addresses = Ipv6Addresses, PrivateIpAddress = PrivateIpAddress, PrivateIpAddresses = PrivateIpAddresses, SecondaryPrivateIpAddressCount = SecondaryPrivateIpAddressCount, InterfaceType = InterfaceType, SubnetId = SubnetId)
  output <- .ec2$create_network_interface_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_network_interface <- ec2_create_network_interface

#' Grants an AWS-authorized account permission to attach the specified
#' network interface to an instance in their account
#'
#' Grants an AWS-authorized account permission to attach the specified
#' network interface to an instance in their account.
#' 
#' You can grant permission to a single AWS account only, and only one
#' account at a time.
#'
#' @usage
#' ec2_create_network_interface_permission(NetworkInterfaceId,
#'   AwsAccountId, AwsService, Permission, DryRun)
#'
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#' @param AwsAccountId The AWS account ID.
#' @param AwsService The AWS service. Currently not supported.
#' @param Permission &#91;required&#93; The type of permission to grant.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_network_interface_permission(
#'   NetworkInterfaceId = "string",
#'   AwsAccountId = "string",
#'   AwsService = "string",
#'   Permission = "INSTANCE-ATTACH"|"EIP-ASSOCIATE",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_network_interface_permission
ec2_create_network_interface_permission <- function(NetworkInterfaceId, AwsAccountId = NULL, AwsService = NULL, Permission, DryRun = NULL) {
  op <- new_operation(
    name = "CreateNetworkInterfacePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_network_interface_permission_input(NetworkInterfaceId = NetworkInterfaceId, AwsAccountId = AwsAccountId, AwsService = AwsService, Permission = Permission, DryRun = DryRun)
  output <- .ec2$create_network_interface_permission_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_network_interface_permission <- ec2_create_network_interface_permission

#' Creates a placement group in which to launch instances
#'
#' Creates a placement group in which to launch instances. The strategy of
#' the placement group determines how the instances are organized within
#' the group.
#' 
#' A `cluster` placement group is a logical grouping of instances within a
#' single Availability Zone that benefit from low network latency, high
#' network throughput. A `spread` placement group places instances on
#' distinct hardware. A `partition` placement group places groups of
#' instances in different partitions, where instances in one partition do
#' not share the same hardware with instances in another partition.
#' 
#' For more information, see [Placement
#' Groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_placement_group(DryRun, GroupName, Strategy, PartitionCount)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param GroupName A name for the placement group. Must be unique within the scope of your
#' account for the Region.
#' 
#' Constraints: Up to 255 ASCII characters
#' @param Strategy The placement strategy.
#' @param PartitionCount The number of partitions. Valid only when **Strategy** is set to
#' `partition`.
#'
#' @section Request syntax:
#' ```
#' svc$create_placement_group(
#'   DryRun = TRUE|FALSE,
#'   GroupName = "string",
#'   Strategy = "cluster"|"spread"|"partition",
#'   PartitionCount = 123
#' )
#' ```
#'
#' @examples
#' # This example creates a placement group with the specified name.
#' \dontrun{svc$create_placement_group(
#'   GroupName = "my-cluster",
#'   Strategy = "cluster"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_placement_group
ec2_create_placement_group <- function(DryRun = NULL, GroupName = NULL, Strategy = NULL, PartitionCount = NULL) {
  op <- new_operation(
    name = "CreatePlacementGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_placement_group_input(DryRun = DryRun, GroupName = GroupName, Strategy = Strategy, PartitionCount = PartitionCount)
  output <- .ec2$create_placement_group_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_placement_group <- ec2_create_placement_group

#' Creates a listing for Amazon EC2 Standard Reserved Instances to be sold
#' in the Reserved Instance Marketplace
#'
#' Creates a listing for Amazon EC2 Standard Reserved Instances to be sold
#' in the Reserved Instance Marketplace. You can submit one Standard
#' Reserved Instance listing at a time. To get a list of your Standard
#' Reserved Instances, you can use the DescribeReservedInstances operation.
#' 
#' Only Standard Reserved Instances can be sold in the Reserved Instance
#' Marketplace. Convertible Reserved Instances cannot be sold.
#' 
#' The Reserved Instance Marketplace matches sellers who want to resell
#' Standard Reserved Instance capacity that they no longer need with buyers
#' who want to purchase additional capacity. Reserved Instances bought and
#' sold through the Reserved Instance Marketplace work like any other
#' Reserved Instances.
#' 
#' To sell your Standard Reserved Instances, you must first register as a
#' seller in the Reserved Instance Marketplace. After completing the
#' registration process, you can create a Reserved Instance Marketplace
#' listing of some or all of your Standard Reserved Instances, and specify
#' the upfront price to receive for them. Your Standard Reserved Instance
#' listings then become available for purchase. To view the details of your
#' Standard Reserved Instance listing, you can use the
#' DescribeReservedInstancesListings operation.
#' 
#' For more information, see [Reserved Instance
#' Marketplace](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_reserved_instances_listing(ClientToken, InstanceCount,
#'   PriceSchedules, ReservedInstancesId)
#'
#' @param ClientToken &#91;required&#93; Unique, case-sensitive identifier you provide to ensure idempotency of
#' your listings. This helps avoid duplicate listings. For more
#' information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param InstanceCount &#91;required&#93; The number of instances that are a part of a Reserved Instance account
#' to be listed in the Reserved Instance Marketplace. This number should be
#' less than or equal to the instance count associated with the Reserved
#' Instance ID specified in this call.
#' @param PriceSchedules &#91;required&#93; A list specifying the price of the Standard Reserved Instance for each
#' month remaining in the Reserved Instance term.
#' @param ReservedInstancesId &#91;required&#93; The ID of the active Standard Reserved Instance.
#'
#' @section Request syntax:
#' ```
#' svc$create_reserved_instances_listing(
#'   ClientToken = "string",
#'   InstanceCount = 123,
#'   PriceSchedules = list(
#'     list(
#'       CurrencyCode = "USD",
#'       Price = 123.0,
#'       Term = 123
#'     )
#'   ),
#'   ReservedInstancesId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_reserved_instances_listing
ec2_create_reserved_instances_listing <- function(ClientToken, InstanceCount, PriceSchedules, ReservedInstancesId) {
  op <- new_operation(
    name = "CreateReservedInstancesListing",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_reserved_instances_listing_input(ClientToken = ClientToken, InstanceCount = InstanceCount, PriceSchedules = PriceSchedules, ReservedInstancesId = ReservedInstancesId)
  output <- .ec2$create_reserved_instances_listing_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_reserved_instances_listing <- ec2_create_reserved_instances_listing

#' Creates a route in a route table within a VPC
#'
#' Creates a route in a route table within a VPC.
#' 
#' You must specify one of the following targets: internet gateway or
#' virtual private gateway, NAT instance, NAT gateway, VPC peering
#' connection, network interface, egress-only internet gateway, or transit
#' gateway.
#' 
#' When determining how to route traffic, we use the route with the most
#' specific match. For example, traffic is destined for the IPv4 address
#' `192.0.2.3`, and the route table includes the following two IPv4 routes:
#' 
#' -   `192.0.2.0/24` (goes to some target A)
#' 
#' -   `192.0.2.0/28` (goes to some target B)
#' 
#' Both routes apply to the traffic destined for `192.0.2.3`. However, the
#' second route in the list covers a smaller number of IP addresses and is
#' therefore more specific, so we use that route to determine where to
#' target the traffic.
#' 
#' For more information about route tables, see [Route
#' Tables](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_route(DestinationCidrBlock, DestinationIpv6CidrBlock, DryRun,
#'   EgressOnlyInternetGatewayId, GatewayId, InstanceId, NatGatewayId,
#'   TransitGatewayId, LocalGatewayId, NetworkInterfaceId, RouteTableId,
#'   VpcPeeringConnectionId)
#'
#' @param DestinationCidrBlock The IPv4 CIDR address block used for the destination match. Routing
#' decisions are based on the most specific match.
#' @param DestinationIpv6CidrBlock The IPv6 CIDR block used for the destination match. Routing decisions
#' are based on the most specific match.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param EgressOnlyInternetGatewayId \[IPv6 traffic only\] The ID of an egress-only internet gateway.
#' @param GatewayId The ID of an internet gateway or virtual private gateway attached to
#' your VPC.
#' @param InstanceId The ID of a NAT instance in your VPC. The operation fails if you specify
#' an instance ID unless exactly one network interface is attached.
#' @param NatGatewayId \[IPv4 traffic only\] The ID of a NAT gateway.
#' @param TransitGatewayId The ID of a transit gateway.
#' @param LocalGatewayId The ID of the local gateway.
#' @param NetworkInterfaceId The ID of a network interface.
#' @param RouteTableId &#91;required&#93; The ID of the route table for the route.
#' @param VpcPeeringConnectionId The ID of a VPC peering connection.
#'
#' @section Request syntax:
#' ```
#' svc$create_route(
#'   DestinationCidrBlock = "string",
#'   DestinationIpv6CidrBlock = "string",
#'   DryRun = TRUE|FALSE,
#'   EgressOnlyInternetGatewayId = "string",
#'   GatewayId = "string",
#'   InstanceId = "string",
#'   NatGatewayId = "string",
#'   TransitGatewayId = "string",
#'   LocalGatewayId = "string",
#'   NetworkInterfaceId = "string",
#'   RouteTableId = "string",
#'   VpcPeeringConnectionId = "string"
#' )
#' ```
#'
#' @examples
#' # This example creates a route for the specified route table. The route
#' # matches all traffic (0.0.0.0/0) and routes it to the specified Internet
#' # gateway.
#' \dontrun{svc$create_route(
#'   DestinationCidrBlock = "0.0.0.0/0",
#'   GatewayId = "igw-c0a643a9",
#'   RouteTableId = "rtb-22574640"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_route
ec2_create_route <- function(DestinationCidrBlock = NULL, DestinationIpv6CidrBlock = NULL, DryRun = NULL, EgressOnlyInternetGatewayId = NULL, GatewayId = NULL, InstanceId = NULL, NatGatewayId = NULL, TransitGatewayId = NULL, LocalGatewayId = NULL, NetworkInterfaceId = NULL, RouteTableId, VpcPeeringConnectionId = NULL) {
  op <- new_operation(
    name = "CreateRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_route_input(DestinationCidrBlock = DestinationCidrBlock, DestinationIpv6CidrBlock = DestinationIpv6CidrBlock, DryRun = DryRun, EgressOnlyInternetGatewayId = EgressOnlyInternetGatewayId, GatewayId = GatewayId, InstanceId = InstanceId, NatGatewayId = NatGatewayId, TransitGatewayId = TransitGatewayId, LocalGatewayId = LocalGatewayId, NetworkInterfaceId = NetworkInterfaceId, RouteTableId = RouteTableId, VpcPeeringConnectionId = VpcPeeringConnectionId)
  output <- .ec2$create_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_route <- ec2_create_route

#' Creates a route table for the specified VPC
#'
#' Creates a route table for the specified VPC. After you create a route
#' table, you can add routes and associate the table with a subnet.
#' 
#' For more information, see [Route
#' Tables](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_route_table(DryRun, VpcId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#'
#' @section Request syntax:
#' ```
#' svc$create_route_table(
#'   DryRun = TRUE|FALSE,
#'   VpcId = "string"
#' )
#' ```
#'
#' @examples
#' # This example creates a route table for the specified VPC.
#' \dontrun{svc$create_route_table(
#'   VpcId = "vpc-a01106c2"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_route_table
ec2_create_route_table <- function(DryRun = NULL, VpcId) {
  op <- new_operation(
    name = "CreateRouteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_route_table_input(DryRun = DryRun, VpcId = VpcId)
  output <- .ec2$create_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_route_table <- ec2_create_route_table

#' Creates a security group
#'
#' Creates a security group.
#' 
#' A security group acts as a virtual firewall for your instance to control
#' inbound and outbound traffic. For more information, see [Amazon EC2
#' Security
#' Groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
#' in the *Amazon Elastic Compute Cloud User Guide* and [Security Groups
#' for Your
#' VPC](https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' 
#' When you create a security group, you specify a friendly name of your
#' choice. You can have a security group for use in EC2-Classic with the
#' same name as a security group for use in a VPC. However, you can\'t have
#' two security groups for use in EC2-Classic with the same name or two
#' security groups for use in a VPC with the same name.
#' 
#' You have a default security group for use in EC2-Classic and a default
#' security group for use in your VPC. If you don\'t specify a security
#' group when you launch an instance, the instance is launched into the
#' appropriate default security group. A default security group includes a
#' default rule that grants instances unrestricted network access to each
#' other.
#' 
#' You can add or remove rules from your security groups using
#' AuthorizeSecurityGroupIngress, AuthorizeSecurityGroupEgress,
#' RevokeSecurityGroupIngress, and RevokeSecurityGroupEgress.
#' 
#' For more information about VPC security group limits, see [Amazon VPC
#' Limits](https://docs.aws.amazon.com/vpc/latest/userguide/amazon-vpc-limits.html).
#'
#' @usage
#' ec2_create_security_group(Description, GroupName, VpcId, DryRun)
#'
#' @param Description &#91;required&#93; A description for the security group. This is informational only.
#' 
#' Constraints: Up to 255 characters in length
#' 
#' Constraints for EC2-Classic: ASCII characters
#' 
#' Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
#' .\\_-:/()\\#,@@\[\]+=&;\{\}!\\$*
#' @param GroupName &#91;required&#93; The name of the security group.
#' 
#' Constraints: Up to 255 characters in length. Cannot start with `sg-`.
#' 
#' Constraints for EC2-Classic: ASCII characters
#' 
#' Constraints for EC2-VPC: a-z, A-Z, 0-9, spaces, and
#' .\\_-:/()\\#,@@\[\]+=&;\{\}!\\$*
#' @param VpcId \[EC2-VPC\] The ID of the VPC. Required for EC2-VPC.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_security_group(
#'   Description = "string",
#'   GroupName = "string",
#'   VpcId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example creates a security group for the specified VPC.
#' \dontrun{svc$create_security_group(
#'   Description = "My security group",
#'   GroupName = "my-security-group",
#'   VpcId = "vpc-1a2b3c4d"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_security_group
ec2_create_security_group <- function(Description, GroupName, VpcId = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateSecurityGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_security_group_input(Description = Description, GroupName = GroupName, VpcId = VpcId, DryRun = DryRun)
  output <- .ec2$create_security_group_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_security_group <- ec2_create_security_group

#' Creates a snapshot of an EBS volume and stores it in Amazon S3
#'
#' Creates a snapshot of an EBS volume and stores it in Amazon S3. You can
#' use snapshots for backups, to make copies of EBS volumes, and to save
#' data before shutting down an instance.
#' 
#' When a snapshot is created, any AWS Marketplace product codes that are
#' associated with the source volume are propagated to the snapshot.
#' 
#' You can take a snapshot of an attached volume that is in use. However,
#' snapshots only capture data that has been written to your EBS volume at
#' the time the snapshot command is issued; this may exclude any data that
#' has been cached by any applications or the operating system. If you can
#' pause any file systems on the volume long enough to take a snapshot,
#' your snapshot should be complete. However, if you cannot pause all file
#' writes to the volume, you should unmount the volume from within the
#' instance, issue the snapshot command, and then remount the volume to
#' ensure a consistent and complete snapshot. You may remount and use your
#' volume while the snapshot status is `pending`.
#' 
#' To create a snapshot for EBS volumes that serve as root devices, you
#' should stop the instance before taking the snapshot.
#' 
#' Snapshots that are taken from encrypted volumes are automatically
#' encrypted. Volumes that are created from encrypted snapshots are also
#' automatically encrypted. Your encrypted volumes and any associated
#' snapshots always remain protected.
#' 
#' You can tag your snapshots during creation. For more information, see
#' [Tagging Your Amazon EC2
#' Resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' For more information, see [Amazon Elastic Block
#' Store](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/AmazonEBS.html)
#' and [Amazon EBS
#' Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_snapshot(Description, VolumeId, TagSpecifications, DryRun)
#'
#' @param Description A description for the snapshot.
#' @param VolumeId &#91;required&#93; The ID of the EBS volume.
#' @param TagSpecifications The tags to apply to the snapshot during creation.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_snapshot(
#'   Description = "string",
#'   VolumeId = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example creates a snapshot of the volume with a volume ID of
#' # `vol-1234567890abcdef0` and a short description to identify the
#' # snapshot.
#' \dontrun{svc$create_snapshot(
#'   Description = "This is my root volume snapshot.",
#'   VolumeId = "vol-1234567890abcdef0"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_snapshot
ec2_create_snapshot <- function(Description = NULL, VolumeId, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_snapshot_input(Description = Description, VolumeId = VolumeId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_snapshot_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_snapshot <- ec2_create_snapshot

#' Creates crash-consistent snapshots of multiple EBS volumes and stores
#' the data in S3
#'
#' Creates crash-consistent snapshots of multiple EBS volumes and stores
#' the data in S3. Volumes are chosen by specifying an instance. Any
#' attached volumes will produce one snapshot each that is crash-consistent
#' across the instance. Boot volumes can be excluded by changing the
#' parameters.
#'
#' @usage
#' ec2_create_snapshots(Description, InstanceSpecification,
#'   TagSpecifications, DryRun, CopyTagsFromSource)
#'
#' @param Description A description propagated to every snapshot specified by the instance.
#' @param InstanceSpecification &#91;required&#93; The instance to specify which volumes should be included in the
#' snapshots.
#' @param TagSpecifications Tags to apply to every snapshot specified by the instance.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param CopyTagsFromSource Copies the tags from the specified volume to corresponding snapshot.
#'
#' @section Request syntax:
#' ```
#' svc$create_snapshots(
#'   Description = "string",
#'   InstanceSpecification = list(
#'     InstanceId = "string",
#'     ExcludeBootVolume = TRUE|FALSE
#'   ),
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   CopyTagsFromSource = "volume"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_snapshots
ec2_create_snapshots <- function(Description = NULL, InstanceSpecification, TagSpecifications = NULL, DryRun = NULL, CopyTagsFromSource = NULL) {
  op <- new_operation(
    name = "CreateSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_snapshots_input(Description = Description, InstanceSpecification = InstanceSpecification, TagSpecifications = TagSpecifications, DryRun = DryRun, CopyTagsFromSource = CopyTagsFromSource)
  output <- .ec2$create_snapshots_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_snapshots <- ec2_create_snapshots

#' Creates a data feed for Spot Instances, enabling you to view Spot
#' Instance usage logs
#'
#' Creates a data feed for Spot Instances, enabling you to view Spot
#' Instance usage logs. You can create one data feed per AWS account. For
#' more information, see [Spot Instance Data
#' Feed](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#'
#' @usage
#' ec2_create_spot_datafeed_subscription(Bucket, DryRun, Prefix)
#'
#' @param Bucket &#91;required&#93; The Amazon S3 bucket in which to store the Spot Instance data feed.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Prefix A prefix for the data feed file names.
#'
#' @section Request syntax:
#' ```
#' svc$create_spot_datafeed_subscription(
#'   Bucket = "string",
#'   DryRun = TRUE|FALSE,
#'   Prefix = "string"
#' )
#' ```
#'
#' @examples
#' # This example creates a Spot Instance data feed for your AWS account.
#' \dontrun{svc$create_spot_datafeed_subscription(
#'   Bucket = "my-s3-bucket",
#'   Prefix = "spotdata"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_spot_datafeed_subscription
ec2_create_spot_datafeed_subscription <- function(Bucket, DryRun = NULL, Prefix = NULL) {
  op <- new_operation(
    name = "CreateSpotDatafeedSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_spot_datafeed_subscription_input(Bucket = Bucket, DryRun = DryRun, Prefix = Prefix)
  output <- .ec2$create_spot_datafeed_subscription_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_spot_datafeed_subscription <- ec2_create_spot_datafeed_subscription

#' Creates a subnet in an existing VPC
#'
#' Creates a subnet in an existing VPC.
#' 
#' When you create each subnet, you provide the VPC ID and IPv4 CIDR block
#' for the subnet. After you create a subnet, you can\'t change its CIDR
#' block. The size of the subnet\'s IPv4 CIDR block can be the same as a
#' VPC\'s IPv4 CIDR block, or a subset of a VPC\'s IPv4 CIDR block. If you
#' create more than one subnet in a VPC, the subnets\' CIDR blocks must not
#' overlap. The smallest IPv4 subnet (and VPC) you can create uses a /28
#' netmask (16 IPv4 addresses), and the largest uses a /16 netmask (65,536
#' IPv4 addresses).
#' 
#' If you\'ve associated an IPv6 CIDR block with your VPC, you can create a
#' subnet with an IPv6 CIDR block that uses a /64 prefix length.
#' 
#' AWS reserves both the first four and the last IPv4 address in each
#' subnet\'s CIDR block. They\'re not available for use.
#' 
#' If you add more than one subnet to a VPC, they\'re set up in a star
#' topology with a logical router in the middle.
#' 
#' If you launch an instance in a VPC using an Amazon EBS-backed AMI, the
#' IP address doesn\'t change if you stop and restart the instance (unlike
#' a similar instance launched outside a VPC, which gets a new IP address
#' when restarted). It\'s therefore possible to have a subnet with no
#' running instances (they\'re all stopped), but no remaining IP addresses
#' available.
#' 
#' For more information about subnets, see [Your VPC and
#' Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_subnet(AvailabilityZone, AvailabilityZoneId, CidrBlock,
#'   Ipv6CidrBlock, OutpostArn, VpcId, DryRun)
#'
#' @param AvailabilityZone The Availability Zone or Local Zone for the subnet.
#' 
#' Default: AWS selects one for you. If you create more than one subnet in
#' your VPC, we do not necessarily select a different zone for each subnet.
#' 
#' To create a subnet in a Local Zone, set this value to the Local Zone ID,
#' for example `us-west-2-lax-1a`. For information about the Regions that
#' support Local Zones, see [Available
#' Regions](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html#concepts-available-regions)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param AvailabilityZoneId The AZ ID or the Local Zone ID of the subnet.
#' @param CidrBlock &#91;required&#93; The IPv4 network range for the subnet, in CIDR notation. For example,
#' `10.0.0.0/24`.
#' @param Ipv6CidrBlock The IPv6 network range for the subnet, in CIDR notation. The subnet size
#' must use a /64 prefix length.
#' @param OutpostArn The Amazon Resource Name (ARN) of the Outpost.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_subnet(
#'   AvailabilityZone = "string",
#'   AvailabilityZoneId = "string",
#'   CidrBlock = "string",
#'   Ipv6CidrBlock = "string",
#'   OutpostArn = "string",
#'   VpcId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example creates a subnet in the specified VPC with the specified
#' # CIDR block. We recommend that you let us select an Availability Zone for
#' # you.
#' \dontrun{svc$create_subnet(
#'   CidrBlock = "10.0.1.0/24",
#'   VpcId = "vpc-a01106c2"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_subnet
ec2_create_subnet <- function(AvailabilityZone = NULL, AvailabilityZoneId = NULL, CidrBlock, Ipv6CidrBlock = NULL, OutpostArn = NULL, VpcId, DryRun = NULL) {
  op <- new_operation(
    name = "CreateSubnet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_subnet_input(AvailabilityZone = AvailabilityZone, AvailabilityZoneId = AvailabilityZoneId, CidrBlock = CidrBlock, Ipv6CidrBlock = Ipv6CidrBlock, OutpostArn = OutpostArn, VpcId = VpcId, DryRun = DryRun)
  output <- .ec2$create_subnet_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_subnet <- ec2_create_subnet

#' Adds or overwrites the specified tags for the specified Amazon EC2
#' resource or resources
#'
#' Adds or overwrites the specified tags for the specified Amazon EC2
#' resource or resources. Each resource can have a maximum of 50 tags. Each
#' tag consists of a key and optional value. Tag keys must be unique per
#' resource.
#' 
#' For more information about tags, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
#' in the *Amazon Elastic Compute Cloud User Guide*. For more information
#' about creating IAM policies that control users\' access to resources
#' based on tags, see [Supported Resource-Level Permissions for Amazon EC2
#' API
#' Actions](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-supported-iam-actions-resources.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_tags(DryRun, Resources, Tags)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Resources &#91;required&#93; The IDs of the resources, separated by spaces.
#' 
#' Constraints: Up to 1000 resource IDs. We recommend breaking up this
#' request into smaller batches.
#' @param Tags &#91;required&#93; The tags. The `value` parameter is required, but if you don\'t want the
#' tag to have a value, specify the parameter with no value, and we set the
#' value to an empty string.
#'
#' @section Request syntax:
#' ```
#' svc$create_tags(
#'   DryRun = TRUE|FALSE,
#'   Resources = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example adds the tag Stack=production to the specified image, or
#' # overwrites an existing tag for the AMI where the tag key is Stack.
#' \dontrun{svc$create_tags(
#'   Resources = list(
#'     "ami-78a54011"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "Stack",
#'       Value = "production"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_tags
ec2_create_tags <- function(DryRun = NULL, Resources, Tags) {
  op <- new_operation(
    name = "CreateTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_tags_input(DryRun = DryRun, Resources = Resources, Tags = Tags)
  output <- .ec2$create_tags_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_tags <- ec2_create_tags

#' Creates a Traffic Mirror filter
#'
#' Creates a Traffic Mirror filter.
#' 
#' A Traffic Mirror filter is a set of rules that defines the traffic to
#' mirror.
#' 
#' By default, no traffic is mirrored. To mirror traffic, use
#' [CreateTrafficMirrorFilterRule](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilterRule.htm)
#' to add Traffic Mirror rules to the filter. The rules you add define what
#' traffic gets mirrored. You can also use
#' [ModifyTrafficMirrorFilterNetworkServices](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyTrafficMirrorFilterNetworkServices.html)
#' to mirror supported network services.
#'
#' @usage
#' ec2_create_traffic_mirror_filter(Description, TagSpecifications, DryRun,
#'   ClientToken)
#'
#' @param Description The description of the Traffic Mirror filter.
#' @param TagSpecifications The tags to assign to a Traffic Mirror filter.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_traffic_mirror_filter(
#'   Description = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_traffic_mirror_filter
ec2_create_traffic_mirror_filter <- function(Description = NULL, TagSpecifications = NULL, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateTrafficMirrorFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_traffic_mirror_filter_input(Description = Description, TagSpecifications = TagSpecifications, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ec2$create_traffic_mirror_filter_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_traffic_mirror_filter <- ec2_create_traffic_mirror_filter

#' Creates a Traffic Mirror filter rule
#'
#' Creates a Traffic Mirror filter rule.
#' 
#' A Traffic Mirror rule defines the Traffic Mirror source traffic to
#' mirror.
#' 
#' You need the Traffic Mirror filter ID when you create the rule.
#'
#' @usage
#' ec2_create_traffic_mirror_filter_rule(TrafficMirrorFilterId,
#'   TrafficDirection, RuleNumber, RuleAction, DestinationPortRange,
#'   SourcePortRange, Protocol, DestinationCidrBlock, SourceCidrBlock,
#'   Description, DryRun, ClientToken)
#'
#' @param TrafficMirrorFilterId &#91;required&#93; The ID of the filter that this rule is associated with.
#' @param TrafficDirection &#91;required&#93; The type of traffic (`ingress` \\| `egress`).
#' @param RuleNumber &#91;required&#93; The number of the Traffic Mirror rule. This number must be unique for
#' each Traffic Mirror rule in a given direction. The rules are processed
#' in ascending order by rule number.
#' @param RuleAction &#91;required&#93; The action to take (`accept` \\| `reject`) on the filtered traffic.
#' @param DestinationPortRange The destination port range.
#' @param SourcePortRange The source port range.
#' @param Protocol The protocol, for example UDP, to assign to the Traffic Mirror rule.
#' 
#' For information about the protocol value, see [Protocol
#' Numbers](https://www.iana.org/assignments/protocol-numbers/protocol-numbers.xhtml)
#' on the Internet Assigned Numbers Authority (IANA) website.
#' @param DestinationCidrBlock &#91;required&#93; The destination CIDR block to assign to the Traffic Mirror rule.
#' @param SourceCidrBlock &#91;required&#93; The source CIDR block to assign to the Traffic Mirror rule.
#' @param Description The description of the Traffic Mirror rule.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_traffic_mirror_filter_rule(
#'   TrafficMirrorFilterId = "string",
#'   TrafficDirection = "ingress"|"egress",
#'   RuleNumber = 123,
#'   RuleAction = "accept"|"reject",
#'   DestinationPortRange = list(
#'     FromPort = 123,
#'     ToPort = 123
#'   ),
#'   SourcePortRange = list(
#'     FromPort = 123,
#'     ToPort = 123
#'   ),
#'   Protocol = 123,
#'   DestinationCidrBlock = "string",
#'   SourceCidrBlock = "string",
#'   Description = "string",
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_traffic_mirror_filter_rule
ec2_create_traffic_mirror_filter_rule <- function(TrafficMirrorFilterId, TrafficDirection, RuleNumber, RuleAction, DestinationPortRange = NULL, SourcePortRange = NULL, Protocol = NULL, DestinationCidrBlock, SourceCidrBlock, Description = NULL, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateTrafficMirrorFilterRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_traffic_mirror_filter_rule_input(TrafficMirrorFilterId = TrafficMirrorFilterId, TrafficDirection = TrafficDirection, RuleNumber = RuleNumber, RuleAction = RuleAction, DestinationPortRange = DestinationPortRange, SourcePortRange = SourcePortRange, Protocol = Protocol, DestinationCidrBlock = DestinationCidrBlock, SourceCidrBlock = SourceCidrBlock, Description = Description, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ec2$create_traffic_mirror_filter_rule_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_traffic_mirror_filter_rule <- ec2_create_traffic_mirror_filter_rule

#' Creates a Traffic Mirror session
#'
#' Creates a Traffic Mirror session.
#' 
#' A Traffic Mirror session actively copies packets from a Traffic Mirror
#' source to a Traffic Mirror target. Create a filter, and then assign it
#' to the session to define a subset of the traffic to mirror, for example
#' all TCP traffic.
#' 
#' The Traffic Mirror source and the Traffic Mirror target (monitoring
#' appliances) can be in the same VPC, or in a different VPC connected via
#' VPC peering or a transit gateway.
#' 
#' By default, no traffic is mirrored. Use
#' [CreateTrafficMirrorFilter](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorFilter.htm)
#' to create filter rules that specify the traffic to mirror.
#'
#' @usage
#' ec2_create_traffic_mirror_session(NetworkInterfaceId,
#'   TrafficMirrorTargetId, TrafficMirrorFilterId, PacketLength,
#'   SessionNumber, VirtualNetworkId, Description, TagSpecifications, DryRun,
#'   ClientToken)
#'
#' @param NetworkInterfaceId &#91;required&#93; The ID of the source network interface.
#' @param TrafficMirrorTargetId &#91;required&#93; The ID of the Traffic Mirror target.
#' @param TrafficMirrorFilterId &#91;required&#93; The ID of the Traffic Mirror filter.
#' @param PacketLength The number of bytes in each packet to mirror. These are bytes after the
#' VXLAN header. Do not specify this parameter when you want to mirror the
#' entire packet. To mirror a subset of the packet, set this to the length
#' (in bytes) that you want to mirror. For example, if you set this value
#' to 100, then the first 100 bytes that meet the filter criteria are
#' copied to the target.
#' 
#' If you do not want to mirror the entire packet, use the `PacketLength`
#' parameter to specify the number of bytes in each packet to mirror.
#' @param SessionNumber &#91;required&#93; The session number determines the order in which sessions are evaluated
#' when an interface is used by multiple sessions. The first session with a
#' matching filter is the one that mirrors the packets.
#' 
#' Valid values are 1-32766.
#' @param VirtualNetworkId The VXLAN ID for the Traffic Mirror session. For more information about
#' the VXLAN protocol, see [RFC 7348](https://tools.ietf.org/html/rfc7348).
#' If you do not specify a `VirtualNetworkId`, an account-wide unique id is
#' chosen at random.
#' @param Description The description of the Traffic Mirror session.
#' @param TagSpecifications The tags to assign to a Traffic Mirror session.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_traffic_mirror_session(
#'   NetworkInterfaceId = "string",
#'   TrafficMirrorTargetId = "string",
#'   TrafficMirrorFilterId = "string",
#'   PacketLength = 123,
#'   SessionNumber = 123,
#'   VirtualNetworkId = 123,
#'   Description = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_traffic_mirror_session
ec2_create_traffic_mirror_session <- function(NetworkInterfaceId, TrafficMirrorTargetId, TrafficMirrorFilterId, PacketLength = NULL, SessionNumber, VirtualNetworkId = NULL, Description = NULL, TagSpecifications = NULL, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateTrafficMirrorSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_traffic_mirror_session_input(NetworkInterfaceId = NetworkInterfaceId, TrafficMirrorTargetId = TrafficMirrorTargetId, TrafficMirrorFilterId = TrafficMirrorFilterId, PacketLength = PacketLength, SessionNumber = SessionNumber, VirtualNetworkId = VirtualNetworkId, Description = Description, TagSpecifications = TagSpecifications, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ec2$create_traffic_mirror_session_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_traffic_mirror_session <- ec2_create_traffic_mirror_session

#' Creates a target for your Traffic Mirror session
#'
#' Creates a target for your Traffic Mirror session.
#' 
#' A Traffic Mirror target is the destination for mirrored traffic. The
#' Traffic Mirror source and the Traffic Mirror target (monitoring
#' appliances) can be in the same VPC, or in different VPCs connected via
#' VPC peering or a transit gateway.
#' 
#' A Traffic Mirror target can be a network interface, or a Network Load
#' Balancer.
#' 
#' To use the target in a Traffic Mirror session, use
#' [CreateTrafficMirrorSession](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_CreateTrafficMirrorSession.htm).
#'
#' @usage
#' ec2_create_traffic_mirror_target(NetworkInterfaceId,
#'   NetworkLoadBalancerArn, Description, TagSpecifications, DryRun,
#'   ClientToken)
#'
#' @param NetworkInterfaceId The network interface ID that is associated with the target.
#' @param NetworkLoadBalancerArn The Amazon Resource Name (ARN) of the Network Load Balancer that is
#' associated with the target.
#' @param Description The description of the Traffic Mirror target.
#' @param TagSpecifications The tags to assign to the Traffic Mirror target.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_traffic_mirror_target(
#'   NetworkInterfaceId = "string",
#'   NetworkLoadBalancerArn = "string",
#'   Description = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_traffic_mirror_target
ec2_create_traffic_mirror_target <- function(NetworkInterfaceId = NULL, NetworkLoadBalancerArn = NULL, Description = NULL, TagSpecifications = NULL, DryRun = NULL, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateTrafficMirrorTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_traffic_mirror_target_input(NetworkInterfaceId = NetworkInterfaceId, NetworkLoadBalancerArn = NetworkLoadBalancerArn, Description = Description, TagSpecifications = TagSpecifications, DryRun = DryRun, ClientToken = ClientToken)
  output <- .ec2$create_traffic_mirror_target_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_traffic_mirror_target <- ec2_create_traffic_mirror_target

#' Creates a transit gateway
#'
#' Creates a transit gateway.
#' 
#' You can use a transit gateway to interconnect your virtual private
#' clouds (VPC) and on-premises networks. After the transit gateway enters
#' the `available` state, you can attach your VPCs and VPN connections to
#' the transit gateway.
#' 
#' To attach your VPCs, use CreateTransitGatewayVpcAttachment.
#' 
#' To attach a VPN connection, use CreateCustomerGateway to create a
#' customer gateway and specify the ID of the customer gateway and the ID
#' of the transit gateway in a call to CreateVpnConnection.
#' 
#' When you create a transit gateway, we create a default transit gateway
#' route table and use it as the default association route table and the
#' default propagation route table. You can use
#' CreateTransitGatewayRouteTable to create additional transit gateway
#' route tables. If you disable automatic route propagation, we do not
#' create a default transit gateway route table. You can use
#' EnableTransitGatewayRouteTablePropagation to propagate routes from a
#' resource attachment to a transit gateway route table. If you disable
#' automatic associations, you can use AssociateTransitGatewayRouteTable to
#' associate a resource attachment with a transit gateway route table.
#'
#' @usage
#' ec2_create_transit_gateway(Description, Options, TagSpecifications,
#'   DryRun)
#'
#' @param Description A description of the transit gateway.
#' @param Options The transit gateway options.
#' @param TagSpecifications The tags to apply to the transit gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_gateway(
#'   Description = "string",
#'   Options = list(
#'     AmazonSideAsn = 123,
#'     AutoAcceptSharedAttachments = "enable"|"disable",
#'     DefaultRouteTableAssociation = "enable"|"disable",
#'     DefaultRouteTablePropagation = "enable"|"disable",
#'     VpnEcmpSupport = "enable"|"disable",
#'     DnsSupport = "enable"|"disable",
#'     MulticastSupport = "enable"|"disable"
#'   ),
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway
ec2_create_transit_gateway <- function(Description = NULL, Options = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_transit_gateway_input(Description = Description, Options = Options, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway <- ec2_create_transit_gateway

#' Creates a multicast domain using the specified transit gateway
#'
#' Creates a multicast domain using the specified transit gateway.
#' 
#' The transit gateway must be in the available state before you create a
#' domain. Use
#' [DescribeTransitGateways](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_DescribeTransitGateways.html)
#' to see the state of transit gateway.
#'
#' @usage
#' ec2_create_transit_gateway_multicast_domain(TransitGatewayId,
#'   TagSpecifications, DryRun)
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway.
#' @param TagSpecifications The tags for the transit gateway multicast domain.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_gateway_multicast_domain(
#'   TransitGatewayId = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_multicast_domain
ec2_create_transit_gateway_multicast_domain <- function(TransitGatewayId, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayMulticastDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_transit_gateway_multicast_domain_input(TransitGatewayId = TransitGatewayId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_multicast_domain_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_multicast_domain <- ec2_create_transit_gateway_multicast_domain

#' Requests a transit gateway peering attachment between the specified
#' transit gateway (requester) and a peer transit gateway (accepter)
#'
#' Requests a transit gateway peering attachment between the specified
#' transit gateway (requester) and a peer transit gateway (accepter). The
#' transit gateways must be in different Regions. The peer transit gateway
#' can be in your account or a different AWS account.
#' 
#' After you create the peering attachment, the owner of the accepter
#' transit gateway must accept the attachment request.
#'
#' @usage
#' ec2_create_transit_gateway_peering_attachment(TransitGatewayId,
#'   PeerTransitGatewayId, PeerAccountId, PeerRegion, TagSpecifications,
#'   DryRun)
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway.
#' @param PeerTransitGatewayId &#91;required&#93; The ID of the peer transit gateway with which to create the peering
#' attachment.
#' @param PeerAccountId &#91;required&#93; The AWS account ID of the owner of the peer transit gateway.
#' @param PeerRegion &#91;required&#93; The Region where the peer transit gateway is located.
#' @param TagSpecifications The tags to apply to the transit gateway peering attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_gateway_peering_attachment(
#'   TransitGatewayId = "string",
#'   PeerTransitGatewayId = "string",
#'   PeerAccountId = "string",
#'   PeerRegion = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_peering_attachment
ec2_create_transit_gateway_peering_attachment <- function(TransitGatewayId, PeerTransitGatewayId, PeerAccountId, PeerRegion, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayPeeringAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_transit_gateway_peering_attachment_input(TransitGatewayId = TransitGatewayId, PeerTransitGatewayId = PeerTransitGatewayId, PeerAccountId = PeerAccountId, PeerRegion = PeerRegion, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_peering_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_peering_attachment <- ec2_create_transit_gateway_peering_attachment

#' Creates a static route for the specified transit gateway route table
#'
#' Creates a static route for the specified transit gateway route table.
#'
#' @usage
#' ec2_create_transit_gateway_route(DestinationCidrBlock,
#'   TransitGatewayRouteTableId, TransitGatewayAttachmentId, Blackhole,
#'   DryRun)
#'
#' @param DestinationCidrBlock &#91;required&#93; The CIDR range used for destination matches. Routing decisions are based
#' on the most specific match.
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param TransitGatewayAttachmentId The ID of the attachment.
#' @param Blackhole Indicates whether to drop traffic that matches this route.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_gateway_route(
#'   DestinationCidrBlock = "string",
#'   TransitGatewayRouteTableId = "string",
#'   TransitGatewayAttachmentId = "string",
#'   Blackhole = TRUE|FALSE,
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_route
ec2_create_transit_gateway_route <- function(DestinationCidrBlock, TransitGatewayRouteTableId, TransitGatewayAttachmentId = NULL, Blackhole = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_transit_gateway_route_input(DestinationCidrBlock = DestinationCidrBlock, TransitGatewayRouteTableId = TransitGatewayRouteTableId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, Blackhole = Blackhole, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_route <- ec2_create_transit_gateway_route

#' Creates a route table for the specified transit gateway
#'
#' Creates a route table for the specified transit gateway.
#'
#' @usage
#' ec2_create_transit_gateway_route_table(TransitGatewayId,
#'   TagSpecifications, DryRun)
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway.
#' @param TagSpecifications The tags to apply to the transit gateway route table.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_gateway_route_table(
#'   TransitGatewayId = "string",
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_route_table
ec2_create_transit_gateway_route_table <- function(TransitGatewayId, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayRouteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_transit_gateway_route_table_input(TransitGatewayId = TransitGatewayId, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_route_table <- ec2_create_transit_gateway_route_table

#' Attaches the specified VPC to the specified transit gateway
#'
#' Attaches the specified VPC to the specified transit gateway.
#' 
#' If you attach a VPC with a CIDR range that overlaps the CIDR range of a
#' VPC that is already attached, the new VPC CIDR range is not propagated
#' to the default propagation route table.
#' 
#' To send VPC traffic to an attached transit gateway, add a route to the
#' VPC route table using CreateRoute.
#'
#' @usage
#' ec2_create_transit_gateway_vpc_attachment(TransitGatewayId, VpcId,
#'   SubnetIds, Options, TagSpecifications, DryRun)
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param SubnetIds &#91;required&#93; The IDs of one or more subnets. You can specify only one subnet per
#' Availability Zone. You must specify at least one subnet, but we
#' recommend that you specify two subnets for better availability. The
#' transit gateway uses one IP address from each specified subnet.
#' @param Options The VPC attachment options.
#' @param TagSpecifications The tags to apply to the VPC attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_transit_gateway_vpc_attachment(
#'   TransitGatewayId = "string",
#'   VpcId = "string",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   Options = list(
#'     DnsSupport = "enable"|"disable",
#'     Ipv6Support = "enable"|"disable"
#'   ),
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_transit_gateway_vpc_attachment
ec2_create_transit_gateway_vpc_attachment <- function(TransitGatewayId, VpcId, SubnetIds, Options = NULL, TagSpecifications = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateTransitGatewayVpcAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_transit_gateway_vpc_attachment_input(TransitGatewayId = TransitGatewayId, VpcId = VpcId, SubnetIds = SubnetIds, Options = Options, TagSpecifications = TagSpecifications, DryRun = DryRun)
  output <- .ec2$create_transit_gateway_vpc_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_transit_gateway_vpc_attachment <- ec2_create_transit_gateway_vpc_attachment

#' Creates an EBS volume that can be attached to an instance in the same
#' Availability Zone
#'
#' Creates an EBS volume that can be attached to an instance in the same
#' Availability Zone. The volume is created in the regional endpoint that
#' you send the HTTP request to. For more information see [Regions and
#' Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html).
#' 
#' You can create a new empty volume or restore a volume from an EBS
#' snapshot. Any AWS Marketplace product codes from the snapshot are
#' propagated to the volume.
#' 
#' You can create encrypted volumes. Encrypted volumes must be attached to
#' instances that support Amazon EBS encryption. Volumes that are created
#' from encrypted snapshots are also automatically encrypted. For more
#' information, see [Amazon EBS
#' Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' You can tag your volumes during creation. For more information, see
#' [Tagging Your Amazon EC2
#' Resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' For more information, see [Creating an Amazon EBS
#' Volume](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-creating-volume.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_volume(AvailabilityZone, Encrypted, Iops, KmsKeyId,
#'   OutpostArn, Size, SnapshotId, VolumeType, DryRun, TagSpecifications)
#'
#' @param AvailabilityZone &#91;required&#93; The Availability Zone in which to create the volume.
#' @param Encrypted Specifies whether the volume should be encrypted. The effect of setting
#' the encryption state to `true` depends on the volume origin (new or from
#' a snapshot), starting encryption state, ownership, and whether
#' encryption by default is enabled. For more information, see [Encryption
#' by
#' Default](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#encryption-by-default)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' Encrypted Amazon EBS volumes must be attached to instances that support
#' Amazon EBS encryption. For more information, see [Supported Instance
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances).
#' @param Iops The number of I/O operations per second (IOPS) to provision for the
#' volume, with a maximum ratio of 50 IOPS/GiB. Range is 100 to 64,000 IOPS
#' for volumes in most Regions. Maximum IOPS of 64,000 is guaranteed only
#' on [Nitro-based
#' instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html#ec2-nitro-instances).
#' Other instance families guarantee performance up to 32,000 IOPS. For
#' more information, see [Amazon EBS Volume
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' This parameter is valid only for Provisioned IOPS SSD (io1) volumes.
#' @param KmsKeyId The identifier of the AWS Key Management Service (AWS KMS) customer
#' master key (CMK) to use for Amazon EBS encryption. If this parameter is
#' not specified, your AWS managed CMK for EBS is used. If `KmsKeyId` is
#' specified, the encrypted state must be `true`.
#' 
#' You can specify the CMK using any of the following:
#' 
#' -   Key ID. For example, key/1234abcd-12ab-34cd-56ef-1234567890ab.
#' 
#' -   Key alias. For example, alias/ExampleAlias.
#' 
#' -   Key ARN. For example,
#'     arn:aws:kms:*us-east-1*:*012345678910*:key/*abcd1234-a123-456a-a12b-a123b4cd56ef*.
#' 
#' -   Alias ARN. For example,
#'     arn:aws:kms:*us-east-1*:*012345678910*:alias/*ExampleAlias*.
#' 
#' AWS authenticates the CMK asynchronously. Therefore, if you specify an
#' ID, alias, or ARN that is not valid, the action can appear to complete,
#' but eventually fails.
#' @param OutpostArn The Amazon Resource Name (ARN) of the Outpost.
#' @param Size The size of the volume, in GiBs.
#' 
#' Constraints: 1-16,384 for `gp2`, 4-16,384 for `io1`, 500-16,384 for
#' `st1`, 500-16,384 for `sc1`, and 1-1,024 for `standard`. If you specify
#' a snapshot, the volume size must be equal to or larger than the snapshot
#' size.
#' 
#' Default: If you\'re creating the volume from a snapshot and don\'t
#' specify a volume size, the default is the snapshot size.
#' 
#' At least one of Size or SnapshotId is required.
#' @param SnapshotId The snapshot from which to create the volume.
#' 
#' At least one of Size or SnapshotId are required.
#' @param VolumeType The volume type. This can be `gp2` for General Purpose SSD, `io1` for
#' Provisioned IOPS SSD, `st1` for Throughput Optimized HDD, `sc1` for Cold
#' HDD, or `standard` for Magnetic volumes.
#' 
#' Default: `gp2`
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param TagSpecifications The tags to apply to the volume during creation.
#'
#' @section Request syntax:
#' ```
#' svc$create_volume(
#'   AvailabilityZone = "string",
#'   Encrypted = TRUE|FALSE,
#'   Iops = 123,
#'   KmsKeyId = "string",
#'   OutpostArn = "string",
#'   Size = 123,
#'   SnapshotId = "string",
#'   VolumeType = "standard"|"io1"|"gp2"|"sc1"|"st1",
#'   DryRun = TRUE|FALSE,
#'   TagSpecifications = list(
#'     list(
#'       ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"elastic-ip"|"fleet"|"fpga-image"|"host-reservation"|"image"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"natgateway"|"network-acl"|"network-interface"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway",
#'       Tags = list(
#'         list(
#'           Key = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example creates an 80 GiB General Purpose (SSD) volume in the
#' # Availability Zone `us-east-1a`.
#' \dontrun{svc$create_volume(
#'   AvailabilityZone = "us-east-1a",
#'   Size = 80L,
#'   VolumeType = "gp2"
#' )}
#' 
#' # This example creates a new Provisioned IOPS (SSD) volume with 1000
#' # provisioned IOPS from a snapshot in the Availability Zone
#' # `us-east-1a`.
#' \dontrun{svc$create_volume(
#'   AvailabilityZone = "us-east-1a",
#'   Iops = 1000L,
#'   SnapshotId = "snap-066877671789bd71b",
#'   VolumeType = "io1"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_volume
ec2_create_volume <- function(AvailabilityZone, Encrypted = NULL, Iops = NULL, KmsKeyId = NULL, OutpostArn = NULL, Size = NULL, SnapshotId = NULL, VolumeType = NULL, DryRun = NULL, TagSpecifications = NULL) {
  op <- new_operation(
    name = "CreateVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_volume_input(AvailabilityZone = AvailabilityZone, Encrypted = Encrypted, Iops = Iops, KmsKeyId = KmsKeyId, OutpostArn = OutpostArn, Size = Size, SnapshotId = SnapshotId, VolumeType = VolumeType, DryRun = DryRun, TagSpecifications = TagSpecifications)
  output <- .ec2$create_volume_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_volume <- ec2_create_volume

#' Creates a VPC with the specified IPv4 CIDR block
#'
#' Creates a VPC with the specified IPv4 CIDR block. The smallest VPC you
#' can create uses a /28 netmask (16 IPv4 addresses), and the largest uses
#' a /16 netmask (65,536 IPv4 addresses). For more information about how
#' large to make your VPC, see [Your VPC and
#' Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' 
#' You can optionally request an Amazon-provided IPv6 CIDR block for the
#' VPC. The IPv6 CIDR block uses a /56 prefix length, and is allocated from
#' Amazon\'s pool of IPv6 addresses. You cannot choose the IPv6 range for
#' your VPC.
#' 
#' By default, each instance you launch in the VPC has the default DHCP
#' options, which include only a default DNS server that we provide
#' (AmazonProvidedDNS). For more information, see [DHCP Options
#' Sets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' 
#' You can specify the instance tenancy value for the VPC when you create
#' it. You can\'t change this value for the VPC after you create it. For
#' more information, see [Dedicated
#' Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-instance.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_create_vpc(CidrBlock, AmazonProvidedIpv6CidrBlock, DryRun,
#'   InstanceTenancy, Ipv6CidrBlockNetworkBorderGroup)
#'
#' @param CidrBlock &#91;required&#93; The IPv4 network range for the VPC, in CIDR notation. For example,
#' `10.0.0.0/16`.
#' @param AmazonProvidedIpv6CidrBlock Requests an Amazon-provided IPv6 CIDR block with a /56 prefix length for
#' the VPC. You cannot specify the range of IP addresses, or the size of
#' the CIDR block.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceTenancy The tenancy options for instances launched into the VPC. For `default`,
#' instances are launched with shared tenancy by default. You can launch
#' instances with any tenancy into a shared tenancy VPC. For `dedicated`,
#' instances are launched as dedicated tenancy instances by default. You
#' can only launch instances with a tenancy of `dedicated` or `host` into a
#' dedicated tenancy VPC.
#' 
#' **Important:** The `host` value cannot be used with this parameter. Use
#' the `default` or `dedicated` values only.
#' 
#' Default: `default`
#' @param Ipv6CidrBlockNetworkBorderGroup The name of the location from which we advertise the IPV6 CIDR block.
#' Use this parameter to limit the address to this location.
#' 
#' You must set `AmazonProvidedIpv6CidrBlock` to `true` to use this
#' parameter.
#'
#' @section Request syntax:
#' ```
#' svc$create_vpc(
#'   CidrBlock = "string",
#'   AmazonProvidedIpv6CidrBlock = TRUE|FALSE,
#'   DryRun = TRUE|FALSE,
#'   InstanceTenancy = "default"|"dedicated"|"host",
#'   Ipv6CidrBlockNetworkBorderGroup = "string"
#' )
#' ```
#'
#' @examples
#' # This example creates a VPC with the specified CIDR block.
#' \dontrun{svc$create_vpc(
#'   CidrBlock = "10.0.0.0/16"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc
ec2_create_vpc <- function(CidrBlock, AmazonProvidedIpv6CidrBlock = NULL, DryRun = NULL, InstanceTenancy = NULL, Ipv6CidrBlockNetworkBorderGroup = NULL) {
  op <- new_operation(
    name = "CreateVpc",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpc_input(CidrBlock = CidrBlock, AmazonProvidedIpv6CidrBlock = AmazonProvidedIpv6CidrBlock, DryRun = DryRun, InstanceTenancy = InstanceTenancy, Ipv6CidrBlockNetworkBorderGroup = Ipv6CidrBlockNetworkBorderGroup)
  output <- .ec2$create_vpc_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc <- ec2_create_vpc

#' Creates a VPC endpoint for a specified service
#'
#' Creates a VPC endpoint for a specified service. An endpoint enables you
#' to create a private connection between your VPC and the service. The
#' service may be provided by AWS, an AWS Marketplace Partner, or another
#' AWS account. For more information, see [VPC
#' Endpoints](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' 
#' A `gateway` endpoint serves as a target for a route in your route table
#' for traffic destined for the AWS service. You can specify an endpoint
#' policy to attach to the endpoint, which will control access to the
#' service from your VPC. You can also specify the VPC route tables that
#' use the endpoint.
#' 
#' An `interface` endpoint is a network interface in your subnet that
#' serves as an endpoint for communicating with the specified service. You
#' can specify the subnets in which to create an endpoint, and the security
#' groups to associate with the endpoint network interface.
#' 
#' Use DescribeVpcEndpointServices to get a list of supported services.
#'
#' @usage
#' ec2_create_vpc_endpoint(DryRun, VpcEndpointType, VpcId, ServiceName,
#'   PolicyDocument, RouteTableIds, SubnetIds, SecurityGroupIds, ClientToken,
#'   PrivateDnsEnabled)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcEndpointType The type of endpoint.
#' 
#' Default: Gateway
#' @param VpcId &#91;required&#93; The ID of the VPC in which the endpoint will be used.
#' @param ServiceName &#91;required&#93; The service name. To get a list of available services, use the
#' DescribeVpcEndpointServices request, or get the name from the service
#' provider.
#' @param PolicyDocument A policy to attach to the endpoint that controls access to the service.
#' The policy must be in valid JSON format. If this parameter is not
#' specified, we attach a default policy that allows full access to the
#' service.
#' @param RouteTableIds (Gateway endpoint) One or more route table IDs.
#' @param SubnetIds (Interface endpoint) The ID of one or more subnets in which to create an
#' endpoint network interface.
#' @param SecurityGroupIds (Interface endpoint) The ID of one or more security groups to associate
#' with the endpoint network interface.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param PrivateDnsEnabled (Interface endpoint) Indicates whether to associate a private hosted
#' zone with the specified VPC. The private hosted zone contains a record
#' set for the default public DNS name for the service for the Region (for
#' example, `kinesis.us-east-1.amazonaws.com`), which resolves to the
#' private IP addresses of the endpoint network interfaces in the VPC. This
#' enables you to make requests to the default public DNS name for the
#' service instead of the public DNS names that are automatically generated
#' by the VPC endpoint service.
#' 
#' To use a private hosted zone, you must set the following VPC attributes
#' to `true`: `enableDnsHostnames` and `enableDnsSupport`. Use
#' ModifyVpcAttribute to set the VPC attributes.
#' 
#' Default: `true`
#'
#' @section Request syntax:
#' ```
#' svc$create_vpc_endpoint(
#'   DryRun = TRUE|FALSE,
#'   VpcEndpointType = "Interface"|"Gateway",
#'   VpcId = "string",
#'   ServiceName = "string",
#'   PolicyDocument = "string",
#'   RouteTableIds = list(
#'     "string"
#'   ),
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   ClientToken = "string",
#'   PrivateDnsEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc_endpoint
ec2_create_vpc_endpoint <- function(DryRun = NULL, VpcEndpointType = NULL, VpcId, ServiceName, PolicyDocument = NULL, RouteTableIds = NULL, SubnetIds = NULL, SecurityGroupIds = NULL, ClientToken = NULL, PrivateDnsEnabled = NULL) {
  op <- new_operation(
    name = "CreateVpcEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpc_endpoint_input(DryRun = DryRun, VpcEndpointType = VpcEndpointType, VpcId = VpcId, ServiceName = ServiceName, PolicyDocument = PolicyDocument, RouteTableIds = RouteTableIds, SubnetIds = SubnetIds, SecurityGroupIds = SecurityGroupIds, ClientToken = ClientToken, PrivateDnsEnabled = PrivateDnsEnabled)
  output <- .ec2$create_vpc_endpoint_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc_endpoint <- ec2_create_vpc_endpoint

#' Creates a connection notification for a specified VPC endpoint or VPC
#' endpoint service
#'
#' Creates a connection notification for a specified VPC endpoint or VPC
#' endpoint service. A connection notification notifies you of specific
#' endpoint events. You must create an SNS topic to receive notifications.
#' For more information, see [Create a
#' Topic](https://docs.aws.amazon.com/sns/latest/dg/CreateTopic.html) in
#' the *Amazon Simple Notification Service Developer Guide*.
#' 
#' You can create a connection notification for interface endpoints only.
#'
#' @usage
#' ec2_create_vpc_endpoint_connection_notification(DryRun, ServiceId,
#'   VpcEndpointId, ConnectionNotificationArn, ConnectionEvents, ClientToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ServiceId The ID of the endpoint service.
#' @param VpcEndpointId The ID of the endpoint.
#' @param ConnectionNotificationArn &#91;required&#93; The ARN of the SNS topic for the notifications.
#' @param ConnectionEvents &#91;required&#93; One or more endpoint events for which to receive notifications. Valid
#' values are `Accept`, `Connect`, `Delete`, and `Reject`.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_vpc_endpoint_connection_notification(
#'   DryRun = TRUE|FALSE,
#'   ServiceId = "string",
#'   VpcEndpointId = "string",
#'   ConnectionNotificationArn = "string",
#'   ConnectionEvents = list(
#'     "string"
#'   ),
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc_endpoint_connection_notification
ec2_create_vpc_endpoint_connection_notification <- function(DryRun = NULL, ServiceId = NULL, VpcEndpointId = NULL, ConnectionNotificationArn, ConnectionEvents, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateVpcEndpointConnectionNotification",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpc_endpoint_connection_notification_input(DryRun = DryRun, ServiceId = ServiceId, VpcEndpointId = VpcEndpointId, ConnectionNotificationArn = ConnectionNotificationArn, ConnectionEvents = ConnectionEvents, ClientToken = ClientToken)
  output <- .ec2$create_vpc_endpoint_connection_notification_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc_endpoint_connection_notification <- ec2_create_vpc_endpoint_connection_notification

#' Creates a VPC endpoint service configuration to which service consumers
#' (AWS accounts, IAM users, and IAM roles) can connect
#'
#' Creates a VPC endpoint service configuration to which service consumers
#' (AWS accounts, IAM users, and IAM roles) can connect. Service consumers
#' can create an interface VPC endpoint to connect to your service.
#' 
#' To create an endpoint service configuration, you must first create a
#' Network Load Balancer for your service. For more information, see [VPC
#' Endpoint
#' Services](https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-service.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#' 
#' If you set the private DNS name, you must prove that you own the private
#' DNS domain name. For more information, see [VPC Endpoint Service Private
#' DNS Name
#' Verification](https://docs.aws.amazon.com/vpc/latest/userguide/endpoint-services-dns-validation.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_create_vpc_endpoint_service_configuration(DryRun,
#'   AcceptanceRequired, PrivateDnsName, NetworkLoadBalancerArns,
#'   ClientToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param AcceptanceRequired Indicates whether requests from service consumers to create an endpoint
#' to your service must be accepted. To accept a request, use
#' AcceptVpcEndpointConnections.
#' @param PrivateDnsName The private DNS name to assign to the VPC endpoint service.
#' @param NetworkLoadBalancerArns &#91;required&#93; The Amazon Resource Names (ARNs) of one or more Network Load Balancers
#' for your service.
#' @param ClientToken Unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. For more information, see [How to Ensure
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Run_Instance_Idempotency.html).
#'
#' @section Request syntax:
#' ```
#' svc$create_vpc_endpoint_service_configuration(
#'   DryRun = TRUE|FALSE,
#'   AcceptanceRequired = TRUE|FALSE,
#'   PrivateDnsName = "string",
#'   NetworkLoadBalancerArns = list(
#'     "string"
#'   ),
#'   ClientToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc_endpoint_service_configuration
ec2_create_vpc_endpoint_service_configuration <- function(DryRun = NULL, AcceptanceRequired = NULL, PrivateDnsName = NULL, NetworkLoadBalancerArns, ClientToken = NULL) {
  op <- new_operation(
    name = "CreateVpcEndpointServiceConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpc_endpoint_service_configuration_input(DryRun = DryRun, AcceptanceRequired = AcceptanceRequired, PrivateDnsName = PrivateDnsName, NetworkLoadBalancerArns = NetworkLoadBalancerArns, ClientToken = ClientToken)
  output <- .ec2$create_vpc_endpoint_service_configuration_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc_endpoint_service_configuration <- ec2_create_vpc_endpoint_service_configuration

#' Requests a VPC peering connection between two VPCs: a requester VPC that
#' you own and an accepter VPC with which to create the connection
#'
#' Requests a VPC peering connection between two VPCs: a requester VPC that
#' you own and an accepter VPC with which to create the connection. The
#' accepter VPC can belong to another AWS account and can be in a different
#' Region to the requester VPC. The requester VPC and accepter VPC cannot
#' have overlapping CIDR blocks.
#' 
#' Limitations and rules apply to a VPC peering connection. For more
#' information, see the
#' [limitations](https://docs.aws.amazon.com/vpc/latest/peering/vpc-peering-basics.html#vpc-peering-limitations)
#' section in the *VPC Peering Guide*.
#' 
#' The owner of the accepter VPC must accept the peering request to
#' activate the peering connection. The VPC peering connection request
#' expires after 7 days, after which it cannot be accepted or rejected.
#' 
#' If you create a VPC peering connection request between VPCs with
#' overlapping CIDR blocks, the VPC peering connection has a status of
#' `failed`.
#'
#' @usage
#' ec2_create_vpc_peering_connection(DryRun, PeerOwnerId, PeerVpcId, VpcId,
#'   PeerRegion)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param PeerOwnerId The AWS account ID of the owner of the accepter VPC.
#' 
#' Default: Your AWS account ID
#' @param PeerVpcId The ID of the VPC with which you are creating the VPC peering
#' connection. You must specify this parameter in the request.
#' @param VpcId The ID of the requester VPC. You must specify this parameter in the
#' request.
#' @param PeerRegion The Region code for the accepter VPC, if the accepter VPC is located in
#' a Region other than the Region in which you make the request.
#' 
#' Default: The Region in which you make the request.
#'
#' @section Request syntax:
#' ```
#' svc$create_vpc_peering_connection(
#'   DryRun = TRUE|FALSE,
#'   PeerOwnerId = "string",
#'   PeerVpcId = "string",
#'   VpcId = "string",
#'   PeerRegion = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpc_peering_connection
ec2_create_vpc_peering_connection <- function(DryRun = NULL, PeerOwnerId = NULL, PeerVpcId = NULL, VpcId = NULL, PeerRegion = NULL) {
  op <- new_operation(
    name = "CreateVpcPeeringConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpc_peering_connection_input(DryRun = DryRun, PeerOwnerId = PeerOwnerId, PeerVpcId = PeerVpcId, VpcId = VpcId, PeerRegion = PeerRegion)
  output <- .ec2$create_vpc_peering_connection_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpc_peering_connection <- ec2_create_vpc_peering_connection

#' Creates a VPN connection between an existing virtual private gateway and
#' a VPN customer gateway
#'
#' Creates a VPN connection between an existing virtual private gateway and
#' a VPN customer gateway. The supported connection type is `ipsec.1`.
#' 
#' The response includes information that you need to give to your network
#' administrator to configure your customer gateway.
#' 
#' We strongly recommend that you use HTTPS when calling this operation
#' because the response contains sensitive cryptographic information for
#' configuring your customer gateway.
#' 
#' If you decide to shut down your VPN connection for any reason and later
#' create a new VPN connection, you must reconfigure your customer gateway
#' with the new information returned from this call.
#' 
#' This is an idempotent operation. If you perform the operation more than
#' once, Amazon EC2 doesn\'t return an error.
#' 
#' For more information, see [AWS Site-to-Site
#' VPN](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the
#' *AWS Site-to-Site VPN User Guide*.
#'
#' @usage
#' ec2_create_vpn_connection(CustomerGatewayId, Type, VpnGatewayId,
#'   TransitGatewayId, DryRun, Options)
#'
#' @param CustomerGatewayId &#91;required&#93; The ID of the customer gateway.
#' @param Type &#91;required&#93; The type of VPN connection (`ipsec.1`).
#' @param VpnGatewayId The ID of the virtual private gateway. If you specify a virtual private
#' gateway, you cannot specify a transit gateway.
#' @param TransitGatewayId The ID of the transit gateway. If you specify a transit gateway, you
#' cannot specify a virtual private gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Options The options for the VPN connection.
#'
#' @section Request syntax:
#' ```
#' svc$create_vpn_connection(
#'   CustomerGatewayId = "string",
#'   Type = "string",
#'   VpnGatewayId = "string",
#'   TransitGatewayId = "string",
#'   DryRun = TRUE|FALSE,
#'   Options = list(
#'     EnableAcceleration = TRUE|FALSE,
#'     StaticRoutesOnly = TRUE|FALSE,
#'     TunnelOptions = list(
#'       list(
#'         TunnelInsideCidr = "string",
#'         PreSharedKey = "string",
#'         Phase1LifetimeSeconds = 123,
#'         Phase2LifetimeSeconds = 123,
#'         RekeyMarginTimeSeconds = 123,
#'         RekeyFuzzPercentage = 123,
#'         ReplayWindowSize = 123,
#'         DPDTimeoutSeconds = 123,
#'         Phase1EncryptionAlgorithms = list(
#'           list(
#'             Value = "string"
#'           )
#'         ),
#'         Phase2EncryptionAlgorithms = list(
#'           list(
#'             Value = "string"
#'           )
#'         ),
#'         Phase1IntegrityAlgorithms = list(
#'           list(
#'             Value = "string"
#'           )
#'         ),
#'         Phase2IntegrityAlgorithms = list(
#'           list(
#'             Value = "string"
#'           )
#'         ),
#'         Phase1DHGroupNumbers = list(
#'           list(
#'             Value = 123
#'           )
#'         ),
#'         Phase2DHGroupNumbers = list(
#'           list(
#'             Value = 123
#'           )
#'         ),
#'         IKEVersions = list(
#'           list(
#'             Value = "string"
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpn_connection
ec2_create_vpn_connection <- function(CustomerGatewayId, Type, VpnGatewayId = NULL, TransitGatewayId = NULL, DryRun = NULL, Options = NULL) {
  op <- new_operation(
    name = "CreateVpnConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpn_connection_input(CustomerGatewayId = CustomerGatewayId, Type = Type, VpnGatewayId = VpnGatewayId, TransitGatewayId = TransitGatewayId, DryRun = DryRun, Options = Options)
  output <- .ec2$create_vpn_connection_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpn_connection <- ec2_create_vpn_connection

#' Creates a static route associated with a VPN connection between an
#' existing virtual private gateway and a VPN customer gateway
#'
#' Creates a static route associated with a VPN connection between an
#' existing virtual private gateway and a VPN customer gateway. The static
#' route allows traffic to be routed from the virtual private gateway to
#' the VPN customer gateway.
#' 
#' For more information, see [AWS Site-to-Site
#' VPN](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the
#' *AWS Site-to-Site VPN User Guide*.
#'
#' @usage
#' ec2_create_vpn_connection_route(DestinationCidrBlock, VpnConnectionId)
#'
#' @param DestinationCidrBlock &#91;required&#93; The CIDR block associated with the local subnet of the customer network.
#' @param VpnConnectionId &#91;required&#93; The ID of the VPN connection.
#'
#' @section Request syntax:
#' ```
#' svc$create_vpn_connection_route(
#'   DestinationCidrBlock = "string",
#'   VpnConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpn_connection_route
ec2_create_vpn_connection_route <- function(DestinationCidrBlock, VpnConnectionId) {
  op <- new_operation(
    name = "CreateVpnConnectionRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpn_connection_route_input(DestinationCidrBlock = DestinationCidrBlock, VpnConnectionId = VpnConnectionId)
  output <- .ec2$create_vpn_connection_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpn_connection_route <- ec2_create_vpn_connection_route

#' Creates a virtual private gateway
#'
#' Creates a virtual private gateway. A virtual private gateway is the
#' endpoint on the VPC side of your VPN connection. You can create a
#' virtual private gateway before creating the VPC itself.
#' 
#' For more information, see [AWS Site-to-Site
#' VPN](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the
#' *AWS Site-to-Site VPN User Guide*.
#'
#' @usage
#' ec2_create_vpn_gateway(AvailabilityZone, Type, AmazonSideAsn, DryRun)
#'
#' @param AvailabilityZone The Availability Zone for the virtual private gateway.
#' @param Type &#91;required&#93; The type of VPN connection this virtual private gateway supports.
#' @param AmazonSideAsn A private Autonomous System Number (ASN) for the Amazon side of a BGP
#' session. If you\'re using a 16-bit ASN, it must be in the 64512 to 65534
#' range. If you\'re using a 32-bit ASN, it must be in the 4200000000 to
#' 4294967294 range.
#' 
#' Default: 64512
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$create_vpn_gateway(
#'   AvailabilityZone = "string",
#'   Type = "ipsec.1",
#'   AmazonSideAsn = 123,
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_create_vpn_gateway
ec2_create_vpn_gateway <- function(AvailabilityZone = NULL, Type, AmazonSideAsn = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "CreateVpnGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$create_vpn_gateway_input(AvailabilityZone = AvailabilityZone, Type = Type, AmazonSideAsn = AmazonSideAsn, DryRun = DryRun)
  output <- .ec2$create_vpn_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$create_vpn_gateway <- ec2_create_vpn_gateway

#' Deletes the specified Client VPN endpoint
#'
#' Deletes the specified Client VPN endpoint. You must disassociate all
#' target networks before you can delete a Client VPN endpoint.
#'
#' @usage
#' ec2_delete_client_vpn_endpoint(ClientVpnEndpointId, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN to be deleted.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_client_vpn_endpoint(
#'   ClientVpnEndpointId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_client_vpn_endpoint
ec2_delete_client_vpn_endpoint <- function(ClientVpnEndpointId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteClientVpnEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_client_vpn_endpoint_input(ClientVpnEndpointId = ClientVpnEndpointId, DryRun = DryRun)
  output <- .ec2$delete_client_vpn_endpoint_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_client_vpn_endpoint <- ec2_delete_client_vpn_endpoint

#' Deletes a route from a Client VPN endpoint
#'
#' Deletes a route from a Client VPN endpoint. You can only delete routes
#' that you manually added using the **CreateClientVpnRoute** action. You
#' cannot delete routes that were automatically added when associating a
#' subnet. To remove routes that have been automatically added,
#' disassociate the target subnet from the Client VPN endpoint.
#'
#' @usage
#' ec2_delete_client_vpn_route(ClientVpnEndpointId, TargetVpcSubnetId,
#'   DestinationCidrBlock, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint from which the route is to be deleted.
#' @param TargetVpcSubnetId The ID of the target subnet used by the route.
#' @param DestinationCidrBlock &#91;required&#93; The IPv4 address range, in CIDR notation, of the route to be deleted.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_client_vpn_route(
#'   ClientVpnEndpointId = "string",
#'   TargetVpcSubnetId = "string",
#'   DestinationCidrBlock = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_client_vpn_route
ec2_delete_client_vpn_route <- function(ClientVpnEndpointId, TargetVpcSubnetId = NULL, DestinationCidrBlock, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteClientVpnRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_client_vpn_route_input(ClientVpnEndpointId = ClientVpnEndpointId, TargetVpcSubnetId = TargetVpcSubnetId, DestinationCidrBlock = DestinationCidrBlock, DryRun = DryRun)
  output <- .ec2$delete_client_vpn_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_client_vpn_route <- ec2_delete_client_vpn_route

#' Deletes the specified customer gateway
#'
#' Deletes the specified customer gateway. You must delete the VPN
#' connection before you can delete the customer gateway.
#'
#' @usage
#' ec2_delete_customer_gateway(CustomerGatewayId, DryRun)
#'
#' @param CustomerGatewayId &#91;required&#93; The ID of the customer gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_customer_gateway(
#'   CustomerGatewayId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified customer gateway.
#' \dontrun{svc$delete_customer_gateway(
#'   CustomerGatewayId = "cgw-0e11f167"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_customer_gateway
ec2_delete_customer_gateway <- function(CustomerGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteCustomerGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_customer_gateway_input(CustomerGatewayId = CustomerGatewayId, DryRun = DryRun)
  output <- .ec2$delete_customer_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_customer_gateway <- ec2_delete_customer_gateway

#' Deletes the specified set of DHCP options
#'
#' Deletes the specified set of DHCP options. You must disassociate the set
#' of DHCP options before you can delete it. You can disassociate the set
#' of DHCP options by associating either a new set of options or the
#' default set of options with the VPC.
#'
#' @usage
#' ec2_delete_dhcp_options(DhcpOptionsId, DryRun)
#'
#' @param DhcpOptionsId &#91;required&#93; The ID of the DHCP options set.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_dhcp_options(
#'   DhcpOptionsId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified DHCP options set.
#' \dontrun{svc$delete_dhcp_options(
#'   DhcpOptionsId = "dopt-d9070ebb"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_dhcp_options
ec2_delete_dhcp_options <- function(DhcpOptionsId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteDhcpOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_dhcp_options_input(DhcpOptionsId = DhcpOptionsId, DryRun = DryRun)
  output <- .ec2$delete_dhcp_options_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_dhcp_options <- ec2_delete_dhcp_options

#' Deletes an egress-only internet gateway
#'
#' Deletes an egress-only internet gateway.
#'
#' @usage
#' ec2_delete_egress_only_internet_gateway(DryRun,
#'   EgressOnlyInternetGatewayId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param EgressOnlyInternetGatewayId &#91;required&#93; The ID of the egress-only internet gateway.
#'
#' @section Request syntax:
#' ```
#' svc$delete_egress_only_internet_gateway(
#'   DryRun = TRUE|FALSE,
#'   EgressOnlyInternetGatewayId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_egress_only_internet_gateway
ec2_delete_egress_only_internet_gateway <- function(DryRun = NULL, EgressOnlyInternetGatewayId) {
  op <- new_operation(
    name = "DeleteEgressOnlyInternetGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_egress_only_internet_gateway_input(DryRun = DryRun, EgressOnlyInternetGatewayId = EgressOnlyInternetGatewayId)
  output <- .ec2$delete_egress_only_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_egress_only_internet_gateway <- ec2_delete_egress_only_internet_gateway

#' Deletes the specified EC2 Fleet
#'
#' Deletes the specified EC2 Fleet.
#' 
#' After you delete an EC2 Fleet, it launches no new instances. You must
#' specify whether an EC2 Fleet should also terminate its instances. If you
#' terminate the instances, the EC2 Fleet enters the `deleted_terminating`
#' state. Otherwise, the EC2 Fleet enters the `deleted_running` state, and
#' the instances continue to run until they are interrupted or you
#' terminate them manually.
#'
#' @usage
#' ec2_delete_fleets(DryRun, FleetIds, TerminateInstances)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FleetIds &#91;required&#93; The IDs of the EC2 Fleets.
#' @param TerminateInstances &#91;required&#93; Indicates whether to terminate instances for an EC2 Fleet if it is
#' deleted successfully.
#'
#' @section Request syntax:
#' ```
#' svc$delete_fleets(
#'   DryRun = TRUE|FALSE,
#'   FleetIds = list(
#'     "string"
#'   ),
#'   TerminateInstances = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_fleets
ec2_delete_fleets <- function(DryRun = NULL, FleetIds, TerminateInstances) {
  op <- new_operation(
    name = "DeleteFleets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_fleets_input(DryRun = DryRun, FleetIds = FleetIds, TerminateInstances = TerminateInstances)
  output <- .ec2$delete_fleets_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_fleets <- ec2_delete_fleets

#' Deletes one or more flow logs
#'
#' Deletes one or more flow logs.
#'
#' @usage
#' ec2_delete_flow_logs(DryRun, FlowLogIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FlowLogIds &#91;required&#93; One or more flow log IDs.
#' 
#' Constraint: Maximum of 1000 flow log IDs.
#'
#' @section Request syntax:
#' ```
#' svc$delete_flow_logs(
#'   DryRun = TRUE|FALSE,
#'   FlowLogIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_flow_logs
ec2_delete_flow_logs <- function(DryRun = NULL, FlowLogIds) {
  op <- new_operation(
    name = "DeleteFlowLogs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_flow_logs_input(DryRun = DryRun, FlowLogIds = FlowLogIds)
  output <- .ec2$delete_flow_logs_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_flow_logs <- ec2_delete_flow_logs

#' Deletes the specified Amazon FPGA Image (AFI)
#'
#' Deletes the specified Amazon FPGA Image (AFI).
#'
#' @usage
#' ec2_delete_fpga_image(DryRun, FpgaImageId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FpgaImageId &#91;required&#93; The ID of the AFI.
#'
#' @section Request syntax:
#' ```
#' svc$delete_fpga_image(
#'   DryRun = TRUE|FALSE,
#'   FpgaImageId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_fpga_image
ec2_delete_fpga_image <- function(DryRun = NULL, FpgaImageId) {
  op <- new_operation(
    name = "DeleteFpgaImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_fpga_image_input(DryRun = DryRun, FpgaImageId = FpgaImageId)
  output <- .ec2$delete_fpga_image_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_fpga_image <- ec2_delete_fpga_image

#' Deletes the specified internet gateway
#'
#' Deletes the specified internet gateway. You must detach the internet
#' gateway from the VPC before you can delete it.
#'
#' @usage
#' ec2_delete_internet_gateway(DryRun, InternetGatewayId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InternetGatewayId &#91;required&#93; The ID of the internet gateway.
#'
#' @section Request syntax:
#' ```
#' svc$delete_internet_gateway(
#'   DryRun = TRUE|FALSE,
#'   InternetGatewayId = "string"
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified Internet gateway.
#' \dontrun{svc$delete_internet_gateway(
#'   InternetGatewayId = "igw-c0a643a9"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_internet_gateway
ec2_delete_internet_gateway <- function(DryRun = NULL, InternetGatewayId) {
  op <- new_operation(
    name = "DeleteInternetGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_internet_gateway_input(DryRun = DryRun, InternetGatewayId = InternetGatewayId)
  output <- .ec2$delete_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_internet_gateway <- ec2_delete_internet_gateway

#' Deletes the specified key pair, by removing the public key from Amazon
#' EC2
#'
#' Deletes the specified key pair, by removing the public key from Amazon
#' EC2.
#'
#' @usage
#' ec2_delete_key_pair(KeyName, DryRun)
#'
#' @param KeyName &#91;required&#93; The name of the key pair.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_key_pair(
#'   KeyName = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified key pair.
#' \dontrun{svc$delete_key_pair(
#'   KeyName = "my-key-pair"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_key_pair
ec2_delete_key_pair <- function(KeyName, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_key_pair_input(KeyName = KeyName, DryRun = DryRun)
  output <- .ec2$delete_key_pair_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_key_pair <- ec2_delete_key_pair

#' Deletes a launch template
#'
#' Deletes a launch template. Deleting a launch template deletes all of its
#' versions.
#'
#' @usage
#' ec2_delete_launch_template(DryRun, LaunchTemplateId, LaunchTemplateName)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LaunchTemplateId The ID of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#' @param LaunchTemplateName The name of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#'
#' @section Request syntax:
#' ```
#' svc$delete_launch_template(
#'   DryRun = TRUE|FALSE,
#'   LaunchTemplateId = "string",
#'   LaunchTemplateName = "string"
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified launch template.
#' \dontrun{svc$delete_launch_template(
#'   LaunchTemplateId = "lt-0abcd290751193123"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_launch_template
ec2_delete_launch_template <- function(DryRun = NULL, LaunchTemplateId = NULL, LaunchTemplateName = NULL) {
  op <- new_operation(
    name = "DeleteLaunchTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_launch_template_input(DryRun = DryRun, LaunchTemplateId = LaunchTemplateId, LaunchTemplateName = LaunchTemplateName)
  output <- .ec2$delete_launch_template_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_launch_template <- ec2_delete_launch_template

#' Deletes one or more versions of a launch template
#'
#' Deletes one or more versions of a launch template. You cannot delete the
#' default version of a launch template; you must first assign a different
#' version as the default. If the default version is the only version for
#' the launch template, you must delete the entire launch template using
#' DeleteLaunchTemplate.
#'
#' @usage
#' ec2_delete_launch_template_versions(DryRun, LaunchTemplateId,
#'   LaunchTemplateName, Versions)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LaunchTemplateId The ID of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#' @param LaunchTemplateName The name of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#' @param Versions &#91;required&#93; The version numbers of one or more launch template versions to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_launch_template_versions(
#'   DryRun = TRUE|FALSE,
#'   LaunchTemplateId = "string",
#'   LaunchTemplateName = "string",
#'   Versions = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified launch template version.
#' \dontrun{svc$delete_launch_template_versions(
#'   LaunchTemplateId = "lt-0abcd290751193123",
#'   Versions = list(
#'     "1"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_launch_template_versions
ec2_delete_launch_template_versions <- function(DryRun = NULL, LaunchTemplateId = NULL, LaunchTemplateName = NULL, Versions) {
  op <- new_operation(
    name = "DeleteLaunchTemplateVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_launch_template_versions_input(DryRun = DryRun, LaunchTemplateId = LaunchTemplateId, LaunchTemplateName = LaunchTemplateName, Versions = Versions)
  output <- .ec2$delete_launch_template_versions_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_launch_template_versions <- ec2_delete_launch_template_versions

#' Deletes the specified route from the specified local gateway route table
#'
#' Deletes the specified route from the specified local gateway route
#' table.
#'
#' @usage
#' ec2_delete_local_gateway_route(DestinationCidrBlock,
#'   LocalGatewayRouteTableId, DryRun)
#'
#' @param DestinationCidrBlock &#91;required&#93; The CIDR range for the route. This must match the CIDR for the route
#' exactly.
#' @param LocalGatewayRouteTableId &#91;required&#93; The ID of the local gateway route table.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_local_gateway_route(
#'   DestinationCidrBlock = "string",
#'   LocalGatewayRouteTableId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_local_gateway_route
ec2_delete_local_gateway_route <- function(DestinationCidrBlock, LocalGatewayRouteTableId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteLocalGatewayRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_local_gateway_route_input(DestinationCidrBlock = DestinationCidrBlock, LocalGatewayRouteTableId = LocalGatewayRouteTableId, DryRun = DryRun)
  output <- .ec2$delete_local_gateway_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_local_gateway_route <- ec2_delete_local_gateway_route

#' Deletes the specified association between a VPC and local gateway route
#' table
#'
#' Deletes the specified association between a VPC and local gateway route
#' table.
#'
#' @usage
#' ec2_delete_local_gateway_route_table_vpc_association(
#'   LocalGatewayRouteTableVpcAssociationId, DryRun)
#'
#' @param LocalGatewayRouteTableVpcAssociationId &#91;required&#93; The ID of the association.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_local_gateway_route_table_vpc_association(
#'   LocalGatewayRouteTableVpcAssociationId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_local_gateway_route_table_vpc_association
ec2_delete_local_gateway_route_table_vpc_association <- function(LocalGatewayRouteTableVpcAssociationId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteLocalGatewayRouteTableVpcAssociation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_local_gateway_route_table_vpc_association_input(LocalGatewayRouteTableVpcAssociationId = LocalGatewayRouteTableVpcAssociationId, DryRun = DryRun)
  output <- .ec2$delete_local_gateway_route_table_vpc_association_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_local_gateway_route_table_vpc_association <- ec2_delete_local_gateway_route_table_vpc_association

#' Deletes the specified NAT gateway
#'
#' Deletes the specified NAT gateway. Deleting a NAT gateway disassociates
#' its Elastic IP address, but does not release the address from your
#' account. Deleting a NAT gateway does not delete any NAT gateway routes
#' in your route tables.
#'
#' @usage
#' ec2_delete_nat_gateway(NatGatewayId)
#'
#' @param NatGatewayId &#91;required&#93; The ID of the NAT gateway.
#'
#' @section Request syntax:
#' ```
#' svc$delete_nat_gateway(
#'   NatGatewayId = "string"
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified NAT gateway.
#' \dontrun{svc$delete_nat_gateway(
#'   NatGatewayId = "nat-04ae55e711cec5680"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_nat_gateway
ec2_delete_nat_gateway <- function(NatGatewayId) {
  op <- new_operation(
    name = "DeleteNatGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_nat_gateway_input(NatGatewayId = NatGatewayId)
  output <- .ec2$delete_nat_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_nat_gateway <- ec2_delete_nat_gateway

#' Deletes the specified network ACL
#'
#' Deletes the specified network ACL. You can\'t delete the ACL if it\'s
#' associated with any subnets. You can\'t delete the default network ACL.
#'
#' @usage
#' ec2_delete_network_acl(DryRun, NetworkAclId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkAclId &#91;required&#93; The ID of the network ACL.
#'
#' @section Request syntax:
#' ```
#' svc$delete_network_acl(
#'   DryRun = TRUE|FALSE,
#'   NetworkAclId = "string"
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified network ACL.
#' \dontrun{svc$delete_network_acl(
#'   NetworkAclId = "acl-5fb85d36"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_acl
ec2_delete_network_acl <- function(DryRun = NULL, NetworkAclId) {
  op <- new_operation(
    name = "DeleteNetworkAcl",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_network_acl_input(DryRun = DryRun, NetworkAclId = NetworkAclId)
  output <- .ec2$delete_network_acl_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_acl <- ec2_delete_network_acl

#' Deletes the specified ingress or egress entry (rule) from the specified
#' network ACL
#'
#' Deletes the specified ingress or egress entry (rule) from the specified
#' network ACL.
#'
#' @usage
#' ec2_delete_network_acl_entry(DryRun, Egress, NetworkAclId, RuleNumber)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Egress &#91;required&#93; Indicates whether the rule is an egress rule.
#' @param NetworkAclId &#91;required&#93; The ID of the network ACL.
#' @param RuleNumber &#91;required&#93; The rule number of the entry to delete.
#'
#' @section Request syntax:
#' ```
#' svc$delete_network_acl_entry(
#'   DryRun = TRUE|FALSE,
#'   Egress = TRUE|FALSE,
#'   NetworkAclId = "string",
#'   RuleNumber = 123
#' )
#' ```
#'
#' @examples
#' # This example deletes ingress rule number 100 from the specified network
#' # ACL.
#' \dontrun{svc$delete_network_acl_entry(
#'   Egress = TRUE,
#'   NetworkAclId = "acl-5fb85d36",
#'   RuleNumber = 100L
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_acl_entry
ec2_delete_network_acl_entry <- function(DryRun = NULL, Egress, NetworkAclId, RuleNumber) {
  op <- new_operation(
    name = "DeleteNetworkAclEntry",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_network_acl_entry_input(DryRun = DryRun, Egress = Egress, NetworkAclId = NetworkAclId, RuleNumber = RuleNumber)
  output <- .ec2$delete_network_acl_entry_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_acl_entry <- ec2_delete_network_acl_entry

#' Deletes the specified network interface
#'
#' Deletes the specified network interface. You must detach the network
#' interface before you can delete it.
#'
#' @usage
#' ec2_delete_network_interface(DryRun, NetworkInterfaceId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#'
#' @section Request syntax:
#' ```
#' svc$delete_network_interface(
#'   DryRun = TRUE|FALSE,
#'   NetworkInterfaceId = "string"
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified network interface.
#' \dontrun{svc$delete_network_interface(
#'   NetworkInterfaceId = "eni-e5aa89a3"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_interface
ec2_delete_network_interface <- function(DryRun = NULL, NetworkInterfaceId) {
  op <- new_operation(
    name = "DeleteNetworkInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_network_interface_input(DryRun = DryRun, NetworkInterfaceId = NetworkInterfaceId)
  output <- .ec2$delete_network_interface_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_interface <- ec2_delete_network_interface

#' Deletes a permission for a network interface
#'
#' Deletes a permission for a network interface. By default, you cannot
#' delete the permission if the account for which you\'re removing the
#' permission has attached the network interface to an instance. However,
#' you can force delete the permission, regardless of any attachment.
#'
#' @usage
#' ec2_delete_network_interface_permission(NetworkInterfacePermissionId,
#'   Force, DryRun)
#'
#' @param NetworkInterfacePermissionId &#91;required&#93; The ID of the network interface permission.
#' @param Force Specify `true` to remove the permission even if the network interface is
#' attached to an instance.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_network_interface_permission(
#'   NetworkInterfacePermissionId = "string",
#'   Force = TRUE|FALSE,
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_network_interface_permission
ec2_delete_network_interface_permission <- function(NetworkInterfacePermissionId, Force = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteNetworkInterfacePermission",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_network_interface_permission_input(NetworkInterfacePermissionId = NetworkInterfacePermissionId, Force = Force, DryRun = DryRun)
  output <- .ec2$delete_network_interface_permission_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_network_interface_permission <- ec2_delete_network_interface_permission

#' Deletes the specified placement group
#'
#' Deletes the specified placement group. You must terminate all instances
#' in the placement group before you can delete the placement group. For
#' more information, see [Placement
#' Groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_delete_placement_group(DryRun, GroupName)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param GroupName &#91;required&#93; The name of the placement group.
#'
#' @section Request syntax:
#' ```
#' svc$delete_placement_group(
#'   DryRun = TRUE|FALSE,
#'   GroupName = "string"
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified placement group.
#' # 
#' \dontrun{svc$delete_placement_group(
#'   GroupName = "my-cluster"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_placement_group
ec2_delete_placement_group <- function(DryRun = NULL, GroupName) {
  op <- new_operation(
    name = "DeletePlacementGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_placement_group_input(DryRun = DryRun, GroupName = GroupName)
  output <- .ec2$delete_placement_group_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_placement_group <- ec2_delete_placement_group

#' Deletes the queued purchases for the specified Reserved Instances
#'
#' Deletes the queued purchases for the specified Reserved Instances.
#'
#' @usage
#' ec2_delete_queued_reserved_instances(DryRun, ReservedInstancesIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ReservedInstancesIds &#91;required&#93; The IDs of the Reserved Instances.
#'
#' @section Request syntax:
#' ```
#' svc$delete_queued_reserved_instances(
#'   DryRun = TRUE|FALSE,
#'   ReservedInstancesIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_queued_reserved_instances
ec2_delete_queued_reserved_instances <- function(DryRun = NULL, ReservedInstancesIds) {
  op <- new_operation(
    name = "DeleteQueuedReservedInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_queued_reserved_instances_input(DryRun = DryRun, ReservedInstancesIds = ReservedInstancesIds)
  output <- .ec2$delete_queued_reserved_instances_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_queued_reserved_instances <- ec2_delete_queued_reserved_instances

#' Deletes the specified route from the specified route table
#'
#' Deletes the specified route from the specified route table.
#'
#' @usage
#' ec2_delete_route(DestinationCidrBlock, DestinationIpv6CidrBlock, DryRun,
#'   RouteTableId)
#'
#' @param DestinationCidrBlock The IPv4 CIDR range for the route. The value you specify must match the
#' CIDR for the route exactly.
#' @param DestinationIpv6CidrBlock The IPv6 CIDR range for the route. The value you specify must match the
#' CIDR for the route exactly.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param RouteTableId &#91;required&#93; The ID of the route table.
#'
#' @section Request syntax:
#' ```
#' svc$delete_route(
#'   DestinationCidrBlock = "string",
#'   DestinationIpv6CidrBlock = "string",
#'   DryRun = TRUE|FALSE,
#'   RouteTableId = "string"
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified route from the specified route table.
#' \dontrun{svc$delete_route(
#'   DestinationCidrBlock = "0.0.0.0/0",
#'   RouteTableId = "rtb-22574640"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_route
ec2_delete_route <- function(DestinationCidrBlock = NULL, DestinationIpv6CidrBlock = NULL, DryRun = NULL, RouteTableId) {
  op <- new_operation(
    name = "DeleteRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_route_input(DestinationCidrBlock = DestinationCidrBlock, DestinationIpv6CidrBlock = DestinationIpv6CidrBlock, DryRun = DryRun, RouteTableId = RouteTableId)
  output <- .ec2$delete_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_route <- ec2_delete_route

#' Deletes the specified route table
#'
#' Deletes the specified route table. You must disassociate the route table
#' from any subnets before you can delete it. You can\'t delete the main
#' route table.
#'
#' @usage
#' ec2_delete_route_table(DryRun, RouteTableId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param RouteTableId &#91;required&#93; The ID of the route table.
#'
#' @section Request syntax:
#' ```
#' svc$delete_route_table(
#'   DryRun = TRUE|FALSE,
#'   RouteTableId = "string"
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified route table.
#' \dontrun{svc$delete_route_table(
#'   RouteTableId = "rtb-22574640"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_route_table
ec2_delete_route_table <- function(DryRun = NULL, RouteTableId) {
  op <- new_operation(
    name = "DeleteRouteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_route_table_input(DryRun = DryRun, RouteTableId = RouteTableId)
  output <- .ec2$delete_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_route_table <- ec2_delete_route_table

#' Deletes a security group
#'
#' Deletes a security group.
#' 
#' If you attempt to delete a security group that is associated with an
#' instance, or is referenced by another security group, the operation
#' fails with `InvalidGroup.InUse` in EC2-Classic or `DependencyViolation`
#' in EC2-VPC.
#'
#' @usage
#' ec2_delete_security_group(GroupId, GroupName, DryRun)
#'
#' @param GroupId The ID of the security group. Required for a nondefault VPC.
#' @param GroupName \[EC2-Classic, default VPC\] The name of the security group. You can
#' specify either the security group name or the security group ID.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_security_group(
#'   GroupId = "string",
#'   GroupName = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified security group.
#' \dontrun{svc$delete_security_group(
#'   GroupId = "sg-903004f8"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_security_group
ec2_delete_security_group <- function(GroupId = NULL, GroupName = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteSecurityGroup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_security_group_input(GroupId = GroupId, GroupName = GroupName, DryRun = DryRun)
  output <- .ec2$delete_security_group_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_security_group <- ec2_delete_security_group

#' Deletes the specified snapshot
#'
#' Deletes the specified snapshot.
#' 
#' When you make periodic snapshots of a volume, the snapshots are
#' incremental, and only the blocks on the device that have changed since
#' your last snapshot are saved in the new snapshot. When you delete a
#' snapshot, only the data not needed for any other snapshot is removed. So
#' regardless of which prior snapshots have been deleted, all active
#' snapshots will have access to all the information needed to restore the
#' volume.
#' 
#' You cannot delete a snapshot of the root device of an EBS volume used by
#' a registered AMI. You must first de-register the AMI before you can
#' delete the snapshot.
#' 
#' For more information, see [Deleting an Amazon EBS
#' Snapshot](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-snapshot.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_delete_snapshot(SnapshotId, DryRun)
#'
#' @param SnapshotId &#91;required&#93; The ID of the EBS snapshot.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_snapshot(
#'   SnapshotId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example deletes a snapshot with the snapshot ID of
#' # `snap-1234567890abcdef0`. If the command succeeds, no output is
#' # returned.
#' \dontrun{svc$delete_snapshot(
#'   SnapshotId = "snap-1234567890abcdef0"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_snapshot
ec2_delete_snapshot <- function(SnapshotId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_snapshot_input(SnapshotId = SnapshotId, DryRun = DryRun)
  output <- .ec2$delete_snapshot_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_snapshot <- ec2_delete_snapshot

#' Deletes the data feed for Spot Instances
#'
#' Deletes the data feed for Spot Instances.
#'
#' @usage
#' ec2_delete_spot_datafeed_subscription(DryRun)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_spot_datafeed_subscription(
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example deletes a Spot data feed subscription for the account.
#' \dontrun{svc$delete_spot_datafeed_subscription()}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_spot_datafeed_subscription
ec2_delete_spot_datafeed_subscription <- function(DryRun = NULL) {
  op <- new_operation(
    name = "DeleteSpotDatafeedSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_spot_datafeed_subscription_input(DryRun = DryRun)
  output <- .ec2$delete_spot_datafeed_subscription_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_spot_datafeed_subscription <- ec2_delete_spot_datafeed_subscription

#' Deletes the specified subnet
#'
#' Deletes the specified subnet. You must terminate all running instances
#' in the subnet before you can delete the subnet.
#'
#' @usage
#' ec2_delete_subnet(SubnetId, DryRun)
#'
#' @param SubnetId &#91;required&#93; The ID of the subnet.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_subnet(
#'   SubnetId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified subnet.
#' \dontrun{svc$delete_subnet(
#'   SubnetId = "subnet-9d4a7b6c"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_subnet
ec2_delete_subnet <- function(SubnetId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteSubnet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_subnet_input(SubnetId = SubnetId, DryRun = DryRun)
  output <- .ec2$delete_subnet_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_subnet <- ec2_delete_subnet

#' Deletes the specified set of tags from the specified set of resources
#'
#' Deletes the specified set of tags from the specified set of resources.
#' 
#' To list the current tags, use DescribeTags. For more information about
#' tags, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_delete_tags(DryRun, Resources, Tags)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Resources &#91;required&#93; The IDs of the resources, separated by spaces.
#' 
#' Constraints: Up to 1000 resource IDs. We recommend breaking up this
#' request into smaller batches.
#' @param Tags The tags to delete. Specify a tag key and an optional tag value to
#' delete specific tags. If you specify a tag key without a tag value, we
#' delete any tag with this key regardless of its value. If you specify a
#' tag key with an empty string as the tag value, we delete the tag only if
#' its value is an empty string.
#' 
#' If you omit this parameter, we delete all user-defined tags for the
#' specified resources. We do not delete AWS-generated tags (tags that have
#' the `aws:` prefix).
#'
#' @section Request syntax:
#' ```
#' svc$delete_tags(
#'   DryRun = TRUE|FALSE,
#'   Resources = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example deletes the tag Stack=test from the specified image.
#' \dontrun{svc$delete_tags(
#'   Resources = list(
#'     "ami-78a54011"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "Stack",
#'       Value = "test"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_tags
ec2_delete_tags <- function(DryRun = NULL, Resources, Tags = NULL) {
  op <- new_operation(
    name = "DeleteTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_tags_input(DryRun = DryRun, Resources = Resources, Tags = Tags)
  output <- .ec2$delete_tags_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_tags <- ec2_delete_tags

#' Deletes the specified Traffic Mirror filter
#'
#' Deletes the specified Traffic Mirror filter.
#' 
#' You cannot delete a Traffic Mirror filter that is in use by a Traffic
#' Mirror session.
#'
#' @usage
#' ec2_delete_traffic_mirror_filter(TrafficMirrorFilterId, DryRun)
#'
#' @param TrafficMirrorFilterId &#91;required&#93; The ID of the Traffic Mirror filter.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_traffic_mirror_filter(
#'   TrafficMirrorFilterId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_traffic_mirror_filter
ec2_delete_traffic_mirror_filter <- function(TrafficMirrorFilterId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTrafficMirrorFilter",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_traffic_mirror_filter_input(TrafficMirrorFilterId = TrafficMirrorFilterId, DryRun = DryRun)
  output <- .ec2$delete_traffic_mirror_filter_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_traffic_mirror_filter <- ec2_delete_traffic_mirror_filter

#' Deletes the specified Traffic Mirror rule
#'
#' Deletes the specified Traffic Mirror rule.
#'
#' @usage
#' ec2_delete_traffic_mirror_filter_rule(TrafficMirrorFilterRuleId, DryRun)
#'
#' @param TrafficMirrorFilterRuleId &#91;required&#93; The ID of the Traffic Mirror rule.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_traffic_mirror_filter_rule(
#'   TrafficMirrorFilterRuleId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_traffic_mirror_filter_rule
ec2_delete_traffic_mirror_filter_rule <- function(TrafficMirrorFilterRuleId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTrafficMirrorFilterRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_traffic_mirror_filter_rule_input(TrafficMirrorFilterRuleId = TrafficMirrorFilterRuleId, DryRun = DryRun)
  output <- .ec2$delete_traffic_mirror_filter_rule_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_traffic_mirror_filter_rule <- ec2_delete_traffic_mirror_filter_rule

#' Deletes the specified Traffic Mirror session
#'
#' Deletes the specified Traffic Mirror session.
#'
#' @usage
#' ec2_delete_traffic_mirror_session(TrafficMirrorSessionId, DryRun)
#'
#' @param TrafficMirrorSessionId &#91;required&#93; The ID of the Traffic Mirror session.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_traffic_mirror_session(
#'   TrafficMirrorSessionId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_traffic_mirror_session
ec2_delete_traffic_mirror_session <- function(TrafficMirrorSessionId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTrafficMirrorSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_traffic_mirror_session_input(TrafficMirrorSessionId = TrafficMirrorSessionId, DryRun = DryRun)
  output <- .ec2$delete_traffic_mirror_session_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_traffic_mirror_session <- ec2_delete_traffic_mirror_session

#' Deletes the specified Traffic Mirror target
#'
#' Deletes the specified Traffic Mirror target.
#' 
#' You cannot delete a Traffic Mirror target that is in use by a Traffic
#' Mirror session.
#'
#' @usage
#' ec2_delete_traffic_mirror_target(TrafficMirrorTargetId, DryRun)
#'
#' @param TrafficMirrorTargetId &#91;required&#93; The ID of the Traffic Mirror target.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_traffic_mirror_target(
#'   TrafficMirrorTargetId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_traffic_mirror_target
ec2_delete_traffic_mirror_target <- function(TrafficMirrorTargetId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTrafficMirrorTarget",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_traffic_mirror_target_input(TrafficMirrorTargetId = TrafficMirrorTargetId, DryRun = DryRun)
  output <- .ec2$delete_traffic_mirror_target_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_traffic_mirror_target <- ec2_delete_traffic_mirror_target

#' Deletes the specified transit gateway
#'
#' Deletes the specified transit gateway.
#'
#' @usage
#' ec2_delete_transit_gateway(TransitGatewayId, DryRun)
#'
#' @param TransitGatewayId &#91;required&#93; The ID of the transit gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_transit_gateway(
#'   TransitGatewayId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway
ec2_delete_transit_gateway <- function(TransitGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_transit_gateway_input(TransitGatewayId = TransitGatewayId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway <- ec2_delete_transit_gateway

#' Deletes the specified transit gateway multicast domain
#'
#' Deletes the specified transit gateway multicast domain.
#'
#' @usage
#' ec2_delete_transit_gateway_multicast_domain(
#'   TransitGatewayMulticastDomainId, DryRun)
#'
#' @param TransitGatewayMulticastDomainId &#91;required&#93; The ID of the transit gateway multicast domain.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_transit_gateway_multicast_domain(
#'   TransitGatewayMulticastDomainId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_multicast_domain
ec2_delete_transit_gateway_multicast_domain <- function(TransitGatewayMulticastDomainId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayMulticastDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_transit_gateway_multicast_domain_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_multicast_domain_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_multicast_domain <- ec2_delete_transit_gateway_multicast_domain

#' Deletes a transit gateway peering attachment
#'
#' Deletes a transit gateway peering attachment.
#'
#' @usage
#' ec2_delete_transit_gateway_peering_attachment(
#'   TransitGatewayAttachmentId, DryRun)
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the transit gateway peering attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_transit_gateway_peering_attachment(
#'   TransitGatewayAttachmentId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_peering_attachment
ec2_delete_transit_gateway_peering_attachment <- function(TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayPeeringAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_transit_gateway_peering_attachment_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_peering_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_peering_attachment <- ec2_delete_transit_gateway_peering_attachment

#' Deletes the specified route from the specified transit gateway route
#' table
#'
#' Deletes the specified route from the specified transit gateway route
#' table.
#'
#' @usage
#' ec2_delete_transit_gateway_route(TransitGatewayRouteTableId,
#'   DestinationCidrBlock, DryRun)
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param DestinationCidrBlock &#91;required&#93; The CIDR range for the route. This must match the CIDR for the route
#' exactly.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_transit_gateway_route(
#'   TransitGatewayRouteTableId = "string",
#'   DestinationCidrBlock = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_route
ec2_delete_transit_gateway_route <- function(TransitGatewayRouteTableId, DestinationCidrBlock, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_transit_gateway_route_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, DestinationCidrBlock = DestinationCidrBlock, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_route <- ec2_delete_transit_gateway_route

#' Deletes the specified transit gateway route table
#'
#' Deletes the specified transit gateway route table. You must disassociate
#' the route table from any transit gateway route tables before you can
#' delete it.
#'
#' @usage
#' ec2_delete_transit_gateway_route_table(TransitGatewayRouteTableId,
#'   DryRun)
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_transit_gateway_route_table(
#'   TransitGatewayRouteTableId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_route_table
ec2_delete_transit_gateway_route_table <- function(TransitGatewayRouteTableId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayRouteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_transit_gateway_route_table_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_route_table <- ec2_delete_transit_gateway_route_table

#' Deletes the specified VPC attachment
#'
#' Deletes the specified VPC attachment.
#'
#' @usage
#' ec2_delete_transit_gateway_vpc_attachment(TransitGatewayAttachmentId,
#'   DryRun)
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_transit_gateway_vpc_attachment(
#'   TransitGatewayAttachmentId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_transit_gateway_vpc_attachment
ec2_delete_transit_gateway_vpc_attachment <- function(TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteTransitGatewayVpcAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_transit_gateway_vpc_attachment_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$delete_transit_gateway_vpc_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_transit_gateway_vpc_attachment <- ec2_delete_transit_gateway_vpc_attachment

#' Deletes the specified EBS volume
#'
#' Deletes the specified EBS volume. The volume must be in the `available`
#' state (not attached to an instance).
#' 
#' The volume can remain in the `deleting` state for several minutes.
#' 
#' For more information, see [Deleting an Amazon EBS
#' Volume](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-deleting-volume.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_delete_volume(VolumeId, DryRun)
#'
#' @param VolumeId &#91;required&#93; The ID of the volume.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_volume(
#'   VolumeId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example deletes an available volume with the volume ID of
#' # `vol-049df61146c4d7901`. If the command succeeds, no output is
#' # returned.
#' \dontrun{svc$delete_volume(
#'   VolumeId = "vol-049df61146c4d7901"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_volume
ec2_delete_volume <- function(VolumeId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_volume_input(VolumeId = VolumeId, DryRun = DryRun)
  output <- .ec2$delete_volume_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_volume <- ec2_delete_volume

#' Deletes the specified VPC
#'
#' Deletes the specified VPC. You must detach or delete all gateways and
#' resources that are associated with the VPC before you can delete it. For
#' example, you must terminate all instances running in the VPC, delete all
#' security groups associated with the VPC (except the default one), delete
#' all route tables associated with the VPC (except the default one), and
#' so on.
#'
#' @usage
#' ec2_delete_vpc(VpcId, DryRun)
#'
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpc(
#'   VpcId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example deletes the specified VPC.
#' \dontrun{svc$delete_vpc(
#'   VpcId = "vpc-a01106c2"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc
ec2_delete_vpc <- function(VpcId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteVpc",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpc_input(VpcId = VpcId, DryRun = DryRun)
  output <- .ec2$delete_vpc_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc <- ec2_delete_vpc

#' Deletes one or more VPC endpoint connection notifications
#'
#' Deletes one or more VPC endpoint connection notifications.
#'
#' @usage
#' ec2_delete_vpc_endpoint_connection_notifications(DryRun,
#'   ConnectionNotificationIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ConnectionNotificationIds &#91;required&#93; One or more notification IDs.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpc_endpoint_connection_notifications(
#'   DryRun = TRUE|FALSE,
#'   ConnectionNotificationIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc_endpoint_connection_notifications
ec2_delete_vpc_endpoint_connection_notifications <- function(DryRun = NULL, ConnectionNotificationIds) {
  op <- new_operation(
    name = "DeleteVpcEndpointConnectionNotifications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpc_endpoint_connection_notifications_input(DryRun = DryRun, ConnectionNotificationIds = ConnectionNotificationIds)
  output <- .ec2$delete_vpc_endpoint_connection_notifications_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc_endpoint_connection_notifications <- ec2_delete_vpc_endpoint_connection_notifications

#' Deletes one or more VPC endpoint service configurations in your account
#'
#' Deletes one or more VPC endpoint service configurations in your account.
#' Before you delete the endpoint service configuration, you must reject
#' any `Available` or `PendingAcceptance` interface endpoint connections
#' that are attached to the service.
#'
#' @usage
#' ec2_delete_vpc_endpoint_service_configurations(DryRun, ServiceIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ServiceIds &#91;required&#93; The IDs of one or more services.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpc_endpoint_service_configurations(
#'   DryRun = TRUE|FALSE,
#'   ServiceIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc_endpoint_service_configurations
ec2_delete_vpc_endpoint_service_configurations <- function(DryRun = NULL, ServiceIds) {
  op <- new_operation(
    name = "DeleteVpcEndpointServiceConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpc_endpoint_service_configurations_input(DryRun = DryRun, ServiceIds = ServiceIds)
  output <- .ec2$delete_vpc_endpoint_service_configurations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc_endpoint_service_configurations <- ec2_delete_vpc_endpoint_service_configurations

#' Deletes one or more specified VPC endpoints
#'
#' Deletes one or more specified VPC endpoints. Deleting a gateway endpoint
#' also deletes the endpoint routes in the route tables that were
#' associated with the endpoint. Deleting an interface endpoint deletes the
#' endpoint network interfaces.
#'
#' @usage
#' ec2_delete_vpc_endpoints(DryRun, VpcEndpointIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcEndpointIds &#91;required&#93; One or more VPC endpoint IDs.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpc_endpoints(
#'   DryRun = TRUE|FALSE,
#'   VpcEndpointIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc_endpoints
ec2_delete_vpc_endpoints <- function(DryRun = NULL, VpcEndpointIds) {
  op <- new_operation(
    name = "DeleteVpcEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpc_endpoints_input(DryRun = DryRun, VpcEndpointIds = VpcEndpointIds)
  output <- .ec2$delete_vpc_endpoints_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc_endpoints <- ec2_delete_vpc_endpoints

#' Deletes a VPC peering connection
#'
#' Deletes a VPC peering connection. Either the owner of the requester VPC
#' or the owner of the accepter VPC can delete the VPC peering connection
#' if it\'s in the `active` state. The owner of the requester VPC can
#' delete a VPC peering connection in the `pending-acceptance` state. You
#' cannot delete a VPC peering connection that\'s in the `failed` state.
#'
#' @usage
#' ec2_delete_vpc_peering_connection(DryRun, VpcPeeringConnectionId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcPeeringConnectionId &#91;required&#93; The ID of the VPC peering connection.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpc_peering_connection(
#'   DryRun = TRUE|FALSE,
#'   VpcPeeringConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpc_peering_connection
ec2_delete_vpc_peering_connection <- function(DryRun = NULL, VpcPeeringConnectionId) {
  op <- new_operation(
    name = "DeleteVpcPeeringConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpc_peering_connection_input(DryRun = DryRun, VpcPeeringConnectionId = VpcPeeringConnectionId)
  output <- .ec2$delete_vpc_peering_connection_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpc_peering_connection <- ec2_delete_vpc_peering_connection

#' Deletes the specified VPN connection
#'
#' Deletes the specified VPN connection.
#' 
#' If you\'re deleting the VPC and its associated components, we recommend
#' that you detach the virtual private gateway from the VPC and delete the
#' VPC before deleting the VPN connection. If you believe that the tunnel
#' credentials for your VPN connection have been compromised, you can
#' delete the VPN connection and create a new one that has new keys,
#' without needing to delete the VPC or virtual private gateway. If you
#' create a new VPN connection, you must reconfigure the customer gateway
#' using the new configuration information returned with the new VPN
#' connection ID.
#'
#' @usage
#' ec2_delete_vpn_connection(VpnConnectionId, DryRun)
#'
#' @param VpnConnectionId &#91;required&#93; The ID of the VPN connection.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpn_connection(
#'   VpnConnectionId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpn_connection
ec2_delete_vpn_connection <- function(VpnConnectionId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteVpnConnection",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpn_connection_input(VpnConnectionId = VpnConnectionId, DryRun = DryRun)
  output <- .ec2$delete_vpn_connection_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpn_connection <- ec2_delete_vpn_connection

#' Deletes the specified static route associated with a VPN connection
#' between an existing virtual private gateway and a VPN customer gateway
#'
#' Deletes the specified static route associated with a VPN connection
#' between an existing virtual private gateway and a VPN customer gateway.
#' The static route allows traffic to be routed from the virtual private
#' gateway to the VPN customer gateway.
#'
#' @usage
#' ec2_delete_vpn_connection_route(DestinationCidrBlock, VpnConnectionId)
#'
#' @param DestinationCidrBlock &#91;required&#93; The CIDR block associated with the local subnet of the customer network.
#' @param VpnConnectionId &#91;required&#93; The ID of the VPN connection.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpn_connection_route(
#'   DestinationCidrBlock = "string",
#'   VpnConnectionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpn_connection_route
ec2_delete_vpn_connection_route <- function(DestinationCidrBlock, VpnConnectionId) {
  op <- new_operation(
    name = "DeleteVpnConnectionRoute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpn_connection_route_input(DestinationCidrBlock = DestinationCidrBlock, VpnConnectionId = VpnConnectionId)
  output <- .ec2$delete_vpn_connection_route_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpn_connection_route <- ec2_delete_vpn_connection_route

#' Deletes the specified virtual private gateway
#'
#' Deletes the specified virtual private gateway. We recommend that before
#' you delete a virtual private gateway, you detach it from the VPC and
#' delete the VPN connection. Note that you don\'t need to delete the
#' virtual private gateway if you plan to delete and recreate the VPN
#' connection between your VPC and your network.
#'
#' @usage
#' ec2_delete_vpn_gateway(VpnGatewayId, DryRun)
#'
#' @param VpnGatewayId &#91;required&#93; The ID of the virtual private gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$delete_vpn_gateway(
#'   VpnGatewayId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_delete_vpn_gateway
ec2_delete_vpn_gateway <- function(VpnGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "DeleteVpnGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$delete_vpn_gateway_input(VpnGatewayId = VpnGatewayId, DryRun = DryRun)
  output <- .ec2$delete_vpn_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$delete_vpn_gateway <- ec2_delete_vpn_gateway

#' Releases the specified address range that you provisioned for use with
#' your AWS resources through bring your own IP addresses (BYOIP) and
#' deletes the corresponding address pool
#'
#' Releases the specified address range that you provisioned for use with
#' your AWS resources through bring your own IP addresses (BYOIP) and
#' deletes the corresponding address pool.
#' 
#' Before you can release an address range, you must stop advertising it
#' using WithdrawByoipCidr and you must not have any IP addresses allocated
#' from its address range.
#'
#' @usage
#' ec2_deprovision_byoip_cidr(Cidr, DryRun)
#'
#' @param Cidr &#91;required&#93; The public IPv4 address range, in CIDR notation. The prefix must be the
#' same prefix that you specified when you provisioned the address range.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$deprovision_byoip_cidr(
#'   Cidr = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_deprovision_byoip_cidr
ec2_deprovision_byoip_cidr <- function(Cidr, DryRun = NULL) {
  op <- new_operation(
    name = "DeprovisionByoipCidr",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$deprovision_byoip_cidr_input(Cidr = Cidr, DryRun = DryRun)
  output <- .ec2$deprovision_byoip_cidr_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deprovision_byoip_cidr <- ec2_deprovision_byoip_cidr

#' Deregisters the specified AMI
#'
#' Deregisters the specified AMI. After you deregister an AMI, it can\'t be
#' used to launch new instances; however, it doesn\'t affect any instances
#' that you\'ve already launched from the AMI. You\'ll continue to incur
#' usage costs for those instances until you terminate them.
#' 
#' When you deregister an Amazon EBS-backed AMI, it doesn\'t affect the
#' snapshot that was created for the root volume of the instance during the
#' AMI creation process. When you deregister an instance store-backed AMI,
#' it doesn\'t affect the files that you uploaded to Amazon S3 when you
#' created the AMI.
#'
#' @usage
#' ec2_deregister_image(ImageId, DryRun)
#'
#' @param ImageId &#91;required&#93; The ID of the AMI.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_image(
#'   ImageId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_deregister_image
ec2_deregister_image <- function(ImageId, DryRun = NULL) {
  op <- new_operation(
    name = "DeregisterImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$deregister_image_input(ImageId = ImageId, DryRun = DryRun)
  output <- .ec2$deregister_image_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deregister_image <- ec2_deregister_image

#' Deregisters the specified members (network interfaces) from the transit
#' gateway multicast group
#'
#' Deregisters the specified members (network interfaces) from the transit
#' gateway multicast group.
#'
#' @usage
#' ec2_deregister_transit_gateway_multicast_group_members(
#'   TransitGatewayMulticastDomainId, GroupIpAddress, NetworkInterfaceIds,
#'   DryRun)
#'
#' @param TransitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
#' @param GroupIpAddress The IP address assigned to the transit gateway multicast group.
#' @param NetworkInterfaceIds The IDs of the group members\' network interfaces.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_transit_gateway_multicast_group_members(
#'   TransitGatewayMulticastDomainId = "string",
#'   GroupIpAddress = "string",
#'   NetworkInterfaceIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_deregister_transit_gateway_multicast_group_members
ec2_deregister_transit_gateway_multicast_group_members <- function(TransitGatewayMulticastDomainId = NULL, GroupIpAddress = NULL, NetworkInterfaceIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeregisterTransitGatewayMulticastGroupMembers",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$deregister_transit_gateway_multicast_group_members_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, GroupIpAddress = GroupIpAddress, NetworkInterfaceIds = NetworkInterfaceIds, DryRun = DryRun)
  output <- .ec2$deregister_transit_gateway_multicast_group_members_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deregister_transit_gateway_multicast_group_members <- ec2_deregister_transit_gateway_multicast_group_members

#' Deregisters the specified sources (network interfaces) from the transit
#' gateway multicast group
#'
#' Deregisters the specified sources (network interfaces) from the transit
#' gateway multicast group.
#'
#' @usage
#' ec2_deregister_transit_gateway_multicast_group_sources(
#'   TransitGatewayMulticastDomainId, GroupIpAddress, NetworkInterfaceIds,
#'   DryRun)
#'
#' @param TransitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
#' @param GroupIpAddress The IP address assigned to the transit gateway multicast group.
#' @param NetworkInterfaceIds The IDs of the group sources\' network interfaces.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$deregister_transit_gateway_multicast_group_sources(
#'   TransitGatewayMulticastDomainId = "string",
#'   GroupIpAddress = "string",
#'   NetworkInterfaceIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_deregister_transit_gateway_multicast_group_sources
ec2_deregister_transit_gateway_multicast_group_sources <- function(TransitGatewayMulticastDomainId = NULL, GroupIpAddress = NULL, NetworkInterfaceIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DeregisterTransitGatewayMulticastGroupSources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$deregister_transit_gateway_multicast_group_sources_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, GroupIpAddress = GroupIpAddress, NetworkInterfaceIds = NetworkInterfaceIds, DryRun = DryRun)
  output <- .ec2$deregister_transit_gateway_multicast_group_sources_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$deregister_transit_gateway_multicast_group_sources <- ec2_deregister_transit_gateway_multicast_group_sources

#' Describes attributes of your AWS account
#'
#' Describes attributes of your AWS account. The following are the
#' supported account attributes:
#' 
#' -   `supported-platforms`: Indicates whether your account can launch
#'     instances into EC2-Classic and EC2-VPC, or only into EC2-VPC.
#' 
#' -   `default-vpc`: The ID of the default VPC for your account, or
#'     `none`.
#' 
#' -   `max-instances`: This attribute is no longer supported. The returned
#'     value does not reflect your actual vCPU limit for running On-Demand
#'     Instances. For more information, see [On-Demand Instance
#'     Limits](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-on-demand-instances.html#ec2-on-demand-instances-limits)
#'     in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' -   `vpc-max-security-groups-per-interface`: The maximum number of
#'     security groups that you can assign to a network interface.
#' 
#' -   `max-elastic-ips`: The maximum number of Elastic IP addresses that
#'     you can allocate for use with EC2-Classic.
#' 
#' -   `vpc-max-elastic-ips`: The maximum number of Elastic IP addresses
#'     that you can allocate for use with EC2-VPC.
#'
#' @usage
#' ec2_describe_account_attributes(AttributeNames, DryRun)
#'
#' @param AttributeNames The account attribute names.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_account_attributes(
#'   AttributeNames = list(
#'     "supported-platforms"|"default-vpc"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example describes the supported-platforms attribute for your AWS
#' # account.
#' \dontrun{svc$describe_account_attributes(
#'   AttributeNames = list(
#'     "supported-platforms"
#'   )
#' )}
#' 
#' # This example describes the attributes for your AWS account.
#' \dontrun{svc$describe_account_attributes()}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_account_attributes
ec2_describe_account_attributes <- function(AttributeNames = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeAccountAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_account_attributes_input(AttributeNames = AttributeNames, DryRun = DryRun)
  output <- .ec2$describe_account_attributes_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_account_attributes <- ec2_describe_account_attributes

#' Describes the specified Elastic IP addresses or all of your Elastic IP
#' addresses
#'
#' Describes the specified Elastic IP addresses or all of your Elastic IP
#' addresses.
#' 
#' An Elastic IP address is for use in either the EC2-Classic platform or
#' in a VPC. For more information, see [Elastic IP
#' Addresses](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_addresses(Filters, PublicIps, AllocationIds, DryRun)
#'
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `allocation-id` - \[EC2-VPC\] The allocation ID for the address.
#' 
#' -   `association-id` - \[EC2-VPC\] The association ID for the address.
#' 
#' -   `domain` - Indicates whether the address is for use in EC2-Classic
#'     (`standard`) or in a VPC (`vpc`).
#' 
#' -   `instance-id` - The ID of the instance the address is associated
#'     with, if any.
#' 
#' -   `network-border-group` - The location from where the IP address is
#'     advertised.
#' 
#' -   `network-interface-id` - \[EC2-VPC\] The ID of the network interface
#'     that the address is associated with, if any.
#' 
#' -   `network-interface-owner-id` - The AWS account ID of the owner.
#' 
#' -   `private-ip-address` - \[EC2-VPC\] The private IP address associated
#'     with the Elastic IP address.
#' 
#' -   `public-ip` - The Elastic IP address.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param PublicIps One or more Elastic IP addresses.
#' 
#' Default: Describes all your Elastic IP addresses.
#' @param AllocationIds \[EC2-VPC\] Information about the allocation IDs.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_addresses(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   PublicIps = list(
#'     "string"
#'   ),
#'   AllocationIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example describes your Elastic IP addresses.
#' \dontrun{svc$describe_addresses()}
#' 
#' # This example describes your Elastic IP addresses for use with instances
#' # in a VPC.
#' \dontrun{svc$describe_addresses(
#'   Filters = list(
#'     list(
#'       Name = "domain",
#'       Values = list(
#'         "vpc"
#'       )
#'     )
#'   )
#' )}
#' 
#' # This example describes your Elastic IP addresses for use with instances
#' # in EC2-Classic.
#' \dontrun{svc$describe_addresses(
#'   Filters = list(
#'     list(
#'       Name = "domain",
#'       Values = list(
#'         "standard"
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_addresses
ec2_describe_addresses <- function(Filters = NULL, PublicIps = NULL, AllocationIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeAddresses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_addresses_input(Filters = Filters, PublicIps = PublicIps, AllocationIds = AllocationIds, DryRun = DryRun)
  output <- .ec2$describe_addresses_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_addresses <- ec2_describe_addresses

#' Describes the longer ID format settings for all resource types in a
#' specific Region
#'
#' Describes the longer ID format settings for all resource types in a
#' specific Region. This request is useful for performing a quick audit to
#' determine whether a specific Region is fully opted in for longer IDs
#' (17-character IDs).
#' 
#' This request only returns information about resource types that support
#' longer IDs.
#' 
#' The following resource types support longer IDs: `bundle` \\|
#' `conversion-task` \\| `customer-gateway` \\| `dhcp-options` \\|
#' `elastic-ip-allocation` \\| `elastic-ip-association` \\| `export-task` \\|
#' `flow-log` \\| `image` \\| `import-task` \\| `instance` \\|
#' `internet-gateway` \\| `network-acl` \\| `network-acl-association` \\|
#' `network-interface` \\| `network-interface-attachment` \\| `prefix-list`
#' \\| `reservation` \\| `route-table` \\| `route-table-association` \\|
#' `security-group` \\| `snapshot` \\| `subnet` \\|
#' `subnet-cidr-block-association` \\| `volume` \\| `vpc` \\|
#' `vpc-cidr-block-association` \\| `vpc-endpoint` \\|
#' `vpc-peering-connection` \\| `vpn-connection` \\| `vpn-gateway`.
#'
#' @usage
#' ec2_describe_aggregate_id_format(DryRun)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_aggregate_id_format(
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_aggregate_id_format
ec2_describe_aggregate_id_format <- function(DryRun = NULL) {
  op <- new_operation(
    name = "DescribeAggregateIdFormat",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_aggregate_id_format_input(DryRun = DryRun)
  output <- .ec2$describe_aggregate_id_format_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_aggregate_id_format <- ec2_describe_aggregate_id_format

#' Describes the Availability Zones and Local Zones that are available to
#' you
#'
#' Describes the Availability Zones and Local Zones that are available to
#' you. If there is an event impacting an Availability Zone or Local Zone,
#' you can use this request to view the state and any provided messages for
#' that Availability Zone or Local Zone.
#' 
#' For more information about Availability Zones and Local Zones, see
#' [Regions and Availability
#' Zones](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-regions-availability-zones.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_availability_zones(Filters, ZoneNames, ZoneIds,
#'   AllAvailabilityZones, DryRun)
#'
#' @param Filters The filters.
#' 
#' -   `group-name` - For Availability Zones, use the Region name. For
#'     Local Zones, use the name of the group associated with the Local
#'     Zone (for example, `us-west-2-lax-1`).
#' 
#' -   `message` - The Availability Zone or Local Zone message.
#' 
#' -   `opt-in-status` - The opt in status (`opted-in`, and `not-opted-in`
#'     \\| `opt-in-not-required`).
#' 
#' -   `region-name` - The name of the Region for the Availability Zone or
#'     Local Zone (for example, `us-east-1`).
#' 
#' -   `state` - The state of the Availability Zone or Local Zone
#'     (`available` \\| `information` \\| `impaired` \\| `unavailable`).
#' 
#' -   `zone-id` - The ID of the Availability Zone (for example,
#'     `use1-az1`) or the Local Zone (for example, use `usw2-lax1-az1`).
#' 
#' -   `zone-name` - The name of the Availability Zone (for example,
#'     `us-east-1a`) or the Local Zone (for example, use
#'     `us-west-2-lax-1a`).
#' @param ZoneNames The names of the Availability Zones and Local Zones.
#' @param ZoneIds The IDs of the Availability Zones and Local Zones.
#' @param AllAvailabilityZones Include all Availability Zones and Local Zones regardless of your opt in
#' status.
#' 
#' If you do not use this parameter, the results include only the zones for
#' the Regions where you have chosen the option to opt in.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_availability_zones(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ZoneNames = list(
#'     "string"
#'   ),
#'   ZoneIds = list(
#'     "string"
#'   ),
#'   AllAvailabilityZones = TRUE|FALSE,
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example describes the Availability Zones that are available to you.
#' # The response includes Availability Zones only for the current region.
#' \dontrun{svc$describe_availability_zones()}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_availability_zones
ec2_describe_availability_zones <- function(Filters = NULL, ZoneNames = NULL, ZoneIds = NULL, AllAvailabilityZones = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeAvailabilityZones",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_availability_zones_input(Filters = Filters, ZoneNames = ZoneNames, ZoneIds = ZoneIds, AllAvailabilityZones = AllAvailabilityZones, DryRun = DryRun)
  output <- .ec2$describe_availability_zones_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_availability_zones <- ec2_describe_availability_zones

#' Describes the specified bundle tasks or all of your bundle tasks
#'
#' Describes the specified bundle tasks or all of your bundle tasks.
#' 
#' Completed bundle tasks are listed for only a limited time. If your
#' bundle task is no longer in the list, you can still register an AMI from
#' it. Just use `RegisterImage` with the Amazon S3 bucket name and image
#' manifest name you provided to the bundle task.
#'
#' @usage
#' ec2_describe_bundle_tasks(BundleIds, Filters, DryRun)
#'
#' @param BundleIds The bundle task IDs.
#' 
#' Default: Describes all your bundle tasks.
#' @param Filters The filters.
#' 
#' -   `bundle-id` - The ID of the bundle task.
#' 
#' -   `error-code` - If the task failed, the error code returned.
#' 
#' -   `error-message` - If the task failed, the error message returned.
#' 
#' -   `instance-id` - The ID of the instance.
#' 
#' -   `progress` - The level of task completion, as a percentage (for
#'     example, 20%).
#' 
#' -   `s3-bucket` - The Amazon S3 bucket to store the AMI.
#' 
#' -   `s3-prefix` - The beginning of the AMI name.
#' 
#' -   `start-time` - The time the task started (for example,
#'     2013-09-15T17:15:20.000Z).
#' 
#' -   `state` - The state of the task (`pending` \\| `waiting-for-shutdown`
#'     \\| `bundling` \\| `storing` \\| `cancelling` \\| `complete` \\|
#'     `failed`).
#' 
#' -   `update-time` - The time of the most recent update for the task.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_bundle_tasks(
#'   BundleIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_bundle_tasks
ec2_describe_bundle_tasks <- function(BundleIds = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeBundleTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_bundle_tasks_input(BundleIds = BundleIds, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_bundle_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_bundle_tasks <- ec2_describe_bundle_tasks

#' Describes the IP address ranges that were specified in calls to
#' ProvisionByoipCidr
#'
#' Describes the IP address ranges that were specified in calls to
#' ProvisionByoipCidr.
#' 
#' To describe the address pools that were created when you provisioned the
#' address ranges, use DescribePublicIpv4Pools.
#'
#' @usage
#' ec2_describe_byoip_cidrs(DryRun, MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults &#91;required&#93; The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_byoip_cidrs(
#'   DryRun = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_byoip_cidrs
ec2_describe_byoip_cidrs <- function(DryRun = NULL, MaxResults, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeByoipCidrs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_byoip_cidrs_input(DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_byoip_cidrs_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_byoip_cidrs <- ec2_describe_byoip_cidrs

#' Describes one or more of your Capacity Reservations
#'
#' Describes one or more of your Capacity Reservations. The results
#' describe only the Capacity Reservations in the AWS Region that you\'re
#' currently using.
#'
#' @usage
#' ec2_describe_capacity_reservations(CapacityReservationIds, NextToken,
#'   MaxResults, Filters, DryRun)
#'
#' @param CapacityReservationIds The ID of the Capacity Reservation.
#' @param NextToken The token to retrieve the next page of results.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the returned nextToken value.
#' @param Filters One or more filters.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_capacity_reservations(
#'   CapacityReservationIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_capacity_reservations
ec2_describe_capacity_reservations <- function(CapacityReservationIds = NULL, NextToken = NULL, MaxResults = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeCapacityReservations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_capacity_reservations_input(CapacityReservationIds = CapacityReservationIds, NextToken = NextToken, MaxResults = MaxResults, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_capacity_reservations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_capacity_reservations <- ec2_describe_capacity_reservations

#' Describes one or more of your linked EC2-Classic instances
#'
#' Describes one or more of your linked EC2-Classic instances. This request
#' only returns information about EC2-Classic instances linked to a VPC
#' through ClassicLink. You cannot use this request to return information
#' about other instances.
#'
#' @usage
#' ec2_describe_classic_link_instances(Filters, DryRun, InstanceIds,
#'   MaxResults, NextToken)
#'
#' @param Filters One or more filters.
#' 
#' -   `group-id` - The ID of a VPC security group that\'s associated with
#'     the instance.
#' 
#' -   `instance-id` - The ID of the instance.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC to which the instance is linked.
#' 
#'     `vpc-id` - The ID of the VPC that the instance is linked to.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceIds One or more instance IDs. Must be instances linked to a VPC through
#' ClassicLink.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' 
#' Constraint: If the value is greater than 1000, we return only 1000
#' items.
#' @param NextToken The token for the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_classic_link_instances(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_classic_link_instances
ec2_describe_classic_link_instances <- function(Filters = NULL, DryRun = NULL, InstanceIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeClassicLinkInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_classic_link_instances_input(Filters = Filters, DryRun = DryRun, InstanceIds = InstanceIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_classic_link_instances_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_classic_link_instances <- ec2_describe_classic_link_instances

#' Describes the authorization rules for a specified Client VPN endpoint
#'
#' Describes the authorization rules for a specified Client VPN endpoint.
#'
#' @usage
#' ec2_describe_client_vpn_authorization_rules(ClientVpnEndpointId, DryRun,
#'   NextToken, Filters, MaxResults)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token to retrieve the next page of results.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the nextToken value.
#'
#' @section Request syntax:
#' ```
#' svc$describe_client_vpn_authorization_rules(
#'   ClientVpnEndpointId = "string",
#'   DryRun = TRUE|FALSE,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_client_vpn_authorization_rules
ec2_describe_client_vpn_authorization_rules <- function(ClientVpnEndpointId, DryRun = NULL, NextToken = NULL, Filters = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeClientVpnAuthorizationRules",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_client_vpn_authorization_rules_input(ClientVpnEndpointId = ClientVpnEndpointId, DryRun = DryRun, NextToken = NextToken, Filters = Filters, MaxResults = MaxResults)
  output <- .ec2$describe_client_vpn_authorization_rules_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_client_vpn_authorization_rules <- ec2_describe_client_vpn_authorization_rules

#' Describes active client connections and connections that have been
#' terminated within the last 60 minutes for the specified Client VPN
#' endpoint
#'
#' Describes active client connections and connections that have been
#' terminated within the last 60 minutes for the specified Client VPN
#' endpoint.
#'
#' @usage
#' ec2_describe_client_vpn_connections(ClientVpnEndpointId, Filters,
#'   NextToken, MaxResults, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' @param NextToken The token to retrieve the next page of results.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the nextToken value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_client_vpn_connections(
#'   ClientVpnEndpointId = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123,
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_client_vpn_connections
ec2_describe_client_vpn_connections <- function(ClientVpnEndpointId, Filters = NULL, NextToken = NULL, MaxResults = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeClientVpnConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_client_vpn_connections_input(ClientVpnEndpointId = ClientVpnEndpointId, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun)
  output <- .ec2$describe_client_vpn_connections_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_client_vpn_connections <- ec2_describe_client_vpn_connections

#' Describes one or more Client VPN endpoints in the account
#'
#' Describes one or more Client VPN endpoints in the account.
#'
#' @usage
#' ec2_describe_client_vpn_endpoints(ClientVpnEndpointIds, MaxResults,
#'   NextToken, Filters, DryRun)
#'
#' @param ClientVpnEndpointIds The ID of the Client VPN endpoint.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the nextToken value.
#' @param NextToken The token to retrieve the next page of results.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_client_vpn_endpoints(
#'   ClientVpnEndpointIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_client_vpn_endpoints
ec2_describe_client_vpn_endpoints <- function(ClientVpnEndpointIds = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeClientVpnEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_client_vpn_endpoints_input(ClientVpnEndpointIds = ClientVpnEndpointIds, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_client_vpn_endpoints_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_client_vpn_endpoints <- ec2_describe_client_vpn_endpoints

#' Describes the routes for the specified Client VPN endpoint
#'
#' Describes the routes for the specified Client VPN endpoint.
#'
#' @usage
#' ec2_describe_client_vpn_routes(ClientVpnEndpointId, Filters, MaxResults,
#'   NextToken, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the nextToken value.
#' @param NextToken The token to retrieve the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_client_vpn_routes(
#'   ClientVpnEndpointId = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_client_vpn_routes
ec2_describe_client_vpn_routes <- function(ClientVpnEndpointId, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeClientVpnRoutes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_client_vpn_routes_input(ClientVpnEndpointId = ClientVpnEndpointId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_client_vpn_routes_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_client_vpn_routes <- ec2_describe_client_vpn_routes

#' Describes the target networks associated with the specified Client VPN
#' endpoint
#'
#' Describes the target networks associated with the specified Client VPN
#' endpoint.
#'
#' @usage
#' ec2_describe_client_vpn_target_networks(ClientVpnEndpointId,
#'   AssociationIds, MaxResults, NextToken, Filters, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param AssociationIds The IDs of the target network associations.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the nextToken value.
#' @param NextToken The token to retrieve the next page of results.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_client_vpn_target_networks(
#'   ClientVpnEndpointId = "string",
#'   AssociationIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_client_vpn_target_networks
ec2_describe_client_vpn_target_networks <- function(ClientVpnEndpointId, AssociationIds = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeClientVpnTargetNetworks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_client_vpn_target_networks_input(ClientVpnEndpointId = ClientVpnEndpointId, AssociationIds = AssociationIds, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_client_vpn_target_networks_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_client_vpn_target_networks <- ec2_describe_client_vpn_target_networks

#' Describes the specified customer-owned address pools or all of your
#' customer-owned address pools
#'
#' Describes the specified customer-owned address pools or all of your
#' customer-owned address pools.
#'
#' @usage
#' ec2_describe_coip_pools(PoolIds, Filters, MaxResults, NextToken, DryRun)
#'
#' @param PoolIds The IDs of the address pools.
#' @param Filters The filters. The following are the possible values:
#' 
#' -   `coip-pool.pool-id`
#' 
#' <!-- -->
#' 
#' -   `coip-pool.local-gateway-route-table-id`
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_coip_pools(
#'   PoolIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_coip_pools
ec2_describe_coip_pools <- function(PoolIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeCoipPools",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_coip_pools_input(PoolIds = PoolIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_coip_pools_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_coip_pools <- ec2_describe_coip_pools

#' Describes the specified conversion tasks or all your conversion tasks
#'
#' Describes the specified conversion tasks or all your conversion tasks.
#' For more information, see the [VM Import/Export User
#' Guide](https://docs.aws.amazon.com/vm-import/latest/userguide/).
#' 
#' For information about the import manifest referenced by this API action,
#' see [VM Import
#' Manifest](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html).
#'
#' @usage
#' ec2_describe_conversion_tasks(ConversionTaskIds, DryRun)
#'
#' @param ConversionTaskIds The conversion task IDs.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_conversion_tasks(
#'   ConversionTaskIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_conversion_tasks
ec2_describe_conversion_tasks <- function(ConversionTaskIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeConversionTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_conversion_tasks_input(ConversionTaskIds = ConversionTaskIds, DryRun = DryRun)
  output <- .ec2$describe_conversion_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_conversion_tasks <- ec2_describe_conversion_tasks

#' Describes one or more of your VPN customer gateways
#'
#' Describes one or more of your VPN customer gateways.
#' 
#' For more information, see [AWS Site-to-Site
#' VPN](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the
#' *AWS Site-to-Site VPN User Guide*.
#'
#' @usage
#' ec2_describe_customer_gateways(CustomerGatewayIds, Filters, DryRun)
#'
#' @param CustomerGatewayIds One or more customer gateway IDs.
#' 
#' Default: Describes all your customer gateways.
#' @param Filters One or more filters.
#' 
#' -   `bgp-asn` - The customer gateway\'s Border Gateway Protocol (BGP)
#'     Autonomous System Number (ASN).
#' 
#' -   `customer-gateway-id` - The ID of the customer gateway.
#' 
#' -   `ip-address` - The IP address of the customer gateway\'s
#'     Internet-routable external interface.
#' 
#' -   `state` - The state of the customer gateway (`pending` \\|
#'     `available` \\| `deleting` \\| `deleted`).
#' 
#' -   `type` - The type of customer gateway. Currently, the only supported
#'     type is `ipsec.1`.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_customer_gateways(
#'   CustomerGatewayIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example describes the specified customer gateway.
#' \dontrun{svc$describe_customer_gateways(
#'   CustomerGatewayIds = list(
#'     "cgw-0e11f167"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_customer_gateways
ec2_describe_customer_gateways <- function(CustomerGatewayIds = NULL, Filters = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeCustomerGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_customer_gateways_input(CustomerGatewayIds = CustomerGatewayIds, Filters = Filters, DryRun = DryRun)
  output <- .ec2$describe_customer_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_customer_gateways <- ec2_describe_customer_gateways

#' Describes one or more of your DHCP options sets
#'
#' Describes one or more of your DHCP options sets.
#' 
#' For more information, see [DHCP Options
#' Sets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_DHCP_Options.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_describe_dhcp_options(DhcpOptionsIds, Filters, DryRun, NextToken,
#'   MaxResults)
#'
#' @param DhcpOptionsIds The IDs of one or more DHCP options sets.
#' 
#' Default: Describes all your DHCP options sets.
#' @param Filters One or more filters.
#' 
#' -   `dhcp-options-id` - The ID of a DHCP options set.
#' 
#' -   `key` - The key for one of the options (for example, `domain-name`).
#' 
#' -   `value` - The value for one of the options.
#' 
#' -   `owner-id` - The ID of the AWS account that owns the DHCP options
#'     set.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @section Request syntax:
#' ```
#' svc$describe_dhcp_options(
#'   DhcpOptionsIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' # This example describes the specified DHCP options set.
#' \dontrun{svc$describe_dhcp_options(
#'   DhcpOptionsIds = list(
#'     "dopt-d9070ebb"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_dhcp_options
ec2_describe_dhcp_options <- function(DhcpOptionsIds = NULL, Filters = NULL, DryRun = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeDhcpOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_dhcp_options_input(DhcpOptionsIds = DhcpOptionsIds, Filters = Filters, DryRun = DryRun, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_dhcp_options_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_dhcp_options <- ec2_describe_dhcp_options

#' Describes one or more of your egress-only internet gateways
#'
#' Describes one or more of your egress-only internet gateways.
#'
#' @usage
#' ec2_describe_egress_only_internet_gateways(DryRun,
#'   EgressOnlyInternetGatewayIds, MaxResults, NextToken, Filters)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param EgressOnlyInternetGatewayIds One or more egress-only internet gateway IDs.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param Filters One or more filters.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#'
#' @section Request syntax:
#' ```
#' svc$describe_egress_only_internet_gateways(
#'   DryRun = TRUE|FALSE,
#'   EgressOnlyInternetGatewayIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_egress_only_internet_gateways
ec2_describe_egress_only_internet_gateways <- function(DryRun = NULL, EgressOnlyInternetGatewayIds = NULL, MaxResults = NULL, NextToken = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeEgressOnlyInternetGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_egress_only_internet_gateways_input(DryRun = DryRun, EgressOnlyInternetGatewayIds = EgressOnlyInternetGatewayIds, MaxResults = MaxResults, NextToken = NextToken, Filters = Filters)
  output <- .ec2$describe_egress_only_internet_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_egress_only_internet_gateways <- ec2_describe_egress_only_internet_gateways

#' Describes the Elastic Graphics accelerator associated with your
#' instances
#'
#' Describes the Elastic Graphics accelerator associated with your
#' instances. For more information about Elastic Graphics, see [Amazon
#' Elastic
#' Graphics](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/elastic-graphics.html).
#'
#' @usage
#' ec2_describe_elastic_gpus(ElasticGpuIds, DryRun, Filters, MaxResults,
#'   NextToken)
#'
#' @param ElasticGpuIds The Elastic Graphics accelerator IDs.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `availability-zone` - The Availability Zone in which the Elastic
#'     Graphics accelerator resides.
#' 
#' -   `elastic-gpu-health` - The status of the Elastic Graphics
#'     accelerator (`OK` \\| `IMPAIRED`).
#' 
#' -   `elastic-gpu-state` - The state of the Elastic Graphics accelerator
#'     (`ATTACHED`).
#' 
#' -   `elastic-gpu-type` - The type of Elastic Graphics accelerator; for
#'     example, `eg1.medium`.
#' 
#' -   `instance-id` - The ID of the instance to which the Elastic Graphics
#'     accelerator is associated.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 5 and 1000.
#' @param NextToken The token to request the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_elastic_gpus(
#'   ElasticGpuIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_elastic_gpus
ec2_describe_elastic_gpus <- function(ElasticGpuIds = NULL, DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeElasticGpus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_elastic_gpus_input(ElasticGpuIds = ElasticGpuIds, DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_elastic_gpus_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_elastic_gpus <- ec2_describe_elastic_gpus

#' Describes the specified export image tasks or all your export image
#' tasks
#'
#' Describes the specified export image tasks or all your export image
#' tasks.
#'
#' @usage
#' ec2_describe_export_image_tasks(DryRun, Filters, ExportImageTaskIds,
#'   MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters Filter tasks using the `task-state` filter and one of the following
#' values: `active`, `completed`, `deleting`, or `deleted`.
#' @param ExportImageTaskIds The IDs of the export image tasks.
#' @param MaxResults The maximum number of results to return in a single call.
#' @param NextToken A token that indicates the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_export_image_tasks(
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ExportImageTaskIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_export_image_tasks
ec2_describe_export_image_tasks <- function(DryRun = NULL, Filters = NULL, ExportImageTaskIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeExportImageTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_export_image_tasks_input(DryRun = DryRun, Filters = Filters, ExportImageTaskIds = ExportImageTaskIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_export_image_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_export_image_tasks <- ec2_describe_export_image_tasks

#' Describes the specified export instance tasks or all your export
#' instance tasks
#'
#' Describes the specified export instance tasks or all your export
#' instance tasks.
#'
#' @usage
#' ec2_describe_export_tasks(ExportTaskIds, Filters)
#'
#' @param ExportTaskIds The export task IDs.
#' @param Filters 
#'
#' @section Request syntax:
#' ```
#' svc$describe_export_tasks(
#'   ExportTaskIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_export_tasks
ec2_describe_export_tasks <- function(ExportTaskIds = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeExportTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_export_tasks_input(ExportTaskIds = ExportTaskIds, Filters = Filters)
  output <- .ec2$describe_export_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_export_tasks <- ec2_describe_export_tasks

#' Describes the state of fast snapshot restores for your snapshots
#'
#' Describes the state of fast snapshot restores for your snapshots.
#'
#' @usage
#' ec2_describe_fast_snapshot_restores(Filters, MaxResults, NextToken,
#'   DryRun)
#'
#' @param Filters The filters. The possible values are:
#' 
#' -   `availability-zone`: The Availability Zone of the snapshot.
#' 
#' -   `owner-id`: The ID of the AWS account that owns the snapshot.
#' 
#' -   `snapshot-id`: The ID of the snapshot.
#' 
#' -   `state`: The state of fast snapshot restores for the snapshot
#'     (`enabling` \\| `optimizing` \\| `enabled` \\| `disabling` \\|
#'     `disabled`).
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_fast_snapshot_restores(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fast_snapshot_restores
ec2_describe_fast_snapshot_restores <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeFastSnapshotRestores",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_fast_snapshot_restores_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_fast_snapshot_restores_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fast_snapshot_restores <- ec2_describe_fast_snapshot_restores

#' Describes the events for the specified EC2 Fleet during the specified
#' time
#'
#' Describes the events for the specified EC2 Fleet during the specified
#' time.
#' 
#' EC2 Fleet events are delayed by up to 30 seconds before they can be
#' described. This ensures that you can query by the last evaluated time
#' and not miss a recorded event. EC2 Fleet events are available for 48
#' hours.
#'
#' @usage
#' ec2_describe_fleet_history(DryRun, EventType, MaxResults, NextToken,
#'   FleetId, StartTime)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param EventType The type of events to describe. By default, all events are described.
#' @param MaxResults The maximum number of results to return in a single call. Specify a
#' value between 1 and 1000. The default value is 1000. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token for the next set of results.
#' @param FleetId &#91;required&#93; The ID of the EC2 Fleet.
#' @param StartTime &#91;required&#93; The start date and time for the events, in UTC format (for example,
#' *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z).
#'
#' @section Request syntax:
#' ```
#' svc$describe_fleet_history(
#'   DryRun = TRUE|FALSE,
#'   EventType = "instance-change"|"fleet-change"|"service-error",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   FleetId = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fleet_history
ec2_describe_fleet_history <- function(DryRun = NULL, EventType = NULL, MaxResults = NULL, NextToken = NULL, FleetId, StartTime) {
  op <- new_operation(
    name = "DescribeFleetHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_fleet_history_input(DryRun = DryRun, EventType = EventType, MaxResults = MaxResults, NextToken = NextToken, FleetId = FleetId, StartTime = StartTime)
  output <- .ec2$describe_fleet_history_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fleet_history <- ec2_describe_fleet_history

#' Describes the running instances for the specified EC2 Fleet
#'
#' Describes the running instances for the specified EC2 Fleet.
#'
#' @usage
#' ec2_describe_fleet_instances(DryRun, MaxResults, NextToken, FleetId,
#'   Filters)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of results to return in a single call. Specify a
#' value between 1 and 1000. The default value is 1000. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token for the next set of results.
#' @param FleetId &#91;required&#93; The ID of the EC2 Fleet.
#' @param Filters The filters.
#' 
#' -   `instance-type` - The instance type.
#'
#' @section Request syntax:
#' ```
#' svc$describe_fleet_instances(
#'   DryRun = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string",
#'   FleetId = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fleet_instances
ec2_describe_fleet_instances <- function(DryRun = NULL, MaxResults = NULL, NextToken = NULL, FleetId, Filters = NULL) {
  op <- new_operation(
    name = "DescribeFleetInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_fleet_instances_input(DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken, FleetId = FleetId, Filters = Filters)
  output <- .ec2$describe_fleet_instances_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fleet_instances <- ec2_describe_fleet_instances

#' Describes the specified EC2 Fleets or all of your EC2 Fleets
#'
#' Describes the specified EC2 Fleets or all of your EC2 Fleets.
#'
#' @usage
#' ec2_describe_fleets(DryRun, MaxResults, NextToken, FleetIds, Filters)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of results to return in a single call. Specify a
#' value between 1 and 1000. The default value is 1000. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token for the next set of results.
#' @param FleetIds The ID of the EC2 Fleets.
#' @param Filters The filters.
#' 
#' -   `activity-status` - The progress of the EC2 Fleet ( `error` \\|
#'     `pending-fulfillment` \\| `pending-termination` \\| `fulfilled`).
#' 
#' -   `excess-capacity-termination-policy` - Indicates whether to
#'     terminate running instances if the target capacity is decreased
#'     below the current EC2 Fleet size (`true` \\| `false`).
#' 
#' -   `fleet-state` - The state of the EC2 Fleet (`submitted` \\| `active`
#'     \\| `deleted` \\| `failed` \\| `deleted-running` \\|
#'     `deleted-terminating` \\| `modifying`).
#' 
#' -   `replace-unhealthy-instances` - Indicates whether EC2 Fleet should
#'     replace unhealthy instances (`true` \\| `false`).
#' 
#' -   `type` - The type of request (`instant` \\| `request` \\| `maintain`).
#'
#' @section Request syntax:
#' ```
#' svc$describe_fleets(
#'   DryRun = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string",
#'   FleetIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fleets
ec2_describe_fleets <- function(DryRun = NULL, MaxResults = NULL, NextToken = NULL, FleetIds = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeFleets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_fleets_input(DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken, FleetIds = FleetIds, Filters = Filters)
  output <- .ec2$describe_fleets_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fleets <- ec2_describe_fleets

#' Describes one or more flow logs
#'
#' Describes one or more flow logs. To view the information in your flow
#' logs (the log streams for the network interfaces), you must use the
#' CloudWatch Logs console or the CloudWatch Logs API.
#'
#' @usage
#' ec2_describe_flow_logs(DryRun, Filter, FlowLogIds, MaxResults,
#'   NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filter One or more filters.
#' 
#' -   `deliver-log-status` - The status of the logs delivery (`SUCCESS` \\|
#'     `FAILED`).
#' 
#' -   `log-destination-type` - The type of destination to which the flow
#'     log publishes data. Possible destination types include
#'     `cloud-watch-logs` and `S3`.
#' 
#' -   `flow-log-id` - The ID of the flow log.
#' 
#' -   `log-group-name` - The name of the log group.
#' 
#' -   `resource-id` - The ID of the VPC, subnet, or network interface.
#' 
#' -   `traffic-type` - The type of traffic (`ACCEPT` \\| `REJECT` \\|
#'     `ALL`).
#' @param FlowLogIds One or more flow log IDs.
#' 
#' Constraint: Maximum of 1000 flow log IDs.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_flow_logs(
#'   DryRun = TRUE|FALSE,
#'   Filter = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   FlowLogIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_flow_logs
ec2_describe_flow_logs <- function(DryRun = NULL, Filter = NULL, FlowLogIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeFlowLogs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_flow_logs_input(DryRun = DryRun, Filter = Filter, FlowLogIds = FlowLogIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_flow_logs_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_flow_logs <- ec2_describe_flow_logs

#' Describes the specified attribute of the specified Amazon FPGA Image
#' (AFI)
#'
#' Describes the specified attribute of the specified Amazon FPGA Image
#' (AFI).
#'
#' @usage
#' ec2_describe_fpga_image_attribute(DryRun, FpgaImageId, Attribute)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FpgaImageId &#91;required&#93; The ID of the AFI.
#' @param Attribute &#91;required&#93; The AFI attribute.
#'
#' @section Request syntax:
#' ```
#' svc$describe_fpga_image_attribute(
#'   DryRun = TRUE|FALSE,
#'   FpgaImageId = "string",
#'   Attribute = "description"|"name"|"loadPermission"|"productCodes"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fpga_image_attribute
ec2_describe_fpga_image_attribute <- function(DryRun = NULL, FpgaImageId, Attribute) {
  op <- new_operation(
    name = "DescribeFpgaImageAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_fpga_image_attribute_input(DryRun = DryRun, FpgaImageId = FpgaImageId, Attribute = Attribute)
  output <- .ec2$describe_fpga_image_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fpga_image_attribute <- ec2_describe_fpga_image_attribute

#' Describes the Amazon FPGA Images (AFIs) available to you
#'
#' Describes the Amazon FPGA Images (AFIs) available to you. These include
#' public AFIs, private AFIs that you own, and AFIs owned by other AWS
#' accounts for which you have load permissions.
#'
#' @usage
#' ec2_describe_fpga_images(DryRun, FpgaImageIds, Owners, Filters,
#'   NextToken, MaxResults)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FpgaImageIds The AFI IDs.
#' @param Owners Filters the AFI by owner. Specify an AWS account ID, `self` (owner is
#' the sender of the request), or an AWS owner alias (valid values are
#' `amazon` \\| `aws-marketplace`).
#' @param Filters The filters.
#' 
#' -   `create-time` - The creation time of the AFI.
#' 
#' -   `fpga-image-id` - The FPGA image identifier (AFI ID).
#' 
#' -   `fpga-image-global-id` - The global FPGA image identifier (AGFI ID).
#' 
#' -   `name` - The name of the AFI.
#' 
#' -   `owner-id` - The AWS account ID of the AFI owner.
#' 
#' -   `product-code` - The product code.
#' 
#' -   `shell-version` - The version of the AWS Shell that was used to
#'     create the bitstream.
#' 
#' -   `state` - The state of the AFI (`pending` \\| `failed` \\| `available`
#'     \\| `unavailable`).
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `update-time` - The time of the most recent update.
#' @param NextToken The token to retrieve the next page of results.
#' @param MaxResults The maximum number of results to return in a single call.
#'
#' @section Request syntax:
#' ```
#' svc$describe_fpga_images(
#'   DryRun = TRUE|FALSE,
#'   FpgaImageIds = list(
#'     "string"
#'   ),
#'   Owners = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_fpga_images
ec2_describe_fpga_images <- function(DryRun = NULL, FpgaImageIds = NULL, Owners = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeFpgaImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_fpga_images_input(DryRun = DryRun, FpgaImageIds = FpgaImageIds, Owners = Owners, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_fpga_images_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_fpga_images <- ec2_describe_fpga_images

#' Describes the Dedicated Host reservations that are available to purchase
#'
#' Describes the Dedicated Host reservations that are available to
#' purchase.
#' 
#' The results describe all of the Dedicated Host reservation offerings,
#' including offerings that might not match the instance family and Region
#' of your Dedicated Hosts. When purchasing an offering, ensure that the
#' instance family and Region of the offering matches that of the Dedicated
#' Hosts with which it is to be associated. For more information about
#' supported instance types, see [Dedicated Hosts
#' Overview](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_host_reservation_offerings(Filter, MaxDuration, MaxResults,
#'   MinDuration, NextToken, OfferingId)
#'
#' @param Filter The filters.
#' 
#' -   `instance-family` - The instance family of the offering (for
#'     example, `m4`).
#' 
#' -   `payment-option` - The payment option (`NoUpfront` \\|
#'     `PartialUpfront` \\| `AllUpfront`).
#' @param MaxDuration This is the maximum duration of the reservation to purchase, specified
#' in seconds. Reservations are available in one-year and three-year terms.
#' The number of seconds specified must be the number of seconds in a year
#' (365x24x60x60) times one of the supported durations (1 or 3). For
#' example, specify 94608000 for three years.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the returned `nextToken` value. This value can be between 5 and 500. If
#' `maxResults` is given a larger value than 500, you receive an error.
#' @param MinDuration This is the minimum duration of the reservation you\'d like to purchase,
#' specified in seconds. Reservations are available in one-year and
#' three-year terms. The number of seconds specified must be the number of
#' seconds in a year (365x24x60x60) times one of the supported durations (1
#' or 3). For example, specify 31536000 for one year.
#' @param NextToken The token to use to retrieve the next page of results.
#' @param OfferingId The ID of the reservation offering.
#'
#' @section Request syntax:
#' ```
#' svc$describe_host_reservation_offerings(
#'   Filter = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxDuration = 123,
#'   MaxResults = 123,
#'   MinDuration = 123,
#'   NextToken = "string",
#'   OfferingId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_host_reservation_offerings
ec2_describe_host_reservation_offerings <- function(Filter = NULL, MaxDuration = NULL, MaxResults = NULL, MinDuration = NULL, NextToken = NULL, OfferingId = NULL) {
  op <- new_operation(
    name = "DescribeHostReservationOfferings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_host_reservation_offerings_input(Filter = Filter, MaxDuration = MaxDuration, MaxResults = MaxResults, MinDuration = MinDuration, NextToken = NextToken, OfferingId = OfferingId)
  output <- .ec2$describe_host_reservation_offerings_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_host_reservation_offerings <- ec2_describe_host_reservation_offerings

#' Describes reservations that are associated with Dedicated Hosts in your
#' account
#'
#' Describes reservations that are associated with Dedicated Hosts in your
#' account.
#'
#' @usage
#' ec2_describe_host_reservations(Filter, HostReservationIdSet, MaxResults,
#'   NextToken)
#'
#' @param Filter The filters.
#' 
#' -   `instance-family` - The instance family (for example, `m4`).
#' 
#' -   `payment-option` - The payment option (`NoUpfront` \\|
#'     `PartialUpfront` \\| `AllUpfront`).
#' 
#' -   `state` - The state of the reservation (`payment-pending` \\|
#'     `payment-failed` \\| `active` \\| `retired`).
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param HostReservationIdSet The host reservation IDs.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the returned `nextToken` value. This value can be between 5 and 500. If
#' `maxResults` is given a larger value than 500, you receive an error.
#' @param NextToken The token to use to retrieve the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_host_reservations(
#'   Filter = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   HostReservationIdSet = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_host_reservations
ec2_describe_host_reservations <- function(Filter = NULL, HostReservationIdSet = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeHostReservations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_host_reservations_input(Filter = Filter, HostReservationIdSet = HostReservationIdSet, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_host_reservations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_host_reservations <- ec2_describe_host_reservations

#' Describes the specified Dedicated Hosts or all your Dedicated Hosts
#'
#' Describes the specified Dedicated Hosts or all your Dedicated Hosts.
#' 
#' The results describe only the Dedicated Hosts in the Region you\'re
#' currently using. All listed instances consume capacity on your Dedicated
#' Host. Dedicated Hosts that have recently been released are listed with
#' the state `released`.
#'
#' @usage
#' ec2_describe_hosts(Filter, HostIds, MaxResults, NextToken)
#'
#' @param Filter The filters.
#' 
#' -   `auto-placement` - Whether auto-placement is enabled or disabled
#'     (`on` \\| `off`).
#' 
#' -   `availability-zone` - The Availability Zone of the host.
#' 
#' -   `client-token` - The idempotency token that you provided when you
#'     allocated the host.
#' 
#' -   `host-reservation-id` - The ID of the reservation assigned to this
#'     host.
#' 
#' -   `instance-type` - The instance type size that the Dedicated Host is
#'     configured to support.
#' 
#' -   `state` - The allocation state of the Dedicated Host (`available` \\|
#'     `under-assessment` \\| `permanent-failure` \\| `released` \\|
#'     `released-permanent-failure`).
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param HostIds The IDs of the Dedicated Hosts. The IDs are used for targeted instance
#' launches.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the returned `nextToken` value. This value can be between 5 and 500. If
#' `maxResults` is given a larger value than 500, you receive an error.
#' 
#' You cannot specify this parameter and the host IDs parameter in the same
#' request.
#' @param NextToken The token to use to retrieve the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_hosts(
#'   Filter = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   HostIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_hosts
ec2_describe_hosts <- function(Filter = NULL, HostIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeHosts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_hosts_input(Filter = Filter, HostIds = HostIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_hosts_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_hosts <- ec2_describe_hosts

#' Describes your IAM instance profile associations
#'
#' Describes your IAM instance profile associations.
#'
#' @usage
#' ec2_describe_iam_instance_profile_associations(AssociationIds, Filters,
#'   MaxResults, NextToken)
#'
#' @param AssociationIds The IAM instance profile associations.
#' @param Filters The filters.
#' 
#' -   `instance-id` - The ID of the instance.
#' 
#' -   `state` - The state of the association (`associating` \\|
#'     `associated` \\| `disassociating` \\| `disassociated`).
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token to request the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_iam_instance_profile_associations(
#'   AssociationIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # This example describes the specified IAM instance profile association.
#' \dontrun{svc$describe_iam_instance_profile_associations(
#'   AssociationIds = list(
#'     "iip-assoc-0db249b1f25fa24b8"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_iam_instance_profile_associations
ec2_describe_iam_instance_profile_associations <- function(AssociationIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeIamInstanceProfileAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_iam_instance_profile_associations_input(AssociationIds = AssociationIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_iam_instance_profile_associations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_iam_instance_profile_associations <- ec2_describe_iam_instance_profile_associations

#' Describes the ID format settings for your resources on a per-Region
#' basis, for example, to view which resource types are enabled for longer
#' IDs
#'
#' Describes the ID format settings for your resources on a per-Region
#' basis, for example, to view which resource types are enabled for longer
#' IDs. This request only returns information about resource types whose ID
#' formats can be modified; it does not return information about other
#' resource types.
#' 
#' The following resource types support longer IDs: `bundle` \\|
#' `conversion-task` \\| `customer-gateway` \\| `dhcp-options` \\|
#' `elastic-ip-allocation` \\| `elastic-ip-association` \\| `export-task` \\|
#' `flow-log` \\| `image` \\| `import-task` \\| `instance` \\|
#' `internet-gateway` \\| `network-acl` \\| `network-acl-association` \\|
#' `network-interface` \\| `network-interface-attachment` \\| `prefix-list`
#' \\| `reservation` \\| `route-table` \\| `route-table-association` \\|
#' `security-group` \\| `snapshot` \\| `subnet` \\|
#' `subnet-cidr-block-association` \\| `volume` \\| `vpc` \\|
#' `vpc-cidr-block-association` \\| `vpc-endpoint` \\|
#' `vpc-peering-connection` \\| `vpn-connection` \\| `vpn-gateway`.
#' 
#' These settings apply to the IAM user who makes the request; they do not
#' apply to the entire AWS account. By default, an IAM user defaults to the
#' same settings as the root user, unless they explicitly override the
#' settings by running the ModifyIdFormat command. Resources created with
#' longer IDs are visible to all IAM users, regardless of these settings
#' and provided that they have permission to use the relevant `Describe`
#' command for the resource type.
#'
#' @usage
#' ec2_describe_id_format(Resource)
#'
#' @param Resource The type of resource: `bundle` \\| `conversion-task` \\|
#' `customer-gateway` \\| `dhcp-options` \\| `elastic-ip-allocation` \\|
#' `elastic-ip-association` \\| `export-task` \\| `flow-log` \\| `image` \\|
#' `import-task` \\| `instance` \\| `internet-gateway` \\| `network-acl` \\|
#' `network-acl-association` \\| `network-interface` \\|
#' `network-interface-attachment` \\| `prefix-list` \\| `reservation` \\|
#' `route-table` \\| `route-table-association` \\| `security-group` \\|
#' `snapshot` \\| `subnet` \\| `subnet-cidr-block-association` \\| `volume` \\|
#' `vpc` \\| `vpc-cidr-block-association` \\| `vpc-endpoint` \\|
#' `vpc-peering-connection` \\| `vpn-connection` \\| `vpn-gateway`
#'
#' @section Request syntax:
#' ```
#' svc$describe_id_format(
#'   Resource = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_id_format
ec2_describe_id_format <- function(Resource = NULL) {
  op <- new_operation(
    name = "DescribeIdFormat",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_id_format_input(Resource = Resource)
  output <- .ec2$describe_id_format_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_id_format <- ec2_describe_id_format

#' Describes the ID format settings for resources for the specified IAM
#' user, IAM role, or root user
#'
#' Describes the ID format settings for resources for the specified IAM
#' user, IAM role, or root user. For example, you can view the resource
#' types that are enabled for longer IDs. This request only returns
#' information about resource types whose ID formats can be modified; it
#' does not return information about other resource types. For more
#' information, see [Resource
#' IDs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' The following resource types support longer IDs: `bundle` \\|
#' `conversion-task` \\| `customer-gateway` \\| `dhcp-options` \\|
#' `elastic-ip-allocation` \\| `elastic-ip-association` \\| `export-task` \\|
#' `flow-log` \\| `image` \\| `import-task` \\| `instance` \\|
#' `internet-gateway` \\| `network-acl` \\| `network-acl-association` \\|
#' `network-interface` \\| `network-interface-attachment` \\| `prefix-list`
#' \\| `reservation` \\| `route-table` \\| `route-table-association` \\|
#' `security-group` \\| `snapshot` \\| `subnet` \\|
#' `subnet-cidr-block-association` \\| `volume` \\| `vpc` \\|
#' `vpc-cidr-block-association` \\| `vpc-endpoint` \\|
#' `vpc-peering-connection` \\| `vpn-connection` \\| `vpn-gateway`.
#' 
#' These settings apply to the principal specified in the request. They do
#' not apply to the principal that makes the request.
#'
#' @usage
#' ec2_describe_identity_id_format(PrincipalArn, Resource)
#'
#' @param PrincipalArn &#91;required&#93; The ARN of the principal, which can be an IAM role, IAM user, or the
#' root user.
#' @param Resource The type of resource: `bundle` \\| `conversion-task` \\|
#' `customer-gateway` \\| `dhcp-options` \\| `elastic-ip-allocation` \\|
#' `elastic-ip-association` \\| `export-task` \\| `flow-log` \\| `image` \\|
#' `import-task` \\| `instance` \\| `internet-gateway` \\| `network-acl` \\|
#' `network-acl-association` \\| `network-interface` \\|
#' `network-interface-attachment` \\| `prefix-list` \\| `reservation` \\|
#' `route-table` \\| `route-table-association` \\| `security-group` \\|
#' `snapshot` \\| `subnet` \\| `subnet-cidr-block-association` \\| `volume` \\|
#' `vpc` \\| `vpc-cidr-block-association` \\| `vpc-endpoint` \\|
#' `vpc-peering-connection` \\| `vpn-connection` \\| `vpn-gateway`
#'
#' @section Request syntax:
#' ```
#' svc$describe_identity_id_format(
#'   PrincipalArn = "string",
#'   Resource = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_identity_id_format
ec2_describe_identity_id_format <- function(PrincipalArn, Resource = NULL) {
  op <- new_operation(
    name = "DescribeIdentityIdFormat",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_identity_id_format_input(PrincipalArn = PrincipalArn, Resource = Resource)
  output <- .ec2$describe_identity_id_format_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_identity_id_format <- ec2_describe_identity_id_format

#' Describes the specified attribute of the specified AMI
#'
#' Describes the specified attribute of the specified AMI. You can specify
#' only one attribute at a time.
#'
#' @usage
#' ec2_describe_image_attribute(Attribute, ImageId, DryRun)
#'
#' @param Attribute &#91;required&#93; The AMI attribute.
#' 
#' **Note**: Depending on your account privileges, the `blockDeviceMapping`
#' attribute may return a `Client.AuthFailure` error. If this happens, use
#' DescribeImages to get information about the block device mapping for the
#' AMI.
#' @param ImageId &#91;required&#93; The ID of the AMI.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_image_attribute(
#'   Attribute = "description"|"kernel"|"ramdisk"|"launchPermission"|"productCodes"|"blockDeviceMapping"|"sriovNetSupport",
#'   ImageId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example describes the launch permissions for the specified AMI.
#' \dontrun{svc$describe_image_attribute(
#'   Attribute = "launchPermission",
#'   ImageId = "ami-5731123e"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_image_attribute
ec2_describe_image_attribute <- function(Attribute, ImageId, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeImageAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_image_attribute_input(Attribute = Attribute, ImageId = ImageId, DryRun = DryRun)
  output <- .ec2$describe_image_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_image_attribute <- ec2_describe_image_attribute

#' Describes the specified images (AMIs, AKIs, and ARIs) available to you
#' or all of the images available to you
#'
#' Describes the specified images (AMIs, AKIs, and ARIs) available to you
#' or all of the images available to you.
#' 
#' The images available to you include public images, private images that
#' you own, and private images owned by other AWS accounts for which you
#' have explicit launch permissions.
#' 
#' Recently deregistered images appear in the returned results for a short
#' interval and then return empty results. After all instances that
#' reference a deregistered AMI are terminated, specifying the ID of the
#' image results in an error indicating that the AMI ID cannot be found.
#'
#' @usage
#' ec2_describe_images(ExecutableUsers, Filters, ImageIds, Owners, DryRun)
#'
#' @param ExecutableUsers Scopes the images by users with explicit launch permissions. Specify an
#' AWS account ID, `self` (the sender of the request), or `all` (public
#' AMIs).
#' @param Filters The filters.
#' 
#' -   `architecture` - The image architecture (`i386` \\| `x86_64` \\|
#'     `arm64`).
#' 
#' -   `block-device-mapping.delete-on-termination` - A Boolean value that
#'     indicates whether the Amazon EBS volume is deleted on instance
#'     termination.
#' 
#' -   `block-device-mapping.device-name` - The device name specified in
#'     the block device mapping (for example, `/dev/sdh` or `xvdh`).
#' 
#' -   `block-device-mapping.snapshot-id` - The ID of the snapshot used for
#'     the EBS volume.
#' 
#' -   `block-device-mapping.volume-size` - The volume size of the EBS
#'     volume, in GiB.
#' 
#' -   `block-device-mapping.volume-type` - The volume type of the EBS
#'     volume (`gp2` \\| `io1` \\| `st1 `\\| `sc1` \\| `standard`).
#' 
#' -   `block-device-mapping.encrypted` - A Boolean that indicates whether
#'     the EBS volume is encrypted.
#' 
#' -   `description` - The description of the image (provided during image
#'     creation).
#' 
#' -   `ena-support` - A Boolean that indicates whether enhanced networking
#'     with ENA is enabled.
#' 
#' -   `hypervisor` - The hypervisor type (`ovm` \\| `xen`).
#' 
#' -   `image-id` - The ID of the image.
#' 
#' -   `image-type` - The image type (`machine` \\| `kernel` \\| `ramdisk`).
#' 
#' -   `is-public` - A Boolean that indicates whether the image is public.
#' 
#' -   `kernel-id` - The kernel ID.
#' 
#' -   `manifest-location` - The location of the image manifest.
#' 
#' -   `name` - The name of the AMI (provided during image creation).
#' 
#' -   `owner-alias` - String value from an Amazon-maintained list
#'     (`amazon` \\| `aws-marketplace` \\| `microsoft`) of snapshot owners.
#'     Not to be confused with the user-configured AWS account alias, which
#'     is set from the IAM console.
#' 
#' -   `owner-id` - The AWS account ID of the image owner.
#' 
#' -   `platform` - The platform. To only list Windows-based AMIs, use
#'     `windows`.
#' 
#' -   `product-code` - The product code.
#' 
#' -   `product-code.type` - The type of the product code (`devpay` \\|
#'     `marketplace`).
#' 
#' -   `ramdisk-id` - The RAM disk ID.
#' 
#' -   `root-device-name` - The device name of the root device volume (for
#'     example, `/dev/sda1`).
#' 
#' -   `root-device-type` - The type of the root device volume (`ebs` \\|
#'     `instance-store`).
#' 
#' -   `state` - The state of the image (`available` \\| `pending` \\|
#'     `failed`).
#' 
#' -   `state-reason-code` - The reason code for the state change.
#' 
#' -   `state-reason-message` - The message for the state change.
#' 
#' -   `sriov-net-support` - A value of `simple` indicates that enhanced
#'     networking with the Intel 82599 VF interface is enabled.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `virtualization-type` - The virtualization type (`paravirtual` \\|
#'     `hvm`).
#' @param ImageIds The image IDs.
#' 
#' Default: Describes all images available to you.
#' @param Owners Filters the images by the owner. Specify an AWS account ID, `self`
#' (owner is the sender of the request), or an AWS owner alias (valid
#' values are `amazon` \\| `aws-marketplace` \\| `microsoft`). Omitting this
#' option returns all images for which you have launch permissions,
#' regardless of ownership.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_images(
#'   ExecutableUsers = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ImageIds = list(
#'     "string"
#'   ),
#'   Owners = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example describes the specified AMI.
#' \dontrun{svc$describe_images(
#'   ImageIds = list(
#'     "ami-5731123e"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_images
ec2_describe_images <- function(ExecutableUsers = NULL, Filters = NULL, ImageIds = NULL, Owners = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeImages",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_images_input(ExecutableUsers = ExecutableUsers, Filters = Filters, ImageIds = ImageIds, Owners = Owners, DryRun = DryRun)
  output <- .ec2$describe_images_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_images <- ec2_describe_images

#' Displays details about an import virtual machine or import snapshot
#' tasks that are already created
#'
#' Displays details about an import virtual machine or import snapshot
#' tasks that are already created.
#'
#' @usage
#' ec2_describe_import_image_tasks(DryRun, Filters, ImportTaskIds,
#'   MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters Filter tasks using the `task-state` filter and one of the following
#' values: `active`, `completed`, `deleting`, or `deleted`.
#' @param ImportTaskIds The IDs of the import image tasks.
#' @param MaxResults The maximum number of results to return in a single call.
#' @param NextToken A token that indicates the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_import_image_tasks(
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ImportTaskIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_import_image_tasks
ec2_describe_import_image_tasks <- function(DryRun = NULL, Filters = NULL, ImportTaskIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeImportImageTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_import_image_tasks_input(DryRun = DryRun, Filters = Filters, ImportTaskIds = ImportTaskIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_import_image_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_import_image_tasks <- ec2_describe_import_image_tasks

#' Describes your import snapshot tasks
#'
#' Describes your import snapshot tasks.
#'
#' @usage
#' ec2_describe_import_snapshot_tasks(DryRun, Filters, ImportTaskIds,
#'   MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' @param ImportTaskIds A list of import snapshot task IDs.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken A token that indicates the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_import_snapshot_tasks(
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ImportTaskIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_import_snapshot_tasks
ec2_describe_import_snapshot_tasks <- function(DryRun = NULL, Filters = NULL, ImportTaskIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeImportSnapshotTasks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_import_snapshot_tasks_input(DryRun = DryRun, Filters = Filters, ImportTaskIds = ImportTaskIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_import_snapshot_tasks_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_import_snapshot_tasks <- ec2_describe_import_snapshot_tasks

#' Describes the specified attribute of the specified instance
#'
#' Describes the specified attribute of the specified instance. You can
#' specify only one attribute at a time. Valid attribute values are:
#' `instanceType` \\| `kernel` \\| `ramdisk` \\| `userData` \\|
#' `disableApiTermination` \\| `instanceInitiatedShutdownBehavior` \\|
#' `rootDeviceName` \\| `blockDeviceMapping` \\| `productCodes` \\|
#' `sourceDestCheck` \\| `groupSet` \\| `ebsOptimized` \\| `sriovNetSupport`
#'
#' @usage
#' ec2_describe_instance_attribute(Attribute, DryRun, InstanceId)
#'
#' @param Attribute &#91;required&#93; The instance attribute.
#' 
#' Note: The `enaSupport` attribute is not supported at this time.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_attribute(
#'   Attribute = "instanceType"|"kernel"|"ramdisk"|"userData"|"disableApiTermination"|"instanceInitiatedShutdownBehavior"|"rootDeviceName"|"blockDeviceMapping"|"productCodes"|"sourceDestCheck"|"groupSet"|"ebsOptimized"|"sriovNetSupport"|"enaSupport",
#'   DryRun = TRUE|FALSE,
#'   InstanceId = "string"
#' )
#' ```
#'
#' @examples
#' # This example describes the instance type of the specified instance.
#' # 
#' \dontrun{svc$describe_instance_attribute(
#'   Attribute = "instanceType",
#'   InstanceId = "i-1234567890abcdef0"
#' )}
#' 
#' # This example describes the `disableApiTermination` attribute of the
#' # specified instance.
#' # 
#' \dontrun{svc$describe_instance_attribute(
#'   Attribute = "disableApiTermination",
#'   InstanceId = "i-1234567890abcdef0"
#' )}
#' 
#' # This example describes the `blockDeviceMapping` attribute of the
#' # specified instance.
#' # 
#' \dontrun{svc$describe_instance_attribute(
#'   Attribute = "blockDeviceMapping",
#'   InstanceId = "i-1234567890abcdef0"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_attribute
ec2_describe_instance_attribute <- function(Attribute, DryRun = NULL, InstanceId) {
  op <- new_operation(
    name = "DescribeInstanceAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_instance_attribute_input(Attribute = Attribute, DryRun = DryRun, InstanceId = InstanceId)
  output <- .ec2$describe_instance_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_attribute <- ec2_describe_instance_attribute

#' Describes the credit option for CPU usage of the specified burstable
#' performance instances
#'
#' Describes the credit option for CPU usage of the specified burstable
#' performance instances. The credit options are `standard` and
#' `unlimited`.
#' 
#' If you do not specify an instance ID, Amazon EC2 returns burstable
#' performance instances with the `unlimited` credit option, as well as
#' instances that were previously configured as T2, T3, and T3a with the
#' `unlimited` credit option. For example, if you resize a T2 instance,
#' while it is configured as `unlimited`, to an M4 instance, Amazon EC2
#' returns the M4 instance.
#' 
#' If you specify one or more instance IDs, Amazon EC2 returns the credit
#' option (`standard` or `unlimited`) of those instances. If you specify an
#' instance ID that is not valid, such as an instance that is not a
#' burstable performance instance, an error is returned.
#' 
#' Recently terminated instances might appear in the returned results. This
#' interval is usually less than one hour.
#' 
#' If an Availability Zone is experiencing a service disruption and you
#' specify instance IDs in the affected zone, or do not specify any
#' instance IDs at all, the call fails. If you specify only instance IDs in
#' an unaffected zone, the call works normally.
#' 
#' For more information, see [Burstable Performance
#' Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_instance_credit_specifications(DryRun, Filters,
#'   InstanceIds, MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `instance-id` - The ID of the instance.
#' @param InstanceIds The instance IDs.
#' 
#' Default: Describes all your instances.
#' 
#' Constraints: Maximum 1000 explicitly specified instance IDs.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 5 and 1000. You cannot specify this
#' parameter and the instance IDs parameter in the same call.
#' @param NextToken The token to retrieve the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_credit_specifications(
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_credit_specifications
ec2_describe_instance_credit_specifications <- function(DryRun = NULL, Filters = NULL, InstanceIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstanceCreditSpecifications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_instance_credit_specifications_input(DryRun = DryRun, Filters = Filters, InstanceIds = InstanceIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_instance_credit_specifications_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_credit_specifications <- ec2_describe_instance_credit_specifications

#' Describes the status of the specified instances or all of your instances
#'
#' Describes the status of the specified instances or all of your
#' instances. By default, only running instances are described, unless you
#' specifically indicate to return the status of all instances.
#' 
#' Instance status includes the following components:
#' 
#' -   **Status checks** - Amazon EC2 performs status checks on running EC2
#'     instances to identify hardware and software issues. For more
#'     information, see [Status Checks for Your
#'     Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-system-instance-status-check.html)
#'     and [Troubleshooting Instances with Failed Status
#'     Checks](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/TroubleshootingInstances.html)
#'     in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' -   **Scheduled events** - Amazon EC2 can schedule events (such as
#'     reboot, stop, or terminate) for your instances related to hardware
#'     issues, software updates, or system maintenance. For more
#'     information, see [Scheduled Events for Your
#'     Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-instances-status-check_sched.html)
#'     in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' -   **Instance state** - You can manage your instances from the moment
#'     you launch them through their termination. For more information, see
#'     [Instance
#'     Lifecycle](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-lifecycle.html)
#'     in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_instance_status(Filters, InstanceIds, MaxResults,
#'   NextToken, DryRun, IncludeAllInstances)
#'
#' @param Filters The filters.
#' 
#' -   `availability-zone` - The Availability Zone of the instance.
#' 
#' -   `event.code` - The code for the scheduled event (`instance-reboot`
#'     \\| `system-reboot` \\| `system-maintenance` \\| `instance-retirement`
#'     \\| `instance-stop`).
#' 
#' -   `event.description` - A description of the event.
#' 
#' -   `event.instance-event-id` - The ID of the event whose date and time
#'     you are modifying.
#' 
#' -   `event.not-after` - The latest end time for the scheduled event (for
#'     example, `2014-09-15T17:15:20.000Z`).
#' 
#' -   `event.not-before` - The earliest start time for the scheduled event
#'     (for example, `2014-09-15T17:15:20.000Z`).
#' 
#' -   `event.not-before-deadline` - The deadline for starting the event
#'     (for example, `2014-09-15T17:15:20.000Z`).
#' 
#' -   `instance-state-code` - The code for the instance state, as a 16-bit
#'     unsigned integer. The high byte is used for internal purposes and
#'     should be ignored. The low byte is set based on the state
#'     represented. The valid values are 0 (pending), 16 (running), 32
#'     (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
#' 
#' -   `instance-state-name` - The state of the instance (`pending` \\|
#'     `running` \\| `shutting-down` \\| `terminated` \\| `stopping` \\|
#'     `stopped`).
#' 
#' -   `instance-status.reachability` - Filters on instance status where
#'     the name is `reachability` (`passed` \\| `failed` \\| `initializing`
#'     \\| `insufficient-data`).
#' 
#' -   `instance-status.status` - The status of the instance (`ok` \\|
#'     `impaired` \\| `initializing` \\| `insufficient-data` \\|
#'     `not-applicable`).
#' 
#' -   `system-status.reachability` - Filters on system status where the
#'     name is `reachability` (`passed` \\| `failed` \\| `initializing` \\|
#'     `insufficient-data`).
#' 
#' -   `system-status.status` - The system status of the instance (`ok` \\|
#'     `impaired` \\| `initializing` \\| `insufficient-data` \\|
#'     `not-applicable`).
#' @param InstanceIds The instance IDs.
#' 
#' Default: Describes all your instances.
#' 
#' Constraints: Maximum 100 explicitly specified instance IDs.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 5 and 1000. You cannot specify this
#' parameter and the instance IDs parameter in the same call.
#' @param NextToken The token to retrieve the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param IncludeAllInstances When `true`, includes the health status for all instances. When `false`,
#' includes the health status for running instances only.
#' 
#' Default: `false`
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_status(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE,
#'   IncludeAllInstances = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example describes the current status of the specified instance.
#' \dontrun{svc$describe_instance_status(
#'   InstanceIds = list(
#'     "i-1234567890abcdef0"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_status
ec2_describe_instance_status <- function(Filters = NULL, InstanceIds = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL, IncludeAllInstances = NULL) {
  op <- new_operation(
    name = "DescribeInstanceStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_instance_status_input(Filters = Filters, InstanceIds = InstanceIds, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun, IncludeAllInstances = IncludeAllInstances)
  output <- .ec2$describe_instance_status_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_status <- ec2_describe_instance_status

#' Returns a list of all instance types offered
#'
#' Returns a list of all instance types offered. The results can be
#' filtered by location (Region or Availability Zone). If no location is
#' specified, the instance types offered in the current Region are
#' returned.
#'
#' @usage
#' ec2_describe_instance_type_offerings(DryRun, LocationType, Filters,
#'   MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LocationType The location type.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `location` - This depends on the location type. For example, if the
#'     location type is `region` (default), the location is the Region code
#'     (for example, `us-east-2`.)
#' 
#' -   `instance-type` - The instance type.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the next token value.
#' @param NextToken The token to retrieve the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_type_offerings(
#'   DryRun = TRUE|FALSE,
#'   LocationType = "region"|"availability-zone"|"availability-zone-id",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_type_offerings
ec2_describe_instance_type_offerings <- function(DryRun = NULL, LocationType = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstanceTypeOfferings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_instance_type_offerings_input(DryRun = DryRun, LocationType = LocationType, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_instance_type_offerings_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_type_offerings <- ec2_describe_instance_type_offerings

#' Returns a list of all instance types offered in your current AWS Region
#'
#' Returns a list of all instance types offered in your current AWS Region.
#' The results can be filtered by the attributes of the instance types.
#'
#' @usage
#' ec2_describe_instance_types(DryRun, InstanceTypes, Filters, MaxResults,
#'   NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceTypes The instance types. For more information, see [Instance
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param Filters One or more filters. Filter names and values are case-sensitive.
#' 
#' -   `auto-recovery-supported` - Indicates whether auto recovery is
#'     supported. (`true` \\| `false`)
#' 
#' -   `bare-metal` - Indicates whether it is a bare metal instance type.
#'     (`true` \\| `false`)
#' 
#' -   `burstable-performance-supported` - Indicates whether it is a
#'     burstable performance instance type. (`true` \\| `false`)
#' 
#' -   `current-generation` - Indicates whether this instance type is the
#'     latest generation instance type of an instance family. (`true` \\|
#'     `false`)
#' 
#' -   `ebs-info.ebs-optimized-support` - Indicates whether the instance
#'     type is EBS-optimized. (`true` \\| `false`)
#' 
#' -   `ebs-info.encryption-support` - Indicates whether EBS encryption is
#'     supported. (`true` \\| `false`)
#' 
#' -   `free-tier-eligible` - Indicates whether the instance type is
#'     eligible to use in the free tier. (`true` \\| `false`)
#' 
#' -   `hibernation-supported` - Indicates whether On-Demand hibernation is
#'     supported. (`true` \\| `false`)
#' 
#' -   `hypervisor` - The hypervisor used. (`nitro` \\| `xen`)
#' 
#' -   `instance-storage-info.disk.count` - The number of local disks.
#' 
#' -   `instance-storage-info.disk.size-in-gb` - The storage size of each
#'     instance storage disk, in GB.
#' 
#' -   `instance-storage-info.disk.type` - The storage technology for the
#'     local instance storage disks. (`hdd` \\| `ssd`)
#' 
#' -   `instance-storage-info.total-size-in-gb` - The total amount of
#'     storage available from all local instance storage, in GB.
#' 
#' -   `instance-storage-supported` - Indicates whether the instance type
#'     has local instance storage. (`true` \\| `false`)
#' 
#' -   `memory-info.size-in-mib` - The memory size.
#' 
#' -   `network-info.ena-support` - Indicates whether Elastic Network
#'     Adapter (ENA) is supported or required. (`required` \\| `supported`
#'     \\| `unsupported`)
#' 
#' -   `network-info.ipv4-addresses-per-interface` - The maximum number of
#'     private IPv4 addresses per network interface.
#' 
#' -   `network-info.ipv6-addresses-per-interface` - The maximum number of
#'     private IPv6 addresses per network interface.
#' 
#' -   `network-info.ipv6-supported` - Indicates whether the instance type
#'     supports IPv6. (`true` \\| `false`)
#' 
#' -   `network-info.maximum-network-interfaces` - The maximum number of
#'     network interfaces per instance.
#' 
#' -   `network-info.network-performance` - Describes the network
#'     performance.
#' 
#' -   `processor-info.sustained-clock-speed-in-ghz` - The CPU clock speed,
#'     in GHz.
#' 
#' -   `vcpu-info.default-cores` - The default number of cores for the
#'     instance type.
#' 
#' -   `vcpu-info.default-threads-per-core` - The default number of threads
#'     per cores for the instance type.
#' 
#' -   `vcpu-info.default-vcpus` - The default number of vCPUs for the
#'     instance type.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the next token value.
#' @param NextToken The token to retrieve the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_instance_types(
#'   DryRun = TRUE|FALSE,
#'   InstanceTypes = list(
#'     "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instance_types
ec2_describe_instance_types <- function(DryRun = NULL, InstanceTypes = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstanceTypes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_instance_types_input(DryRun = DryRun, InstanceTypes = InstanceTypes, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_instance_types_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instance_types <- ec2_describe_instance_types

#' Describes the specified instances or all of AWS account's instances
#'
#' Describes the specified instances or all of AWS account\'s instances.
#' 
#' If you specify one or more instance IDs, Amazon EC2 returns information
#' for those instances. If you do not specify instance IDs, Amazon EC2
#' returns information for all relevant instances. If you specify an
#' instance ID that is not valid, an error is returned. If you specify an
#' instance that you do not own, it is not included in the returned
#' results.
#' 
#' Recently terminated instances might appear in the returned results. This
#' interval is usually less than one hour.
#' 
#' If you describe instances in the rare case where an Availability Zone is
#' experiencing a service disruption and you specify instance IDs that are
#' in the affected zone, or do not specify any instance IDs at all, the
#' call fails. If you describe instances and specify only instance IDs that
#' are in an unaffected zone, the call works normally.
#'
#' @usage
#' ec2_describe_instances(Filters, InstanceIds, DryRun, MaxResults,
#'   NextToken)
#'
#' @param Filters The filters.
#' 
#' -   `affinity` - The affinity setting for an instance running on a
#'     Dedicated Host (`default` \\| `host`).
#' 
#' -   `architecture` - The instance architecture (`i386` \\| `x86_64` \\|
#'     `arm64`).
#' 
#' -   `availability-zone` - The Availability Zone of the instance.
#' 
#' -   `block-device-mapping.attach-time` - The attach time for an EBS
#'     volume mapped to the instance, for example,
#'     `2010-09-15T17:15:20.000Z`.
#' 
#' -   `block-device-mapping.delete-on-termination` - A Boolean that
#'     indicates whether the EBS volume is deleted on instance termination.
#' 
#' -   `block-device-mapping.device-name` - The device name specified in
#'     the block device mapping (for example, `/dev/sdh` or `xvdh`).
#' 
#' -   `block-device-mapping.status` - The status for the EBS volume
#'     (`attaching` \\| `attached` \\| `detaching` \\| `detached`).
#' 
#' -   `block-device-mapping.volume-id` - The volume ID of the EBS volume.
#' 
#' -   `client-token` - The idempotency token you provided when you
#'     launched the instance.
#' 
#' -   `dns-name` - The public DNS name of the instance.
#' 
#' -   `group-id` - The ID of the security group for the instance.
#'     EC2-Classic only.
#' 
#' -   `group-name` - The name of the security group for the instance.
#'     EC2-Classic only.
#' 
#' -   `hibernation-options.configured` - A Boolean that indicates whether
#'     the instance is enabled for hibernation. A value of `true` means
#'     that the instance is enabled for hibernation.
#' 
#' -   `host-id` - The ID of the Dedicated Host on which the instance is
#'     running, if applicable.
#' 
#' -   `hypervisor` - The hypervisor type of the instance (`ovm` \\| `xen`).
#' 
#' -   `iam-instance-profile.arn` - The instance profile associated with
#'     the instance. Specified as an ARN.
#' 
#' -   `image-id` - The ID of the image used to launch the instance.
#' 
#' -   `instance-id` - The ID of the instance.
#' 
#' -   `instance-lifecycle` - Indicates whether this is a Spot Instance or
#'     a Scheduled Instance (`spot` \\| `scheduled`).
#' 
#' -   `instance-state-code` - The state of the instance, as a 16-bit
#'     unsigned integer. The high byte is used for internal purposes and
#'     should be ignored. The low byte is set based on the state
#'     represented. The valid values are: 0 (pending), 16 (running), 32
#'     (shutting-down), 48 (terminated), 64 (stopping), and 80 (stopped).
#' 
#' -   `instance-state-name` - The state of the instance (`pending` \\|
#'     `running` \\| `shutting-down` \\| `terminated` \\| `stopping` \\|
#'     `stopped`).
#' 
#' -   `instance-type` - The type of instance (for example, `t2.micro`).
#' 
#' -   `instance.group-id` - The ID of the security group for the instance.
#' 
#' -   `instance.group-name` - The name of the security group for the
#'     instance.
#' 
#' -   `ip-address` - The public IPv4 address of the instance.
#' 
#' -   `kernel-id` - The kernel ID.
#' 
#' -   `key-name` - The name of the key pair used when the instance was
#'     launched.
#' 
#' -   `launch-index` - When launching multiple instances, this is the
#'     index for the instance in the launch group (for example, 0, 1, 2,
#'     and so on).
#' 
#' -   `launch-time` - The time when the instance was launched.
#' 
#' -   `metadata-options.http-tokens` - The metadata request authorization
#'     state (`optional` \\| `required`)
#' 
#' -   `metadata-options.http-put-response-hop-limit` - The http metadata
#'     request put response hop limit (integer, possible values `1` to
#'     `64`)
#' 
#' -   `metadata-options.http-endpoint` - Enable or disable metadata access
#'     on http endpoint (`enabled` \\| `disabled`)
#' 
#' -   `monitoring-state` - Indicates whether detailed monitoring is
#'     enabled (`disabled` \\| `enabled`).
#' 
#' -   `network-interface.addresses.private-ip-address` - The private IPv4
#'     address associated with the network interface.
#' 
#' -   `network-interface.addresses.primary` - Specifies whether the IPv4
#'     address of the network interface is the primary private IPv4
#'     address.
#' 
#' -   `network-interface.addresses.association.public-ip` - The ID of the
#'     association of an Elastic IP address (IPv4) with a network
#'     interface.
#' 
#' -   `network-interface.addresses.association.ip-owner-id` - The owner ID
#'     of the private IPv4 address associated with the network interface.
#' 
#' -   `network-interface.association.public-ip` - The address of the
#'     Elastic IP address (IPv4) bound to the network interface.
#' 
#' -   `network-interface.association.ip-owner-id` - The owner of the
#'     Elastic IP address (IPv4) associated with the network interface.
#' 
#' -   `network-interface.association.allocation-id` - The allocation ID
#'     returned when you allocated the Elastic IP address (IPv4) for your
#'     network interface.
#' 
#' -   `network-interface.association.association-id` - The association ID
#'     returned when the network interface was associated with an IPv4
#'     address.
#' 
#' -   `network-interface.attachment.attachment-id` - The ID of the
#'     interface attachment.
#' 
#' -   `network-interface.attachment.instance-id` - The ID of the instance
#'     to which the network interface is attached.
#' 
#' -   `network-interface.attachment.instance-owner-id` - The owner ID of
#'     the instance to which the network interface is attached.
#' 
#' -   `network-interface.attachment.device-index` - The device index to
#'     which the network interface is attached.
#' 
#' -   `network-interface.attachment.status` - The status of the attachment
#'     (`attaching` \\| `attached` \\| `detaching` \\| `detached`).
#' 
#' -   `network-interface.attachment.attach-time` - The time that the
#'     network interface was attached to an instance.
#' 
#' -   `network-interface.attachment.delete-on-termination` - Specifies
#'     whether the attachment is deleted when an instance is terminated.
#' 
#' -   `network-interface.availability-zone` - The Availability Zone for
#'     the network interface.
#' 
#' -   `network-interface.description` - The description of the network
#'     interface.
#' 
#' -   `network-interface.group-id` - The ID of a security group associated
#'     with the network interface.
#' 
#' -   `network-interface.group-name` - The name of a security group
#'     associated with the network interface.
#' 
#' -   `network-interface.ipv6-addresses.ipv6-address` - The IPv6 address
#'     associated with the network interface.
#' 
#' -   `network-interface.mac-address` - The MAC address of the network
#'     interface.
#' 
#' -   `network-interface.network-interface-id` - The ID of the network
#'     interface.
#' 
#' -   `network-interface.owner-id` - The ID of the owner of the network
#'     interface.
#' 
#' -   `network-interface.private-dns-name` - The private DNS name of the
#'     network interface.
#' 
#' -   `network-interface.requester-id` - The requester ID for the network
#'     interface.
#' 
#' -   `network-interface.requester-managed` - Indicates whether the
#'     network interface is being managed by AWS.
#' 
#' -   `network-interface.status` - The status of the network interface
#'     (`available`) \\| `in-use`).
#' 
#' -   `network-interface.source-dest-check` - Whether the network
#'     interface performs source/destination checking. A value of `true`
#'     means that checking is enabled, and `false` means that checking is
#'     disabled. The value must be `false` for the network interface to
#'     perform network address translation (NAT) in your VPC.
#' 
#' -   `network-interface.subnet-id` - The ID of the subnet for the network
#'     interface.
#' 
#' -   `network-interface.vpc-id` - The ID of the VPC for the network
#'     interface.
#' 
#' -   `owner-id` - The AWS account ID of the instance owner.
#' 
#' -   `placement-group-name` - The name of the placement group for the
#'     instance.
#' 
#' -   `placement-partition-number` - The partition in which the instance
#'     is located.
#' 
#' -   `platform` - The platform. To list only Windows instances, use
#'     `windows`.
#' 
#' -   `private-dns-name` - The private IPv4 DNS name of the instance.
#' 
#' -   `private-ip-address` - The private IPv4 address of the instance.
#' 
#' -   `product-code` - The product code associated with the AMI used to
#'     launch the instance.
#' 
#' -   `product-code.type` - The type of product code (`devpay` \\|
#'     `marketplace`).
#' 
#' -   `ramdisk-id` - The RAM disk ID.
#' 
#' -   `reason` - The reason for the current state of the instance (for
#'     example, shows \"User Initiated \[date\]\" when you stop or
#'     terminate the instance). Similar to the state-reason-code filter.
#' 
#' -   `requester-id` - The ID of the entity that launched the instance on
#'     your behalf (for example, AWS Management Console, Auto Scaling, and
#'     so on).
#' 
#' -   `reservation-id` - The ID of the instance\'s reservation. A
#'     reservation ID is created any time you launch an instance. A
#'     reservation ID has a one-to-one relationship with an instance launch
#'     request, but can be associated with more than one instance if you
#'     launch multiple instances using the same launch request. For
#'     example, if you launch one instance, you get one reservation ID. If
#'     you launch ten instances using the same launch request, you also get
#'     one reservation ID.
#' 
#' -   `root-device-name` - The device name of the root device volume (for
#'     example, `/dev/sda1`).
#' 
#' -   `root-device-type` - The type of the root device volume (`ebs` \\|
#'     `instance-store`).
#' 
#' -   `source-dest-check` - Indicates whether the instance performs
#'     source/destination checking. A value of `true` means that checking
#'     is enabled, and `false` means that checking is disabled. The value
#'     must be `false` for the instance to perform network address
#'     translation (NAT) in your VPC.
#' 
#' -   `spot-instance-request-id` - The ID of the Spot Instance request.
#' 
#' -   `state-reason-code` - The reason code for the state change.
#' 
#' -   `state-reason-message` - A message that describes the state change.
#' 
#' -   `subnet-id` - The ID of the subnet for the instance.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources that have a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `tenancy` - The tenancy of an instance (`dedicated` \\| `default` \\|
#'     `host`).
#' 
#' -   `virtualization-type` - The virtualization type of the instance
#'     (`paravirtual` \\| `hvm`).
#' 
#' -   `vpc-id` - The ID of the VPC that the instance is running in.
#' @param InstanceIds The instance IDs.
#' 
#' Default: Describes all your instances.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 5 and 1000. You cannot specify this
#' parameter and the instance IDs parameter in the same call.
#' @param NextToken The token to request the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_instances(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   InstanceIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # This example describes the specified instance.
#' \dontrun{svc$describe_instances(
#'   InstanceIds = list(
#'     "i-1234567890abcdef0"
#'   )
#' )}
#' 
#' # This example describes the instances with the t2.micro instance type.
#' \dontrun{svc$describe_instances(
#'   Filters = list(
#'     list(
#'       Name = "instance-type",
#'       Values = list(
#'         "t2.micro"
#'       )
#'     )
#'   )
#' )}
#' 
#' # This example describes the instances with the Purpose=test tag.
#' \dontrun{svc$describe_instances(
#'   Filters = list(
#'     list(
#'       Name = "tag:Purpose",
#'       Values = list(
#'         "test"
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_instances
ec2_describe_instances <- function(Filters = NULL, InstanceIds = NULL, DryRun = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_instances_input(Filters = Filters, InstanceIds = InstanceIds, DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_instances_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_instances <- ec2_describe_instances

#' Describes one or more of your internet gateways
#'
#' Describes one or more of your internet gateways.
#'
#' @usage
#' ec2_describe_internet_gateways(Filters, DryRun, InternetGatewayIds,
#'   NextToken, MaxResults)
#'
#' @param Filters One or more filters.
#' 
#' -   `attachment.state` - The current state of the attachment between the
#'     gateway and the VPC (`available`). Present only if a VPC is
#'     attached.
#' 
#' -   `attachment.vpc-id` - The ID of an attached VPC.
#' 
#' -   `internet-gateway-id` - The ID of the Internet gateway.
#' 
#' -   `owner-id` - The ID of the AWS account that owns the internet
#'     gateway.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InternetGatewayIds One or more internet gateway IDs.
#' 
#' Default: Describes all your internet gateways.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @section Request syntax:
#' ```
#' svc$describe_internet_gateways(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   InternetGatewayIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' # This example describes the Internet gateway for the specified VPC.
#' \dontrun{svc$describe_internet_gateways(
#'   Filters = list(
#'     list(
#'       Name = "attachment.vpc-id",
#'       Values = list(
#'         "vpc-a01106c2"
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_internet_gateways
ec2_describe_internet_gateways <- function(Filters = NULL, DryRun = NULL, InternetGatewayIds = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeInternetGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_internet_gateways_input(Filters = Filters, DryRun = DryRun, InternetGatewayIds = InternetGatewayIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_internet_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_internet_gateways <- ec2_describe_internet_gateways

#' Describes the specified key pairs or all of your key pairs
#'
#' Describes the specified key pairs or all of your key pairs.
#' 
#' For more information about key pairs, see [Key
#' Pairs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_key_pairs(Filters, KeyNames, KeyPairIds, DryRun)
#'
#' @param Filters The filters.
#' 
#' -   `fingerprint` - The fingerprint of the key pair.
#' 
#' -   `key-name` - The name of the key pair.
#' @param KeyNames The key pair names.
#' 
#' Default: Describes all your key pairs.
#' @param KeyPairIds The IDs of the key pairs.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_key_pairs(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   KeyNames = list(
#'     "string"
#'   ),
#'   KeyPairIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example displays the fingerprint for the specified key.
#' \dontrun{svc$describe_key_pairs(
#'   KeyNames = list(
#'     "my-key-pair"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_key_pairs
ec2_describe_key_pairs <- function(Filters = NULL, KeyNames = NULL, KeyPairIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeKeyPairs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_key_pairs_input(Filters = Filters, KeyNames = KeyNames, KeyPairIds = KeyPairIds, DryRun = DryRun)
  output <- .ec2$describe_key_pairs_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_key_pairs <- ec2_describe_key_pairs

#' Describes one or more versions of a specified launch template
#'
#' Describes one or more versions of a specified launch template. You can
#' describe all versions, individual versions, or a range of versions.
#'
#' @usage
#' ec2_describe_launch_template_versions(DryRun, LaunchTemplateId,
#'   LaunchTemplateName, Versions, MinVersion, MaxVersion, NextToken,
#'   MaxResults, Filters)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LaunchTemplateId The ID of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#' @param LaunchTemplateName The name of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#' @param Versions One or more versions of the launch template.
#' @param MinVersion The version number after which to describe launch template versions.
#' @param MaxVersion The version number up to which to describe launch template versions.
#' @param NextToken The token to request the next page of results.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 1 and 200.
#' @param Filters One or more filters.
#' 
#' -   `create-time` - The time the launch template version was created.
#' 
#' -   `ebs-optimized` - A boolean that indicates whether the instance is
#'     optimized for Amazon EBS I/O.
#' 
#' -   `iam-instance-profile` - The ARN of the IAM instance profile.
#' 
#' -   `image-id` - The ID of the AMI.
#' 
#' -   `instance-type` - The instance type.
#' 
#' -   `is-default-version` - A boolean that indicates whether the launch
#'     template version is the default version.
#' 
#' -   `kernel-id` - The kernel ID.
#' 
#' -   `ram-disk-id` - The RAM disk ID.
#'
#' @section Request syntax:
#' ```
#' svc$describe_launch_template_versions(
#'   DryRun = TRUE|FALSE,
#'   LaunchTemplateId = "string",
#'   LaunchTemplateName = "string",
#'   Versions = list(
#'     "string"
#'   ),
#'   MinVersion = "string",
#'   MaxVersion = "string",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example describes the versions for the specified launch template.
#' \dontrun{svc$describe_launch_template_versions(
#'   LaunchTemplateId = "068f72b72934aff71"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_launch_template_versions
ec2_describe_launch_template_versions <- function(DryRun = NULL, LaunchTemplateId = NULL, LaunchTemplateName = NULL, Versions = NULL, MinVersion = NULL, MaxVersion = NULL, NextToken = NULL, MaxResults = NULL, Filters = NULL) {
  op <- new_operation(
    name = "DescribeLaunchTemplateVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_launch_template_versions_input(DryRun = DryRun, LaunchTemplateId = LaunchTemplateId, LaunchTemplateName = LaunchTemplateName, Versions = Versions, MinVersion = MinVersion, MaxVersion = MaxVersion, NextToken = NextToken, MaxResults = MaxResults, Filters = Filters)
  output <- .ec2$describe_launch_template_versions_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_launch_template_versions <- ec2_describe_launch_template_versions

#' Describes one or more launch templates
#'
#' Describes one or more launch templates.
#'
#' @usage
#' ec2_describe_launch_templates(DryRun, LaunchTemplateIds,
#'   LaunchTemplateNames, Filters, NextToken, MaxResults)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LaunchTemplateIds One or more launch template IDs.
#' @param LaunchTemplateNames One or more launch template names.
#' @param Filters One or more filters.
#' 
#' -   `create-time` - The time the launch template was created.
#' 
#' -   `launch-template-name` - The name of the launch template.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param NextToken The token to request the next page of results.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. This value can be between 1 and 200.
#'
#' @section Request syntax:
#' ```
#' svc$describe_launch_templates(
#'   DryRun = TRUE|FALSE,
#'   LaunchTemplateIds = list(
#'     "string"
#'   ),
#'   LaunchTemplateNames = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' # This example describes the specified launch template.
#' \dontrun{svc$describe_launch_templates(
#'   LaunchTemplateIds = list(
#'     "lt-01238c059e3466abc"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_launch_templates
ec2_describe_launch_templates <- function(DryRun = NULL, LaunchTemplateIds = NULL, LaunchTemplateNames = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeLaunchTemplates",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_launch_templates_input(DryRun = DryRun, LaunchTemplateIds = LaunchTemplateIds, LaunchTemplateNames = LaunchTemplateNames, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_launch_templates_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_launch_templates <- ec2_describe_launch_templates

#' Describes the associations between virtual interface groups and local
#' gateway route tables
#'
#' Describes the associations between virtual interface groups and local
#' gateway route tables.
#'
#' @usage
#' ec2_describe_local_gateway_route_table_virtual_interface_group_associations(
#'   LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds, Filters,
#'   MaxResults, NextToken, DryRun)
#'
#' @param LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds The IDs of the associations.
#' @param Filters One or more filters.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_local_gateway_route_table_virtual_interface_group_associations(
#'   LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateway_route_table_virtual_interface_group_associations
ec2_describe_local_gateway_route_table_virtual_interface_group_associations <- function(LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGatewayRouteTableVirtualInterfaceGroupAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_local_gateway_route_table_virtual_interface_group_associations_input(LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds = LocalGatewayRouteTableVirtualInterfaceGroupAssociationIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateway_route_table_virtual_interface_group_associations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateway_route_table_virtual_interface_group_associations <- ec2_describe_local_gateway_route_table_virtual_interface_group_associations

#' Describes the specified associations between VPCs and local gateway
#' route tables
#'
#' Describes the specified associations between VPCs and local gateway
#' route tables.
#'
#' @usage
#' ec2_describe_local_gateway_route_table_vpc_associations(
#'   LocalGatewayRouteTableVpcAssociationIds, Filters, MaxResults, NextToken,
#'   DryRun)
#'
#' @param LocalGatewayRouteTableVpcAssociationIds The IDs of the associations.
#' @param Filters One or more filters.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_local_gateway_route_table_vpc_associations(
#'   LocalGatewayRouteTableVpcAssociationIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateway_route_table_vpc_associations
ec2_describe_local_gateway_route_table_vpc_associations <- function(LocalGatewayRouteTableVpcAssociationIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGatewayRouteTableVpcAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_local_gateway_route_table_vpc_associations_input(LocalGatewayRouteTableVpcAssociationIds = LocalGatewayRouteTableVpcAssociationIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateway_route_table_vpc_associations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateway_route_table_vpc_associations <- ec2_describe_local_gateway_route_table_vpc_associations

#' Describes one or more local gateway route tables
#'
#' Describes one or more local gateway route tables. By default, all local
#' gateway route tables are described. Alternatively, you can filter the
#' results.
#'
#' @usage
#' ec2_describe_local_gateway_route_tables(LocalGatewayRouteTableIds,
#'   Filters, MaxResults, NextToken, DryRun)
#'
#' @param LocalGatewayRouteTableIds The IDs of the local gateway route tables.
#' @param Filters One or more filters.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_local_gateway_route_tables(
#'   LocalGatewayRouteTableIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateway_route_tables
ec2_describe_local_gateway_route_tables <- function(LocalGatewayRouteTableIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGatewayRouteTables",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_local_gateway_route_tables_input(LocalGatewayRouteTableIds = LocalGatewayRouteTableIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateway_route_tables_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateway_route_tables <- ec2_describe_local_gateway_route_tables

#' Describes the specified local gateway virtual interface groups
#'
#' Describes the specified local gateway virtual interface groups.
#'
#' @usage
#' ec2_describe_local_gateway_virtual_interface_groups(
#'   LocalGatewayVirtualInterfaceGroupIds, Filters, MaxResults, NextToken,
#'   DryRun)
#'
#' @param LocalGatewayVirtualInterfaceGroupIds The IDs of the virtual interface groups.
#' @param Filters One or more filters.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_local_gateway_virtual_interface_groups(
#'   LocalGatewayVirtualInterfaceGroupIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateway_virtual_interface_groups
ec2_describe_local_gateway_virtual_interface_groups <- function(LocalGatewayVirtualInterfaceGroupIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGatewayVirtualInterfaceGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_local_gateway_virtual_interface_groups_input(LocalGatewayVirtualInterfaceGroupIds = LocalGatewayVirtualInterfaceGroupIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateway_virtual_interface_groups_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateway_virtual_interface_groups <- ec2_describe_local_gateway_virtual_interface_groups

#' Describes the specified local gateway virtual interfaces
#'
#' Describes the specified local gateway virtual interfaces.
#'
#' @usage
#' ec2_describe_local_gateway_virtual_interfaces(
#'   LocalGatewayVirtualInterfaceIds, Filters, MaxResults, NextToken, DryRun)
#'
#' @param LocalGatewayVirtualInterfaceIds The IDs of the virtual interfaces.
#' @param Filters One or more filters.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_local_gateway_virtual_interfaces(
#'   LocalGatewayVirtualInterfaceIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateway_virtual_interfaces
ec2_describe_local_gateway_virtual_interfaces <- function(LocalGatewayVirtualInterfaceIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGatewayVirtualInterfaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_local_gateway_virtual_interfaces_input(LocalGatewayVirtualInterfaceIds = LocalGatewayVirtualInterfaceIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateway_virtual_interfaces_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateway_virtual_interfaces <- ec2_describe_local_gateway_virtual_interfaces

#' Describes one or more local gateways
#'
#' Describes one or more local gateways. By default, all local gateways are
#' described. Alternatively, you can filter the results.
#'
#' @usage
#' ec2_describe_local_gateways(LocalGatewayIds, Filters, MaxResults,
#'   NextToken, DryRun)
#'
#' @param LocalGatewayIds The IDs of the local gateways.
#' @param Filters One or more filters.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_local_gateways(
#'   LocalGatewayIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_local_gateways
ec2_describe_local_gateways <- function(LocalGatewayIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeLocalGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_local_gateways_input(LocalGatewayIds = LocalGatewayIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_local_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_local_gateways <- ec2_describe_local_gateways

#' Describes your Elastic IP addresses that are being moved to the EC2-VPC
#' platform, or that are being restored to the EC2-Classic platform
#'
#' Describes your Elastic IP addresses that are being moved to the EC2-VPC
#' platform, or that are being restored to the EC2-Classic platform. This
#' request does not return information about any other Elastic IP addresses
#' in your account.
#'
#' @usage
#' ec2_describe_moving_addresses(Filters, DryRun, MaxResults, NextToken,
#'   PublicIps)
#'
#' @param Filters One or more filters.
#' 
#' -   `moving-status` - The status of the Elastic IP address
#'     (`MovingToVpc` \\| `RestoringToClassic`).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results of the initial request can be seen by
#' sending another request with the returned `NextToken` value. This value
#' can be between 5 and 1000; if `MaxResults` is given a value outside of
#' this range, an error is returned.
#' 
#' Default: If no value is provided, the default is 1000.
#' @param NextToken The token for the next page of results.
#' @param PublicIps One or more Elastic IP addresses.
#'
#' @section Request syntax:
#' ```
#' svc$describe_moving_addresses(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string",
#'   PublicIps = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example describes all of your moving Elastic IP addresses.
#' \dontrun{svc$describe_moving_addresses()}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_moving_addresses
ec2_describe_moving_addresses <- function(Filters = NULL, DryRun = NULL, MaxResults = NULL, NextToken = NULL, PublicIps = NULL) {
  op <- new_operation(
    name = "DescribeMovingAddresses",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_moving_addresses_input(Filters = Filters, DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken, PublicIps = PublicIps)
  output <- .ec2$describe_moving_addresses_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_moving_addresses <- ec2_describe_moving_addresses

#' Describes one or more of your NAT gateways
#'
#' Describes one or more of your NAT gateways.
#'
#' @usage
#' ec2_describe_nat_gateways(Filter, MaxResults, NatGatewayIds, NextToken)
#'
#' @param Filter One or more filters.
#' 
#' -   `nat-gateway-id` - The ID of the NAT gateway.
#' 
#' -   `state` - The state of the NAT gateway (`pending` \\| `failed` \\|
#'     `available` \\| `deleting` \\| `deleted`).
#' 
#' -   `subnet-id` - The ID of the subnet in which the NAT gateway resides.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC in which the NAT gateway resides.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NatGatewayIds One or more NAT gateway IDs.
#' @param NextToken The token for the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_nat_gateways(
#'   Filter = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NatGatewayIds = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # This example describes the NAT gateway for the specified VPC.
#' \dontrun{svc$describe_nat_gateways(
#'   Filter = list(
#'     list(
#'       Name = "vpc-id",
#'       Values = list(
#'         "vpc-1a2b3c4d"
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_nat_gateways
ec2_describe_nat_gateways <- function(Filter = NULL, MaxResults = NULL, NatGatewayIds = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeNatGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_nat_gateways_input(Filter = Filter, MaxResults = MaxResults, NatGatewayIds = NatGatewayIds, NextToken = NextToken)
  output <- .ec2$describe_nat_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_nat_gateways <- ec2_describe_nat_gateways

#' Describes one or more of your network ACLs
#'
#' Describes one or more of your network ACLs.
#' 
#' For more information, see [Network
#' ACLs](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_ACLs.html) in
#' the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_describe_network_acls(Filters, DryRun, NetworkAclIds, NextToken,
#'   MaxResults)
#'
#' @param Filters One or more filters.
#' 
#' -   `association.association-id` - The ID of an association ID for the
#'     ACL.
#' 
#' -   `association.network-acl-id` - The ID of the network ACL involved in
#'     the association.
#' 
#' -   `association.subnet-id` - The ID of the subnet involved in the
#'     association.
#' 
#' -   `default` - Indicates whether the ACL is the default network ACL for
#'     the VPC.
#' 
#' -   `entry.cidr` - The IPv4 CIDR range specified in the entry.
#' 
#' -   `entry.icmp.code` - The ICMP code specified in the entry, if any.
#' 
#' -   `entry.icmp.type` - The ICMP type specified in the entry, if any.
#' 
#' -   `entry.ipv6-cidr` - The IPv6 CIDR range specified in the entry.
#' 
#' -   `entry.port-range.from` - The start of the port range specified in
#'     the entry.
#' 
#' -   `entry.port-range.to` - The end of the port range specified in the
#'     entry.
#' 
#' -   `entry.protocol` - The protocol specified in the entry (`tcp` \\|
#'     `udp` \\| `icmp` or a protocol number).
#' 
#' -   `entry.rule-action` - Allows or denies the matching traffic (`allow`
#'     \\| `deny`).
#' 
#' -   `entry.rule-number` - The number of an entry (in other words, rule)
#'     in the set of ACL entries.
#' 
#' -   `network-acl-id` - The ID of the network ACL.
#' 
#' -   `owner-id` - The ID of the AWS account that owns the network ACL.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC for the network ACL.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkAclIds One or more network ACL IDs.
#' 
#' Default: Describes all your network ACLs.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @section Request syntax:
#' ```
#' svc$describe_network_acls(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   NetworkAclIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' # This example describes the specified network ACL.
#' \dontrun{svc$describe_network_acls(
#'   NetworkAclIds = list(
#'     "acl-5fb85d36"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_acls
ec2_describe_network_acls <- function(Filters = NULL, DryRun = NULL, NetworkAclIds = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeNetworkAcls",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_network_acls_input(Filters = Filters, DryRun = DryRun, NetworkAclIds = NetworkAclIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_network_acls_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_acls <- ec2_describe_network_acls

#' Describes a network interface attribute
#'
#' Describes a network interface attribute. You can specify only one
#' attribute at a time.
#'
#' @usage
#' ec2_describe_network_interface_attribute(Attribute, DryRun,
#'   NetworkInterfaceId)
#'
#' @param Attribute The attribute of the network interface. This parameter is required.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#'
#' @section Request syntax:
#' ```
#' svc$describe_network_interface_attribute(
#'   Attribute = "description"|"groupSet"|"sourceDestCheck"|"attachment",
#'   DryRun = TRUE|FALSE,
#'   NetworkInterfaceId = "string"
#' )
#' ```
#'
#' @examples
#' # This example describes the attachment attribute of the specified network
#' # interface.
#' \dontrun{svc$describe_network_interface_attribute(
#'   Attribute = "attachment",
#'   NetworkInterfaceId = "eni-686ea200"
#' )}
#' 
#' # This example describes the description attribute of the specified
#' # network interface.
#' \dontrun{svc$describe_network_interface_attribute(
#'   Attribute = "description",
#'   NetworkInterfaceId = "eni-686ea200"
#' )}
#' 
#' # This example describes the groupSet attribute of the specified network
#' # interface.
#' \dontrun{svc$describe_network_interface_attribute(
#'   Attribute = "groupSet",
#'   NetworkInterfaceId = "eni-686ea200"
#' )}
#' 
#' # This example describes the sourceDestCheck attribute of the specified
#' # network interface.
#' \dontrun{svc$describe_network_interface_attribute(
#'   Attribute = "sourceDestCheck",
#'   NetworkInterfaceId = "eni-686ea200"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_interface_attribute
ec2_describe_network_interface_attribute <- function(Attribute = NULL, DryRun = NULL, NetworkInterfaceId) {
  op <- new_operation(
    name = "DescribeNetworkInterfaceAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_network_interface_attribute_input(Attribute = Attribute, DryRun = DryRun, NetworkInterfaceId = NetworkInterfaceId)
  output <- .ec2$describe_network_interface_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_interface_attribute <- ec2_describe_network_interface_attribute

#' Describes the permissions for your network interfaces
#'
#' Describes the permissions for your network interfaces.
#'
#' @usage
#' ec2_describe_network_interface_permissions(
#'   NetworkInterfacePermissionIds, Filters, NextToken, MaxResults)
#'
#' @param NetworkInterfacePermissionIds One or more network interface permission IDs.
#' @param Filters One or more filters.
#' 
#' -   `network-interface-permission.network-interface-permission-id` - The
#'     ID of the permission.
#' 
#' -   `network-interface-permission.network-interface-id` - The ID of the
#'     network interface.
#' 
#' -   `network-interface-permission.aws-account-id` - The AWS account ID.
#' 
#' -   `network-interface-permission.aws-service` - The AWS service.
#' 
#' -   `network-interface-permission.permission` - The type of permission
#'     (`INSTANCE-ATTACH` \\| `EIP-ASSOCIATE`).
#' @param NextToken The token to request the next page of results.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned `NextToken`
#' value. If this parameter is not specified, up to 50 results are returned
#' by default.
#'
#' @section Request syntax:
#' ```
#' svc$describe_network_interface_permissions(
#'   NetworkInterfacePermissionIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_interface_permissions
ec2_describe_network_interface_permissions <- function(NetworkInterfacePermissionIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeNetworkInterfacePermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_network_interface_permissions_input(NetworkInterfacePermissionIds = NetworkInterfacePermissionIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_network_interface_permissions_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_interface_permissions <- ec2_describe_network_interface_permissions

#' Describes one or more of your network interfaces
#'
#' Describes one or more of your network interfaces.
#'
#' @usage
#' ec2_describe_network_interfaces(Filters, DryRun, NetworkInterfaceIds,
#'   NextToken, MaxResults)
#'
#' @param Filters One or more filters.
#' 
#' -   `addresses.private-ip-address` - The private IPv4 addresses
#'     associated with the network interface.
#' 
#' -   `addresses.primary` - Whether the private IPv4 address is the
#'     primary IP address associated with the network interface.
#' 
#' -   `addresses.association.public-ip` - The association ID returned when
#'     the network interface was associated with the Elastic IP address
#'     (IPv4).
#' 
#' -   `addresses.association.owner-id` - The owner ID of the addresses
#'     associated with the network interface.
#' 
#' -   `association.association-id` - The association ID returned when the
#'     network interface was associated with an IPv4 address.
#' 
#' -   `association.allocation-id` - The allocation ID returned when you
#'     allocated the Elastic IP address (IPv4) for your network interface.
#' 
#' -   `association.ip-owner-id` - The owner of the Elastic IP address
#'     (IPv4) associated with the network interface.
#' 
#' -   `association.public-ip` - The address of the Elastic IP address
#'     (IPv4) bound to the network interface.
#' 
#' -   `association.public-dns-name` - The public DNS name for the network
#'     interface (IPv4).
#' 
#' -   `attachment.attachment-id` - The ID of the interface attachment.
#' 
#' -   `attachment.attach-time` - The time that the network interface was
#'     attached to an instance.
#' 
#' -   `attachment.delete-on-termination` - Indicates whether the
#'     attachment is deleted when an instance is terminated.
#' 
#' -   `attachment.device-index` - The device index to which the network
#'     interface is attached.
#' 
#' -   `attachment.instance-id` - The ID of the instance to which the
#'     network interface is attached.
#' 
#' -   `attachment.instance-owner-id` - The owner ID of the instance to
#'     which the network interface is attached.
#' 
#' -   `attachment.nat-gateway-id` - The ID of the NAT gateway to which the
#'     network interface is attached.
#' 
#' -   `attachment.status` - The status of the attachment (`attaching` \\|
#'     `attached` \\| `detaching` \\| `detached`).
#' 
#' -   `availability-zone` - The Availability Zone of the network
#'     interface.
#' 
#' -   `description` - The description of the network interface.
#' 
#' -   `group-id` - The ID of a security group associated with the network
#'     interface.
#' 
#' -   `group-name` - The name of a security group associated with the
#'     network interface.
#' 
#' -   `ipv6-addresses.ipv6-address` - An IPv6 address associated with the
#'     network interface.
#' 
#' -   `mac-address` - The MAC address of the network interface.
#' 
#' -   `network-interface-id` - The ID of the network interface.
#' 
#' -   `owner-id` - The AWS account ID of the network interface owner.
#' 
#' -   `private-ip-address` - The private IPv4 address or addresses of the
#'     network interface.
#' 
#' -   `private-dns-name` - The private DNS name of the network interface
#'     (IPv4).
#' 
#' -   `requester-id` - The ID of the entity that launched the instance on
#'     your behalf (for example, AWS Management Console, Auto Scaling, and
#'     so on).
#' 
#' -   `requester-managed` - Indicates whether the network interface is
#'     being managed by an AWS service (for example, AWS Management
#'     Console, Auto Scaling, and so on).
#' 
#' -   `source-dest-check` - Indicates whether the network interface
#'     performs source/destination checking. A value of `true` means
#'     checking is enabled, and `false` means checking is disabled. The
#'     value must be `false` for the network interface to perform network
#'     address translation (NAT) in your VPC.
#' 
#' -   `status` - The status of the network interface. If the network
#'     interface is not attached to an instance, the status is `available`;
#'     if a network interface is attached to an instance the status is
#'     `in-use`.
#' 
#' -   `subnet-id` - The ID of the subnet for the network interface.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC for the network interface.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NetworkInterfaceIds One or more network interface IDs.
#' 
#' Default: Describes all your network interfaces.
#' @param NextToken The token to retrieve the next page of results.
#' @param MaxResults The maximum number of items to return for this request. The request
#' returns a token that you can specify in a subsequent call to get the
#' next set of results. You cannot specify this parameter and the network
#' interface IDs parameter in the same request.
#'
#' @section Request syntax:
#' ```
#' svc$describe_network_interfaces(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   NetworkInterfaceIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' # 
#' \dontrun{svc$describe_network_interfaces(
#'   NetworkInterfaceIds = list(
#'     "eni-e5aa89a3"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_network_interfaces
ec2_describe_network_interfaces <- function(Filters = NULL, DryRun = NULL, NetworkInterfaceIds = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeNetworkInterfaces",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_network_interfaces_input(Filters = Filters, DryRun = DryRun, NetworkInterfaceIds = NetworkInterfaceIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_network_interfaces_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_network_interfaces <- ec2_describe_network_interfaces

#' Describes the specified placement groups or all of your placement groups
#'
#' Describes the specified placement groups or all of your placement
#' groups. For more information, see [Placement
#' Groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_placement_groups(Filters, DryRun, GroupNames, GroupIds)
#'
#' @param Filters The filters.
#' 
#' -   `group-name` - The name of the placement group.
#' 
#' -   `state` - The state of the placement group (`pending` \\| `available`
#'     \\| `deleting` \\| `deleted`).
#' 
#' -   `strategy` - The strategy of the placement group (`cluster` \\|
#'     `spread` \\| `partition`).
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param GroupNames The names of the placement groups.
#' 
#' Default: Describes all your placement groups, or only those otherwise
#' specified.
#' @param GroupIds The IDs of the placement groups.
#'
#' @section Request syntax:
#' ```
#' svc$describe_placement_groups(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   GroupNames = list(
#'     "string"
#'   ),
#'   GroupIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_placement_groups
ec2_describe_placement_groups <- function(Filters = NULL, DryRun = NULL, GroupNames = NULL, GroupIds = NULL) {
  op <- new_operation(
    name = "DescribePlacementGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_placement_groups_input(Filters = Filters, DryRun = DryRun, GroupNames = GroupNames, GroupIds = GroupIds)
  output <- .ec2$describe_placement_groups_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_placement_groups <- ec2_describe_placement_groups

#' Describes available AWS services in a prefix list format, which includes
#' the prefix list name and prefix list ID of the service and the IP
#' address range for the service
#'
#' Describes available AWS services in a prefix list format, which includes
#' the prefix list name and prefix list ID of the service and the IP
#' address range for the service. A prefix list ID is required for creating
#' an outbound security group rule that allows traffic from a VPC to access
#' an AWS service through a gateway VPC endpoint. Currently, the services
#' that support this action are Amazon S3 and Amazon DynamoDB.
#'
#' @usage
#' ec2_describe_prefix_lists(DryRun, Filters, MaxResults, NextToken,
#'   PrefixListIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters.
#' 
#' -   `prefix-list-id`: The ID of a prefix list.
#' 
#' -   `prefix-list-name`: The name of a prefix list.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param PrefixListIds One or more prefix list IDs.
#'
#' @section Request syntax:
#' ```
#' svc$describe_prefix_lists(
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   PrefixListIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_prefix_lists
ec2_describe_prefix_lists <- function(DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, PrefixListIds = NULL) {
  op <- new_operation(
    name = "DescribePrefixLists",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_prefix_lists_input(DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, PrefixListIds = PrefixListIds)
  output <- .ec2$describe_prefix_lists_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_prefix_lists <- ec2_describe_prefix_lists

#' Describes the ID format settings for the root user and all IAM roles and
#' IAM users that have explicitly specified a longer ID (17-character ID)
#' preference
#'
#' Describes the ID format settings for the root user and all IAM roles and
#' IAM users that have explicitly specified a longer ID (17-character ID)
#' preference.
#' 
#' By default, all IAM roles and IAM users default to the same ID settings
#' as the root user, unless they explicitly override the settings. This
#' request is useful for identifying those IAM users and IAM roles that
#' have overridden the default ID settings.
#' 
#' The following resource types support longer IDs: `bundle` \\|
#' `conversion-task` \\| `customer-gateway` \\| `dhcp-options` \\|
#' `elastic-ip-allocation` \\| `elastic-ip-association` \\| `export-task` \\|
#' `flow-log` \\| `image` \\| `import-task` \\| `instance` \\|
#' `internet-gateway` \\| `network-acl` \\| `network-acl-association` \\|
#' `network-interface` \\| `network-interface-attachment` \\| `prefix-list`
#' \\| `reservation` \\| `route-table` \\| `route-table-association` \\|
#' `security-group` \\| `snapshot` \\| `subnet` \\|
#' `subnet-cidr-block-association` \\| `volume` \\| `vpc` \\|
#' `vpc-cidr-block-association` \\| `vpc-endpoint` \\|
#' `vpc-peering-connection` \\| `vpn-connection` \\| `vpn-gateway`.
#'
#' @usage
#' ec2_describe_principal_id_format(DryRun, Resources, MaxResults,
#'   NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Resources The type of resource: `bundle` \\| `conversion-task` \\|
#' `customer-gateway` \\| `dhcp-options` \\| `elastic-ip-allocation` \\|
#' `elastic-ip-association` \\| `export-task` \\| `flow-log` \\| `image` \\|
#' `import-task` \\| `instance` \\| `internet-gateway` \\| `network-acl` \\|
#' `network-acl-association` \\| `network-interface` \\|
#' `network-interface-attachment` \\| `prefix-list` \\| `reservation` \\|
#' `route-table` \\| `route-table-association` \\| `security-group` \\|
#' `snapshot` \\| `subnet` \\| `subnet-cidr-block-association` \\| `volume` \\|
#' `vpc` \\| `vpc-cidr-block-association` \\| `vpc-endpoint` \\|
#' `vpc-peering-connection` \\| `vpn-connection` \\| `vpn-gateway`
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another call with the returned NextToken
#' value.
#' @param NextToken The token to request the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_principal_id_format(
#'   DryRun = TRUE|FALSE,
#'   Resources = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_principal_id_format
ec2_describe_principal_id_format <- function(DryRun = NULL, Resources = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribePrincipalIdFormat",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_principal_id_format_input(DryRun = DryRun, Resources = Resources, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_principal_id_format_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_principal_id_format <- ec2_describe_principal_id_format

#' Describes the specified IPv4 address pools
#'
#' Describes the specified IPv4 address pools.
#'
#' @usage
#' ec2_describe_public_ipv_4_pools(PoolIds, NextToken, MaxResults)
#'
#' @param PoolIds The IDs of the address pools.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @section Request syntax:
#' ```
#' svc$describe_public_ipv_4_pools(
#'   PoolIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_public_ipv_4_pools
ec2_describe_public_ipv_4_pools <- function(PoolIds = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribePublicIpv4Pools",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_public_ipv_4_pools_input(PoolIds = PoolIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_public_ipv_4_pools_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_public_ipv_4_pools <- ec2_describe_public_ipv_4_pools

#' Describes the Regions that are enabled for your account, or all Regions
#'
#' Describes the Regions that are enabled for your account, or all Regions.
#' 
#' For a list of the Regions supported by Amazon EC2, see [Regions and
#' Endpoints](https://docs.aws.amazon.com/general/latest/gr/rande.html#ec2_region).
#' 
#' For information about enabling and disabling Regions for your account,
#' see [Managing AWS
#' Regions](https://docs.aws.amazon.com/general/latest/gr/rande-manage.html)
#' in the *AWS General Reference*.
#'
#' @usage
#' ec2_describe_regions(Filters, RegionNames, DryRun, AllRegions)
#'
#' @param Filters The filters.
#' 
#' -   `endpoint` - The endpoint of the Region (for example,
#'     `ec2.us-east-1.amazonaws.com`).
#' 
#' -   `opt-in-status` - The opt-in status of the Region
#'     (`opt-in-not-required` \\| `opted-in` \\| `not-opted-in`).
#' 
#' -   `region-name` - The name of the Region (for example, `us-east-1`).
#' @param RegionNames The names of the Regions. You can specify any Regions, whether they are
#' enabled and disabled for your account.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param AllRegions Indicates whether to display all Regions, including Regions that are
#' disabled for your account.
#'
#' @section Request syntax:
#' ```
#' svc$describe_regions(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   RegionNames = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   AllRegions = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example describes all the regions that are available to you.
#' \dontrun{svc$describe_regions()}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_regions
ec2_describe_regions <- function(Filters = NULL, RegionNames = NULL, DryRun = NULL, AllRegions = NULL) {
  op <- new_operation(
    name = "DescribeRegions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_regions_input(Filters = Filters, RegionNames = RegionNames, DryRun = DryRun, AllRegions = AllRegions)
  output <- .ec2$describe_regions_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_regions <- ec2_describe_regions

#' Describes one or more of the Reserved Instances that you purchased
#'
#' Describes one or more of the Reserved Instances that you purchased.
#' 
#' For more information about Reserved Instances, see [Reserved
#' Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/concepts-on-demand-reserved-instances.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_reserved_instances(Filters, OfferingClass,
#'   ReservedInstancesIds, DryRun, OfferingType)
#'
#' @param Filters One or more filters.
#' 
#' -   `availability-zone` - The Availability Zone where the Reserved
#'     Instance can be used.
#' 
#' -   `duration` - The duration of the Reserved Instance (one year or
#'     three years), in seconds (`31536000` \\| `94608000`).
#' 
#' -   `end` - The time when the Reserved Instance expires (for example,
#'     2015-08-07T11:54:42.000Z).
#' 
#' -   `fixed-price` - The purchase price of the Reserved Instance (for
#'     example, 9800.0).
#' 
#' -   `instance-type` - The instance type that is covered by the
#'     reservation.
#' 
#' -   `scope` - The scope of the Reserved Instance (`Region` or
#'     `Availability Zone`).
#' 
#' -   `product-description` - The Reserved Instance product platform
#'     description. Instances that include `(Amazon VPC)` in the product
#'     platform description will only be displayed to EC2-Classic account
#'     holders and are for use with Amazon VPC (`Linux/UNIX` \\|
#'     `Linux/UNIX (Amazon VPC)` \\| `SUSE Linux` \\|
#'     `SUSE Linux (Amazon VPC)` \\| `Red Hat Enterprise Linux` \\|
#'     `Red Hat Enterprise Linux (Amazon VPC)` \\| `Windows` \\|
#'     `Windows (Amazon VPC)` \\| `Windows with SQL Server Standard` \\|
#'     `Windows with SQL Server Standard (Amazon VPC)` \\|
#'     `Windows with SQL Server Web` \\|
#'     `Windows with SQL Server Web (Amazon VPC)` \\|
#'     `Windows with SQL Server Enterprise` \\|
#'     `Windows with SQL Server Enterprise (Amazon VPC)`).
#' 
#' -   `reserved-instances-id` - The ID of the Reserved Instance.
#' 
#' -   `start` - The time at which the Reserved Instance purchase request
#'     was placed (for example, 2014-08-07T11:54:42.000Z).
#' 
#' -   `state` - The state of the Reserved Instance (`payment-pending` \\|
#'     `active` \\| `payment-failed` \\| `retired`).
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `usage-price` - The usage price of the Reserved Instance, per hour
#'     (for example, 0.84).
#' @param OfferingClass Describes whether the Reserved Instance is Standard or Convertible.
#' @param ReservedInstancesIds One or more Reserved Instance IDs.
#' 
#' Default: Describes all your Reserved Instances, or only those otherwise
#' specified.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param OfferingType The Reserved Instance offering type. If you are using tools that predate
#' the 2011-11-01 API version, you only have access to the
#' `Medium Utilization` Reserved Instance offering type.
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_instances(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   OfferingClass = "standard"|"convertible",
#'   ReservedInstancesIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   OfferingType = "Heavy Utilization"|"Medium Utilization"|"Light Utilization"|"No Upfront"|"Partial Upfront"|"All Upfront"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_reserved_instances
ec2_describe_reserved_instances <- function(Filters = NULL, OfferingClass = NULL, ReservedInstancesIds = NULL, DryRun = NULL, OfferingType = NULL) {
  op <- new_operation(
    name = "DescribeReservedInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_reserved_instances_input(Filters = Filters, OfferingClass = OfferingClass, ReservedInstancesIds = ReservedInstancesIds, DryRun = DryRun, OfferingType = OfferingType)
  output <- .ec2$describe_reserved_instances_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_reserved_instances <- ec2_describe_reserved_instances

#' Describes your account's Reserved Instance listings in the Reserved
#' Instance Marketplace
#'
#' Describes your account\'s Reserved Instance listings in the Reserved
#' Instance Marketplace.
#' 
#' The Reserved Instance Marketplace matches sellers who want to resell
#' Reserved Instance capacity that they no longer need with buyers who want
#' to purchase additional capacity. Reserved Instances bought and sold
#' through the Reserved Instance Marketplace work like any other Reserved
#' Instances.
#' 
#' As a seller, you choose to list some or all of your Reserved Instances,
#' and you specify the upfront price to receive for them. Your Reserved
#' Instances are then listed in the Reserved Instance Marketplace and are
#' available for purchase.
#' 
#' As a buyer, you specify the configuration of the Reserved Instance to
#' purchase, and the Marketplace matches what you\'re searching for with
#' what\'s available. The Marketplace first sells the lowest priced
#' Reserved Instances to you, and continues to sell available Reserved
#' Instance listings to you until your demand is met. You are charged based
#' on the total price of all of the listings that you purchase.
#' 
#' For more information, see [Reserved Instance
#' Marketplace](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_reserved_instances_listings(Filters, ReservedInstancesId,
#'   ReservedInstancesListingId)
#'
#' @param Filters One or more filters.
#' 
#' -   `reserved-instances-id` - The ID of the Reserved Instances.
#' 
#' -   `reserved-instances-listing-id` - The ID of the Reserved Instances
#'     listing.
#' 
#' -   `status` - The status of the Reserved Instance listing (`pending` \\|
#'     `active` \\| `cancelled` \\| `closed`).
#' 
#' -   `status-message` - The reason for the status.
#' @param ReservedInstancesId One or more Reserved Instance IDs.
#' @param ReservedInstancesListingId One or more Reserved Instance listing IDs.
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_instances_listings(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ReservedInstancesId = "string",
#'   ReservedInstancesListingId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_reserved_instances_listings
ec2_describe_reserved_instances_listings <- function(Filters = NULL, ReservedInstancesId = NULL, ReservedInstancesListingId = NULL) {
  op <- new_operation(
    name = "DescribeReservedInstancesListings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_reserved_instances_listings_input(Filters = Filters, ReservedInstancesId = ReservedInstancesId, ReservedInstancesListingId = ReservedInstancesListingId)
  output <- .ec2$describe_reserved_instances_listings_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_reserved_instances_listings <- ec2_describe_reserved_instances_listings

#' Describes the modifications made to your Reserved Instances
#'
#' Describes the modifications made to your Reserved Instances. If no
#' parameter is specified, information about all your Reserved Instances
#' modification requests is returned. If a modification ID is specified,
#' only information about the specific modification is returned.
#' 
#' For more information, see [Modifying Reserved
#' Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html)
#' in the Amazon Elastic Compute Cloud User Guide.
#'
#' @usage
#' ec2_describe_reserved_instances_modifications(Filters,
#'   ReservedInstancesModificationIds, NextToken)
#'
#' @param Filters One or more filters.
#' 
#' -   `client-token` - The idempotency token for the modification request.
#' 
#' -   `create-date` - The time when the modification request was created.
#' 
#' -   `effective-date` - The time when the modification becomes effective.
#' 
#' -   `modification-result.reserved-instances-id` - The ID for the
#'     Reserved Instances created as part of the modification request. This
#'     ID is only available when the status of the modification is
#'     `fulfilled`.
#' 
#' -   `modification-result.target-configuration.availability-zone` - The
#'     Availability Zone for the new Reserved Instances.
#' 
#' -   `modification-result.target-configuration.instance-count ` - The
#'     number of new Reserved Instances.
#' 
#' -   `modification-result.target-configuration.instance-type` - The
#'     instance type of the new Reserved Instances.
#' 
#' -   `modification-result.target-configuration.platform` - The network
#'     platform of the new Reserved Instances (`EC2-Classic` \\| `EC2-VPC`).
#' 
#' -   `reserved-instances-id` - The ID of the Reserved Instances modified.
#' 
#' -   `reserved-instances-modification-id` - The ID of the modification
#'     request.
#' 
#' -   `status` - The status of the Reserved Instances modification request
#'     (`processing` \\| `fulfilled` \\| `failed`).
#' 
#' -   `status-message` - The reason for the status.
#' 
#' -   `update-date` - The time when the modification request was last
#'     updated.
#' @param ReservedInstancesModificationIds IDs for the submitted modification request.
#' @param NextToken The token to retrieve the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_instances_modifications(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   ReservedInstancesModificationIds = list(
#'     "string"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_reserved_instances_modifications
ec2_describe_reserved_instances_modifications <- function(Filters = NULL, ReservedInstancesModificationIds = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeReservedInstancesModifications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_reserved_instances_modifications_input(Filters = Filters, ReservedInstancesModificationIds = ReservedInstancesModificationIds, NextToken = NextToken)
  output <- .ec2$describe_reserved_instances_modifications_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_reserved_instances_modifications <- ec2_describe_reserved_instances_modifications

#' Describes Reserved Instance offerings that are available for purchase
#'
#' Describes Reserved Instance offerings that are available for purchase.
#' With Reserved Instances, you purchase the right to launch instances for
#' a period of time. During that time period, you do not receive
#' insufficient capacity errors, and you pay a lower usage rate than the
#' rate charged for On-Demand instances for the actual time used.
#' 
#' If you have listed your own Reserved Instances for sale in the Reserved
#' Instance Marketplace, they will be excluded from these results. This is
#' to ensure that you do not purchase your own Reserved Instances.
#' 
#' For more information, see [Reserved Instance
#' Marketplace](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-market-general.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_reserved_instances_offerings(AvailabilityZone, Filters,
#'   IncludeMarketplace, InstanceType, MaxDuration, MaxInstanceCount,
#'   MinDuration, OfferingClass, ProductDescription,
#'   ReservedInstancesOfferingIds, DryRun, InstanceTenancy, MaxResults,
#'   NextToken, OfferingType)
#'
#' @param AvailabilityZone The Availability Zone in which the Reserved Instance can be used.
#' @param Filters One or more filters.
#' 
#' -   `availability-zone` - The Availability Zone where the Reserved
#'     Instance can be used.
#' 
#' -   `duration` - The duration of the Reserved Instance (for example, one
#'     year or three years), in seconds (`31536000` \\| `94608000`).
#' 
#' -   `fixed-price` - The purchase price of the Reserved Instance (for
#'     example, 9800.0).
#' 
#' -   `instance-type` - The instance type that is covered by the
#'     reservation.
#' 
#' -   `marketplace` - Set to `true` to show only Reserved Instance
#'     Marketplace offerings. When this filter is not used, which is the
#'     default behavior, all offerings from both AWS and the Reserved
#'     Instance Marketplace are listed.
#' 
#' -   `product-description` - The Reserved Instance product platform
#'     description. Instances that include `(Amazon VPC)` in the product
#'     platform description will only be displayed to EC2-Classic account
#'     holders and are for use with Amazon VPC. (`Linux/UNIX` \\|
#'     `Linux/UNIX (Amazon VPC)` \\| `SUSE Linux` \\|
#'     `SUSE Linux (Amazon VPC)` \\| `Red Hat Enterprise Linux` \\|
#'     `Red Hat Enterprise Linux (Amazon VPC)` \\| `Windows` \\|
#'     `Windows (Amazon VPC)` \\| `Windows with SQL Server Standard` \\|
#'     `Windows with SQL Server Standard (Amazon VPC)` \\|
#'     `Windows with SQL Server Web` \\|
#'     ` Windows with SQL Server Web (Amazon VPC)` \\|
#'     `Windows with SQL Server Enterprise` \\|
#'     `Windows with SQL Server Enterprise (Amazon VPC)`)
#' 
#' -   `reserved-instances-offering-id` - The Reserved Instances offering
#'     ID.
#' 
#' -   `scope` - The scope of the Reserved Instance (`Availability Zone` or
#'     `Region`).
#' 
#' -   `usage-price` - The usage price of the Reserved Instance, per hour
#'     (for example, 0.84).
#' @param IncludeMarketplace Include Reserved Instance Marketplace offerings in the response.
#' @param InstanceType The instance type that the reservation will cover (for example,
#' `m1.small`). For more information, see [Instance
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param MaxDuration The maximum duration (in seconds) to filter when searching for
#' offerings.
#' 
#' Default: 94608000 (3 years)
#' @param MaxInstanceCount The maximum number of instances to filter when searching for offerings.
#' 
#' Default: 20
#' @param MinDuration The minimum duration (in seconds) to filter when searching for
#' offerings.
#' 
#' Default: 2592000 (1 month)
#' @param OfferingClass The offering class of the Reserved Instance. Can be `standard` or
#' `convertible`.
#' @param ProductDescription The Reserved Instance product platform description. Instances that
#' include `(Amazon VPC)` in the description are for use with Amazon VPC.
#' @param ReservedInstancesOfferingIds One or more Reserved Instances offering IDs.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceTenancy The tenancy of the instances covered by the reservation. A Reserved
#' Instance with a tenancy of `dedicated` is applied to instances that run
#' in a VPC on single-tenant hardware (i.e., Dedicated Instances).
#' 
#' **Important:** The `host` value cannot be used with this parameter. Use
#' the `default` or `dedicated` values only.
#' 
#' Default: `default`
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results of the initial request can be seen by
#' sending another request with the returned `NextToken` value. The maximum
#' is 100.
#' 
#' Default: 100
#' @param NextToken The token to retrieve the next page of results.
#' @param OfferingType The Reserved Instance offering type. If you are using tools that predate
#' the 2011-11-01 API version, you only have access to the
#' `Medium Utilization` Reserved Instance offering type.
#'
#' @section Request syntax:
#' ```
#' svc$describe_reserved_instances_offerings(
#'   AvailabilityZone = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   IncludeMarketplace = TRUE|FALSE,
#'   InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge",
#'   MaxDuration = 123,
#'   MaxInstanceCount = 123,
#'   MinDuration = 123,
#'   OfferingClass = "standard"|"convertible",
#'   ProductDescription = "Linux/UNIX"|"Linux/UNIX (Amazon VPC)"|"Windows"|"Windows (Amazon VPC)",
#'   ReservedInstancesOfferingIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   InstanceTenancy = "default"|"dedicated"|"host",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   OfferingType = "Heavy Utilization"|"Medium Utilization"|"Light Utilization"|"No Upfront"|"Partial Upfront"|"All Upfront"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_reserved_instances_offerings
ec2_describe_reserved_instances_offerings <- function(AvailabilityZone = NULL, Filters = NULL, IncludeMarketplace = NULL, InstanceType = NULL, MaxDuration = NULL, MaxInstanceCount = NULL, MinDuration = NULL, OfferingClass = NULL, ProductDescription = NULL, ReservedInstancesOfferingIds = NULL, DryRun = NULL, InstanceTenancy = NULL, MaxResults = NULL, NextToken = NULL, OfferingType = NULL) {
  op <- new_operation(
    name = "DescribeReservedInstancesOfferings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_reserved_instances_offerings_input(AvailabilityZone = AvailabilityZone, Filters = Filters, IncludeMarketplace = IncludeMarketplace, InstanceType = InstanceType, MaxDuration = MaxDuration, MaxInstanceCount = MaxInstanceCount, MinDuration = MinDuration, OfferingClass = OfferingClass, ProductDescription = ProductDescription, ReservedInstancesOfferingIds = ReservedInstancesOfferingIds, DryRun = DryRun, InstanceTenancy = InstanceTenancy, MaxResults = MaxResults, NextToken = NextToken, OfferingType = OfferingType)
  output <- .ec2$describe_reserved_instances_offerings_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_reserved_instances_offerings <- ec2_describe_reserved_instances_offerings

#' Describes one or more of your route tables
#'
#' Describes one or more of your route tables.
#' 
#' Each subnet in your VPC must be associated with a route table. If a
#' subnet is not explicitly associated with any route table, it is
#' implicitly associated with the main route table. This command does not
#' return the subnet ID for implicit associations.
#' 
#' For more information, see [Route
#' Tables](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_describe_route_tables(Filters, DryRun, RouteTableIds, NextToken,
#'   MaxResults)
#'
#' @param Filters One or more filters.
#' 
#' -   `association.route-table-association-id` - The ID of an association
#'     ID for the route table.
#' 
#' -   `association.route-table-id` - The ID of the route table involved in
#'     the association.
#' 
#' -   `association.subnet-id` - The ID of the subnet involved in the
#'     association.
#' 
#' -   `association.main` - Indicates whether the route table is the main
#'     route table for the VPC (`true` \\| `false`). Route tables that do
#'     not have an association ID are not returned in the response.
#' 
#' -   `owner-id` - The ID of the AWS account that owns the route table.
#' 
#' -   `route-table-id` - The ID of the route table.
#' 
#' -   `route.destination-cidr-block` - The IPv4 CIDR range specified in a
#'     route in the table.
#' 
#' -   `route.destination-ipv6-cidr-block` - The IPv6 CIDR range specified
#'     in a route in the route table.
#' 
#' -   `route.destination-prefix-list-id` - The ID (prefix) of the AWS
#'     service specified in a route in the table.
#' 
#' -   `route.egress-only-internet-gateway-id` - The ID of an egress-only
#'     Internet gateway specified in a route in the route table.
#' 
#' -   `route.gateway-id` - The ID of a gateway specified in a route in the
#'     table.
#' 
#' -   `route.instance-id` - The ID of an instance specified in a route in
#'     the table.
#' 
#' -   `route.nat-gateway-id` - The ID of a NAT gateway.
#' 
#' -   `route.transit-gateway-id` - The ID of a transit gateway.
#' 
#' -   `route.origin` - Describes how the route was created.
#'     `CreateRouteTable` indicates that the route was automatically
#'     created when the route table was created; `CreateRoute` indicates
#'     that the route was manually added to the route table;
#'     `EnableVgwRoutePropagation` indicates that the route was propagated
#'     by route propagation.
#' 
#' -   `route.state` - The state of a route in the route table (`active` \\|
#'     `blackhole`). The blackhole state indicates that the route\'s target
#'     isn\'t available (for example, the specified gateway isn\'t attached
#'     to the VPC, the specified NAT instance has been terminated, and so
#'     on).
#' 
#' -   `route.vpc-peering-connection-id` - The ID of a VPC peering
#'     connection specified in a route in the table.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `transit-gateway-id` - The ID of a transit gateway.
#' 
#' -   `vpc-id` - The ID of the VPC for the route table.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param RouteTableIds One or more route table IDs.
#' 
#' Default: Describes all your route tables.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @section Request syntax:
#' ```
#' svc$describe_route_tables(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   RouteTableIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' # This example describes the specified route table.
#' \dontrun{svc$describe_route_tables(
#'   RouteTableIds = list(
#'     "rtb-1f382e7d"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_route_tables
ec2_describe_route_tables <- function(Filters = NULL, DryRun = NULL, RouteTableIds = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeRouteTables",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_route_tables_input(Filters = Filters, DryRun = DryRun, RouteTableIds = RouteTableIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_route_tables_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_route_tables <- ec2_describe_route_tables

#' Finds available schedules that meet the specified criteria
#'
#' Finds available schedules that meet the specified criteria.
#' 
#' You can search for an available schedule no more than 3 months in
#' advance. You must meet the minimum required duration of 1,200 hours per
#' year. For example, the minimum daily schedule is 4 hours, the minimum
#' weekly schedule is 24 hours, and the minimum monthly schedule is 100
#' hours.
#' 
#' After you find a schedule that meets your needs, call
#' PurchaseScheduledInstances to purchase Scheduled Instances with that
#' schedule.
#'
#' @usage
#' ec2_describe_scheduled_instance_availability(DryRun, Filters,
#'   FirstSlotStartTimeRange, MaxResults, MaxSlotDurationInHours,
#'   MinSlotDurationInHours, NextToken, Recurrence)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `availability-zone` - The Availability Zone (for example,
#'     `us-west-2a`).
#' 
#' -   `instance-type` - The instance type (for example, `c4.large`).
#' 
#' -   `network-platform` - The network platform (`EC2-Classic` or
#'     `EC2-VPC`).
#' 
#' -   `platform` - The platform (`Linux/UNIX` or `Windows`).
#' @param FirstSlotStartTimeRange &#91;required&#93; The time period for the first schedule to start.
#' @param MaxResults The maximum number of results to return in a single call. This value can
#' be between 5 and 300. The default value is 300. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param MaxSlotDurationInHours The maximum available duration, in hours. This value must be greater
#' than `MinSlotDurationInHours` and less than 1,720.
#' @param MinSlotDurationInHours The minimum available duration, in hours. The minimum required duration
#' is 1,200 hours per year. For example, the minimum daily schedule is 4
#' hours, the minimum weekly schedule is 24 hours, and the minimum monthly
#' schedule is 100 hours.
#' @param NextToken The token for the next set of results.
#' @param Recurrence &#91;required&#93; The schedule recurrence.
#'
#' @section Request syntax:
#' ```
#' svc$describe_scheduled_instance_availability(
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   FirstSlotStartTimeRange = list(
#'     EarliestTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LatestTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   MaxResults = 123,
#'   MaxSlotDurationInHours = 123,
#'   MinSlotDurationInHours = 123,
#'   NextToken = "string",
#'   Recurrence = list(
#'     Frequency = "string",
#'     Interval = 123,
#'     OccurrenceDays = list(
#'       123
#'     ),
#'     OccurrenceRelativeToEnd = TRUE|FALSE,
#'     OccurrenceUnit = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example describes a schedule that occurs every week on Sunday,
#' # starting on the specified date. Note that the output contains a single
#' # schedule as an example.
#' \dontrun{svc$describe_scheduled_instance_availability(
#'   FirstSlotStartTimeRange = list(
#'     EarliestTime = "2016-01-31T00:00:00Z",
#'     LatestTime = "2016-01-31T04:00:00Z"
#'   ),
#'   Recurrence = list(
#'     Frequency = "Weekly",
#'     Interval = 1L,
#'     OccurrenceDays = list(
#'       1L
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_scheduled_instance_availability
ec2_describe_scheduled_instance_availability <- function(DryRun = NULL, Filters = NULL, FirstSlotStartTimeRange, MaxResults = NULL, MaxSlotDurationInHours = NULL, MinSlotDurationInHours = NULL, NextToken = NULL, Recurrence) {
  op <- new_operation(
    name = "DescribeScheduledInstanceAvailability",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_scheduled_instance_availability_input(DryRun = DryRun, Filters = Filters, FirstSlotStartTimeRange = FirstSlotStartTimeRange, MaxResults = MaxResults, MaxSlotDurationInHours = MaxSlotDurationInHours, MinSlotDurationInHours = MinSlotDurationInHours, NextToken = NextToken, Recurrence = Recurrence)
  output <- .ec2$describe_scheduled_instance_availability_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_scheduled_instance_availability <- ec2_describe_scheduled_instance_availability

#' Describes the specified Scheduled Instances or all your Scheduled
#' Instances
#'
#' Describes the specified Scheduled Instances or all your Scheduled
#' Instances.
#'
#' @usage
#' ec2_describe_scheduled_instances(DryRun, Filters, MaxResults, NextToken,
#'   ScheduledInstanceIds, SlotStartTimeRange)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `availability-zone` - The Availability Zone (for example,
#'     `us-west-2a`).
#' 
#' -   `instance-type` - The instance type (for example, `c4.large`).
#' 
#' -   `network-platform` - The network platform (`EC2-Classic` or
#'     `EC2-VPC`).
#' 
#' -   `platform` - The platform (`Linux/UNIX` or `Windows`).
#' @param MaxResults The maximum number of results to return in a single call. This value can
#' be between 5 and 300. The default value is 100. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token for the next set of results.
#' @param ScheduledInstanceIds The Scheduled Instance IDs.
#' @param SlotStartTimeRange The time period for the first schedule to start.
#'
#' @section Request syntax:
#' ```
#' svc$describe_scheduled_instances(
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   ScheduledInstanceIds = list(
#'     "string"
#'   ),
#'   SlotStartTimeRange = list(
#'     EarliestTime = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     LatestTime = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This example describes the specified Scheduled Instance.
#' \dontrun{svc$describe_scheduled_instances(
#'   ScheduledInstanceIds = list(
#'     "sci-1234-1234-1234-1234-123456789012"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_scheduled_instances
ec2_describe_scheduled_instances <- function(DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, ScheduledInstanceIds = NULL, SlotStartTimeRange = NULL) {
  op <- new_operation(
    name = "DescribeScheduledInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_scheduled_instances_input(DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, ScheduledInstanceIds = ScheduledInstanceIds, SlotStartTimeRange = SlotStartTimeRange)
  output <- .ec2$describe_scheduled_instances_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_scheduled_instances <- ec2_describe_scheduled_instances

#' &#91;VPC only&#93; Describes the VPCs on the other side of a VPC peering
#' connection that are referencing the security groups you've specified in
#' this request
#'
#' \[VPC only\] Describes the VPCs on the other side of a VPC peering
#' connection that are referencing the security groups you\'ve specified in
#' this request.
#'
#' @usage
#' ec2_describe_security_group_references(DryRun, GroupId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param GroupId &#91;required&#93; The IDs of the security groups in your account.
#'
#' @section Request syntax:
#' ```
#' svc$describe_security_group_references(
#'   DryRun = TRUE|FALSE,
#'   GroupId = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example describes the security group references for the specified
#' # security group.
#' \dontrun{svc$describe_security_group_references(
#'   GroupId = list(
#'     "sg-903004f8"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_security_group_references
ec2_describe_security_group_references <- function(DryRun = NULL, GroupId) {
  op <- new_operation(
    name = "DescribeSecurityGroupReferences",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_security_group_references_input(DryRun = DryRun, GroupId = GroupId)
  output <- .ec2$describe_security_group_references_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_security_group_references <- ec2_describe_security_group_references

#' Describes the specified security groups or all of your security groups
#'
#' Describes the specified security groups or all of your security groups.
#' 
#' A security group is for use with instances either in the EC2-Classic
#' platform or in a specific VPC. For more information, see [Amazon EC2
#' Security
#' Groups](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-network-security.html)
#' in the *Amazon Elastic Compute Cloud User Guide* and [Security Groups
#' for Your
#' VPC](https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_SecurityGroups.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_describe_security_groups(Filters, GroupIds, GroupNames, DryRun,
#'   NextToken, MaxResults)
#'
#' @param Filters The filters. If using multiple filters for rules, the results include
#' security groups for which any combination of rules - not necessarily a
#' single rule - match all filters.
#' 
#' -   `description` - The description of the security group.
#' 
#' -   `egress.ip-permission.cidr` - An IPv4 CIDR block for an outbound
#'     security group rule.
#' 
#' -   `egress.ip-permission.from-port` - For an outbound rule, the start
#'     of port range for the TCP and UDP protocols, or an ICMP type number.
#' 
#' -   `egress.ip-permission.group-id` - The ID of a security group that
#'     has been referenced in an outbound security group rule.
#' 
#' -   `egress.ip-permission.group-name` - The name of a security group
#'     that has been referenced in an outbound security group rule.
#' 
#' -   `egress.ip-permission.ipv6-cidr` - An IPv6 CIDR block for an
#'     outbound security group rule.
#' 
#' -   `egress.ip-permission.prefix-list-id` - The ID (prefix) of the AWS
#'     service to which a security group rule allows outbound access.
#' 
#' -   `egress.ip-permission.protocol` - The IP protocol for an outbound
#'     security group rule (`tcp` \\| `udp` \\| `icmp` or a protocol number).
#' 
#' -   `egress.ip-permission.to-port` - For an outbound rule, the end of
#'     port range for the TCP and UDP protocols, or an ICMP code.
#' 
#' -   `egress.ip-permission.user-id` - The ID of an AWS account that has
#'     been referenced in an outbound security group rule.
#' 
#' -   `group-id` - The ID of the security group.
#' 
#' -   `group-name` - The name of the security group.
#' 
#' -   `ip-permission.cidr` - An IPv4 CIDR block for an inbound security
#'     group rule.
#' 
#' -   `ip-permission.from-port` - For an inbound rule, the start of port
#'     range for the TCP and UDP protocols, or an ICMP type number.
#' 
#' -   `ip-permission.group-id` - The ID of a security group that has been
#'     referenced in an inbound security group rule.
#' 
#' -   `ip-permission.group-name` - The name of a security group that has
#'     been referenced in an inbound security group rule.
#' 
#' -   `ip-permission.ipv6-cidr` - An IPv6 CIDR block for an inbound
#'     security group rule.
#' 
#' -   `ip-permission.prefix-list-id` - The ID (prefix) of the AWS service
#'     from which a security group rule allows inbound access.
#' 
#' -   `ip-permission.protocol` - The IP protocol for an inbound security
#'     group rule (`tcp` \\| `udp` \\| `icmp` or a protocol number).
#' 
#' -   `ip-permission.to-port` - For an inbound rule, the end of port range
#'     for the TCP and UDP protocols, or an ICMP code.
#' 
#' -   `ip-permission.user-id` - The ID of an AWS account that has been
#'     referenced in an inbound security group rule.
#' 
#' -   `owner-id` - The AWS account ID of the owner of the security group.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC specified when the security group was
#'     created.
#' @param GroupIds The IDs of the security groups. Required for security groups in a
#' nondefault VPC.
#' 
#' Default: Describes all your security groups.
#' @param GroupNames \[EC2-Classic and default VPC only\] The names of the security groups.
#' You can specify either the security group name or the security group ID.
#' For security groups in a nondefault VPC, use the `group-name` filter to
#' describe security groups by name.
#' 
#' Default: Describes all your security groups.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token to request the next page of results.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another request with the returned
#' `NextToken` value. This value can be between 5 and 1000. If this
#' parameter is not specified, then all results are returned.
#'
#' @section Request syntax:
#' ```
#' svc$describe_security_groups(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   GroupIds = list(
#'     "string"
#'   ),
#'   GroupNames = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' # This example describes the specified security group.
#' \dontrun{svc$describe_security_groups(
#'   GroupIds = list(
#'     "sg-903004f8"
#'   )
#' )}
#' 
#' # This example describes the security groups that include the specified
#' # tag (Purpose=test).
#' \dontrun{svc$describe_security_groups(
#'   Filters = list(
#'     list(
#'       Name = "tag:Purpose",
#'       Values = list(
#'         "test"
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_security_groups
ec2_describe_security_groups <- function(Filters = NULL, GroupIds = NULL, GroupNames = NULL, DryRun = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeSecurityGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_security_groups_input(Filters = Filters, GroupIds = GroupIds, GroupNames = GroupNames, DryRun = DryRun, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_security_groups_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_security_groups <- ec2_describe_security_groups

#' Describes the specified attribute of the specified snapshot
#'
#' Describes the specified attribute of the specified snapshot. You can
#' specify only one attribute at a time.
#' 
#' For more information about EBS snapshots, see [Amazon EBS
#' Snapshots](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_snapshot_attribute(Attribute, SnapshotId, DryRun)
#'
#' @param Attribute &#91;required&#93; The snapshot attribute you would like to view.
#' @param SnapshotId &#91;required&#93; The ID of the EBS snapshot.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_snapshot_attribute(
#'   Attribute = "productCodes"|"createVolumePermission",
#'   SnapshotId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example describes the `createVolumePermission` attribute on a
#' # snapshot with the snapshot ID of `snap-066877671789bd71b`.
#' \dontrun{svc$describe_snapshot_attribute(
#'   Attribute = "createVolumePermission",
#'   SnapshotId = "snap-066877671789bd71b"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_snapshot_attribute
ec2_describe_snapshot_attribute <- function(Attribute, SnapshotId, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeSnapshotAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_snapshot_attribute_input(Attribute = Attribute, SnapshotId = SnapshotId, DryRun = DryRun)
  output <- .ec2$describe_snapshot_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_snapshot_attribute <- ec2_describe_snapshot_attribute

#' Describes the specified EBS snapshots available to you or all of the EBS
#' snapshots available to you
#'
#' Describes the specified EBS snapshots available to you or all of the EBS
#' snapshots available to you.
#' 
#' The snapshots available to you include public snapshots, private
#' snapshots that you own, and private snapshots owned by other AWS
#' accounts for which you have explicit create volume permissions.
#' 
#' The create volume permissions fall into the following categories:
#' 
#' -   *public*: The owner of the snapshot granted create volume
#'     permissions for the snapshot to the `all` group. All AWS accounts
#'     have create volume permissions for these snapshots.
#' 
#' -   *explicit*: The owner of the snapshot granted create volume
#'     permissions to a specific AWS account.
#' 
#' -   *implicit*: An AWS account has implicit create volume permissions
#'     for all snapshots it owns.
#' 
#' The list of snapshots returned can be modified by specifying snapshot
#' IDs, snapshot owners, or AWS accounts with create volume permissions. If
#' no options are specified, Amazon EC2 returns all snapshots for which you
#' have create volume permissions.
#' 
#' If you specify one or more snapshot IDs, only snapshots that have the
#' specified IDs are returned. If you specify an invalid snapshot ID, an
#' error is returned. If you specify a snapshot ID for which you do not
#' have access, it is not included in the returned results.
#' 
#' If you specify one or more snapshot owners using the `OwnerIds` option,
#' only snapshots from the specified owners and for which you have access
#' are returned. The results can include the AWS account IDs of the
#' specified owners, `amazon` for snapshots owned by Amazon, or `self` for
#' snapshots that you own.
#' 
#' If you specify a list of restorable users, only snapshots with create
#' snapshot permissions for those users are returned. You can specify AWS
#' account IDs (if you own the snapshots), `self` for snapshots for which
#' you own or have explicit permissions, or `all` for public snapshots.
#' 
#' If you are describing a long list of snapshots, you can paginate the
#' output to make the list more manageable. The `MaxResults` parameter sets
#' the maximum number of results returned in a single page. If the list of
#' results exceeds your `MaxResults` value, then that number of results is
#' returned along with a `NextToken` value that can be passed to a
#' subsequent `DescribeSnapshots` request to retrieve the remaining
#' results.
#' 
#' For more information about EBS snapshots, see [Amazon EBS
#' Snapshots](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSSnapshots.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_snapshots(Filters, MaxResults, NextToken, OwnerIds,
#'   RestorableByUserIds, SnapshotIds, DryRun)
#'
#' @param Filters The filters.
#' 
#' -   `description` - A description of the snapshot.
#' 
#' -   `encrypted` - Indicates whether the snapshot is encrypted (`true` \\|
#'     `false`)
#' 
#' -   `owner-alias` - Value from an Amazon-maintained list (`amazon` \\|
#'     `self` \\| `all` \\| `aws-marketplace` \\| `microsoft`) of snapshot
#'     owners. Not to be confused with the user-configured AWS account
#'     alias, which is set from the IAM console.
#' 
#' -   `owner-id` - The ID of the AWS account that owns the snapshot.
#' 
#' -   `progress` - The progress of the snapshot, as a percentage (for
#'     example, 80%).
#' 
#' -   `snapshot-id` - The snapshot ID.
#' 
#' -   `start-time` - The time stamp when the snapshot was initiated.
#' 
#' -   `status` - The status of the snapshot (`pending` \\| `completed` \\|
#'     `error`).
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `volume-id` - The ID of the volume the snapshot is for.
#' 
#' -   `volume-size` - The size of the volume, in GiB.
#' @param MaxResults The maximum number of snapshot results returned by `DescribeSnapshots`
#' in paginated output. When this parameter is used, `DescribeSnapshots`
#' only returns `MaxResults` results in a single page along with a
#' `NextToken` response element. The remaining results of the initial
#' request can be seen by sending another `DescribeSnapshots` request with
#' the returned `NextToken` value. This value can be between 5 and 1000; if
#' `MaxResults` is given a value larger than 1000, only 1000 results are
#' returned. If this parameter is not used, then `DescribeSnapshots`
#' returns all results. You cannot specify this parameter and the snapshot
#' IDs parameter in the same request.
#' @param NextToken The `NextToken` value returned from a previous paginated
#' `DescribeSnapshots` request where `MaxResults` was used and the results
#' exceeded the value of that parameter. Pagination continues from the end
#' of the previous results that returned the `NextToken` value. This value
#' is `null` when there are no more results to return.
#' @param OwnerIds Describes the snapshots owned by these owners.
#' @param RestorableByUserIds The IDs of the AWS accounts that can create volumes from the snapshot.
#' @param SnapshotIds The snapshot IDs.
#' 
#' Default: Describes the snapshots for which you have create volume
#' permissions.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_snapshots(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   OwnerIds = list(
#'     "string"
#'   ),
#'   RestorableByUserIds = list(
#'     "string"
#'   ),
#'   SnapshotIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example describes a snapshot with the snapshot ID of
#' # `snap-1234567890abcdef0`.
#' \dontrun{svc$describe_snapshots(
#'   SnapshotIds = list(
#'     "snap-1234567890abcdef0"
#'   )
#' )}
#' 
#' # This example describes all snapshots owned by the ID 012345678910 that
#' # are in the `pending` status.
#' \dontrun{svc$describe_snapshots(
#'   Filters = list(
#'     list(
#'       Name = "status",
#'       Values = list(
#'         "pending"
#'       )
#'     )
#'   ),
#'   OwnerIds = list(
#'     "012345678910"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_snapshots
ec2_describe_snapshots <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL, OwnerIds = NULL, RestorableByUserIds = NULL, SnapshotIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeSnapshots",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_snapshots_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, OwnerIds = OwnerIds, RestorableByUserIds = RestorableByUserIds, SnapshotIds = SnapshotIds, DryRun = DryRun)
  output <- .ec2$describe_snapshots_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_snapshots <- ec2_describe_snapshots

#' Describes the data feed for Spot Instances
#'
#' Describes the data feed for Spot Instances. For more information, see
#' [Spot Instance Data
#' Feed](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-data-feeds.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#'
#' @usage
#' ec2_describe_spot_datafeed_subscription(DryRun)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_spot_datafeed_subscription(
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example describes the Spot Instance datafeed subscription for your
#' # AWS account.
#' \dontrun{svc$describe_spot_datafeed_subscription()}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_spot_datafeed_subscription
ec2_describe_spot_datafeed_subscription <- function(DryRun = NULL) {
  op <- new_operation(
    name = "DescribeSpotDatafeedSubscription",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_spot_datafeed_subscription_input(DryRun = DryRun)
  output <- .ec2$describe_spot_datafeed_subscription_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_spot_datafeed_subscription <- ec2_describe_spot_datafeed_subscription

#' Describes the running instances for the specified Spot Fleet
#'
#' Describes the running instances for the specified Spot Fleet.
#'
#' @usage
#' ec2_describe_spot_fleet_instances(DryRun, MaxResults, NextToken,
#'   SpotFleetRequestId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of results to return in a single call. Specify a
#' value between 1 and 1000. The default value is 1000. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token for the next set of results.
#' @param SpotFleetRequestId &#91;required&#93; The ID of the Spot Fleet request.
#'
#' @section Request syntax:
#' ```
#' svc$describe_spot_fleet_instances(
#'   DryRun = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string",
#'   SpotFleetRequestId = "string"
#' )
#' ```
#'
#' @examples
#' # This example lists the Spot Instances associated with the specified Spot
#' # fleet.
#' \dontrun{svc$describe_spot_fleet_instances(
#'   SpotFleetRequestId = "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_spot_fleet_instances
ec2_describe_spot_fleet_instances <- function(DryRun = NULL, MaxResults = NULL, NextToken = NULL, SpotFleetRequestId) {
  op <- new_operation(
    name = "DescribeSpotFleetInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_spot_fleet_instances_input(DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken, SpotFleetRequestId = SpotFleetRequestId)
  output <- .ec2$describe_spot_fleet_instances_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_spot_fleet_instances <- ec2_describe_spot_fleet_instances

#' Describes the events for the specified Spot Fleet request during the
#' specified time
#'
#' Describes the events for the specified Spot Fleet request during the
#' specified time.
#' 
#' Spot Fleet events are delayed by up to 30 seconds before they can be
#' described. This ensures that you can query by the last evaluated time
#' and not miss a recorded event. Spot Fleet events are available for 48
#' hours.
#'
#' @usage
#' ec2_describe_spot_fleet_request_history(DryRun, EventType, MaxResults,
#'   NextToken, SpotFleetRequestId, StartTime)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param EventType The type of events to describe. By default, all events are described.
#' @param MaxResults The maximum number of results to return in a single call. Specify a
#' value between 1 and 1000. The default value is 1000. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token for the next set of results.
#' @param SpotFleetRequestId &#91;required&#93; The ID of the Spot Fleet request.
#' @param StartTime &#91;required&#93; The starting date and time for the events, in UTC format (for example,
#' *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z).
#'
#' @section Request syntax:
#' ```
#' svc$describe_spot_fleet_request_history(
#'   DryRun = TRUE|FALSE,
#'   EventType = "instanceChange"|"fleetRequestChange"|"error"|"information",
#'   MaxResults = 123,
#'   NextToken = "string",
#'   SpotFleetRequestId = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example returns the history for the specified Spot fleet starting
#' # at the specified time.
#' \dontrun{svc$describe_spot_fleet_request_history(
#'   SpotFleetRequestId = "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE",
#'   StartTime = "2015-05-26T00:00:00Z"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_spot_fleet_request_history
ec2_describe_spot_fleet_request_history <- function(DryRun = NULL, EventType = NULL, MaxResults = NULL, NextToken = NULL, SpotFleetRequestId, StartTime) {
  op <- new_operation(
    name = "DescribeSpotFleetRequestHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_spot_fleet_request_history_input(DryRun = DryRun, EventType = EventType, MaxResults = MaxResults, NextToken = NextToken, SpotFleetRequestId = SpotFleetRequestId, StartTime = StartTime)
  output <- .ec2$describe_spot_fleet_request_history_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_spot_fleet_request_history <- ec2_describe_spot_fleet_request_history

#' Describes your Spot Fleet requests
#'
#' Describes your Spot Fleet requests.
#' 
#' Spot Fleet requests are deleted 48 hours after they are canceled and
#' their instances are terminated.
#'
#' @usage
#' ec2_describe_spot_fleet_requests(DryRun, MaxResults, NextToken,
#'   SpotFleetRequestIds)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of results to return in a single call. Specify a
#' value between 1 and 1000. The default value is 1000. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token for the next set of results.
#' @param SpotFleetRequestIds The IDs of the Spot Fleet requests.
#'
#' @section Request syntax:
#' ```
#' svc$describe_spot_fleet_requests(
#'   DryRun = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string",
#'   SpotFleetRequestIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example describes the specified Spot fleet request.
#' \dontrun{svc$describe_spot_fleet_requests(
#'   SpotFleetRequestIds = list(
#'     "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_spot_fleet_requests
ec2_describe_spot_fleet_requests <- function(DryRun = NULL, MaxResults = NULL, NextToken = NULL, SpotFleetRequestIds = NULL) {
  op <- new_operation(
    name = "DescribeSpotFleetRequests",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_spot_fleet_requests_input(DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken, SpotFleetRequestIds = SpotFleetRequestIds)
  output <- .ec2$describe_spot_fleet_requests_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_spot_fleet_requests <- ec2_describe_spot_fleet_requests

#' Describes the specified Spot Instance requests
#'
#' Describes the specified Spot Instance requests.
#' 
#' You can use `DescribeSpotInstanceRequests` to find a running Spot
#' Instance by examining the response. If the status of the Spot Instance
#' is `fulfilled`, the instance ID appears in the response and contains the
#' identifier of the instance. Alternatively, you can use DescribeInstances
#' with a filter to look for instances where the instance lifecycle is
#' `spot`.
#' 
#' We recommend that you set `MaxResults` to a value between 5 and 1000 to
#' limit the number of results returned. This paginates the output, which
#' makes the list more manageable and returns the results faster. If the
#' list of results exceeds your `MaxResults` value, then that number of
#' results is returned along with a `NextToken` value that can be passed to
#' a subsequent `DescribeSpotInstanceRequests` request to retrieve the
#' remaining results.
#' 
#' Spot Instance requests are deleted four hours after they are canceled
#' and their instances are terminated.
#'
#' @usage
#' ec2_describe_spot_instance_requests(Filters, DryRun,
#'   SpotInstanceRequestIds, NextToken, MaxResults)
#'
#' @param Filters One or more filters.
#' 
#' -   `availability-zone-group` - The Availability Zone group.
#' 
#' -   `create-time` - The time stamp when the Spot Instance request was
#'     created.
#' 
#' -   `fault-code` - The fault code related to the request.
#' 
#' -   `fault-message` - The fault message related to the request.
#' 
#' -   `instance-id` - The ID of the instance that fulfilled the request.
#' 
#' -   `launch-group` - The Spot Instance launch group.
#' 
#' -   `launch.block-device-mapping.delete-on-termination` - Indicates
#'     whether the EBS volume is deleted on instance termination.
#' 
#' -   `launch.block-device-mapping.device-name` - The device name for the
#'     volume in the block device mapping (for example, `/dev/sdh` or
#'     `xvdh`).
#' 
#' -   `launch.block-device-mapping.snapshot-id` - The ID of the snapshot
#'     for the EBS volume.
#' 
#' -   `launch.block-device-mapping.volume-size` - The size of the EBS
#'     volume, in GiB.
#' 
#' -   `launch.block-device-mapping.volume-type` - The type of EBS volume:
#'     `gp2` for General Purpose SSD, `io1` for Provisioned IOPS SSD, `st1`
#'     for Throughput Optimized HDD, `sc1`for Cold HDD, or `standard` for
#'     Magnetic.
#' 
#' -   `launch.group-id` - The ID of the security group for the instance.
#' 
#' -   `launch.group-name` - The name of the security group for the
#'     instance.
#' 
#' -   `launch.image-id` - The ID of the AMI.
#' 
#' -   `launch.instance-type` - The type of instance (for example,
#'     `m3.medium`).
#' 
#' -   `launch.kernel-id` - The kernel ID.
#' 
#' -   `launch.key-name` - The name of the key pair the instance launched
#'     with.
#' 
#' -   `launch.monitoring-enabled` - Whether detailed monitoring is enabled
#'     for the Spot Instance.
#' 
#' -   `launch.ramdisk-id` - The RAM disk ID.
#' 
#' -   `launched-availability-zone` - The Availability Zone in which the
#'     request is launched.
#' 
#' -   `network-interface.addresses.primary` - Indicates whether the IP
#'     address is the primary private IP address.
#' 
#' -   `network-interface.delete-on-termination` - Indicates whether the
#'     network interface is deleted when the instance is terminated.
#' 
#' -   `network-interface.description` - A description of the network
#'     interface.
#' 
#' -   `network-interface.device-index` - The index of the device for the
#'     network interface attachment on the instance.
#' 
#' -   `network-interface.group-id` - The ID of the security group
#'     associated with the network interface.
#' 
#' -   `network-interface.network-interface-id` - The ID of the network
#'     interface.
#' 
#' -   `network-interface.private-ip-address` - The primary private IP
#'     address of the network interface.
#' 
#' -   `network-interface.subnet-id` - The ID of the subnet for the
#'     instance.
#' 
#' -   `product-description` - The product description associated with the
#'     instance (`Linux/UNIX` \\| `Windows`).
#' 
#' -   `spot-instance-request-id` - The Spot Instance request ID.
#' 
#' -   `spot-price` - The maximum hourly price for any Spot Instance
#'     launched to fulfill the request.
#' 
#' -   `state` - The state of the Spot Instance request (`open` \\| `active`
#'     \\| `closed` \\| `cancelled` \\| `failed`). Spot request status
#'     information can help you track your Amazon EC2 Spot Instance
#'     requests. For more information, see [Spot Request
#'     Status](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-bid-status.html)
#'     in the *Amazon EC2 User Guide for Linux Instances*.
#' 
#' -   `status-code` - The short code describing the most recent evaluation
#'     of your Spot Instance request.
#' 
#' -   `status-message` - The message explaining the status of the Spot
#'     Instance request.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `type` - The type of Spot Instance request (`one-time` \\|
#'     `persistent`).
#' 
#' -   `valid-from` - The start date of the request.
#' 
#' -   `valid-until` - The end date of the request.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param SpotInstanceRequestIds One or more Spot Instance request IDs.
#' @param NextToken The token to request the next set of results. This value is `null` when
#' there are no more results to return.
#' @param MaxResults The maximum number of results to return in a single call. Specify a
#' value between 5 and 1000. To retrieve the remaining results, make
#' another call with the returned `NextToken` value.
#'
#' @section Request syntax:
#' ```
#' svc$describe_spot_instance_requests(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   SpotInstanceRequestIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' # This example describes the specified Spot Instance request.
#' \dontrun{svc$describe_spot_instance_requests(
#'   SpotInstanceRequestIds = list(
#'     "sir-08b93456"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_spot_instance_requests
ec2_describe_spot_instance_requests <- function(Filters = NULL, DryRun = NULL, SpotInstanceRequestIds = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeSpotInstanceRequests",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_spot_instance_requests_input(Filters = Filters, DryRun = DryRun, SpotInstanceRequestIds = SpotInstanceRequestIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_spot_instance_requests_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_spot_instance_requests <- ec2_describe_spot_instance_requests

#' Describes the Spot price history
#'
#' Describes the Spot price history. For more information, see [Spot
#' Instance Pricing
#' History](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-spot-instances-history.html)
#' in the *Amazon EC2 User Guide for Linux Instances*.
#' 
#' When you specify a start and end time, this operation returns the prices
#' of the instance types within the time range that you specified and the
#' time when the price changed. The price is valid within the time period
#' that you specified; the response merely indicates the last time that the
#' price changed.
#'
#' @usage
#' ec2_describe_spot_price_history(Filters, AvailabilityZone, DryRun,
#'   EndTime, InstanceTypes, MaxResults, NextToken, ProductDescriptions,
#'   StartTime)
#'
#' @param Filters One or more filters.
#' 
#' -   `availability-zone` - The Availability Zone for which prices should
#'     be returned.
#' 
#' -   `instance-type` - The type of instance (for example, `m3.medium`).
#' 
#' -   `product-description` - The product description for the Spot price
#'     (`Linux/UNIX` \\| `SUSE Linux` \\| `Windows` \\|
#'     `Linux/UNIX (Amazon VPC)` \\| `SUSE Linux (Amazon VPC)` \\|
#'     `Windows (Amazon VPC)`).
#' 
#' -   `spot-price` - The Spot price. The value must match exactly (or use
#'     wildcards; greater than or less than comparison is not supported).
#' 
#' -   `timestamp` - The time stamp of the Spot price history, in UTC
#'     format (for example, *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z). You can use
#'     wildcards (* and ?). Greater than or less than comparison is not
#'     supported.
#' @param AvailabilityZone Filters the results by the specified Availability Zone.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param EndTime The date and time, up to the current date, from which to stop retrieving
#' the price history data, in UTC format (for example,
#' *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z).
#' @param InstanceTypes Filters the results by the specified instance types.
#' @param MaxResults The maximum number of results to return in a single call. Specify a
#' value between 1 and 1000. The default value is 1000. To retrieve the
#' remaining results, make another call with the returned `NextToken`
#' value.
#' @param NextToken The token for the next set of results.
#' @param ProductDescriptions Filters the results by the specified basic product descriptions.
#' @param StartTime The date and time, up to the past 90 days, from which to start
#' retrieving the price history data, in UTC format (for example,
#' *YYYY*-*MM*-*DD*T*HH*:*MM*:*SS*Z).
#'
#' @section Request syntax:
#' ```
#' svc$describe_spot_price_history(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   AvailabilityZone = "string",
#'   DryRun = TRUE|FALSE,
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   InstanceTypes = list(
#'     "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   ProductDescriptions = list(
#'     "string"
#'   ),
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @examples
#' # This example returns the Spot Price history for m1.xlarge, Linux/UNIX
#' # (Amazon VPC) instances for a particular day in January.
#' \dontrun{svc$describe_spot_price_history(
#'   EndTime = "2014-01-06T08:09:10",
#'   InstanceTypes = list(
#'     "m1.xlarge"
#'   ),
#'   ProductDescriptions = list(
#'     "Linux/UNIX (Amazon VPC)"
#'   ),
#'   StartTime = "2014-01-06T07:08:09"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_spot_price_history
ec2_describe_spot_price_history <- function(Filters = NULL, AvailabilityZone = NULL, DryRun = NULL, EndTime = NULL, InstanceTypes = NULL, MaxResults = NULL, NextToken = NULL, ProductDescriptions = NULL, StartTime = NULL) {
  op <- new_operation(
    name = "DescribeSpotPriceHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_spot_price_history_input(Filters = Filters, AvailabilityZone = AvailabilityZone, DryRun = DryRun, EndTime = EndTime, InstanceTypes = InstanceTypes, MaxResults = MaxResults, NextToken = NextToken, ProductDescriptions = ProductDescriptions, StartTime = StartTime)
  output <- .ec2$describe_spot_price_history_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_spot_price_history <- ec2_describe_spot_price_history

#' &#91;VPC only&#93; Describes the stale security group rules for security
#' groups in a specified VPC
#'
#' \[VPC only\] Describes the stale security group rules for security
#' groups in a specified VPC. Rules are stale when they reference a deleted
#' security group in a peer VPC, or a security group in a peer VPC for
#' which the VPC peering connection has been deleted.
#'
#' @usage
#' ec2_describe_stale_security_groups(DryRun, MaxResults, NextToken, VpcId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of items to return for this request. The request
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a prior call.)
#' @param VpcId &#91;required&#93; The ID of the VPC.
#'
#' @section Request syntax:
#' ```
#' svc$describe_stale_security_groups(
#'   DryRun = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string",
#'   VpcId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_stale_security_groups
ec2_describe_stale_security_groups <- function(DryRun = NULL, MaxResults = NULL, NextToken = NULL, VpcId) {
  op <- new_operation(
    name = "DescribeStaleSecurityGroups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_stale_security_groups_input(DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken, VpcId = VpcId)
  output <- .ec2$describe_stale_security_groups_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_stale_security_groups <- ec2_describe_stale_security_groups

#' Describes one or more of your subnets
#'
#' Describes one or more of your subnets.
#' 
#' For more information, see [Your VPC and
#' Subnets](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Subnets.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_describe_subnets(Filters, SubnetIds, DryRun, NextToken, MaxResults)
#'
#' @param Filters One or more filters.
#' 
#' -   `availability-zone` - The Availability Zone for the subnet. You can
#'     also use `availabilityZone` as the filter name.
#' 
#' -   `availability-zone-id` - The ID of the Availability Zone for the
#'     subnet. You can also use `availabilityZoneId` as the filter name.
#' 
#' -   `available-ip-address-count` - The number of IPv4 addresses in the
#'     subnet that are available.
#' 
#' -   `cidr-block` - The IPv4 CIDR block of the subnet. The CIDR block you
#'     specify must exactly match the subnet\'s CIDR block for information
#'     to be returned for the subnet. You can also use `cidr` or
#'     `cidrBlock` as the filter names.
#' 
#' -   `default-for-az` - Indicates whether this is the default subnet for
#'     the Availability Zone. You can also use `defaultForAz` as the filter
#'     name.
#' 
#' -   `ipv6-cidr-block-association.ipv6-cidr-block` - An IPv6 CIDR block
#'     associated with the subnet.
#' 
#' -   `ipv6-cidr-block-association.association-id` - An association ID for
#'     an IPv6 CIDR block associated with the subnet.
#' 
#' -   `ipv6-cidr-block-association.state` - The state of an IPv6 CIDR
#'     block associated with the subnet.
#' 
#' -   `owner-id` - The ID of the AWS account that owns the subnet.
#' 
#' -   `state` - The state of the subnet (`pending` \\| `available`).
#' 
#' -   `subnet-arn` - The Amazon Resource Name (ARN) of the subnet.
#' 
#' -   `subnet-id` - The ID of the subnet.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC for the subnet.
#' @param SubnetIds One or more subnet IDs.
#' 
#' Default: Describes all your subnets.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @section Request syntax:
#' ```
#' svc$describe_subnets(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' # This example describes the subnets for the specified VPC.
#' \dontrun{svc$describe_subnets(
#'   Filters = list(
#'     list(
#'       Name = "vpc-id",
#'       Values = list(
#'         "vpc-a01106c2"
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_subnets
ec2_describe_subnets <- function(Filters = NULL, SubnetIds = NULL, DryRun = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeSubnets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_subnets_input(Filters = Filters, SubnetIds = SubnetIds, DryRun = DryRun, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_subnets_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_subnets <- ec2_describe_subnets

#' Describes the specified tags for your EC2 resources
#'
#' Describes the specified tags for your EC2 resources.
#' 
#' For more information about tags, see [Tagging Your
#' Resources](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_Tags.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_tags(DryRun, Filters, MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters The filters.
#' 
#' -   `key` - The tag key.
#' 
#' -   `resource-id` - The ID of the resource.
#' 
#' -   `resource-type` - The resource type (`customer-gateway` \\|
#'     `dedicated-host` \\| `dhcp-options` \\| `elastic-ip` \\| `fleet` \\|
#'     `fpga-image` \\| `image` \\| `instance` \\| `host-reservation` \\|
#'     `internet-gateway` \\| `launch-template` \\| `natgateway` \\|
#'     `network-acl` \\| `network-interface` \\| `reserved-instances` \\|
#'     `route-table` \\| `security-group` \\| `snapshot` \\|
#'     `spot-instances-request` \\| `subnet` \\| `volume` \\| `vpc` \\|
#'     `vpc-peering-connection` \\| `vpn-connection` \\| `vpn-gateway`).
#' 
#' -   `tag`:\\<key\\> - The key/value combination of the tag. For example,
#'     specify \"tag:Owner\" for the filter name and \"TeamA\" for the
#'     filter value to find resources with the tag \"Owner=TeamA\".
#' 
#' -   `value` - The tag value.
#' @param MaxResults The maximum number of results to return in a single call. This value can
#' be between 5 and 1000. To retrieve the remaining results, make another
#' call with the returned `NextToken` value.
#' @param NextToken The token to retrieve the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_tags(
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # This example describes the tags for the specified instance.
#' \dontrun{svc$describe_tags(
#'   Filters = list(
#'     list(
#'       Name = "resource-id",
#'       Values = list(
#'         "i-1234567890abcdef8"
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_tags
ec2_describe_tags <- function(DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeTags",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_tags_input(DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_tags_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_tags <- ec2_describe_tags

#' Describes one or more Traffic Mirror filters
#'
#' Describes one or more Traffic Mirror filters.
#'
#' @usage
#' ec2_describe_traffic_mirror_filters(TrafficMirrorFilterIds, DryRun,
#'   Filters, MaxResults, NextToken)
#'
#' @param TrafficMirrorFilterIds The ID of the Traffic Mirror filter.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `description`: The Traffic Mirror filter description.
#' 
#' -   `traffic-mirror-filter-id`: The ID of the Traffic Mirror filter.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_traffic_mirror_filters(
#'   TrafficMirrorFilterIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_traffic_mirror_filters
ec2_describe_traffic_mirror_filters <- function(TrafficMirrorFilterIds = NULL, DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeTrafficMirrorFilters",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_traffic_mirror_filters_input(TrafficMirrorFilterIds = TrafficMirrorFilterIds, DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_traffic_mirror_filters_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_traffic_mirror_filters <- ec2_describe_traffic_mirror_filters

#' Describes one or more Traffic Mirror sessions
#'
#' Describes one or more Traffic Mirror sessions. By default, all Traffic
#' Mirror sessions are described. Alternatively, you can filter the
#' results.
#'
#' @usage
#' ec2_describe_traffic_mirror_sessions(TrafficMirrorSessionIds, DryRun,
#'   Filters, MaxResults, NextToken)
#'
#' @param TrafficMirrorSessionIds The ID of the Traffic Mirror session.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `description`: The Traffic Mirror session description.
#' 
#' -   `network-interface-id`: The ID of the Traffic Mirror session network
#'     interface.
#' 
#' -   `owner-id`: The ID of the account that owns the Traffic Mirror
#'     session.
#' 
#' -   `packet-length`: The assigned number of packets to mirror.
#' 
#' -   `session-number`: The assigned session number.
#' 
#' -   `traffic-mirror-filter-id`: The ID of the Traffic Mirror filter.
#' 
#' -   `traffic-mirror-session-id`: The ID of the Traffic Mirror session.
#' 
#' -   `traffic-mirror-target-id`: The ID of the Traffic Mirror target.
#' 
#' -   `virtual-network-id`: The virtual network ID of the Traffic Mirror
#'     session.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_traffic_mirror_sessions(
#'   TrafficMirrorSessionIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_traffic_mirror_sessions
ec2_describe_traffic_mirror_sessions <- function(TrafficMirrorSessionIds = NULL, DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeTrafficMirrorSessions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_traffic_mirror_sessions_input(TrafficMirrorSessionIds = TrafficMirrorSessionIds, DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_traffic_mirror_sessions_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_traffic_mirror_sessions <- ec2_describe_traffic_mirror_sessions

#' Information about one or more Traffic Mirror targets
#'
#' Information about one or more Traffic Mirror targets.
#'
#' @usage
#' ec2_describe_traffic_mirror_targets(TrafficMirrorTargetIds, DryRun,
#'   Filters, MaxResults, NextToken)
#'
#' @param TrafficMirrorTargetIds The ID of the Traffic Mirror targets.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `description`: The Traffic Mirror target description.
#' 
#' -   `network-interface-id`: The ID of the Traffic Mirror session network
#'     interface.
#' 
#' -   `network-load-balancer-arn`: The Amazon Resource Name (ARN) of the
#'     Network Load Balancer that is associated with the session.
#' 
#' -   `owner-id`: The ID of the account that owns the Traffic Mirror
#'     session.
#' 
#' -   `traffic-mirror-target-id`: The ID of the Traffic Mirror target.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_traffic_mirror_targets(
#'   TrafficMirrorTargetIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_traffic_mirror_targets
ec2_describe_traffic_mirror_targets <- function(TrafficMirrorTargetIds = NULL, DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeTrafficMirrorTargets",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_traffic_mirror_targets_input(TrafficMirrorTargetIds = TrafficMirrorTargetIds, DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_traffic_mirror_targets_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_traffic_mirror_targets <- ec2_describe_traffic_mirror_targets

#' Describes one or more attachments between resources and transit gateways
#'
#' Describes one or more attachments between resources and transit
#' gateways. By default, all attachments are described. Alternatively, you
#' can filter the results by attachment ID, attachment state, resource ID,
#' or resource owner.
#'
#' @usage
#' ec2_describe_transit_gateway_attachments(TransitGatewayAttachmentIds,
#'   Filters, MaxResults, NextToken, DryRun)
#'
#' @param TransitGatewayAttachmentIds The IDs of the attachments.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `association.state` - The state of the association (`associating` \\|
#'     `associated` \\| `disassociating`).
#' 
#' -   `association.transit-gateway-route-table-id` - The ID of the route
#'     table for the transit gateway.
#' 
#' -   `resource-id` - The ID of the resource.
#' 
#' -   `resource-owner-id` - The ID of the AWS account that owns the
#'     resource.
#' 
#' -   `resource-type` - The resource type (`vpc` \\| `vpn`).
#' 
#' -   `state` - The state of the attachment (`available` \\| `deleted` \\|
#'     `deleting` \\| `failed` \\| `modifying` \\| `pendingAcceptance` \\|
#'     `pending` \\| `rollingBack` \\| `rejected` \\| `rejecting`).
#' 
#' -   `transit-gateway-attachment-id` - The ID of the attachment.
#' 
#' -   `transit-gateway-id` - The ID of the transit gateway.
#' 
#' -   `transit-gateway-owner-id` - The ID of the AWS account that owns the
#'     transit gateway.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_transit_gateway_attachments(
#'   TransitGatewayAttachmentIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateway_attachments
ec2_describe_transit_gateway_attachments <- function(TransitGatewayAttachmentIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGatewayAttachments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_transit_gateway_attachments_input(TransitGatewayAttachmentIds = TransitGatewayAttachmentIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateway_attachments_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateway_attachments <- ec2_describe_transit_gateway_attachments

#' Describes one or more transit gateway multicast domains
#'
#' Describes one or more transit gateway multicast domains.
#'
#' @usage
#' ec2_describe_transit_gateway_multicast_domains(
#'   TransitGatewayMulticastDomainIds, Filters, MaxResults, NextToken,
#'   DryRun)
#'
#' @param TransitGatewayMulticastDomainIds The ID of the transit gateway multicast domain.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `state` - The state of the transit gateway multicast domain. Valid
#'     values are `pending` \\| `available` \\| `deleting` \\| `deleted`.
#' 
#' -   `transit-gateway-id` - The ID of the transit gateway.
#' 
#' -   `transit-gateway-multicast-domain-id` - The ID of the transit
#'     gateway multicast domain.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_transit_gateway_multicast_domains(
#'   TransitGatewayMulticastDomainIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateway_multicast_domains
ec2_describe_transit_gateway_multicast_domains <- function(TransitGatewayMulticastDomainIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGatewayMulticastDomains",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_transit_gateway_multicast_domains_input(TransitGatewayMulticastDomainIds = TransitGatewayMulticastDomainIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateway_multicast_domains_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateway_multicast_domains <- ec2_describe_transit_gateway_multicast_domains

#' Describes your transit gateway peering attachments
#'
#' Describes your transit gateway peering attachments.
#'
#' @usage
#' ec2_describe_transit_gateway_peering_attachments(
#'   TransitGatewayAttachmentIds, Filters, MaxResults, NextToken, DryRun)
#'
#' @param TransitGatewayAttachmentIds One or more IDs of the transit gateway peering attachments.
#' @param Filters One or more filters.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_transit_gateway_peering_attachments(
#'   TransitGatewayAttachmentIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateway_peering_attachments
ec2_describe_transit_gateway_peering_attachments <- function(TransitGatewayAttachmentIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGatewayPeeringAttachments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_transit_gateway_peering_attachments_input(TransitGatewayAttachmentIds = TransitGatewayAttachmentIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateway_peering_attachments_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateway_peering_attachments <- ec2_describe_transit_gateway_peering_attachments

#' Describes one or more transit gateway route tables
#'
#' Describes one or more transit gateway route tables. By default, all
#' transit gateway route tables are described. Alternatively, you can
#' filter the results.
#'
#' @usage
#' ec2_describe_transit_gateway_route_tables(TransitGatewayRouteTableIds,
#'   Filters, MaxResults, NextToken, DryRun)
#'
#' @param TransitGatewayRouteTableIds The IDs of the transit gateway route tables.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `default-association-route-table` - Indicates whether this is the
#'     default association route table for the transit gateway (`true` \\|
#'     `false`).
#' 
#' -   `default-propagation-route-table` - Indicates whether this is the
#'     default propagation route table for the transit gateway (`true` \\|
#'     `false`).
#' 
#' -   `state` - The state of the attachment (`available` \\| `deleted` \\|
#'     `deleting` \\| `failed` \\| `modifying` \\| `pendingAcceptance` \\|
#'     `pending` \\| `rollingBack` \\| `rejected` \\| `rejecting`).
#' 
#' -   `transit-gateway-id` - The ID of the transit gateway.
#' 
#' -   `transit-gateway-route-table-id` - The ID of the transit gateway
#'     route table.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_transit_gateway_route_tables(
#'   TransitGatewayRouteTableIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateway_route_tables
ec2_describe_transit_gateway_route_tables <- function(TransitGatewayRouteTableIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGatewayRouteTables",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_transit_gateway_route_tables_input(TransitGatewayRouteTableIds = TransitGatewayRouteTableIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateway_route_tables_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateway_route_tables <- ec2_describe_transit_gateway_route_tables

#' Describes one or more VPC attachments
#'
#' Describes one or more VPC attachments. By default, all VPC attachments
#' are described. Alternatively, you can filter the results.
#'
#' @usage
#' ec2_describe_transit_gateway_vpc_attachments(
#'   TransitGatewayAttachmentIds, Filters, MaxResults, NextToken, DryRun)
#'
#' @param TransitGatewayAttachmentIds The IDs of the attachments.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `state` - The state of the attachment (`available` \\| `deleted` \\|
#'     `deleting` \\| `failed` \\| `modifying` \\| `pendingAcceptance` \\|
#'     `pending` \\| `rollingBack` \\| `rejected` \\| `rejecting`).
#' 
#' -   `transit-gateway-attachment-id` - The ID of the attachment.
#' 
#' -   `transit-gateway-id` - The ID of the transit gateway.
#' 
#' -   `vpc-id` - The ID of the VPC.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_transit_gateway_vpc_attachments(
#'   TransitGatewayAttachmentIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateway_vpc_attachments
ec2_describe_transit_gateway_vpc_attachments <- function(TransitGatewayAttachmentIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGatewayVpcAttachments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_transit_gateway_vpc_attachments_input(TransitGatewayAttachmentIds = TransitGatewayAttachmentIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateway_vpc_attachments_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateway_vpc_attachments <- ec2_describe_transit_gateway_vpc_attachments

#' Describes one or more transit gateways
#'
#' Describes one or more transit gateways. By default, all transit gateways
#' are described. Alternatively, you can filter the results.
#'
#' @usage
#' ec2_describe_transit_gateways(TransitGatewayIds, Filters, MaxResults,
#'   NextToken, DryRun)
#'
#' @param TransitGatewayIds The IDs of the transit gateways.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `options.propagation-default-route-table-id` - The ID of the default
#'     propagation route table.
#' 
#' -   `options.amazon-side-asn` - The private ASN for the Amazon side of a
#'     BGP session.
#' 
#' -   `options.association-default-route-table-id` - The ID of the default
#'     association route table.
#' 
#' -   `options.auto-accept-shared-attachments` - Indicates whether there
#'     is automatic acceptance of attachment requests (`enable` \\|
#'     `disable`).
#' 
#' -   `options.default-route-table-association` - Indicates whether
#'     resource attachments are automatically associated with the default
#'     association route table (`enable` \\| `disable`).
#' 
#' -   `options.default-route-table-propagation` - Indicates whether
#'     resource attachments automatically propagate routes to the default
#'     propagation route table (`enable` \\| `disable`).
#' 
#' -   `options.dns-support` - Indicates whether DNS support is enabled
#'     (`enable` \\| `disable`).
#' 
#' -   `options.vpn-ecmp-support` - Indicates whether Equal Cost Multipath
#'     Protocol support is enabled (`enable` \\| `disable`).
#' 
#' -   `owner-id` - The ID of the AWS account that owns the transit
#'     gateway.
#' 
#' -   `state` - The state of the attachment (`available` \\| `deleted` \\|
#'     `deleting` \\| `failed` \\| `modifying` \\| `pendingAcceptance` \\|
#'     `pending` \\| `rollingBack` \\| `rejected` \\| `rejecting`).
#' 
#' -   `transit-gateway-id` - The ID of the transit gateway.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_transit_gateways(
#'   TransitGatewayIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_transit_gateways
ec2_describe_transit_gateways <- function(TransitGatewayIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeTransitGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_transit_gateways_input(TransitGatewayIds = TransitGatewayIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$describe_transit_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_transit_gateways <- ec2_describe_transit_gateways

#' Describes the specified attribute of the specified volume
#'
#' Describes the specified attribute of the specified volume. You can
#' specify only one attribute at a time.
#' 
#' For more information about EBS volumes, see [Amazon EBS
#' Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_volume_attribute(Attribute, VolumeId, DryRun)
#'
#' @param Attribute &#91;required&#93; The attribute of the volume. This parameter is required.
#' @param VolumeId &#91;required&#93; The ID of the volume.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_volume_attribute(
#'   Attribute = "autoEnableIO"|"productCodes",
#'   VolumeId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example describes the `autoEnableIo` attribute of the volume with
#' # the ID `vol-049df61146c4d7901`.
#' \dontrun{svc$describe_volume_attribute(
#'   Attribute = "autoEnableIO",
#'   VolumeId = "vol-049df61146c4d7901"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_volume_attribute
ec2_describe_volume_attribute <- function(Attribute, VolumeId, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVolumeAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_volume_attribute_input(Attribute = Attribute, VolumeId = VolumeId, DryRun = DryRun)
  output <- .ec2$describe_volume_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_volume_attribute <- ec2_describe_volume_attribute

#' Describes the status of the specified volumes
#'
#' Describes the status of the specified volumes. Volume status provides
#' the result of the checks performed on your volumes to determine events
#' that can impair the performance of your volumes. The performance of a
#' volume can be affected if an issue occurs on the volume\'s underlying
#' host. If the volume\'s underlying host experiences a power outage or
#' system issue, after the system is restored, there could be data
#' inconsistencies on the volume. Volume events notify you if this occurs.
#' Volume actions notify you if any action needs to be taken in response to
#' the event.
#' 
#' The `DescribeVolumeStatus` operation provides the following information
#' about the specified volumes:
#' 
#' *Status*: Reflects the current status of the volume. The possible values
#' are `ok`, `impaired` , `warning`, or `insufficient-data`. If all checks
#' pass, the overall status of the volume is `ok`. If the check fails, the
#' overall status is `impaired`. If the status is `insufficient-data`, then
#' the checks may still be taking place on your volume at the time. We
#' recommend that you retry the request. For more information about volume
#' status, see [Monitoring the Status of Your
#' Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/monitoring-volume-status.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' *Events*: Reflect the cause of a volume status and may require you to
#' take action. For example, if your volume returns an `impaired` status,
#' then the volume event might be `potential-data-inconsistency`. This
#' means that your volume has been affected by an issue with the underlying
#' host, has all I/O operations disabled, and may have inconsistent data.
#' 
#' *Actions*: Reflect the actions you may have to take in response to an
#' event. For example, if the status of the volume is `impaired` and the
#' volume event shows `potential-data-inconsistency`, then the action shows
#' `enable-volume-io`. This means that you may want to enable the I/O
#' operations for the volume by calling the EnableVolumeIO action and then
#' check the volume for data consistency.
#' 
#' Volume status is based on the volume status checks, and does not reflect
#' the volume state. Therefore, volume status does not indicate volumes in
#' the `error` state (for example, when a volume is incapable of accepting
#' I/O.)
#'
#' @usage
#' ec2_describe_volume_status(Filters, MaxResults, NextToken, VolumeIds,
#'   DryRun)
#'
#' @param Filters The filters.
#' 
#' -   `action.code` - The action code for the event (for example,
#'     `enable-volume-io`).
#' 
#' -   `action.description` - A description of the action.
#' 
#' -   `action.event-id` - The event ID associated with the action.
#' 
#' -   `availability-zone` - The Availability Zone of the instance.
#' 
#' -   `event.description` - A description of the event.
#' 
#' -   `event.event-id` - The event ID.
#' 
#' -   `event.event-type` - The event type (for `io-enabled`: `passed` \\|
#'     `failed`; for `io-performance`: `io-performance:degraded` \\|
#'     `io-performance:severely-degraded` \\| `io-performance:stalled`).
#' 
#' -   `event.not-after` - The latest end time for the event.
#' 
#' -   `event.not-before` - The earliest start time for the event.
#' 
#' -   `volume-status.details-name` - The cause for `volume-status.status`
#'     (`io-enabled` \\| `io-performance`).
#' 
#' -   `volume-status.details-status` - The status of
#'     `volume-status.details-name` (for `io-enabled`: `passed` \\|
#'     `failed`; for `io-performance`: `normal` \\| `degraded` \\|
#'     `severely-degraded` \\| `stalled`).
#' 
#' -   `volume-status.status` - The status of the volume (`ok` \\|
#'     `impaired` \\| `warning` \\| `insufficient-data`).
#' @param MaxResults The maximum number of volume results returned by `DescribeVolumeStatus`
#' in paginated output. When this parameter is used, the request only
#' returns `MaxResults` results in a single page along with a `NextToken`
#' response element. The remaining results of the initial request can be
#' seen by sending another request with the returned `NextToken` value.
#' This value can be between 5 and 1000; if `MaxResults` is given a value
#' larger than 1000, only 1000 results are returned. If this parameter is
#' not used, then `DescribeVolumeStatus` returns all results. You cannot
#' specify this parameter and the volume IDs parameter in the same request.
#' @param NextToken The `NextToken` value to include in a future `DescribeVolumeStatus`
#' request. When the results of the request exceed `MaxResults`, this value
#' can be used to retrieve the next page of results. This value is `null`
#' when there are no more results to return.
#' @param VolumeIds The IDs of the volumes.
#' 
#' Default: Describes all your volumes.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_volume_status(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   VolumeIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example describes the status for the volume
#' # `vol-1234567890abcdef0`.
#' \dontrun{svc$describe_volume_status(
#'   VolumeIds = list(
#'     "vol-1234567890abcdef0"
#'   )
#' )}
#' 
#' # This example describes the status for all volumes that are impaired. In
#' # this example output, there are no impaired volumes.
#' \dontrun{svc$describe_volume_status(
#'   Filters = list(
#'     list(
#'       Name = "volume-status.status",
#'       Values = list(
#'         "impaired"
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_volume_status
ec2_describe_volume_status <- function(Filters = NULL, MaxResults = NULL, NextToken = NULL, VolumeIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVolumeStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_volume_status_input(Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, VolumeIds = VolumeIds, DryRun = DryRun)
  output <- .ec2$describe_volume_status_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_volume_status <- ec2_describe_volume_status

#' Describes the specified EBS volumes or all of your EBS volumes
#'
#' Describes the specified EBS volumes or all of your EBS volumes.
#' 
#' If you are describing a long list of volumes, you can paginate the
#' output to make the list more manageable. The `MaxResults` parameter sets
#' the maximum number of results returned in a single page. If the list of
#' results exceeds your `MaxResults` value, then that number of results is
#' returned along with a `NextToken` value that can be passed to a
#' subsequent `DescribeVolumes` request to retrieve the remaining results.
#' 
#' For more information about EBS volumes, see [Amazon EBS
#' Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumes.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_volumes(Filters, VolumeIds, DryRun, MaxResults, NextToken)
#'
#' @param Filters The filters.
#' 
#' -   `attachment.attach-time` - The time stamp when the attachment
#'     initiated.
#' 
#' -   `attachment.delete-on-termination` - Whether the volume is deleted
#'     on instance termination.
#' 
#' -   `attachment.device` - The device name specified in the block device
#'     mapping (for example, `/dev/sda1`).
#' 
#' -   `attachment.instance-id` - The ID of the instance the volume is
#'     attached to.
#' 
#' -   `attachment.status` - The attachment state (`attaching` \\|
#'     `attached` \\| `detaching`).
#' 
#' -   `availability-zone` - The Availability Zone in which the volume was
#'     created.
#' 
#' -   `create-time` - The time stamp when the volume was created.
#' 
#' -   `encrypted` - Indicates whether the volume is encrypted (`true` \\|
#'     `false`)
#' 
#' -   `size` - The size of the volume, in GiB.
#' 
#' -   `snapshot-id` - The snapshot from which the volume was created.
#' 
#' -   `status` - The status of the volume (`creating` \\| `available` \\|
#'     `in-use` \\| `deleting` \\| `deleted` \\| `error`).
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `volume-id` - The volume ID.
#' 
#' -   `volume-type` - The Amazon EBS volume type. This can be `gp2` for
#'     General Purpose SSD, `io1` for Provisioned IOPS SSD, `st1` for
#'     Throughput Optimized HDD, `sc1` for Cold HDD, or `standard` for
#'     Magnetic volumes.
#' @param VolumeIds The volume IDs.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param MaxResults The maximum number of volume results returned by `DescribeVolumes` in
#' paginated output. When this parameter is used, `DescribeVolumes` only
#' returns `MaxResults` results in a single page along with a `NextToken`
#' response element. The remaining results of the initial request can be
#' seen by sending another `DescribeVolumes` request with the returned
#' `NextToken` value. This value can be between 5 and 500; if `MaxResults`
#' is given a value larger than 500, only 500 results are returned. If this
#' parameter is not used, then `DescribeVolumes` returns all results. You
#' cannot specify this parameter and the volume IDs parameter in the same
#' request.
#' @param NextToken The `NextToken` value returned from a previous paginated
#' `DescribeVolumes` request where `MaxResults` was used and the results
#' exceeded the value of that parameter. Pagination continues from the end
#' of the previous results that returned the `NextToken` value. This value
#' is `null` when there are no more results to return.
#'
#' @section Request syntax:
#' ```
#' svc$describe_volumes(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   VolumeIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # This example describes all of your volumes in the default region.
#' \dontrun{svc$describe_volumes()}
#' 
#' # This example describes all volumes that are both attached to the
#' # instance with the ID i-1234567890abcdef0 and set to delete when the
#' # instance terminates.
#' \dontrun{svc$describe_volumes(
#'   Filters = list(
#'     list(
#'       Name = "attachment.instance-id",
#'       Values = list(
#'         "i-1234567890abcdef0"
#'       )
#'     ),
#'     list(
#'       Name = "attachment.delete-on-termination",
#'       Values = list(
#'         "true"
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_volumes
ec2_describe_volumes <- function(Filters = NULL, VolumeIds = NULL, DryRun = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVolumes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_volumes_input(Filters = Filters, VolumeIds = VolumeIds, DryRun = DryRun, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_volumes_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_volumes <- ec2_describe_volumes

#' Reports the current modification status of EBS volumes
#'
#' Reports the current modification status of EBS volumes.
#' 
#' Current-generation EBS volumes support modification of attributes
#' including type, size, and (for `io1` volumes) IOPS provisioning while
#' either attached to or detached from an instance. Following an action
#' from the API or the console to modify a volume, the status of the
#' modification may be `modifying`, `optimizing`, `completed`, or `failed`.
#' If a volume has never been modified, then certain elements of the
#' returned `VolumeModification` objects are null.
#' 
#' You can also use CloudWatch Events to check the status of a modification
#' to an EBS volume. For information about CloudWatch Events, see the
#' [Amazon CloudWatch Events User
#' Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/). For
#' more information, see [Monitoring Volume
#' Modifications\"](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#monitoring_mods)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_volumes_modifications(DryRun, VolumeIds, Filters,
#'   NextToken, MaxResults)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VolumeIds The IDs of the volumes for which in-progress modifications will be
#' described.
#' @param Filters The filters. Supported filters: `volume-id`, `modification-state`,
#' `target-size`, `target-iops`, `target-volume-type`, `original-size`,
#' `original-iops`, `original-volume-type`, `start-time`.
#' @param NextToken The `nextToken` value returned by a previous paginated request.
#' @param MaxResults The maximum number of results (up to a limit of 500) to be returned in a
#' paginated request.
#'
#' @section Request syntax:
#' ```
#' svc$describe_volumes_modifications(
#'   DryRun = TRUE|FALSE,
#'   VolumeIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_volumes_modifications
ec2_describe_volumes_modifications <- function(DryRun = NULL, VolumeIds = NULL, Filters = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeVolumesModifications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_volumes_modifications_input(DryRun = DryRun, VolumeIds = VolumeIds, Filters = Filters, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_volumes_modifications_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_volumes_modifications <- ec2_describe_volumes_modifications

#' Describes the specified attribute of the specified VPC
#'
#' Describes the specified attribute of the specified VPC. You can specify
#' only one attribute at a time.
#'
#' @usage
#' ec2_describe_vpc_attribute(Attribute, VpcId, DryRun)
#'
#' @param Attribute &#91;required&#93; The VPC attribute.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_vpc_attribute(
#'   Attribute = "enableDnsSupport"|"enableDnsHostnames",
#'   VpcId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example describes the enableDnsSupport attribute. This attribute
#' # indicates whether DNS resolution is enabled for the VPC. If this
#' # attribute is true, the Amazon DNS server resolves DNS hostnames for your
#' # instances to their corresponding IP addresses; otherwise, it does not.
#' \dontrun{svc$describe_vpc_attribute(
#'   Attribute = "enableDnsSupport",
#'   VpcId = "vpc-a01106c2"
#' )}
#' 
#' # This example describes the enableDnsHostnames attribute. This attribute
#' # indicates whether the instances launched in the VPC get DNS hostnames.
#' # If this attribute is true, instances in the VPC get DNS hostnames;
#' # otherwise, they do not.
#' \dontrun{svc$describe_vpc_attribute(
#'   Attribute = "enableDnsHostnames",
#'   VpcId = "vpc-a01106c2"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_attribute
ec2_describe_vpc_attribute <- function(Attribute, VpcId, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVpcAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_vpc_attribute_input(Attribute = Attribute, VpcId = VpcId, DryRun = DryRun)
  output <- .ec2$describe_vpc_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_attribute <- ec2_describe_vpc_attribute

#' Describes the ClassicLink status of one or more VPCs
#'
#' Describes the ClassicLink status of one or more VPCs.
#'
#' @usage
#' ec2_describe_vpc_classic_link(Filters, DryRun, VpcIds)
#'
#' @param Filters One or more filters.
#' 
#' -   `is-classic-link-enabled` - Whether the VPC is enabled for
#'     ClassicLink (`true` \\| `false`).
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcIds One or more VPCs for which you want to describe the ClassicLink status.
#'
#' @section Request syntax:
#' ```
#' svc$describe_vpc_classic_link(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   VpcIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_classic_link
ec2_describe_vpc_classic_link <- function(Filters = NULL, DryRun = NULL, VpcIds = NULL) {
  op <- new_operation(
    name = "DescribeVpcClassicLink",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_vpc_classic_link_input(Filters = Filters, DryRun = DryRun, VpcIds = VpcIds)
  output <- .ec2$describe_vpc_classic_link_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_classic_link <- ec2_describe_vpc_classic_link

#' Describes the ClassicLink DNS support status of one or more VPCs
#'
#' Describes the ClassicLink DNS support status of one or more VPCs. If
#' enabled, the DNS hostname of a linked EC2-Classic instance resolves to
#' its private IP address when addressed from an instance in the VPC to
#' which it\'s linked. Similarly, the DNS hostname of an instance in a VPC
#' resolves to its private IP address when addressed from a linked
#' EC2-Classic instance. For more information, see
#' [ClassicLink](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_describe_vpc_classic_link_dns_support(MaxResults, NextToken, VpcIds)
#'
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param VpcIds One or more VPC IDs.
#'
#' @section Request syntax:
#' ```
#' svc$describe_vpc_classic_link_dns_support(
#'   MaxResults = 123,
#'   NextToken = "string",
#'   VpcIds = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_classic_link_dns_support
ec2_describe_vpc_classic_link_dns_support <- function(MaxResults = NULL, NextToken = NULL, VpcIds = NULL) {
  op <- new_operation(
    name = "DescribeVpcClassicLinkDnsSupport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_vpc_classic_link_dns_support_input(MaxResults = MaxResults, NextToken = NextToken, VpcIds = VpcIds)
  output <- .ec2$describe_vpc_classic_link_dns_support_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_classic_link_dns_support <- ec2_describe_vpc_classic_link_dns_support

#' Describes the connection notifications for VPC endpoints and VPC
#' endpoint services
#'
#' Describes the connection notifications for VPC endpoints and VPC
#' endpoint services.
#'
#' @usage
#' ec2_describe_vpc_endpoint_connection_notifications(DryRun,
#'   ConnectionNotificationId, Filters, MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ConnectionNotificationId The ID of the notification.
#' @param Filters One or more filters.
#' 
#' -   `connection-notification-arn` - The ARN of the SNS topic for the
#'     notification.
#' 
#' -   `connection-notification-id` - The ID of the notification.
#' 
#' -   `connection-notification-state` - The state of the notification
#'     (`Enabled` \\| `Disabled`).
#' 
#' -   `connection-notification-type` - The type of notification (`Topic`).
#' 
#' -   `service-id` - The ID of the endpoint service.
#' 
#' -   `vpc-endpoint-id` - The ID of the VPC endpoint.
#' @param MaxResults The maximum number of results to return in a single call. To retrieve
#' the remaining results, make another request with the returned
#' `NextToken` value.
#' @param NextToken The token to request the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_vpc_endpoint_connection_notifications(
#'   DryRun = TRUE|FALSE,
#'   ConnectionNotificationId = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_endpoint_connection_notifications
ec2_describe_vpc_endpoint_connection_notifications <- function(DryRun = NULL, ConnectionNotificationId = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVpcEndpointConnectionNotifications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_vpc_endpoint_connection_notifications_input(DryRun = DryRun, ConnectionNotificationId = ConnectionNotificationId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_vpc_endpoint_connection_notifications_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_endpoint_connection_notifications <- ec2_describe_vpc_endpoint_connection_notifications

#' Describes the VPC endpoint connections to your VPC endpoint services,
#' including any endpoints that are pending your acceptance
#'
#' Describes the VPC endpoint connections to your VPC endpoint services,
#' including any endpoints that are pending your acceptance.
#'
#' @usage
#' ec2_describe_vpc_endpoint_connections(DryRun, Filters, MaxResults,
#'   NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Filters One or more filters.
#' 
#' -   `service-id` - The ID of the service.
#' 
#' -   `vpc-endpoint-owner` - The AWS account number of the owner of the
#'     endpoint.
#' 
#' -   `vpc-endpoint-state` - The state of the endpoint
#'     (`pendingAcceptance` \\| `pending` \\| `available` \\| `deleting` \\|
#'     `deleted` \\| `rejected` \\| `failed`).
#' 
#' -   `vpc-endpoint-id` - The ID of the endpoint.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results of the initial request can be seen by
#' sending another request with the returned `NextToken` value. This value
#' can be between 5 and 1,000; if `MaxResults` is given a value larger than
#' 1,000, only 1,000 results are returned.
#' @param NextToken The token to retrieve the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_vpc_endpoint_connections(
#'   DryRun = TRUE|FALSE,
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_endpoint_connections
ec2_describe_vpc_endpoint_connections <- function(DryRun = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVpcEndpointConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_vpc_endpoint_connections_input(DryRun = DryRun, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_vpc_endpoint_connections_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_endpoint_connections <- ec2_describe_vpc_endpoint_connections

#' Describes the VPC endpoint service configurations in your account (your
#' services)
#'
#' Describes the VPC endpoint service configurations in your account (your
#' services).
#'
#' @usage
#' ec2_describe_vpc_endpoint_service_configurations(DryRun, ServiceIds,
#'   Filters, MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ServiceIds The IDs of one or more services.
#' @param Filters One or more filters.
#' 
#' -   `service-name` - The name of the service.
#' 
#' -   `service-id` - The ID of the service.
#' 
#' -   `service-state` - The state of the service (`Pending` \\| `Available`
#'     \\| `Deleting` \\| `Deleted` \\| `Failed`).
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results of the initial request can be seen by
#' sending another request with the returned `NextToken` value. This value
#' can be between 5 and 1,000; if `MaxResults` is given a value larger than
#' 1,000, only 1,000 results are returned.
#' @param NextToken The token to retrieve the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_vpc_endpoint_service_configurations(
#'   DryRun = TRUE|FALSE,
#'   ServiceIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_endpoint_service_configurations
ec2_describe_vpc_endpoint_service_configurations <- function(DryRun = NULL, ServiceIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVpcEndpointServiceConfigurations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_vpc_endpoint_service_configurations_input(DryRun = DryRun, ServiceIds = ServiceIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_vpc_endpoint_service_configurations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_endpoint_service_configurations <- ec2_describe_vpc_endpoint_service_configurations

#' Describes the principals (service consumers) that are permitted to
#' discover your VPC endpoint service
#'
#' Describes the principals (service consumers) that are permitted to
#' discover your VPC endpoint service.
#'
#' @usage
#' ec2_describe_vpc_endpoint_service_permissions(DryRun, ServiceId,
#'   Filters, MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ServiceId &#91;required&#93; The ID of the service.
#' @param Filters One or more filters.
#' 
#' -   `principal` - The ARN of the principal.
#' 
#' -   `principal-type` - The principal type (`All` \\| `Service` \\|
#'     `OrganizationUnit` \\| `Account` \\| `User` \\| `Role`).
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results of the initial request can be seen by
#' sending another request with the returned `NextToken` value. This value
#' can be between 5 and 1,000; if `MaxResults` is given a value larger than
#' 1,000, only 1,000 results are returned.
#' @param NextToken The token to retrieve the next page of results.
#'
#' @section Request syntax:
#' ```
#' svc$describe_vpc_endpoint_service_permissions(
#'   DryRun = TRUE|FALSE,
#'   ServiceId = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_endpoint_service_permissions
ec2_describe_vpc_endpoint_service_permissions <- function(DryRun = NULL, ServiceId, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVpcEndpointServicePermissions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_vpc_endpoint_service_permissions_input(DryRun = DryRun, ServiceId = ServiceId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_vpc_endpoint_service_permissions_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_endpoint_service_permissions <- ec2_describe_vpc_endpoint_service_permissions

#' Describes available services to which you can create a VPC endpoint
#'
#' Describes available services to which you can create a VPC endpoint.
#'
#' @usage
#' ec2_describe_vpc_endpoint_services(DryRun, ServiceNames, Filters,
#'   MaxResults, NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ServiceNames One or more service names.
#' @param Filters One or more filters.
#' 
#' -   `service-name` - The name of the service.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param MaxResults The maximum number of items to return for this request. The request
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' 
#' Constraint: If the value is greater than 1,000, we return only 1,000
#' items.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a prior call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_vpc_endpoint_services(
#'   DryRun = TRUE|FALSE,
#'   ServiceNames = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_endpoint_services
ec2_describe_vpc_endpoint_services <- function(DryRun = NULL, ServiceNames = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVpcEndpointServices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_vpc_endpoint_services_input(DryRun = DryRun, ServiceNames = ServiceNames, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_vpc_endpoint_services_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_endpoint_services <- ec2_describe_vpc_endpoint_services

#' Describes one or more of your VPC endpoints
#'
#' Describes one or more of your VPC endpoints.
#'
#' @usage
#' ec2_describe_vpc_endpoints(DryRun, VpcEndpointIds, Filters, MaxResults,
#'   NextToken)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcEndpointIds One or more endpoint IDs.
#' @param Filters One or more filters.
#' 
#' -   `service-name` - The name of the service.
#' 
#' -   `vpc-id` - The ID of the VPC in which the endpoint resides.
#' 
#' -   `vpc-endpoint-id` - The ID of the endpoint.
#' 
#' -   `vpc-endpoint-state` - The state of the endpoint
#'     (`pendingAcceptance` \\| `pending` \\| `available` \\| `deleting` \\|
#'     `deleted` \\| `rejected` \\| `failed`).
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' @param MaxResults The maximum number of items to return for this request. The request
#' returns a token that you can specify in a subsequent call to get the
#' next set of results.
#' 
#' Constraint: If the value is greater than 1,000, we return only 1,000
#' items.
#' @param NextToken The token for the next set of items to return. (You received this token
#' from a prior call.)
#'
#' @section Request syntax:
#' ```
#' svc$describe_vpc_endpoints(
#'   DryRun = TRUE|FALSE,
#'   VpcEndpointIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_endpoints
ec2_describe_vpc_endpoints <- function(DryRun = NULL, VpcEndpointIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeVpcEndpoints",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_vpc_endpoints_input(DryRun = DryRun, VpcEndpointIds = VpcEndpointIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .ec2$describe_vpc_endpoints_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_endpoints <- ec2_describe_vpc_endpoints

#' Describes one or more of your VPC peering connections
#'
#' Describes one or more of your VPC peering connections.
#'
#' @usage
#' ec2_describe_vpc_peering_connections(Filters, DryRun,
#'   VpcPeeringConnectionIds, NextToken, MaxResults)
#'
#' @param Filters One or more filters.
#' 
#' -   `accepter-vpc-info.cidr-block` - The IPv4 CIDR block of the accepter
#'     VPC.
#' 
#' -   `accepter-vpc-info.owner-id` - The AWS account ID of the owner of
#'     the accepter VPC.
#' 
#' -   `accepter-vpc-info.vpc-id` - The ID of the accepter VPC.
#' 
#' -   `expiration-time` - The expiration date and time for the VPC peering
#'     connection.
#' 
#' -   `requester-vpc-info.cidr-block` - The IPv4 CIDR block of the
#'     requester\'s VPC.
#' 
#' -   `requester-vpc-info.owner-id` - The AWS account ID of the owner of
#'     the requester VPC.
#' 
#' -   `requester-vpc-info.vpc-id` - The ID of the requester VPC.
#' 
#' -   `status-code` - The status of the VPC peering connection
#'     (`pending-acceptance` \\| `failed` \\| `expired` \\| `provisioning` \\|
#'     `active` \\| `deleting` \\| `deleted` \\| `rejected`).
#' 
#' -   `status-message` - A message that provides more information about
#'     the status of the VPC peering connection, if applicable.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-peering-connection-id` - The ID of the VPC peering connection.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcPeeringConnectionIds One or more VPC peering connection IDs.
#' 
#' Default: Describes all your VPC peering connections.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @section Request syntax:
#' ```
#' svc$describe_vpc_peering_connections(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   VpcPeeringConnectionIds = list(
#'     "string"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpc_peering_connections
ec2_describe_vpc_peering_connections <- function(Filters = NULL, DryRun = NULL, VpcPeeringConnectionIds = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeVpcPeeringConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_vpc_peering_connections_input(Filters = Filters, DryRun = DryRun, VpcPeeringConnectionIds = VpcPeeringConnectionIds, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_vpc_peering_connections_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpc_peering_connections <- ec2_describe_vpc_peering_connections

#' Describes one or more of your VPCs
#'
#' Describes one or more of your VPCs.
#'
#' @usage
#' ec2_describe_vpcs(Filters, VpcIds, DryRun, NextToken, MaxResults)
#'
#' @param Filters One or more filters.
#' 
#' -   `cidr` - The primary IPv4 CIDR block of the VPC. The CIDR block you
#'     specify must exactly match the VPC\'s CIDR block for information to
#'     be returned for the VPC. Must contain the slash followed by one or
#'     two digits (for example, `/28`).
#' 
#' -   `cidr-block-association.cidr-block` - An IPv4 CIDR block associated
#'     with the VPC.
#' 
#' -   `cidr-block-association.association-id` - The association ID for an
#'     IPv4 CIDR block associated with the VPC.
#' 
#' -   `cidr-block-association.state` - The state of an IPv4 CIDR block
#'     associated with the VPC.
#' 
#' -   `dhcp-options-id` - The ID of a set of DHCP options.
#' 
#' -   `ipv6-cidr-block-association.ipv6-cidr-block` - An IPv6 CIDR block
#'     associated with the VPC.
#' 
#' -   `ipv6-cidr-block-association.association-id` - The association ID
#'     for an IPv6 CIDR block associated with the VPC.
#' 
#' -   `ipv6-cidr-block-association.state` - The state of an IPv6 CIDR
#'     block associated with the VPC.
#' 
#' -   `isDefault` - Indicates whether the VPC is the default VPC.
#' 
#' -   `owner-id` - The ID of the AWS account that owns the VPC.
#' 
#' -   `state` - The state of the VPC (`pending` \\| `available`).
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `vpc-id` - The ID of the VPC.
#' @param VpcIds One or more VPC IDs.
#' 
#' Default: Describes all your VPCs.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param NextToken The token for the next page of results.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#'
#' @section Request syntax:
#' ```
#' svc$describe_vpcs(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   VpcIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @examples
#' # This example describes the specified VPC.
#' \dontrun{svc$describe_vpcs(
#'   VpcIds = list(
#'     "vpc-a01106c2"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpcs
ec2_describe_vpcs <- function(Filters = NULL, VpcIds = NULL, DryRun = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "DescribeVpcs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_vpcs_input(Filters = Filters, VpcIds = VpcIds, DryRun = DryRun, NextToken = NextToken, MaxResults = MaxResults)
  output <- .ec2$describe_vpcs_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpcs <- ec2_describe_vpcs

#' Describes one or more of your VPN connections
#'
#' Describes one or more of your VPN connections.
#' 
#' For more information, see [AWS Site-to-Site
#' VPN](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the
#' *AWS Site-to-Site VPN User Guide*.
#'
#' @usage
#' ec2_describe_vpn_connections(Filters, VpnConnectionIds, DryRun)
#'
#' @param Filters One or more filters.
#' 
#' -   `customer-gateway-configuration` - The configuration information for
#'     the customer gateway.
#' 
#' -   `customer-gateway-id` - The ID of a customer gateway associated with
#'     the VPN connection.
#' 
#' -   `state` - The state of the VPN connection (`pending` \\| `available`
#'     \\| `deleting` \\| `deleted`).
#' 
#' -   `option.static-routes-only` - Indicates whether the connection has
#'     static routes only. Used for devices that do not support Border
#'     Gateway Protocol (BGP).
#' 
#' -   `route.destination-cidr-block` - The destination CIDR block. This
#'     corresponds to the subnet used in a customer data center.
#' 
#' -   `bgp-asn` - The BGP Autonomous System Number (ASN) associated with a
#'     BGP device.
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `type` - The type of VPN connection. Currently the only supported
#'     type is `ipsec.1`.
#' 
#' -   `vpn-connection-id` - The ID of the VPN connection.
#' 
#' -   `vpn-gateway-id` - The ID of a virtual private gateway associated
#'     with the VPN connection.
#' 
#' -   `transit-gateway-id` - The ID of a transit gateway associated with
#'     the VPN connection.
#' @param VpnConnectionIds One or more VPN connection IDs.
#' 
#' Default: Describes your VPN connections.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_vpn_connections(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   VpnConnectionIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpn_connections
ec2_describe_vpn_connections <- function(Filters = NULL, VpnConnectionIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVpnConnections",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_vpn_connections_input(Filters = Filters, VpnConnectionIds = VpnConnectionIds, DryRun = DryRun)
  output <- .ec2$describe_vpn_connections_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpn_connections <- ec2_describe_vpn_connections

#' Describes one or more of your virtual private gateways
#'
#' Describes one or more of your virtual private gateways.
#' 
#' For more information, see [AWS Site-to-Site
#' VPN](https://docs.aws.amazon.com/vpn/latest/s2svpn/VPC_VPN.html) in the
#' *AWS Site-to-Site VPN User Guide*.
#'
#' @usage
#' ec2_describe_vpn_gateways(Filters, VpnGatewayIds, DryRun)
#'
#' @param Filters One or more filters.
#' 
#' -   `amazon-side-asn` - The Autonomous System Number (ASN) for the
#'     Amazon side of the gateway.
#' 
#' -   `attachment.state` - The current state of the attachment between the
#'     gateway and the VPC (`attaching` \\| `attached` \\| `detaching` \\|
#'     `detached`).
#' 
#' -   `attachment.vpc-id` - The ID of an attached VPC.
#' 
#' -   `availability-zone` - The Availability Zone for the virtual private
#'     gateway (if applicable).
#' 
#' -   `state` - The state of the virtual private gateway (`pending` \\|
#'     `available` \\| `deleting` \\| `deleted`).
#' 
#' -   `tag`:\\<key\\> - The key/value combination of a tag assigned to the
#'     resource. Use the tag key in the filter name and the tag value as
#'     the filter value. For example, to find all resources that have a tag
#'     with the key `Owner` and the value `TeamA`, specify `tag:Owner` for
#'     the filter name and `TeamA` for the filter value.
#' 
#' -   `tag-key` - The key of a tag assigned to the resource. Use this
#'     filter to find all resources assigned a tag with a specific key,
#'     regardless of the tag value.
#' 
#' -   `type` - The type of virtual private gateway. Currently the only
#'     supported type is `ipsec.1`.
#' 
#' -   `vpn-gateway-id` - The ID of the virtual private gateway.
#' @param VpnGatewayIds One or more virtual private gateway IDs.
#' 
#' Default: Describes all your virtual private gateways.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$describe_vpn_gateways(
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   VpnGatewayIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_describe_vpn_gateways
ec2_describe_vpn_gateways <- function(Filters = NULL, VpnGatewayIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DescribeVpnGateways",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$describe_vpn_gateways_input(Filters = Filters, VpnGatewayIds = VpnGatewayIds, DryRun = DryRun)
  output <- .ec2$describe_vpn_gateways_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$describe_vpn_gateways <- ec2_describe_vpn_gateways

#' Unlinks (detaches) a linked EC2-Classic instance from a VPC
#'
#' Unlinks (detaches) a linked EC2-Classic instance from a VPC. After the
#' instance has been unlinked, the VPC security groups are no longer
#' associated with it. An instance is automatically unlinked from a VPC
#' when it\'s stopped.
#'
#' @usage
#' ec2_detach_classic_link_vpc(DryRun, InstanceId, VpcId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceId &#91;required&#93; The ID of the instance to unlink from the VPC.
#' @param VpcId &#91;required&#93; The ID of the VPC to which the instance is linked.
#'
#' @section Request syntax:
#' ```
#' svc$detach_classic_link_vpc(
#'   DryRun = TRUE|FALSE,
#'   InstanceId = "string",
#'   VpcId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_detach_classic_link_vpc
ec2_detach_classic_link_vpc <- function(DryRun = NULL, InstanceId, VpcId) {
  op <- new_operation(
    name = "DetachClassicLinkVpc",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$detach_classic_link_vpc_input(DryRun = DryRun, InstanceId = InstanceId, VpcId = VpcId)
  output <- .ec2$detach_classic_link_vpc_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$detach_classic_link_vpc <- ec2_detach_classic_link_vpc

#' Detaches an internet gateway from a VPC, disabling connectivity between
#' the internet and the VPC
#'
#' Detaches an internet gateway from a VPC, disabling connectivity between
#' the internet and the VPC. The VPC must not contain any running instances
#' with Elastic IP addresses or public IPv4 addresses.
#'
#' @usage
#' ec2_detach_internet_gateway(DryRun, InternetGatewayId, VpcId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InternetGatewayId &#91;required&#93; The ID of the internet gateway.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#'
#' @section Request syntax:
#' ```
#' svc$detach_internet_gateway(
#'   DryRun = TRUE|FALSE,
#'   InternetGatewayId = "string",
#'   VpcId = "string"
#' )
#' ```
#'
#' @examples
#' # This example detaches the specified Internet gateway from the specified
#' # VPC.
#' \dontrun{svc$detach_internet_gateway(
#'   InternetGatewayId = "igw-c0a643a9",
#'   VpcId = "vpc-a01106c2"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_detach_internet_gateway
ec2_detach_internet_gateway <- function(DryRun = NULL, InternetGatewayId, VpcId) {
  op <- new_operation(
    name = "DetachInternetGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$detach_internet_gateway_input(DryRun = DryRun, InternetGatewayId = InternetGatewayId, VpcId = VpcId)
  output <- .ec2$detach_internet_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$detach_internet_gateway <- ec2_detach_internet_gateway

#' Detaches a network interface from an instance
#'
#' Detaches a network interface from an instance.
#'
#' @usage
#' ec2_detach_network_interface(AttachmentId, DryRun, Force)
#'
#' @param AttachmentId &#91;required&#93; The ID of the attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Force Specifies whether to force a detachment.
#' 
#' -   Use the `Force` parameter only as a last resort to detach a network
#'     interface from a failed instance.
#' 
#' -   If you use the `Force` parameter to detach a network interface, you
#'     might not be able to attach a different network interface to the
#'     same index on the instance without first stopping and starting the
#'     instance.
#' 
#' -   If you force the detachment of a network interface, the [instance
#'     metadata](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html)
#'     might not get updated. This means that the attributes associated
#'     with the detached network interface might still be visible. The
#'     instance metadata will get updated when you stop and start the
#'     instance.
#'
#' @section Request syntax:
#' ```
#' svc$detach_network_interface(
#'   AttachmentId = "string",
#'   DryRun = TRUE|FALSE,
#'   Force = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example detaches the specified network interface from its attached
#' # instance.
#' \dontrun{svc$detach_network_interface(
#'   AttachmentId = "eni-attach-66c4350a"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_detach_network_interface
ec2_detach_network_interface <- function(AttachmentId, DryRun = NULL, Force = NULL) {
  op <- new_operation(
    name = "DetachNetworkInterface",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$detach_network_interface_input(AttachmentId = AttachmentId, DryRun = DryRun, Force = Force)
  output <- .ec2$detach_network_interface_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$detach_network_interface <- ec2_detach_network_interface

#' Detaches an EBS volume from an instance
#'
#' Detaches an EBS volume from an instance. Make sure to unmount any file
#' systems on the device within your operating system before detaching the
#' volume. Failure to do so can result in the volume becoming stuck in the
#' `busy` state while detaching. If this happens, detachment can be delayed
#' indefinitely until you unmount the volume, force detachment, reboot the
#' instance, or all three. If an EBS volume is the root device of an
#' instance, it can\'t be detached while the instance is running. To detach
#' the root volume, stop the instance first.
#' 
#' When a volume with an AWS Marketplace product code is detached from an
#' instance, the product code is no longer associated with the instance.
#' 
#' For more information, see [Detaching an Amazon EBS
#' Volume](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-detaching-volume.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_detach_volume(Device, Force, InstanceId, VolumeId, DryRun)
#'
#' @param Device The device name.
#' @param Force Forces detachment if the previous detachment attempt did not occur
#' cleanly (for example, logging into an instance, unmounting the volume,
#' and detaching normally). This option can lead to data loss or a
#' corrupted file system. Use this option only as a last resort to detach a
#' volume from a failed instance. The instance won\'t have an opportunity
#' to flush file system caches or file system metadata. If you use this
#' option, you must perform file system check and repair procedures.
#' @param InstanceId The ID of the instance.
#' @param VolumeId &#91;required&#93; The ID of the volume.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$detach_volume(
#'   Device = "string",
#'   Force = TRUE|FALSE,
#'   InstanceId = "string",
#'   VolumeId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example detaches the volume (`vol-049df61146c4d7901`) from the
#' # instance it is attached to.
#' \dontrun{svc$detach_volume(
#'   VolumeId = "vol-1234567890abcdef0"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_detach_volume
ec2_detach_volume <- function(Device = NULL, Force = NULL, InstanceId = NULL, VolumeId, DryRun = NULL) {
  op <- new_operation(
    name = "DetachVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$detach_volume_input(Device = Device, Force = Force, InstanceId = InstanceId, VolumeId = VolumeId, DryRun = DryRun)
  output <- .ec2$detach_volume_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$detach_volume <- ec2_detach_volume

#' Detaches a virtual private gateway from a VPC
#'
#' Detaches a virtual private gateway from a VPC. You do this if you\'re
#' planning to turn off the VPC and not use it anymore. You can confirm a
#' virtual private gateway has been completely detached from a VPC by
#' describing the virtual private gateway (any attachments to the virtual
#' private gateway are also described).
#' 
#' You must wait for the attachment\'s state to switch to `detached` before
#' you can delete the VPC or attach a different VPC to the virtual private
#' gateway.
#'
#' @usage
#' ec2_detach_vpn_gateway(VpcId, VpnGatewayId, DryRun)
#'
#' @param VpcId &#91;required&#93; The ID of the VPC.
#' @param VpnGatewayId &#91;required&#93; The ID of the virtual private gateway.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$detach_vpn_gateway(
#'   VpcId = "string",
#'   VpnGatewayId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_detach_vpn_gateway
ec2_detach_vpn_gateway <- function(VpcId, VpnGatewayId, DryRun = NULL) {
  op <- new_operation(
    name = "DetachVpnGateway",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$detach_vpn_gateway_input(VpcId = VpcId, VpnGatewayId = VpnGatewayId, DryRun = DryRun)
  output <- .ec2$detach_vpn_gateway_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$detach_vpn_gateway <- ec2_detach_vpn_gateway

#' Disables EBS encryption by default for your account in the current
#' Region
#'
#' Disables EBS encryption by default for your account in the current
#' Region.
#' 
#' After you disable encryption by default, you can still create encrypted
#' volumes by enabling encryption when you create each volume.
#' 
#' Disabling encryption by default does not change the encryption status of
#' your existing volumes.
#' 
#' For more information, see [Amazon EBS
#' Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_disable_ebs_encryption_by_default(DryRun)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$disable_ebs_encryption_by_default(
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_disable_ebs_encryption_by_default
ec2_disable_ebs_encryption_by_default <- function(DryRun = NULL) {
  op <- new_operation(
    name = "DisableEbsEncryptionByDefault",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$disable_ebs_encryption_by_default_input(DryRun = DryRun)
  output <- .ec2$disable_ebs_encryption_by_default_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disable_ebs_encryption_by_default <- ec2_disable_ebs_encryption_by_default

#' Disables fast snapshot restores for the specified snapshots in the
#' specified Availability Zones
#'
#' Disables fast snapshot restores for the specified snapshots in the
#' specified Availability Zones.
#'
#' @usage
#' ec2_disable_fast_snapshot_restores(AvailabilityZones, SourceSnapshotIds,
#'   DryRun)
#'
#' @param AvailabilityZones &#91;required&#93; One or more Availability Zones. For example, `us-east-2a`.
#' @param SourceSnapshotIds &#91;required&#93; The IDs of one or more snapshots. For example, `snap-1234567890abcdef0`.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$disable_fast_snapshot_restores(
#'   AvailabilityZones = list(
#'     "string"
#'   ),
#'   SourceSnapshotIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_disable_fast_snapshot_restores
ec2_disable_fast_snapshot_restores <- function(AvailabilityZones, SourceSnapshotIds, DryRun = NULL) {
  op <- new_operation(
    name = "DisableFastSnapshotRestores",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$disable_fast_snapshot_restores_input(AvailabilityZones = AvailabilityZones, SourceSnapshotIds = SourceSnapshotIds, DryRun = DryRun)
  output <- .ec2$disable_fast_snapshot_restores_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disable_fast_snapshot_restores <- ec2_disable_fast_snapshot_restores

#' Disables the specified resource attachment from propagating routes to
#' the specified propagation route table
#'
#' Disables the specified resource attachment from propagating routes to
#' the specified propagation route table.
#'
#' @usage
#' ec2_disable_transit_gateway_route_table_propagation(
#'   TransitGatewayRouteTableId, TransitGatewayAttachmentId, DryRun)
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the propagation route table.
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$disable_transit_gateway_route_table_propagation(
#'   TransitGatewayRouteTableId = "string",
#'   TransitGatewayAttachmentId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_disable_transit_gateway_route_table_propagation
ec2_disable_transit_gateway_route_table_propagation <- function(TransitGatewayRouteTableId, TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "DisableTransitGatewayRouteTablePropagation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$disable_transit_gateway_route_table_propagation_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$disable_transit_gateway_route_table_propagation_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disable_transit_gateway_route_table_propagation <- ec2_disable_transit_gateway_route_table_propagation

#' Disables a virtual private gateway (VGW) from propagating routes to a
#' specified route table of a VPC
#'
#' Disables a virtual private gateway (VGW) from propagating routes to a
#' specified route table of a VPC.
#'
#' @usage
#' ec2_disable_vgw_route_propagation(GatewayId, RouteTableId)
#'
#' @param GatewayId &#91;required&#93; The ID of the virtual private gateway.
#' @param RouteTableId &#91;required&#93; The ID of the route table.
#'
#' @section Request syntax:
#' ```
#' svc$disable_vgw_route_propagation(
#'   GatewayId = "string",
#'   RouteTableId = "string"
#' )
#' ```
#'
#' @examples
#' # This example disables the specified virtual private gateway from
#' # propagating static routes to the specified route table.
#' \dontrun{svc$disable_vgw_route_propagation(
#'   GatewayId = "vgw-9a4cacf3",
#'   RouteTableId = "rtb-22574640"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_disable_vgw_route_propagation
ec2_disable_vgw_route_propagation <- function(GatewayId, RouteTableId) {
  op <- new_operation(
    name = "DisableVgwRoutePropagation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$disable_vgw_route_propagation_input(GatewayId = GatewayId, RouteTableId = RouteTableId)
  output <- .ec2$disable_vgw_route_propagation_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disable_vgw_route_propagation <- ec2_disable_vgw_route_propagation

#' Disables ClassicLink for a VPC
#'
#' Disables ClassicLink for a VPC. You cannot disable ClassicLink for a VPC
#' that has EC2-Classic instances linked to it.
#'
#' @usage
#' ec2_disable_vpc_classic_link(DryRun, VpcId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#'
#' @section Request syntax:
#' ```
#' svc$disable_vpc_classic_link(
#'   DryRun = TRUE|FALSE,
#'   VpcId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_disable_vpc_classic_link
ec2_disable_vpc_classic_link <- function(DryRun = NULL, VpcId) {
  op <- new_operation(
    name = "DisableVpcClassicLink",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$disable_vpc_classic_link_input(DryRun = DryRun, VpcId = VpcId)
  output <- .ec2$disable_vpc_classic_link_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disable_vpc_classic_link <- ec2_disable_vpc_classic_link

#' Disables ClassicLink DNS support for a VPC
#'
#' Disables ClassicLink DNS support for a VPC. If disabled, DNS hostnames
#' resolve to public IP addresses when addressed between a linked
#' EC2-Classic instance and instances in the VPC to which it\'s linked. For
#' more information, see
#' [ClassicLink](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_disable_vpc_classic_link_dns_support(VpcId)
#'
#' @param VpcId The ID of the VPC.
#'
#' @section Request syntax:
#' ```
#' svc$disable_vpc_classic_link_dns_support(
#'   VpcId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_disable_vpc_classic_link_dns_support
ec2_disable_vpc_classic_link_dns_support <- function(VpcId = NULL) {
  op <- new_operation(
    name = "DisableVpcClassicLinkDnsSupport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$disable_vpc_classic_link_dns_support_input(VpcId = VpcId)
  output <- .ec2$disable_vpc_classic_link_dns_support_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disable_vpc_classic_link_dns_support <- ec2_disable_vpc_classic_link_dns_support

#' Disassociates an Elastic IP address from the instance or network
#' interface it's associated with
#'
#' Disassociates an Elastic IP address from the instance or network
#' interface it\'s associated with.
#' 
#' An Elastic IP address is for use in either the EC2-Classic platform or
#' in a VPC. For more information, see [Elastic IP
#' Addresses](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/elastic-ip-addresses-eip.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' This is an idempotent operation. If you perform the operation more than
#' once, Amazon EC2 doesn\'t return an error.
#'
#' @usage
#' ec2_disassociate_address(AssociationId, PublicIp, DryRun)
#'
#' @param AssociationId \[EC2-VPC\] The association ID. Required for EC2-VPC.
#' @param PublicIp \[EC2-Classic\] The Elastic IP address. Required for EC2-Classic.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_address(
#'   AssociationId = "string",
#'   PublicIp = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example disassociates an Elastic IP address from an instance in a
#' # VPC.
#' \dontrun{svc$disassociate_address(
#'   AssociationId = "eipassoc-2bebb745"
#' )}
#' 
#' # This example disassociates an Elastic IP address from an instance in
#' # EC2-Classic.
#' \dontrun{svc$disassociate_address(
#'   PublicIp = "198.51.100.0"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_disassociate_address
ec2_disassociate_address <- function(AssociationId = NULL, PublicIp = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DisassociateAddress",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$disassociate_address_input(AssociationId = AssociationId, PublicIp = PublicIp, DryRun = DryRun)
  output <- .ec2$disassociate_address_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disassociate_address <- ec2_disassociate_address

#' Disassociates a target network from the specified Client VPN endpoint
#'
#' Disassociates a target network from the specified Client VPN endpoint.
#' When you disassociate the last target network from a Client VPN, the
#' following happens:
#' 
#' -   The route that was automatically added for the VPC is deleted
#' 
#' -   All active client connections are terminated
#' 
#' -   New client connections are disallowed
#' 
#' -   The Client VPN endpoint\'s status changes to `pending-associate`
#'
#' @usage
#' ec2_disassociate_client_vpn_target_network(ClientVpnEndpointId,
#'   AssociationId, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint from which to disassociate the target
#' network.
#' @param AssociationId &#91;required&#93; The ID of the target network association.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_client_vpn_target_network(
#'   ClientVpnEndpointId = "string",
#'   AssociationId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_disassociate_client_vpn_target_network
ec2_disassociate_client_vpn_target_network <- function(ClientVpnEndpointId, AssociationId, DryRun = NULL) {
  op <- new_operation(
    name = "DisassociateClientVpnTargetNetwork",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$disassociate_client_vpn_target_network_input(ClientVpnEndpointId = ClientVpnEndpointId, AssociationId = AssociationId, DryRun = DryRun)
  output <- .ec2$disassociate_client_vpn_target_network_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disassociate_client_vpn_target_network <- ec2_disassociate_client_vpn_target_network

#' Disassociates an IAM instance profile from a running or stopped instance
#'
#' Disassociates an IAM instance profile from a running or stopped
#' instance.
#' 
#' Use DescribeIamInstanceProfileAssociations to get the association ID.
#'
#' @usage
#' ec2_disassociate_iam_instance_profile(AssociationId)
#'
#' @param AssociationId &#91;required&#93; The ID of the IAM instance profile association.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_iam_instance_profile(
#'   AssociationId = "string"
#' )
#' ```
#'
#' @examples
#' # This example disassociates the specified IAM instance profile from an
#' # instance.
#' \dontrun{svc$disassociate_iam_instance_profile(
#'   AssociationId = "iip-assoc-05020b59952902f5f"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_disassociate_iam_instance_profile
ec2_disassociate_iam_instance_profile <- function(AssociationId) {
  op <- new_operation(
    name = "DisassociateIamInstanceProfile",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$disassociate_iam_instance_profile_input(AssociationId = AssociationId)
  output <- .ec2$disassociate_iam_instance_profile_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disassociate_iam_instance_profile <- ec2_disassociate_iam_instance_profile

#' Disassociates a subnet from a route table
#'
#' Disassociates a subnet from a route table.
#' 
#' After you perform this action, the subnet no longer uses the routes in
#' the route table. Instead, it uses the routes in the VPC\'s main route
#' table. For more information about route tables, see [Route
#' Tables](https://docs.aws.amazon.com/vpc/latest/userguide/VPC_Route_Tables.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_disassociate_route_table(AssociationId, DryRun)
#'
#' @param AssociationId &#91;required&#93; The association ID representing the current association between the
#' route table and subnet.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_route_table(
#'   AssociationId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example disassociates the specified route table from its associated
#' # subnet.
#' \dontrun{svc$disassociate_route_table(
#'   AssociationId = "rtbassoc-781d0d1a"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_disassociate_route_table
ec2_disassociate_route_table <- function(AssociationId, DryRun = NULL) {
  op <- new_operation(
    name = "DisassociateRouteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$disassociate_route_table_input(AssociationId = AssociationId, DryRun = DryRun)
  output <- .ec2$disassociate_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disassociate_route_table <- ec2_disassociate_route_table

#' Disassociates a CIDR block from a subnet
#'
#' Disassociates a CIDR block from a subnet. Currently, you can
#' disassociate an IPv6 CIDR block only. You must detach or delete all
#' gateways and resources that are associated with the CIDR block before
#' you can disassociate it.
#'
#' @usage
#' ec2_disassociate_subnet_cidr_block(AssociationId)
#'
#' @param AssociationId &#91;required&#93; The association ID for the CIDR block.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_subnet_cidr_block(
#'   AssociationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_disassociate_subnet_cidr_block
ec2_disassociate_subnet_cidr_block <- function(AssociationId) {
  op <- new_operation(
    name = "DisassociateSubnetCidrBlock",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$disassociate_subnet_cidr_block_input(AssociationId = AssociationId)
  output <- .ec2$disassociate_subnet_cidr_block_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disassociate_subnet_cidr_block <- ec2_disassociate_subnet_cidr_block

#' Disassociates the specified subnets from the transit gateway multicast
#' domain
#'
#' Disassociates the specified subnets from the transit gateway multicast
#' domain.
#'
#' @usage
#' ec2_disassociate_transit_gateway_multicast_domain(
#'   TransitGatewayMulticastDomainId, TransitGatewayAttachmentId, SubnetIds,
#'   DryRun)
#'
#' @param TransitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
#' @param TransitGatewayAttachmentId The ID of the attachment.
#' @param SubnetIds The IDs of the subnets;
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_transit_gateway_multicast_domain(
#'   TransitGatewayMulticastDomainId = "string",
#'   TransitGatewayAttachmentId = "string",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_disassociate_transit_gateway_multicast_domain
ec2_disassociate_transit_gateway_multicast_domain <- function(TransitGatewayMulticastDomainId = NULL, TransitGatewayAttachmentId = NULL, SubnetIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "DisassociateTransitGatewayMulticastDomain",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$disassociate_transit_gateway_multicast_domain_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, SubnetIds = SubnetIds, DryRun = DryRun)
  output <- .ec2$disassociate_transit_gateway_multicast_domain_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disassociate_transit_gateway_multicast_domain <- ec2_disassociate_transit_gateway_multicast_domain

#' Disassociates a resource attachment from a transit gateway route table
#'
#' Disassociates a resource attachment from a transit gateway route table.
#'
#' @usage
#' ec2_disassociate_transit_gateway_route_table(TransitGatewayRouteTableId,
#'   TransitGatewayAttachmentId, DryRun)
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_transit_gateway_route_table(
#'   TransitGatewayRouteTableId = "string",
#'   TransitGatewayAttachmentId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_disassociate_transit_gateway_route_table
ec2_disassociate_transit_gateway_route_table <- function(TransitGatewayRouteTableId, TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "DisassociateTransitGatewayRouteTable",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$disassociate_transit_gateway_route_table_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$disassociate_transit_gateway_route_table_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disassociate_transit_gateway_route_table <- ec2_disassociate_transit_gateway_route_table

#' Disassociates a CIDR block from a VPC
#'
#' Disassociates a CIDR block from a VPC. To disassociate the CIDR block,
#' you must specify its association ID. You can get the association ID by
#' using DescribeVpcs. You must detach or delete all gateways and resources
#' that are associated with the CIDR block before you can disassociate it.
#' 
#' You cannot disassociate the CIDR block with which you originally created
#' the VPC (the primary CIDR block).
#'
#' @usage
#' ec2_disassociate_vpc_cidr_block(AssociationId)
#'
#' @param AssociationId &#91;required&#93; The association ID for the CIDR block.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_vpc_cidr_block(
#'   AssociationId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_disassociate_vpc_cidr_block
ec2_disassociate_vpc_cidr_block <- function(AssociationId) {
  op <- new_operation(
    name = "DisassociateVpcCidrBlock",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$disassociate_vpc_cidr_block_input(AssociationId = AssociationId)
  output <- .ec2$disassociate_vpc_cidr_block_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$disassociate_vpc_cidr_block <- ec2_disassociate_vpc_cidr_block

#' Enables EBS encryption by default for your account in the current Region
#'
#' Enables EBS encryption by default for your account in the current
#' Region.
#' 
#' After you enable encryption by default, the EBS volumes that you create
#' are are always encrypted, either using the default CMK or the CMK that
#' you specified when you created each volume. For more information, see
#' [Amazon EBS
#' Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' You can specify the default CMK for encryption by default using
#' ModifyEbsDefaultKmsKeyId or ResetEbsDefaultKmsKeyId.
#' 
#' Enabling encryption by default has no effect on the encryption status of
#' your existing volumes.
#' 
#' After you enable encryption by default, you can no longer launch
#' instances using instance types that do not support encryption. For more
#' information, see [Supported Instance
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html#EBSEncryption_supported_instances).
#'
#' @usage
#' ec2_enable_ebs_encryption_by_default(DryRun)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$enable_ebs_encryption_by_default(
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_enable_ebs_encryption_by_default
ec2_enable_ebs_encryption_by_default <- function(DryRun = NULL) {
  op <- new_operation(
    name = "EnableEbsEncryptionByDefault",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$enable_ebs_encryption_by_default_input(DryRun = DryRun)
  output <- .ec2$enable_ebs_encryption_by_default_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$enable_ebs_encryption_by_default <- ec2_enable_ebs_encryption_by_default

#' Enables fast snapshot restores for the specified snapshots in the
#' specified Availability Zones
#'
#' Enables fast snapshot restores for the specified snapshots in the
#' specified Availability Zones.
#' 
#' You get the full benefit of fast snapshot restores after they enter the
#' `enabled` state. To get the current state of fast snapshot restores, use
#' DescribeFastSnapshotRestores. To disable fast snapshot restores, use
#' DisableFastSnapshotRestores.
#'
#' @usage
#' ec2_enable_fast_snapshot_restores(AvailabilityZones, SourceSnapshotIds,
#'   DryRun)
#'
#' @param AvailabilityZones &#91;required&#93; One or more Availability Zones. For example, `us-east-2a`.
#' @param SourceSnapshotIds &#91;required&#93; The IDs of one or more snapshots. For example, `snap-1234567890abcdef0`.
#' You can specify a snapshot that was shared with you from another AWS
#' account.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$enable_fast_snapshot_restores(
#'   AvailabilityZones = list(
#'     "string"
#'   ),
#'   SourceSnapshotIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_enable_fast_snapshot_restores
ec2_enable_fast_snapshot_restores <- function(AvailabilityZones, SourceSnapshotIds, DryRun = NULL) {
  op <- new_operation(
    name = "EnableFastSnapshotRestores",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$enable_fast_snapshot_restores_input(AvailabilityZones = AvailabilityZones, SourceSnapshotIds = SourceSnapshotIds, DryRun = DryRun)
  output <- .ec2$enable_fast_snapshot_restores_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$enable_fast_snapshot_restores <- ec2_enable_fast_snapshot_restores

#' Enables the specified attachment to propagate routes to the specified
#' propagation route table
#'
#' Enables the specified attachment to propagate routes to the specified
#' propagation route table.
#'
#' @usage
#' ec2_enable_transit_gateway_route_table_propagation(
#'   TransitGatewayRouteTableId, TransitGatewayAttachmentId, DryRun)
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the propagation route table.
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the attachment.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$enable_transit_gateway_route_table_propagation(
#'   TransitGatewayRouteTableId = "string",
#'   TransitGatewayAttachmentId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_enable_transit_gateway_route_table_propagation
ec2_enable_transit_gateway_route_table_propagation <- function(TransitGatewayRouteTableId, TransitGatewayAttachmentId, DryRun = NULL) {
  op <- new_operation(
    name = "EnableTransitGatewayRouteTablePropagation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$enable_transit_gateway_route_table_propagation_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, TransitGatewayAttachmentId = TransitGatewayAttachmentId, DryRun = DryRun)
  output <- .ec2$enable_transit_gateway_route_table_propagation_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$enable_transit_gateway_route_table_propagation <- ec2_enable_transit_gateway_route_table_propagation

#' Enables a virtual private gateway (VGW) to propagate routes to the
#' specified route table of a VPC
#'
#' Enables a virtual private gateway (VGW) to propagate routes to the
#' specified route table of a VPC.
#'
#' @usage
#' ec2_enable_vgw_route_propagation(GatewayId, RouteTableId)
#'
#' @param GatewayId &#91;required&#93; The ID of the virtual private gateway that is attached to a VPC. The
#' virtual private gateway must be attached to the same VPC that the
#' routing tables are associated with.
#' @param RouteTableId &#91;required&#93; The ID of the route table. The routing table must be associated with the
#' same VPC that the virtual private gateway is attached to.
#'
#' @section Request syntax:
#' ```
#' svc$enable_vgw_route_propagation(
#'   GatewayId = "string",
#'   RouteTableId = "string"
#' )
#' ```
#'
#' @examples
#' # This example enables the specified virtual private gateway to propagate
#' # static routes to the specified route table.
#' \dontrun{svc$enable_vgw_route_propagation(
#'   GatewayId = "vgw-9a4cacf3",
#'   RouteTableId = "rtb-22574640"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_enable_vgw_route_propagation
ec2_enable_vgw_route_propagation <- function(GatewayId, RouteTableId) {
  op <- new_operation(
    name = "EnableVgwRoutePropagation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$enable_vgw_route_propagation_input(GatewayId = GatewayId, RouteTableId = RouteTableId)
  output <- .ec2$enable_vgw_route_propagation_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$enable_vgw_route_propagation <- ec2_enable_vgw_route_propagation

#' Enables I/O operations for a volume that had I/O operations disabled
#' because the data on the volume was potentially inconsistent
#'
#' Enables I/O operations for a volume that had I/O operations disabled
#' because the data on the volume was potentially inconsistent.
#'
#' @usage
#' ec2_enable_volume_io(DryRun, VolumeId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VolumeId &#91;required&#93; The ID of the volume.
#'
#' @section Request syntax:
#' ```
#' svc$enable_volume_io(
#'   DryRun = TRUE|FALSE,
#'   VolumeId = "string"
#' )
#' ```
#'
#' @examples
#' # This example enables I/O on volume `vol-1234567890abcdef0`.
#' \dontrun{svc$enable_volume_io(
#'   VolumeId = "vol-1234567890abcdef0"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_enable_volume_io
ec2_enable_volume_io <- function(DryRun = NULL, VolumeId) {
  op <- new_operation(
    name = "EnableVolumeIO",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$enable_volume_io_input(DryRun = DryRun, VolumeId = VolumeId)
  output <- .ec2$enable_volume_io_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$enable_volume_io <- ec2_enable_volume_io

#' Enables a VPC for ClassicLink
#'
#' Enables a VPC for ClassicLink. You can then link EC2-Classic instances
#' to your ClassicLink-enabled VPC to allow communication over private IP
#' addresses. You cannot enable your VPC for ClassicLink if any of your VPC
#' route tables have existing routes for address ranges within the
#' `10.0.0.0/8` IP address range, excluding local routes for VPCs in the
#' `10.0.0.0/16` and `10.1.0.0/16` IP address ranges. For more information,
#' see
#' [ClassicLink](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_enable_vpc_classic_link(DryRun, VpcId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#'
#' @section Request syntax:
#' ```
#' svc$enable_vpc_classic_link(
#'   DryRun = TRUE|FALSE,
#'   VpcId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_enable_vpc_classic_link
ec2_enable_vpc_classic_link <- function(DryRun = NULL, VpcId) {
  op <- new_operation(
    name = "EnableVpcClassicLink",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$enable_vpc_classic_link_input(DryRun = DryRun, VpcId = VpcId)
  output <- .ec2$enable_vpc_classic_link_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$enable_vpc_classic_link <- ec2_enable_vpc_classic_link

#' Enables a VPC to support DNS hostname resolution for ClassicLink
#'
#' Enables a VPC to support DNS hostname resolution for ClassicLink. If
#' enabled, the DNS hostname of a linked EC2-Classic instance resolves to
#' its private IP address when addressed from an instance in the VPC to
#' which it\'s linked. Similarly, the DNS hostname of an instance in a VPC
#' resolves to its private IP address when addressed from a linked
#' EC2-Classic instance. For more information, see
#' [ClassicLink](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/vpc-classiclink.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_enable_vpc_classic_link_dns_support(VpcId)
#'
#' @param VpcId The ID of the VPC.
#'
#' @section Request syntax:
#' ```
#' svc$enable_vpc_classic_link_dns_support(
#'   VpcId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_enable_vpc_classic_link_dns_support
ec2_enable_vpc_classic_link_dns_support <- function(VpcId = NULL) {
  op <- new_operation(
    name = "EnableVpcClassicLinkDnsSupport",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$enable_vpc_classic_link_dns_support_input(VpcId = VpcId)
  output <- .ec2$enable_vpc_classic_link_dns_support_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$enable_vpc_classic_link_dns_support <- ec2_enable_vpc_classic_link_dns_support

#' Downloads the client certificate revocation list for the specified
#' Client VPN endpoint
#'
#' Downloads the client certificate revocation list for the specified
#' Client VPN endpoint.
#'
#' @usage
#' ec2_export_client_vpn_client_certificate_revocation_list(
#'   ClientVpnEndpointId, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$export_client_vpn_client_certificate_revocation_list(
#'   ClientVpnEndpointId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_export_client_vpn_client_certificate_revocation_list
ec2_export_client_vpn_client_certificate_revocation_list <- function(ClientVpnEndpointId, DryRun = NULL) {
  op <- new_operation(
    name = "ExportClientVpnClientCertificateRevocationList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$export_client_vpn_client_certificate_revocation_list_input(ClientVpnEndpointId = ClientVpnEndpointId, DryRun = DryRun)
  output <- .ec2$export_client_vpn_client_certificate_revocation_list_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$export_client_vpn_client_certificate_revocation_list <- ec2_export_client_vpn_client_certificate_revocation_list

#' Downloads the contents of the Client VPN endpoint configuration file for
#' the specified Client VPN endpoint
#'
#' Downloads the contents of the Client VPN endpoint configuration file for
#' the specified Client VPN endpoint. The Client VPN endpoint configuration
#' file includes the Client VPN endpoint and certificate information
#' clients need to establish a connection with the Client VPN endpoint.
#'
#' @usage
#' ec2_export_client_vpn_client_configuration(ClientVpnEndpointId, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$export_client_vpn_client_configuration(
#'   ClientVpnEndpointId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_export_client_vpn_client_configuration
ec2_export_client_vpn_client_configuration <- function(ClientVpnEndpointId, DryRun = NULL) {
  op <- new_operation(
    name = "ExportClientVpnClientConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$export_client_vpn_client_configuration_input(ClientVpnEndpointId = ClientVpnEndpointId, DryRun = DryRun)
  output <- .ec2$export_client_vpn_client_configuration_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$export_client_vpn_client_configuration <- ec2_export_client_vpn_client_configuration

#' Exports an Amazon Machine Image (AMI) to a VM file
#'
#' Exports an Amazon Machine Image (AMI) to a VM file. For more
#' information, see [Exporting a VM Directory from an Amazon Machine Image
#' (AMI)](https://docs.aws.amazon.com/vm-import/latest/userguide/vmexport_image.html)
#' in the *VM Import/Export User Guide*.
#'
#' @usage
#' ec2_export_image(ClientToken, Description, DiskImageFormat, DryRun,
#'   ImageId, S3ExportLocation, RoleName)
#'
#' @param ClientToken Token to enable idempotency for export image requests.
#' @param Description A description of the image being exported. The maximum length is 255
#' bytes.
#' @param DiskImageFormat &#91;required&#93; The disk image format.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ImageId &#91;required&#93; The ID of the image.
#' @param S3ExportLocation &#91;required&#93; Information about the destination S3 bucket. The bucket must exist and
#' grant WRITE and READ\\_ACP permissions to the AWS account
#' vm-import-export\\@@amazon.com.
#' @param RoleName The name of the role that grants VM Import/Export permission to export
#' images to your S3 bucket. If this parameter is not specified, the
#' default role is named \'vmimport\'.
#'
#' @section Request syntax:
#' ```
#' svc$export_image(
#'   ClientToken = "string",
#'   Description = "string",
#'   DiskImageFormat = "VMDK"|"RAW"|"VHD",
#'   DryRun = TRUE|FALSE,
#'   ImageId = "string",
#'   S3ExportLocation = list(
#'     S3Bucket = "string",
#'     S3Prefix = "string"
#'   ),
#'   RoleName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_export_image
ec2_export_image <- function(ClientToken = NULL, Description = NULL, DiskImageFormat, DryRun = NULL, ImageId, S3ExportLocation, RoleName = NULL) {
  op <- new_operation(
    name = "ExportImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$export_image_input(ClientToken = ClientToken, Description = Description, DiskImageFormat = DiskImageFormat, DryRun = DryRun, ImageId = ImageId, S3ExportLocation = S3ExportLocation, RoleName = RoleName)
  output <- .ec2$export_image_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$export_image <- ec2_export_image

#' Exports routes from the specified transit gateway route table to the
#' specified S3 bucket
#'
#' Exports routes from the specified transit gateway route table to the
#' specified S3 bucket. By default, all routes are exported. Alternatively,
#' you can filter by CIDR range.
#'
#' @usage
#' ec2_export_transit_gateway_routes(TransitGatewayRouteTableId, Filters,
#'   S3Bucket, DryRun)
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the route table.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `attachment.transit-gateway-attachment-id` - The id of the transit
#'     gateway attachment.
#' 
#' -   `attachment.resource-id` - The resource id of the transit gateway
#'     attachment.
#' 
#' -   `route-search.exact-match` - The exact match of the specified
#'     filter.
#' 
#' -   `route-search.longest-prefix-match` - The longest prefix that
#'     matches the route.
#' 
#' -   `route-search.subnet-of-match` - The routes with a subnet that match
#'     the specified CIDR filter.
#' 
#' -   `route-search.supernet-of-match` - The routes with a CIDR that
#'     encompass the CIDR filter. For example, if you have 10.0.1.0/29 and
#'     10.0.1.0/31 routes in your route table and you specify
#'     supernet-of-match as 10.0.1.0/30, then the result returns
#'     10.0.1.0/29.
#' 
#' -   `state` - The state of the attachment (`available` \\| `deleted` \\|
#'     `deleting` \\| `failed` \\| `modifying` \\| `pendingAcceptance` \\|
#'     `pending` \\| `rollingBack` \\| `rejected` \\| `rejecting`).
#' 
#' -   `transit-gateway-route-destination-cidr-block` - The CIDR range.
#' 
#' -   `type` - The type of route (`active` \\| `blackhole`).
#' @param S3Bucket &#91;required&#93; The name of the S3 bucket.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$export_transit_gateway_routes(
#'   TransitGatewayRouteTableId = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   S3Bucket = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_export_transit_gateway_routes
ec2_export_transit_gateway_routes <- function(TransitGatewayRouteTableId, Filters = NULL, S3Bucket, DryRun = NULL) {
  op <- new_operation(
    name = "ExportTransitGatewayRoutes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$export_transit_gateway_routes_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, Filters = Filters, S3Bucket = S3Bucket, DryRun = DryRun)
  output <- .ec2$export_transit_gateway_routes_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$export_transit_gateway_routes <- ec2_export_transit_gateway_routes

#' Gets usage information about a Capacity Reservation
#'
#' Gets usage information about a Capacity Reservation. If the Capacity
#' Reservation is shared, it shows usage information for the Capacity
#' Reservation owner and each AWS account that is currently using the
#' shared capacity. If the Capacity Reservation is not shared, it shows
#' only the Capacity Reservation owner\'s usage.
#'
#' @usage
#' ec2_get_capacity_reservation_usage(CapacityReservationId, NextToken,
#'   MaxResults, DryRun)
#'
#' @param CapacityReservationId &#91;required&#93; The ID of the Capacity Reservation.
#' @param NextToken The token to retrieve the next page of results.
#' @param MaxResults The maximum number of results to return for the request in a single
#' page. The remaining results can be seen by sending another request with
#' the returned nextToken value.
#' 
#' Valid range: Minimum value of 1. Maximum value of 1000.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$get_capacity_reservation_usage(
#'   CapacityReservationId = "string",
#'   NextToken = "string",
#'   MaxResults = 123,
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_get_capacity_reservation_usage
ec2_get_capacity_reservation_usage <- function(CapacityReservationId, NextToken = NULL, MaxResults = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "GetCapacityReservationUsage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$get_capacity_reservation_usage_input(CapacityReservationId = CapacityReservationId, NextToken = NextToken, MaxResults = MaxResults, DryRun = DryRun)
  output <- .ec2$get_capacity_reservation_usage_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$get_capacity_reservation_usage <- ec2_get_capacity_reservation_usage

#' Describes the allocations from the specified customer-owned address pool
#'
#' Describes the allocations from the specified customer-owned address
#' pool.
#'
#' @usage
#' ec2_get_coip_pool_usage(PoolId, Filters, MaxResults, NextToken, DryRun)
#'
#' @param PoolId &#91;required&#93; The ID of the address pool.
#' @param Filters The filters. The following are the possible values:
#' 
#' -   `coip-address-usage.allocation-id`
#' 
#' <!-- -->
#' 
#' -   `coip-address-usage.aws-account-id`
#' 
#' <!-- -->
#' 
#' -   `coip-address-usage.aws-service`
#' 
#' <!-- -->
#' 
#' -   `coip-address-usage.co-ip`
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$get_coip_pool_usage(
#'   PoolId = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_get_coip_pool_usage
ec2_get_coip_pool_usage <- function(PoolId, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "GetCoipPoolUsage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$get_coip_pool_usage_input(PoolId = PoolId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$get_coip_pool_usage_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$get_coip_pool_usage <- ec2_get_coip_pool_usage

#' Gets the console output for the specified instance
#'
#' Gets the console output for the specified instance. For Linux instances,
#' the instance console output displays the exact console output that would
#' normally be displayed on a physical monitor attached to a computer. For
#' Windows instances, the instance console output includes the last three
#' system event log errors.
#' 
#' By default, the console output returns buffered information that was
#' posted shortly after an instance transition state (start, stop, reboot,
#' or terminate). This information is available for at least one hour after
#' the most recent post. Only the most recent 64 KB of console output is
#' available.
#' 
#' You can optionally retrieve the latest serial console output at any time
#' during the instance lifecycle. This option is supported on instance
#' types that use the Nitro hypervisor.
#' 
#' For more information, see [Instance Console
#' Output](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-console.html#instance-console-console-output)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_get_console_output(InstanceId, DryRun, Latest)
#'
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Latest When enabled, retrieves the latest console output for the instance.
#' 
#' Default: disabled (`false`)
#'
#' @section Request syntax:
#' ```
#' svc$get_console_output(
#'   InstanceId = "string",
#'   DryRun = TRUE|FALSE,
#'   Latest = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example gets the console output for the specified instance.
#' \dontrun{svc$get_console_output(
#'   InstanceId = "i-1234567890abcdef0"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_get_console_output
ec2_get_console_output <- function(InstanceId, DryRun = NULL, Latest = NULL) {
  op <- new_operation(
    name = "GetConsoleOutput",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$get_console_output_input(InstanceId = InstanceId, DryRun = DryRun, Latest = Latest)
  output <- .ec2$get_console_output_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$get_console_output <- ec2_get_console_output

#' Retrieve a JPG-format screenshot of a running instance to help with
#' troubleshooting
#'
#' Retrieve a JPG-format screenshot of a running instance to help with
#' troubleshooting.
#' 
#' The returned content is Base64-encoded.
#'
#' @usage
#' ec2_get_console_screenshot(DryRun, InstanceId, WakeUp)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param WakeUp When set to `true`, acts as keystroke input and wakes up an instance
#' that\'s in standby or \"sleep\" mode.
#'
#' @section Request syntax:
#' ```
#' svc$get_console_screenshot(
#'   DryRun = TRUE|FALSE,
#'   InstanceId = "string",
#'   WakeUp = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_get_console_screenshot
ec2_get_console_screenshot <- function(DryRun = NULL, InstanceId, WakeUp = NULL) {
  op <- new_operation(
    name = "GetConsoleScreenshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$get_console_screenshot_input(DryRun = DryRun, InstanceId = InstanceId, WakeUp = WakeUp)
  output <- .ec2$get_console_screenshot_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$get_console_screenshot <- ec2_get_console_screenshot

#' Describes the default credit option for CPU usage of a burstable
#' performance instance family
#'
#' Describes the default credit option for CPU usage of a burstable
#' performance instance family.
#' 
#' For more information, see [Burstable Performance
#' Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_get_default_credit_specification(DryRun, InstanceFamily)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceFamily &#91;required&#93; The instance family.
#'
#' @section Request syntax:
#' ```
#' svc$get_default_credit_specification(
#'   DryRun = TRUE|FALSE,
#'   InstanceFamily = "t2"|"t3"|"t3a"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_get_default_credit_specification
ec2_get_default_credit_specification <- function(DryRun = NULL, InstanceFamily) {
  op <- new_operation(
    name = "GetDefaultCreditSpecification",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$get_default_credit_specification_input(DryRun = DryRun, InstanceFamily = InstanceFamily)
  output <- .ec2$get_default_credit_specification_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$get_default_credit_specification <- ec2_get_default_credit_specification

#' Describes the default customer master key (CMK) for EBS encryption by
#' default for your account in this Region
#'
#' Describes the default customer master key (CMK) for EBS encryption by
#' default for your account in this Region. You can change the default CMK
#' for encryption by default using ModifyEbsDefaultKmsKeyId or
#' ResetEbsDefaultKmsKeyId.
#' 
#' For more information, see [Amazon EBS
#' Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_get_ebs_default_kms_key_id(DryRun)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$get_ebs_default_kms_key_id(
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_get_ebs_default_kms_key_id
ec2_get_ebs_default_kms_key_id <- function(DryRun = NULL) {
  op <- new_operation(
    name = "GetEbsDefaultKmsKeyId",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$get_ebs_default_kms_key_id_input(DryRun = DryRun)
  output <- .ec2$get_ebs_default_kms_key_id_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$get_ebs_default_kms_key_id <- ec2_get_ebs_default_kms_key_id

#' Describes whether EBS encryption by default is enabled for your account
#' in the current Region
#'
#' Describes whether EBS encryption by default is enabled for your account
#' in the current Region.
#' 
#' For more information, see [Amazon EBS
#' Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_get_ebs_encryption_by_default(DryRun)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$get_ebs_encryption_by_default(
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_get_ebs_encryption_by_default
ec2_get_ebs_encryption_by_default <- function(DryRun = NULL) {
  op <- new_operation(
    name = "GetEbsEncryptionByDefault",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$get_ebs_encryption_by_default_input(DryRun = DryRun)
  output <- .ec2$get_ebs_encryption_by_default_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$get_ebs_encryption_by_default <- ec2_get_ebs_encryption_by_default

#' Preview a reservation purchase with configurations that match those of
#' your Dedicated Host
#'
#' Preview a reservation purchase with configurations that match those of
#' your Dedicated Host. You must have active Dedicated Hosts in your
#' account before you purchase a reservation.
#' 
#' This is a preview of the PurchaseHostReservation action and does not
#' result in the offering being purchased.
#'
#' @usage
#' ec2_get_host_reservation_purchase_preview(HostIdSet, OfferingId)
#'
#' @param HostIdSet &#91;required&#93; The IDs of the Dedicated Hosts with which the reservation is associated.
#' @param OfferingId &#91;required&#93; The offering ID of the reservation.
#'
#' @section Request syntax:
#' ```
#' svc$get_host_reservation_purchase_preview(
#'   HostIdSet = list(
#'     "string"
#'   ),
#'   OfferingId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_get_host_reservation_purchase_preview
ec2_get_host_reservation_purchase_preview <- function(HostIdSet, OfferingId) {
  op <- new_operation(
    name = "GetHostReservationPurchasePreview",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$get_host_reservation_purchase_preview_input(HostIdSet = HostIdSet, OfferingId = OfferingId)
  output <- .ec2$get_host_reservation_purchase_preview_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$get_host_reservation_purchase_preview <- ec2_get_host_reservation_purchase_preview

#' Retrieves the configuration data of the specified instance
#'
#' Retrieves the configuration data of the specified instance. You can use
#' this data to create a launch template.
#'
#' @usage
#' ec2_get_launch_template_data(DryRun, InstanceId)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#'
#' @section Request syntax:
#' ```
#' svc$get_launch_template_data(
#'   DryRun = TRUE|FALSE,
#'   InstanceId = "string"
#' )
#' ```
#'
#' @examples
#' # This example gets the launch template data for the specified instance.
#' \dontrun{svc$get_launch_template_data(
#'   InstanceId = "0123d646e8048babc"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_get_launch_template_data
ec2_get_launch_template_data <- function(DryRun = NULL, InstanceId) {
  op <- new_operation(
    name = "GetLaunchTemplateData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$get_launch_template_data_input(DryRun = DryRun, InstanceId = InstanceId)
  output <- .ec2$get_launch_template_data_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$get_launch_template_data <- ec2_get_launch_template_data

#' Retrieves the encrypted administrator password for a running Windows
#' instance
#'
#' Retrieves the encrypted administrator password for a running Windows
#' instance.
#' 
#' The Windows password is generated at boot by the `EC2Config` service or
#' `EC2Launch` scripts (Windows Server 2016 and later). This usually only
#' happens the first time an instance is launched. For more information,
#' see
#' [EC2Config](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/UsingConfig_WinAMI.html)
#' and
#' [EC2Launch](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ec2launch.html)
#' in the Amazon Elastic Compute Cloud User Guide.
#' 
#' For the `EC2Config` service, the password is not generated for rebundled
#' AMIs unless `Ec2SetPassword` is enabled before bundling.
#' 
#' The password is encrypted using the key pair that you specified when you
#' launched the instance. You must provide the corresponding key pair file.
#' 
#' When you launch an instance, password generation and encryption may take
#' a few minutes. If you try to retrieve the password before it\'s
#' available, the output returns an empty string. We recommend that you
#' wait up to 15 minutes after launching an instance before trying to
#' retrieve the generated password.
#'
#' @usage
#' ec2_get_password_data(InstanceId, DryRun)
#'
#' @param InstanceId &#91;required&#93; The ID of the Windows instance.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$get_password_data(
#'   InstanceId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_get_password_data
ec2_get_password_data <- function(InstanceId, DryRun = NULL) {
  op <- new_operation(
    name = "GetPasswordData",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$get_password_data_input(InstanceId = InstanceId, DryRun = DryRun)
  output <- .ec2$get_password_data_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$get_password_data <- ec2_get_password_data

#' Returns a quote and exchange information for exchanging one or more
#' specified Convertible Reserved Instances for a new Convertible Reserved
#' Instance
#'
#' Returns a quote and exchange information for exchanging one or more
#' specified Convertible Reserved Instances for a new Convertible Reserved
#' Instance. If the exchange cannot be performed, the reason is returned in
#' the response. Use AcceptReservedInstancesExchangeQuote to perform the
#' exchange.
#'
#' @usage
#' ec2_get_reserved_instances_exchange_quote(DryRun, ReservedInstanceIds,
#'   TargetConfigurations)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ReservedInstanceIds &#91;required&#93; The IDs of the Convertible Reserved Instances to exchange.
#' @param TargetConfigurations The configuration of the target Convertible Reserved Instance to
#' exchange for your current Convertible Reserved Instances.
#'
#' @section Request syntax:
#' ```
#' svc$get_reserved_instances_exchange_quote(
#'   DryRun = TRUE|FALSE,
#'   ReservedInstanceIds = list(
#'     "string"
#'   ),
#'   TargetConfigurations = list(
#'     list(
#'       InstanceCount = 123,
#'       OfferingId = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_get_reserved_instances_exchange_quote
ec2_get_reserved_instances_exchange_quote <- function(DryRun = NULL, ReservedInstanceIds, TargetConfigurations = NULL) {
  op <- new_operation(
    name = "GetReservedInstancesExchangeQuote",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$get_reserved_instances_exchange_quote_input(DryRun = DryRun, ReservedInstanceIds = ReservedInstanceIds, TargetConfigurations = TargetConfigurations)
  output <- .ec2$get_reserved_instances_exchange_quote_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$get_reserved_instances_exchange_quote <- ec2_get_reserved_instances_exchange_quote

#' Lists the route tables to which the specified resource attachment
#' propagates routes
#'
#' Lists the route tables to which the specified resource attachment
#' propagates routes.
#'
#' @usage
#' ec2_get_transit_gateway_attachment_propagations(
#'   TransitGatewayAttachmentId, Filters, MaxResults, NextToken, DryRun)
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the attachment.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `transit-gateway-route-table-id` - The ID of the transit gateway
#'     route table.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$get_transit_gateway_attachment_propagations(
#'   TransitGatewayAttachmentId = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_get_transit_gateway_attachment_propagations
ec2_get_transit_gateway_attachment_propagations <- function(TransitGatewayAttachmentId, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "GetTransitGatewayAttachmentPropagations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$get_transit_gateway_attachment_propagations_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$get_transit_gateway_attachment_propagations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$get_transit_gateway_attachment_propagations <- ec2_get_transit_gateway_attachment_propagations

#' Gets information about the associations for the transit gateway
#' multicast domain
#'
#' Gets information about the associations for the transit gateway
#' multicast domain.
#'
#' @usage
#' ec2_get_transit_gateway_multicast_domain_associations(
#'   TransitGatewayMulticastDomainId, Filters, MaxResults, NextToken, DryRun)
#'
#' @param TransitGatewayMulticastDomainId The ID of the transit gateway multicast domain.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `resource-id` - The ID of the resource.
#' 
#' -   `resource-type` - The type of resource. The valid value is: `vpc`.
#' 
#' -   `state` - The state of the subnet association. Valid values are
#'     `associated` \\| `associating` \\| `disassociated` \\|
#'     `disassociating`.
#' 
#' -   `subnet-id` - The ID of the subnet.
#' 
#' -   `transit-gateway-attachment-id` - The id of the transit gateway
#'     attachment.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$get_transit_gateway_multicast_domain_associations(
#'   TransitGatewayMulticastDomainId = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_get_transit_gateway_multicast_domain_associations
ec2_get_transit_gateway_multicast_domain_associations <- function(TransitGatewayMulticastDomainId = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "GetTransitGatewayMulticastDomainAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$get_transit_gateway_multicast_domain_associations_input(TransitGatewayMulticastDomainId = TransitGatewayMulticastDomainId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$get_transit_gateway_multicast_domain_associations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$get_transit_gateway_multicast_domain_associations <- ec2_get_transit_gateway_multicast_domain_associations

#' Gets information about the associations for the specified transit
#' gateway route table
#'
#' Gets information about the associations for the specified transit
#' gateway route table.
#'
#' @usage
#' ec2_get_transit_gateway_route_table_associations(
#'   TransitGatewayRouteTableId, Filters, MaxResults, NextToken, DryRun)
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `resource-id` - The ID of the resource.
#' 
#' -   `resource-type` - The resource type (`vpc` \\| `vpn`).
#' 
#' -   `transit-gateway-attachment-id` - The ID of the attachment.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$get_transit_gateway_route_table_associations(
#'   TransitGatewayRouteTableId = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_get_transit_gateway_route_table_associations
ec2_get_transit_gateway_route_table_associations <- function(TransitGatewayRouteTableId, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "GetTransitGatewayRouteTableAssociations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$get_transit_gateway_route_table_associations_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$get_transit_gateway_route_table_associations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$get_transit_gateway_route_table_associations <- ec2_get_transit_gateway_route_table_associations

#' Gets information about the route table propagations for the specified
#' transit gateway route table
#'
#' Gets information about the route table propagations for the specified
#' transit gateway route table.
#'
#' @usage
#' ec2_get_transit_gateway_route_table_propagations(
#'   TransitGatewayRouteTableId, Filters, MaxResults, NextToken, DryRun)
#'
#' @param TransitGatewayRouteTableId &#91;required&#93; The ID of the transit gateway route table.
#' @param Filters One or more filters. The possible values are:
#' 
#' -   `resource-id` - The ID of the resource.
#' 
#' -   `resource-type` - The resource type (`vpc` \\| `vpn`).
#' 
#' -   `transit-gateway-attachment-id` - The ID of the attachment.
#' @param MaxResults The maximum number of results to return with a single call. To retrieve
#' the remaining results, make another call with the returned `nextToken`
#' value.
#' @param NextToken The token for the next page of results.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$get_transit_gateway_route_table_propagations(
#'   TransitGatewayRouteTableId = "string",
#'   Filters = list(
#'     list(
#'       Name = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_get_transit_gateway_route_table_propagations
ec2_get_transit_gateway_route_table_propagations <- function(TransitGatewayRouteTableId, Filters = NULL, MaxResults = NULL, NextToken = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "GetTransitGatewayRouteTablePropagations",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$get_transit_gateway_route_table_propagations_input(TransitGatewayRouteTableId = TransitGatewayRouteTableId, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken, DryRun = DryRun)
  output <- .ec2$get_transit_gateway_route_table_propagations_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$get_transit_gateway_route_table_propagations <- ec2_get_transit_gateway_route_table_propagations

#' Uploads a client certificate revocation list to the specified Client VPN
#' endpoint
#'
#' Uploads a client certificate revocation list to the specified Client VPN
#' endpoint. Uploading a client certificate revocation list overwrites the
#' existing client certificate revocation list.
#' 
#' Uploading a client certificate revocation list resets existing client
#' connections.
#'
#' @usage
#' ec2_import_client_vpn_client_certificate_revocation_list(
#'   ClientVpnEndpointId, CertificateRevocationList, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint to which the client certificate
#' revocation list applies.
#' @param CertificateRevocationList &#91;required&#93; The client certificate revocation list file. For more information, see
#' [Generate a Client Certificate Revocation
#' List](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/cvpn-working-certificates.html#cvpn-working-certificates-generate)
#' in the *AWS Client VPN Administrator Guide*.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$import_client_vpn_client_certificate_revocation_list(
#'   ClientVpnEndpointId = "string",
#'   CertificateRevocationList = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_import_client_vpn_client_certificate_revocation_list
ec2_import_client_vpn_client_certificate_revocation_list <- function(ClientVpnEndpointId, CertificateRevocationList, DryRun = NULL) {
  op <- new_operation(
    name = "ImportClientVpnClientCertificateRevocationList",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$import_client_vpn_client_certificate_revocation_list_input(ClientVpnEndpointId = ClientVpnEndpointId, CertificateRevocationList = CertificateRevocationList, DryRun = DryRun)
  output <- .ec2$import_client_vpn_client_certificate_revocation_list_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$import_client_vpn_client_certificate_revocation_list <- ec2_import_client_vpn_client_certificate_revocation_list

#' Import single or multi-volume disk images or EBS snapshots into an
#' Amazon Machine Image (AMI)
#'
#' Import single or multi-volume disk images or EBS snapshots into an
#' Amazon Machine Image (AMI). For more information, see [Importing a VM as
#' an Image Using VM
#' Import/Export](https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html)
#' in the *VM Import/Export User Guide*.
#'
#' @usage
#' ec2_import_image(Architecture, ClientData, ClientToken, Description,
#'   DiskContainers, DryRun, Encrypted, Hypervisor, KmsKeyId, LicenseType,
#'   Platform, RoleName, LicenseSpecifications)
#'
#' @param Architecture The architecture of the virtual machine.
#' 
#' Valid values: `i386` \\| `x86_64` \\| `arm64`
#' @param ClientData The client-specific data.
#' @param ClientToken The token to enable idempotency for VM import requests.
#' @param Description A description string for the import image task.
#' @param DiskContainers Information about the disk containers.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Encrypted Specifies whether the destination AMI of the imported image should be
#' encrypted. The default CMK for EBS is used unless you specify a
#' non-default AWS Key Management Service (AWS KMS) CMK using `KmsKeyId`.
#' For more information, see [Amazon EBS
#' Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param Hypervisor The target hypervisor platform.
#' 
#' Valid values: `xen`
#' @param KmsKeyId An identifier for the symmetric AWS Key Management Service (AWS KMS)
#' customer master key (CMK) to use when creating the encrypted AMI. This
#' parameter is only required if you want to use a non-default CMK; if this
#' parameter is not specified, the default CMK for EBS is used. If a
#' `KmsKeyId` is specified, the `Encrypted` flag must also be set.
#' 
#' The CMK identifier may be provided in any of the following formats:
#' 
#' -   Key ID
#' 
#' -   Key alias. The alias ARN contains the `arn:aws:kms` namespace,
#'     followed by the Region of the CMK, the AWS account ID of the CMK
#'     owner, the `alias` namespace, and then the CMK alias. For example,
#'     arn:aws:kms:*us-east-1*:*012345678910*:alias/*ExampleAlias*.
#' 
#' -   ARN using key ID. The ID ARN contains the `arn:aws:kms` namespace,
#'     followed by the Region of the CMK, the AWS account ID of the CMK
#'     owner, the `key` namespace, and then the CMK ID. For example,
#'     arn:aws:kms:*us-east-1*:*012345678910*:key/*abcd1234-a123-456a-a12b-a123b4cd56ef*.
#' 
#' -   ARN using key alias. The alias ARN contains the `arn:aws:kms`
#'     namespace, followed by the Region of the CMK, the AWS account ID of
#'     the CMK owner, the `alias` namespace, and then the CMK alias. For
#'     example,
#'     arn:aws:kms:*us-east-1*:*012345678910*:alias/*ExampleAlias*.
#' 
#' AWS parses `KmsKeyId` asynchronously, meaning that the action you call
#' may appear to complete even though you provided an invalid identifier.
#' This action will eventually report failure.
#' 
#' The specified CMK must exist in the Region that the AMI is being copied
#' to.
#' 
#' Amazon EBS does not support asymmetric CMKs.
#' @param LicenseType The license type to be used for the Amazon Machine Image (AMI) after
#' importing.
#' 
#' By default, we detect the source-system operating system (OS) and apply
#' the appropriate license. Specify `AWS` to replace the source-system
#' license with an AWS license, if appropriate. Specify `BYOL` to retain
#' the source-system license, if appropriate.
#' 
#' To use `BYOL`, you must have existing licenses with rights to use these
#' licenses in a third party cloud, such as AWS. For more information, see
#' [Prerequisites](https://docs.aws.amazon.com/vm-import/latest/userguide/vmimport-image-import.html#prerequisites-image)
#' in the VM Import/Export User Guide.
#' @param Platform The operating system of the virtual machine.
#' 
#' Valid values: `Windows` \\| `Linux`
#' @param RoleName The name of the role to use when not using the default role,
#' \'vmimport\'.
#' @param LicenseSpecifications The ARNs of the license configurations.
#'
#' @section Request syntax:
#' ```
#' svc$import_image(
#'   Architecture = "string",
#'   ClientData = list(
#'     Comment = "string",
#'     UploadEnd = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     UploadSize = 123.0,
#'     UploadStart = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   ClientToken = "string",
#'   Description = "string",
#'   DiskContainers = list(
#'     list(
#'       Description = "string",
#'       DeviceName = "string",
#'       Format = "string",
#'       SnapshotId = "string",
#'       Url = "string",
#'       UserBucket = list(
#'         S3Bucket = "string",
#'         S3Key = "string"
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   Encrypted = TRUE|FALSE,
#'   Hypervisor = "string",
#'   KmsKeyId = "string",
#'   LicenseType = "string",
#'   Platform = "string",
#'   RoleName = "string",
#'   LicenseSpecifications = list(
#'     list(
#'       LicenseConfigurationArn = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_import_image
ec2_import_image <- function(Architecture = NULL, ClientData = NULL, ClientToken = NULL, Description = NULL, DiskContainers = NULL, DryRun = NULL, Encrypted = NULL, Hypervisor = NULL, KmsKeyId = NULL, LicenseType = NULL, Platform = NULL, RoleName = NULL, LicenseSpecifications = NULL) {
  op <- new_operation(
    name = "ImportImage",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$import_image_input(Architecture = Architecture, ClientData = ClientData, ClientToken = ClientToken, Description = Description, DiskContainers = DiskContainers, DryRun = DryRun, Encrypted = Encrypted, Hypervisor = Hypervisor, KmsKeyId = KmsKeyId, LicenseType = LicenseType, Platform = Platform, RoleName = RoleName, LicenseSpecifications = LicenseSpecifications)
  output <- .ec2$import_image_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$import_image <- ec2_import_image

#' Creates an import instance task using metadata from the specified disk
#' image
#'
#' Creates an import instance task using metadata from the specified disk
#' image. `ImportInstance` only supports single-volume VMs. To import
#' multi-volume VMs, use ImportImage. For more information, see [Importing
#' a Virtual Machine Using the Amazon EC2
#' CLI](https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/ec2-cli-vmimport-export.html).
#' 
#' For information about the import manifest referenced by this API action,
#' see [VM Import
#' Manifest](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html).
#'
#' @usage
#' ec2_import_instance(Description, DiskImages, DryRun,
#'   LaunchSpecification, Platform)
#'
#' @param Description A description for the instance being imported.
#' @param DiskImages The disk image.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param LaunchSpecification The launch specification.
#' @param Platform &#91;required&#93; The instance operating system.
#'
#' @section Request syntax:
#' ```
#' svc$import_instance(
#'   Description = "string",
#'   DiskImages = list(
#'     list(
#'       Description = "string",
#'       Image = list(
#'         Bytes = 123,
#'         Format = "VMDK"|"RAW"|"VHD",
#'         ImportManifestUrl = "string"
#'       ),
#'       Volume = list(
#'         Size = 123
#'       )
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   LaunchSpecification = list(
#'     AdditionalInfo = "string",
#'     Architecture = "i386"|"x86_64"|"arm64",
#'     GroupIds = list(
#'       "string"
#'     ),
#'     GroupNames = list(
#'       "string"
#'     ),
#'     InstanceInitiatedShutdownBehavior = "stop"|"terminate",
#'     InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge",
#'     Monitoring = TRUE|FALSE,
#'     Placement = list(
#'       AvailabilityZone = "string",
#'       Affinity = "string",
#'       GroupName = "string",
#'       PartitionNumber = 123,
#'       HostId = "string",
#'       Tenancy = "default"|"dedicated"|"host",
#'       SpreadDomain = "string",
#'       HostResourceGroupArn = "string"
#'     ),
#'     PrivateIpAddress = "string",
#'     SubnetId = "string",
#'     UserData = list(
#'       Data = "string"
#'     )
#'   ),
#'   Platform = "Windows"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_import_instance
ec2_import_instance <- function(Description = NULL, DiskImages = NULL, DryRun = NULL, LaunchSpecification = NULL, Platform) {
  op <- new_operation(
    name = "ImportInstance",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$import_instance_input(Description = Description, DiskImages = DiskImages, DryRun = DryRun, LaunchSpecification = LaunchSpecification, Platform = Platform)
  output <- .ec2$import_instance_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$import_instance <- ec2_import_instance

#' Imports the public key from an RSA key pair that you created with a
#' third-party tool
#'
#' Imports the public key from an RSA key pair that you created with a
#' third-party tool. Compare this with CreateKeyPair, in which AWS creates
#' the key pair and gives the keys to you (AWS keeps a copy of the public
#' key). With ImportKeyPair, you create the key pair and give AWS just the
#' public key. The private key is never transferred between you and AWS.
#' 
#' For more information about key pairs, see [Key
#' Pairs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-key-pairs.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_import_key_pair(DryRun, KeyName, PublicKeyMaterial)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param KeyName &#91;required&#93; A unique name for the key pair.
#' @param PublicKeyMaterial &#91;required&#93; The public key. For API calls, the text must be base64-encoded. For
#' command line tools, base64 encoding is performed for you.
#'
#' @section Request syntax:
#' ```
#' svc$import_key_pair(
#'   DryRun = TRUE|FALSE,
#'   KeyName = "string",
#'   PublicKeyMaterial = raw
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_import_key_pair
ec2_import_key_pair <- function(DryRun = NULL, KeyName, PublicKeyMaterial) {
  op <- new_operation(
    name = "ImportKeyPair",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$import_key_pair_input(DryRun = DryRun, KeyName = KeyName, PublicKeyMaterial = PublicKeyMaterial)
  output <- .ec2$import_key_pair_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$import_key_pair <- ec2_import_key_pair

#' Imports a disk into an EBS snapshot
#'
#' Imports a disk into an EBS snapshot.
#'
#' @usage
#' ec2_import_snapshot(ClientData, ClientToken, Description, DiskContainer,
#'   DryRun, Encrypted, KmsKeyId, RoleName)
#'
#' @param ClientData The client-specific data.
#' @param ClientToken Token to enable idempotency for VM import requests.
#' @param Description The description string for the import snapshot task.
#' @param DiskContainer Information about the disk container.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Encrypted Specifies whether the destination snapshot of the imported image should
#' be encrypted. The default CMK for EBS is used unless you specify a
#' non-default AWS Key Management Service (AWS KMS) CMK using `KmsKeyId`.
#' For more information, see [Amazon EBS
#' Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param KmsKeyId An identifier for the symmetric AWS Key Management Service (AWS KMS)
#' customer master key (CMK) to use when creating the encrypted snapshot.
#' This parameter is only required if you want to use a non-default CMK; if
#' this parameter is not specified, the default CMK for EBS is used. If a
#' `KmsKeyId` is specified, the `Encrypted` flag must also be set.
#' 
#' The CMK identifier may be provided in any of the following formats:
#' 
#' -   Key ID
#' 
#' -   Key alias. The alias ARN contains the `arn:aws:kms` namespace,
#'     followed by the Region of the CMK, the AWS account ID of the CMK
#'     owner, the `alias` namespace, and then the CMK alias. For example,
#'     arn:aws:kms:*us-east-1*:*012345678910*:alias/*ExampleAlias*.
#' 
#' -   ARN using key ID. The ID ARN contains the `arn:aws:kms` namespace,
#'     followed by the Region of the CMK, the AWS account ID of the CMK
#'     owner, the `key` namespace, and then the CMK ID. For example,
#'     arn:aws:kms:*us-east-1*:*012345678910*:key/*abcd1234-a123-456a-a12b-a123b4cd56ef*.
#' 
#' -   ARN using key alias. The alias ARN contains the `arn:aws:kms`
#'     namespace, followed by the Region of the CMK, the AWS account ID of
#'     the CMK owner, the `alias` namespace, and then the CMK alias. For
#'     example,
#'     arn:aws:kms:*us-east-1*:*012345678910*:alias/*ExampleAlias*.
#' 
#' AWS parses `KmsKeyId` asynchronously, meaning that the action you call
#' may appear to complete even though you provided an invalid identifier.
#' This action will eventually report failure.
#' 
#' The specified CMK must exist in the Region that the snapshot is being
#' copied to.
#' 
#' Amazon EBS does not support asymmetric CMKs.
#' @param RoleName The name of the role to use when not using the default role,
#' \'vmimport\'.
#'
#' @section Request syntax:
#' ```
#' svc$import_snapshot(
#'   ClientData = list(
#'     Comment = "string",
#'     UploadEnd = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     UploadSize = 123.0,
#'     UploadStart = as.POSIXct(
#'       "2015-01-01"
#'     )
#'   ),
#'   ClientToken = "string",
#'   Description = "string",
#'   DiskContainer = list(
#'     Description = "string",
#'     Format = "string",
#'     Url = "string",
#'     UserBucket = list(
#'       S3Bucket = "string",
#'       S3Key = "string"
#'     )
#'   ),
#'   DryRun = TRUE|FALSE,
#'   Encrypted = TRUE|FALSE,
#'   KmsKeyId = "string",
#'   RoleName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_import_snapshot
ec2_import_snapshot <- function(ClientData = NULL, ClientToken = NULL, Description = NULL, DiskContainer = NULL, DryRun = NULL, Encrypted = NULL, KmsKeyId = NULL, RoleName = NULL) {
  op <- new_operation(
    name = "ImportSnapshot",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$import_snapshot_input(ClientData = ClientData, ClientToken = ClientToken, Description = Description, DiskContainer = DiskContainer, DryRun = DryRun, Encrypted = Encrypted, KmsKeyId = KmsKeyId, RoleName = RoleName)
  output <- .ec2$import_snapshot_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$import_snapshot <- ec2_import_snapshot

#' Creates an import volume task using metadata from the specified disk
#' image
#'
#' Creates an import volume task using metadata from the specified disk
#' image.For more information, see [Importing Disks to Amazon
#' EBS](https://docs.aws.amazon.com/AWSEC2/latest/CommandLineReference/importing-your-volumes-into-amazon-ebs.html).
#' 
#' For information about the import manifest referenced by this API action,
#' see [VM Import
#' Manifest](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/manifest.html).
#'
#' @usage
#' ec2_import_volume(AvailabilityZone, Description, DryRun, Image, Volume)
#'
#' @param AvailabilityZone &#91;required&#93; The Availability Zone for the resulting EBS volume.
#' @param Description A description of the volume.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Image &#91;required&#93; The disk image.
#' @param Volume &#91;required&#93; The volume size.
#'
#' @section Request syntax:
#' ```
#' svc$import_volume(
#'   AvailabilityZone = "string",
#'   Description = "string",
#'   DryRun = TRUE|FALSE,
#'   Image = list(
#'     Bytes = 123,
#'     Format = "VMDK"|"RAW"|"VHD",
#'     ImportManifestUrl = "string"
#'   ),
#'   Volume = list(
#'     Size = 123
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_import_volume
ec2_import_volume <- function(AvailabilityZone, Description = NULL, DryRun = NULL, Image, Volume) {
  op <- new_operation(
    name = "ImportVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$import_volume_input(AvailabilityZone = AvailabilityZone, Description = Description, DryRun = DryRun, Image = Image, Volume = Volume)
  output <- .ec2$import_volume_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$import_volume <- ec2_import_volume

#' Modifies a Capacity Reservation's capacity and the conditions under
#' which it is to be released
#'
#' Modifies a Capacity Reservation\'s capacity and the conditions under
#' which it is to be released. You cannot change a Capacity Reservation\'s
#' instance type, EBS optimization, instance store settings, platform,
#' Availability Zone, or instance eligibility. If you need to modify any of
#' these attributes, we recommend that you cancel the Capacity Reservation,
#' and then create a new one with the required attributes.
#'
#' @usage
#' ec2_modify_capacity_reservation(CapacityReservationId, InstanceCount,
#'   EndDate, EndDateType, DryRun)
#'
#' @param CapacityReservationId &#91;required&#93; The ID of the Capacity Reservation.
#' @param InstanceCount The number of instances for which to reserve capacity.
#' @param EndDate The date and time at which the Capacity Reservation expires. When a
#' Capacity Reservation expires, the reserved capacity is released and you
#' can no longer launch instances into it. The Capacity Reservation\'s
#' state changes to `expired` when it reaches its end date and time.
#' 
#' The Capacity Reservation is cancelled within an hour from the specified
#' time. For example, if you specify 5/31/2019, 13:30:55, the Capacity
#' Reservation is guaranteed to end between 13:30:55 and 14:30:55 on
#' 5/31/2019.
#' 
#' You must provide an `EndDate` value if `EndDateType` is `limited`. Omit
#' `EndDate` if `EndDateType` is `unlimited`.
#' @param EndDateType Indicates the way in which the Capacity Reservation ends. A Capacity
#' Reservation can have one of the following end types:
#' 
#' -   `unlimited` - The Capacity Reservation remains active until you
#'     explicitly cancel it. Do not provide an `EndDate` value if
#'     `EndDateType` is `unlimited`.
#' 
#' -   `limited` - The Capacity Reservation expires automatically at a
#'     specified date and time. You must provide an `EndDate` value if
#'     `EndDateType` is `limited`.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$modify_capacity_reservation(
#'   CapacityReservationId = "string",
#'   InstanceCount = 123,
#'   EndDate = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndDateType = "unlimited"|"limited",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_capacity_reservation
ec2_modify_capacity_reservation <- function(CapacityReservationId, InstanceCount = NULL, EndDate = NULL, EndDateType = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "ModifyCapacityReservation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_capacity_reservation_input(CapacityReservationId = CapacityReservationId, InstanceCount = InstanceCount, EndDate = EndDate, EndDateType = EndDateType, DryRun = DryRun)
  output <- .ec2$modify_capacity_reservation_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_capacity_reservation <- ec2_modify_capacity_reservation

#' Modifies the specified Client VPN endpoint
#'
#' Modifies the specified Client VPN endpoint. You can only modify an
#' endpoint\'s server certificate information, client connection logging
#' information, DNS server, and description. Modifying the DNS server
#' resets existing client connections.
#'
#' @usage
#' ec2_modify_client_vpn_endpoint(ClientVpnEndpointId,
#'   ServerCertificateArn, ConnectionLogOptions, DnsServers, Description,
#'   SplitTunnel, DryRun)
#'
#' @param ClientVpnEndpointId &#91;required&#93; The ID of the Client VPN endpoint to modify.
#' @param ServerCertificateArn The ARN of the server certificate to be used. The server certificate
#' must be provisioned in AWS Certificate Manager (ACM).
#' @param ConnectionLogOptions Information about the client connection logging options.
#' 
#' If you enable client connection logging, data about client connections
#' is sent to a Cloudwatch Logs log stream. The following information is
#' logged:
#' 
#' -   Client connection requests
#' 
#' -   Client connection results (successful and unsuccessful)
#' 
#' -   Reasons for unsuccessful client connection requests
#' 
#' -   Client connection termination time
#' @param DnsServers Information about the DNS servers to be used by Client VPN connections.
#' A Client VPN endpoint can have up to two DNS servers.
#' @param Description A brief description of the Client VPN endpoint.
#' @param SplitTunnel Indicates whether the VPN is split-tunnel.
#' 
#' For information about split-tunnel VPN endpoints, see [Split-Tunnel AWS
#' Client VPN
#' Endpoint](https://docs.aws.amazon.com/vpn/latest/clientvpn-admin/split-tunnel-vpn.html)
#' in the *AWS Client VPN Administrator Guide*.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$modify_client_vpn_endpoint(
#'   ClientVpnEndpointId = "string",
#'   ServerCertificateArn = "string",
#'   ConnectionLogOptions = list(
#'     Enabled = TRUE|FALSE,
#'     CloudwatchLogGroup = "string",
#'     CloudwatchLogStream = "string"
#'   ),
#'   DnsServers = list(
#'     CustomDnsServers = list(
#'       "string"
#'     ),
#'     Enabled = TRUE|FALSE
#'   ),
#'   Description = "string",
#'   SplitTunnel = TRUE|FALSE,
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_client_vpn_endpoint
ec2_modify_client_vpn_endpoint <- function(ClientVpnEndpointId, ServerCertificateArn = NULL, ConnectionLogOptions = NULL, DnsServers = NULL, Description = NULL, SplitTunnel = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "ModifyClientVpnEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_client_vpn_endpoint_input(ClientVpnEndpointId = ClientVpnEndpointId, ServerCertificateArn = ServerCertificateArn, ConnectionLogOptions = ConnectionLogOptions, DnsServers = DnsServers, Description = Description, SplitTunnel = SplitTunnel, DryRun = DryRun)
  output <- .ec2$modify_client_vpn_endpoint_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_client_vpn_endpoint <- ec2_modify_client_vpn_endpoint

#' Modifies the default credit option for CPU usage of burstable
#' performance instances
#'
#' Modifies the default credit option for CPU usage of burstable
#' performance instances. The default credit option is set at the account
#' level per AWS Region, and is specified per instance family. All new
#' burstable performance instances in the account launch using the default
#' credit option.
#' 
#' `ModifyDefaultCreditSpecification` is an asynchronous operation, which
#' works at an AWS Region level and modifies the credit option for each
#' Availability Zone. All zones in a Region are updated within five
#' minutes. But if instances are launched during this operation, they might
#' not get the new credit option until the zone is updated. To verify
#' whether the update has occurred, you can call
#' `GetDefaultCreditSpecification` and check `DefaultCreditSpecification`
#' for updates.
#' 
#' For more information, see [Burstable Performance
#' Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_modify_default_credit_specification(DryRun, InstanceFamily,
#'   CpuCredits)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceFamily &#91;required&#93; The instance family.
#' @param CpuCredits &#91;required&#93; The credit option for CPU usage of the instance family.
#' 
#' Valid Values: `standard` \\| `unlimited`
#'
#' @section Request syntax:
#' ```
#' svc$modify_default_credit_specification(
#'   DryRun = TRUE|FALSE,
#'   InstanceFamily = "t2"|"t3"|"t3a",
#'   CpuCredits = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_default_credit_specification
ec2_modify_default_credit_specification <- function(DryRun = NULL, InstanceFamily, CpuCredits) {
  op <- new_operation(
    name = "ModifyDefaultCreditSpecification",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_default_credit_specification_input(DryRun = DryRun, InstanceFamily = InstanceFamily, CpuCredits = CpuCredits)
  output <- .ec2$modify_default_credit_specification_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_default_credit_specification <- ec2_modify_default_credit_specification

#' Changes the default customer master key (CMK) for EBS encryption by
#' default for your account in this Region
#'
#' Changes the default customer master key (CMK) for EBS encryption by
#' default for your account in this Region.
#' 
#' AWS creates a unique AWS managed CMK in each Region for use with
#' encryption by default. If you change the default CMK to a symmetric
#' customer managed CMK, it is used instead of the AWS managed CMK. To
#' reset the default CMK to the AWS managed CMK for EBS, use
#' ResetEbsDefaultKmsKeyId. Amazon EBS does not support asymmetric CMKs.
#' 
#' If you delete or disable the customer managed CMK that you specified for
#' use with encryption by default, your instances will fail to launch.
#' 
#' For more information, see [Amazon EBS
#' Encryption](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSEncryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_modify_ebs_default_kms_key_id(KmsKeyId, DryRun)
#'
#' @param KmsKeyId &#91;required&#93; The identifier of the AWS Key Management Service (AWS KMS) customer
#' master key (CMK) to use for Amazon EBS encryption. If this parameter is
#' not specified, your AWS managed CMK for EBS is used. If `KmsKeyId` is
#' specified, the encrypted state must be `true`.
#' 
#' You can specify the CMK using any of the following:
#' 
#' -   Key ID. For example, key/1234abcd-12ab-34cd-56ef-1234567890ab.
#' 
#' -   Key alias. For example, alias/ExampleAlias.
#' 
#' -   Key ARN. For example,
#'     arn:aws:kms:*us-east-1*:*012345678910*:key/*abcd1234-a123-456a-a12b-a123b4cd56ef*.
#' 
#' -   Alias ARN. For example,
#'     arn:aws:kms:*us-east-1*:*012345678910*:alias/*ExampleAlias*.
#' 
#' AWS authenticates the CMK asynchronously. Therefore, if you specify an
#' ID, alias, or ARN that is not valid, the action can appear to complete,
#' but eventually fails.
#' 
#' Amazon EBS does not support asymmetric CMKs.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$modify_ebs_default_kms_key_id(
#'   KmsKeyId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_ebs_default_kms_key_id
ec2_modify_ebs_default_kms_key_id <- function(KmsKeyId, DryRun = NULL) {
  op <- new_operation(
    name = "ModifyEbsDefaultKmsKeyId",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_ebs_default_kms_key_id_input(KmsKeyId = KmsKeyId, DryRun = DryRun)
  output <- .ec2$modify_ebs_default_kms_key_id_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_ebs_default_kms_key_id <- ec2_modify_ebs_default_kms_key_id

#' Modifies the specified EC2 Fleet
#'
#' Modifies the specified EC2 Fleet.
#' 
#' You can only modify an EC2 Fleet request of type `maintain`.
#' 
#' While the EC2 Fleet is being modified, it is in the `modifying` state.
#' 
#' To scale up your EC2 Fleet, increase its target capacity. The EC2 Fleet
#' launches the additional Spot Instances according to the allocation
#' strategy for the EC2 Fleet request. If the allocation strategy is
#' `lowest-price`, the EC2 Fleet launches instances using the Spot Instance
#' pool with the lowest price. If the allocation strategy is `diversified`,
#' the EC2 Fleet distributes the instances across the Spot Instance pools.
#' If the allocation strategy is `capacity-optimized`, EC2 Fleet launches
#' instances from Spot Instance pools with optimal capacity for the number
#' of instances that are launching.
#' 
#' To scale down your EC2 Fleet, decrease its target capacity. First, the
#' EC2 Fleet cancels any open requests that exceed the new target capacity.
#' You can request that the EC2 Fleet terminate Spot Instances until the
#' size of the fleet no longer exceeds the new target capacity. If the
#' allocation strategy is `lowest-price`, the EC2 Fleet terminates the
#' instances with the highest price per unit. If the allocation strategy is
#' `capacity-optimized`, the EC2 Fleet terminates the instances in the Spot
#' Instance pools that have the least available Spot Instance capacity. If
#' the allocation strategy is `diversified`, the EC2 Fleet terminates
#' instances across the Spot Instance pools. Alternatively, you can request
#' that the EC2 Fleet keep the fleet at its current size, but not replace
#' any Spot Instances that are interrupted or that you terminate manually.
#' 
#' If you are finished with your EC2 Fleet for now, but will use it again
#' later, you can set the target capacity to 0.
#'
#' @usage
#' ec2_modify_fleet(DryRun, ExcessCapacityTerminationPolicy, FleetId,
#'   TargetCapacitySpecification)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ExcessCapacityTerminationPolicy Indicates whether running instances should be terminated if the total
#' target capacity of the EC2 Fleet is decreased below the current size of
#' the EC2 Fleet.
#' @param FleetId &#91;required&#93; The ID of the EC2 Fleet.
#' @param TargetCapacitySpecification &#91;required&#93; The size of the EC2 Fleet.
#'
#' @section Request syntax:
#' ```
#' svc$modify_fleet(
#'   DryRun = TRUE|FALSE,
#'   ExcessCapacityTerminationPolicy = "no-termination"|"termination",
#'   FleetId = "string",
#'   TargetCapacitySpecification = list(
#'     TotalTargetCapacity = 123,
#'     OnDemandTargetCapacity = 123,
#'     SpotTargetCapacity = 123,
#'     DefaultTargetCapacityType = "spot"|"on-demand"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_fleet
ec2_modify_fleet <- function(DryRun = NULL, ExcessCapacityTerminationPolicy = NULL, FleetId, TargetCapacitySpecification) {
  op <- new_operation(
    name = "ModifyFleet",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_fleet_input(DryRun = DryRun, ExcessCapacityTerminationPolicy = ExcessCapacityTerminationPolicy, FleetId = FleetId, TargetCapacitySpecification = TargetCapacitySpecification)
  output <- .ec2$modify_fleet_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_fleet <- ec2_modify_fleet

#' Modifies the specified attribute of the specified Amazon FPGA Image
#' (AFI)
#'
#' Modifies the specified attribute of the specified Amazon FPGA Image
#' (AFI).
#'
#' @usage
#' ec2_modify_fpga_image_attribute(DryRun, FpgaImageId, Attribute,
#'   OperationType, UserIds, UserGroups, ProductCodes, LoadPermission,
#'   Description, Name)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param FpgaImageId &#91;required&#93; The ID of the AFI.
#' @param Attribute The name of the attribute.
#' @param OperationType The operation type.
#' @param UserIds The AWS account IDs. This parameter is valid only when modifying the
#' `loadPermission` attribute.
#' @param UserGroups The user groups. This parameter is valid only when modifying the
#' `loadPermission` attribute.
#' @param ProductCodes The product codes. After you add a product code to an AFI, it can\'t be
#' removed. This parameter is valid only when modifying the `productCodes`
#' attribute.
#' @param LoadPermission The load permission for the AFI.
#' @param Description A description for the AFI.
#' @param Name A name for the AFI.
#'
#' @section Request syntax:
#' ```
#' svc$modify_fpga_image_attribute(
#'   DryRun = TRUE|FALSE,
#'   FpgaImageId = "string",
#'   Attribute = "description"|"name"|"loadPermission"|"productCodes",
#'   OperationType = "add"|"remove",
#'   UserIds = list(
#'     "string"
#'   ),
#'   UserGroups = list(
#'     "string"
#'   ),
#'   ProductCodes = list(
#'     "string"
#'   ),
#'   LoadPermission = list(
#'     Add = list(
#'       list(
#'         Group = "all",
#'         UserId = "string"
#'       )
#'     ),
#'     Remove = list(
#'       list(
#'         Group = "all",
#'         UserId = "string"
#'       )
#'     )
#'   ),
#'   Description = "string",
#'   Name = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_fpga_image_attribute
ec2_modify_fpga_image_attribute <- function(DryRun = NULL, FpgaImageId, Attribute = NULL, OperationType = NULL, UserIds = NULL, UserGroups = NULL, ProductCodes = NULL, LoadPermission = NULL, Description = NULL, Name = NULL) {
  op <- new_operation(
    name = "ModifyFpgaImageAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_fpga_image_attribute_input(DryRun = DryRun, FpgaImageId = FpgaImageId, Attribute = Attribute, OperationType = OperationType, UserIds = UserIds, UserGroups = UserGroups, ProductCodes = ProductCodes, LoadPermission = LoadPermission, Description = Description, Name = Name)
  output <- .ec2$modify_fpga_image_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_fpga_image_attribute <- ec2_modify_fpga_image_attribute

#' Modify the auto-placement setting of a Dedicated Host
#'
#' Modify the auto-placement setting of a Dedicated Host. When
#' auto-placement is enabled, any instances that you launch with a tenancy
#' of `host` but without a specific host ID are placed onto any available
#' Dedicated Host in your account that has auto-placement enabled. When
#' auto-placement is disabled, you need to provide a host ID to have the
#' instance launch onto a specific host. If no host ID is provided, the
#' instance is launched onto a suitable host with auto-placement enabled.
#' 
#' You can also use this API action to modify a Dedicated Host to support
#' either multiple instance types in an instance family, or to support a
#' specific instance type only.
#'
#' @usage
#' ec2_modify_hosts(AutoPlacement, HostIds, HostRecovery, InstanceType,
#'   InstanceFamily)
#'
#' @param AutoPlacement Specify whether to enable or disable auto-placement.
#' @param HostIds &#91;required&#93; The IDs of the Dedicated Hosts to modify.
#' @param HostRecovery Indicates whether to enable or disable host recovery for the Dedicated
#' Host. For more information, see [Host
#' Recovery](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-recovery.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param InstanceType Specifies the instance type to be supported by the Dedicated Host.
#' Specify this parameter to modify a Dedicated Host to support only a
#' specific instance type.
#' 
#' If you want to modify a Dedicated Host to support multiple instance
#' types in its current instance family, omit this parameter and specify
#' **InstanceFamily** instead. You cannot specify **InstanceType** and
#' **InstanceFamily** in the same request.
#' @param InstanceFamily Specifies the instance family to be supported by the Dedicated Host.
#' Specify this parameter to modify a Dedicated Host to support multiple
#' instance types within its current instance family.
#' 
#' If you want to modify a Dedicated Host to support a specific instance
#' type only, omit this parameter and specify **InstanceType** instead. You
#' cannot specify **InstanceFamily** and **InstanceType** in the same
#' request.
#'
#' @section Request syntax:
#' ```
#' svc$modify_hosts(
#'   AutoPlacement = "on"|"off",
#'   HostIds = list(
#'     "string"
#'   ),
#'   HostRecovery = "on"|"off",
#'   InstanceType = "string",
#'   InstanceFamily = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_hosts
ec2_modify_hosts <- function(AutoPlacement = NULL, HostIds, HostRecovery = NULL, InstanceType = NULL, InstanceFamily = NULL) {
  op <- new_operation(
    name = "ModifyHosts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_hosts_input(AutoPlacement = AutoPlacement, HostIds = HostIds, HostRecovery = HostRecovery, InstanceType = InstanceType, InstanceFamily = InstanceFamily)
  output <- .ec2$modify_hosts_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_hosts <- ec2_modify_hosts

#' Modifies the ID format for the specified resource on a per-Region basis
#'
#' Modifies the ID format for the specified resource on a per-Region basis.
#' You can specify that resources should receive longer IDs (17-character
#' IDs) when they are created.
#' 
#' This request can only be used to modify longer ID settings for resource
#' types that are within the opt-in period. Resources currently in their
#' opt-in period include: `bundle` \\| `conversion-task` \\|
#' `customer-gateway` \\| `dhcp-options` \\| `elastic-ip-allocation` \\|
#' `elastic-ip-association` \\| `export-task` \\| `flow-log` \\| `image` \\|
#' `import-task` \\| `internet-gateway` \\| `network-acl` \\|
#' `network-acl-association` \\| `network-interface` \\|
#' `network-interface-attachment` \\| `prefix-list` \\| `route-table` \\|
#' `route-table-association` \\| `security-group` \\| `subnet` \\|
#' `subnet-cidr-block-association` \\| `vpc` \\| `vpc-cidr-block-association`
#' \\| `vpc-endpoint` \\| `vpc-peering-connection` \\| `vpn-connection` \\|
#' `vpn-gateway`.
#' 
#' This setting applies to the IAM user who makes the request; it does not
#' apply to the entire AWS account. By default, an IAM user defaults to the
#' same settings as the root user. If you\'re using this action as the root
#' user, then these settings apply to the entire account, unless an IAM
#' user explicitly overrides these settings for themselves. For more
#' information, see [Resource
#' IDs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' Resources created with longer IDs are visible to all IAM roles and
#' users, regardless of these settings and provided that they have
#' permission to use the relevant `Describe` command for the resource type.
#'
#' @usage
#' ec2_modify_id_format(Resource, UseLongIds)
#'
#' @param Resource &#91;required&#93; The type of resource: `bundle` \\| `conversion-task` \\|
#' `customer-gateway` \\| `dhcp-options` \\| `elastic-ip-allocation` \\|
#' `elastic-ip-association` \\| `export-task` \\| `flow-log` \\| `image` \\|
#' `import-task` \\| `internet-gateway` \\| `network-acl` \\|
#' `network-acl-association` \\| `network-interface` \\|
#' `network-interface-attachment` \\| `prefix-list` \\| `route-table` \\|
#' `route-table-association` \\| `security-group` \\| `subnet` \\|
#' `subnet-cidr-block-association` \\| `vpc` \\| `vpc-cidr-block-association`
#' \\| `vpc-endpoint` \\| `vpc-peering-connection` \\| `vpn-connection` \\|
#' `vpn-gateway`.
#' 
#' Alternatively, use the `all-current` option to include all resource
#' types that are currently within their opt-in period for longer IDs.
#' @param UseLongIds &#91;required&#93; Indicate whether the resource should use longer IDs (17-character IDs).
#'
#' @section Request syntax:
#' ```
#' svc$modify_id_format(
#'   Resource = "string",
#'   UseLongIds = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_id_format
ec2_modify_id_format <- function(Resource, UseLongIds) {
  op <- new_operation(
    name = "ModifyIdFormat",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_id_format_input(Resource = Resource, UseLongIds = UseLongIds)
  output <- .ec2$modify_id_format_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_id_format <- ec2_modify_id_format

#' Modifies the ID format of a resource for a specified IAM user, IAM role,
#' or the root user for an account; or all IAM users, IAM roles, and the
#' root user for an account
#'
#' Modifies the ID format of a resource for a specified IAM user, IAM role,
#' or the root user for an account; or all IAM users, IAM roles, and the
#' root user for an account. You can specify that resources should receive
#' longer IDs (17-character IDs) when they are created.
#' 
#' This request can only be used to modify longer ID settings for resource
#' types that are within the opt-in period. Resources currently in their
#' opt-in period include: `bundle` \\| `conversion-task` \\|
#' `customer-gateway` \\| `dhcp-options` \\| `elastic-ip-allocation` \\|
#' `elastic-ip-association` \\| `export-task` \\| `flow-log` \\| `image` \\|
#' `import-task` \\| `internet-gateway` \\| `network-acl` \\|
#' `network-acl-association` \\| `network-interface` \\|
#' `network-interface-attachment` \\| `prefix-list` \\| `route-table` \\|
#' `route-table-association` \\| `security-group` \\| `subnet` \\|
#' `subnet-cidr-block-association` \\| `vpc` \\| `vpc-cidr-block-association`
#' \\| `vpc-endpoint` \\| `vpc-peering-connection` \\| `vpn-connection` \\|
#' `vpn-gateway`.
#' 
#' For more information, see [Resource
#' IDs](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/resource-ids.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' This setting applies to the principal specified in the request; it does
#' not apply to the principal that makes the request.
#' 
#' Resources created with longer IDs are visible to all IAM roles and
#' users, regardless of these settings and provided that they have
#' permission to use the relevant `Describe` command for the resource type.
#'
#' @usage
#' ec2_modify_identity_id_format(PrincipalArn, Resource, UseLongIds)
#'
#' @param PrincipalArn &#91;required&#93; The ARN of the principal, which can be an IAM user, IAM role, or the
#' root user. Specify `all` to modify the ID format for all IAM users, IAM
#' roles, and the root user of the account.
#' @param Resource &#91;required&#93; The type of resource: `bundle` \\| `conversion-task` \\|
#' `customer-gateway` \\| `dhcp-options` \\| `elastic-ip-allocation` \\|
#' `elastic-ip-association` \\| `export-task` \\| `flow-log` \\| `image` \\|
#' `import-task` \\| `internet-gateway` \\| `network-acl` \\|
#' `network-acl-association` \\| `network-interface` \\|
#' `network-interface-attachment` \\| `prefix-list` \\| `route-table` \\|
#' `route-table-association` \\| `security-group` \\| `subnet` \\|
#' `subnet-cidr-block-association` \\| `vpc` \\| `vpc-cidr-block-association`
#' \\| `vpc-endpoint` \\| `vpc-peering-connection` \\| `vpn-connection` \\|
#' `vpn-gateway`.
#' 
#' Alternatively, use the `all-current` option to include all resource
#' types that are currently within their opt-in period for longer IDs.
#' @param UseLongIds &#91;required&#93; Indicates whether the resource should use longer IDs (17-character IDs)
#'
#' @section Request syntax:
#' ```
#' svc$modify_identity_id_format(
#'   PrincipalArn = "string",
#'   Resource = "string",
#'   UseLongIds = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_identity_id_format
ec2_modify_identity_id_format <- function(PrincipalArn, Resource, UseLongIds) {
  op <- new_operation(
    name = "ModifyIdentityIdFormat",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_identity_id_format_input(PrincipalArn = PrincipalArn, Resource = Resource, UseLongIds = UseLongIds)
  output <- .ec2$modify_identity_id_format_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_identity_id_format <- ec2_modify_identity_id_format

#' Modifies the specified attribute of the specified AMI
#'
#' Modifies the specified attribute of the specified AMI. You can specify
#' only one attribute at a time. You can use the `Attribute` parameter to
#' specify the attribute or one of the following parameters: `Description`,
#' `LaunchPermission`, or `ProductCode`.
#' 
#' AWS Marketplace product codes cannot be modified. Images with an AWS
#' Marketplace product code cannot be made public.
#' 
#' To enable the SriovNetSupport enhanced networking attribute of an image,
#' enable SriovNetSupport on an instance and create an AMI from the
#' instance.
#'
#' @usage
#' ec2_modify_image_attribute(Attribute, Description, ImageId,
#'   LaunchPermission, OperationType, ProductCodes, UserGroups, UserIds,
#'   Value, DryRun)
#'
#' @param Attribute The name of the attribute to modify. The valid values are `description`,
#' `launchPermission`, and `productCodes`.
#' @param Description A new description for the AMI.
#' @param ImageId &#91;required&#93; The ID of the AMI.
#' @param LaunchPermission A new launch permission for the AMI.
#' @param OperationType The operation type. This parameter can be used only when the `Attribute`
#' parameter is `launchPermission`.
#' @param ProductCodes The DevPay product codes. After you add a product code to an AMI, it
#' can\'t be removed.
#' @param UserGroups The user groups. This parameter can be used only when the `Attribute`
#' parameter is `launchPermission`.
#' @param UserIds The AWS account IDs. This parameter can be used only when the
#' `Attribute` parameter is `launchPermission`.
#' @param Value The value of the attribute being modified. This parameter can be used
#' only when the `Attribute` parameter is `description` or `productCodes`.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$modify_image_attribute(
#'   Attribute = "string",
#'   Description = list(
#'     Value = "string"
#'   ),
#'   ImageId = "string",
#'   LaunchPermission = list(
#'     Add = list(
#'       list(
#'         Group = "all",
#'         UserId = "string"
#'       )
#'     ),
#'     Remove = list(
#'       list(
#'         Group = "all",
#'         UserId = "string"
#'       )
#'     )
#'   ),
#'   OperationType = "add"|"remove",
#'   ProductCodes = list(
#'     "string"
#'   ),
#'   UserGroups = list(
#'     "string"
#'   ),
#'   UserIds = list(
#'     "string"
#'   ),
#'   Value = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example makes the specified AMI public.
#' \dontrun{svc$modify_image_attribute(
#'   ImageId = "ami-5731123e",
#'   LaunchPermission = list(
#'     Add = list(
#'       list(
#'         Group = "all"
#'       )
#'     )
#'   )
#' )}
#' 
#' # This example grants launch permissions for the specified AMI to the
#' # specified AWS account.
#' \dontrun{svc$modify_image_attribute(
#'   ImageId = "ami-5731123e",
#'   LaunchPermission = list(
#'     Add = list(
#'       list(
#'         UserId = "123456789012"
#'       )
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_modify_image_attribute
ec2_modify_image_attribute <- function(Attribute = NULL, Description = NULL, ImageId, LaunchPermission = NULL, OperationType = NULL, ProductCodes = NULL, UserGroups = NULL, UserIds = NULL, Value = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "ModifyImageAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_image_attribute_input(Attribute = Attribute, Description = Description, ImageId = ImageId, LaunchPermission = LaunchPermission, OperationType = OperationType, ProductCodes = ProductCodes, UserGroups = UserGroups, UserIds = UserIds, Value = Value, DryRun = DryRun)
  output <- .ec2$modify_image_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_image_attribute <- ec2_modify_image_attribute

#' Modifies the specified attribute of the specified instance
#'
#' Modifies the specified attribute of the specified instance. You can
#' specify only one attribute at a time.
#' 
#' **Note:** Using this action to change the security groups associated
#' with an elastic network interface (ENI) attached to an instance in a VPC
#' can result in an error if the instance has more than one ENI. To change
#' the security groups associated with an ENI attached to an instance that
#' has multiple ENIs, we recommend that you use the
#' ModifyNetworkInterfaceAttribute action.
#' 
#' To modify some attributes, the instance must be stopped. For more
#' information, see [Modifying Attributes of a Stopped
#' Instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/Using_ChangingAttributesWhileInstanceStopped.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_modify_instance_attribute(SourceDestCheck, Attribute,
#'   BlockDeviceMappings, DisableApiTermination, DryRun, EbsOptimized,
#'   EnaSupport, Groups, InstanceId, InstanceInitiatedShutdownBehavior,
#'   InstanceType, Kernel, Ramdisk, SriovNetSupport, UserData, Value)
#'
#' @param SourceDestCheck Specifies whether source/destination checking is enabled. A value of
#' `true` means that checking is enabled, and `false` means that checking
#' is disabled. This value must be `false` for a NAT instance to perform
#' NAT.
#' @param Attribute The name of the attribute.
#' @param BlockDeviceMappings Modifies the `DeleteOnTermination` attribute for volumes that are
#' currently attached. The volume must be owned by the caller. If no value
#' is specified for `DeleteOnTermination`, the default is `true` and the
#' volume is deleted when the instance is terminated.
#' 
#' To add instance store volumes to an Amazon EBS-backed instance, you must
#' add them when you launch the instance. For more information, see
#' [Updating the Block Device Mapping when Launching an
#' Instance](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html#Using_OverridingAMIBDM)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param DisableApiTermination If the value is `true`, you can\'t terminate the instance using the
#' Amazon EC2 console, CLI, or API; otherwise, you can. You cannot use this
#' parameter for Spot Instances.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param EbsOptimized Specifies whether the instance is optimized for Amazon EBS I/O. This
#' optimization provides dedicated throughput to Amazon EBS and an
#' optimized configuration stack to provide optimal EBS I/O performance.
#' This optimization isn\'t available with all instance types. Additional
#' usage charges apply when using an EBS Optimized instance.
#' @param EnaSupport Set to `true` to enable enhanced networking with ENA for the instance.
#' 
#' This option is supported only for HVM instances. Specifying this option
#' with a PV instance can make it unreachable.
#' @param Groups \[EC2-VPC\] Changes the security groups of the instance. You must
#' specify at least one security group, even if it\'s just the default
#' security group for the VPC. You must specify the security group ID, not
#' the security group name.
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param InstanceInitiatedShutdownBehavior Specifies whether an instance stops or terminates when you initiate
#' shutdown from the instance (using the operating system command for
#' system shutdown).
#' @param InstanceType Changes the instance type to the specified value. For more information,
#' see [Instance
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/instance-types.html).
#' If the instance type is not valid, the error returned is
#' `InvalidInstanceAttributeValue`.
#' @param Kernel Changes the instance\'s kernel to the specified value. We recommend that
#' you use PV-GRUB instead of kernels and RAM disks. For more information,
#' see
#' [PV-GRUB](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html).
#' @param Ramdisk Changes the instance\'s RAM disk to the specified value. We recommend
#' that you use PV-GRUB instead of kernels and RAM disks. For more
#' information, see
#' [PV-GRUB](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/UserProvidedKernels.html).
#' @param SriovNetSupport Set to `simple` to enable enhanced networking with the Intel 82599
#' Virtual Function interface for the instance.
#' 
#' There is no way to disable enhanced networking with the Intel 82599
#' Virtual Function interface at this time.
#' 
#' This option is supported only for HVM instances. Specifying this option
#' with a PV instance can make it unreachable.
#' @param UserData Changes the instance\'s user data to the specified value. If you are
#' using an AWS SDK or command line tool, base64-encoding is performed for
#' you, and you can load the text from a file. Otherwise, you must provide
#' base64-encoded text.
#' @param Value A new value for the attribute. Use only with the `kernel`, `ramdisk`,
#' `userData`, `disableApiTermination`, or
#' `instanceInitiatedShutdownBehavior` attribute.
#'
#' @section Request syntax:
#' ```
#' svc$modify_instance_attribute(
#'   SourceDestCheck = list(
#'     Value = TRUE|FALSE
#'   ),
#'   Attribute = "instanceType"|"kernel"|"ramdisk"|"userData"|"disableApiTermination"|"instanceInitiatedShutdownBehavior"|"rootDeviceName"|"blockDeviceMapping"|"productCodes"|"sourceDestCheck"|"groupSet"|"ebsOptimized"|"sriovNetSupport"|"enaSupport",
#'   BlockDeviceMappings = list(
#'     list(
#'       DeviceName = "string",
#'       Ebs = list(
#'         DeleteOnTermination = TRUE|FALSE,
#'         VolumeId = "string"
#'       ),
#'       NoDevice = "string",
#'       VirtualName = "string"
#'     )
#'   ),
#'   DisableApiTermination = list(
#'     Value = TRUE|FALSE
#'   ),
#'   DryRun = TRUE|FALSE,
#'   EbsOptimized = list(
#'     Value = TRUE|FALSE
#'   ),
#'   EnaSupport = list(
#'     Value = TRUE|FALSE
#'   ),
#'   Groups = list(
#'     "string"
#'   ),
#'   InstanceId = "string",
#'   InstanceInitiatedShutdownBehavior = list(
#'     Value = "string"
#'   ),
#'   InstanceType = list(
#'     Value = "string"
#'   ),
#'   Kernel = list(
#'     Value = "string"
#'   ),
#'   Ramdisk = list(
#'     Value = "string"
#'   ),
#'   SriovNetSupport = list(
#'     Value = "string"
#'   ),
#'   UserData = list(
#'     Value = raw
#'   ),
#'   Value = "string"
#' )
#' ```
#'
#' @examples
#' # This example modifies the instance type of the specified stopped
#' # instance.
#' \dontrun{svc$modify_instance_attribute(
#'   InstanceId = "i-1234567890abcdef0",
#'   InstanceType = list(
#'     Value = "m5.large"
#'   )
#' )}
#' 
#' # This example enables enhanced networking for the specified stopped
#' # instance.
#' \dontrun{svc$modify_instance_attribute(
#'   EnaSupport = list(
#'     Value = TRUE
#'   ),
#'   InstanceId = "i-1234567890abcdef0"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_modify_instance_attribute
ec2_modify_instance_attribute <- function(SourceDestCheck = NULL, Attribute = NULL, BlockDeviceMappings = NULL, DisableApiTermination = NULL, DryRun = NULL, EbsOptimized = NULL, EnaSupport = NULL, Groups = NULL, InstanceId, InstanceInitiatedShutdownBehavior = NULL, InstanceType = NULL, Kernel = NULL, Ramdisk = NULL, SriovNetSupport = NULL, UserData = NULL, Value = NULL) {
  op <- new_operation(
    name = "ModifyInstanceAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_instance_attribute_input(SourceDestCheck = SourceDestCheck, Attribute = Attribute, BlockDeviceMappings = BlockDeviceMappings, DisableApiTermination = DisableApiTermination, DryRun = DryRun, EbsOptimized = EbsOptimized, EnaSupport = EnaSupport, Groups = Groups, InstanceId = InstanceId, InstanceInitiatedShutdownBehavior = InstanceInitiatedShutdownBehavior, InstanceType = InstanceType, Kernel = Kernel, Ramdisk = Ramdisk, SriovNetSupport = SriovNetSupport, UserData = UserData, Value = Value)
  output <- .ec2$modify_instance_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_instance_attribute <- ec2_modify_instance_attribute

#' Modifies the Capacity Reservation settings for a stopped instance
#'
#' Modifies the Capacity Reservation settings for a stopped instance. Use
#' this action to configure an instance to target a specific Capacity
#' Reservation, run in any `open` Capacity Reservation with matching
#' attributes, or run On-Demand Instance capacity.
#'
#' @usage
#' ec2_modify_instance_capacity_reservation_attributes(InstanceId,
#'   CapacityReservationSpecification, DryRun)
#'
#' @param InstanceId &#91;required&#93; The ID of the instance to be modified.
#' @param CapacityReservationSpecification &#91;required&#93; Information about the Capacity Reservation targeting option.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$modify_instance_capacity_reservation_attributes(
#'   InstanceId = "string",
#'   CapacityReservationSpecification = list(
#'     CapacityReservationPreference = "open"|"none",
#'     CapacityReservationTarget = list(
#'       CapacityReservationId = "string"
#'     )
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_instance_capacity_reservation_attributes
ec2_modify_instance_capacity_reservation_attributes <- function(InstanceId, CapacityReservationSpecification, DryRun = NULL) {
  op <- new_operation(
    name = "ModifyInstanceCapacityReservationAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_instance_capacity_reservation_attributes_input(InstanceId = InstanceId, CapacityReservationSpecification = CapacityReservationSpecification, DryRun = DryRun)
  output <- .ec2$modify_instance_capacity_reservation_attributes_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_instance_capacity_reservation_attributes <- ec2_modify_instance_capacity_reservation_attributes

#' Modifies the credit option for CPU usage on a running or stopped
#' burstable performance instance
#'
#' Modifies the credit option for CPU usage on a running or stopped
#' burstable performance instance. The credit options are `standard` and
#' `unlimited`.
#' 
#' For more information, see [Burstable Performance
#' Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/burstable-performance-instances.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_modify_instance_credit_specification(DryRun, ClientToken,
#'   InstanceCreditSpecifications)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken A unique, case-sensitive token that you provide to ensure idempotency of
#' your modification request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param InstanceCreditSpecifications &#91;required&#93; Information about the credit option for CPU usage.
#'
#' @section Request syntax:
#' ```
#' svc$modify_instance_credit_specification(
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string",
#'   InstanceCreditSpecifications = list(
#'     list(
#'       InstanceId = "string",
#'       CpuCredits = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_instance_credit_specification
ec2_modify_instance_credit_specification <- function(DryRun = NULL, ClientToken = NULL, InstanceCreditSpecifications) {
  op <- new_operation(
    name = "ModifyInstanceCreditSpecification",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_instance_credit_specification_input(DryRun = DryRun, ClientToken = ClientToken, InstanceCreditSpecifications = InstanceCreditSpecifications)
  output <- .ec2$modify_instance_credit_specification_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_instance_credit_specification <- ec2_modify_instance_credit_specification

#' Modifies the start time for a scheduled Amazon EC2 instance event
#'
#' Modifies the start time for a scheduled Amazon EC2 instance event.
#'
#' @usage
#' ec2_modify_instance_event_start_time(DryRun, InstanceId,
#'   InstanceEventId, NotBefore)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param InstanceId &#91;required&#93; The ID of the instance with the scheduled event.
#' @param InstanceEventId &#91;required&#93; The ID of the event whose date and time you are modifying.
#' @param NotBefore &#91;required&#93; The new date and time when the event will take place.
#'
#' @section Request syntax:
#' ```
#' svc$modify_instance_event_start_time(
#'   DryRun = TRUE|FALSE,
#'   InstanceId = "string",
#'   InstanceEventId = "string",
#'   NotBefore = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_instance_event_start_time
ec2_modify_instance_event_start_time <- function(DryRun = NULL, InstanceId, InstanceEventId, NotBefore) {
  op <- new_operation(
    name = "ModifyInstanceEventStartTime",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_instance_event_start_time_input(DryRun = DryRun, InstanceId = InstanceId, InstanceEventId = InstanceEventId, NotBefore = NotBefore)
  output <- .ec2$modify_instance_event_start_time_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_instance_event_start_time <- ec2_modify_instance_event_start_time

#' Modify the instance metadata parameters on a running or stopped instance
#'
#' Modify the instance metadata parameters on a running or stopped
#' instance. When you modify the parameters on a stopped instance, they are
#' applied when the instance is started. When you modify the parameters on
#' a running instance, the API responds with a state of "pending". After
#' the parameter modifications are successfully applied to the instance,
#' the state of the modifications changes from "pending" to "applied" in
#' subsequent describe-instances API calls. For more information, see
#' [Instance Metadata and User
#' Data](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ec2-instance-metadata.html).
#'
#' @usage
#' ec2_modify_instance_metadata_options(InstanceId, HttpTokens,
#'   HttpPutResponseHopLimit, HttpEndpoint, DryRun)
#'
#' @param InstanceId &#91;required&#93; The ID of the instance.
#' @param HttpTokens The state of token usage for your instance metadata requests. If the
#' parameter is not specified in the request, the default state is
#' `optional`.
#' 
#' If the state is `optional`, you can choose to retrieve instance metadata
#' with or without a signed token header on your request. If you retrieve
#' the IAM role credentials without a token, the version 1.0 role
#' credentials are returned. If you retrieve the IAM role credentials using
#' a valid signed token, the version 2.0 role credentials are returned.
#' 
#' If the state is `required`, you must send a signed token header with any
#' instance metadata retrieval requests. In this state, retrieving the IAM
#' role credential always returns the version 2.0 credentials; the version
#' 1.0 credentials are not available.
#' @param HttpPutResponseHopLimit The desired HTTP PUT response hop limit for instance metadata requests.
#' The larger the number, the further instance metadata requests can
#' travel. If no parameter is specified, the existing state is maintained.
#' 
#' Possible values: Integers from 1 to 64
#' @param HttpEndpoint This parameter enables or disables the HTTP metadata endpoint on your
#' instances. If the parameter is not specified, the existing state is
#' maintained.
#' 
#' If you specify a value of `disabled`, you will not be able to access
#' your instance metadata.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$modify_instance_metadata_options(
#'   InstanceId = "string",
#'   HttpTokens = "optional"|"required",
#'   HttpPutResponseHopLimit = 123,
#'   HttpEndpoint = "disabled"|"enabled",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_instance_metadata_options
ec2_modify_instance_metadata_options <- function(InstanceId, HttpTokens = NULL, HttpPutResponseHopLimit = NULL, HttpEndpoint = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "ModifyInstanceMetadataOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_instance_metadata_options_input(InstanceId = InstanceId, HttpTokens = HttpTokens, HttpPutResponseHopLimit = HttpPutResponseHopLimit, HttpEndpoint = HttpEndpoint, DryRun = DryRun)
  output <- .ec2$modify_instance_metadata_options_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_instance_metadata_options <- ec2_modify_instance_metadata_options

#' Modifies the placement attributes for a specified instance
#'
#' Modifies the placement attributes for a specified instance. You can do
#' the following:
#' 
#' -   Modify the affinity between an instance and a [Dedicated
#'     Host](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/dedicated-hosts-overview.html).
#'     When affinity is set to `host` and the instance is not associated
#'     with a specific Dedicated Host, the next time the instance is
#'     launched, it is automatically associated with the host on which it
#'     lands. If the instance is restarted or rebooted, this relationship
#'     persists.
#' 
#' -   Change the Dedicated Host with which an instance is associated.
#' 
#' -   Change the instance tenancy of an instance from `host` to
#'     `dedicated`, or from `dedicated` to `host`.
#' 
#' -   Move an instance to or from a [placement
#'     group](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/placement-groups.html).
#' 
#' At least one attribute for affinity, host ID, tenancy, or placement
#' group name must be specified in the request. Affinity and tenancy can be
#' modified in the same request.
#' 
#' To modify the host ID, tenancy, placement group, or partition for an
#' instance, the instance must be in the `stopped` state.
#'
#' @usage
#' ec2_modify_instance_placement(Affinity, GroupName, HostId, InstanceId,
#'   Tenancy, PartitionNumber, HostResourceGroupArn)
#'
#' @param Affinity The affinity setting for the instance.
#' @param GroupName The name of the placement group in which to place the instance. For
#' spread placement groups, the instance must have a tenancy of `default`.
#' For cluster and partition placement groups, the instance must have a
#' tenancy of `default` or `dedicated`.
#' 
#' To remove an instance from a placement group, specify an empty string
#' (\"\").
#' @param HostId The ID of the Dedicated Host with which to associate the instance.
#' @param InstanceId &#91;required&#93; The ID of the instance that you are modifying.
#' @param Tenancy The tenancy for the instance.
#' @param PartitionNumber Reserved for future use.
#' @param HostResourceGroupArn The ARN of the host resource group in which to place the instance.
#'
#' @section Request syntax:
#' ```
#' svc$modify_instance_placement(
#'   Affinity = "default"|"host",
#'   GroupName = "string",
#'   HostId = "string",
#'   InstanceId = "string",
#'   Tenancy = "dedicated"|"host",
#'   PartitionNumber = 123,
#'   HostResourceGroupArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_instance_placement
ec2_modify_instance_placement <- function(Affinity = NULL, GroupName = NULL, HostId = NULL, InstanceId, Tenancy = NULL, PartitionNumber = NULL, HostResourceGroupArn = NULL) {
  op <- new_operation(
    name = "ModifyInstancePlacement",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_instance_placement_input(Affinity = Affinity, GroupName = GroupName, HostId = HostId, InstanceId = InstanceId, Tenancy = Tenancy, PartitionNumber = PartitionNumber, HostResourceGroupArn = HostResourceGroupArn)
  output <- .ec2$modify_instance_placement_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_instance_placement <- ec2_modify_instance_placement

#' Modifies a launch template
#'
#' Modifies a launch template. You can specify which version of the launch
#' template to set as the default version. When launching an instance, the
#' default version applies when a launch template version is not specified.
#'
#' @usage
#' ec2_modify_launch_template(DryRun, ClientToken, LaunchTemplateId,
#'   LaunchTemplateName, DefaultVersion)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ClientToken Unique, case-sensitive identifier you provide to ensure the idempotency
#' of the request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' 
#' Constraint: Maximum 128 ASCII characters.
#' @param LaunchTemplateId The ID of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#' @param LaunchTemplateName The name of the launch template. You must specify either the launch
#' template ID or launch template name in the request.
#' @param DefaultVersion The version number of the launch template to set as the default version.
#'
#' @section Request syntax:
#' ```
#' svc$modify_launch_template(
#'   DryRun = TRUE|FALSE,
#'   ClientToken = "string",
#'   LaunchTemplateId = "string",
#'   LaunchTemplateName = "string",
#'   DefaultVersion = "string"
#' )
#' ```
#'
#' @examples
#' # This example specifies version 2 as the default version of the specified
#' # launch template.
#' \dontrun{svc$modify_launch_template(
#'   DefaultVersion = "2",
#'   LaunchTemplateId = "lt-0abcd290751193123"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_modify_launch_template
ec2_modify_launch_template <- function(DryRun = NULL, ClientToken = NULL, LaunchTemplateId = NULL, LaunchTemplateName = NULL, DefaultVersion = NULL) {
  op <- new_operation(
    name = "ModifyLaunchTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_launch_template_input(DryRun = DryRun, ClientToken = ClientToken, LaunchTemplateId = LaunchTemplateId, LaunchTemplateName = LaunchTemplateName, DefaultVersion = DefaultVersion)
  output <- .ec2$modify_launch_template_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_launch_template <- ec2_modify_launch_template

#' Modifies the specified network interface attribute
#'
#' Modifies the specified network interface attribute. You can specify only
#' one attribute at a time. You can use this action to attach and detach
#' security groups from an existing EC2 instance.
#'
#' @usage
#' ec2_modify_network_interface_attribute(Attachment, Description, DryRun,
#'   Groups, NetworkInterfaceId, SourceDestCheck)
#'
#' @param Attachment Information about the interface attachment. If modifying the \'delete on
#' termination\' attribute, you must specify the ID of the interface
#' attachment.
#' @param Description A description for the network interface.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param Groups Changes the security groups for the network interface. The new set of
#' groups you specify replaces the current set. You must specify at least
#' one group, even if it\'s just the default security group in the VPC. You
#' must specify the ID of the security group, not the name.
#' @param NetworkInterfaceId &#91;required&#93; The ID of the network interface.
#' @param SourceDestCheck Indicates whether source/destination checking is enabled. A value of
#' `true` means checking is enabled, and `false` means checking is
#' disabled. This value must be `false` for a NAT instance to perform NAT.
#' For more information, see [NAT
#' Instances](https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_NAT_Instance.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @section Request syntax:
#' ```
#' svc$modify_network_interface_attribute(
#'   Attachment = list(
#'     AttachmentId = "string",
#'     DeleteOnTermination = TRUE|FALSE
#'   ),
#'   Description = list(
#'     Value = "string"
#'   ),
#'   DryRun = TRUE|FALSE,
#'   Groups = list(
#'     "string"
#'   ),
#'   NetworkInterfaceId = "string",
#'   SourceDestCheck = list(
#'     Value = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @examples
#' # This example modifies the attachment attribute of the specified network
#' # interface.
#' \dontrun{svc$modify_network_interface_attribute(
#'   Attachment = list(
#'     AttachmentId = "eni-attach-43348162",
#'     DeleteOnTermination = FALSE
#'   ),
#'   NetworkInterfaceId = "eni-686ea200"
#' )}
#' 
#' # This example modifies the description attribute of the specified network
#' # interface.
#' \dontrun{svc$modify_network_interface_attribute(
#'   Description = list(
#'     Value = "My description"
#'   ),
#'   NetworkInterfaceId = "eni-686ea200"
#' )}
#' 
#' # This example command modifies the groupSet attribute of the specified
#' # network interface.
#' \dontrun{svc$modify_network_interface_attribute(
#'   Groups = list(
#'     "sg-903004f8",
#'     "sg-1a2b3c4d"
#'   ),
#'   NetworkInterfaceId = "eni-686ea200"
#' )}
#' 
#' # This example command modifies the sourceDestCheck attribute of the
#' # specified network interface.
#' \dontrun{svc$modify_network_interface_attribute(
#'   NetworkInterfaceId = "eni-686ea200",
#'   SourceDestCheck = list(
#'     Value = FALSE
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_modify_network_interface_attribute
ec2_modify_network_interface_attribute <- function(Attachment = NULL, Description = NULL, DryRun = NULL, Groups = NULL, NetworkInterfaceId, SourceDestCheck = NULL) {
  op <- new_operation(
    name = "ModifyNetworkInterfaceAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_network_interface_attribute_input(Attachment = Attachment, Description = Description, DryRun = DryRun, Groups = Groups, NetworkInterfaceId = NetworkInterfaceId, SourceDestCheck = SourceDestCheck)
  output <- .ec2$modify_network_interface_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_network_interface_attribute <- ec2_modify_network_interface_attribute

#' Modifies the Availability Zone, instance count, instance type, or
#' network platform (EC2-Classic or EC2-VPC) of your Reserved Instances
#'
#' Modifies the Availability Zone, instance count, instance type, or
#' network platform (EC2-Classic or EC2-VPC) of your Reserved Instances.
#' The Reserved Instances to be modified must be identical, except for
#' Availability Zone, network platform, and instance type.
#' 
#' For more information, see [Modifying Reserved
#' Instances](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ri-modifying.html)
#' in the Amazon Elastic Compute Cloud User Guide.
#'
#' @usage
#' ec2_modify_reserved_instances(ReservedInstancesIds, ClientToken,
#'   TargetConfigurations)
#'
#' @param ReservedInstancesIds &#91;required&#93; The IDs of the Reserved Instances to modify.
#' @param ClientToken A unique, case-sensitive token you provide to ensure idempotency of your
#' modification request. For more information, see [Ensuring
#' Idempotency](https://docs.aws.amazon.com/AWSEC2/latest/APIReference/Run_Instance_Idempotency.html).
#' @param TargetConfigurations &#91;required&#93; The configuration settings for the Reserved Instances to modify.
#'
#' @section Request syntax:
#' ```
#' svc$modify_reserved_instances(
#'   ReservedInstancesIds = list(
#'     "string"
#'   ),
#'   ClientToken = "string",
#'   TargetConfigurations = list(
#'     list(
#'       AvailabilityZone = "string",
#'       InstanceCount = 123,
#'       InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge",
#'       Platform = "string",
#'       Scope = "Availability Zone"|"Region"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_reserved_instances
ec2_modify_reserved_instances <- function(ReservedInstancesIds, ClientToken = NULL, TargetConfigurations) {
  op <- new_operation(
    name = "ModifyReservedInstances",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_reserved_instances_input(ReservedInstancesIds = ReservedInstancesIds, ClientToken = ClientToken, TargetConfigurations = TargetConfigurations)
  output <- .ec2$modify_reserved_instances_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_reserved_instances <- ec2_modify_reserved_instances

#' Adds or removes permission settings for the specified snapshot
#'
#' Adds or removes permission settings for the specified snapshot. You may
#' add or remove specified AWS account IDs from a snapshot\'s list of
#' create volume permissions, but you cannot do both in a single operation.
#' If you need to both add and remove account IDs for a snapshot, you must
#' use multiple operations. You can make up to 500 modifications to a
#' snapshot in a single operation.
#' 
#' Encrypted snapshots and snapshots with AWS Marketplace product codes
#' cannot be made public. Snapshots encrypted with your default CMK cannot
#' be shared with other accounts.
#' 
#' For more information about modifying snapshot permissions, see [Sharing
#' Snapshots](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-modifying-snapshot-permissions.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#'
#' @usage
#' ec2_modify_snapshot_attribute(Attribute, CreateVolumePermission,
#'   GroupNames, OperationType, SnapshotId, UserIds, DryRun)
#'
#' @param Attribute The snapshot attribute to modify. Only volume creation permissions can
#' be modified.
#' @param CreateVolumePermission A JSON representation of the snapshot attribute modification.
#' @param GroupNames The group to modify for the snapshot.
#' @param OperationType The type of operation to perform to the attribute.
#' @param SnapshotId &#91;required&#93; The ID of the snapshot.
#' @param UserIds The account ID to modify for the snapshot.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$modify_snapshot_attribute(
#'   Attribute = "productCodes"|"createVolumePermission",
#'   CreateVolumePermission = list(
#'     Add = list(
#'       list(
#'         Group = "all",
#'         UserId = "string"
#'       )
#'     ),
#'     Remove = list(
#'       list(
#'         Group = "all",
#'         UserId = "string"
#'       )
#'     )
#'   ),
#'   GroupNames = list(
#'     "string"
#'   ),
#'   OperationType = "add"|"remove",
#'   SnapshotId = "string",
#'   UserIds = list(
#'     "string"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example modifies snapshot `snap-1234567890abcdef0` to remove the
#' # create volume permission for a user with the account ID
#' # `123456789012`. If the command succeeds, no output is returned.
#' \dontrun{svc$modify_snapshot_attribute(
#'   Attribute = "createVolumePermission",
#'   OperationType = "remove",
#'   SnapshotId = "snap-1234567890abcdef0",
#'   UserIds = list(
#'     "123456789012"
#'   )
#' )}
#' 
#' # This example makes the snapshot `snap-1234567890abcdef0` public.
#' \dontrun{svc$modify_snapshot_attribute(
#'   Attribute = "createVolumePermission",
#'   GroupNames = list(
#'     "all"
#'   ),
#'   OperationType = "add",
#'   SnapshotId = "snap-1234567890abcdef0"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_modify_snapshot_attribute
ec2_modify_snapshot_attribute <- function(Attribute = NULL, CreateVolumePermission = NULL, GroupNames = NULL, OperationType = NULL, SnapshotId, UserIds = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "ModifySnapshotAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_snapshot_attribute_input(Attribute = Attribute, CreateVolumePermission = CreateVolumePermission, GroupNames = GroupNames, OperationType = OperationType, SnapshotId = SnapshotId, UserIds = UserIds, DryRun = DryRun)
  output <- .ec2$modify_snapshot_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_snapshot_attribute <- ec2_modify_snapshot_attribute

#' Modifies the specified Spot Fleet request
#'
#' Modifies the specified Spot Fleet request.
#' 
#' You can only modify a Spot Fleet request of type `maintain`.
#' 
#' While the Spot Fleet request is being modified, it is in the `modifying`
#' state.
#' 
#' To scale up your Spot Fleet, increase its target capacity. The Spot
#' Fleet launches the additional Spot Instances according to the allocation
#' strategy for the Spot Fleet request. If the allocation strategy is
#' `lowestPrice`, the Spot Fleet launches instances using the Spot Instance
#' pool with the lowest price. If the allocation strategy is `diversified`,
#' the Spot Fleet distributes the instances across the Spot Instance pools.
#' If the allocation strategy is `capacityOptimized`, Spot Fleet launches
#' instances from Spot Instance pools with optimal capacity for the number
#' of instances that are launching.
#' 
#' To scale down your Spot Fleet, decrease its target capacity. First, the
#' Spot Fleet cancels any open requests that exceed the new target
#' capacity. You can request that the Spot Fleet terminate Spot Instances
#' until the size of the fleet no longer exceeds the new target capacity.
#' If the allocation strategy is `lowestPrice`, the Spot Fleet terminates
#' the instances with the highest price per unit. If the allocation
#' strategy is `capacityOptimized`, the Spot Fleet terminates the instances
#' in the Spot Instance pools that have the least available Spot Instance
#' capacity. If the allocation strategy is `diversified`, the Spot Fleet
#' terminates instances across the Spot Instance pools. Alternatively, you
#' can request that the Spot Fleet keep the fleet at its current size, but
#' not replace any Spot Instances that are interrupted or that you
#' terminate manually.
#' 
#' If you are finished with your Spot Fleet for now, but will use it again
#' later, you can set the target capacity to 0.
#'
#' @usage
#' ec2_modify_spot_fleet_request(ExcessCapacityTerminationPolicy,
#'   SpotFleetRequestId, TargetCapacity, OnDemandTargetCapacity)
#'
#' @param ExcessCapacityTerminationPolicy Indicates whether running Spot Instances should be terminated if the
#' target capacity of the Spot Fleet request is decreased below the current
#' size of the Spot Fleet.
#' @param SpotFleetRequestId &#91;required&#93; The ID of the Spot Fleet request.
#' @param TargetCapacity The size of the fleet.
#' @param OnDemandTargetCapacity The number of On-Demand Instances in the fleet.
#'
#' @section Request syntax:
#' ```
#' svc$modify_spot_fleet_request(
#'   ExcessCapacityTerminationPolicy = "noTermination"|"default",
#'   SpotFleetRequestId = "string",
#'   TargetCapacity = 123,
#'   OnDemandTargetCapacity = 123
#' )
#' ```
#'
#' @examples
#' # This example increases the target capacity of the specified Spot fleet
#' # request.
#' \dontrun{svc$modify_spot_fleet_request(
#'   SpotFleetRequestId = "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE",
#'   TargetCapacity = 20L
#' )}
#' 
#' # This example decreases the target capacity of the specified Spot fleet
#' # request without terminating any Spot Instances as a result.
#' \dontrun{svc$modify_spot_fleet_request(
#'   ExcessCapacityTerminationPolicy = "NoTermination ",
#'   SpotFleetRequestId = "sfr-73fbd2ce-aa30-494c-8788-1cee4EXAMPLE",
#'   TargetCapacity = 10L
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_modify_spot_fleet_request
ec2_modify_spot_fleet_request <- function(ExcessCapacityTerminationPolicy = NULL, SpotFleetRequestId, TargetCapacity = NULL, OnDemandTargetCapacity = NULL) {
  op <- new_operation(
    name = "ModifySpotFleetRequest",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_spot_fleet_request_input(ExcessCapacityTerminationPolicy = ExcessCapacityTerminationPolicy, SpotFleetRequestId = SpotFleetRequestId, TargetCapacity = TargetCapacity, OnDemandTargetCapacity = OnDemandTargetCapacity)
  output <- .ec2$modify_spot_fleet_request_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_spot_fleet_request <- ec2_modify_spot_fleet_request

#' Modifies a subnet attribute
#'
#' Modifies a subnet attribute. You can only modify one attribute at a
#' time.
#'
#' @usage
#' ec2_modify_subnet_attribute(AssignIpv6AddressOnCreation,
#'   MapPublicIpOnLaunch, SubnetId)
#'
#' @param AssignIpv6AddressOnCreation Specify `true` to indicate that network interfaces created in the
#' specified subnet should be assigned an IPv6 address. This includes a
#' network interface that\'s created when launching an instance into the
#' subnet (the instance therefore receives an IPv6 address).
#' 
#' If you enable the IPv6 addressing feature for your subnet, your network
#' interface or instance only receives an IPv6 address if it\'s created
#' using version `2016-11-15` or later of the Amazon EC2 API.
#' @param MapPublicIpOnLaunch Specify `true` to indicate that ENIs attached to instances created in
#' the specified subnet should be assigned a public IPv4 address.
#' @param SubnetId &#91;required&#93; The ID of the subnet.
#'
#' @section Request syntax:
#' ```
#' svc$modify_subnet_attribute(
#'   AssignIpv6AddressOnCreation = list(
#'     Value = TRUE|FALSE
#'   ),
#'   MapPublicIpOnLaunch = list(
#'     Value = TRUE|FALSE
#'   ),
#'   SubnetId = "string"
#' )
#' ```
#'
#' @examples
#' # This example modifies the specified subnet so that all instances
#' # launched into this subnet are assigned a public IP address.
#' \dontrun{svc$modify_subnet_attribute(
#'   MapPublicIpOnLaunch = list(
#'     Value = TRUE
#'   ),
#'   SubnetId = "subnet-1a2b3c4d"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_modify_subnet_attribute
ec2_modify_subnet_attribute <- function(AssignIpv6AddressOnCreation = NULL, MapPublicIpOnLaunch = NULL, SubnetId) {
  op <- new_operation(
    name = "ModifySubnetAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_subnet_attribute_input(AssignIpv6AddressOnCreation = AssignIpv6AddressOnCreation, MapPublicIpOnLaunch = MapPublicIpOnLaunch, SubnetId = SubnetId)
  output <- .ec2$modify_subnet_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_subnet_attribute <- ec2_modify_subnet_attribute

#' Allows or restricts mirroring network services
#'
#' Allows or restricts mirroring network services.
#' 
#' By default, Amazon DNS network services are not eligible for Traffic
#' Mirror. Use `AddNetworkServices` to add network services to a Traffic
#' Mirror filter. When a network service is added to the Traffic Mirror
#' filter, all traffic related to that network service will be mirrored.
#' When you no longer want to mirror network services, use
#' `RemoveNetworkServices` to remove the network services from the Traffic
#' Mirror filter.
#' 
#' For information about filter rule properties, see [Network
#' Services](https://docs.aws.amazon.com/vpc/latest/mirroring/traffic-mirroring-considerations.html)
#' in the *Traffic Mirroring User Guide* .
#'
#' @usage
#' ec2_modify_traffic_mirror_filter_network_services(TrafficMirrorFilterId,
#'   AddNetworkServices, RemoveNetworkServices, DryRun)
#'
#' @param TrafficMirrorFilterId &#91;required&#93; The ID of the Traffic Mirror filter.
#' @param AddNetworkServices The network service, for example Amazon DNS, that you want to mirror.
#' @param RemoveNetworkServices The network service, for example Amazon DNS, that you no longer want to
#' mirror.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$modify_traffic_mirror_filter_network_services(
#'   TrafficMirrorFilterId = "string",
#'   AddNetworkServices = list(
#'     "amazon-dns"
#'   ),
#'   RemoveNetworkServices = list(
#'     "amazon-dns"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_traffic_mirror_filter_network_services
ec2_modify_traffic_mirror_filter_network_services <- function(TrafficMirrorFilterId, AddNetworkServices = NULL, RemoveNetworkServices = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "ModifyTrafficMirrorFilterNetworkServices",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_traffic_mirror_filter_network_services_input(TrafficMirrorFilterId = TrafficMirrorFilterId, AddNetworkServices = AddNetworkServices, RemoveNetworkServices = RemoveNetworkServices, DryRun = DryRun)
  output <- .ec2$modify_traffic_mirror_filter_network_services_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_traffic_mirror_filter_network_services <- ec2_modify_traffic_mirror_filter_network_services

#' Modifies the specified Traffic Mirror rule
#'
#' Modifies the specified Traffic Mirror rule.
#' 
#' `DestinationCidrBlock` and `SourceCidrBlock` must both be an IPv4 range
#' or an IPv6 range.
#'
#' @usage
#' ec2_modify_traffic_mirror_filter_rule(TrafficMirrorFilterRuleId,
#'   TrafficDirection, RuleNumber, RuleAction, DestinationPortRange,
#'   SourcePortRange, Protocol, DestinationCidrBlock, SourceCidrBlock,
#'   Description, RemoveFields, DryRun)
#'
#' @param TrafficMirrorFilterRuleId &#91;required&#93; The ID of the Traffic Mirror rule.
#' @param TrafficDirection The type of traffic (`ingress` \\| `egress`) to assign to the rule.
#' @param RuleNumber The number of the Traffic Mirror rule. This number must be unique for
#' each Traffic Mirror rule in a given direction. The rules are processed
#' in ascending order by rule number.
#' @param RuleAction The action to assign to the rule.
#' @param DestinationPortRange The destination ports that are associated with the Traffic Mirror rule.
#' @param SourcePortRange The port range to assign to the Traffic Mirror rule.
#' @param Protocol The protocol, for example TCP, to assign to the Traffic Mirror rule.
#' @param DestinationCidrBlock The destination CIDR block to assign to the Traffic Mirror rule.
#' @param SourceCidrBlock The source CIDR block to assign to the Traffic Mirror rule.
#' @param Description The description to assign to the Traffic Mirror rule.
#' @param RemoveFields The properties that you want to remove from the Traffic Mirror filter
#' rule.
#' 
#' When you remove a property from a Traffic Mirror filter rule, the
#' property is set to the default.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$modify_traffic_mirror_filter_rule(
#'   TrafficMirrorFilterRuleId = "string",
#'   TrafficDirection = "ingress"|"egress",
#'   RuleNumber = 123,
#'   RuleAction = "accept"|"reject",
#'   DestinationPortRange = list(
#'     FromPort = 123,
#'     ToPort = 123
#'   ),
#'   SourcePortRange = list(
#'     FromPort = 123,
#'     ToPort = 123
#'   ),
#'   Protocol = 123,
#'   DestinationCidrBlock = "string",
#'   SourceCidrBlock = "string",
#'   Description = "string",
#'   RemoveFields = list(
#'     "destination-port-range"|"source-port-range"|"protocol"|"description"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_traffic_mirror_filter_rule
ec2_modify_traffic_mirror_filter_rule <- function(TrafficMirrorFilterRuleId, TrafficDirection = NULL, RuleNumber = NULL, RuleAction = NULL, DestinationPortRange = NULL, SourcePortRange = NULL, Protocol = NULL, DestinationCidrBlock = NULL, SourceCidrBlock = NULL, Description = NULL, RemoveFields = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "ModifyTrafficMirrorFilterRule",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_traffic_mirror_filter_rule_input(TrafficMirrorFilterRuleId = TrafficMirrorFilterRuleId, TrafficDirection = TrafficDirection, RuleNumber = RuleNumber, RuleAction = RuleAction, DestinationPortRange = DestinationPortRange, SourcePortRange = SourcePortRange, Protocol = Protocol, DestinationCidrBlock = DestinationCidrBlock, SourceCidrBlock = SourceCidrBlock, Description = Description, RemoveFields = RemoveFields, DryRun = DryRun)
  output <- .ec2$modify_traffic_mirror_filter_rule_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_traffic_mirror_filter_rule <- ec2_modify_traffic_mirror_filter_rule

#' Modifies a Traffic Mirror session
#'
#' Modifies a Traffic Mirror session.
#'
#' @usage
#' ec2_modify_traffic_mirror_session(TrafficMirrorSessionId,
#'   TrafficMirrorTargetId, TrafficMirrorFilterId, PacketLength,
#'   SessionNumber, VirtualNetworkId, Description, RemoveFields, DryRun)
#'
#' @param TrafficMirrorSessionId &#91;required&#93; The ID of the Traffic Mirror session.
#' @param TrafficMirrorTargetId The Traffic Mirror target. The target must be in the same VPC as the
#' source, or have a VPC peering connection with the source.
#' @param TrafficMirrorFilterId The ID of the Traffic Mirror filter.
#' @param PacketLength The number of bytes in each packet to mirror. These are bytes after the
#' VXLAN header. To mirror a subset, set this to the length (in bytes) to
#' mirror. For example, if you set this value to 100, then the first 100
#' bytes that meet the filter criteria are copied to the target. Do not
#' specify this parameter when you want to mirror the entire packet.
#' @param SessionNumber The session number determines the order in which sessions are evaluated
#' when an interface is used by multiple sessions. The first session with a
#' matching filter is the one that mirrors the packets.
#' 
#' Valid values are 1-32766.
#' @param VirtualNetworkId The virtual network ID of the Traffic Mirror session.
#' @param Description The description to assign to the Traffic Mirror session.
#' @param RemoveFields The properties that you want to remove from the Traffic Mirror session.
#' 
#' When you remove a property from a Traffic Mirror session, the property
#' is set to the default.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$modify_traffic_mirror_session(
#'   TrafficMirrorSessionId = "string",
#'   TrafficMirrorTargetId = "string",
#'   TrafficMirrorFilterId = "string",
#'   PacketLength = 123,
#'   SessionNumber = 123,
#'   VirtualNetworkId = 123,
#'   Description = "string",
#'   RemoveFields = list(
#'     "packet-length"|"description"|"virtual-network-id"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_traffic_mirror_session
ec2_modify_traffic_mirror_session <- function(TrafficMirrorSessionId, TrafficMirrorTargetId = NULL, TrafficMirrorFilterId = NULL, PacketLength = NULL, SessionNumber = NULL, VirtualNetworkId = NULL, Description = NULL, RemoveFields = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "ModifyTrafficMirrorSession",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_traffic_mirror_session_input(TrafficMirrorSessionId = TrafficMirrorSessionId, TrafficMirrorTargetId = TrafficMirrorTargetId, TrafficMirrorFilterId = TrafficMirrorFilterId, PacketLength = PacketLength, SessionNumber = SessionNumber, VirtualNetworkId = VirtualNetworkId, Description = Description, RemoveFields = RemoveFields, DryRun = DryRun)
  output <- .ec2$modify_traffic_mirror_session_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_traffic_mirror_session <- ec2_modify_traffic_mirror_session

#' Modifies the specified VPC attachment
#'
#' Modifies the specified VPC attachment.
#'
#' @usage
#' ec2_modify_transit_gateway_vpc_attachment(TransitGatewayAttachmentId,
#'   AddSubnetIds, RemoveSubnetIds, Options, DryRun)
#'
#' @param TransitGatewayAttachmentId &#91;required&#93; The ID of the attachment.
#' @param AddSubnetIds The IDs of one or more subnets to add. You can specify at most one
#' subnet per Availability Zone.
#' @param RemoveSubnetIds The IDs of one or more subnets to remove.
#' @param Options The new VPC attachment options.
#' 
#' You cannot modify the IPv6 options.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$modify_transit_gateway_vpc_attachment(
#'   TransitGatewayAttachmentId = "string",
#'   AddSubnetIds = list(
#'     "string"
#'   ),
#'   RemoveSubnetIds = list(
#'     "string"
#'   ),
#'   Options = list(
#'     DnsSupport = "enable"|"disable",
#'     Ipv6Support = "enable"|"disable"
#'   ),
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_transit_gateway_vpc_attachment
ec2_modify_transit_gateway_vpc_attachment <- function(TransitGatewayAttachmentId, AddSubnetIds = NULL, RemoveSubnetIds = NULL, Options = NULL, DryRun = NULL) {
  op <- new_operation(
    name = "ModifyTransitGatewayVpcAttachment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_transit_gateway_vpc_attachment_input(TransitGatewayAttachmentId = TransitGatewayAttachmentId, AddSubnetIds = AddSubnetIds, RemoveSubnetIds = RemoveSubnetIds, Options = Options, DryRun = DryRun)
  output <- .ec2$modify_transit_gateway_vpc_attachment_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_transit_gateway_vpc_attachment <- ec2_modify_transit_gateway_vpc_attachment

#' You can modify several parameters of an existing EBS volume, including
#' volume size, volume type, and IOPS capacity
#'
#' You can modify several parameters of an existing EBS volume, including
#' volume size, volume type, and IOPS capacity. If your EBS volume is
#' attached to a current-generation EC2 instance type, you may be able to
#' apply these changes without stopping the instance or detaching the
#' volume from it. For more information about modifying an EBS volume
#' running Linux, see [Modifying the Size, IOPS, or Type of an EBS Volume
#' on
#' Linux](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html).
#' For more information about modifying an EBS volume running Windows, see
#' [Modifying the Size, IOPS, or Type of an EBS Volume on
#' Windows](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-expand-volume.html).
#' 
#' When you complete a resize operation on your volume, you need to extend
#' the volume\'s file-system size to take advantage of the new storage
#' capacity. For information about extending a Linux file system, see
#' [Extending a Linux File
#' System](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#recognize-expanded-volume-linux).
#' For information about extending a Windows file system, see [Extending a
#' Windows File
#' System](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-expand-volume.html#recognize-expanded-volume-windows).
#' 
#' You can use CloudWatch Events to check the status of a modification to
#' an EBS volume. For information about CloudWatch Events, see the [Amazon
#' CloudWatch Events User
#' Guide](https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/). You
#' can also track the status of a modification using
#' DescribeVolumesModifications. For information about tracking status
#' changes using either method, see [Monitoring Volume
#' Modifications](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#monitoring_mods).
#' 
#' With previous-generation instance types, resizing an EBS volume may
#' require detaching and reattaching the volume or stopping and restarting
#' the instance. For more information, see [Modifying the Size, IOPS, or
#' Type of an EBS Volume on
#' Linux](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html)
#' and [Modifying the Size, IOPS, or Type of an EBS Volume on
#' Windows](https://docs.aws.amazon.com/AWSEC2/latest/WindowsGuide/ebs-expand-volume.html).
#' 
#' If you reach the maximum volume modification rate per volume limit, you
#' will need to wait at least six hours before applying further
#' modifications to the affected EBS volume.
#'
#' @usage
#' ec2_modify_volume(DryRun, VolumeId, Size, VolumeType, Iops)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VolumeId &#91;required&#93; The ID of the volume.
#' @param Size The target size of the volume, in GiB. The target volume size must be
#' greater than or equal to than the existing size of the volume. For
#' information about available EBS volume sizes, see [Amazon EBS Volume
#' Types](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html).
#' 
#' Default: If no size is specified, the existing size is retained.
#' @param VolumeType The target EBS volume type of the volume.
#' 
#' Default: If no type is specified, the existing type is retained.
#' @param Iops The target IOPS rate of the volume.
#' 
#' This is only valid for Provisioned IOPS SSD (`io1`) volumes. For more
#' information, see [Provisioned IOPS SSD (io1)
#' Volumes](https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/EBSVolumeTypes.html#EBSVolumeTypes_piops).
#' 
#' Default: If no IOPS value is specified, the existing value is retained.
#'
#' @section Request syntax:
#' ```
#' svc$modify_volume(
#'   DryRun = TRUE|FALSE,
#'   VolumeId = "string",
#'   Size = 123,
#'   VolumeType = "standard"|"io1"|"gp2"|"sc1"|"st1",
#'   Iops = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_volume
ec2_modify_volume <- function(DryRun = NULL, VolumeId, Size = NULL, VolumeType = NULL, Iops = NULL) {
  op <- new_operation(
    name = "ModifyVolume",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_volume_input(DryRun = DryRun, VolumeId = VolumeId, Size = Size, VolumeType = VolumeType, Iops = Iops)
  output <- .ec2$modify_volume_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_volume <- ec2_modify_volume

#' Modifies a volume attribute
#'
#' Modifies a volume attribute.
#' 
#' By default, all I/O operations for the volume are suspended when the
#' data on the volume is determined to be potentially inconsistent, to
#' prevent undetectable, latent data corruption. The I/O access to the
#' volume can be resumed by first enabling I/O access and then checking the
#' data consistency on your volume.
#' 
#' You can change the default behavior to resume I/O operations. We
#' recommend that you change this only for boot volumes or for volumes that
#' are stateless or disposable.
#'
#' @usage
#' ec2_modify_volume_attribute(AutoEnableIO, VolumeId, DryRun)
#'
#' @param AutoEnableIO Indicates whether the volume should be auto-enabled for I/O operations.
#' @param VolumeId &#91;required&#93; The ID of the volume.
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#'
#' @section Request syntax:
#' ```
#' svc$modify_volume_attribute(
#'   AutoEnableIO = list(
#'     Value = TRUE|FALSE
#'   ),
#'   VolumeId = "string",
#'   DryRun = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' # This example sets the `autoEnableIo` attribute of the volume with the
#' # ID `vol-1234567890abcdef0` to `true`. If the command succeeds, no
#' # output is returned.
#' \dontrun{svc$modify_volume_attribute(
#'   AutoEnableIO = list(
#'     Value = TRUE
#'   ),
#'   DryRun = TRUE,
#'   VolumeId = "vol-1234567890abcdef0"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_modify_volume_attribute
ec2_modify_volume_attribute <- function(AutoEnableIO = NULL, VolumeId, DryRun = NULL) {
  op <- new_operation(
    name = "ModifyVolumeAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_volume_attribute_input(AutoEnableIO = AutoEnableIO, VolumeId = VolumeId, DryRun = DryRun)
  output <- .ec2$modify_volume_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_volume_attribute <- ec2_modify_volume_attribute

#' Modifies the specified attribute of the specified VPC
#'
#' Modifies the specified attribute of the specified VPC.
#'
#' @usage
#' ec2_modify_vpc_attribute(EnableDnsHostnames, EnableDnsSupport, VpcId)
#'
#' @param EnableDnsHostnames Indicates whether the instances launched in the VPC get DNS hostnames.
#' If enabled, instances in the VPC get DNS hostnames; otherwise, they do
#' not.
#' 
#' You cannot modify the DNS resolution and DNS hostnames attributes in the
#' same request. Use separate requests for each attribute. You can only
#' enable DNS hostnames if you\'ve enabled DNS support.
#' @param EnableDnsSupport Indicates whether the DNS resolution is supported for the VPC. If
#' enabled, queries to the Amazon provided DNS server at the
#' 169.254.169.253 IP address, or the reserved IP address at the base of
#' the VPC network range \"plus two\" succeed. If disabled, the Amazon
#' provided DNS service in the VPC that resolves public DNS hostnames to IP
#' addresses is not enabled.
#' 
#' You cannot modify the DNS resolution and DNS hostnames attributes in the
#' same request. Use separate requests for each attribute.
#' @param VpcId &#91;required&#93; The ID of the VPC.
#'
#' @section Request syntax:
#' ```
#' svc$modify_vpc_attribute(
#'   EnableDnsHostnames = list(
#'     Value = TRUE|FALSE
#'   ),
#'   EnableDnsSupport = list(
#'     Value = TRUE|FALSE
#'   ),
#'   VpcId = "string"
#' )
#' ```
#'
#' @examples
#' # This example modifies the enableDnsSupport attribute. This attribute
#' # indicates whether DNS resolution is enabled for the VPC. If this
#' # attribute is true, the Amazon DNS server resolves DNS hostnames for
#' # instances in the VPC to their corresponding IP addresses; otherwise, it
#' # does not.
#' \dontrun{svc$modify_vpc_attribute(
#'   EnableDnsSupport = list(
#'     Value = FALSE
#'   ),
#'   VpcId = "vpc-a01106c2"
#' )}
#' 
#' # This example modifies the enableDnsHostnames attribute. This attribute
#' # indicates whether instances launched in the VPC get DNS hostnames. If
#' # this attribute is true, instances in the VPC get DNS hostnames;
#' # otherwise, they do not.
#' \dontrun{svc$modify_vpc_attribute(
#'   EnableDnsHostnames = list(
#'     Value = FALSE
#'   ),
#'   VpcId = "vpc-a01106c2"
#' )}
#'
#' @keywords internal
#'
#' @rdname ec2_modify_vpc_attribute
ec2_modify_vpc_attribute <- function(EnableDnsHostnames = NULL, EnableDnsSupport = NULL, VpcId) {
  op <- new_operation(
    name = "ModifyVpcAttribute",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_vpc_attribute_input(EnableDnsHostnames = EnableDnsHostnames, EnableDnsSupport = EnableDnsSupport, VpcId = VpcId)
  output <- .ec2$modify_vpc_attribute_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_vpc_attribute <- ec2_modify_vpc_attribute

#' Modifies attributes of a specified VPC endpoint
#'
#' Modifies attributes of a specified VPC endpoint. The attributes that you
#' can modify depend on the type of VPC endpoint (interface or gateway).
#' For more information, see [VPC
#' Endpoints](https://docs.aws.amazon.com/vpc/latest/userguide/vpc-endpoints.html)
#' in the *Amazon Virtual Private Cloud User Guide*.
#'
#' @usage
#' ec2_modify_vpc_endpoint(DryRun, VpcEndpointId, ResetPolicy,
#'   PolicyDocument, AddRouteTableIds, RemoveRouteTableIds, AddSubnetIds,
#'   RemoveSubnetIds, AddSecurityGroupIds, RemoveSecurityGroupIds,
#'   PrivateDnsEnabled)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param VpcEndpointId &#91;required&#93; The ID of the endpoint.
#' @param ResetPolicy (Gateway endpoint) Specify `true` to reset the policy document to the
#' default policy. The default policy allows full access to the service.
#' @param PolicyDocument A policy to attach to the endpoint that controls access to the service.
#' The policy must be in valid JSON format.
#' @param AddRouteTableIds (Gateway endpoint) One or more route tables IDs to associate with the
#' endpoint.
#' @param RemoveRouteTableIds (Gateway endpoint) One or more route table IDs to disassociate from the
#' endpoint.
#' @param AddSubnetIds (Interface endpoint) One or more subnet IDs in which to serve the
#' endpoint.
#' @param RemoveSubnetIds (Interface endpoint) One or more subnets IDs in which to remove the
#' endpoint.
#' @param AddSecurityGroupIds (Interface endpoint) One or more security group IDs to associate with
#' the network interface.
#' @param RemoveSecurityGroupIds (Interface endpoint) One or more security group IDs to disassociate from
#' the network interface.
#' @param PrivateDnsEnabled (Interface endpoint) Indicates whether a private hosted zone is
#' associated with the VPC.
#'
#' @section Request syntax:
#' ```
#' svc$modify_vpc_endpoint(
#'   DryRun = TRUE|FALSE,
#'   VpcEndpointId = "string",
#'   ResetPolicy = TRUE|FALSE,
#'   PolicyDocument = "string",
#'   AddRouteTableIds = list(
#'     "string"
#'   ),
#'   RemoveRouteTableIds = list(
#'     "string"
#'   ),
#'   AddSubnetIds = list(
#'     "string"
#'   ),
#'   RemoveSubnetIds = list(
#'     "string"
#'   ),
#'   AddSecurityGroupIds = list(
#'     "string"
#'   ),
#'   RemoveSecurityGroupIds = list(
#'     "string"
#'   ),
#'   PrivateDnsEnabled = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_vpc_endpoint
ec2_modify_vpc_endpoint <- function(DryRun = NULL, VpcEndpointId, ResetPolicy = NULL, PolicyDocument = NULL, AddRouteTableIds = NULL, RemoveRouteTableIds = NULL, AddSubnetIds = NULL, RemoveSubnetIds = NULL, AddSecurityGroupIds = NULL, RemoveSecurityGroupIds = NULL, PrivateDnsEnabled = NULL) {
  op <- new_operation(
    name = "ModifyVpcEndpoint",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_vpc_endpoint_input(DryRun = DryRun, VpcEndpointId = VpcEndpointId, ResetPolicy = ResetPolicy, PolicyDocument = PolicyDocument, AddRouteTableIds = AddRouteTableIds, RemoveRouteTableIds = RemoveRouteTableIds, AddSubnetIds = AddSubnetIds, RemoveSubnetIds = RemoveSubnetIds, AddSecurityGroupIds = AddSecurityGroupIds, RemoveSecurityGroupIds = RemoveSecurityGroupIds, PrivateDnsEnabled = PrivateDnsEnabled)
  output <- .ec2$modify_vpc_endpoint_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_vpc_endpoint <- ec2_modify_vpc_endpoint

#' Modifies a connection notification for VPC endpoint or VPC endpoint
#' service
#'
#' Modifies a connection notification for VPC endpoint or VPC endpoint
#' service. You can change the SNS topic for the notification, or the
#' events for which to be notified.
#'
#' @usage
#' ec2_modify_vpc_endpoint_connection_notification(DryRun,
#'   ConnectionNotificationId, ConnectionNotificationArn, ConnectionEvents)
#'
#' @param DryRun Checks whether you have the required permissions for the action, without
#' actually making the request, and provides an error response. If you have
#' the required permissions, the error response is `DryRunOperation`.
#' Otherwise, it is `UnauthorizedOperation`.
#' @param ConnectionNotificationId &#91;required&#93; The ID of the notification.
#' @param ConnectionNotificationArn The ARN for the SNS topic for the notification.
#' @param ConnectionEvents One or more events for the endpoint. Valid values are `Accept`,
#' `Connect`, `Delete`, and `Reject`.
#'
#' @section Request syntax:
#' ```
#' svc$modify_vpc_endpoint_connection_notification(
#'   DryRun = TRUE|FALSE,
#'   ConnectionNotificationId = "string",
#'   ConnectionNotificationArn = "string",
#'   ConnectionEvents = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname ec2_modify_vpc_endpoint_connection_notification
ec2_modify_vpc_endpoint_connection_notification <- function(DryRun = NULL, ConnectionNotificationId, ConnectionNotificationArn = NULL, ConnectionEvents = NULL) {
  op <- new_operation(
    name = "ModifyVpcEndpointConnectionNotification",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .ec2$modify_vpc_endpoint_connection_notification_input(DryRun = DryRun, ConnectionNotificationId = ConnectionNotificationId, ConnectionNotificationArn = ConnectionNotificationArn, ConnectionEvents = ConnectionEvents)
  output <- .ec2$modify_vpc_endpoint_connection_notification_output()
  config <- get_config()
  svc <- .ec2$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ec2$operations$modify_vpc_endpoint_connection_notification <- ec2_modify_vpc_endpoint_connection_notification

#' Modifies the attributes of your VPC endpoint service configuration
#'
#' Modifies the attributes of your VPC endpoint service configuration. You
#' can change the Network Load Balancers for your service, and you can
#' specify whether acceptance is required for requests to connect to