% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_run_task}
\alias{ecs_run_task}
\title{Starts a new task using the specified task definition}
\usage{
ecs_run_task(capacityProviderStrategy, cluster, count,
  enableECSManagedTags, group, launchType, networkConfiguration,
  overrides, placementConstraints, placementStrategy, platformVersion,
  propagateTags, referenceId, startedBy, tags, taskDefinition)
}
\arguments{
\item{capacityProviderStrategy}{The capacity provider strategy to use for the task.

A capacity provider strategy consists of one or more capacity providers
along with the \code{base} and \code{weight} to assign to them. A capacity
provider must be associated with the cluster to be used in a capacity
provider strategy. The PutClusterCapacityProviders API is used to
associate a capacity provider with a cluster. Only capacity providers
with an \code{ACTIVE} or \code{UPDATING} status can be used.

If a \code{capacityProviderStrategy} is specified, the \code{launchType} parameter
must be omitted. If no \code{capacityProviderStrategy} or \code{launchType} is
specified, the \code{defaultCapacityProviderStrategy} for the cluster is
used.

If specifying a capacity provider that uses an Auto Scaling group, the
capacity provider must already be created. New capacity providers can be
created with the CreateCapacityProvider API operation.

To use a AWS Fargate capacity provider, specify either the \code{FARGATE} or
\code{FARGATE_SPOT} capacity providers. The AWS Fargate capacity providers
are available to all accounts and only need to be associated with a
cluster to be used.

The PutClusterCapacityProviders API operation is used to update the list
of available capacity providers for a cluster after the cluster is
created.}

\item{cluster}{The short name or full Amazon Resource Name (ARN) of the cluster on
which to run your task. If you do not specify a cluster, the default
cluster is assumed.}

\item{count}{The number of instantiations of the specified task to place on your
cluster. You can specify up to 10 tasks per call.}

\item{enableECSManagedTags}{Specifies whether to enable Amazon ECS managed tags for the task. For
more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html}{Tagging Your Amazon ECS Resources}
in the \emph{Amazon Elastic Container Service Developer Guide}.}

\item{group}{The name of the task group to associate with the task. The default value
is the family name of the task definition (for example,
family:my-family-name).}

\item{launchType}{The launch type on which to run your task. For more information, see
\href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html}{Amazon ECS Launch Types}
in the \emph{Amazon Elastic Container Service Developer Guide}.

If a \code{launchType} is specified, the \code{capacityProviderStrategy} parameter
must be omitted.}

\item{networkConfiguration}{The network configuration for the task. This parameter is required for
task definitions that use the \code{awsvpc} network mode to receive their own
elastic network interface, and it is not supported for other network
modes. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/task-networking.html}{Task Networking}
in the \emph{Amazon Elastic Container Service Developer Guide}.}

\item{overrides}{A list of container overrides in JSON format that specify the name of a
container in the specified task definition and the overrides it should
receive. You can override the default command for a container (that is
specified in the task definition or Docker image) with a \code{command}
override. You can also override existing environment variables (that are
specified in the task definition or Docker image) on a container or add
new environment variables to it with an \code{environment} override.

A total of 8192 characters are allowed for overrides. This limit
includes the JSON formatting characters of the override structure.}

\item{placementConstraints}{An array of placement constraint objects to use for the task. You can
specify up to 10 constraints per task (including constraints in the task
definition and those specified at runtime).}

\item{placementStrategy}{The placement strategy objects to use for the task. You can specify a
maximum of five strategy rules per task.}

\item{platformVersion}{The platform version the task should run. A platform version is only
specified for tasks using the Fargate launch type. If one is not
specified, the \code{LATEST} platform version is used by default. For more
information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html}{AWS Fargate Platform Versions}
in the \emph{Amazon Elastic Container Service Developer Guide}.}

\item{propagateTags}{Specifies whether to propagate the tags from the task definition to the
task. If no value is specified, the tags are not propagated. Tags can
only be propagated to the task during task creation. To add tags to a
task after task creation, use the TagResource API action.

An error will be received if you specify the \code{SERVICE} option when
running a task.}

\item{referenceId}{The reference ID to use for the task.}

\item{startedBy}{An optional tag specified when a task is started. For example, if you
automatically trigger a task to run a batch process job, you could apply
a unique identifier for that job to your task with the \code{startedBy}
parameter. You can then identify which tasks belong to that job by
filtering the results of a ListTasks call with the \code{startedBy} value. Up
to 36 letters (uppercase and lowercase), numbers, hyphens, and
underscores are allowed.

If a task is started by an Amazon ECS service, then the \code{startedBy}
parameter contains the deployment ID of the service that starts it.}

\item{tags}{The metadata that you apply to the task to help you categorize and
organize them. Each tag consists of a key and an optional value, both of
which you define.

The following basic restrictions apply to tags:
\itemize{
\item Maximum number of tags per resource - 50
\item For each resource, each tag key must be unique, and each tag key can
have only one value.
\item Maximum key length - 128 Unicode characters in UTF-8
\item Maximum value length - 256 Unicode characters in UTF-8
\item If your tagging schema is used across multiple services and
resources, remember that other services may have restrictions on
allowed characters. Generally allowed characters are: letters,
numbers, and spaces representable in UTF-8, and the following
characters: + - = . \\_ : / @.
\item Tag keys and values are case-sensitive.
\item Do not use \verb{aws:}, \verb{AWS:}, or any upper or lowercase combination of
such as a prefix for either keys or values as it is reserved for AWS
use. You cannot edit or delete tag keys or values with this prefix.
Tags with this prefix do not count against your tags per resource
limit.
}}

\item{taskDefinition}{[required] The \code{family} and \code{revision} (\code{family:revision}) or full ARN of the task
definition to run. If a \code{revision} is not specified, the latest \code{ACTIVE}
revision is used.}
}
\description{
Starts a new task using the specified task definition.
}
\details{
You can allow Amazon ECS to place tasks for you, or you can customize
how Amazon ECS places tasks using placement constraints and placement
strategies. For more information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/scheduling_tasks.html}{Scheduling Tasks}
in the \emph{Amazon Elastic Container Service Developer Guide}.

Alternatively, you can use StartTask to use your own scheduler or place
tasks manually on specific container instances.

The Amazon ECS API follows an eventual consistency model, due to the
distributed nature of the system supporting the API. This means that the
result of an API command you run that affects your Amazon ECS resources
might not be immediately visible to all subsequent commands you run.
Keep this in mind when you carry out an API command that immediately
follows a previous API command.

To manage eventual consistency, you can do the following:
\itemize{
\item Confirm the state of the resource before you run a command to modify
it. Run the DescribeTasks command using an exponential backoff
algorithm to ensure that you allow enough time for the previous
command to propagate through the system. To do this, run the
DescribeTasks command repeatedly, starting with a couple of seconds
of wait time and increasing gradually up to five minutes of wait
time.
\item Add wait time between subsequent commands, even if the DescribeTasks
command returns an accurate response. Apply an exponential backoff
algorithm starting with a couple of seconds of wait time, and
increase gradually up to about five minutes of wait time.
}
}
\section{Request syntax}{
\preformatted{svc$run_task(
  capacityProviderStrategy = list(
    list(
      capacityProvider = "string",
      weight = 123,
      base = 123
    )
  ),
  cluster = "string",
  count = 123,
  enableECSManagedTags = TRUE|FALSE,
  group = "string",
  launchType = "EC2"|"FARGATE",
  networkConfiguration = list(
    awsvpcConfiguration = list(
      subnets = list(
        "string"
      ),
      securityGroups = list(
        "string"
      ),
      assignPublicIp = "ENABLED"|"DISABLED"
    )
  ),
  overrides = list(
    containerOverrides = list(
      list(
        name = "string",
        command = list(
          "string"
        ),
        environment = list(
          list(
            name = "string",
            value = "string"
          )
        ),
        cpu = 123,
        memory = 123,
        memoryReservation = 123,
        resourceRequirements = list(
          list(
            value = "string",
            type = "GPU"|"InferenceAccelerator"
          )
        )
      )
    ),
    cpu = "string",
    inferenceAcceleratorOverrides = list(
      list(
        deviceName = "string",
        deviceType = "string"
      )
    ),
    executionRoleArn = "string",
    memory = "string",
    taskRoleArn = "string"
  ),
  placementConstraints = list(
    list(
      type = "distinctInstance"|"memberOf",
      expression = "string"
    )
  ),
  placementStrategy = list(
    list(
      type = "random"|"spread"|"binpack",
      field = "string"
    )
  ),
  platformVersion = "string",
  propagateTags = "TASK_DEFINITION"|"SERVICE",
  referenceId = "string",
  startedBy = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  taskDefinition = "string"
)
}
}

\examples{
# This example runs the specified task definition on your default cluster.
\donttest{svc$run_task(
  cluster = "default",
  taskDefinition = "sleep360:1"
)}

}
\keyword{internal}
