% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_modify_volume_attribute}
\alias{ec2_modify_volume_attribute}
\title{Modifies a volume attribute}
\usage{
ec2_modify_volume_attribute(AutoEnableIO, VolumeId, DryRun)
}
\arguments{
\item{AutoEnableIO}{Indicates whether the volume should be auto-enabled for I/O operations.}

\item{VolumeId}{[required] The ID of the volume.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Modifies a volume attribute.
}
\details{
By default, all I/O operations for the volume are suspended when the
data on the volume is determined to be potentially inconsistent, to
prevent undetectable, latent data corruption. The I/O access to the
volume can be resumed by first enabling I/O access and then checking the
data consistency on your volume.

You can change the default behavior to resume I/O operations. We
recommend that you change this only for boot volumes or for volumes that
are stateless or disposable.
}
\section{Request syntax}{
\preformatted{svc$modify_volume_attribute(
  AutoEnableIO = list(
    Value = TRUE|FALSE
  ),
  VolumeId = "string",
  DryRun = TRUE|FALSE
)
}
}

\examples{
# This example sets the `autoEnableIo` attribute of the volume with the
# ID `vol-1234567890abcdef0` to `true`. If the command succeeds, no
# output is returned.
\donttest{svc$modify_volume_attribute(
  AutoEnableIO = list(
    Value = TRUE
  ),
  DryRun = TRUE,
  VolumeId = "vol-1234567890abcdef0"
)}

}
\keyword{internal}
