% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_instance_type_offerings}
\alias{ec2_describe_instance_type_offerings}
\title{Returns a list of all instance types offered}
\usage{
ec2_describe_instance_type_offerings(DryRun, LocationType, Filters,
  MaxResults, NextToken)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{LocationType}{The location type.}

\item{Filters}{One or more filters. Filter names and values are case-sensitive.
\itemize{
\item \code{location} - This depends on the location type. For example, if the
location type is \code{region} (default), the location is the Region code
(for example, \code{us-east-2}.)
\item \code{instance-type} - The instance type.
}}

\item{MaxResults}{The maximum number of results to return for the request in a single
page. The remaining results can be seen by sending another request with
the next token value.}

\item{NextToken}{The token to retrieve the next page of results.}
}
\description{
Returns a list of all instance types offered. The results can be
filtered by location (Region or Availability Zone). If no location is
specified, the instance types offered in the current Region are
returned.
}
\section{Request syntax}{
\preformatted{svc$describe_instance_type_offerings(
  DryRun = TRUE|FALSE,
  LocationType = "region"|"availability-zone"|"availability-zone-id",
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
