% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_stop_instance}
\alias{lightsail_stop_instance}
\title{Stops a specific Amazon Lightsail instance that is currently running}
\usage{
lightsail_stop_instance(instanceName, force)
}
\arguments{
\item{instanceName}{[required] The name of the instance (a virtual private server) to stop.}

\item{force}{When set to \code{True}, forces a Lightsail instance that is stuck in a
\code{stopping} state to stop.

Only use the \code{force} parameter if your instance is stuck in the
\code{stopping} state. In any other state, your instance should stop normally
without adding this parameter to your API request.}
}
\description{
Stops a specific Amazon Lightsail instance that is currently running.
}
\details{
When you start a stopped instance, Lightsail assigns a new public IP
address to the instance. To use the same IP address after stopping and
starting an instance, create a static IP address and attach it to the
instance. For more information, see the \href{https://lightsail.aws.amazon.com/ls/docs/en/articles/lightsail-create-static-ip}{Lightsail Dev Guide}.

The \code{stop instance} operation supports tag-based access control via
resource tags applied to the resource identified by instanceName. For
more information, see the \href{https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags}{Lightsail Dev Guide}.
}
\section{Request syntax}{
\preformatted{svc$stop_instance(
  instanceName = "string",
  force = TRUE|FALSE
)
}
}

\keyword{internal}
