% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_create_disk_snapshot}
\alias{lightsail_create_disk_snapshot}
\title{Creates a snapshot of a block storage disk}
\usage{
lightsail_create_disk_snapshot(diskName, diskSnapshotName, instanceName,
  tags)
}
\arguments{
\item{diskName}{The unique name of the source disk (e.g., \code{Disk-Virginia-1}).

This parameter cannot be defined together with the \code{instance name}
parameter. The \code{disk name} and \code{instance name} parameters are mutually
exclusive.}

\item{diskSnapshotName}{[required] The name of the destination disk snapshot (e.g., \code{my-disk-snapshot})
based on the source disk.}

\item{instanceName}{The unique name of the source instance (e.g.,
\code{Amazon_Linux-512MB-Virginia-1}). When this is defined, a snapshot of
the instance's system volume is created.

This parameter cannot be defined together with the \code{disk name}
parameter. The \code{instance name} and \code{disk name} parameters are mutually
exclusive.}

\item{tags}{The tag keys and optional values to add to the resource during create.

To tag a resource after it has been created, see the \code{tag resource}
operation.}
}
\description{
Creates a snapshot of a block storage disk. You can use snapshots for
backups, to make copies of disks, and to save data before shutting down
a Lightsail instance.
}
\details{
You can take a snapshot of an attached disk that is in use; however,
snapshots only capture data that has been written to your disk at the
time the snapshot command is issued. This may exclude any data that has
been cached by any applications or the operating system. If you can
pause any file systems on the disk long enough to take a snapshot, your
snapshot should be complete. Nevertheless, if you cannot pause all file
writes to the disk, you should unmount the disk from within the
Lightsail instance, issue the create disk snapshot command, and then
remount the disk to ensure a consistent and complete snapshot. You may
remount and use your disk while the snapshot status is pending.

You can also use this operation to create a snapshot of an instance's
system volume. You might want to do this, for example, to recover data
from the system volume of a botched instance or to create a backup of
the system volume like you would for a block storage disk. To create a
snapshot of a system volume, just define the \code{instance name} parameter
when issuing the snapshot command, and a snapshot of the defined
instance's system volume will be created. After the snapshot is
available, you can create a block storage disk from the snapshot and
attach it to a running instance to access the data on the disk.

The \code{create disk snapshot} operation supports tag-based access control
via request tags. For more information, see the \href{https://lightsail.aws.amazon.com/ls/docs/en/articles/amazon-lightsail-controlling-access-using-tags}{Lightsail Dev Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_disk_snapshot(
  diskName = "string",
  diskSnapshotName = "string",
  instanceName = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  )
)
}
}

\keyword{internal}
