% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_capacity_reservations}
\alias{ec2_describe_capacity_reservations}
\title{Describes one or more of your Capacity Reservations}
\usage{
ec2_describe_capacity_reservations(CapacityReservationIds, NextToken,
  MaxResults, Filters, DryRun)
}
\arguments{
\item{CapacityReservationIds}{The ID of the Capacity Reservation.}

\item{NextToken}{The token to retrieve the next page of results.}

\item{MaxResults}{The maximum number of results to return for the request in a single
page. The remaining results can be seen by sending another request with
the returned nextToken value.}

\item{Filters}{One or more filters.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}
}
\description{
Describes one or more of your Capacity Reservations. The results
describe only the Capacity Reservations in the AWS Region that you're
currently using.
}
\section{Request syntax}{
\preformatted{svc$describe_capacity_reservations(
  CapacityReservationIds = list(
    "string"
  ),
  NextToken = "string",
  MaxResults = 123,
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  DryRun = TRUE|FALSE
)
}
}

\keyword{internal}
