% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_contact_methods}
\alias{lightsail_get_contact_methods}
\title{Returns information about the configured contact methods}
\usage{
lightsail_get_contact_methods(protocols)
}
\arguments{
\item{protocols}{The protocols used to send notifications, such as \code{Email}, or \code{SMS}
(text messaging).

Specify a protocol in your request to return information about a
specific contact method protocol.}
}
\value{
A list with the following syntax:\preformatted{list(
  contactMethods = list(
    list(
      contactEndpoint = "string",
      status = "PendingVerification"|"Valid"|"Invalid",
      protocol = "Email"|"SMS",
      name = "string",
      arn = "string",
      createdAt = as.POSIXct(
        "2015-01-01"
      ),
      location = list(
        availabilityZone = "string",
        regionName = "us-east-1"|"us-east-2"|"us-west-1"|"us-west-2"|"eu-west-1"|"eu-west-2"|"eu-west-3"|"eu-central-1"|"ca-central-1"|"ap-south-1"|"ap-southeast-1"|"ap-southeast-2"|"ap-northeast-1"|"ap-northeast-2"
      ),
      resourceType = "ContainerService"|"Instance"|"StaticIp"|"KeyPair"|"InstanceSnapshot"|"Domain"|"PeeredVpc"|"LoadBalancer"|"LoadBalancerTlsCertificate"|"Disk"|"DiskSnapshot"|"RelationalDatabase"|"RelationalDatabaseSnapshot"|"ExportSnapshotRecord"|"CloudFormationStackRecord"|"Alarm"|"ContactMethod"|"Distribution"|"Certificate",
      supportCode = "string"
    )
  )
)
}
}
\description{
Returns information about the configured contact methods. Specify a
protocol in your request to return information about a specific contact
method.

A contact method is used to send you notifications about your Amazon
Lightsail resources. You can add one email address and one mobile phone
number contact method in each AWS Region. However, SMS text messaging is
not supported in some AWS Regions, and SMS text messages cannot be sent
to some countries/regions. For more information, see Notifications in
Amazon Lightsail.
}
\section{Request syntax}{
\preformatted{svc$get_contact_methods(
  protocols = list(
    "Email"|"SMS"
  )
)
}
}

\keyword{internal}
