% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lightsail_operations.R
\name{lightsail_get_certificates}
\alias{lightsail_get_certificates}
\title{Returns information about one or more Amazon Lightsail SSL/TLS
certificates}
\usage{
lightsail_get_certificates(certificateStatuses,
  includeCertificateDetails, certificateName)
}
\arguments{
\item{certificateStatuses}{The status of the certificates for which to return information.

For example, specify \code{ISSUED} to return only certificates with an
\code{ISSUED} status.

When omitted, the response includes all of your certificates in the AWS
Region where the request is made, regardless of their current status.}

\item{includeCertificateDetails}{Indicates whether to include detailed information about the certificates
in the response.

When omitted, the response includes only the certificate names, Amazon
Resource Names (ARNs), domain names, and tags.}

\item{certificateName}{The name for the certificate for which to return information.

When omitted, the response includes all of your certificates in the AWS
Region where the request is made.}
}
\value{
A list with the following syntax:\preformatted{list(
  certificates = list(
    list(
      certificateArn = "string",
      certificateName = "string",
      domainName = "string",
      certificateDetail = list(
        arn = "string",
        name = "string",
        domainName = "string",
        status = "PENDING_VALIDATION"|"ISSUED"|"INACTIVE"|"EXPIRED"|"VALIDATION_TIMED_OUT"|"REVOKED"|"FAILED",
        serialNumber = "string",
        subjectAlternativeNames = list(
          "string"
        ),
        domainValidationRecords = list(
          list(
            domainName = "string",
            resourceRecord = list(
              name = "string",
              type = "string",
              value = "string"
            )
          )
        ),
        requestFailureReason = "string",
        inUseResourceCount = 123,
        keyAlgorithm = "string",
        createdAt = as.POSIXct(
          "2015-01-01"
        ),
        issuedAt = as.POSIXct(
          "2015-01-01"
        ),
        issuerCA = "string",
        notBefore = as.POSIXct(
          "2015-01-01"
        ),
        notAfter = as.POSIXct(
          "2015-01-01"
        ),
        eligibleToRenew = "string",
        renewalSummary = list(
          domainValidationRecords = list(
            list(
              domainName = "string",
              resourceRecord = list(
                name = "string",
                type = "string",
                value = "string"
              )
            )
          ),
          renewalStatus = "PendingAutoRenewal"|"PendingValidation"|"Success"|"Failed",
          renewalStatusReason = "string",
          updatedAt = as.POSIXct(
            "2015-01-01"
          )
        ),
        revokedAt = as.POSIXct(
          "2015-01-01"
        ),
        revocationReason = "string",
        tags = list(
          list(
            key = "string",
            value = "string"
          )
        ),
        supportCode = "string"
      ),
      tags = list(
        list(
          key = "string",
          value = "string"
        )
      )
    )
  )
)
}
}
\description{
Returns information about one or more Amazon Lightsail SSL/TLS
certificates.

To get a summary of a certificate, ommit \code{includeCertificateDetails}
from your request. The response will include only the certificate Amazon
Resource Name (ARN), certificate name, domain name, and tags.
}
\section{Request syntax}{
\preformatted{svc$get_certificates(
  certificateStatuses = list(
    "PENDING_VALIDATION"|"ISSUED"|"INACTIVE"|"EXPIRED"|"VALIDATION_TIMED_OUT"|"REVOKED"|"FAILED"
  ),
  includeCertificateDetails = TRUE|FALSE,
  certificateName = "string"
)
}
}

\keyword{internal}
