% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lambda_operations.R
\name{lambda_get_layer_version_policy}
\alias{lambda_get_layer_version_policy}
\title{Returns the permission policy for a version of an AWS Lambda layer}
\usage{
lambda_get_layer_version_policy(LayerName, VersionNumber)
}
\arguments{
\item{LayerName}{[required] The name or Amazon Resource Name (ARN) of the layer.}

\item{VersionNumber}{[required] The version number.}
}
\value{
A list with the following syntax:\preformatted{list(
  Policy = "string",
  RevisionId = "string"
)
}
}
\description{
Returns the permission policy for a version of an \href{https://docs.aws.amazon.com/lambda/latest/dg/configuration-layers.html}{AWS Lambda layer}.
For more information, see
\code{\link[=lambda_add_layer_version_permission]{add_layer_version_permission}}.
}
\section{Request syntax}{
\preformatted{svc$get_layer_version_policy(
  LayerName = "string",
  VersionNumber = 123
)
}
}

\keyword{internal}
