% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_network_interface}
\alias{ec2_create_network_interface}
\title{Creates a network interface in the specified subnet}
\usage{
ec2_create_network_interface(Description, DryRun, Groups,
  Ipv6AddressCount, Ipv6Addresses, PrivateIpAddress, PrivateIpAddresses,
  SecondaryPrivateIpAddressCount, InterfaceType, SubnetId,
  TagSpecifications)
}
\arguments{
\item{Description}{A description for the network interface.}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Groups}{The IDs of one or more security groups.}

\item{Ipv6AddressCount}{The number of IPv6 addresses to assign to a network interface. Amazon
EC2 automatically selects the IPv6 addresses from the subnet range. You
can't use this option if specifying specific IPv6 addresses. If your
subnet has the \code{AssignIpv6AddressOnCreation} attribute set to \code{true},
you can specify \code{0} to override this setting.}

\item{Ipv6Addresses}{One or more specific IPv6 addresses from the IPv6 CIDR block range of
your subnet. You can't use this option if you're specifying a number of
IPv6 addresses.}

\item{PrivateIpAddress}{The primary private IPv4 address of the network interface. If you don't
specify an IPv4 address, Amazon EC2 selects one for you from the
subnet's IPv4 CIDR range. If you specify an IP address, you cannot
indicate any IP addresses specified in \code{privateIpAddresses} as primary
(only one IP address can be designated as primary).}

\item{PrivateIpAddresses}{One or more private IPv4 addresses.}

\item{SecondaryPrivateIpAddressCount}{The number of secondary private IPv4 addresses to assign to a network
interface. When you specify a number of secondary IPv4 addresses, Amazon
EC2 selects these IP addresses within the subnet's IPv4 CIDR range. You
can't specify this option and specify more than one private IP address
using \code{privateIpAddresses}.

The number of IP addresses you can assign to a network interface varies
by instance type. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html#AvailableIpPerENI}{IP Addresses Per ENI Per Instance Type}
in the \emph{Amazon Virtual Private Cloud User Guide}.}

\item{InterfaceType}{Indicates the type of network interface. To create an Elastic Fabric
Adapter (EFA), specify \code{efa}. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/efa.html}{Elastic Fabric Adapter}
in the \emph{Amazon Elastic Compute Cloud User Guide}.}

\item{SubnetId}{[required] The ID of the subnet to associate with the network interface.}

\item{TagSpecifications}{The tags to apply to the new network interface.}
}
\value{
A list with the following syntax:\preformatted{list(
  NetworkInterface = list(
    Association = list(
      AllocationId = "string",
      AssociationId = "string",
      IpOwnerId = "string",
      PublicDnsName = "string",
      PublicIp = "string",
      CustomerOwnedIp = "string",
      CarrierIp = "string"
    ),
    Attachment = list(
      AttachTime = as.POSIXct(
        "2015-01-01"
      ),
      AttachmentId = "string",
      DeleteOnTermination = TRUE|FALSE,
      DeviceIndex = 123,
      NetworkCardIndex = 123,
      InstanceId = "string",
      InstanceOwnerId = "string",
      Status = "attaching"|"attached"|"detaching"|"detached"
    ),
    AvailabilityZone = "string",
    Description = "string",
    Groups = list(
      list(
        GroupName = "string",
        GroupId = "string"
      )
    ),
    InterfaceType = "interface"|"natGateway"|"efa",
    Ipv6Addresses = list(
      list(
        Ipv6Address = "string"
      )
    ),
    MacAddress = "string",
    NetworkInterfaceId = "string",
    OutpostArn = "string",
    OwnerId = "string",
    PrivateDnsName = "string",
    PrivateIpAddress = "string",
    PrivateIpAddresses = list(
      list(
        Association = list(
          AllocationId = "string",
          AssociationId = "string",
          IpOwnerId = "string",
          PublicDnsName = "string",
          PublicIp = "string",
          CustomerOwnedIp = "string",
          CarrierIp = "string"
        ),
        Primary = TRUE|FALSE,
        PrivateDnsName = "string",
        PrivateIpAddress = "string"
      )
    ),
    RequesterId = "string",
    RequesterManaged = TRUE|FALSE,
    SourceDestCheck = TRUE|FALSE,
    Status = "available"|"associated"|"attaching"|"in-use"|"detaching",
    SubnetId = "string",
    TagSet = list(
      list(
        Key = "string",
        Value = "string"
      )
    ),
    VpcId = "string"
  )
)
}
}
\description{
Creates a network interface in the specified subnet.

For more information about network interfaces, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/using-eni.html}{Elastic Network Interfaces}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_network_interface(
  Description = "string",
  DryRun = TRUE|FALSE,
  Groups = list(
    "string"
  ),
  Ipv6AddressCount = 123,
  Ipv6Addresses = list(
    list(
      Ipv6Address = "string"
    )
  ),
  PrivateIpAddress = "string",
  PrivateIpAddresses = list(
    list(
      Primary = TRUE|FALSE,
      PrivateIpAddress = "string"
    )
  ),
  SecondaryPrivateIpAddressCount = 123,
  InterfaceType = "efa",
  SubnetId = "string",
  TagSpecifications = list(
    list(
      ResourceType = "client-vpn-endpoint"|"customer-gateway"|"dedicated-host"|"dhcp-options"|"egress-only-internet-gateway"|"elastic-ip"|"elastic-gpu"|"export-image-task"|"export-instance-task"|"fleet"|"fpga-image"|"host-reservation"|"image"|"import-image-task"|"import-snapshot-task"|"instance"|"internet-gateway"|"key-pair"|"launch-template"|"local-gateway-route-table-vpc-association"|"natgateway"|"network-acl"|"network-interface"|"network-insights-analysis"|"network-insights-path"|"placement-group"|"reserved-instances"|"route-table"|"security-group"|"snapshot"|"spot-fleet-request"|"spot-instances-request"|"subnet"|"traffic-mirror-filter"|"traffic-mirror-session"|"traffic-mirror-target"|"transit-gateway"|"transit-gateway-attachment"|"transit-gateway-connect-peer"|"transit-gateway-multicast-domain"|"transit-gateway-route-table"|"volume"|"vpc"|"vpc-peering-connection"|"vpn-connection"|"vpn-gateway"|"vpc-flow-log",
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      )
    )
  )
)
}
}

\examples{
\dontrun{
# This example creates a network interface for the specified subnet.
svc$create_network_interface(
  Description = "my network interface",
  Groups = list(
    "sg-903004f8"
  ),
  PrivateIpAddress = "10.0.2.17",
  SubnetId = "subnet-9d4a7b6c"
)
}

}
\keyword{internal}
