# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include elasticbeanstalk_service.R
NULL

#' Cancels in-progress environment configuration update or application
#' version deployment
#'
#' @description
#' Cancels in-progress environment configuration update or application
#' version deployment.
#'
#' @usage
#' elasticbeanstalk_abort_environment_update(EnvironmentId,
#'   EnvironmentName)
#'
#' @param EnvironmentId This specifies the ID of the environment with the in-progress update
#' that you want to cancel.
#' @param EnvironmentName This specifies the name of the environment with the in-progress update
#' that you want to cancel.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$abort_environment_update(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following code aborts a running application version deployment for
#' # an environment named my-env:
#' svc$abort_environment_update(
#'   EnvironmentName = "my-env"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_abort_environment_update
elasticbeanstalk_abort_environment_update <- function(EnvironmentId = NULL, EnvironmentName = NULL) {
  op <- new_operation(
    name = "AbortEnvironmentUpdate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$abort_environment_update_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$abort_environment_update_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$abort_environment_update <- elasticbeanstalk_abort_environment_update

#' Applies a scheduled managed action immediately
#'
#' @description
#' Applies a scheduled managed action immediately. A managed action can be
#' applied only if its status is `Scheduled`. Get the status and action ID
#' of a managed action with
#' [`describe_environment_managed_actions`][elasticbeanstalk_describe_environment_managed_actions].
#'
#' @usage
#' elasticbeanstalk_apply_environment_managed_action(EnvironmentName,
#'   EnvironmentId, ActionId)
#'
#' @param EnvironmentName The name of the target environment.
#' @param EnvironmentId The environment ID of the target environment.
#' @param ActionId &#91;required&#93; The action ID of the scheduled managed action to execute.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ActionId = "string",
#'   ActionDescription = "string",
#'   ActionType = "InstanceRefresh"|"PlatformUpdate"|"Unknown",
#'   Status = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$apply_environment_managed_action(
#'   EnvironmentName = "string",
#'   EnvironmentId = "string",
#'   ActionId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_apply_environment_managed_action
elasticbeanstalk_apply_environment_managed_action <- function(EnvironmentName = NULL, EnvironmentId = NULL, ActionId) {
  op <- new_operation(
    name = "ApplyEnvironmentManagedAction",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$apply_environment_managed_action_input(EnvironmentName = EnvironmentName, EnvironmentId = EnvironmentId, ActionId = ActionId)
  output <- .elasticbeanstalk$apply_environment_managed_action_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$apply_environment_managed_action <- elasticbeanstalk_apply_environment_managed_action

#' Add or change the operations role used by an environment
#'
#' @description
#' Add or change the operations role used by an environment. After this
#' call is made, Elastic Beanstalk uses the associated operations role for
#' permissions to downstream services during subsequent calls acting on
#' this environment. For more information, see [Operations
#' roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/) in the
#' *AWS Elastic Beanstalk Developer Guide*.
#'
#' @usage
#' elasticbeanstalk_associate_environment_operations_role(EnvironmentName,
#'   OperationsRole)
#'
#' @param EnvironmentName &#91;required&#93; The name of the environment to which to set the operations role.
#' @param OperationsRole &#91;required&#93; The Amazon Resource Name (ARN) of an existing IAM role to be used as the
#' environment's operations role.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$associate_environment_operations_role(
#'   EnvironmentName = "string",
#'   OperationsRole = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_associate_environment_operations_role
elasticbeanstalk_associate_environment_operations_role <- function(EnvironmentName, OperationsRole) {
  op <- new_operation(
    name = "AssociateEnvironmentOperationsRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$associate_environment_operations_role_input(EnvironmentName = EnvironmentName, OperationsRole = OperationsRole)
  output <- .elasticbeanstalk$associate_environment_operations_role_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$associate_environment_operations_role <- elasticbeanstalk_associate_environment_operations_role

#' Checks if the specified CNAME is available
#'
#' @description
#' Checks if the specified CNAME is available.
#'
#' @usage
#' elasticbeanstalk_check_dns_availability(CNAMEPrefix)
#'
#' @param CNAMEPrefix &#91;required&#93; The prefix used when this CNAME is reserved.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Available = TRUE|FALSE,
#'   FullyQualifiedCNAME = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$check_dns_availability(
#'   CNAMEPrefix = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation checks the availability of the subdomain
#' # my-cname:
#' svc$check_dns_availability(
#'   CNAMEPrefix = "my-cname"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_check_dns_availability
elasticbeanstalk_check_dns_availability <- function(CNAMEPrefix) {
  op <- new_operation(
    name = "CheckDNSAvailability",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$check_dns_availability_input(CNAMEPrefix = CNAMEPrefix)
  output <- .elasticbeanstalk$check_dns_availability_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$check_dns_availability <- elasticbeanstalk_check_dns_availability

#' Create or update a group of environments that each run a separate
#' component of a single application
#'
#' @description
#' Create or update a group of environments that each run a separate
#' component of a single application. Takes a list of version labels that
#' specify application source bundles for each of the environments to
#' create or update. The name of each environment and other required
#' information must be included in the source bundles in an environment
#' manifest named `env.yaml`. See [Compose
#' Environments](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-mgmt-compose.html)
#' for details.
#'
#' @usage
#' elasticbeanstalk_compose_environments(ApplicationName, GroupName,
#'   VersionLabels)
#'
#' @param ApplicationName The name of the application to which the specified source bundles
#' belong.
#' @param GroupName The name of the group to which the target environments belong. Specify a
#' group name only if the environment name defined in each target
#' environment's manifest ends with a + (plus) character. See [Environment
#' Manifest
#' (env.yaml)](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html)
#' for details.
#' @param VersionLabels A list of version labels, specifying one or more application source
#' bundles that belong to the target application. Each source bundle must
#' include an environment manifest that specifies the name of the
#' environment and the name of the solution stack to use, and optionally
#' can specify environment links to create.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Environments = list(
#'     list(
#'       EnvironmentName = "string",
#'       EnvironmentId = "string",
#'       ApplicationName = "string",
#'       VersionLabel = "string",
#'       SolutionStackName = "string",
#'       PlatformArn = "string",
#'       TemplateName = "string",
#'       Description = "string",
#'       EndpointURL = "string",
#'       CNAME = "string",
#'       DateCreated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       DateUpdated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Status = "Aborting"|"Launching"|"Updating"|"LinkingFrom"|"LinkingTo"|"Ready"|"Terminating"|"Terminated",
#'       AbortableOperationInProgress = TRUE|FALSE,
#'       Health = "Green"|"Yellow"|"Red"|"Grey",
#'       HealthStatus = "NoData"|"Unknown"|"Pending"|"Ok"|"Info"|"Warning"|"Degraded"|"Severe"|"Suspended",
#'       Resources = list(
#'         LoadBalancer = list(
#'           LoadBalancerName = "string",
#'           Domain = "string",
#'           Listeners = list(
#'             list(
#'               Protocol = "string",
#'               Port = 123
#'             )
#'           )
#'         )
#'       ),
#'       Tier = list(
#'         Name = "string",
#'         Type = "string",
#'         Version = "string"
#'       ),
#'       EnvironmentLinks = list(
#'         list(
#'           LinkName = "string",
#'           EnvironmentName = "string"
#'         )
#'       ),
#'       EnvironmentArn = "string",
#'       OperationsRole = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$compose_environments(
#'   ApplicationName = "string",
#'   GroupName = "string",
#'   VersionLabels = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_compose_environments
elasticbeanstalk_compose_environments <- function(ApplicationName = NULL, GroupName = NULL, VersionLabels = NULL) {
  op <- new_operation(
    name = "ComposeEnvironments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$compose_environments_input(ApplicationName = ApplicationName, GroupName = GroupName, VersionLabels = VersionLabels)
  output <- .elasticbeanstalk$compose_environments_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$compose_environments <- elasticbeanstalk_compose_environments

#' Creates an application that has one configuration template named default
#' and no application versions
#'
#' @description
#' Creates an application that has one configuration template named
#' `default` and no application versions.
#'
#' @usage
#' elasticbeanstalk_create_application(ApplicationName, Description,
#'   ResourceLifecycleConfig, Tags)
#'
#' @param ApplicationName &#91;required&#93; The name of the application. Must be unique within your account.
#' @param Description Your description of the application.
#' @param ResourceLifecycleConfig Specifies an application resource lifecycle configuration to prevent
#' your application from accumulating too many versions.
#' @param Tags Specifies the tags applied to the application.
#' 
#' Elastic Beanstalk applies these tags only to the application.
#' Environments that you create in the application don't inherit the tags.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Application = list(
#'     ApplicationArn = "string",
#'     ApplicationName = "string",
#'     Description = "string",
#'     DateCreated = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     DateUpdated = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Versions = list(
#'       "string"
#'     ),
#'     ConfigurationTemplates = list(
#'       "string"
#'     ),
#'     ResourceLifecycleConfig = list(
#'       ServiceRole = "string",
#'       VersionLifecycleConfig = list(
#'         MaxCountRule = list(
#'           Enabled = TRUE|FALSE,
#'           MaxCount = 123,
#'           DeleteSourceFromS3 = TRUE|FALSE
#'         ),
#'         MaxAgeRule = list(
#'           Enabled = TRUE|FALSE,
#'           MaxAgeInDays = 123,
#'           DeleteSourceFromS3 = TRUE|FALSE
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_application(
#'   ApplicationName = "string",
#'   Description = "string",
#'   ResourceLifecycleConfig = list(
#'     ServiceRole = "string",
#'     VersionLifecycleConfig = list(
#'       MaxCountRule = list(
#'         Enabled = TRUE|FALSE,
#'         MaxCount = 123,
#'         DeleteSourceFromS3 = TRUE|FALSE
#'       ),
#'       MaxAgeRule = list(
#'         Enabled = TRUE|FALSE,
#'         MaxAgeInDays = 123,
#'         DeleteSourceFromS3 = TRUE|FALSE
#'       )
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation creates a new application named my-app:
#' svc$create_application(
#'   ApplicationName = "my-app",
#'   Description = "my application"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_application
elasticbeanstalk_create_application <- function(ApplicationName, Description = NULL, ResourceLifecycleConfig = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_application_input(ApplicationName = ApplicationName, Description = Description, ResourceLifecycleConfig = ResourceLifecycleConfig, Tags = Tags)
  output <- .elasticbeanstalk$create_application_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_application <- elasticbeanstalk_create_application

#' Creates an application version for the specified application
#'
#' @description
#' Creates an application version for the specified application. You can
#' create an application version from a source bundle in Amazon S3, a
#' commit in AWS CodeCommit, or the output of an AWS CodeBuild build as
#' follows:
#' 
#' Specify a commit in an AWS CodeCommit repository with
#' `SourceBuildInformation`.
#' 
#' Specify a build in an AWS CodeBuild with `SourceBuildInformation` and
#' `BuildConfiguration`.
#' 
#' Specify a source bundle in S3 with `SourceBundle`
#' 
#' Omit both `SourceBuildInformation` and `SourceBundle` to use the default
#' sample application.
#' 
#' After you create an application version with a specified Amazon S3
#' bucket and key location, you can't change that Amazon S3 location. If
#' you change the Amazon S3 location, you receive an exception when you
#' attempt to launch an environment from the application version.
#'
#' @usage
#' elasticbeanstalk_create_application_version(ApplicationName,
#'   VersionLabel, Description, SourceBuildInformation, SourceBundle,
#'   BuildConfiguration, AutoCreateApplication, Process, Tags)
#'
#' @param ApplicationName &#91;required&#93; The name of the application. If no application is found with this name,
#' and `AutoCreateApplication` is `false`, returns an
#' `InvalidParameterValue` error.
#' @param VersionLabel &#91;required&#93; A label identifying this version.
#' 
#' Constraint: Must be unique per application. If an application version
#' already exists with this label for the specified application, AWS
#' Elastic Beanstalk returns an `InvalidParameterValue` error.
#' @param Description A description of this application version.
#' @param SourceBuildInformation Specify a commit in an AWS CodeCommit Git repository to use as the
#' source code for the application version.
#' @param SourceBundle The Amazon S3 bucket and key that identify the location of the source
#' bundle for this version.
#' 
#' The Amazon S3 bucket must be in the same region as the environment.
#' 
#' Specify a source bundle in S3 or a commit in an AWS CodeCommit
#' repository (with `SourceBuildInformation`), but not both. If neither
#' `SourceBundle` nor `SourceBuildInformation` are provided, Elastic
#' Beanstalk uses a sample application.
#' @param BuildConfiguration Settings for an AWS CodeBuild build.
#' @param AutoCreateApplication Set to `true` to create an application with the specified name if it
#' doesn't already exist.
#' @param Process Pre-processes and validates the environment manifest (`env.yaml`) and
#' configuration files (`*.config` files in the `.ebextensions` folder) in
#' the source bundle. Validating configuration files can identify issues
#' prior to deploying the application version to an environment.
#' 
#' You must turn processing on for application versions that you create
#' using AWS CodeBuild or AWS CodeCommit. For application versions built
#' from a source bundle in Amazon S3, processing is optional.
#' 
#' The `Process` option validates Elastic Beanstalk configuration files. It
#' doesn't validate your application's configuration files, like proxy
#' server or Docker configuration.
#' @param Tags Specifies the tags applied to the application version.
#' 
#' Elastic Beanstalk applies these tags only to the application version.
#' Environments that use the application version don't inherit the tags.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ApplicationVersion = list(
#'     ApplicationVersionArn = "string",
#'     ApplicationName = "string",
#'     Description = "string",
#'     VersionLabel = "string",
#'     SourceBuildInformation = list(
#'       SourceType = "Git"|"Zip",
#'       SourceRepository = "CodeCommit"|"S3",
#'       SourceLocation = "string"
#'     ),
#'     BuildArn = "string",
#'     SourceBundle = list(
#'       S3Bucket = "string",
#'       S3Key = "string"
#'     ),
#'     DateCreated = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     DateUpdated = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Status = "Processed"|"Unprocessed"|"Failed"|"Processing"|"Building"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_application_version(
#'   ApplicationName = "string",
#'   VersionLabel = "string",
#'   Description = "string",
#'   SourceBuildInformation = list(
#'     SourceType = "Git"|"Zip",
#'     SourceRepository = "CodeCommit"|"S3",
#'     SourceLocation = "string"
#'   ),
#'   SourceBundle = list(
#'     S3Bucket = "string",
#'     S3Key = "string"
#'   ),
#'   BuildConfiguration = list(
#'     ArtifactName = "string",
#'     CodeBuildServiceRole = "string",
#'     ComputeType = "BUILD_GENERAL1_SMALL"|"BUILD_GENERAL1_MEDIUM"|"BUILD_GENERAL1_LARGE",
#'     Image = "string",
#'     TimeoutInMinutes = 123
#'   ),
#'   AutoCreateApplication = TRUE|FALSE,
#'   Process = TRUE|FALSE,
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation creates a new version (v1) of an application
#' # named my-app:
#' svc$create_application_version(
#'   ApplicationName = "my-app",
#'   AutoCreateApplication = TRUE,
#'   Description = "my-app-v1",
#'   Process = TRUE,
#'   SourceBundle = list(
#'     S3Bucket = "my-bucket",
#'     S3Key = "sample.war"
#'   ),
#'   VersionLabel = "v1"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_application_version
elasticbeanstalk_create_application_version <- function(ApplicationName, VersionLabel, Description = NULL, SourceBuildInformation = NULL, SourceBundle = NULL, BuildConfiguration = NULL, AutoCreateApplication = NULL, Process = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateApplicationVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_application_version_input(ApplicationName = ApplicationName, VersionLabel = VersionLabel, Description = Description, SourceBuildInformation = SourceBuildInformation, SourceBundle = SourceBundle, BuildConfiguration = BuildConfiguration, AutoCreateApplication = AutoCreateApplication, Process = Process, Tags = Tags)
  output <- .elasticbeanstalk$create_application_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_application_version <- elasticbeanstalk_create_application_version

#' Creates an AWS Elastic Beanstalk configuration template, associated with
#' a specific Elastic Beanstalk application
#'
#' @description
#' Creates an AWS Elastic Beanstalk configuration template, associated with
#' a specific Elastic Beanstalk application. You define application
#' configuration settings in a configuration template. You can then use the
#' configuration template to deploy different versions of the application
#' with the same configuration settings.
#' 
#' Templates aren't associated with any environment. The `EnvironmentName`
#' response element is always `null`.
#' 
#' Related Topics
#' 
#' -   [`describe_configuration_options`][elasticbeanstalk_describe_configuration_options]
#' 
#' -   [`describe_configuration_settings`][elasticbeanstalk_describe_configuration_settings]
#' 
#' -   [`list_available_solution_stacks`][elasticbeanstalk_list_available_solution_stacks]
#'
#' @usage
#' elasticbeanstalk_create_configuration_template(ApplicationName,
#'   TemplateName, SolutionStackName, PlatformArn, SourceConfiguration,
#'   EnvironmentId, Description, OptionSettings, Tags)
#'
#' @param ApplicationName &#91;required&#93; The name of the Elastic Beanstalk application to associate with this
#' configuration template.
#' @param TemplateName &#91;required&#93; The name of the configuration template.
#' 
#' Constraint: This name must be unique per application.
#' @param SolutionStackName The name of an Elastic Beanstalk solution stack (platform version) that
#' this configuration uses. For example,
#' `64bit Amazon Linux 2013.09 running Tomcat 7 Java 7`. A solution stack
#' specifies the operating system, runtime, and application server for a
#' configuration template. It also determines the set of configuration
#' options as well as the possible and default values. For more
#' information, see [Supported
#' Platforms](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/concepts.platforms.html)
#' in the *AWS Elastic Beanstalk Developer Guide*.
#' 
#' You must specify `SolutionStackName` if you don't specify `PlatformArn`,
#' `EnvironmentId`, or `SourceConfiguration`.
#' 
#' Use the
#' [`list_available_solution_stacks`](https://docs.aws.amazon.com/elasticbeanstalk/latest/api/API_ListAvailableSolutionStacks.html)
#' API to obtain a list of available solution stacks.
#' @param PlatformArn The Amazon Resource Name (ARN) of the custom platform. For more
#' information, see [Custom
#' Platforms](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html)
#' in the *AWS Elastic Beanstalk Developer Guide*.
#' 
#' If you specify `PlatformArn`, then don't specify `SolutionStackName`.
#' @param SourceConfiguration An Elastic Beanstalk configuration template to base this one on. If
#' specified, Elastic Beanstalk uses the configuration values from the
#' specified configuration template to create a new configuration.
#' 
#' Values specified in `OptionSettings` override any values obtained from
#' the `SourceConfiguration`.
#' 
#' You must specify `SourceConfiguration` if you don't specify
#' `PlatformArn`, `EnvironmentId`, or `SolutionStackName`.
#' 
#' Constraint: If both solution stack name and source configuration are
#' specified, the solution stack of the source configuration template must
#' match the specified solution stack name.
#' @param EnvironmentId The ID of an environment whose settings you want to use to create the
#' configuration template. You must specify `EnvironmentId` if you don't
#' specify `PlatformArn`, `SolutionStackName`, or `SourceConfiguration`.
#' @param Description An optional description for this configuration.
#' @param OptionSettings Option values for the Elastic Beanstalk configuration, such as the
#' instance type. If specified, these values override the values obtained
#' from the solution stack or the source configuration template. For a
#' complete list of Elastic Beanstalk configuration options, see [Option
#' Values](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/command-options.html)
#' in the *AWS Elastic Beanstalk Developer Guide*.
#' @param Tags Specifies the tags applied to the configuration template.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SolutionStackName = "string",
#'   PlatformArn = "string",
#'   ApplicationName = "string",
#'   TemplateName = "string",
#'   Description = "string",
#'   EnvironmentName = "string",
#'   DeploymentStatus = "deployed"|"pending"|"failed",
#'   DateCreated = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   DateUpdated = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   OptionSettings = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_configuration_template(
#'   ApplicationName = "string",
#'   TemplateName = "string",
#'   SolutionStackName = "string",
#'   PlatformArn = "string",
#'   SourceConfiguration = list(
#'     ApplicationName = "string",
#'     TemplateName = "string"
#'   ),
#'   EnvironmentId = "string",
#'   Description = "string",
#'   OptionSettings = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string",
#'       Value = "string"
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation creates a configuration template named my-app-v1
#' # from the settings applied to an environment with the id e-rpqsewtp2j:
#' svc$create_configuration_template(
#'   ApplicationName = "my-app",
#'   EnvironmentId = "e-rpqsewtp2j",
#'   TemplateName = "my-app-v1"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_configuration_template
elasticbeanstalk_create_configuration_template <- function(ApplicationName, TemplateName, SolutionStackName = NULL, PlatformArn = NULL, SourceConfiguration = NULL, EnvironmentId = NULL, Description = NULL, OptionSettings = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateConfigurationTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_configuration_template_input(ApplicationName = ApplicationName, TemplateName = TemplateName, SolutionStackName = SolutionStackName, PlatformArn = PlatformArn, SourceConfiguration = SourceConfiguration, EnvironmentId = EnvironmentId, Description = Description, OptionSettings = OptionSettings, Tags = Tags)
  output <- .elasticbeanstalk$create_configuration_template_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_configuration_template <- elasticbeanstalk_create_configuration_template

#' Launches an AWS Elastic Beanstalk environment for the specified
#' application using the specified configuration
#'
#' @description
#' Launches an AWS Elastic Beanstalk environment for the specified
#' application using the specified configuration.
#'
#' @usage
#' elasticbeanstalk_create_environment(ApplicationName, EnvironmentName,
#'   GroupName, Description, CNAMEPrefix, Tier, Tags, VersionLabel,
#'   TemplateName, SolutionStackName, PlatformArn, OptionSettings,
#'   OptionsToRemove, OperationsRole)
#'
#' @param ApplicationName &#91;required&#93; The name of the application that is associated with this environment.
#' @param EnvironmentName A unique name for the environment.
#' 
#' Constraint: Must be from 4 to 40 characters in length. The name can
#' contain only letters, numbers, and hyphens. It can't start or end with a
#' hyphen. This name must be unique within a region in your account. If the
#' specified name already exists in the region, Elastic Beanstalk returns
#' an `InvalidParameterValue` error.
#' 
#' If you don't specify the `CNAMEPrefix` parameter, the environment name
#' becomes part of the CNAME, and therefore part of the visible URL for
#' your application.
#' @param GroupName The name of the group to which the target environment belongs. Specify a
#' group name only if the environment's name is specified in an environment
#' manifest and not with the environment name parameter. See [Environment
#' Manifest
#' (env.yaml)](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html)
#' for details.
#' @param Description Your description for this environment.
#' @param CNAMEPrefix If specified, the environment attempts to use this value as the prefix
#' for the CNAME in your Elastic Beanstalk environment URL. If not
#' specified, the CNAME is generated automatically by appending a random
#' alphanumeric string to the environment name.
#' @param Tier Specifies the tier to use in creating this environment. The environment
#' tier that you choose determines whether Elastic Beanstalk provisions
#' resources to support a web application that handles HTTP(S) requests or
#' a web application that handles background-processing tasks.
#' @param Tags Specifies the tags applied to resources in the environment.
#' @param VersionLabel The name of the application version to deploy.
#' 
#' Default: If not specified, Elastic Beanstalk attempts to deploy the
#' sample application.
#' @param TemplateName The name of the Elastic Beanstalk configuration template to use with the
#' environment.
#' 
#' If you specify `TemplateName`, then don't specify `SolutionStackName`.
#' @param SolutionStackName The name of an Elastic Beanstalk solution stack (platform version) to
#' use with the environment. If specified, Elastic Beanstalk sets the
#' configuration values to the default values associated with the specified
#' solution stack. For a list of current solution stacks, see [Elastic
#' Beanstalk Supported
#' Platforms](https://docs.aws.amazon.com/elasticbeanstalk/latest/platforms/platforms-supported.html)
#' in the *AWS Elastic Beanstalk Platforms* guide.
#' 
#' If you specify `SolutionStackName`, don't specify `PlatformArn` or
#' `TemplateName`.
#' @param PlatformArn The Amazon Resource Name (ARN) of the custom platform to use with the
#' environment. For more information, see [Custom
#' Platforms](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/custom-platforms.html)
#' in the *AWS Elastic Beanstalk Developer Guide*.
#' 
#' If you specify `PlatformArn`, don't specify `SolutionStackName`.
#' @param OptionSettings If specified, AWS Elastic Beanstalk sets the specified configuration
#' options to the requested value in the configuration set for the new
#' environment. These override the values obtained from the solution stack
#' or the configuration template.
#' @param OptionsToRemove A list of custom user-defined configuration options to remove from the
#' configuration set for this new environment.
#' @param OperationsRole The Amazon Resource Name (ARN) of an existing IAM role to be used as the
#' environment's operations role. If specified, Elastic Beanstalk uses the
#' operations role for permissions to downstream services during this call
#' and during subsequent calls acting on this environment. To specify an
#' operations role, you must have the `iam:PassRole` permission for the
#' role. For more information, see [Operations
#' roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/) in the
#' *AWS Elastic Beanstalk Developer Guide*.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   EnvironmentName = "string",
#'   EnvironmentId = "string",
#'   ApplicationName = "string",
#'   VersionLabel = "string",
#'   SolutionStackName = "string",
#'   PlatformArn = "string",
#'   TemplateName = "string",
#'   Description = "string",
#'   EndpointURL = "string",
#'   CNAME = "string",
#'   DateCreated = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   DateUpdated = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Status = "Aborting"|"Launching"|"Updating"|"LinkingFrom"|"LinkingTo"|"Ready"|"Terminating"|"Terminated",
#'   AbortableOperationInProgress = TRUE|FALSE,
#'   Health = "Green"|"Yellow"|"Red"|"Grey",
#'   HealthStatus = "NoData"|"Unknown"|"Pending"|"Ok"|"Info"|"Warning"|"Degraded"|"Severe"|"Suspended",
#'   Resources = list(
#'     LoadBalancer = list(
#'       LoadBalancerName = "string",
#'       Domain = "string",
#'       Listeners = list(
#'         list(
#'           Protocol = "string",
#'           Port = 123
#'         )
#'       )
#'     )
#'   ),
#'   Tier = list(
#'     Name = "string",
#'     Type = "string",
#'     Version = "string"
#'   ),
#'   EnvironmentLinks = list(
#'     list(
#'       LinkName = "string",
#'       EnvironmentName = "string"
#'     )
#'   ),
#'   EnvironmentArn = "string",
#'   OperationsRole = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_environment(
#'   ApplicationName = "string",
#'   EnvironmentName = "string",
#'   GroupName = "string",
#'   Description = "string",
#'   CNAMEPrefix = "string",
#'   Tier = list(
#'     Name = "string",
#'     Type = "string",
#'     Version = "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   VersionLabel = "string",
#'   TemplateName = "string",
#'   SolutionStackName = "string",
#'   PlatformArn = "string",
#'   OptionSettings = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string",
#'       Value = "string"
#'     )
#'   ),
#'   OptionsToRemove = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string"
#'     )
#'   ),
#'   OperationsRole = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation creates a new environment for version v1 of a
#' # java application named my-app:
#' svc$create_environment(
#'   ApplicationName = "my-app",
#'   CNAMEPrefix = "my-app",
#'   EnvironmentName = "my-env",
#'   SolutionStackName = "64bit Amazon Linux 2015.03 v2.0.0 running Tomcat 8 Java 8",
#'   VersionLabel = "v1"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_environment
elasticbeanstalk_create_environment <- function(ApplicationName, EnvironmentName = NULL, GroupName = NULL, Description = NULL, CNAMEPrefix = NULL, Tier = NULL, Tags = NULL, VersionLabel = NULL, TemplateName = NULL, SolutionStackName = NULL, PlatformArn = NULL, OptionSettings = NULL, OptionsToRemove = NULL, OperationsRole = NULL) {
  op <- new_operation(
    name = "CreateEnvironment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_environment_input(ApplicationName = ApplicationName, EnvironmentName = EnvironmentName, GroupName = GroupName, Description = Description, CNAMEPrefix = CNAMEPrefix, Tier = Tier, Tags = Tags, VersionLabel = VersionLabel, TemplateName = TemplateName, SolutionStackName = SolutionStackName, PlatformArn = PlatformArn, OptionSettings = OptionSettings, OptionsToRemove = OptionsToRemove, OperationsRole = OperationsRole)
  output <- .elasticbeanstalk$create_environment_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_environment <- elasticbeanstalk_create_environment

#' Create a new version of your custom platform
#'
#' @description
#' Create a new version of your custom platform.
#'
#' @usage
#' elasticbeanstalk_create_platform_version(PlatformName, PlatformVersion,
#'   PlatformDefinitionBundle, EnvironmentName, OptionSettings, Tags)
#'
#' @param PlatformName &#91;required&#93; The name of your custom platform.
#' @param PlatformVersion &#91;required&#93; The number, such as 1.0.2, for the new platform version.
#' @param PlatformDefinitionBundle &#91;required&#93; The location of the platform definition archive in Amazon S3.
#' @param EnvironmentName The name of the builder environment.
#' @param OptionSettings The configuration option settings to apply to the builder environment.
#' @param Tags Specifies the tags applied to the new platform version.
#' 
#' Elastic Beanstalk applies these tags only to the platform version.
#' Environments that you create using the platform version don't inherit
#' the tags.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PlatformSummary = list(
#'     PlatformArn = "string",
#'     PlatformOwner = "string",
#'     PlatformStatus = "Creating"|"Failed"|"Ready"|"Deleting"|"Deleted",
#'     PlatformCategory = "string",
#'     OperatingSystemName = "string",
#'     OperatingSystemVersion = "string",
#'     SupportedTierList = list(
#'       "string"
#'     ),
#'     SupportedAddonList = list(
#'       "string"
#'     ),
#'     PlatformLifecycleState = "string",
#'     PlatformVersion = "string",
#'     PlatformBranchName = "string",
#'     PlatformBranchLifecycleState = "string"
#'   ),
#'   Builder = list(
#'     ARN = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$create_platform_version(
#'   PlatformName = "string",
#'   PlatformVersion = "string",
#'   PlatformDefinitionBundle = list(
#'     S3Bucket = "string",
#'     S3Key = "string"
#'   ),
#'   EnvironmentName = "string",
#'   OptionSettings = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string",
#'       Value = "string"
#'     )
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_platform_version
elasticbeanstalk_create_platform_version <- function(PlatformName, PlatformVersion, PlatformDefinitionBundle, EnvironmentName = NULL, OptionSettings = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreatePlatformVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_platform_version_input(PlatformName = PlatformName, PlatformVersion = PlatformVersion, PlatformDefinitionBundle = PlatformDefinitionBundle, EnvironmentName = EnvironmentName, OptionSettings = OptionSettings, Tags = Tags)
  output <- .elasticbeanstalk$create_platform_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_platform_version <- elasticbeanstalk_create_platform_version

#' Creates a bucket in Amazon S3 to store application versions, logs, and
#' other files used by Elastic Beanstalk environments
#'
#' @description
#' Creates a bucket in Amazon S3 to store application versions, logs, and
#' other files used by Elastic Beanstalk environments. The Elastic
#' Beanstalk console and EB CLI call this API the first time you create an
#' environment in a region. If the storage location already exists,
#' [`create_storage_location`][elasticbeanstalk_create_storage_location]
#' still returns the bucket name but does not create a new bucket.
#'
#' @usage
#' elasticbeanstalk_create_storage_location()
#'

#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   S3Bucket = "string"
#' )
#' ```
#'

#'
#' @examples
#' \dontrun{
#' # The following operation creates a new environment for version v1 of a
#' # java application named my-app:
#' svc$create_storage_location()
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_create_storage_location
elasticbeanstalk_create_storage_location <- function() {
  op <- new_operation(
    name = "CreateStorageLocation",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$create_storage_location_input()
  output <- .elasticbeanstalk$create_storage_location_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$create_storage_location <- elasticbeanstalk_create_storage_location

#' Deletes the specified application along with all associated versions and
#' configurations
#'
#' @description
#' Deletes the specified application along with all associated versions and
#' configurations. The application versions will not be deleted from your
#' Amazon S3 bucket.
#' 
#' You cannot delete an application that has a running environment.
#'
#' @usage
#' elasticbeanstalk_delete_application(ApplicationName,
#'   TerminateEnvByForce)
#'
#' @param ApplicationName &#91;required&#93; The name of the application to delete.
#' @param TerminateEnvByForce When set to true, running environments will be terminated before
#' deleting the application.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application(
#'   ApplicationName = "string",
#'   TerminateEnvByForce = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation deletes an application named my-app:
#' svc$delete_application(
#'   ApplicationName = "my-app"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_delete_application
elasticbeanstalk_delete_application <- function(ApplicationName, TerminateEnvByForce = NULL) {
  op <- new_operation(
    name = "DeleteApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$delete_application_input(ApplicationName = ApplicationName, TerminateEnvByForce = TerminateEnvByForce)
  output <- .elasticbeanstalk$delete_application_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$delete_application <- elasticbeanstalk_delete_application

#' Deletes the specified version from the specified application
#'
#' @description
#' Deletes the specified version from the specified application.
#' 
#' You cannot delete an application version that is associated with a
#' running environment.
#'
#' @usage
#' elasticbeanstalk_delete_application_version(ApplicationName,
#'   VersionLabel, DeleteSourceBundle)
#'
#' @param ApplicationName &#91;required&#93; The name of the application to which the version belongs.
#' @param VersionLabel &#91;required&#93; The label of the version to delete.
#' @param DeleteSourceBundle Set to `true` to delete the source bundle from your storage bucket.
#' Otherwise, the application version is deleted only from Elastic
#' Beanstalk and the source bundle remains in Amazon S3.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_application_version(
#'   ApplicationName = "string",
#'   VersionLabel = "string",
#'   DeleteSourceBundle = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation deletes an application version named
#' # 22a0-stage-150819_182129 for an application named my-app:
#' svc$delete_application_version(
#'   ApplicationName = "my-app",
#'   DeleteSourceBundle = TRUE,
#'   VersionLabel = "22a0-stage-150819_182129"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_delete_application_version
elasticbeanstalk_delete_application_version <- function(ApplicationName, VersionLabel, DeleteSourceBundle = NULL) {
  op <- new_operation(
    name = "DeleteApplicationVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$delete_application_version_input(ApplicationName = ApplicationName, VersionLabel = VersionLabel, DeleteSourceBundle = DeleteSourceBundle)
  output <- .elasticbeanstalk$delete_application_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$delete_application_version <- elasticbeanstalk_delete_application_version

#' Deletes the specified configuration template
#'
#' @description
#' Deletes the specified configuration template.
#' 
#' When you launch an environment using a configuration template, the
#' environment gets a copy of the template. You can delete or modify the
#' environment's copy of the template without affecting the running
#' environment.
#'
#' @usage
#' elasticbeanstalk_delete_configuration_template(ApplicationName,
#'   TemplateName)
#'
#' @param ApplicationName &#91;required&#93; The name of the application to delete the configuration template from.
#' @param TemplateName &#91;required&#93; The name of the configuration template to delete.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_configuration_template(
#'   ApplicationName = "string",
#'   TemplateName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation deletes a configuration template named
#' # my-template for an application named my-app:
#' svc$delete_configuration_template(
#'   ApplicationName = "my-app",
#'   TemplateName = "my-template"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_delete_configuration_template
elasticbeanstalk_delete_configuration_template <- function(ApplicationName, TemplateName) {
  op <- new_operation(
    name = "DeleteConfigurationTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$delete_configuration_template_input(ApplicationName = ApplicationName, TemplateName = TemplateName)
  output <- .elasticbeanstalk$delete_configuration_template_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$delete_configuration_template <- elasticbeanstalk_delete_configuration_template

#' Deletes the draft configuration associated with the running environment
#'
#' @description
#' Deletes the draft configuration associated with the running environment.
#' 
#' Updating a running environment with any configuration changes creates a
#' draft configuration set. You can get the draft configuration using
#' [`describe_configuration_settings`][elasticbeanstalk_describe_configuration_settings]
#' while the update is in progress or if the update fails. The
#' `DeploymentStatus` for the draft configuration indicates whether the
#' deployment is in process or has failed. The draft configuration remains
#' in existence until it is deleted with this action.
#'
#' @usage
#' elasticbeanstalk_delete_environment_configuration(ApplicationName,
#'   EnvironmentName)
#'
#' @param ApplicationName &#91;required&#93; The name of the application the environment is associated with.
#' @param EnvironmentName &#91;required&#93; The name of the environment to delete the draft configuration from.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$delete_environment_configuration(
#'   ApplicationName = "string",
#'   EnvironmentName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation deletes a draft configuration for an environment
#' # named my-env:
#' svc$delete_environment_configuration(
#'   ApplicationName = "my-app",
#'   EnvironmentName = "my-env"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_delete_environment_configuration
elasticbeanstalk_delete_environment_configuration <- function(ApplicationName, EnvironmentName) {
  op <- new_operation(
    name = "DeleteEnvironmentConfiguration",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$delete_environment_configuration_input(ApplicationName = ApplicationName, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$delete_environment_configuration_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$delete_environment_configuration <- elasticbeanstalk_delete_environment_configuration

#' Deletes the specified version of a custom platform
#'
#' @description
#' Deletes the specified version of a custom platform.
#'
#' @usage
#' elasticbeanstalk_delete_platform_version(PlatformArn)
#'
#' @param PlatformArn The ARN of the version of the custom platform.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PlatformSummary = list(
#'     PlatformArn = "string",
#'     PlatformOwner = "string",
#'     PlatformStatus = "Creating"|"Failed"|"Ready"|"Deleting"|"Deleted",
#'     PlatformCategory = "string",
#'     OperatingSystemName = "string",
#'     OperatingSystemVersion = "string",
#'     SupportedTierList = list(
#'       "string"
#'     ),
#'     SupportedAddonList = list(
#'       "string"
#'     ),
#'     PlatformLifecycleState = "string",
#'     PlatformVersion = "string",
#'     PlatformBranchName = "string",
#'     PlatformBranchLifecycleState = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$delete_platform_version(
#'   PlatformArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_delete_platform_version
elasticbeanstalk_delete_platform_version <- function(PlatformArn = NULL) {
  op <- new_operation(
    name = "DeletePlatformVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$delete_platform_version_input(PlatformArn = PlatformArn)
  output <- .elasticbeanstalk$delete_platform_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$delete_platform_version <- elasticbeanstalk_delete_platform_version

#' Returns attributes related to AWS Elastic Beanstalk that are associated
#' with the calling AWS account
#'
#' @description
#' Returns attributes related to AWS Elastic Beanstalk that are associated
#' with the calling AWS account.
#' 
#' The result currently has one set of attributes—resource quotas.
#'
#' @usage
#' elasticbeanstalk_describe_account_attributes()
#'

#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ResourceQuotas = list(
#'     ApplicationQuota = list(
#'       Maximum = 123
#'     ),
#'     ApplicationVersionQuota = list(
#'       Maximum = 123
#'     ),
#'     EnvironmentQuota = list(
#'       Maximum = 123
#'     ),
#'     ConfigurationTemplateQuota = list(
#'       Maximum = 123
#'     ),
#'     CustomPlatformQuota = list(
#'       Maximum = 123
#'     )
#'   )
#' )
#' ```
#'

#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_account_attributes
elasticbeanstalk_describe_account_attributes <- function() {
  op <- new_operation(
    name = "DescribeAccountAttributes",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_account_attributes_input()
  output <- .elasticbeanstalk$describe_account_attributes_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_account_attributes <- elasticbeanstalk_describe_account_attributes

#' Retrieve a list of application versions
#'
#' @description
#' Retrieve a list of application versions.
#'
#' @usage
#' elasticbeanstalk_describe_application_versions(ApplicationName,
#'   VersionLabels, MaxRecords, NextToken)
#'
#' @param ApplicationName Specify an application name to show only application versions for that
#' application.
#' @param VersionLabels Specify a version label to show a specific application version.
#' @param MaxRecords For a paginated request. Specify a maximum number of application
#' versions to include in each response.
#' 
#' If no `MaxRecords` is specified, all available application versions are
#' retrieved in a single response.
#' @param NextToken For a paginated request. Specify a token from a previous response page
#' to retrieve the next response page. All other parameter values must be
#' identical to the ones specified in the initial request.
#' 
#' If no `NextToken` is specified, the first page is retrieved.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ApplicationVersions = list(
#'     list(
#'       ApplicationVersionArn = "string",
#'       ApplicationName = "string",
#'       Description = "string",
#'       VersionLabel = "string",
#'       SourceBuildInformation = list(
#'         SourceType = "Git"|"Zip",
#'         SourceRepository = "CodeCommit"|"S3",
#'         SourceLocation = "string"
#'       ),
#'       BuildArn = "string",
#'       SourceBundle = list(
#'         S3Bucket = "string",
#'         S3Key = "string"
#'       ),
#'       DateCreated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       DateUpdated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Status = "Processed"|"Unprocessed"|"Failed"|"Processing"|"Building"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_application_versions(
#'   ApplicationName = "string",
#'   VersionLabels = list(
#'     "string"
#'   ),
#'   MaxRecords = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation retrieves information about an application
#' # version labeled v2:
#' svc$describe_application_versions(
#'   ApplicationName = "my-app",
#'   VersionLabels = list(
#'     "v2"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_application_versions
elasticbeanstalk_describe_application_versions <- function(ApplicationName = NULL, VersionLabels = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeApplicationVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_application_versions_input(ApplicationName = ApplicationName, VersionLabels = VersionLabels, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .elasticbeanstalk$describe_application_versions_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_application_versions <- elasticbeanstalk_describe_application_versions

#' Returns the descriptions of existing applications
#'
#' @description
#' Returns the descriptions of existing applications.
#'
#' @usage
#' elasticbeanstalk_describe_applications(ApplicationNames)
#'
#' @param ApplicationNames If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to only include those with the specified names.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Applications = list(
#'     list(
#'       ApplicationArn = "string",
#'       ApplicationName = "string",
#'       Description = "string",
#'       DateCreated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       DateUpdated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Versions = list(
#'         "string"
#'       ),
#'       ConfigurationTemplates = list(
#'         "string"
#'       ),
#'       ResourceLifecycleConfig = list(
#'         ServiceRole = "string",
#'         VersionLifecycleConfig = list(
#'           MaxCountRule = list(
#'             Enabled = TRUE|FALSE,
#'             MaxCount = 123,
#'             DeleteSourceFromS3 = TRUE|FALSE
#'           ),
#'           MaxAgeRule = list(
#'             Enabled = TRUE|FALSE,
#'             MaxAgeInDays = 123,
#'             DeleteSourceFromS3 = TRUE|FALSE
#'           )
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_applications(
#'   ApplicationNames = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation retrieves information about applications in the
#' # current region:
#' svc$describe_applications()
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_applications
elasticbeanstalk_describe_applications <- function(ApplicationNames = NULL) {
  op <- new_operation(
    name = "DescribeApplications",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_applications_input(ApplicationNames = ApplicationNames)
  output <- .elasticbeanstalk$describe_applications_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_applications <- elasticbeanstalk_describe_applications

#' Describes the configuration options that are used in a particular
#' configuration template or environment, or that a specified solution
#' stack defines
#'
#' @description
#' Describes the configuration options that are used in a particular
#' configuration template or environment, or that a specified solution
#' stack defines. The description includes the values the options, their
#' default values, and an indication of the required action on a running
#' environment if an option value is changed.
#'
#' @usage
#' elasticbeanstalk_describe_configuration_options(ApplicationName,
#'   TemplateName, EnvironmentName, SolutionStackName, PlatformArn, Options)
#'
#' @param ApplicationName The name of the application associated with the configuration template
#' or environment. Only needed if you want to describe the configuration
#' options associated with either the configuration template or
#' environment.
#' @param TemplateName The name of the configuration template whose configuration options you
#' want to describe.
#' @param EnvironmentName The name of the environment whose configuration options you want to
#' describe.
#' @param SolutionStackName The name of the solution stack whose configuration options you want to
#' describe.
#' @param PlatformArn The ARN of the custom platform.
#' @param Options If specified, restricts the descriptions to only the specified options.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SolutionStackName = "string",
#'   PlatformArn = "string",
#'   Options = list(
#'     list(
#'       Namespace = "string",
#'       Name = "string",
#'       DefaultValue = "string",
#'       ChangeSeverity = "string",
#'       UserDefined = TRUE|FALSE,
#'       ValueType = "Scalar"|"List",
#'       ValueOptions = list(
#'         "string"
#'       ),
#'       MinValue = 123,
#'       MaxValue = 123,
#'       MaxLength = 123,
#'       Regex = list(
#'         Pattern = "string",
#'         Label = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_configuration_options(
#'   ApplicationName = "string",
#'   TemplateName = "string",
#'   EnvironmentName = "string",
#'   SolutionStackName = "string",
#'   PlatformArn = "string",
#'   Options = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation retrieves descriptions of all available
#' # configuration options for an environment named my-env:
#' svc$describe_configuration_options(
#'   ApplicationName = "my-app",
#'   EnvironmentName = "my-env"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_configuration_options
elasticbeanstalk_describe_configuration_options <- function(ApplicationName = NULL, TemplateName = NULL, EnvironmentName = NULL, SolutionStackName = NULL, PlatformArn = NULL, Options = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationOptions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_configuration_options_input(ApplicationName = ApplicationName, TemplateName = TemplateName, EnvironmentName = EnvironmentName, SolutionStackName = SolutionStackName, PlatformArn = PlatformArn, Options = Options)
  output <- .elasticbeanstalk$describe_configuration_options_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_configuration_options <- elasticbeanstalk_describe_configuration_options

#' Returns a description of the settings for the specified configuration
#' set, that is, either a configuration template or the configuration set
#' associated with a running environment
#'
#' @description
#' Returns a description of the settings for the specified configuration
#' set, that is, either a configuration template or the configuration set
#' associated with a running environment.
#' 
#' When describing the settings for the configuration set associated with a
#' running environment, it is possible to receive two sets of setting
#' descriptions. One is the deployed configuration set, and the other is a
#' draft configuration of an environment that is either in the process of
#' deployment or that failed to deploy.
#' 
#' Related Topics
#' 
#' -   [`delete_environment_configuration`][elasticbeanstalk_delete_environment_configuration]
#'
#' @usage
#' elasticbeanstalk_describe_configuration_settings(ApplicationName,
#'   TemplateName, EnvironmentName)
#'
#' @param ApplicationName &#91;required&#93; The application for the environment or configuration template.
#' @param TemplateName The name of the configuration template to describe.
#' 
#' Conditional: You must specify either this parameter or an
#' EnvironmentName, but not both. If you specify both, AWS Elastic
#' Beanstalk returns an `InvalidParameterCombination` error. If you do not
#' specify either, AWS Elastic Beanstalk returns a
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to describe.
#' 
#' Condition: You must specify either this or a TemplateName, but not both.
#' If you specify both, AWS Elastic Beanstalk returns an
#' `InvalidParameterCombination` error. If you do not specify either, AWS
#' Elastic Beanstalk returns `MissingRequiredParameter` error.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ConfigurationSettings = list(
#'     list(
#'       SolutionStackName = "string",
#'       PlatformArn = "string",
#'       ApplicationName = "string",
#'       TemplateName = "string",
#'       Description = "string",
#'       EnvironmentName = "string",
#'       DeploymentStatus = "deployed"|"pending"|"failed",
#'       DateCreated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       DateUpdated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       OptionSettings = list(
#'         list(
#'           ResourceName = "string",
#'           Namespace = "string",
#'           OptionName = "string",
#'           Value = "string"
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_configuration_settings(
#'   ApplicationName = "string",
#'   TemplateName = "string",
#'   EnvironmentName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation retrieves configuration settings for an
#' # environment named my-env:
#' svc$describe_configuration_settings(
#'   ApplicationName = "my-app",
#'   EnvironmentName = "my-env"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_configuration_settings
elasticbeanstalk_describe_configuration_settings <- function(ApplicationName, TemplateName = NULL, EnvironmentName = NULL) {
  op <- new_operation(
    name = "DescribeConfigurationSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_configuration_settings_input(ApplicationName = ApplicationName, TemplateName = TemplateName, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$describe_configuration_settings_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_configuration_settings <- elasticbeanstalk_describe_configuration_settings

#' Returns information about the overall health of the specified
#' environment
#'
#' @description
#' Returns information about the overall health of the specified
#' environment. The **DescribeEnvironmentHealth** operation is only
#' available with AWS Elastic Beanstalk Enhanced Health.
#'
#' @usage
#' elasticbeanstalk_describe_environment_health(EnvironmentName,
#'   EnvironmentId, AttributeNames)
#'
#' @param EnvironmentName Specify the environment by name.
#' 
#' You must specify either this or an EnvironmentName, or both.
#' @param EnvironmentId Specify the environment by ID.
#' 
#' You must specify either this or an EnvironmentName, or both.
#' @param AttributeNames Specify the response elements to return. To retrieve all attributes, set
#' to `All`. If no attribute names are specified, returns the name of the
#' environment.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   EnvironmentName = "string",
#'   HealthStatus = "string",
#'   Status = "Green"|"Yellow"|"Red"|"Grey",
#'   Color = "string",
#'   Causes = list(
#'     "string"
#'   ),
#'   ApplicationMetrics = list(
#'     Duration = 123,
#'     RequestCount = 123,
#'     StatusCodes = list(
#'       Status2xx = 123,
#'       Status3xx = 123,
#'       Status4xx = 123,
#'       Status5xx = 123
#'     ),
#'     Latency = list(
#'       P999 = 123.0,
#'       P99 = 123.0,
#'       P95 = 123.0,
#'       P90 = 123.0,
#'       P85 = 123.0,
#'       P75 = 123.0,
#'       P50 = 123.0,
#'       P10 = 123.0
#'     )
#'   ),
#'   InstancesHealth = list(
#'     NoData = 123,
#'     Unknown = 123,
#'     Pending = 123,
#'     Ok = 123,
#'     Info = 123,
#'     Warning = 123,
#'     Degraded = 123,
#'     Severe = 123
#'   ),
#'   RefreshedAt = as.POSIXct(
#'     "2015-01-01"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_environment_health(
#'   EnvironmentName = "string",
#'   EnvironmentId = "string",
#'   AttributeNames = list(
#'     "Status"|"Color"|"Causes"|"ApplicationMetrics"|"InstancesHealth"|"All"|"HealthStatus"|"RefreshedAt"
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation retrieves overall health information for an
#' # environment named my-env:
#' svc$describe_environment_health(
#'   AttributeNames = list(
#'     "All"
#'   ),
#'   EnvironmentName = "my-env"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_environment_health
elasticbeanstalk_describe_environment_health <- function(EnvironmentName = NULL, EnvironmentId = NULL, AttributeNames = NULL) {
  op <- new_operation(
    name = "DescribeEnvironmentHealth",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_environment_health_input(EnvironmentName = EnvironmentName, EnvironmentId = EnvironmentId, AttributeNames = AttributeNames)
  output <- .elasticbeanstalk$describe_environment_health_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_environment_health <- elasticbeanstalk_describe_environment_health

#' Lists an environment's completed and failed managed actions
#'
#' @description
#' Lists an environment's completed and failed managed actions.
#'
#' @usage
#' elasticbeanstalk_describe_environment_managed_action_history(
#'   EnvironmentId, EnvironmentName, NextToken, MaxItems)
#'
#' @param EnvironmentId The environment ID of the target environment.
#' @param EnvironmentName The name of the target environment.
#' @param NextToken The pagination token returned by a previous request.
#' @param MaxItems The maximum number of items to return for a single request.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ManagedActionHistoryItems = list(
#'     list(
#'       ActionId = "string",
#'       ActionType = "InstanceRefresh"|"PlatformUpdate"|"Unknown",
#'       ActionDescription = "string",
#'       FailureType = "UpdateCancelled"|"CancellationFailed"|"RollbackFailed"|"RollbackSuccessful"|"InternalFailure"|"InvalidEnvironmentState"|"PermissionsError",
#'       Status = "Completed"|"Failed"|"Unknown",
#'       FailureDescription = "string",
#'       ExecutedTime = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       FinishedTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_environment_managed_action_history(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string",
#'   NextToken = "string",
#'   MaxItems = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_environment_managed_action_history
elasticbeanstalk_describe_environment_managed_action_history <- function(EnvironmentId = NULL, EnvironmentName = NULL, NextToken = NULL, MaxItems = NULL) {
  op <- new_operation(
    name = "DescribeEnvironmentManagedActionHistory",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_environment_managed_action_history_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, NextToken = NextToken, MaxItems = MaxItems)
  output <- .elasticbeanstalk$describe_environment_managed_action_history_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_environment_managed_action_history <- elasticbeanstalk_describe_environment_managed_action_history

#' Lists an environment's upcoming and in-progress managed actions
#'
#' @description
#' Lists an environment's upcoming and in-progress managed actions.
#'
#' @usage
#' elasticbeanstalk_describe_environment_managed_actions(EnvironmentName,
#'   EnvironmentId, Status)
#'
#' @param EnvironmentName The name of the target environment.
#' @param EnvironmentId The environment ID of the target environment.
#' @param Status To show only actions with a particular status, specify a status.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ManagedActions = list(
#'     list(
#'       ActionId = "string",
#'       ActionDescription = "string",
#'       ActionType = "InstanceRefresh"|"PlatformUpdate"|"Unknown",
#'       Status = "Scheduled"|"Pending"|"Running"|"Unknown",
#'       WindowStartTime = as.POSIXct(
#'         "2015-01-01"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_environment_managed_actions(
#'   EnvironmentName = "string",
#'   EnvironmentId = "string",
#'   Status = "Scheduled"|"Pending"|"Running"|"Unknown"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_environment_managed_actions
elasticbeanstalk_describe_environment_managed_actions <- function(EnvironmentName = NULL, EnvironmentId = NULL, Status = NULL) {
  op <- new_operation(
    name = "DescribeEnvironmentManagedActions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_environment_managed_actions_input(EnvironmentName = EnvironmentName, EnvironmentId = EnvironmentId, Status = Status)
  output <- .elasticbeanstalk$describe_environment_managed_actions_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_environment_managed_actions <- elasticbeanstalk_describe_environment_managed_actions

#' Returns AWS resources for this environment
#'
#' @description
#' Returns AWS resources for this environment.
#'
#' @usage
#' elasticbeanstalk_describe_environment_resources(EnvironmentId,
#'   EnvironmentName)
#'
#' @param EnvironmentId The ID of the environment to retrieve AWS resource usage data.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to retrieve AWS resource usage data.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   EnvironmentResources = list(
#'     EnvironmentName = "string",
#'     AutoScalingGroups = list(
#'       list(
#'         Name = "string"
#'       )
#'     ),
#'     Instances = list(
#'       list(
#'         Id = "string"
#'       )
#'     ),
#'     LaunchConfigurations = list(
#'       list(
#'         Name = "string"
#'       )
#'     ),
#'     LaunchTemplates = list(
#'       list(
#'         Id = "string"
#'       )
#'     ),
#'     LoadBalancers = list(
#'       list(
#'         Name = "string"
#'       )
#'     ),
#'     Triggers = list(
#'       list(
#'         Name = "string"
#'       )
#'     ),
#'     Queues = list(
#'       list(
#'         Name = "string",
#'         URL = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_environment_resources(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation retrieves information about resources in an
#' # environment named my-env:
#' svc$describe_environment_resources(
#'   EnvironmentName = "my-env"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_environment_resources
elasticbeanstalk_describe_environment_resources <- function(EnvironmentId = NULL, EnvironmentName = NULL) {
  op <- new_operation(
    name = "DescribeEnvironmentResources",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_environment_resources_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$describe_environment_resources_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_environment_resources <- elasticbeanstalk_describe_environment_resources

#' Returns descriptions for existing environments
#'
#' @description
#' Returns descriptions for existing environments.
#'
#' @usage
#' elasticbeanstalk_describe_environments(ApplicationName, VersionLabel,
#'   EnvironmentIds, EnvironmentNames, IncludeDeleted, IncludedDeletedBackTo,
#'   MaxRecords, NextToken)
#'
#' @param ApplicationName If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to include only those that are associated with this application.
#' @param VersionLabel If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to include only those that are associated with this application version.
#' @param EnvironmentIds If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to include only those that have the specified IDs.
#' @param EnvironmentNames If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to include only those that have the specified names.
#' @param IncludeDeleted Indicates whether to include deleted environments:
#' 
#' `true`: Environments that have been deleted after
#' `IncludedDeletedBackTo` are displayed.
#' 
#' `false`: Do not include deleted environments.
#' @param IncludedDeletedBackTo If specified when `IncludeDeleted` is set to `true`, then environments
#' deleted after this date are displayed.
#' @param MaxRecords For a paginated request. Specify a maximum number of environments to
#' include in each response.
#' 
#' If no `MaxRecords` is specified, all available environments are
#' retrieved in a single response.
#' @param NextToken For a paginated request. Specify a token from a previous response page
#' to retrieve the next response page. All other parameter values must be
#' identical to the ones specified in the initial request.
#' 
#' If no `NextToken` is specified, the first page is retrieved.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Environments = list(
#'     list(
#'       EnvironmentName = "string",
#'       EnvironmentId = "string",
#'       ApplicationName = "string",
#'       VersionLabel = "string",
#'       SolutionStackName = "string",
#'       PlatformArn = "string",
#'       TemplateName = "string",
#'       Description = "string",
#'       EndpointURL = "string",
#'       CNAME = "string",
#'       DateCreated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       DateUpdated = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Status = "Aborting"|"Launching"|"Updating"|"LinkingFrom"|"LinkingTo"|"Ready"|"Terminating"|"Terminated",
#'       AbortableOperationInProgress = TRUE|FALSE,
#'       Health = "Green"|"Yellow"|"Red"|"Grey",
#'       HealthStatus = "NoData"|"Unknown"|"Pending"|"Ok"|"Info"|"Warning"|"Degraded"|"Severe"|"Suspended",
#'       Resources = list(
#'         LoadBalancer = list(
#'           LoadBalancerName = "string",
#'           Domain = "string",
#'           Listeners = list(
#'             list(
#'               Protocol = "string",
#'               Port = 123
#'             )
#'           )
#'         )
#'       ),
#'       Tier = list(
#'         Name = "string",
#'         Type = "string",
#'         Version = "string"
#'       ),
#'       EnvironmentLinks = list(
#'         list(
#'           LinkName = "string",
#'           EnvironmentName = "string"
#'         )
#'       ),
#'       EnvironmentArn = "string",
#'       OperationsRole = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_environments(
#'   ApplicationName = "string",
#'   VersionLabel = "string",
#'   EnvironmentIds = list(
#'     "string"
#'   ),
#'   EnvironmentNames = list(
#'     "string"
#'   ),
#'   IncludeDeleted = TRUE|FALSE,
#'   IncludedDeletedBackTo = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxRecords = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation retrieves information about an environment named
#' # my-env:
#' svc$describe_environments(
#'   EnvironmentNames = list(
#'     "my-env"
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_environments
elasticbeanstalk_describe_environments <- function(ApplicationName = NULL, VersionLabel = NULL, EnvironmentIds = NULL, EnvironmentNames = NULL, IncludeDeleted = NULL, IncludedDeletedBackTo = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeEnvironments",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_environments_input(ApplicationName = ApplicationName, VersionLabel = VersionLabel, EnvironmentIds = EnvironmentIds, EnvironmentNames = EnvironmentNames, IncludeDeleted = IncludeDeleted, IncludedDeletedBackTo = IncludedDeletedBackTo, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .elasticbeanstalk$describe_environments_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_environments <- elasticbeanstalk_describe_environments

#' Returns list of event descriptions matching criteria up to the last 6
#' weeks
#'
#' @description
#' Returns list of event descriptions matching criteria up to the last 6
#' weeks.
#' 
#' This action returns the most recent 1,000 events from the specified
#' `NextToken`.
#'
#' @usage
#' elasticbeanstalk_describe_events(ApplicationName, VersionLabel,
#'   TemplateName, EnvironmentId, EnvironmentName, PlatformArn, RequestId,
#'   Severity, StartTime, EndTime, MaxRecords, NextToken)
#'
#' @param ApplicationName If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to include only those associated with this application.
#' @param VersionLabel If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those associated with this application version.
#' @param TemplateName If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those that are associated with this environment configuration.
#' @param EnvironmentId If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those associated with this environment.
#' @param EnvironmentName If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those associated with this environment.
#' @param PlatformArn The ARN of a custom platform version. If specified, AWS Elastic
#' Beanstalk restricts the returned descriptions to those associated with
#' this custom platform version.
#' @param RequestId If specified, AWS Elastic Beanstalk restricts the described events to
#' include only those associated with this request ID.
#' @param Severity If specified, limits the events returned from this call to include only
#' those with the specified severity or higher.
#' @param StartTime If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those that occur on or after this time.
#' @param EndTime If specified, AWS Elastic Beanstalk restricts the returned descriptions
#' to those that occur up to, but not including, the `EndTime`.
#' @param MaxRecords Specifies the maximum number of events that can be returned, beginning
#' with the most recent event.
#' @param NextToken Pagination token. If specified, the events return the next batch of
#' results.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Events = list(
#'     list(
#'       EventDate = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Message = "string",
#'       ApplicationName = "string",
#'       VersionLabel = "string",
#'       TemplateName = "string",
#'       EnvironmentName = "string",
#'       PlatformArn = "string",
#'       RequestId = "string",
#'       Severity = "TRACE"|"DEBUG"|"INFO"|"WARN"|"ERROR"|"FATAL"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_events(
#'   ApplicationName = "string",
#'   VersionLabel = "string",
#'   TemplateName = "string",
#'   EnvironmentId = "string",
#'   EnvironmentName = "string",
#'   PlatformArn = "string",
#'   RequestId = "string",
#'   Severity = "TRACE"|"DEBUG"|"INFO"|"WARN"|"ERROR"|"FATAL",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   MaxRecords = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation retrieves events for an environment named
#' # my-env:
#' svc$describe_events(
#'   EnvironmentName = "my-env"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_events
elasticbeanstalk_describe_events <- function(ApplicationName = NULL, VersionLabel = NULL, TemplateName = NULL, EnvironmentId = NULL, EnvironmentName = NULL, PlatformArn = NULL, RequestId = NULL, Severity = NULL, StartTime = NULL, EndTime = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeEvents",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_events_input(ApplicationName = ApplicationName, VersionLabel = VersionLabel, TemplateName = TemplateName, EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, PlatformArn = PlatformArn, RequestId = RequestId, Severity = Severity, StartTime = StartTime, EndTime = EndTime, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .elasticbeanstalk$describe_events_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_events <- elasticbeanstalk_describe_events

#' Retrieves detailed information about the health of instances in your AWS
#' Elastic Beanstalk
#'
#' @description
#' Retrieves detailed information about the health of instances in your AWS
#' Elastic Beanstalk. This operation requires [enhanced health
#' reporting](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/health-enhanced.html).
#'
#' @usage
#' elasticbeanstalk_describe_instances_health(EnvironmentName,
#'   EnvironmentId, AttributeNames, NextToken)
#'
#' @param EnvironmentName Specify the AWS Elastic Beanstalk environment by name.
#' @param EnvironmentId Specify the AWS Elastic Beanstalk environment by ID.
#' @param AttributeNames Specifies the response elements you wish to receive. To retrieve all
#' attributes, set to `All`. If no attribute names are specified, returns a
#' list of instances.
#' @param NextToken Specify the pagination token returned by a previous call.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   InstanceHealthList = list(
#'     list(
#'       InstanceId = "string",
#'       HealthStatus = "string",
#'       Color = "string",
#'       Causes = list(
#'         "string"
#'       ),
#'       LaunchedAt = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       ApplicationMetrics = list(
#'         Duration = 123,
#'         RequestCount = 123,
#'         StatusCodes = list(
#'           Status2xx = 123,
#'           Status3xx = 123,
#'           Status4xx = 123,
#'           Status5xx = 123
#'         ),
#'         Latency = list(
#'           P999 = 123.0,
#'           P99 = 123.0,
#'           P95 = 123.0,
#'           P90 = 123.0,
#'           P85 = 123.0,
#'           P75 = 123.0,
#'           P50 = 123.0,
#'           P10 = 123.0
#'         )
#'       ),
#'       System = list(
#'         CPUUtilization = list(
#'           User = 123.0,
#'           Nice = 123.0,
#'           System = 123.0,
#'           Idle = 123.0,
#'           IOWait = 123.0,
#'           IRQ = 123.0,
#'           SoftIRQ = 123.0,
#'           Privileged = 123.0
#'         ),
#'         LoadAverage = list(
#'           123.0
#'         )
#'       ),
#'       Deployment = list(
#'         VersionLabel = "string",
#'         DeploymentId = 123,
#'         Status = "string",
#'         DeploymentTime = as.POSIXct(
#'           "2015-01-01"
#'         )
#'       ),
#'       AvailabilityZone = "string",
#'       InstanceType = "string"
#'     )
#'   ),
#'   RefreshedAt = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_instances_health(
#'   EnvironmentName = "string",
#'   EnvironmentId = "string",
#'   AttributeNames = list(
#'     "HealthStatus"|"Color"|"Causes"|"ApplicationMetrics"|"RefreshedAt"|"LaunchedAt"|"System"|"Deployment"|"AvailabilityZone"|"InstanceType"|"All"
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation retrieves health information for instances in an
#' # environment named my-env:
#' svc$describe_instances_health(
#'   AttributeNames = list(
#'     "All"
#'   ),
#'   EnvironmentName = "my-env"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_instances_health
elasticbeanstalk_describe_instances_health <- function(EnvironmentName = NULL, EnvironmentId = NULL, AttributeNames = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeInstancesHealth",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_instances_health_input(EnvironmentName = EnvironmentName, EnvironmentId = EnvironmentId, AttributeNames = AttributeNames, NextToken = NextToken)
  output <- .elasticbeanstalk$describe_instances_health_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_instances_health <- elasticbeanstalk_describe_instances_health

#' Describes a platform version
#'
#' @description
#' Describes a platform version. Provides full details. Compare to
#' [`list_platform_versions`][elasticbeanstalk_list_platform_versions],
#' which provides summary information about a list of platform versions.
#' 
#' For definitions of platform version and other platform-related terms,
#' see [AWS Elastic Beanstalk Platforms
#' Glossary](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
#'
#' @usage
#' elasticbeanstalk_describe_platform_version(PlatformArn)
#'
#' @param PlatformArn The ARN of the platform version.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PlatformDescription = list(
#'     PlatformArn = "string",
#'     PlatformOwner = "string",
#'     PlatformName = "string",
#'     PlatformVersion = "string",
#'     SolutionStackName = "string",
#'     PlatformStatus = "Creating"|"Failed"|"Ready"|"Deleting"|"Deleted",
#'     DateCreated = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     DateUpdated = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     PlatformCategory = "string",
#'     Description = "string",
#'     Maintainer = "string",
#'     OperatingSystemName = "string",
#'     OperatingSystemVersion = "string",
#'     ProgrammingLanguages = list(
#'       list(
#'         Name = "string",
#'         Version = "string"
#'       )
#'     ),
#'     Frameworks = list(
#'       list(
#'         Name = "string",
#'         Version = "string"
#'       )
#'     ),
#'     CustomAmiList = list(
#'       list(
#'         VirtualizationType = "string",
#'         ImageId = "string"
#'       )
#'     ),
#'     SupportedTierList = list(
#'       "string"
#'     ),
#'     SupportedAddonList = list(
#'       "string"
#'     ),
#'     PlatformLifecycleState = "string",
#'     PlatformBranchName = "string",
#'     PlatformBranchLifecycleState = "string"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$describe_platform_version(
#'   PlatformArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_describe_platform_version
elasticbeanstalk_describe_platform_version <- function(PlatformArn = NULL) {
  op <- new_operation(
    name = "DescribePlatformVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$describe_platform_version_input(PlatformArn = PlatformArn)
  output <- .elasticbeanstalk$describe_platform_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$describe_platform_version <- elasticbeanstalk_describe_platform_version

#' Disassociate the operations role from an environment
#'
#' @description
#' Disassociate the operations role from an environment. After this call is
#' made, Elastic Beanstalk uses the caller's permissions for permissions to
#' downstream services during subsequent calls acting on this environment.
#' For more information, see [Operations
#' roles](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/) in the
#' *AWS Elastic Beanstalk Developer Guide*.
#'
#' @usage
#' elasticbeanstalk_disassociate_environment_operations_role(
#'   EnvironmentName)
#'
#' @param EnvironmentName &#91;required&#93; The name of the environment from which to disassociate the operations
#' role.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_environment_operations_role(
#'   EnvironmentName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_disassociate_environment_operations_role
elasticbeanstalk_disassociate_environment_operations_role <- function(EnvironmentName) {
  op <- new_operation(
    name = "DisassociateEnvironmentOperationsRole",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$disassociate_environment_operations_role_input(EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$disassociate_environment_operations_role_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$disassociate_environment_operations_role <- elasticbeanstalk_disassociate_environment_operations_role

#' Returns a list of the available solution stack names, with the public
#' version first and then in reverse chronological order
#'
#' @description
#' Returns a list of the available solution stack names, with the public
#' version first and then in reverse chronological order.
#'
#' @usage
#' elasticbeanstalk_list_available_solution_stacks()
#'

#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SolutionStacks = list(
#'     "string"
#'   ),
#'   SolutionStackDetails = list(
#'     list(
#'       SolutionStackName = "string",
#'       PermittedFileTypes = list(
#'         "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'

#'
#' @examples
#' \dontrun{
#' # The following operation lists solution stacks for all currently
#' # available platform configurations and any that you have used in the
#' # past:
#' svc$list_available_solution_stacks()
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_list_available_solution_stacks
elasticbeanstalk_list_available_solution_stacks <- function() {
  op <- new_operation(
    name = "ListAvailableSolutionStacks",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$list_available_solution_stacks_input()
  output <- .elasticbeanstalk$list_available_solution_stacks_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$list_available_solution_stacks <- elasticbeanstalk_list_available_solution_stacks

#' Lists the platform branches available for your account in an AWS Region
#'
#' @description
#' Lists the platform branches available for your account in an AWS Region.
#' Provides summary information about each platform branch.
#' 
#' For definitions of platform branch and other platform-related terms, see
#' [AWS Elastic Beanstalk Platforms
#' Glossary](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
#'
#' @usage
#' elasticbeanstalk_list_platform_branches(Filters, MaxRecords, NextToken)
#'
#' @param Filters Criteria for restricting the resulting list of platform branches. The
#' filter is evaluated as a logical conjunction (AND) of the separate
#' `SearchFilter` terms.
#' 
#' The following list shows valid attribute values for each of the
#' `SearchFilter` terms. Most operators take a single value. The `in` and
#' `not_in` operators can take multiple values.
#' 
#' -   `Attribute = BranchName`:
#' 
#'     -   `Operator`: `=` | `!=` | `begins_with` | `ends_with` |
#'         `contains` | `in` | `not_in`
#' 
#' -   `Attribute = LifecycleState`:
#' 
#'     -   `Operator`: `=` | `!=` | `in` | `not_in`
#' 
#'     -   `Values`: `beta` | `supported` | `deprecated` | `retired`
#' 
#' -   `Attribute = PlatformName`:
#' 
#'     -   `Operator`: `=` | `!=` | `begins_with` | `ends_with` |
#'         `contains` | `in` | `not_in`
#' 
#' -   `Attribute = TierType`:
#' 
#'     -   `Operator`: `=` | `!=`
#' 
#'     -   `Values`: `WebServer/Standard` | `Worker/SQS/HTTP`
#' 
#' Array size: limited to 10 `SearchFilter` objects.
#' 
#' Within each `SearchFilter` item, the `Values` array is limited to 10
#' items.
#' @param MaxRecords The maximum number of platform branch values returned in one call.
#' @param NextToken For a paginated request. Specify a token from a previous response page
#' to retrieve the next response page. All other parameter values must be
#' identical to the ones specified in the initial request.
#' 
#' If no `NextToken` is specified, the first page is retrieved.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PlatformBranchSummaryList = list(
#'     list(
#'       PlatformName = "string",
#'       BranchName = "string",
#'       LifecycleState = "string",
#'       BranchOrder = 123,
#'       SupportedTierList = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_platform_branches(
#'   Filters = list(
#'     list(
#'       Attribute = "string",
#'       Operator = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_list_platform_branches
elasticbeanstalk_list_platform_branches <- function(Filters = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPlatformBranches",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$list_platform_branches_input(Filters = Filters, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .elasticbeanstalk$list_platform_branches_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$list_platform_branches <- elasticbeanstalk_list_platform_branches

#' Lists the platform versions available for your account in an AWS Region
#'
#' @description
#' Lists the platform versions available for your account in an AWS Region.
#' Provides summary information about each platform version. Compare to
#' [`describe_platform_version`][elasticbeanstalk_describe_platform_version],
#' which provides full details about a single platform version.
#' 
#' For definitions of platform version and other platform-related terms,
#' see [AWS Elastic Beanstalk Platforms
#' Glossary](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/platforms-glossary.html).
#'
#' @usage
#' elasticbeanstalk_list_platform_versions(Filters, MaxRecords, NextToken)
#'
#' @param Filters Criteria for restricting the resulting list of platform versions. The
#' filter is interpreted as a logical conjunction (AND) of the separate
#' `PlatformFilter` terms.
#' @param MaxRecords The maximum number of platform version values returned in one call.
#' @param NextToken For a paginated request. Specify a token from a previous response page
#' to retrieve the next response page. All other parameter values must be
#' identical to the ones specified in the initial request.
#' 
#' If no `NextToken` is specified, the first page is retrieved.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   PlatformSummaryList = list(
#'     list(
#'       PlatformArn = "string",
#'       PlatformOwner = "string",
#'       PlatformStatus = "Creating"|"Failed"|"Ready"|"Deleting"|"Deleted",
#'       PlatformCategory = "string",
#'       OperatingSystemName = "string",
#'       OperatingSystemVersion = "string",
#'       SupportedTierList = list(
#'         "string"
#'       ),
#'       SupportedAddonList = list(
#'         "string"
#'       ),
#'       PlatformLifecycleState = "string",
#'       PlatformVersion = "string",
#'       PlatformBranchName = "string",
#'       PlatformBranchLifecycleState = "string"
#'     )
#'   ),
#'   NextToken = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_platform_versions(
#'   Filters = list(
#'     list(
#'       Type = "string",
#'       Operator = "string",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxRecords = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_list_platform_versions
elasticbeanstalk_list_platform_versions <- function(Filters = NULL, MaxRecords = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListPlatformVersions",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$list_platform_versions_input(Filters = Filters, MaxRecords = MaxRecords, NextToken = NextToken)
  output <- .elasticbeanstalk$list_platform_versions_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$list_platform_versions <- elasticbeanstalk_list_platform_versions

#' Return the tags applied to an AWS Elastic Beanstalk resource
#'
#' @description
#' Return the tags applied to an AWS Elastic Beanstalk resource. The
#' response contains a list of tag key-value pairs.
#' 
#' Elastic Beanstalk supports tagging of all of its resources. For details
#' about resource tagging, see [Tagging Application
#' Resources](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html).
#'
#' @usage
#' elasticbeanstalk_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resouce for which a tag list is
#' requested.
#' 
#' Must be the ARN of an Elastic Beanstalk resource.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ResourceArn = "string",
#'   ResourceTags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_list_tags_for_resource
elasticbeanstalk_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .elasticbeanstalk$list_tags_for_resource_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$list_tags_for_resource <- elasticbeanstalk_list_tags_for_resource

#' Deletes and recreates all of the AWS resources (for example: the Auto
#' Scaling group, load balancer, etc
#'
#' @description
#' Deletes and recreates all of the AWS resources (for example: the Auto
#' Scaling group, load balancer, etc.) for a specified environment and
#' forces a restart.
#'
#' @usage
#' elasticbeanstalk_rebuild_environment(EnvironmentId, EnvironmentName)
#'
#' @param EnvironmentId The ID of the environment to rebuild.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to rebuild.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$rebuild_environment(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation terminates and recreates the resources in an
#' # environment named my-env:
#' svc$rebuild_environment(
#'   EnvironmentName = "my-env"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_rebuild_environment
elasticbeanstalk_rebuild_environment <- function(EnvironmentId = NULL, EnvironmentName = NULL) {
  op <- new_operation(
    name = "RebuildEnvironment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$rebuild_environment_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$rebuild_environment_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$rebuild_environment <- elasticbeanstalk_rebuild_environment

#' Initiates a request to compile the specified type of information of the
#' deployed environment
#'
#' @description
#' Initiates a request to compile the specified type of information of the
#' deployed environment.
#' 
#' Setting the `InfoType` to `tail` compiles the last lines from the
#' application server log files of every Amazon EC2 instance in your
#' environment.
#' 
#' Setting the `InfoType` to `bundle` compresses the application server log
#' files for every Amazon EC2 instance into a `.zip` file. Legacy and .NET
#' containers do not support bundle logs.
#' 
#' Use
#' [`retrieve_environment_info`][elasticbeanstalk_retrieve_environment_info]
#' to obtain the set of logs.
#' 
#' Related Topics
#' 
#' -   [`retrieve_environment_info`][elasticbeanstalk_retrieve_environment_info]
#'
#' @usage
#' elasticbeanstalk_request_environment_info(EnvironmentId,
#'   EnvironmentName, InfoType)
#'
#' @param EnvironmentId The ID of the environment of the requested data.
#' 
#' If no such environment is found,
#' [`request_environment_info`][elasticbeanstalk_request_environment_info]
#' returns an `InvalidParameterValue` error.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment of the requested data.
#' 
#' If no such environment is found,
#' [`request_environment_info`][elasticbeanstalk_request_environment_info]
#' returns an `InvalidParameterValue` error.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param InfoType &#91;required&#93; The type of information to request.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$request_environment_info(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string",
#'   InfoType = "tail"|"bundle"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation requests logs from an environment named my-env:
#' svc$request_environment_info(
#'   EnvironmentName = "my-env",
#'   InfoType = "tail"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_request_environment_info
elasticbeanstalk_request_environment_info <- function(EnvironmentId = NULL, EnvironmentName = NULL, InfoType) {
  op <- new_operation(
    name = "RequestEnvironmentInfo",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$request_environment_info_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, InfoType = InfoType)
  output <- .elasticbeanstalk$request_environment_info_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$request_environment_info <- elasticbeanstalk_request_environment_info

#' Causes the environment to restart the application container server
#' running on each Amazon EC2 instance
#'
#' @description
#' Causes the environment to restart the application container server
#' running on each Amazon EC2 instance.
#'
#' @usage
#' elasticbeanstalk_restart_app_server(EnvironmentId, EnvironmentName)
#'
#' @param EnvironmentId The ID of the environment to restart the server for.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to restart the server for.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$restart_app_server(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation restarts application servers on all instances in
#' # an environment named my-env:
#' svc$restart_app_server(
#'   EnvironmentName = "my-env"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_restart_app_server
elasticbeanstalk_restart_app_server <- function(EnvironmentId = NULL, EnvironmentName = NULL) {
  op <- new_operation(
    name = "RestartAppServer",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$restart_app_server_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName)
  output <- .elasticbeanstalk$restart_app_server_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$restart_app_server <- elasticbeanstalk_restart_app_server

#' Retrieves the compiled information from a RequestEnvironmentInfo request
#'
#' @description
#' Retrieves the compiled information from a
#' [`request_environment_info`][elasticbeanstalk_request_environment_info]
#' request.
#' 
#' Related Topics
#' 
#' -   [`request_environment_info`][elasticbeanstalk_request_environment_info]
#'
#' @usage
#' elasticbeanstalk_retrieve_environment_info(EnvironmentId,
#'   EnvironmentName, InfoType)
#'
#' @param EnvironmentId The ID of the data's environment.
#' 
#' If no such environment is found, returns an `InvalidParameterValue`
#' error.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the data's environment.
#' 
#' If no such environment is found, returns an `InvalidParameterValue`
#' error.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param InfoType &#91;required&#93; The type of information to retrieve.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   EnvironmentInfo = list(
#'     list(
#'       InfoType = "tail"|"bundle",
#'       Ec2InstanceId = "string",
#'       SampleTimestamp = as.POSIXct(
#'         "2015-01-01"
#'       ),
#'       Message = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$retrieve_environment_info(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string",
#'   InfoType = "tail"|"bundle"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation retrieves a link to logs from an environment
#' # named my-env:
#' svc$retrieve_environment_info(
#'   EnvironmentName = "my-env",
#'   InfoType = "tail"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_retrieve_environment_info
elasticbeanstalk_retrieve_environment_info <- function(EnvironmentId = NULL, EnvironmentName = NULL, InfoType) {
  op <- new_operation(
    name = "RetrieveEnvironmentInfo",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$retrieve_environment_info_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, InfoType = InfoType)
  output <- .elasticbeanstalk$retrieve_environment_info_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$retrieve_environment_info <- elasticbeanstalk_retrieve_environment_info

#' Swaps the CNAMEs of two environments
#'
#' @description
#' Swaps the CNAMEs of two environments.
#'
#' @usage
#' elasticbeanstalk_swap_environment_cnam_es(SourceEnvironmentId,
#'   SourceEnvironmentName, DestinationEnvironmentId,
#'   DestinationEnvironmentName)
#'
#' @param SourceEnvironmentId The ID of the source environment.
#' 
#' Condition: You must specify at least the `SourceEnvironmentID` or the
#' `SourceEnvironmentName`. You may also specify both. If you specify the
#' `SourceEnvironmentId`, you must specify the `DestinationEnvironmentId`.
#' @param SourceEnvironmentName The name of the source environment.
#' 
#' Condition: You must specify at least the `SourceEnvironmentID` or the
#' `SourceEnvironmentName`. You may also specify both. If you specify the
#' `SourceEnvironmentName`, you must specify the
#' `DestinationEnvironmentName`.
#' @param DestinationEnvironmentId The ID of the destination environment.
#' 
#' Condition: You must specify at least the `DestinationEnvironmentID` or
#' the `DestinationEnvironmentName`. You may also specify both. You must
#' specify the `SourceEnvironmentId` with the `DestinationEnvironmentId`.
#' @param DestinationEnvironmentName The name of the destination environment.
#' 
#' Condition: You must specify at least the `DestinationEnvironmentID` or
#' the `DestinationEnvironmentName`. You may also specify both. You must
#' specify the `SourceEnvironmentName` with the
#' `DestinationEnvironmentName`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$swap_environment_cnam_es(
#'   SourceEnvironmentId = "string",
#'   SourceEnvironmentName = "string",
#'   DestinationEnvironmentId = "string",
#'   DestinationEnvironmentName = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation swaps the assigned subdomains of two
#' # environments:
#' svc$swap_environment_cnam_es(
#'   DestinationEnvironmentName = "my-env-green",
#'   SourceEnvironmentName = "my-env-blue"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_swap_environment_cnam_es
elasticbeanstalk_swap_environment_cnam_es <- function(SourceEnvironmentId = NULL, SourceEnvironmentName = NULL, DestinationEnvironmentId = NULL, DestinationEnvironmentName = NULL) {
  op <- new_operation(
    name = "SwapEnvironmentCNAMEs",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$swap_environment_cnam_es_input(SourceEnvironmentId = SourceEnvironmentId, SourceEnvironmentName = SourceEnvironmentName, DestinationEnvironmentId = DestinationEnvironmentId, DestinationEnvironmentName = DestinationEnvironmentName)
  output <- .elasticbeanstalk$swap_environment_cnam_es_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$swap_environment_cnam_es <- elasticbeanstalk_swap_environment_cnam_es

#' Terminates the specified environment
#'
#' @description
#' Terminates the specified environment.
#'
#' @usage
#' elasticbeanstalk_terminate_environment(EnvironmentId, EnvironmentName,
#'   TerminateResources, ForceTerminate)
#'
#' @param EnvironmentId The ID of the environment to terminate.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to terminate.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param TerminateResources Indicates whether the associated AWS resources should shut down when the
#' environment is terminated:
#' 
#' -   `true`: The specified environment as well as the associated AWS
#'     resources, such as Auto Scaling group and LoadBalancer, are
#'     terminated.
#' 
#' -   `false`: AWS Elastic Beanstalk resource management is removed from
#'     the environment, but the AWS resources continue to operate.
#' 
#' For more information, see the [AWS Elastic Beanstalk User
#' Guide.](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/)
#' 
#' Default: `true`
#' 
#' Valid Values: `true` | `false`
#' @param ForceTerminate Terminates the target environment even if another environment in the
#' same group is dependent on it.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   EnvironmentName = "string",
#'   EnvironmentId = "string",
#'   ApplicationName = "string",
#'   VersionLabel = "string",
#'   SolutionStackName = "string",
#'   PlatformArn = "string",
#'   TemplateName = "string",
#'   Description = "string",
#'   EndpointURL = "string",
#'   CNAME = "string",
#'   DateCreated = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   DateUpdated = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Status = "Aborting"|"Launching"|"Updating"|"LinkingFrom"|"LinkingTo"|"Ready"|"Terminating"|"Terminated",
#'   AbortableOperationInProgress = TRUE|FALSE,
#'   Health = "Green"|"Yellow"|"Red"|"Grey",
#'   HealthStatus = "NoData"|"Unknown"|"Pending"|"Ok"|"Info"|"Warning"|"Degraded"|"Severe"|"Suspended",
#'   Resources = list(
#'     LoadBalancer = list(
#'       LoadBalancerName = "string",
#'       Domain = "string",
#'       Listeners = list(
#'         list(
#'           Protocol = "string",
#'           Port = 123
#'         )
#'       )
#'     )
#'   ),
#'   Tier = list(
#'     Name = "string",
#'     Type = "string",
#'     Version = "string"
#'   ),
#'   EnvironmentLinks = list(
#'     list(
#'       LinkName = "string",
#'       EnvironmentName = "string"
#'     )
#'   ),
#'   EnvironmentArn = "string",
#'   OperationsRole = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$terminate_environment(
#'   EnvironmentId = "string",
#'   EnvironmentName = "string",
#'   TerminateResources = TRUE|FALSE,
#'   ForceTerminate = TRUE|FALSE
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation terminates an Elastic Beanstalk environment
#' # named my-env:
#' svc$terminate_environment(
#'   EnvironmentName = "my-env"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_terminate_environment
elasticbeanstalk_terminate_environment <- function(EnvironmentId = NULL, EnvironmentName = NULL, TerminateResources = NULL, ForceTerminate = NULL) {
  op <- new_operation(
    name = "TerminateEnvironment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$terminate_environment_input(EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, TerminateResources = TerminateResources, ForceTerminate = ForceTerminate)
  output <- .elasticbeanstalk$terminate_environment_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$terminate_environment <- elasticbeanstalk_terminate_environment

#' Updates the specified application to have the specified properties
#'
#' @description
#' Updates the specified application to have the specified properties.
#' 
#' If a property (for example, `description`) is not provided, the value
#' remains unchanged. To clear these properties, specify an empty string.
#'
#' @usage
#' elasticbeanstalk_update_application(ApplicationName, Description)
#'
#' @param ApplicationName &#91;required&#93; The name of the application to update. If no such application is found,
#' [`update_application`][elasticbeanstalk_update_application] returns an
#' `InvalidParameterValue` error.
#' @param Description A new description for the application.
#' 
#' Default: If not specified, AWS Elastic Beanstalk does not update the
#' description.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Application = list(
#'     ApplicationArn = "string",
#'     ApplicationName = "string",
#'     Description = "string",
#'     DateCreated = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     DateUpdated = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Versions = list(
#'       "string"
#'     ),
#'     ConfigurationTemplates = list(
#'       "string"
#'     ),
#'     ResourceLifecycleConfig = list(
#'       ServiceRole = "string",
#'       VersionLifecycleConfig = list(
#'         MaxCountRule = list(
#'           Enabled = TRUE|FALSE,
#'           MaxCount = 123,
#'           DeleteSourceFromS3 = TRUE|FALSE
#'         ),
#'         MaxAgeRule = list(
#'           Enabled = TRUE|FALSE,
#'           MaxAgeInDays = 123,
#'           DeleteSourceFromS3 = TRUE|FALSE
#'         )
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_application(
#'   ApplicationName = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation updates the description of an application named
#' # my-app:
#' svc$update_application(
#'   ApplicationName = "my-app",
#'   Description = "my Elastic Beanstalk application"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_application
elasticbeanstalk_update_application <- function(ApplicationName, Description = NULL) {
  op <- new_operation(
    name = "UpdateApplication",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_application_input(ApplicationName = ApplicationName, Description = Description)
  output <- .elasticbeanstalk$update_application_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_application <- elasticbeanstalk_update_application

#' Modifies lifecycle settings for an application
#'
#' @description
#' Modifies lifecycle settings for an application.
#'
#' @usage
#' elasticbeanstalk_update_application_resource_lifecycle(ApplicationName,
#'   ResourceLifecycleConfig)
#'
#' @param ApplicationName &#91;required&#93; The name of the application.
#' @param ResourceLifecycleConfig &#91;required&#93; The lifecycle configuration.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ApplicationName = "string",
#'   ResourceLifecycleConfig = list(
#'     ServiceRole = "string",
#'     VersionLifecycleConfig = list(
#'       MaxCountRule = list(
#'         Enabled = TRUE|FALSE,
#'         MaxCount = 123,
#'         DeleteSourceFromS3 = TRUE|FALSE
#'       ),
#'       MaxAgeRule = list(
#'         Enabled = TRUE|FALSE,
#'         MaxAgeInDays = 123,
#'         DeleteSourceFromS3 = TRUE|FALSE
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_application_resource_lifecycle(
#'   ApplicationName = "string",
#'   ResourceLifecycleConfig = list(
#'     ServiceRole = "string",
#'     VersionLifecycleConfig = list(
#'       MaxCountRule = list(
#'         Enabled = TRUE|FALSE,
#'         MaxCount = 123,
#'         DeleteSourceFromS3 = TRUE|FALSE
#'       ),
#'       MaxAgeRule = list(
#'         Enabled = TRUE|FALSE,
#'         MaxAgeInDays = 123,
#'         DeleteSourceFromS3 = TRUE|FALSE
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_application_resource_lifecycle
elasticbeanstalk_update_application_resource_lifecycle <- function(ApplicationName, ResourceLifecycleConfig) {
  op <- new_operation(
    name = "UpdateApplicationResourceLifecycle",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_application_resource_lifecycle_input(ApplicationName = ApplicationName, ResourceLifecycleConfig = ResourceLifecycleConfig)
  output <- .elasticbeanstalk$update_application_resource_lifecycle_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_application_resource_lifecycle <- elasticbeanstalk_update_application_resource_lifecycle

#' Updates the specified application version to have the specified
#' properties
#'
#' @description
#' Updates the specified application version to have the specified
#' properties.
#' 
#' If a property (for example, `description`) is not provided, the value
#' remains unchanged. To clear properties, specify an empty string.
#'
#' @usage
#' elasticbeanstalk_update_application_version(ApplicationName,
#'   VersionLabel, Description)
#'
#' @param ApplicationName &#91;required&#93; The name of the application associated with this version.
#' 
#' If no application is found with this name,
#' [`update_application`][elasticbeanstalk_update_application] returns an
#' `InvalidParameterValue` error.
#' @param VersionLabel &#91;required&#93; The name of the version to update.
#' 
#' If no application version is found with this label,
#' [`update_application`][elasticbeanstalk_update_application] returns an
#' `InvalidParameterValue` error.
#' @param Description A new description for this version.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   ApplicationVersion = list(
#'     ApplicationVersionArn = "string",
#'     ApplicationName = "string",
#'     Description = "string",
#'     VersionLabel = "string",
#'     SourceBuildInformation = list(
#'       SourceType = "Git"|"Zip",
#'       SourceRepository = "CodeCommit"|"S3",
#'       SourceLocation = "string"
#'     ),
#'     BuildArn = "string",
#'     SourceBundle = list(
#'       S3Bucket = "string",
#'       S3Key = "string"
#'     ),
#'     DateCreated = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     DateUpdated = as.POSIXct(
#'       "2015-01-01"
#'     ),
#'     Status = "Processed"|"Unprocessed"|"Failed"|"Processing"|"Building"
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_application_version(
#'   ApplicationName = "string",
#'   VersionLabel = "string",
#'   Description = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation updates the description of an application
#' # version named 22a0-stage-150819_185942:
#' svc$update_application_version(
#'   ApplicationName = "my-app",
#'   Description = "new description",
#'   VersionLabel = "22a0-stage-150819_185942"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_application_version
elasticbeanstalk_update_application_version <- function(ApplicationName, VersionLabel, Description = NULL) {
  op <- new_operation(
    name = "UpdateApplicationVersion",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_application_version_input(ApplicationName = ApplicationName, VersionLabel = VersionLabel, Description = Description)
  output <- .elasticbeanstalk$update_application_version_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_application_version <- elasticbeanstalk_update_application_version

#' Updates the specified configuration template to have the specified
#' properties or configuration option values
#'
#' @description
#' Updates the specified configuration template to have the specified
#' properties or configuration option values.
#' 
#' If a property (for example, `ApplicationName`) is not provided, its
#' value remains unchanged. To clear such properties, specify an empty
#' string.
#' 
#' Related Topics
#' 
#' -   [`describe_configuration_options`][elasticbeanstalk_describe_configuration_options]
#'
#' @usage
#' elasticbeanstalk_update_configuration_template(ApplicationName,
#'   TemplateName, Description, OptionSettings, OptionsToRemove)
#'
#' @param ApplicationName &#91;required&#93; The name of the application associated with the configuration template
#' to update.
#' 
#' If no application is found with this name,
#' [`update_configuration_template`][elasticbeanstalk_update_configuration_template]
#' returns an `InvalidParameterValue` error.
#' @param TemplateName &#91;required&#93; The name of the configuration template to update.
#' 
#' If no configuration template is found with this name,
#' [`update_configuration_template`][elasticbeanstalk_update_configuration_template]
#' returns an `InvalidParameterValue` error.
#' @param Description A new description for the configuration.
#' @param OptionSettings A list of configuration option settings to update with the new specified
#' option value.
#' @param OptionsToRemove A list of configuration options to remove from the configuration set.
#' 
#' Constraint: You can remove only `UserDefined` configuration options.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   SolutionStackName = "string",
#'   PlatformArn = "string",
#'   ApplicationName = "string",
#'   TemplateName = "string",
#'   Description = "string",
#'   EnvironmentName = "string",
#'   DeploymentStatus = "deployed"|"pending"|"failed",
#'   DateCreated = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   DateUpdated = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   OptionSettings = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_configuration_template(
#'   ApplicationName = "string",
#'   TemplateName = "string",
#'   Description = "string",
#'   OptionSettings = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string",
#'       Value = "string"
#'     )
#'   ),
#'   OptionsToRemove = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation removes the configured CloudWatch custom health
#' # metrics configuration ConfigDocument from a saved configuration template
#' # named my-template:
#' svc$update_configuration_template(
#'   ApplicationName = "my-app",
#'   OptionsToRemove = list(
#'     list(
#'       Namespace = "aws:elasticbeanstalk:healthreporting:system",
#'       OptionName = "ConfigDocument"
#'     )
#'   ),
#'   TemplateName = "my-template"
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_configuration_template
elasticbeanstalk_update_configuration_template <- function(ApplicationName, TemplateName, Description = NULL, OptionSettings = NULL, OptionsToRemove = NULL) {
  op <- new_operation(
    name = "UpdateConfigurationTemplate",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_configuration_template_input(ApplicationName = ApplicationName, TemplateName = TemplateName, Description = Description, OptionSettings = OptionSettings, OptionsToRemove = OptionsToRemove)
  output <- .elasticbeanstalk$update_configuration_template_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_configuration_template <- elasticbeanstalk_update_configuration_template

#' Updates the environment description, deploys a new application version,
#' updates the configuration settings to an entirely new configuration
#' template, or updates select configuration option values in the running
#' environment
#'
#' @description
#' Updates the environment description, deploys a new application version,
#' updates the configuration settings to an entirely new configuration
#' template, or updates select configuration option values in the running
#' environment.
#' 
#' Attempting to update both the release and configuration is not allowed
#' and AWS Elastic Beanstalk returns an `InvalidParameterCombination`
#' error.
#' 
#' When updating the configuration settings to a new template or individual
#' settings, a draft configuration is created and
#' [`describe_configuration_settings`][elasticbeanstalk_describe_configuration_settings]
#' for this environment returns two setting descriptions with different
#' `DeploymentStatus` values.
#'
#' @usage
#' elasticbeanstalk_update_environment(ApplicationName, EnvironmentId,
#'   EnvironmentName, GroupName, Description, Tier, VersionLabel,
#'   TemplateName, SolutionStackName, PlatformArn, OptionSettings,
#'   OptionsToRemove)
#'
#' @param ApplicationName The name of the application with which the environment is associated.
#' @param EnvironmentId The ID of the environment to update.
#' 
#' If no environment with this ID exists, AWS Elastic Beanstalk returns an
#' `InvalidParameterValue` error.
#' 
#' Condition: You must specify either this or an EnvironmentName, or both.
#' If you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param EnvironmentName The name of the environment to update. If no environment with this name
#' exists, AWS Elastic Beanstalk returns an `InvalidParameterValue` error.
#' 
#' Condition: You must specify either this or an EnvironmentId, or both. If
#' you do not specify either, AWS Elastic Beanstalk returns
#' `MissingRequiredParameter` error.
#' @param GroupName The name of the group to which the target environment belongs. Specify a
#' group name only if the environment's name is specified in an environment
#' manifest and not with the environment name or environment ID parameters.
#' See [Environment Manifest
#' (env.yaml)](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/environment-cfg-manifest.html)
#' for details.
#' @param Description If this parameter is specified, AWS Elastic Beanstalk updates the
#' description of this environment.
#' @param Tier This specifies the tier to use to update the environment.
#' 
#' Condition: At this time, if you change the tier version, name, or type,
#' AWS Elastic Beanstalk returns `InvalidParameterValue` error.
#' @param VersionLabel If this parameter is specified, AWS Elastic Beanstalk deploys the named
#' application version to the environment. If no such application version
#' is found, returns an `InvalidParameterValue` error.
#' @param TemplateName If this parameter is specified, AWS Elastic Beanstalk deploys this
#' configuration template to the environment. If no such configuration
#' template is found, AWS Elastic Beanstalk returns an
#' `InvalidParameterValue` error.
#' @param SolutionStackName This specifies the platform version that the environment will run after
#' the environment is updated.
#' @param PlatformArn The ARN of the platform, if used.
#' @param OptionSettings If specified, AWS Elastic Beanstalk updates the configuration set
#' associated with the running environment and sets the specified
#' configuration options to the requested value.
#' @param OptionsToRemove A list of custom user-defined configuration options to remove from the
#' configuration set for this environment.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   EnvironmentName = "string",
#'   EnvironmentId = "string",
#'   ApplicationName = "string",
#'   VersionLabel = "string",
#'   SolutionStackName = "string",
#'   PlatformArn = "string",
#'   TemplateName = "string",
#'   Description = "string",
#'   EndpointURL = "string",
#'   CNAME = "string",
#'   DateCreated = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   DateUpdated = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   Status = "Aborting"|"Launching"|"Updating"|"LinkingFrom"|"LinkingTo"|"Ready"|"Terminating"|"Terminated",
#'   AbortableOperationInProgress = TRUE|FALSE,
#'   Health = "Green"|"Yellow"|"Red"|"Grey",
#'   HealthStatus = "NoData"|"Unknown"|"Pending"|"Ok"|"Info"|"Warning"|"Degraded"|"Severe"|"Suspended",
#'   Resources = list(
#'     LoadBalancer = list(
#'       LoadBalancerName = "string",
#'       Domain = "string",
#'       Listeners = list(
#'         list(
#'           Protocol = "string",
#'           Port = 123
#'         )
#'       )
#'     )
#'   ),
#'   Tier = list(
#'     Name = "string",
#'     Type = "string",
#'     Version = "string"
#'   ),
#'   EnvironmentLinks = list(
#'     list(
#'       LinkName = "string",
#'       EnvironmentName = "string"
#'     )
#'   ),
#'   EnvironmentArn = "string",
#'   OperationsRole = "string"
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$update_environment(
#'   ApplicationName = "string",
#'   EnvironmentId = "string",
#'   EnvironmentName = "string",
#'   GroupName = "string",
#'   Description = "string",
#'   Tier = list(
#'     Name = "string",
#'     Type = "string",
#'     Version = "string"
#'   ),
#'   VersionLabel = "string",
#'   TemplateName = "string",
#'   SolutionStackName = "string",
#'   PlatformArn = "string",
#'   OptionSettings = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string",
#'       Value = "string"
#'     )
#'   ),
#'   OptionsToRemove = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation updates an environment named "my-env" to version
#' # "v2" of the application to which it belongs:
#' svc$update_environment(
#'   EnvironmentName = "my-env",
#'   VersionLabel = "v2"
#' )
#' 
#' # The following operation configures several options in the
#' # aws:elb:loadbalancer namespace:
#' svc$update_environment(
#'   EnvironmentName = "my-env",
#'   OptionSettings = list(
#'     list(
#'       Namespace = "aws:elb:healthcheck",
#'       OptionName = "Interval",
#'       Value = "15"
#'     ),
#'     list(
#'       Namespace = "aws:elb:healthcheck",
#'       OptionName = "Timeout",
#'       Value = "8"
#'     ),
#'     list(
#'       Namespace = "aws:elb:healthcheck",
#'       OptionName = "HealthyThreshold",
#'       Value = "2"
#'     ),
#'     list(
#'       Namespace = "aws:elb:healthcheck",
#'       OptionName = "UnhealthyThreshold",
#'       Value = "3"
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_environment
elasticbeanstalk_update_environment <- function(ApplicationName = NULL, EnvironmentId = NULL, EnvironmentName = NULL, GroupName = NULL, Description = NULL, Tier = NULL, VersionLabel = NULL, TemplateName = NULL, SolutionStackName = NULL, PlatformArn = NULL, OptionSettings = NULL, OptionsToRemove = NULL) {
  op <- new_operation(
    name = "UpdateEnvironment",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_environment_input(ApplicationName = ApplicationName, EnvironmentId = EnvironmentId, EnvironmentName = EnvironmentName, GroupName = GroupName, Description = Description, Tier = Tier, VersionLabel = VersionLabel, TemplateName = TemplateName, SolutionStackName = SolutionStackName, PlatformArn = PlatformArn, OptionSettings = OptionSettings, OptionsToRemove = OptionsToRemove)
  output <- .elasticbeanstalk$update_environment_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_environment <- elasticbeanstalk_update_environment

#' Update the list of tags applied to an AWS Elastic Beanstalk resource
#'
#' @description
#' Update the list of tags applied to an AWS Elastic Beanstalk resource.
#' Two lists can be passed: `TagsToAdd` for tags to add or update, and
#' `TagsToRemove`.
#' 
#' Elastic Beanstalk supports tagging of all of its resources. For details
#' about resource tagging, see [Tagging Application
#' Resources](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/applications-tagging-resources.html).
#' 
#' If you create a custom IAM user policy to control permission to this
#' operation, specify one of the following two virtual actions (or both)
#' instead of the API operation name:
#' 
#' ### elasticbeanstalk:AddTags
#' 
#' Controls permission to call
#' [`update_tags_for_resource`][elasticbeanstalk_update_tags_for_resource]
#' and pass a list of tags to add in the `TagsToAdd` parameter.
#' 
#' ### elasticbeanstalk:RemoveTags
#' 
#' Controls permission to call
#' [`update_tags_for_resource`][elasticbeanstalk_update_tags_for_resource]
#' and pass a list of tag keys to remove in the `TagsToRemove` parameter.
#' 
#' For details about creating a custom user policy, see [Creating a Custom
#' User
#' Policy](https://docs.aws.amazon.com/elasticbeanstalk/latest/dg/AWSHowTo.iam.managed-policies.html#AWSHowTo.iam.policies).
#'
#' @usage
#' elasticbeanstalk_update_tags_for_resource(ResourceArn, TagsToAdd,
#'   TagsToRemove)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resouce to be updated.
#' 
#' Must be the ARN of an Elastic Beanstalk resource.
#' @param TagsToAdd A list of tags to add or update. If a key of an existing tag is added,
#' the tag's value is updated.
#' 
#' Specify at least one of these parameters: `TagsToAdd`, `TagsToRemove`.
#' @param TagsToRemove A list of tag keys to remove. If a tag key doesn't exist, it is silently
#' ignored.
#' 
#' Specify at least one of these parameters: `TagsToAdd`, `TagsToRemove`.
#'
#' @return
#' An empty list.
#'
#' @section Request syntax:
#' ```
#' svc$update_tags_for_resource(
#'   ResourceArn = "string",
#'   TagsToAdd = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   TagsToRemove = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_update_tags_for_resource
elasticbeanstalk_update_tags_for_resource <- function(ResourceArn, TagsToAdd = NULL, TagsToRemove = NULL) {
  op <- new_operation(
    name = "UpdateTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$update_tags_for_resource_input(ResourceArn = ResourceArn, TagsToAdd = TagsToAdd, TagsToRemove = TagsToRemove)
  output <- .elasticbeanstalk$update_tags_for_resource_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$update_tags_for_resource <- elasticbeanstalk_update_tags_for_resource

#' Takes a set of configuration settings and either a configuration
#' template or environment, and determines whether those values are valid
#'
#' @description
#' Takes a set of configuration settings and either a configuration
#' template or environment, and determines whether those values are valid.
#' 
#' This action returns a list of messages indicating any errors or warnings
#' associated with the selection of option values.
#'
#' @usage
#' elasticbeanstalk_validate_configuration_settings(ApplicationName,
#'   TemplateName, EnvironmentName, OptionSettings)
#'
#' @param ApplicationName &#91;required&#93; The name of the application that the configuration template or
#' environment belongs to.
#' @param TemplateName The name of the configuration template to validate the settings against.
#' 
#' Condition: You cannot specify both this and an environment name.
#' @param EnvironmentName The name of the environment to validate the settings against.
#' 
#' Condition: You cannot specify both this and a configuration template
#' name.
#' @param OptionSettings &#91;required&#93; A list of the options and desired values to evaluate.
#'
#' @return
#' A list with the following syntax:
#' ```
#' list(
#'   Messages = list(
#'     list(
#'       Message = "string",
#'       Severity = "error"|"warning",
#'       Namespace = "string",
#'       OptionName = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @section Request syntax:
#' ```
#' svc$validate_configuration_settings(
#'   ApplicationName = "string",
#'   TemplateName = "string",
#'   EnvironmentName = "string",
#'   OptionSettings = list(
#'     list(
#'       ResourceName = "string",
#'       Namespace = "string",
#'       OptionName = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' # The following operation validates a CloudWatch custom metrics config
#' # document:
#' svc$validate_configuration_settings(
#'   ApplicationName = "my-app",
#'   EnvironmentName = "my-env",
#'   OptionSettings = list(
#'     list(
#'       Namespace = "aws:elasticbeanstalk:healthreporting:system",
#'       OptionName = "ConfigDocument",
#'       Value = "\{\"CloudWatchMetrics\": \{\"Environment\": \{\"ApplicationLatencyP9..."
#'     )
#'   )
#' )
#' }
#'
#' @keywords internal
#'
#' @rdname elasticbeanstalk_validate_configuration_settings
elasticbeanstalk_validate_configuration_settings <- function(ApplicationName, TemplateName = NULL, EnvironmentName = NULL, OptionSettings) {
  op <- new_operation(
    name = "ValidateConfigurationSettings",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .elasticbeanstalk$validate_configuration_settings_input(ApplicationName = ApplicationName, TemplateName = TemplateName, EnvironmentName = EnvironmentName, OptionSettings = OptionSettings)
  output <- .elasticbeanstalk$validate_configuration_settings_output()
  config <- get_config()
  svc <- .elasticbeanstalk$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.elasticbeanstalk$operations$validate_configuration_settings <- elasticbeanstalk_validate_configuration_settings
