% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_spot_instance_requests}
\alias{ec2_describe_spot_instance_requests}
\title{Describes the specified Spot Instance requests}
\usage{
ec2_describe_spot_instance_requests(Filters, DryRun,
  SpotInstanceRequestIds, NextToken, MaxResults)
}
\arguments{
\item{Filters}{One or more filters.
\itemize{
\item \code{availability-zone-group} - The Availability Zone group.
\item \code{create-time} - The time stamp when the Spot Instance request was
created.
\item \code{fault-code} - The fault code related to the request.
\item \code{fault-message} - The fault message related to the request.
\item \code{instance-id} - The ID of the instance that fulfilled the request.
\item \code{launch-group} - The Spot Instance launch group.
\item \code{launch.block-device-mapping.delete-on-termination} - Indicates
whether the EBS volume is deleted on instance termination.
\item \code{launch.block-device-mapping.device-name} - The device name for the
volume in the block device mapping (for example, \verb{/dev/sdh} or
\code{xvdh}).
\item \code{launch.block-device-mapping.snapshot-id} - The ID of the snapshot
for the EBS volume.
\item \code{launch.block-device-mapping.volume-size} - The size of the EBS
volume, in GiB.
\item \code{launch.block-device-mapping.volume-type} - The type of EBS volume:
\code{gp2} for General Purpose SSD, \code{io1} or \code{io2} for Provisioned IOPS
SSD, \code{st1} for Throughput Optimized HDD, \code{sc1}for Cold HDD, or
\code{standard} for Magnetic.
\item \code{launch.group-id} - The ID of the security group for the instance.
\item \code{launch.group-name} - The name of the security group for the
instance.
\item \code{launch.image-id} - The ID of the AMI.
\item \code{launch.instance-type} - The type of instance (for example,
\code{m3.medium}).
\item \code{launch.kernel-id} - The kernel ID.
\item \code{launch.key-name} - The name of the key pair the instance launched
with.
\item \code{launch.monitoring-enabled} - Whether detailed monitoring is enabled
for the Spot Instance.
\item \code{launch.ramdisk-id} - The RAM disk ID.
\item \code{launched-availability-zone} - The Availability Zone in which the
request is launched.
\item \code{network-interface.addresses.primary} - Indicates whether the IP
address is the primary private IP address.
\item \code{network-interface.delete-on-termination} - Indicates whether the
network interface is deleted when the instance is terminated.
\item \code{network-interface.description} - A description of the network
interface.
\item \code{network-interface.device-index} - The index of the device for the
network interface attachment on the instance.
\item \code{network-interface.group-id} - The ID of the security group
associated with the network interface.
\item \code{network-interface.network-interface-id} - The ID of the network
interface.
\item \code{network-interface.private-ip-address} - The primary private IP
address of the network interface.
\item \code{network-interface.subnet-id} - The ID of the subnet for the
instance.
\item \code{product-description} - The product description associated with the
instance (\code{Linux/UNIX} | \code{Windows}).
\item \code{spot-instance-request-id} - The Spot Instance request ID.
\item \code{spot-price} - The maximum hourly price for any Spot Instance
launched to fulfill the request.
\item \code{state} - The state of the Spot Instance request (\code{open} | \code{active}
| \code{closed} | \code{cancelled} | \code{failed}). Spot request status
information can help you track your Amazon EC2 Spot Instance
requests. For more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/spot-request-status.html}{Spot request status}
in the \emph{Amazon EC2 User Guide for Linux Instances}.
\item \code{status-code} - The short code describing the most recent evaluation
of your Spot Instance request.
\item \code{status-message} - The message explaining the status of the Spot
Instance request.
\item \code{tag}:<key> - The key/value combination of a tag assigned to
the resource. Use the tag key in the filter name and the tag value
as the filter value. For example, to find all resources that have a
tag with the key \code{Owner} and the value \code{TeamA}, specify \code{tag:Owner}
for the filter name and \code{TeamA} for the filter value.
\item \code{tag-key} - The key of a tag assigned to the resource. Use this
filter to find all resources assigned a tag with a specific key,
regardless of the tag value.
\item \code{type} - The type of Spot Instance request (\code{one-time} |
\code{persistent}).
\item \code{valid-from} - The start date of the request.
\item \code{valid-until} - The end date of the request.
}}

\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{SpotInstanceRequestIds}{One or more Spot Instance request IDs.}

\item{NextToken}{The token to request the next set of results. This value is \code{null} when
there are no more results to return.}

\item{MaxResults}{The maximum number of results to return in a single call. Specify a
value between 5 and 1000. To retrieve the remaining results, make
another call with the returned \code{NextToken} value.}
}
\value{
A list with the following syntax:\preformatted{list(
  SpotInstanceRequests = list(
    list(
      ActualBlockHourlyPrice = "string",
      AvailabilityZoneGroup = "string",
      BlockDurationMinutes = 123,
      CreateTime = as.POSIXct(
        "2015-01-01"
      ),
      Fault = list(
        Code = "string",
        Message = "string"
      ),
      InstanceId = "string",
      LaunchGroup = "string",
      LaunchSpecification = list(
        UserData = "string",
        SecurityGroups = list(
          list(
            GroupName = "string",
            GroupId = "string"
          )
        ),
        AddressingType = "string",
        BlockDeviceMappings = list(
          list(
            DeviceName = "string",
            VirtualName = "string",
            Ebs = list(
              DeleteOnTermination = TRUE|FALSE,
              Iops = 123,
              SnapshotId = "string",
              VolumeSize = 123,
              VolumeType = "standard"|"io1"|"io2"|"gp2"|"sc1"|"st1"|"gp3",
              KmsKeyId = "string",
              Throughput = 123,
              Encrypted = TRUE|FALSE
            ),
            NoDevice = "string"
          )
        ),
        EbsOptimized = TRUE|FALSE,
        IamInstanceProfile = list(
          Arn = "string",
          Name = "string"
        ),
        ImageId = "string",
        InstanceType = "t1.micro"|"t2.nano"|"t2.micro"|"t2.small"|"t2.medium"|"t2.large"|"t2.xlarge"|"t2.2xlarge"|"t3.nano"|"t3.micro"|"t3.small"|"t3.medium"|"t3.large"|"t3.xlarge"|"t3.2xlarge"|"t3a.nano"|"t3a.micro"|"t3a.small"|"t3a.medium"|"t3a.large"|"t3a.xlarge"|"t3a.2xlarge"|"t4g.nano"|"t4g.micro"|"t4g.small"|"t4g.medium"|"t4g.large"|"t4g.xlarge"|"t4g.2xlarge"|"m1.small"|"m1.medium"|"m1.large"|"m1.xlarge"|"m3.medium"|"m3.large"|"m3.xlarge"|"m3.2xlarge"|"m4.large"|"m4.xlarge"|"m4.2xlarge"|"m4.4xlarge"|"m4.10xlarge"|"m4.16xlarge"|"m2.xlarge"|"m2.2xlarge"|"m2.4xlarge"|"cr1.8xlarge"|"r3.large"|"r3.xlarge"|"r3.2xlarge"|"r3.4xlarge"|"r3.8xlarge"|"r4.large"|"r4.xlarge"|"r4.2xlarge"|"r4.4xlarge"|"r4.8xlarge"|"r4.16xlarge"|"r5.large"|"r5.xlarge"|"r5.2xlarge"|"r5.4xlarge"|"r5.8xlarge"|"r5.12xlarge"|"r5.16xlarge"|"r5.24xlarge"|"r5.metal"|"r5a.large"|"r5a.xlarge"|"r5a.2xlarge"|"r5a.4xlarge"|"r5a.8xlarge"|"r5a.12xlarge"|"r5a.16xlarge"|"r5a.24xlarge"|"r5b.large"|"r5b.xlarge"|"r5b.2xlarge"|"r5b.4xlarge"|"r5b.8xlarge"|"r5b.12xlarge"|"r5b.16xlarge"|"r5b.24xlarge"|"r5b.metal"|"r5d.large"|"r5d.xlarge"|"r5d.2xlarge"|"r5d.4xlarge"|"r5d.8xlarge"|"r5d.12xlarge"|"r5d.16xlarge"|"r5d.24xlarge"|"r5d.metal"|"r5ad.large"|"r5ad.xlarge"|"r5ad.2xlarge"|"r5ad.4xlarge"|"r5ad.8xlarge"|"r5ad.12xlarge"|"r5ad.16xlarge"|"r5ad.24xlarge"|"r6g.metal"|"r6g.medium"|"r6g.large"|"r6g.xlarge"|"r6g.2xlarge"|"r6g.4xlarge"|"r6g.8xlarge"|"r6g.12xlarge"|"r6g.16xlarge"|"r6gd.metal"|"r6gd.medium"|"r6gd.large"|"r6gd.xlarge"|"r6gd.2xlarge"|"r6gd.4xlarge"|"r6gd.8xlarge"|"r6gd.12xlarge"|"r6gd.16xlarge"|"x1.16xlarge"|"x1.32xlarge"|"x1e.xlarge"|"x1e.2xlarge"|"x1e.4xlarge"|"x1e.8xlarge"|"x1e.16xlarge"|"x1e.32xlarge"|"i2.xlarge"|"i2.2xlarge"|"i2.4xlarge"|"i2.8xlarge"|"i3.large"|"i3.xlarge"|"i3.2xlarge"|"i3.4xlarge"|"i3.8xlarge"|"i3.16xlarge"|"i3.metal"|"i3en.large"|"i3en.xlarge"|"i3en.2xlarge"|"i3en.3xlarge"|"i3en.6xlarge"|"i3en.12xlarge"|"i3en.24xlarge"|"i3en.metal"|"hi1.4xlarge"|"hs1.8xlarge"|"c1.medium"|"c1.xlarge"|"c3.large"|"c3.xlarge"|"c3.2xlarge"|"c3.4xlarge"|"c3.8xlarge"|"c4.large"|"c4.xlarge"|"c4.2xlarge"|"c4.4xlarge"|"c4.8xlarge"|"c5.large"|"c5.xlarge"|"c5.2xlarge"|"c5.4xlarge"|"c5.9xlarge"|"c5.12xlarge"|"c5.18xlarge"|"c5.24xlarge"|"c5.metal"|"c5a.large"|"c5a.xlarge"|"c5a.2xlarge"|"c5a.4xlarge"|"c5a.8xlarge"|"c5a.12xlarge"|"c5a.16xlarge"|"c5a.24xlarge"|"c5ad.large"|"c5ad.xlarge"|"c5ad.2xlarge"|"c5ad.4xlarge"|"c5ad.8xlarge"|"c5ad.12xlarge"|"c5ad.16xlarge"|"c5ad.24xlarge"|"c5d.large"|"c5d.xlarge"|"c5d.2xlarge"|"c5d.4xlarge"|"c5d.9xlarge"|"c5d.12xlarge"|"c5d.18xlarge"|"c5d.24xlarge"|"c5d.metal"|"c5n.large"|"c5n.xlarge"|"c5n.2xlarge"|"c5n.4xlarge"|"c5n.9xlarge"|"c5n.18xlarge"|"c5n.metal"|"c6g.metal"|"c6g.medium"|"c6g.large"|"c6g.xlarge"|"c6g.2xlarge"|"c6g.4xlarge"|"c6g.8xlarge"|"c6g.12xlarge"|"c6g.16xlarge"|"c6gd.metal"|"c6gd.medium"|"c6gd.large"|"c6gd.xlarge"|"c6gd.2xlarge"|"c6gd.4xlarge"|"c6gd.8xlarge"|"c6gd.12xlarge"|"c6gd.16xlarge"|"c6gn.medium"|"c6gn.large"|"c6gn.xlarge"|"c6gn.2xlarge"|"c6gn.4xlarge"|"c6gn.8xlarge"|"c6gn.12xlarge"|"c6gn.16xlarge"|"cc1.4xlarge"|"cc2.8xlarge"|"g2.2xlarge"|"g2.8xlarge"|"g3.4xlarge"|"g3.8xlarge"|"g3.16xlarge"|"g3s.xlarge"|"g4ad.4xlarge"|"g4ad.8xlarge"|"g4ad.16xlarge"|"g4dn.xlarge"|"g4dn.2xlarge"|"g4dn.4xlarge"|"g4dn.8xlarge"|"g4dn.12xlarge"|"g4dn.16xlarge"|"g4dn.metal"|"cg1.4xlarge"|"p2.xlarge"|"p2.8xlarge"|"p2.16xlarge"|"p3.2xlarge"|"p3.8xlarge"|"p3.16xlarge"|"p3dn.24xlarge"|"p4d.24xlarge"|"d2.xlarge"|"d2.2xlarge"|"d2.4xlarge"|"d2.8xlarge"|"d3.xlarge"|"d3.2xlarge"|"d3.4xlarge"|"d3.8xlarge"|"d3en.xlarge"|"d3en.2xlarge"|"d3en.4xlarge"|"d3en.6xlarge"|"d3en.8xlarge"|"d3en.12xlarge"|"f1.2xlarge"|"f1.4xlarge"|"f1.16xlarge"|"m5.large"|"m5.xlarge"|"m5.2xlarge"|"m5.4xlarge"|"m5.8xlarge"|"m5.12xlarge"|"m5.16xlarge"|"m5.24xlarge"|"m5.metal"|"m5a.large"|"m5a.xlarge"|"m5a.2xlarge"|"m5a.4xlarge"|"m5a.8xlarge"|"m5a.12xlarge"|"m5a.16xlarge"|"m5a.24xlarge"|"m5d.large"|"m5d.xlarge"|"m5d.2xlarge"|"m5d.4xlarge"|"m5d.8xlarge"|"m5d.12xlarge"|"m5d.16xlarge"|"m5d.24xlarge"|"m5d.metal"|"m5ad.large"|"m5ad.xlarge"|"m5ad.2xlarge"|"m5ad.4xlarge"|"m5ad.8xlarge"|"m5ad.12xlarge"|"m5ad.16xlarge"|"m5ad.24xlarge"|"m5zn.large"|"m5zn.xlarge"|"m5zn.2xlarge"|"m5zn.3xlarge"|"m5zn.6xlarge"|"m5zn.12xlarge"|"m5zn.metal"|"h1.2xlarge"|"h1.4xlarge"|"h1.8xlarge"|"h1.16xlarge"|"z1d.large"|"z1d.xlarge"|"z1d.2xlarge"|"z1d.3xlarge"|"z1d.6xlarge"|"z1d.12xlarge"|"z1d.metal"|"u-6tb1.metal"|"u-9tb1.metal"|"u-12tb1.metal"|"u-18tb1.metal"|"u-24tb1.metal"|"a1.medium"|"a1.large"|"a1.xlarge"|"a1.2xlarge"|"a1.4xlarge"|"a1.metal"|"m5dn.large"|"m5dn.xlarge"|"m5dn.2xlarge"|"m5dn.4xlarge"|"m5dn.8xlarge"|"m5dn.12xlarge"|"m5dn.16xlarge"|"m5dn.24xlarge"|"m5n.large"|"m5n.xlarge"|"m5n.2xlarge"|"m5n.4xlarge"|"m5n.8xlarge"|"m5n.12xlarge"|"m5n.16xlarge"|"m5n.24xlarge"|"r5dn.large"|"r5dn.xlarge"|"r5dn.2xlarge"|"r5dn.4xlarge"|"r5dn.8xlarge"|"r5dn.12xlarge"|"r5dn.16xlarge"|"r5dn.24xlarge"|"r5n.large"|"r5n.xlarge"|"r5n.2xlarge"|"r5n.4xlarge"|"r5n.8xlarge"|"r5n.12xlarge"|"r5n.16xlarge"|"r5n.24xlarge"|"inf1.xlarge"|"inf1.2xlarge"|"inf1.6xlarge"|"inf1.24xlarge"|"m6g.metal"|"m6g.medium"|"m6g.large"|"m6g.xlarge"|"m6g.2xlarge"|"m6g.4xlarge"|"m6g.8xlarge"|"m6g.12xlarge"|"m6g.16xlarge"|"m6gd.metal"|"m6gd.medium"|"m6gd.large"|"m6gd.xlarge"|"m6gd.2xlarge"|"m6gd.4xlarge"|"m6gd.8xlarge"|"m6gd.12xlarge"|"m6gd.16xlarge"|"mac1.metal",
        KernelId = "string",
        KeyName = "string",
        NetworkInterfaces = list(
          list(
            AssociatePublicIpAddress = TRUE|FALSE,
            DeleteOnTermination = TRUE|FALSE,
            Description = "string",
            DeviceIndex = 123,
            Groups = list(
              "string"
            ),
            Ipv6AddressCount = 123,
            Ipv6Addresses = list(
              list(
                Ipv6Address = "string"
              )
            ),
            NetworkInterfaceId = "string",
            PrivateIpAddress = "string",
            PrivateIpAddresses = list(
              list(
                Primary = TRUE|FALSE,
                PrivateIpAddress = "string"
              )
            ),
            SecondaryPrivateIpAddressCount = 123,
            SubnetId = "string",
            AssociateCarrierIpAddress = TRUE|FALSE,
            InterfaceType = "string",
            NetworkCardIndex = 123
          )
        ),
        Placement = list(
          AvailabilityZone = "string",
          GroupName = "string",
          Tenancy = "default"|"dedicated"|"host"
        ),
        RamdiskId = "string",
        SubnetId = "string",
        Monitoring = list(
          Enabled = TRUE|FALSE
        )
      ),
      LaunchedAvailabilityZone = "string",
      ProductDescription = "Linux/UNIX"|"Linux/UNIX (Amazon VPC)"|"Windows"|"Windows (Amazon VPC)",
      SpotInstanceRequestId = "string",
      SpotPrice = "string",
      State = "open"|"active"|"closed"|"cancelled"|"failed",
      Status = list(
        Code = "string",
        Message = "string",
        UpdateTime = as.POSIXct(
          "2015-01-01"
        )
      ),
      Tags = list(
        list(
          Key = "string",
          Value = "string"
        )
      ),
      Type = "one-time"|"persistent",
      ValidFrom = as.POSIXct(
        "2015-01-01"
      ),
      ValidUntil = as.POSIXct(
        "2015-01-01"
      ),
      InstanceInterruptionBehavior = "hibernate"|"stop"|"terminate"
    )
  ),
  NextToken = "string"
)
}
}
\description{
Describes the specified Spot Instance requests.

You can use
\code{\link[=ec2_describe_spot_instance_requests]{describe_spot_instance_requests}}
to find a running Spot Instance by examining the response. If the status
of the Spot Instance is \code{fulfilled}, the instance ID appears in the
response and contains the identifier of the instance. Alternatively, you
can use \code{\link[=ec2_describe_instances]{describe_instances}} with a filter to
look for instances where the instance lifecycle is \code{spot}.

We recommend that you set \code{MaxResults} to a value between 5 and 1000 to
limit the number of results returned. This paginates the output, which
makes the list more manageable and returns the results faster. If the
list of results exceeds your \code{MaxResults} value, then that number of
results is returned along with a \code{NextToken} value that can be passed to
a subsequent
\code{\link[=ec2_describe_spot_instance_requests]{describe_spot_instance_requests}}
request to retrieve the remaining results.

Spot Instance requests are deleted four hours after they are canceled
and their instances are terminated.
}
\section{Request syntax}{
\preformatted{svc$describe_spot_instance_requests(
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  DryRun = TRUE|FALSE,
  SpotInstanceRequestIds = list(
    "string"
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\examples{
\dontrun{
# This example describes the specified Spot Instance request.
svc$describe_spot_instance_requests(
  SpotInstanceRequestIds = list(
    "sir-08b93456"
  )
)
}

}
\keyword{internal}
