% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_attach_classic_link_vpc}
\alias{ec2_attach_classic_link_vpc}
\title{Links an EC2-Classic instance to a ClassicLink-enabled VPC through one
or more of the VPC's security groups}
\usage{
ec2_attach_classic_link_vpc(DryRun, Groups, InstanceId, VpcId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{Groups}{[required] The ID of one or more of the VPC's security groups. You cannot specify
security groups from a different VPC.}

\item{InstanceId}{[required] The ID of an EC2-Classic instance to link to the ClassicLink-enabled
VPC.}

\item{VpcId}{[required] The ID of a ClassicLink-enabled VPC.}
}
\description{
Links an EC2-Classic instance to a ClassicLink-enabled VPC through one
or more of the VPC's security groups. You cannot link an EC2-Classic
instance to more than one VPC at a time. You can only link an instance
that's in the \code{running} state. An instance is automatically unlinked
from a VPC when it's stopped - you can link it to the VPC again when you
restart it.

After you've linked an instance, you cannot change the VPC security
groups that are associated with it. To change the security groups, you
must first unlink the instance, and then link it again.

Linking your instance to a VPC is sometimes referred to as \emph{attaching}
your instance.
}
\section{Request syntax}{
\preformatted{svc$attach_classic_link_vpc(
  DryRun = TRUE|FALSE,
  Groups = list(
    "string"
  ),
  InstanceId = "string",
  VpcId = "string"
)
}
}

\keyword{internal}
