% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ecs_operations.R
\name{ecs_create_task_set}
\alias{ecs_create_task_set}
\title{Create a task set in the specified cluster and service}
\usage{
ecs_create_task_set(service, cluster, externalId, taskDefinition,
  networkConfiguration, loadBalancers, serviceRegistries, launchType,
  platformVersion, scale, clientToken)
}
\arguments{
\item{service}{[required] The short name or full Amazon Resource Name (ARN) of the service to
create the task set in.}

\item{cluster}{[required] The short name or full Amazon Resource Name (ARN) of the cluster that
hosts the service to create the task set in.}

\item{externalId}{An optional non-unique tag that identifies this task set in external
systems. If the task set is associated with a service discovery
registry, the tasks in this task set will have the
\code{ECS_TASK_SET_EXTERNAL_ID} AWS Cloud Map attribute set to the provided
value.}

\item{taskDefinition}{[required] The task definition for the tasks in the task set to use.}

\item{networkConfiguration}{}

\item{loadBalancers}{A load balancer object representing the load balancer to use with the
task set. The supported load balancer types are either an Application
Load Balancer or a Network Load Balancer.}

\item{serviceRegistries}{The details of the service discovery registries to assign to this task
set. For more information, see \href{http://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-discovery.html}{Service Discovery}.}

\item{launchType}{The launch type that new tasks in the task set will use. For more
information, see \href{https://docs.aws.amazon.com/AmazonECS/latest/developerguide/launch_types.html}{Amazon ECS Launch Types}
in the \emph{Amazon Elastic Container Service Developer Guide}.}

\item{platformVersion}{The platform version that the tasks in the task set should use. A
platform version is specified only for tasks using the Fargate launch
type. If one isn't specified, the \code{LATEST} platform version is used by
default.}

\item{scale}{}

\item{clientToken}{Unique, case-sensitive identifier that you provide to ensure the
idempotency of the request. Up to 32 ASCII characters are allowed.}
}
\description{
Create a task set in the specified cluster and service. This is used
when a service uses the \code{EXTERNAL} deployment controller type. For more
information, see \href{http://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html}{Amazon ECS Deployment Types}
in the \emph{Amazon Elastic Container Service Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_task_set(
  service = "string",
  cluster = "string",
  externalId = "string",
  taskDefinition = "string",
  networkConfiguration = list(
    awsvpcConfiguration = list(
      subnets = list(
        "string"
      ),
      securityGroups = list(
        "string"
      ),
      assignPublicIp = "ENABLED"|"DISABLED"
    )
  ),
  loadBalancers = list(
    list(
      targetGroupArn = "string",
      loadBalancerName = "string",
      containerName = "string",
      containerPort = 123
    )
  ),
  serviceRegistries = list(
    list(
      registryArn = "string",
      port = 123,
      containerName = "string",
      containerPort = 123
    )
  ),
  launchType = "EC2"|"FARGATE",
  platformVersion = "string",
  scale = list(
    value = 123.0,
    unit = "PERCENT"
  ),
  clientToken = "string"
)
}
}

\keyword{internal}
