% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_describe_volumes_modifications}
\alias{ec2_describe_volumes_modifications}
\title{Reports the current modification status of EBS volumes}
\usage{
ec2_describe_volumes_modifications(DryRun, VolumeIds, Filters,
  NextToken, MaxResults)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VolumeIds}{One or more volume IDs for which in-progress modifications will be
described.}

\item{Filters}{One or more filters. Supported filters: \code{volume-id},
\code{modification-state}, \code{target-size}, \code{target-iops},
\code{target-volume-type}, \code{original-size}, \code{original-iops},
\code{original-volume-type}, \code{start-time}.}

\item{NextToken}{The \code{nextToken} value returned by a previous paginated request.}

\item{MaxResults}{The maximum number of results (up to a limit of 500) to be returned in a
paginated request.}
}
\description{
Reports the current modification status of EBS volumes.
}
\details{
Current-generation EBS volumes support modification of attributes
including type, size, and (for \code{io1} volumes) IOPS provisioning while
either attached to or detached from an instance. Following an action
from the API or the console to modify a volume, the status of the
modification may be \code{modifying}, \code{optimizing}, \code{completed}, or \code{failed}.
If a volume has never been modified, then certain elements of the
returned \code{VolumeModification} objects are null.

You can also use CloudWatch Events to check the status of a modification
to an EBS volume. For information about CloudWatch Events, see the
\href{https://docs.aws.amazon.com/AmazonCloudWatch/latest/events/}{Amazon CloudWatch Events User Guide}. For
more information, see \href{https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/ebs-expand-volume.html#monitoring_mods}{Monitoring Volume Modifications"}
in the \emph{Amazon Elastic Compute Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$describe_volumes_modifications(
  DryRun = TRUE|FALSE,
  VolumeIds = list(
    "string"
  ),
  Filters = list(
    list(
      Name = "string",
      Values = list(
        "string"
      )
    )
  ),
  NextToken = "string",
  MaxResults = 123
)
}
}

\keyword{internal}
