% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ec2_operations.R
\name{ec2_create_route_table}
\alias{ec2_create_route_table}
\title{Creates a route table for the specified VPC}
\usage{
ec2_create_route_table(DryRun, VpcId)
}
\arguments{
\item{DryRun}{Checks whether you have the required permissions for the action, without
actually making the request, and provides an error response. If you have
the required permissions, the error response is \code{DryRunOperation}.
Otherwise, it is \code{UnauthorizedOperation}.}

\item{VpcId}{[required] The ID of the VPC.}
}
\description{
Creates a route table for the specified VPC. After you create a route
table, you can add routes and associate the table with a subnet.
}
\details{
For more information, see \href{https://docs.aws.amazon.com/AmazonVPC/latest/UserGuide/VPC_Route_Tables.html}{Route Tables}
in the \emph{Amazon Virtual Private Cloud User Guide}.
}
\section{Request syntax}{
\preformatted{svc$create_route_table(
  DryRun = TRUE|FALSE,
  VpcId = "string"
)
}
}

\examples{
# This example creates a route table for the specified VPC.
\donttest{svc$create_route_table(
  VpcId = "vpc-a01106c2"
)}

}
\keyword{internal}
