% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/handlers.R
\name{handlers}
\alias{handlers}
\alias{handlers_set}
\alias{handlers_add_back}
\alias{handlers_add_front}
\title{Set or add to handler lists}
\usage{
handlers_set(...)

handlers_add_back(existing, ...)

handlers_add_front(existing, ...)
}
\arguments{
\item{...}{One or more request-handling functions to add.}

\item{existing}{An existing request handler list.}
}
\description{
Set or add to a list of request-handling functions. Request-handling
functions must take a request and return a request.
}
\examples{
\dontrun{
# Replace a handler list with a new handler list.
handlers$build <- handlers_set(restxml_build)

# Add a new handler onto the end of an existing handler list.
handlers$build <- handlers_add_back(handlers$build, restxml_build)

# Add a new handler at the beginning of an existing handler list.
handlers$build <- handlers_add_front(handlers$build, restxml_build)
}

}
\keyword{internal}
