% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/service.R
\name{new_service}
\alias{new_service}
\title{Return an AWS API service object}
\usage{
new_service(metadata, handlers, cfgs = NULL)
}
\arguments{
\item{metadata}{A named list of API metadata. It should look like:\preformatted{list(
  service_name = "string",
  endpoints = list("region" = list(endpoint = "endpoint", global = FALSE)),
  service_id = "string",
  api_version = "string",
  signing_name = "string"|NULL,
  json_version = "string",
  target_prefix = "string"
)
}}

\item{handlers}{A set of handlers, e.g. from \code{new_handlers}.}

\item{cfgs}{A config defined by the service. Defaults to null.}
}
\description{
Return an API service object with information and handlers needed to make
API requests.
}
\section{Region and credentials}{


\code{new_service} requires that you've set your AWS region in one of:
\enumerate{
\item \code{AWS_REGION} R environment variable
\item \code{AWS_REGION} OS environment variable (Linux and macOS)
\item \verb{~/.aws/config} AWS configuration file
}

\code{new_service} also requires that you've set your AWS credentials in one of:
\enumerate{
\item \code{AWS_ACCESS_KEY_ID} and \code{AWS_SECRET_ACCESS_KEY} R environment variables
\item \code{AWS_ACCESS_KEY_ID} and \code{AWS_SECRET_ACCESS_KEY} OS environment variables
(Linux and macOS)
\item \verb{~/.aws/credentials} AWS credentials file
\item IAM role
}
}

\examples{
\donttest{# Metadata for the S3 API.
metadata <- list(
  service_name = "s3",
  endpoints = list("us-east-1" = list(endpoint = "s3.amazonaws.com", global = FALSE)),
  service_id = "S3",
  api_version = "2006-03-01",
  signing_name = NULL,
  json_version = "",
  target_prefix = ""
)

# Handlers for S3.
handlers <- new_handlers("restxml", "v4")

# Build a service object for S3, containing the information necessary to
# build, send, and receive requests.
service <- new_service(metadata, handlers)}

}
\seealso{
Other API request functions: 
\code{\link{new_handlers}()},
\code{\link{new_operation}()},
\code{\link{new_request}()},
\code{\link{send_request}()}
}
\concept{API request functions}
