% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn_operations.R
\name{sfn_start_sync_execution}
\alias{sfn_start_sync_execution}
\title{Starts a Synchronous Express state machine execution}
\usage{
sfn_start_sync_execution(
  stateMachineArn,
  name = NULL,
  input = NULL,
  traceHeader = NULL,
  includedData = NULL
)
}
\arguments{
\item{stateMachineArn}{[required] The Amazon Resource Name (ARN) of the state machine to execute.}

\item{name}{The name of the execution.}

\item{input}{The string that contains the JSON input data for the execution, for
example:

\verb{"input": "\{\\"first_name\\" : \\"test\\"\}"}

If you don't include any JSON input data, you still must include the two
braces, for example: \code{"input": "{}"}

Length constraints apply to the payload size, and are expressed as bytes
in UTF-8 encoding.}

\item{traceHeader}{Passes the X-Ray trace header. The trace header can also be passed in
the request payload.}

\item{includedData}{If your state machine definition is encrypted with a KMS key, callers
must have \code{kms:Decrypt} permission to decrypt the definition.
Alternatively, you can call the API with \code{includedData = METADATA_ONLY}
to get a successful response without the encrypted definition.}
}
\description{
Starts a Synchronous Express state machine execution. \code{\link[=sfn_start_sync_execution]{start_sync_execution}} is not available for \code{STANDARD} workflows.

See \url{https://www.paws-r-sdk.com/docs/sfn_start_sync_execution/} for full documentation.
}
\keyword{internal}
