% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_create_integration}
\alias{glue_create_integration}
\title{Creates a Zero-ETL integration in the caller's account between two
resources with Amazon Resource Names (ARNs): the SourceArn and TargetArn}
\usage{
glue_create_integration(
  IntegrationName,
  SourceArn,
  TargetArn,
  Description = NULL,
  DataFilter = NULL,
  KmsKeyId = NULL,
  AdditionalEncryptionContext = NULL,
  Tags = NULL
)
}
\arguments{
\item{IntegrationName}{[required] A unique name for an integration in Glue.}

\item{SourceArn}{[required] The ARN of the source resource for the integration.}

\item{TargetArn}{[required] The ARN of the target resource for the integration.}

\item{Description}{A description of the integration.}

\item{DataFilter}{Selects source tables for the integration using Maxwell filter syntax.}

\item{KmsKeyId}{The ARN of a KMS key used for encrypting the channel.}

\item{AdditionalEncryptionContext}{An optional set of non-secret key–value pairs that contains additional
contextual information for encryption. This can only be provided if
\code{KMSKeyId} is provided.}

\item{Tags}{Metadata assigned to the resource consisting of a list of key-value
pairs.}
}
\description{
Creates a Zero-ETL integration in the caller's account between two resources with Amazon Resource Names (ARNs): the \code{SourceArn} and \code{TargetArn}.

See \url{https://www.paws-r-sdk.com/docs/glue_create_integration/} for full documentation.
}
\keyword{internal}
