% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kendra_operations.R
\name{kendra_create_thesaurus}
\alias{kendra_create_thesaurus}
\title{Creates a thesaurus for an index}
\usage{
kendra_create_thesaurus(
  IndexId,
  Name,
  Description = NULL,
  RoleArn,
  Tags = NULL,
  SourceS3Path,
  ClientToken = NULL
)
}
\arguments{
\item{IndexId}{[required] The identifier of the index for the thesaurus.}

\item{Name}{[required] A name for the thesaurus.}

\item{Description}{A description for the thesaurus.}

\item{RoleArn}{[required] The Amazon Resource Name (ARN) of an IAM role with permission to access
your S3 bucket that contains the thesaurus file. For more information,
see \href{https://docs.aws.amazon.com/kendra/latest/dg/iam-roles.html}{IAM access roles for Amazon Kendra}.}

\item{Tags}{A list of key-value pairs that identify or categorize the thesaurus. You
can also use tags to help control access to the thesaurus. Tag keys and
values can consist of Unicode letters, digits, white space, and any of
the following symbols: _ . : / = + - @.}

\item{SourceS3Path}{[required] The path to the thesaurus file in S3.}

\item{ClientToken}{A token that you provide to identify the request to create a thesaurus.
Multiple calls to the \code{\link[=kendra_create_thesaurus]{create_thesaurus}} API
with the same client token will create only one thesaurus.}
}
\description{
Creates a thesaurus for an index. The thesaurus contains a list of synonyms in Solr format.

See \url{https://www.paws-r-sdk.com/docs/kendra_create_thesaurus/} for full documentation.
}
\keyword{internal}
