% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/entityresolution_operations.R
\name{entityresolution_update_id_mapping_workflow}
\alias{entityresolution_update_id_mapping_workflow}
\title{Updates an existing IdMappingWorkflow}
\usage{
entityresolution_update_id_mapping_workflow(
  description = NULL,
  idMappingTechniques,
  inputSourceConfig,
  outputSourceConfig = NULL,
  roleArn,
  workflowName
)
}
\arguments{
\item{description}{A description of the workflow.}

\item{idMappingTechniques}{[required] An object which defines the \code{idMappingType} and the
\code{providerProperties}.}

\item{inputSourceConfig}{[required] A list of \code{InputSource} objects, which have the fields \code{InputSourceARN}
and \code{SchemaName}.}

\item{outputSourceConfig}{A list of \code{OutputSource} objects, each of which contains fields
\code{OutputS3Path} and \code{KMSArn}.}

\item{roleArn}{[required] The Amazon Resource Name (ARN) of the IAM role. Entity Resolution
assumes this role to access Amazon Web Services resources on your
behalf.}

\item{workflowName}{[required] The name of the workflow.}
}
\description{
Updates an existing \code{IdMappingWorkflow}. This method is identical to \code{\link[=entityresolution_create_id_mapping_workflow]{create_id_mapping_workflow}}, except it uses an HTTP \code{PUT} request instead of a \code{POST} request, and the \code{IdMappingWorkflow} must already exist for the method to succeed.

See \url{https://www.paws-r-sdk.com/docs/entityresolution_update_id_mapping_workflow/} for full documentation.
}
\keyword{internal}
