# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon Interactive Video Service RealTime
#'
#' @description
#' **Introduction**
#' 
#' The Amazon Interactive Video Service (IVS) real-time API is REST
#' compatible, using a standard HTTP API and an AWS EventBridge event
#' stream for responses. JSON is used for both requests and responses,
#' including errors.
#' 
#' Terminology:
#' 
#' -   A *stage* is a virtual space where participants can exchange video
#'     in real time.
#' 
#' -   A *participant token* is a token that authenticates a participant
#'     when they join a stage.
#' 
#' -   A *participant object* represents participants (people) in the stage
#'     and contains information about them. When a token is created, it
#'     includes a participant ID; when a participant uses that token to
#'     join a stage, the participant is associated with that participant
#'     ID. There is a 1:1 mapping between participant tokens and
#'     participants.
#' 
#' -   Server-side composition: The *composition* process composites
#'     participants of a stage into a single video and forwards it to a set
#'     of outputs (e.g., IVS channels). Composition endpoints support this
#'     process.
#' 
#' -   Server-side composition: A *composition* controls the look of the
#'     outputs, including how participants are positioned in the video.
#' 
#' **Resources**
#' 
#' The following resources contain information about your IVS live stream
#' (see [Getting Started with Amazon IVS Real-Time
#' Streaming](https://docs.aws.amazon.com/ivs/latest/RealTimeUserGuide/getting-started.html)):
#' 
#' -   **Stage** — A stage is a virtual space where participants can
#'     exchange video in real time.
#' 
#' **Tagging**
#' 
#' A *tag* is a metadata label that you assign to an AWS resource. A tag
#' comprises a *key* and a *value*, both set by you. For example, you might
#' set a tag as `topic:nature` to label a particular video category. See
#' [Tagging AWS
#' Resources](https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html)
#' for more information, including restrictions that apply to tags and "Tag
#' naming limits and requirements"; Amazon IVS stages has no
#' service-specific constraints beyond what is documented there.
#' 
#' Tags can help you identify and organize your AWS resources. For example,
#' you can use the same tag for different resources to indicate that they
#' are related. You can also use tags to manage access (see [Access
#' Tags](https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html)).
#' 
#' The Amazon IVS real-time API has these tag-related endpoints:
#' [`tag_resource`][ivsrealtime_tag_resource],
#' [`untag_resource`][ivsrealtime_untag_resource], and
#' [`list_tags_for_resource`][ivsrealtime_list_tags_for_resource]. The
#' following resource supports tagging: Stage.
#' 
#' At most 50 tags can be applied to a resource.
#' 
#' **Stages Endpoints**
#' 
#' -   [`create_participant_token`][ivsrealtime_create_participant_token] —
#'     Creates an additional token for a specified stage. This can be done
#'     after stage creation or when tokens expire.
#' 
#' -   [`create_stage`][ivsrealtime_create_stage] — Creates a new stage
#'     (and optionally participant tokens).
#' 
#' -   [`delete_stage`][ivsrealtime_delete_stage] — Shuts down and deletes
#'     the specified stage (disconnecting all participants).
#' 
#' -   [`disconnect_participant`][ivsrealtime_disconnect_participant] —
#'     Disconnects a specified participant and revokes the participant
#'     permanently from a specified stage.
#' 
#' -   [`get_participant`][ivsrealtime_get_participant] — Gets information
#'     about the specified participant token.
#' 
#' -   [`get_stage`][ivsrealtime_get_stage] — Gets information for the
#'     specified stage.
#' 
#' -   [`get_stage_session`][ivsrealtime_get_stage_session] — Gets
#'     information for the specified stage session.
#' 
#' -   [`list_participant_events`][ivsrealtime_list_participant_events] —
#'     Lists events for a specified participant that occurred during a
#'     specified stage session.
#' 
#' -   [`list_participants`][ivsrealtime_list_participants] — Lists all
#'     participants in a specified stage session.
#' 
#' -   [`list_stages`][ivsrealtime_list_stages] — Gets summary information
#'     about all stages in your account, in the AWS region where the API
#'     request is processed.
#' 
#' -   [`list_stage_sessions`][ivsrealtime_list_stage_sessions] — Gets all
#'     sessions for a specified stage.
#' 
#' -   [`update_stage`][ivsrealtime_update_stage] — Updates a stage’s
#'     configuration.
#' 
#' **Composition Endpoints**
#' 
#' -   [`get_composition`][ivsrealtime_get_composition] — Gets information
#'     about the specified Composition resource.
#' 
#' -   [`list_compositions`][ivsrealtime_list_compositions] — Gets summary
#'     information about all Compositions in your account, in the AWS
#'     region where the API request is processed.
#' 
#' -   [`start_composition`][ivsrealtime_start_composition] — Starts a
#'     Composition from a stage based on the configuration provided in the
#'     request.
#' 
#' -   [`stop_composition`][ivsrealtime_stop_composition] — Stops and
#'     deletes a Composition resource. Any broadcast from the Composition
#'     resource is stopped.
#' 
#' **EncoderConfiguration Endpoints**
#' 
#' -   [`create_encoder_configuration`][ivsrealtime_create_encoder_configuration]
#'     — Creates an EncoderConfiguration object.
#' 
#' -   [`delete_encoder_configuration`][ivsrealtime_delete_encoder_configuration]
#'     — Deletes an EncoderConfiguration resource. Ensures that no
#'     Compositions are using this template; otherwise, returns an error.
#' 
#' -   [`get_encoder_configuration`][ivsrealtime_get_encoder_configuration]
#'     — Gets information about the specified EncoderConfiguration
#'     resource.
#' 
#' -   [`list_encoder_configurations`][ivsrealtime_list_encoder_configurations]
#'     — Gets summary information about all EncoderConfigurations in your
#'     account, in the AWS region where the API request is processed.
#' 
#' **StorageConfiguration Endpoints**
#' 
#' -   [`create_storage_configuration`][ivsrealtime_create_storage_configuration]
#'     — Creates a new storage configuration, used to enable recording to
#'     Amazon S3.
#' 
#' -   [`delete_storage_configuration`][ivsrealtime_delete_storage_configuration]
#'     — Deletes the storage configuration for the specified ARN.
#' 
#' -   [`get_storage_configuration`][ivsrealtime_get_storage_configuration]
#'     — Gets the storage configuration for the specified ARN.
#' 
#' -   [`list_storage_configurations`][ivsrealtime_list_storage_configurations]
#'     — Gets summary information about all storage configurations in your
#'     account, in the AWS region where the API request is processed.
#' 
#' **Tags Endpoints**
#' 
#' -   [`list_tags_for_resource`][ivsrealtime_list_tags_for_resource] —
#'     Gets information about AWS tags for the specified ARN.
#' 
#' -   [`tag_resource`][ivsrealtime_tag_resource] — Adds or updates tags
#'     for the AWS resource with the specified ARN.
#' 
#' -   [`untag_resource`][ivsrealtime_untag_resource] — Removes tags from
#'     the resource with the specified ARN.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- ivsrealtime(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- ivsrealtime()
#' svc$create_encoder_configuration(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=ivsrealtime_create_encoder_configuration]{create_encoder_configuration} \tab Creates an EncoderConfiguration object\cr
#'  \link[=ivsrealtime_create_participant_token]{create_participant_token} \tab Creates an additional token for a specified stage\cr
#'  \link[=ivsrealtime_create_stage]{create_stage} \tab Creates a new stage (and optionally participant tokens)\cr
#'  \link[=ivsrealtime_create_storage_configuration]{create_storage_configuration} \tab Creates a new storage configuration, used to enable recording to Amazon S3\cr
#'  \link[=ivsrealtime_delete_encoder_configuration]{delete_encoder_configuration} \tab Deletes an EncoderConfiguration resource\cr
#'  \link[=ivsrealtime_delete_stage]{delete_stage} \tab Shuts down and deletes the specified stage (disconnecting all participants)\cr
#'  \link[=ivsrealtime_delete_storage_configuration]{delete_storage_configuration} \tab Deletes the storage configuration for the specified ARN\cr
#'  \link[=ivsrealtime_disconnect_participant]{disconnect_participant} \tab Disconnects a specified participant and revokes the participant permanently from a specified stage\cr
#'  \link[=ivsrealtime_get_composition]{get_composition} \tab Get information about the specified Composition resource\cr
#'  \link[=ivsrealtime_get_encoder_configuration]{get_encoder_configuration} \tab Gets information about the specified EncoderConfiguration resource\cr
#'  \link[=ivsrealtime_get_participant]{get_participant} \tab Gets information about the specified participant token\cr
#'  \link[=ivsrealtime_get_stage]{get_stage} \tab Gets information for the specified stage\cr
#'  \link[=ivsrealtime_get_stage_session]{get_stage_session} \tab Gets information for the specified stage session\cr
#'  \link[=ivsrealtime_get_storage_configuration]{get_storage_configuration} \tab Gets the storage configuration for the specified ARN\cr
#'  \link[=ivsrealtime_list_compositions]{list_compositions} \tab Gets summary information about all Compositions in your account, in the AWS region where the API request is processed\cr
#'  \link[=ivsrealtime_list_encoder_configurations]{list_encoder_configurations} \tab Gets summary information about all EncoderConfigurations in your account, in the AWS region where the API request is processed\cr
#'  \link[=ivsrealtime_list_participant_events]{list_participant_events} \tab Lists events for a specified participant that occurred during a specified stage session\cr
#'  \link[=ivsrealtime_list_participants]{list_participants} \tab Lists all participants in a specified stage session\cr
#'  \link[=ivsrealtime_list_stages]{list_stages} \tab Gets summary information about all stages in your account, in the AWS region where the API request is processed\cr
#'  \link[=ivsrealtime_list_stage_sessions]{list_stage_sessions} \tab Gets all sessions for a specified stage\cr
#'  \link[=ivsrealtime_list_storage_configurations]{list_storage_configurations} \tab Gets summary information about all storage configurations in your account, in the AWS region where the API request is processed\cr
#'  \link[=ivsrealtime_list_tags_for_resource]{list_tags_for_resource} \tab Gets information about AWS tags for the specified ARN\cr
#'  \link[=ivsrealtime_start_composition]{start_composition} \tab Starts a Composition from a stage based on the configuration provided in the request\cr
#'  \link[=ivsrealtime_stop_composition]{stop_composition} \tab Stops and deletes a Composition resource\cr
#'  \link[=ivsrealtime_tag_resource]{tag_resource} \tab Adds or updates tags for the AWS resource with the specified ARN\cr
#'  \link[=ivsrealtime_untag_resource]{untag_resource} \tab Removes tags from the resource with the specified ARN\cr
#'  \link[=ivsrealtime_update_stage]{update_stage} \tab Updates a stage’s configuration
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname ivsrealtime
#' @export
ivsrealtime <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .ivsrealtime$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.ivsrealtime <- list()

.ivsrealtime$operations <- list()

.ivsrealtime$metadata <- list(
  service_name = "ivsrealtime",
  endpoints = list("*" = list(endpoint = "ivsrealtime.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "ivsrealtime.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "ivsrealtime.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "ivsrealtime.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "ivsrealtime.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "ivsrealtime.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "IVS RealTime",
  api_version = "2020-07-14",
  signing_name = "ivs",
  json_version = "1.1",
  target_prefix = ""
)

.ivsrealtime$service <- function(config = list()) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.ivsrealtime$metadata, handlers, config)
}
