% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivsrealtime_operations.R
\name{ivsrealtime_list_participant_events}
\alias{ivsrealtime_list_participant_events}
\title{Lists events for a specified participant that occurred during a
specified stage session}
\usage{
ivsrealtime_list_participant_events(
  maxResults = NULL,
  nextToken = NULL,
  participantId,
  sessionId,
  stageArn
)
}
\arguments{
\item{maxResults}{Maximum number of results to return. Default: 50.}

\item{nextToken}{The first participant event to retrieve. This is used for pagination;
see the \code{nextToken} response field.}

\item{participantId}{[required] Unique identifier for this participant. This is assigned by IVS and
returned by
\code{\link[=ivsrealtime_create_participant_token]{create_participant_token}}.}

\item{sessionId}{[required] ID of a session within the stage.}

\item{stageArn}{[required] Stage ARN.}
}
\description{
Lists events for a specified participant that occurred during a specified stage session.

See \url{https://www.paws-r-sdk.com/docs/ivsrealtime_list_participant_events/} for full documentation.
}
\keyword{internal}
