% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ivs_service.R
\name{ivs}
\alias{ivs}
\title{Amazon Interactive Video Service}
\usage{
ivs(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.
\itemize{
\item{\strong{access_key_id}:} {AWS access key ID}
\item{\strong{secret_access_key}:} {AWS secret access key}
\item{\strong{session_token}:} {AWS temporary session token}
\item{\strong{profile}:} {The name of a profile to use. If not given, then the default profile is used.}
\item{\strong{anonymous}:} {Set anonymous credentials.}
\item{\strong{endpoint}:} {The complete URL to use for the constructed client.}
\item{\strong{region}:} {The AWS Region used in instantiating the client.}
\item{\strong{close_connection}:} {Immediately close all HTTP connections.}
\item{\strong{timeout}:} {The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
\item{\strong{s3_force_path_style}:} {Set this to \code{true} to force the request to use path-style addressing, i.e., \verb{http://s3.amazonaws.com/BUCKET/KEY}.}
}}
}
\value{
A client for the service. You can call the service's operations using
syntax like \code{svc$operation(...)}, where \code{svc} is the name you've assigned
to the client. The available operations are listed in the
Operations section.
}
\description{
\strong{Introduction}

The Amazon Interactive Video Service (IVS) API is REST compatible, using
a standard HTTP API and an Amazon Web Services EventBridge event stream
for responses. JSON is used for both requests and responses, including
errors.

The API is an Amazon Web Services regional service. For a list of
supported regions and Amazon IVS HTTPS service endpoints, see the
\href{https://docs.aws.amazon.com/general/latest/gr/ivs.html}{Amazon IVS page} in the
\emph{Amazon Web Services General Reference}.

*All API request parameters and URLs are case sensitive. *

For a summary of notable documentation changes in each release, see
\href{https://docs.aws.amazon.com/ivs/latest/userguide/doc-history.html}{Document History}.

\strong{Allowed Header Values}
\itemize{
\item \verb{Accept:} application/json
\item \verb{Accept-Encoding:} gzip, deflate
\item \verb{Content-Type:}application/json
}

\strong{Resources}

The following resources contain information about your IVS live stream
(see \href{https://docs.aws.amazon.com/ivs/latest/userguide/getting-started.html}{Getting Started with Amazon IVS}):
\itemize{
\item \strong{Channel} — Stores configuration data related to your live stream.
You first create a channel and then use the channel’s stream key to
start your live stream. See the Channel endpoints for more
information.
\item \strong{Stream key} — An identifier assigned by Amazon IVS when you
create a channel, which is then used to authorize streaming. See the
StreamKey endpoints for more information. \emph{Treat the stream key like
a secret, since it allows anyone to stream to the channel.}
\item \strong{Playback key pair} — Video playback may be restricted using
playback-authorization tokens, which use public-key encryption. A
playback key pair is the public-private pair of keys used to sign
and validate the playback-authorization token. See the
PlaybackKeyPair endpoints for more information.
\item \strong{Recording configuration} — Stores configuration related to
recording a live stream and where to store the recorded content.
Multiple channels can reference the same recording configuration.
See the Recording Configuration endpoints for more information.
}

\strong{Tagging}

A \emph{tag} is a metadata label that you assign to an Amazon Web Services
resource. A tag comprises a \emph{key} and a \emph{value}, both set by you. For
example, you might set a tag as \code{topic:nature} to label a particular
video category. See \href{https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html}{Tagging Amazon Web Services Resources}
for more information, including restrictions that apply to tags and "Tag
naming limits and requirements"; Amazon IVS has no service-specific
constraints beyond what is documented there.

Tags can help you identify and organize your Amazon Web Services
resources. For example, you can use the same tag for different resources
to indicate that they are related. You can also use tags to manage
access (see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/access_tags.html}{Access Tags}).

The Amazon IVS API has these tag-related endpoints:
\code{\link[=ivs_tag_resource]{tag_resource}},
\code{\link[=ivs_untag_resource]{untag_resource}}, and
\code{\link[=ivs_list_tags_for_resource]{list_tags_for_resource}}. The following
resources support tagging: Channels, Stream Keys, Playback Key Pairs,
and Recording Configurations.

At most 50 tags can be applied to a resource.

\strong{Authentication versus Authorization}

Note the differences between these concepts:
\itemize{
\item \emph{Authentication} is about verifying identity. You need to be
authenticated to sign Amazon IVS API requests.
\item \emph{Authorization} is about granting permissions. Your IAM roles need
to have permissions for Amazon IVS API requests. In addition,
authorization is needed to view \href{https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html}{Amazon IVS private channels}.
(Private channels are channels that are enabled for "playback
authorization.")
}

\strong{Authentication}

All Amazon IVS API requests must be authenticated with a signature. The
Amazon Web Services Command-Line Interface (CLI) and Amazon IVS Player
SDKs take care of signing the underlying API calls for you. However, if
your application calls the Amazon IVS API directly, it’s your
responsibility to sign the requests.

You generate a signature using valid Amazon Web Services credentials
that have permission to perform the requested action. For example, you
must sign PutMetadata requests with a signature generated from a user
account that has the \code{ivs:PutMetadata} permission.

For more information:
\itemize{
\item Authentication and generating signatures — See \href{https://docs.aws.amazon.com/AmazonS3/latest/API/sig-v4-authenticating-requests.html}{Authenticating Requests (Amazon Web Services Signature Version 4)}
in the \emph{Amazon Web Services General Reference}.
\item Managing Amazon IVS permissions — See \href{https://docs.aws.amazon.com/ivs/latest/userguide/security-iam.html}{Identity and Access Management}
on the Security page of the \emph{Amazon IVS User Guide}.
}

\strong{Amazon Resource Names (ARNs)}

ARNs uniquely identify AWS resources. An ARN is required when you need
to specify a resource unambiguously across all of AWS, such as in IAM
policies and API calls. For more information, see \href{https://docs.aws.amazon.com/IAM/latest/UserGuide/reference-arns.html}{Amazon Resource Names}
in the \emph{AWS General Reference}.

\strong{Channel Endpoints}
\itemize{
\item \code{\link[=ivs_create_channel]{create_channel}} — Creates a new channel and
an associated stream key to start streaming.
\item \code{\link[=ivs_get_channel]{get_channel}} — Gets the channel configuration
for the specified channel ARN.
\item \code{\link[=ivs_batch_get_channel]{batch_get_channel}} — Performs
\code{\link[=ivs_get_channel]{get_channel}} on multiple ARNs simultaneously.
\item \code{\link[=ivs_list_channels]{list_channels}} — Gets summary information
about all channels in your account, in the Amazon Web Services
region where the API request is processed. This list can be filtered
to match a specified name or recording-configuration ARN. Filters
are mutually exclusive and cannot be used together. If you try to
use both filters, you will get an error (409 Conflict Exception).
\item \code{\link[=ivs_update_channel]{update_channel}} — Updates a channel's
configuration. This does not affect an ongoing stream of this
channel. You must stop and restart the stream for the changes to
take effect.
\item \code{\link[=ivs_delete_channel]{delete_channel}} — Deletes the specified
channel.
}

\strong{StreamKey Endpoints}
\itemize{
\item \code{\link[=ivs_create_stream_key]{create_stream_key}} — Creates a stream key,
used to initiate a stream, for the specified channel ARN.
\item \code{\link[=ivs_get_stream_key]{get_stream_key}} — Gets stream key information
for the specified ARN.
\item \code{\link[=ivs_batch_get_stream_key]{batch_get_stream_key}} — Performs
\code{\link[=ivs_get_stream_key]{get_stream_key}} on multiple ARNs
simultaneously.
\item \code{\link[=ivs_list_stream_keys]{list_stream_keys}} — Gets summary
information about stream keys for the specified channel.
\item \code{\link[=ivs_delete_stream_key]{delete_stream_key}} — Deletes the stream
key for the specified ARN, so it can no longer be used to stream.
}

\strong{Stream Endpoints}
\itemize{
\item \code{\link[=ivs_get_stream]{get_stream}} — Gets information about the active
(live) stream on a specified channel.
\item \code{\link[=ivs_get_stream_session]{get_stream_session}} — Gets metadata on a
specified stream.
\item \code{\link[=ivs_list_streams]{list_streams}} — Gets summary information about
live streams in your account, in the Amazon Web Services region
where the API request is processed.
\item \code{\link[=ivs_list_stream_sessions]{list_stream_sessions}} — Gets a summary
of current and previous streams for a specified channel in your
account, in the AWS region where the API request is processed.
\item \code{\link[=ivs_stop_stream]{stop_stream}} — Disconnects the incoming RTMPS
stream for the specified channel. Can be used in conjunction with
\code{\link[=ivs_delete_stream_key]{delete_stream_key}} to prevent further
streaming to a channel.
\item \code{\link[=ivs_put_metadata]{put_metadata}} — Inserts metadata into the
active stream of the specified channel. At most 5 requests per
second per channel are allowed, each with a maximum 1 KB payload.
(If 5 TPS is not sufficient for your needs, we recommend batching
your data into a single PutMetadata call.) At most 155 requests per
second per account are allowed.
}

\strong{PlaybackKeyPair Endpoints}

For more information, see \href{https://docs.aws.amazon.com/ivs/latest/userguide/private-channels.html}{Setting Up Private Channels}
in the \emph{Amazon IVS User Guide}.
\itemize{
\item \code{\link[=ivs_import_playback_key_pair]{import_playback_key_pair}} — Imports
the public portion of a new key pair and returns its \code{arn} and
\code{fingerprint}. The \code{privateKey} can then be used to generate viewer
authorization tokens, to grant viewers access to private channels
(channels enabled for playback authorization).
\item \code{\link[=ivs_get_playback_key_pair]{get_playback_key_pair}} — Gets a
specified playback authorization key pair and returns the \code{arn} and
\code{fingerprint}. The \code{privateKey} held by the caller can be used to
generate viewer authorization tokens, to grant viewers access to
private channels.
\item \code{\link[=ivs_list_playback_key_pairs]{list_playback_key_pairs}} — Gets
summary information about playback key pairs.
\item \code{\link[=ivs_delete_playback_key_pair]{delete_playback_key_pair}} — Deletes
a specified authorization key pair. This invalidates future viewer
tokens generated using the key pair’s \code{privateKey}.
}

\strong{RecordingConfiguration Endpoints}
\itemize{
\item \code{\link[=ivs_create_recording_configuration]{create_recording_configuration}}
— Creates a new recording configuration, used to enable recording to
Amazon S3.
\item \code{\link[=ivs_get_recording_configuration]{get_recording_configuration}} —
Gets the recording-configuration metadata for the specified ARN.
\item \code{\link[=ivs_list_recording_configurations]{list_recording_configurations}}
— Gets summary information about all recording configurations in
your account, in the Amazon Web Services region where the API
request is processed.
\item \code{\link[=ivs_delete_recording_configuration]{delete_recording_configuration}}
— Deletes the recording configuration for the specified ARN.
}

\strong{Amazon Web Services Tags Endpoints}
\itemize{
\item \code{\link[=ivs_tag_resource]{tag_resource}} — Adds or updates tags for the
Amazon Web Services resource with the specified ARN.
\item \code{\link[=ivs_untag_resource]{untag_resource}} — Removes tags from the
resource with the specified ARN.
\item \code{\link[=ivs_list_tags_for_resource]{list_tags_for_resource}} — Gets
information about Amazon Web Services tags for the specified ARN.
}
}
\section{Service syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc <- ivs(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string",
      anonymous = "logical"
    ),
    endpoint = "string",
    region = "string",
    close_connection = "logical",
    timeout = "numeric",
    s3_force_path_style = "logical"
  )
)
}\if{html}{\out{</div>}}
}

\section{Operations}{

\tabular{ll}{
\link[=ivs_batch_get_channel]{batch_get_channel} \tab Performs GetChannel on multiple ARNs simultaneously\cr
\link[=ivs_batch_get_stream_key]{batch_get_stream_key} \tab Performs GetStreamKey on multiple ARNs simultaneously\cr
\link[=ivs_create_channel]{create_channel} \tab Creates a new channel and an associated stream key to start streaming\cr
\link[=ivs_create_recording_configuration]{create_recording_configuration} \tab Creates a new recording configuration, used to enable recording to Amazon S3\cr
\link[=ivs_create_stream_key]{create_stream_key} \tab Creates a stream key, used to initiate a stream, for the specified channel ARN\cr
\link[=ivs_delete_channel]{delete_channel} \tab Deletes the specified channel and its associated stream keys\cr
\link[=ivs_delete_playback_key_pair]{delete_playback_key_pair} \tab Deletes a specified authorization key pair\cr
\link[=ivs_delete_recording_configuration]{delete_recording_configuration} \tab Deletes the recording configuration for the specified ARN\cr
\link[=ivs_delete_stream_key]{delete_stream_key} \tab Deletes the stream key for the specified ARN, so it can no longer be used to stream\cr
\link[=ivs_get_channel]{get_channel} \tab Gets the channel configuration for the specified channel ARN\cr
\link[=ivs_get_playback_key_pair]{get_playback_key_pair} \tab Gets a specified playback authorization key pair and returns the arn and fingerprint\cr
\link[=ivs_get_recording_configuration]{get_recording_configuration} \tab Gets the recording configuration for the specified ARN\cr
\link[=ivs_get_stream]{get_stream} \tab Gets information about the active (live) stream on a specified channel\cr
\link[=ivs_get_stream_key]{get_stream_key} \tab Gets stream-key information for a specified ARN\cr
\link[=ivs_get_stream_session]{get_stream_session} \tab Gets metadata on a specified stream\cr
\link[=ivs_import_playback_key_pair]{import_playback_key_pair} \tab Imports the public portion of a new key pair and returns its arn and fingerprint\cr
\link[=ivs_list_channels]{list_channels} \tab Gets summary information about all channels in your account, in the Amazon Web Services region where the API request is processed\cr
\link[=ivs_list_playback_key_pairs]{list_playback_key_pairs} \tab Gets summary information about playback key pairs\cr
\link[=ivs_list_recording_configurations]{list_recording_configurations} \tab Gets summary information about all recording configurations in your account, in the Amazon Web Services region where the API request is processed\cr
\link[=ivs_list_stream_keys]{list_stream_keys} \tab Gets summary information about stream keys for the specified channel\cr
\link[=ivs_list_streams]{list_streams} \tab Gets summary information about live streams in your account, in the Amazon Web Services region where the API request is processed\cr
\link[=ivs_list_stream_sessions]{list_stream_sessions} \tab Gets a summary of current and previous streams for a specified channel in your account, in the AWS region where the API request is processed\cr
\link[=ivs_list_tags_for_resource]{list_tags_for_resource} \tab Gets information about Amazon Web Services tags for the specified ARN\cr
\link[=ivs_put_metadata]{put_metadata} \tab Inserts metadata into the active stream of the specified channel\cr
\link[=ivs_stop_stream]{stop_stream} \tab Disconnects the incoming RTMPS stream for the specified channel\cr
\link[=ivs_tag_resource]{tag_resource} \tab Adds or updates tags for the Amazon Web Services resource with the specified ARN\cr
\link[=ivs_untag_resource]{untag_resource} \tab Removes tags from the resource with the specified ARN\cr
\link[=ivs_update_channel]{update_channel} \tab Updates a channel's configuration
}
}

\examples{
\dontrun{
svc <- ivs()
svc$batch_get_channel(
  Foo = 123
)
}

}
