% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/athena_operations.R
\name{athena_update_data_catalog}
\alias{athena_update_data_catalog}
\title{Updates the data catalog that has the specified name}
\usage{
athena_update_data_catalog(Name, Type, Description, Parameters)
}
\arguments{
\item{Name}{[required] The name of the data catalog to update. The catalog name must be unique
for the AWS account and can use a maximum of 128 alphanumeric,
underscore, at sign, or hyphen characters.}

\item{Type}{[required] Specifies the type of data catalog to update. Specify \code{LAMBDA} for a
federated catalog, \code{GLUE} for AWS Glue Catalog, or \code{HIVE} for an
external hive metastore.}

\item{Description}{New or modified text that describes the data catalog.}

\item{Parameters}{Specifies the Lambda function or functions to use for updating the data
catalog. This is a mapping whose values depend on the catalog type.
\itemize{
\item For the \code{HIVE} data catalog type, use the following syntax. The
\verb{metadata-function} parameter is required. \verb{The sdk-version}
parameter is optional and defaults to the currently supported
version.

\verb{metadata-function=<i>lambda_arn</i>, sdk-version=<i>version_number</i> }
\item For the \code{LAMBDA} data catalog type, use one of the following sets of
required parameters, but not both.
\itemize{
\item If you have one Lambda function that processes metadata and
another for reading the actual data, use the following syntax.
Both parameters are required.

\verb{metadata-function=<i>lambda_arn</i>, record-function=<i>lambda_arn</i> }
\item If you have a composite Lambda function that processes both
metadata and data, use the following syntax to specify your
Lambda function.

\verb{function=<i>lambda_arn</i> }
}
\item The \code{GLUE} type has no parameters.
}}
}
\description{
Updates the data catalog that has the specified name.
}
\section{Request syntax}{
\preformatted{svc$update_data_catalog(
  Name = "string",
  Type = "LAMBDA"|"GLUE"|"HIVE",
  Description = "string",
  Parameters = list(
    "string"
  )
)
}
}

\keyword{internal}
