# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' Managed Streaming for Kafka
#'
#' 
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- kafka(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- kafka()
#' svc$create_cluster(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=kafka_create_cluster]{create_cluster} \tab Creates a new MSK cluster \cr
#'  \link[=kafka_create_configuration]{create_configuration} \tab Creates a new MSK configuration \cr
#'  \link[=kafka_delete_cluster]{delete_cluster} \tab Deletes the MSK cluster specified by the Amazon Resource Name (ARN) in the request \cr
#'  \link[=kafka_describe_cluster]{describe_cluster} \tab Returns a description of the MSK cluster whose Amazon Resource Name (ARN) is specified in the request\cr
#'  \link[=kafka_describe_cluster_operation]{describe_cluster_operation} \tab Returns a description of the cluster operation specified by the ARN \cr
#'  \link[=kafka_describe_configuration]{describe_configuration} \tab Returns a description of this MSK configuration \cr
#'  \link[=kafka_describe_configuration_revision]{describe_configuration_revision} \tab Returns a description of this revision of the configuration \cr
#'  \link[=kafka_get_bootstrap_brokers]{get_bootstrap_brokers} \tab A list of brokers that a client application can use to bootstrap \cr
#'  \link[=kafka_list_cluster_operations]{list_cluster_operations} \tab Returns a list of all the operations that have been performed on the specified MSK cluster \cr
#'  \link[=kafka_list_clusters]{list_clusters} \tab Returns a list of all the MSK clusters in the current Region \cr
#'  \link[=kafka_list_configuration_revisions]{list_configuration_revisions} \tab Returns a list of all the MSK configurations in this Region \cr
#'  \link[=kafka_list_configurations]{list_configurations} \tab Returns a list of all the MSK configurations in this Region \cr
#'  \link[=kafka_list_nodes]{list_nodes} \tab Returns a list of the broker nodes in the cluster \cr
#'  \link[=kafka_list_tags_for_resource]{list_tags_for_resource} \tab Returns a list of the tags associated with the specified resource \cr
#'  \link[=kafka_tag_resource]{tag_resource} \tab Adds tags to the specified MSK resource \cr
#'  \link[=kafka_untag_resource]{untag_resource} \tab Removes the tags associated with the keys that are provided in the query \cr
#'  \link[=kafka_update_broker_storage]{update_broker_storage} \tab Updates the EBS storage associated with MSK brokers \cr
#'  \link[=kafka_update_cluster_configuration]{update_cluster_configuration} \tab Updates the cluster with the configuration that is specified in the request body 
#' }
#'
#' @rdname kafka
#' @export
kafka <- function(config = list()) {
  svc <- .kafka$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.kafka <- list()

.kafka$operations <- list()

.kafka$metadata <- list(
  service_name = "kafka",
  endpoints = list("*" = list(endpoint = "kafka.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "kafka.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "Kafka",
  api_version = "2018-11-14",
  signing_name = "kafka",
  json_version = "1.1",
  target_prefix = ""
)

.kafka$handlers <- new_handlers("restjson", "v4")

.kafka$service <- function(config = list()) {
  new_service(.kafka$metadata, .kafka$handlers, config)
}
