% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalyticsv2_operations.R
\name{kinesisanalyticsv2_add_application_cloud_watch_logging_option}
\alias{kinesisanalyticsv2_add_application_cloud_watch_logging_option}
\title{Adds an Amazon CloudWatch log stream to monitor application
configuration errors}
\usage{
kinesisanalyticsv2_add_application_cloud_watch_logging_option(
  ApplicationName, CurrentApplicationVersionId, CloudWatchLoggingOption)
}
\arguments{
\item{ApplicationName}{[required] The Kinesis Data Analytics application name.}

\item{CurrentApplicationVersionId}{[required] The version ID of the Kinesis Data Analytics application. You can
retrieve the application version ID using
\code{\link[=kinesisanalyticsv2_describe_application]{describe_application}}.}

\item{CloudWatchLoggingOption}{[required] Provides the Amazon CloudWatch log stream Amazon Resource Name (ARN).}
}
\value{
A list with the following syntax:\preformatted{list(
  ApplicationARN = "string",
  ApplicationVersionId = 123,
  CloudWatchLoggingOptionDescriptions = list(
    list(
      CloudWatchLoggingOptionId = "string",
      LogStreamARN = "string",
      RoleARN = "string"
    )
  )
)
}
}
\description{
Adds an Amazon CloudWatch log stream to monitor application
configuration errors.
}
\section{Request syntax}{
\preformatted{svc$add_application_cloud_watch_logging_option(
  ApplicationName = "string",
  CurrentApplicationVersionId = 123,
  CloudWatchLoggingOption = list(
    LogStreamARN = "string"
  )
)
}
}

\keyword{internal}
