% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kinesisanalytics_operations.R
\name{kinesisanalytics_delete_application_cloud_watch_logging_option}
\alias{kinesisanalytics_delete_application_cloud_watch_logging_option}
\title{Deletes a CloudWatch log stream from an application}
\usage{
kinesisanalytics_delete_application_cloud_watch_logging_option(
  ApplicationName, CurrentApplicationVersionId, CloudWatchLoggingOptionId)
}
\arguments{
\item{ApplicationName}{[required] The Kinesis Analytics application name.}

\item{CurrentApplicationVersionId}{[required] The version ID of the Kinesis Analytics application.}

\item{CloudWatchLoggingOptionId}{[required] The \code{CloudWatchLoggingOptionId} of the CloudWatch logging option to
delete. You can get the \code{CloudWatchLoggingOptionId} by using the
DescribeApplication operation.}
}
\description{
Deletes a CloudWatch log stream from an application. For more
information about using CloudWatch log streams with Amazon Kinesis
Analytics applications, see \href{http://docs.aws.amazon.com/kinesisanalytics/latest/dev/cloudwatch-logs.html}{Working with Amazon CloudWatch Logs}.
}
\section{Request syntax}{
\preformatted{svc$delete_application_cloud_watch_logging_option(
  ApplicationName = "string",
  CurrentApplicationVersionId = 123,
  CloudWatchLoggingOptionId = "string"
)
}
}

\keyword{internal}
