% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/glue_operations.R
\name{glue_update_database}
\alias{glue_update_database}
\title{Updates an existing database definition in a Data Catalog}
\usage{
glue_update_database(CatalogId, Name, DatabaseInput)
}
\arguments{
\item{CatalogId}{The ID of the Data Catalog in which the metadata database resides. If
none is supplied, the AWS account ID is used by default.}

\item{Name}{[required] The name of the database to update in the catalog. For Hive
compatibility, this is folded to lowercase.}

\item{DatabaseInput}{[required] A \code{DatabaseInput} object specifying the new definition of the metadata
database in the catalog.}
}
\description{
Updates an existing database definition in a Data Catalog.
}
\section{Request syntax}{
\preformatted{svc$update_database(
  CatalogId = "string",
  Name = "string",
  DatabaseInput = list(
    Name = "string",
    Description = "string",
    LocationUri = "string",
    Parameters = list(
      "string"
    )
  )
)
}
}

\keyword{internal}
