% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/patternboxplot.R
\name{patternboxplot}
\alias{patternboxplot}
\title{Plot a boxplot using patterns and colors to fill the boxes.}
\usage{
patternboxplot(data, x, y, group = NULL, xlab = "", ylab = "",
  outlier.shape = 21, outlier.color = "black", outlier.size = 1,
  linetype = rep("solid", ifelse(is.null(group), length(unique(x)),
  length(unique(group)))), pattern.type, pattern.color = rep("black",
  ifelse(is.null(group), length(unique(x)), length(unique(group)))),
  pattern.line.size = 1, background.color = rep("white",
  ifelse(is.null(group), length(unique(x)), length(unique(group)))),
  frame.color = rep("black", ifelse(is.null(group), length(unique(x)),
  length(unique(group)))), frame.size = 1, pixel = 1, density = rep(7,
  ifelse(is.null(group), length(unique(x)), length(unique(group)))),
  legend.type = "h", legend.h = 6, legend.x.pos = 0.5,
  legend.y.pos = 0.5, legend.pixel = 0.3, label.size = 3.5,
  legend.ratio1 = 0.1)
}
\arguments{
\item{data}{the data to be used.}

\item{x}{the variable used on x axis.}

\item{y}{the variable used on y axis.}

\item{group}{the variable used as the second grouping variable on x axis.}

\item{xlab}{a character string to give x axis label.}

\item{ylab}{a character string to give y axis label.}

\item{outlier.shape}{the shape of outlier dots.}

\item{outlier.color}{the color of outlier dots.}

\item{outlier.size}{the size of outlier dots.}

\item{linetype}{the linetype for the borders of boxplots.}

\item{pattern.type}{a vector of patterns to be filled in the boxes 
There are 15 pattern types: 'blank', 'bricks', 'circles1','circles2', 'vdashes', 'hdashes',
'crosshatch','dots', 'grid','hlines','nelines', 'nwlines', 'shells', 'vlines', 'waves'.}

\item{pattern.color}{a vector of colors for the lines/dots of patterns.}

\item{pattern.line.size}{a numeric value, the line size for the lines/dots of patterns.}

\item{background.color}{a vector of colors to be filled in the boxes.}

\item{frame.color}{the color for the borders of boxes.}

\item{frame.size}{a numeric value, the line size for the borders of boxes.}

\item{pixel}{a numeric value, the pixel resolution of boxplot.}

\item{density}{a numeric vector, the density for the lines/dots of patterns.}

\item{legend.type}{if legend.type='h', the layout of legends is horizontal; if legend.type='v', the layout of legends is vertical.}

\item{legend.h}{a numeric value to change the height of legend boxes.}

\item{legend.x.pos}{a numeric value to change the position of legend text on x axis.}

\item{legend.y.pos}{a numeric value to change the position of legend text on y axis.}

\item{legend.pixel}{a numeric value to change the pixel of legends.}

\item{label.size}{the font size of labels shown above the boxplots.}

\item{legend.ratio1}{a numeric value to fine-tune the position of legend boxes on y axis.}
}
\value{
A ggplot object.
}
\description{
The \code{patternboxplot} function is a tool for creating versatile boxplots 
by filling the boxplots with colors and patterns.
}
\details{
\code{patternboxplot} function offers flexible ways in doing boxplots.
}
\examples{
library(patternplot)
library(jpeg)

Orange<-readJPEG(system.file("img", "oranges.jpg", package="patternplot"))
Strawberry <-readJPEG(system.file("img", "strawberries.jpg", package="patternplot"))
Watermelon<-readJPEG(system.file("img", "watermelons.jpg", package="patternplot"))

#Example 1
data <- read.csv(system.file("extdata", "fruits.csv", package="patternplot"))
x<-data$Fruit
y<-data$Weight
group<-data$Store
pattern.type<-list(Orange, Strawberry, Watermelon)
imageboxplot(data,x, y,group=NULL,pattern.type=pattern.type, 
             frame.color=c('orange', 'darkred', 'darkgreen'),ylab='Weight, Pounds')
}
\seealso{
Function \code{imageboxplot}
}
\author{
Chunqiao Luo (chunqiaoluo@gmail.com)
}
