% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotMatrix.R
\name{plotMatrix}
\alias{plotMatrix}
\title{Visualize Pattern Causality Matrix}
\usage{
plotMatrix(pcmatrix, status, method)
}
\arguments{
\item{pcmatrix}{A list containing three matrices (\code{positive}, \code{negative}, and \code{dark}) which represent the respective causality types for different items.}

\item{status}{A character string specifying which causality matrix to plot. Must be one of \code{"positive"}, \code{"negative"}, or \code{"dark"}.}

\item{method}{A character string specifying the visualization method for the plot. Options include \code{"circle"}, \code{"square"}, \code{"ellipse"}, \code{"number"}, \code{"shade"}, \code{"color"}, and \code{"pie"}.}
}
\value{
A visual plot of the selected causality matrix using the specified method. The plot provides a color-coded representation of the causality strengths between items.
}
\description{
The \code{plotMatrix} function generates a visual representation of a pattern causality matrix using different methods. It allows users to visualize the positive, negative, or dark causality effects in a specified matrix, providing insight into the relationships between items.
}
\examples{
\donttest{
data(climate_indices)
dataset <- climate_indices[,-1]
pcmatrix <- pcMatrix(dataset, E = 3, tau = 1, metric = "euclidean", h = 1, weighted = TRUE)
plotMatrix(pcmatrix, status = "positive", method = "color")
}
}
