% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/distanceMatrix.R
\name{distanceMatrix}
\alias{distanceMatrix}
\title{Compute Distance Matrix for an Embedded Matrix}
\usage{
distanceMatrix(M, metric)
}
\arguments{
\item{M}{Numeric matrix, the embedded state space matrix where each row represents a point in the reconstructed state space of a time series or any multidimensional data.}

\item{metric}{Character, the distance metric to be used for computing distances. Common metrics include "euclidean", "maximum", "manhattan", "canberra", "binary" or "minkowski".}
}
\value{
An object of class \code{dist}, representing the distance matrix of the embedded matrix \code{M}. This distance matrix can optionally be converted to a full matrix format if needed for subsequent analyses.
}
\description{
This function computes the distance matrix from a given embedded matrix, \code{M}, using a specified metric. The distance matrix is essential for exploring the underlying structure in complex systems by quantifying the distances between different points (or states) in the embedded space. This matrix can be crucial for further analysis like clustering, nearest neighbor searches, or causality inference in complex systems.
}
\examples{
# Assume M is an already constructed state space matrix of a time series
M <- matrix(rnorm(100), nrow = 10)
distanceMat <- distanceMatrix(M, "euclidean")
print(distanceMat) # Optionally convert to a full matrix for display
}
