% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/with_parameters.R
\name{with_parameters_test_that}
\alias{with_parameters_test_that}
\alias{cases}
\title{Execute a test with parameters.}
\usage{
with_parameters_test_that(desc_stub, code, .cases = NULL, ...)

cases(...)
}
\arguments{
\item{desc_stub}{A string scalar. Used in creating the names of the
parameterized tests.}

\item{code}{Test code containing expectations.}

\item{.cases}{A data frame where each row contains test parameters.}

\item{...}{Named arguments of test parameters.}
}
\description{
This function is an extension of \code{\link[testthat:test_that]{testthat::test_that()}} that lets you pass
a series of testing parameters. These values are substituted into your
regular testing code block, making it reusable and reducing duplication.
}
\details{
You have a couple of options for passing parameters to you test. You can
use named vectors/ lists. The function will assert that you have correct
lengths before proceeding to test execution. Alternatively you can used
a \code{data.frame} or list in combination with the splice unquote operator
\code{\link[rlang]{!!!}}. Last, you can use the constructor \code{cases()}, which
is similar to building a \code{data.frame} rowwise. If you manually build the
data frame, pass it in the \code{.cases} argument.

One parameter is noteworthy. If the user passes a character vector as
\code{test_name}, each instance is combined with \code{desc_stub} to create the
completed test name. Similarly, the named argument from \code{cases()} is combined
with \code{desc_stub} to create the parameterized test names.
}
\examples{
with_parameters_test_that("trigonometric functions match identities", {
    testthat::expect_equal(expr, numeric_value)
  },
  expr = c(sin(pi / 4), cos(pi / 4), tan(pi / 4)),
  numeric_value = c(1 / sqrt(2), 1 / sqrt(2), 1)
)

# Run the same test with the cases() constructor
with_parameters_test_that("trigonometric functions match identities", {
    testthat::expect_equal(expr, numeric_value)
  },
  cases(
    sin = list(expr = sin(pi / 4), numeric_value = 1 / sqrt(2)),
    cos = list(expr = cos(pi / 4), numeric_value = 1 / sqrt(2)),
    tan = list(expr = tan(pi / 4), numeric_value = 1)
  )
)
}
