% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analytical_functions.R
\name{calc_min_dist_box}
\alias{calc_min_dist_box}
\title{Calculate minimum distance to lateral and end walls in a box-shaped
experimental tunnel}
\usage{
calc_min_dist_box(obj_name)
}
\arguments{
\item{obj_name}{The input viewr object; a tibble or data.frame with attribute
\code{pathviewr_steps} that include \code{"viewr"} and
\code{treatments_added}.}
}
\value{
A tibble or data.frame with added variables for
\code{min_dist_pos}, \code{min_dist_neg}, and \code{min_dist_end},.
}
\description{
Calculate minimum distance to lateral and end walls in a box-shaped
experimental tunnel
}
\details{
\code{calc_min_dist_box()} assumes the subject locomotes facing
forward, therefore \code{min_dist_end} represents the minimum distance
between the subject and the end wall to which it is moving towards.
All outputs are in meters.
}
\examples{
## Import sample data from package
 flydra_data <-
 read_flydra_mat(system.file("extdata", "pathviewr_flydra_example_data.mat",
                               package = 'pathviewr'),
                               subject_name = "birdie_sanders")

   ## Process data up to and including insert_treatments()
  flydra_data_full <-
   flydra_data \%>\%
   redefine_tunnel_center(length_method = "middle",
                         height_method = "user-defined",
                         height_zero = 1.44) \%>\%
   select_x_percent(desired_percent = 50) \%>\%
   separate_trajectories(max_frame_gap = "autodetect") \%>\%
   get_full_trajectories(span = 0.95) \%>\%
   insert_treatments(tunnel_config = "box",
                    tunnel_length = 3,
                    tunnel_width = 1,
                    stim_param_lat_pos = 0.1,
                    stim_param_lat_neg = 0.1,
                    stim_param_end_pos = 0.3,
                    stim_param_end_neg = 0.3,
                    treatment = "lat10_end_30") \%>\%

   ## Now calculate the minimum distances to each wall
   calc_min_dist_box()

   ## See 3 new variables for calculations to lateral and end walls
   names(flydra_data_full)
}
\seealso{
Other visual perception functions: 
\code{\link{get_sf}()},
\code{\link{get_vis_angle}()}
}
\author{
Eric R. Press
}
\concept{visual perception functions}
